# toposens_sync

This package enables the use of multiple synchronized TS3 sensors alternately. It sets up a `SensorManager` on top of a group of `Sensor` objects and triggers them alternately.

It was developed and tested for ROS Melodic on Ubuntu 18.04 (Bionic) and ROS Kinetic on Ubuntu 16.04 (Xenial) using Toposens TS3 ultrasonic sensor.

## Usage

### Build

Find information on how to build the package in the README of the `toposens` metapackage.

### Enable Serial Port Permissions

Find information on how to setup the serial port permissions in the README of the `toposens_driver` package.

### Setup Launch File

Create a launch file with the following content (this is an example):

```xml
<launch>
  <arg name="ports" default="[/dev/ttyUSB0, /dev/ttyUSB1]"/>
  <arg name="frame_ids" default="[ts3_1, ts3_2]"/>

  <node pkg="toposens_sync" type="toposens_sync_node"
        name="ts_sync_node" output="screen">
    <rosparam param="ports" subst_value="true">$(arg ports)</rosparam>
    <rosparam param="frames" subst_value="true">$(arg frame_ids)</rosparam>
  </node>

  <node pkg="tf" type="static_transform_publisher" name="toposens_link_1"
        args="0 -0.10 0 0 0 0 1 toposens ts3_1 100" />
  <node pkg="tf" type="static_transform_publisher" name="toposens_link_2"
        args="0 0.10 0 0 0 0 1 toposens ts3_2 100" />

  <node pkg="toposens_pointcloud" type="toposens_pointcloud_node"
        name="ts_cloud_node" output="screen">
    <param name="target_frame" value="toposens" />
  </node>

  <node pkg="rviz" type="rviz" name="grid_visualization" output="screen"
        args="-d $(find toposens_pointcloud)/rviz/toposens_pointcloud.rviz" />
</launch>
```

The file can be broken down into the following parts:

```xml
<arg name="ports" default="[/dev/ttyUSB0, /dev/ttyUSB1]"/>
<arg name="frame_ids" default="[ts3_1, ts3_2]"/>
```

The terminal IDs ("ports") and frame IDs ("frame_ids") are defined as arrays. Both these arrays need to have the same size. Element [i] of "ports" is mapped to element [i] of "frame_ids".

```xml
<node pkg="toposens_sync" type="toposens_sync_node"
      name="ts_sync_node" output="screen">
  <rosparam param="ports" subst_value="true">$(arg ports)</rosparam>
  <rosparam param="frames" subst_value="true">$(arg frame_ids)</rosparam>
</node>
```

The ts_sync_node must be given the arrays of the terminal IDs and frame IDs as launch arguments. The ts_sync_node handles the alternating triggering of the sensors as well as the polling of their data stream.

```xml
<node pkg="tf" type="static_transform_publisher" name="toposens_link_1"
      args="0 -0.10 0 0 0 0 1 toposens ts3_1 100" />
<node pkg="tf" type="static_transform_publisher" name="toposens_link_2"
      args="0 0.10 0 0 0 0 1 toposens ts3_2 100" />
```

In order to set the transformation from the individual sensor frames (here: ts_1, ts_2) to the desired reference frame (here: toposens), static transform publishers are used. Fill in the correct tf parameters for your setup.

```xml
<node pkg="toposens_pointcloud" type="toposens_pointcloud_node"
      name="ts_cloud_node" output="screen">
  <param name="target_frame" value="toposens" />
</node>
```

The data that is accumulated from the two sensors can be translated into messages of type sensor_msgs/PointCloud2 via the ts_cloud_node. The name of the frame in which the pointcloud is published is given to the node as a launch argument.

```xml
<node pkg="rviz" type="rviz" name="grid_visualization" output="screen"
      args="-d $(find toposens_pointcloud)/rviz/toposens_pointcloud.rviz" />
```

In order to visualize the pointcloud, RViz is launched.

### Run

In order to visualize the data as `sensor_msgs/PointCloud2` messages, launch the `ts_sync_node` as well as the `ts_cloud_node` with the created launch file.

```bash
roslaunch toposens_sync toposens_sync.launch
```

The firmware parameters for each TS3 sensor can be adjusted independently through rqt_reconfigure (see README in `toposens_driver` package).

