#!/usr/bin/env roseus


(defun generate-gif-all-for-sample-ik-iks
    ()
  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-inverse-kinematics.l")
  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-inverse-kinematics-statics.l")

  (format t "~%~%## Sample (irteus sample robot)~%~%")
  (format t "Gif images are generated by [generate-gif.l](doc/generate-gif.l). Gif animation is not realtime (actually it is slower than gif animation).~%~%")

  (format t "### inverse-kinematics-optmotiongen~%~%")
  (format t "[sample-inverse-kinematics.l](./euslisp/sample/sample-inverse-kinematics.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-arm-reach-ik-raw"
         "sample-arm-reach-ik-raw-msc"
         "sample-arm-reach-ik"
         "sample-arm-reach-ik-obstacle"
         "sample-arm-reach-ik-posture"
         "sample-arm-reach-ik-with-root-virtual-joint"
         "sample-arm-reach-ik-face"
         "sample-arm-reach-ik-line"
         "sample-robot-reach-ik-raw"
         (list "sample-robot-reach-ik-raw :set-posture-joint? t :look-at? t"
               "sample-robot-reach-ik-raw-with-set-posture-look-at")
         "sample-robot-reach-ik"
         "sample-robot-reach-ik-limb"
         "sample-robot-reach-ik-dual-arm"
         "sample-robot-reach-ik-dual-arm-with-torso"
         "sample-robot-reach-ik-fullbody"
         ))

  (format t "### inverse-kinematics-trajectory-optmotiongen~%~%")
  (format t "[sample-inverse-kinematics.l](./euslisp/sample/sample-inverse-kinematics.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-arm-reach-trajectory-ik-raw"
         "sample-arm-reach-trajectory-ik"
         "sample-arm-reach-trajectory-ik-with-root-virtual-joint"
         "sample-arm-reach-trajectory-ik-with-root-virtual-joint-obstacle"
         "sample-robot-reach-trajectory-ik-dual-arm-with-torso"
         "sample-robot-reach-trajectory-ik-dual-arm-with-torso-no-mid-constraint"
         "sample-robot-reach-trajectory-ik-fullbody"
         ))

  (format t "### inverse-kinematics-statics-optmotiongen~%~%")
  (format t "[sample-inverse-kinematics-statics.l](./euslisp/sample/sample-inverse-kinematics-statics.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-robot-reach-iks-raw"
         (list "sample-robot-reach-iks :optimize-torque? nil" "sample-robot-reach-iks-without-torque")
         (list "sample-robot-reach-iks :optimize-torque? t" "sample-robot-reach-iks")
         (list "sample-robot-reach-iks-face :optimize-torque? nil" "sample-robot-reach-iks-face-without-torque")
         (list "sample-robot-reach-iks-face :optimize-torque? t" "sample-robot-reach-iks-face")
         ))

  (format t "### inverse-kinematics-statics-trajectory-optmotiongen~%~%")
  (format t "[sample-inverse-kinematics-statics.l](./euslisp/sample/sample-inverse-kinematics-statics.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-robot-reach-trajectory-iks-raw"
         (list "sample-robot-reach-trajectory-iks :optimize-start-end-torque? nil" "sample-robot-reach-trajectory-iks-without-torque")
         (list "sample-robot-reach-trajectory-iks :optimize-start-end-torque? t" "sample-robot-reach-trajectory-iks")
         (list "sample-robot-reach-trajectory-iks-face :optimize-start-end-torque? nil" "sample-robot-reach-trajectory-iks-face-without-torque")
         (list "sample-robot-reach-trajectory-iks-face :optimize-start-end-torque? t" "sample-robot-reach-trajectory-iks-face")
         ))
  )
(warn "(generate-gif-all-for-sample-ik-iks)~%")

(defun generate-gif-all-for-sample-samplerobot
    ()
  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-samplerobot.l")

  (format t "### sample-robot-sqp-instant-manip-config-task~%~%")
  (format t "[sample-samplerobot.l](./euslisp/sample/sample-samplerobot.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "sample-robot-sqp-instant-manip-config-task :fix-obj? nil :optimize-torque? nil"
               "sample-robot-sqp-instant-manip-config-task-without-torque")
         (list "sample-robot-sqp-instant-manip-config-task :fix-obj? t :optimize-torque? nil"
               "sample-robot-sqp-instant-manip-config-task-fix-obj-without-torque")
         (list "sample-robot-sqp-instant-manip-config-task :fix-obj? nil :optimize-torque? t"
               "sample-robot-sqp-instant-manip-config-task")
         (list "sample-robot-sqp-instant-manip-config-task :fix-obj? t :optimize-torque? t"
               "sample-robot-sqp-instant-manip-config-task-fix-obj")
         ))

  (format t "### sample-arm-sqp-bspline-config-task~%~%")
  (format t "[sample-samplerobot.l](./euslisp/sample/sample-samplerobot.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-arm-sqp-bspline-config-task"
         ))

  (format t "### sample-robot-sqp-bspline-dynamic-config-task~%~%")
  (format t "[sample-samplerobot.l](./euslisp/sample/sample-samplerobot.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-robot-sqp-bspline-dynamic-config-task"
         )
   :look-all? nil
   )
  )
(warn "(generate-gif-all-for-sample-samplerobot)~%")

(defun generate-gif-all-for-sample-hrp2
    ()
  (format t "~%~%## Sample (HRP2)~%~%")

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-optimization-instant.l")
  (format t "### instant-configuration-task~%~%")
  (format t "[sample-sqp-optimization-instant.l](./euslisp/sample/sample-sqp-optimization-instant.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "sample-sqp-optimization-instant :optimize-torque? t" "sample-sqp-optimization-instant")
         (list "sample-sqp-optimization-instant :optimize-torque? nil" "sample-sqp-optimization-instant-without-torque")
         (list "sample-sqp-optimization-instant :only-kinematics? t" "sample-sqp-optimization-instant-only-kinematics")
         ))

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-optimization-trajectory.l")
  (format t "### trajectory-configuration-task~%~%")
  (format t "[sample-sqp-optimization-trajectory.l](./euslisp/sample/sample-sqp-optimization-trajectory.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "sample-sqp-optimization-trajectory :optimize-start-end-torque? t" "sample-sqp-optimization-trajectory")
         (list "sample-sqp-optimization-trajectory :optimize-start-end-torque? nil" "sample-sqp-optimization-trajectory-without-torque")
         ))

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-optimization-instant-manip.l")
  (format t "### instant-manip-configuration-task~%~%")
  (format t "[sample-sqp-optimization-instant-manip.l](./euslisp/sample/sample-sqp-optimization-instant-manip.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "sample-sqp-optimization-instant-manip :optimize-torque? t" "sample-sqp-optimization-instant-manip")
         (list "sample-sqp-optimization-instant-manip :optimize-torque? nil" "sample-sqp-optimization-instant-manip-without-torque")
         ))

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-optimization-trajectory-manip.l")
  (format t "### trajectory-manip-configuration-task~%~%")
  (format t "[sample-sqp-optimization-trajectory-manip.l](./euslisp/sample/sample-sqp-optimization-trajectory-manip.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "sample-sqp-optimization-trajectory-manip :optimize-start-end-torque? t" "sample-sqp-optimization-trajectory-manip")
         (list "sample-sqp-optimization-trajectory-manip :optimize-start-end-torque? nil" "sample-sqp-optimization-trajectory-manip-without-torque")
         ))

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-optimization-bspline.l")
  (format t "### bspline-configuration-task~%~%")
  (format t "[sample-sqp-optimization-bspline.l](./euslisp/sample/sample-sqp-optimization-bspline.l)~%~%")
  (format t "[graph of joint trajectory](./logs/sample-sqp-optimization-bspline.pdf)~%")
  (generate-gif
   :func-name-list
   (list "sample-sqp-optimization-bspline"
         ))

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-msc-optimization-instant.l")
  (format t "### instant-configuration-task with sqp-msc~%~%")
  (format t "[sample-sqp-msc-optimization-instant.l](./euslisp/sample/sample-sqp-msc-optimization-instant.l)~%~%")
  (generate-gif
   :func-name-list
   (list ;; (list "sample-sqp-msc-optimization-instant :optimize-torque? t" "sample-sqp-msc-optimization-instant")
         (list "sample-sqp-msc-optimization-instant :optimize-torque? nil" "sample-sqp-msc-optimization-instant-without-torque")
         (list "sample-sqp-msc-optimization-instant :only-kinematics? t" "sample-sqp-msc-optimization-instant-only-kinematics")
         ))

  (require "package://eus_qp/optmotiongen/euslisp/sample/sample-sqp-optimization-bspline-dynamic.l")
  (format t "### sample-sqp-optimization-bspline-dynamic~%~%")
  (format t "[sample-sqp-optimization-bspline-dynamic.l](./euslisp/sample/sample-sqp-optimization-bspline-dynamic.l)~%~%")
  (generate-gif
   :func-name-list
   (list "sample-sqp-optimization-bspline-dynamic"
         ))
  )
(warn "(generate-gif-all-for-sample-hrp2)~%")

(defun generate-gif-all-for-demo-humanoid
    ()
  (format t "~%~%## Demo~%~%")

  (require "package://eus_qp/optmotiongen/euslisp/demo/demo-hrp2jsknts-desk-reach-instant.l")
  (format t "### demo-hrp2jsknts-desk-reach-instant~%~%")
  (format t "[demo-hrp2jsknts-desk-reach-instant.l](./euslisp/demo/demo-hrp2jsknts-desk-reach-instant.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "demo-hrp2jsknts-desk-reach-instant :use-thumb-contact? t :optimize-torque? t" "demo-hrp2jsknts-desk-reach-instant")
         (list "demo-hrp2jsknts-desk-reach-instant :use-thumb-contact? t :optimize-torque? nil" "demo-hrp2jsknts-desk-reach-instant-without-torque")
         ))

  (require "package://eus_qp/optmotiongen/euslisp/demo/demo-hrp2jsknts-desk-reach-trajectory.l")
  (format t "### demo-hrp2jsknts-desk-reach-trajectory~%~%")
  (format t "[demo-hrp2jsknts-desk-reach-trajectory.l](./euslisp/demo/demo-hrp2jsknts-desk-reach-trajectory.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "demo-hrp2jsknts-desk-reach-trajectory :use-thumb-contact? t :optimize-torque-only-key-pose? t" "demo-hrp2jsknts-desk-reach-trajectory")
         (list "demo-hrp2jsknts-desk-reach-trajectory :use-thumb-contact? t :optimize-torque-only-key-pose? nil" "demo-hrp2jsknts-desk-reach-trajectory-without-torque")
         ))

  ;; (require "package://eus_qp/optmotiongen/euslisp/demo/demo-rhp4b-step-block-terrain.l")
  ;; (format t "### demo-rhp4b-step-block-terrain-trajectory~%~%")
  ;; (format t "[demo-rhp4b-step-block-terrain.l](./euslisp/demo/demo-rhp4b-step-block-terrain.l)~%~%")
  ;; (generate-gif
  ;;  :func-name-list
  ;;  (list (list "demo-rhp4b-step-block-terrain-trajectory :optimize-torque? t" "demo-rhp4b-step-block-terrain-trajectory")
  ;;        (list "demo-rhp4b-step-block-terrain-trajectory :optimize-torque? nil" "demo-rhp4b-step-block-terrain-trajectory-without-torque")
  ;;        ))
  )
(warn "(generate-gif-all-for-demo-humanoid)~%")

(defun generate-gif-all-for-demo-pr2
    ()
  (require "package://eus_qp/optmotiongen/euslisp/demo/demo-pr2-regrasp-object.l")
  (format t "### demo-pr2-regrasp-object~%~%")
  (format t "[demo-pr2-regrasp-object.l](./euslisp/demo/demo-pr2-regrasp-object.l)~%~%")
  (generate-gif
   :func-name-list
   (list "demo-pr2-regrasp-object"
         ))
  )
(warn "(generate-gif-all-for-demo-pr2)~%")

(defun generate-gif-all-for-demo-fetch
    ()
  (require "package://eus_qp/optmotiongen/euslisp/demo/demo-fetch-elbow-stretch.l")
  (format t "### demo-fetch-elbow-stretch~%~%")
  (format t "[demo-fetch-elbow-stretch.l](./euslisp/demo/demo-fetch-elbow-stretch.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "demo-fetch-elbow-stretch" "demo-fetch-elbow-stretch-with-stretch")
         (list "demo-fetch-elbow-stretch :stretch-elbow nil" "demo-fetch-elbow-stretch-without-stretch")
         ))
  )
(warn "(generate-gif-all-for-demo-fetch)~%")

(defun generate-gif-all-for-demo-others
    ()
  (require "package://eus_qp/optmotiongen/euslisp/demo/demo-2d-body-trajectory.l")
  (format t "### demo-2d-body-trajectory~%~%")
  (format t "[demo-2d-body-trajectory.l](./euslisp/demo/demo-2d-body-trajectory.l)~%~%")
  (generate-gif
   :func-name-list
   (list (list "demo-2d-body-trajectory :num-of-solution-candidates 4" "demo-2d-body-trajectory-with-msc")
         (list "demo-2d-body-trajectory :num-of-solution-candidates 1" "demo-2d-body-trajectory-without-msc")
         ))
  )
(warn "(generate-gif-all-for-demo-others)~%")


(defun generate-gif
    (&key
     (func-name-list)
     (look-all? t)
     )
  (dolist (func-name func-name-list)
    (null-output
     (setq *gif-name* (if (consp func-name) (elt func-name 1) func-name))
     (eval (read-from-string
            (format nil "
(~a
 :pre-process-func
 #'(lambda (sqp)
     (when (= (send sqp :iteration) 1)
       (setup-gif-animation :look-all? ~a))
     (save-image-for-gif-animation)
     )
 :visualize-callback-func
 #'save-image-for-gif-animation
 :visualize-loop? nil
 :output-filename nil
 :graph-filename nil
 )
" (if (consp func-name) (elt func-name 0) func-name)
  look-all?
  )))
     (create-gif-animation :save-dir (ros::resolve-ros-path "package://eus_qp/optmotiongen/doc/images"))
    )
   (format t "###### ~a~%" *gif-name*)
   (format t "```~%(~a)~%```~%" (if (consp func-name) (elt func-name 0) func-name))
   (format t "![~a](doc/images/~a.gif)~%~%" *gif-name* *gif-name*)
   )
  )

(defun setup-gif-animation
    (&key
     (name *gif-name*)
     (look-all? t)
     (manual-adjust? nil)
     )
  (setq *gif-image-idx* 10000)
  (send *irtviewer* :resize 600 600)
  (when look-all?
    (send *irtviewer* :look-all))
  (send *irtviewer* :draw-objects)
  (when manual-adjust?
    (warning-message 1 "[gif] press Key if ready to start~%")
    (while t
      (x::window-main-one)
      (unix:usleep (* 100 1000))
      (when (kbhit)
        (return-from nil nil))
      )
    )
  (unix:system (format nil "rm -rf /tmp/eus_qp/optmotiongen/~a" name))
  (unix:system (format nil "mkdir -p /tmp/eus_qp/optmotiongen/~a/figs" name))
  (unix:usleep (* 100 1000))
  )

(defun save-image-for-gif-animation
    (&key
     (name *gif-name*)
     )
  (send *irtviewer* :viewer :viewsurface :write-to-image-file
        (format nil "/tmp/eus_qp/optmotiongen/~a/figs/~a.png" name *gif-image-idx*))
  (incf *gif-image-idx*)
  )

(defun create-gif-animation
    (&key
     (name *gif-name*)
     (save-dir "/tmp")
     )
  (let* ((gif-path
          (format nil "~a/~a.gif" save-dir name))
         )
    (warning-message 1 "[gif] saving gif animation file to ~a~%" gif-path)
    (unix:system
     (format nil "convert -delay 6 -loop 0 -fuzz 5% -layers Optimize /tmp/eus_qp/optmotiongen/~a/figs/*.png ~a" name gif-path))
    ))
