#include <iterator>
#include <memory>
#include <mrpt/core/safe_pointers.h>
#include <mrpt/maps/CColouredOctoMap.h>
#include <mrpt/maps/COctoMap.h>
#include <mrpt/maps/COctoMapBase.h>
#include <mrpt/maps/CPointsMap.h>
#include <mrpt/math/TPoint3D.h>
#include <mrpt/opengl/COctoMapVoxels.h>
#include <mrpt/opengl/CSetOfObjects.h>
#include <sstream> // __str__
#include <string>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <pybind11/stl.h>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*)
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>)
#endif

void bind_mrpt_core_safe_pointers_1(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // mrpt::non_copiable_ptr_basic file:mrpt/core/safe_pointers.h line:118
		pybind11::class_<mrpt::non_copiable_ptr_basic<void>, std::shared_ptr<mrpt::non_copiable_ptr_basic<void>>> cl(M("mrpt"), "non_copiable_ptr_basic_void_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::non_copiable_ptr_basic<void>(); } ) );
		cl.def( pybind11::init( [](mrpt::non_copiable_ptr_basic<void> const &o){ return new mrpt::non_copiable_ptr_basic<void>(o); } ) );
		cl.def( pybind11::init<const void *>(), pybind11::arg("p") );

		cl.def("assign", (struct mrpt::non_copiable_ptr_basic<void> & (mrpt::non_copiable_ptr_basic<void>::*)(void *)) &mrpt::non_copiable_ptr_basic<void>::operator=, "C++: mrpt::non_copiable_ptr_basic<void>::operator=(void *) --> struct mrpt::non_copiable_ptr_basic<void> &", pybind11::return_value_policy::automatic, pybind11::arg("p"));
		cl.def("assign", (struct mrpt::non_copiable_ptr_basic<void> & (mrpt::non_copiable_ptr_basic<void>::*)(const struct mrpt::non_copiable_ptr_basic<void> &)) &mrpt::non_copiable_ptr_basic<void>::operator=, "C++: mrpt::non_copiable_ptr_basic<void>::operator=(const struct mrpt::non_copiable_ptr_basic<void> &) --> struct mrpt::non_copiable_ptr_basic<void> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("set", (void (mrpt::non_copiable_ptr_basic<void>::*)(const void *)) &mrpt::non_copiable_ptr_basic<void>::set, "C++: mrpt::non_copiable_ptr_basic<void>::set(const void *) --> void", pybind11::arg("p"));
		cl.def("__eq__", (bool (mrpt::non_copiable_ptr_basic<void>::*)(const void *) const) &mrpt::non_copiable_ptr_basic<void>::operator==, "C++: mrpt::non_copiable_ptr_basic<void>::operator==(const void *) const --> bool", pybind11::arg("o"));
		cl.def("__eq__", (bool (mrpt::non_copiable_ptr_basic<void>::*)(const struct mrpt::non_copiable_ptr_basic<void> &) const) &mrpt::non_copiable_ptr_basic<void>::operator==, "C++: mrpt::non_copiable_ptr_basic<void>::operator==(const struct mrpt::non_copiable_ptr_basic<void> &) const --> bool", pybind11::arg("o"));
		cl.def("__ne__", (bool (mrpt::non_copiable_ptr_basic<void>::*)(const void *) const) &mrpt::non_copiable_ptr_basic<void>::operator!=, "C++: mrpt::non_copiable_ptr_basic<void>::operator!=(const void *) const --> bool", pybind11::arg("o"));
		cl.def("__ne__", (bool (mrpt::non_copiable_ptr_basic<void>::*)(const struct mrpt::non_copiable_ptr_basic<void> &) const) &mrpt::non_copiable_ptr_basic<void>::operator!=, "C++: mrpt::non_copiable_ptr_basic<void>::operator!=(const struct mrpt::non_copiable_ptr_basic<void> &) const --> bool", pybind11::arg("o"));
		cl.def("get", (void *& (mrpt::non_copiable_ptr_basic<void>::*)()) &mrpt::non_copiable_ptr_basic<void>::get, "C++: mrpt::non_copiable_ptr_basic<void>::get() --> void *&", pybind11::return_value_policy::automatic);
		cl.def("arrow", (void *& (mrpt::non_copiable_ptr_basic<void>::*)()) &mrpt::non_copiable_ptr_basic<void>::operator->, "C++: mrpt::non_copiable_ptr_basic<void>::operator->() --> void *&", pybind11::return_value_policy::automatic);
	}
	{ // mrpt::ignored_copy_ptr file:mrpt/core/safe_pointers.h line:231
		pybind11::class_<mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>, std::shared_ptr<mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>>> cl(M("mrpt"), "ignored_copy_ptr_mrpt_maps_COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>(); } ) );
		cl.def( pybind11::init( [](mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>> const &o){ return new mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>(o); } ) );
		cl.def( pybind11::init<const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *>(), pybind11::arg("p") );

		cl.def("assign", (struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > & (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *)) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator=(class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *) --> struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &", pybind11::return_value_policy::automatic, pybind11::arg("p"));
		cl.def("assign", (struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > & (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &)) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator=(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &) --> struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("set", (void (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *)) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::set, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::set(const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *) --> void", pybind11::arg("p"));
		cl.def("__eq__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator==, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator==(const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *) const --> bool", pybind11::arg("o"));
		cl.def("__eq__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator==, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator==(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &) const --> bool", pybind11::arg("o"));
		cl.def("__ne__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator!=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator!=(const class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *) const --> bool", pybind11::arg("o"));
		cl.def("__ne__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator!=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator!=(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> > &) const --> bool", pybind11::arg("o"));
		cl.def("get", (class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *& (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)()) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::get, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::get() --> class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *&", pybind11::return_value_policy::automatic);
		cl.def("arrow", (class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *& (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::*)()) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator->, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::ColorOcTree, octomap::ColorOcTreeNode>>::operator->() --> class mrpt::maps::COctoMapBase<class octomap::ColorOcTree, class octomap::ColorOcTreeNode> *&", pybind11::return_value_policy::automatic);
	}
	{ // mrpt::ignored_copy_ptr file:mrpt/core/safe_pointers.h line:231
		pybind11::class_<mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>, std::shared_ptr<mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>>> cl(M("mrpt"), "ignored_copy_ptr_mrpt_maps_COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>(); } ) );
		cl.def( pybind11::init( [](mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>> const &o){ return new mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>(o); } ) );
		cl.def( pybind11::init<const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *>(), pybind11::arg("p") );

		cl.def("assign", (struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > & (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *)) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator=(class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *) --> struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &", pybind11::return_value_policy::automatic, pybind11::arg("p"));
		cl.def("assign", (struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > & (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &)) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator=(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &) --> struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("set", (void (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *)) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::set, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::set(const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *) --> void", pybind11::arg("p"));
		cl.def("__eq__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator==, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator==(const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *) const --> bool", pybind11::arg("o"));
		cl.def("__eq__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator==, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator==(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &) const --> bool", pybind11::arg("o"));
		cl.def("__ne__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator!=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator!=(const class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *) const --> bool", pybind11::arg("o"));
		cl.def("__ne__", (bool (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &) const) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator!=, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator!=(const struct mrpt::ignored_copy_ptr<class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> > &) const --> bool", pybind11::arg("o"));
		cl.def("get", (class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *& (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)()) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::get, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::get() --> class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *&", pybind11::return_value_policy::automatic);
		cl.def("arrow", (class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *& (mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::*)()) &mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator->, "C++: mrpt::ignored_copy_ptr<mrpt::maps::COctoMapBase<octomap::OcTree, octomap::OcTreeNode>>::operator->() --> class mrpt::maps::COctoMapBase<class octomap::OcTree, class octomap::OcTreeNode> *&", pybind11::return_value_policy::automatic);
	}
}
