# OEM7 Driver Test
Scripts and files supporting automated testing of OEM7 driver.  
* Built-int Self Test (BIST):  
   Equivalent to ROS 'hz' test, verifying message rates under operational scenario.    
   It does not verify correctness of individual messages.  

* Integration Test:  
  Ensures correctness of ROS message generation, by verifying that the driver provides expected 'output' (ROS topics/messages) for  
  specific 'input' (OEM7 Receiver binary output stream).  


## Implementation
### Test Creation:
1. OEM7 Receiver binary output is captured manually in .gps files (e.g. "bestpos.gps").  
2. Driver is launched wth .gps files as 'canned' input (refer to "launch/oem7_gps_file.launch".  
3. Corresponding ROS topics/messages published by the driver are recorded in .bag files (e.g. "bestpos.bag").  
4. Correctness of ROS topics/messages vs. OEM7 Receiver output (e.g. GPS position) is verified manually,   
   by examining individual messages in the .bag vs corresponding OEM7 messages in the .gps file.   
   Since the .gps file contents are in 'Novatel Binary' format, they need to be converted to ASCII using standard NovAtel tools.  

### Test execution:
1. The .gps file is fed the driver, resulting in generation of ROS .bag file (e.g. .ros/bestpos-test.bag)  
2. The verified bag file (e.g. bestpos.bag) is compared with bag file generated by the test (e.g. .ros/bestpos-test.bag).  
3. The test passes when the contents of the two bag files are identical. For the purpose of this test, ROS header sequence number  
   and timestamp generated by "rosbag record" are ignored.


## Generation of .gps files
To capture receiver output, manually connect to the OEM7 receiver using a terminal program of your choice and manually send appropriate log and configuration commands.  
The generate good data, the receiver should be tracking and INS must be in 'ALIGNMENT_COMPLETE' state. (Issue 'SETINITAZIMUTH 90 5' for desk testing of INS-enabled receivers).  
&nbsp;
 
Below, OEM7 configuration and logs for each test are listed:  


### bestpos
```
SETINITAZIMUTH 90 5
LOG PSRDOP2B ONTIME 4
LOG BESTPOSB ONTIME 2
LOG BESTVELB ONTIME 2
LOG BESTUTMB ONTIME 2
LOG BESTGNSSPOSB ONTIME 2
LOG PPPPOSB ONTIME 2
LOG TERRASTARINFOB ONTIME 2
LOG TERRASTARSTATUSB ONTIME 2
LOG INSPVASB ONTIME 1
LOG INSPVAXB ONTIME 4
```


### align 
ALIGN-capable receiver is required.  
```
LOG HEADING2B ONNEW

```


### ins1
```
LOG INSCONFIGB ONCHANGED
LOG INSPVASB ONTIME 1
LOG CORRIMUSB ONTIME 1
LOG INSSTDEVB ONTIME 2

```

### ins2
```
LOG INSCONFIGB ONCHANGED
LOG INSPVASB ONTIME 1
LOG INSPVAXB ONTIME 1
LOG IMURATECORRIMUSB ONNEW
```

### time
```
LOG TIMEB ONTIME 1
```

### rxstatus
```
LOG RXSTATUSB ONTIME 1
```


