/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import jp.go.aist.rtm.RTC.NumberingPolicy;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.RtcDeleteFunc;
import jp.go.aist.rtm.RTC.RtcNewFunc;

public class FactoryGlobal<ABSTRACTCLASS, IDENTIFIER> {
    protected RtcNewFunc m_New = null;
    protected RtcDeleteFunc m_Delete = null;
    protected NumberingPolicy m_policy = null;
    private static String factory_global_mutex = new String();
    private static FactoryGlobal factory_global;
    protected HashMap<IDENTIFIER, FactoryEntry> m_creators = new HashMap();

    protected FactoryGlobal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryGlobal instance() {
        if (factory_global == null) {
            String string = factory_global_mutex;
            synchronized (string) {
                if (factory_global == null) {
                    try {
                        factory_global = new FactoryGlobal();
                    }
                    catch (Exception exception) {
                        factory_global = null;
                    }
                }
            }
        }
        return factory_global;
    }

    public boolean hasFactory(IDENTIFIER IDENTIFIER) {
        return this.m_creators.containsKey(IDENTIFIER);
    }

    public Set<IDENTIFIER> getIdentifiers() {
        return this.m_creators.keySet();
    }

    public ReturnCode addFactory(IDENTIFIER IDENTIFIER, ObjectCreator objectCreator, ObjectDestructor objectDestructor) {
        if (this.m_creators.containsKey(IDENTIFIER)) {
            return ReturnCode.ALREADY_EXISTS;
        }
        FactoryEntry factoryEntry = new FactoryEntry(objectCreator, objectDestructor);
        this.m_creators.put(IDENTIFIER, factoryEntry);
        return ReturnCode.FACTORY_OK;
    }

    public ReturnCode removeFactory(IDENTIFIER IDENTIFIER) {
        if (!this.m_creators.containsKey(IDENTIFIER)) {
            return ReturnCode.NOT_FOUND;
        }
        this.m_creators.remove(IDENTIFIER);
        return ReturnCode.FACTORY_OK;
    }

    public ABSTRACTCLASS createObject(IDENTIFIER IDENTIFIER) {
        if (!this.m_creators.containsKey(IDENTIFIER)) {
            return null;
        }
        return this.m_creators.get(IDENTIFIER).creator_.creator_();
    }

    public void deleteObject(IDENTIFIER IDENTIFIER, ABSTRACTCLASS ABSTRACTCLASS) {
        if (!this.m_creators.containsKey(IDENTIFIER)) {
            return;
        }
        this.m_creators.get(IDENTIFIER).destructor_.destructor_(ABSTRACTCLASS);
    }

    public void deleteObject(ABSTRACTCLASS ABSTRACTCLASS) {
        Iterator<IDENTIFIER> iterator = this.m_creators.keySet().iterator();
        while (iterator.hasNext()) {
            this.m_creators.get(iterator.next()).destructor_.destructor_(ABSTRACTCLASS);
        }
    }

    public static enum ReturnCode {
        FACTORY_OK,
        FACTORY_ERROR,
        ALREADY_EXISTS,
        NOT_FOUND,
        INVALID_ARG,
        UNKNOWN_ERROR;

    }

    class FactoryEntry {
        public ObjectCreator<ABSTRACTCLASS> creator_;
        public ObjectDestructor destructor_;

        public FactoryEntry() {
        }

        public FactoryEntry(ObjectCreator objectCreator, ObjectDestructor objectDestructor) {
            this.creator_ = objectCreator;
            this.destructor_ = objectDestructor;
        }
    }
}

