/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.Vector;
import jp.go.aist.rtm.RTC.util.TimeValue;

public class TimeMeasure {
    private Vector<TimeValue> m_record = new Vector();
    private TimeValue m_begin = new TimeValue(0.0);
    private TimeValue m_interval = new TimeValue(0.0);
    private int m_count;
    private int m_countMax;
    private long m_cpuClock;
    private boolean m_recurred;

    public TimeMeasure(int n) {
        this.m_begin.convert(0.0);
        this.m_interval.convert(0.0);
        this.m_count = 0;
        this.m_countMax = n + 1;
        this.m_recurred = false;
        this.m_record.ensureCapacity(this.m_countMax);
        for (int i = 0; i < this.m_countMax; ++i) {
            this.m_record.add(new TimeValue(0L, 0L));
        }
    }

    public TimeMeasure() {
        int n = 100;
        this.m_begin.convert(0.0);
        this.m_interval.convert(0.0);
        this.m_count = 0;
        this.m_countMax = n + 1;
        this.m_recurred = false;
        this.m_record.ensureCapacity(this.m_countMax);
        for (int i = 0; i < this.m_countMax; ++i) {
            this.m_record.add(new TimeValue(0L, 0L));
        }
    }

    public void tick() {
        double d = System.currentTimeMillis();
        this.m_begin.convert(d / 1000.0);
    }

    public void tack() {
        if (this.m_begin.sec() == 0L) {
            return;
        }
        double d = System.currentTimeMillis();
        this.m_interval.convert(d / 1000.0 - this.m_begin.toDouble());
        this.m_record.set(this.m_count, this.m_interval);
        ++this.m_count;
        if (this.m_count == this.m_countMax) {
            this.m_count = 0;
            this.m_recurred = true;
        }
    }

    public TimeValue interval() {
        return this.m_interval;
    }

    public void reset() {
        this.m_count = 0;
        this.m_recurred = false;
        this.m_begin.convert(0.0);
    }

    public int count() {
        return this.m_recurred ? this.m_record.size() : this.m_count;
    }

    public boolean getStatistics(Statistics statistics) {
        double d;
        int n;
        statistics.max_interval = 0.0;
        statistics.min_interval = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this.count();
        if (n2 == 0) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            d = this.m_record.get(n).toDouble();
            d2 += d;
            if (d > statistics.max_interval) {
                statistics.max_interval = d;
            }
            if (!(d < statistics.min_interval)) continue;
            statistics.min_interval = d;
        }
        statistics.mean_interval = d2 / (double)n2;
        for (n = 0; n < n2; ++n) {
            d = this.m_record.get(n).toDouble();
            d3 += (d - statistics.mean_interval) * (d - statistics.mean_interval);
        }
        statistics.std_deviation = Math.sqrt(d3 / (double)n2);
        return true;
    }

    public Statistics getStatistics() {
        Statistics statistics = new Statistics();
        this.getStatistics(statistics);
        return statistics;
    }

    public Statistics createStatistics() {
        Statistics statistics = new Statistics();
        return statistics;
    }

    public class Statistics {
        public double max_interval = 0.0;
        public double min_interval = 0.0;
        public double mean_interval = 0.0;
        public double std_deviation = 0.0;
    }
}

