/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.buffer;

import java.util.Vector;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.buffer.ReturnCode;
import jp.go.aist.rtm.RTC.util.DataRef;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import jp.go.aist.rtm.RTC.util.TimeValue;

public class RingBuffer<DataType>
implements BufferBase<DataType> {
    private static final int RINGBUFFER_DEFAULT_LENGTH = 8;
    private boolean m_overwrite;
    private boolean m_readback;
    private boolean m_timedwrite;
    private boolean m_timedread;
    private TimeValue m_wtimeout;
    private TimeValue m_rtimeout;
    private int m_length;
    private int m_oldPtr;
    private int m_newPtr;
    private Vector<DataType> m_buffer;
    private int m_wpos;
    private int m_rpos;
    private int m_fillcount;
    private static String m_posmutex = new String();
    private condition m_empty = new condition();
    private condition m_full = new condition();

    public RingBuffer() {
        this(8);
    }

    public RingBuffer(int n) {
        this.m_length = n < 2 ? 2 : n;
        this.m_oldPtr = 0;
        this.m_newPtr = n < 2 ? 1 : n - 1;
        this.m_buffer = new Vector(this.m_length);
        this.m_buffer.setSize(this.m_length);
        this.m_overwrite = true;
        this.m_readback = true;
        this.m_timedwrite = false;
        this.m_timedread = false;
        this.m_wtimeout = new TimeValue(1.0);
        this.m_rtimeout = new TimeValue(1.0);
        this.m_wpos = 0;
        this.m_rpos = 0;
        this.m_fillcount = 0;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int length() {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_length;
        }
    }

    @Override
    public ReturnCode length(int n) {
        this.m_buffer.setSize(n);
        this.m_length = n;
        this.reset();
        return ReturnCode.BUFFER_OK;
    }

    @Override
    public ReturnCode write(DataType DataType) {
        return this.write(DataType, -1, 0);
    }

    public ReturnCode write(DataType DataType, int n) {
        return this.write(DataType, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode write(DataType DataType, int n, int n2) {
        String string = this.m_full.mutex;
        synchronized (string) {
            boolean bl;
            if (this.full()) {
                bl = this.m_timedwrite;
                boolean bl2 = this.m_overwrite;
                if (n >= 0) {
                    bl = true;
                    bl2 = false;
                }
                if (bl2 && !bl) {
                    this.advanceRptr();
                } else {
                    if (!bl2 && !bl) {
                        return ReturnCode.BUFFER_FULL;
                    }
                    if (!bl2 && bl) {
                        if (n < 0) {
                            n = (int)(this.m_rtimeout.sec() * 1000L + this.m_rtimeout.usec() / 1000L);
                            n2 = (int)(this.m_rtimeout.usec() % 1000L) * 1000;
                        }
                        try {
                            if (n == 0 && n2 == 0) {
                                return ReturnCode.TIMEOUT;
                            }
                            this.m_full.mutex.wait(n, n2);
                            return ReturnCode.TIMEOUT;
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException.toString());
                        }
                        catch (IllegalMonitorStateException illegalMonitorStateException) {
                            throw new RuntimeException(illegalMonitorStateException.toString());
                        }
                    }
                    return ReturnCode.PRECONDITION_NOT_MET;
                }
            }
            bl = this.empty();
            this.put(DataType);
            if (bl) {
                String string2 = this.m_empty.mutex;
                synchronized (string2) {
                    try {
                        this.m_empty.mutex.notify();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                }
            }
            this.advanceWptr(1);
            return ReturnCode.BUFFER_OK;
        }
    }

    @Override
    public ReturnCode read(DataRef<DataType> dataRef) {
        return this.read(dataRef, -1, 0);
    }

    public ReturnCode read(DataRef<DataType> dataRef, int n) {
        return this.read(dataRef, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode read(DataRef<DataType> dataRef, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        String string = this.m_empty.mutex;
        synchronized (string) {
            boolean bl;
            block20: {
                if (this.empty()) {
                    bl = this.m_timedread;
                    boolean bl2 = this.m_readback;
                    if (n >= 0) {
                        bl = true;
                        bl2 = false;
                        l = this.m_rtimeout.sec() * 1000L + this.m_rtimeout.usec() / 1000L;
                        n3 = (int)(this.m_rtimeout.usec() % 1000L) * 1000;
                    }
                    if (bl2 && !bl) {
                        this.advanceRptr(-1);
                    } else {
                        if (!bl2 && !bl) {
                            return ReturnCode.BUFFER_EMPTY;
                        }
                        if (!bl2 && bl) {
                            try {
                                this.m_empty.mutex.wait(l, n3);
                                if (this.empty()) {
                                    return ReturnCode.TIMEOUT;
                                }
                                break block20;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new RuntimeException(illegalArgumentException.toString());
                            }
                            catch (IllegalMonitorStateException illegalMonitorStateException) {
                                throw new RuntimeException(illegalMonitorStateException.toString());
                            }
                            catch (InterruptedException interruptedException) {
                                throw new RuntimeException(interruptedException.toString());
                            }
                        }
                        return ReturnCode.PRECONDITION_NOT_MET;
                    }
                }
            }
            bl = this.full();
            this.get(dataRef);
            this.advanceRptr();
            if (bl) {
                String string2 = this.m_full.mutex;
                synchronized (string2) {
                    try {
                        this.m_full.mutex.notify();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                }
            }
            return ReturnCode.BUFFER_OK;
        }
    }

    public boolean isFull() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode put(DataType DataType) {
        String string = m_posmutex;
        synchronized (string) {
            this.m_buffer.set(this.m_wpos, DataType);
            return ReturnCode.BUFFER_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType get() {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_buffer.get(this.m_rpos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode get(DataRef<DataType> dataRef) {
        String string = m_posmutex;
        synchronized (string) {
            dataRef.v = this.m_buffer.get(this.m_rpos);
            return ReturnCode.BUFFER_OK;
        }
    }

    @Override
    public void init(Properties properties) {
        this.initLength(properties);
        this.initWritePolicy(properties);
        this.initReadPolicy(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode reset() {
        String string = m_posmutex;
        synchronized (string) {
            this.m_fillcount = 0;
            this.m_wpos = 0;
            this.m_rpos = 0;
            return ReturnCode.BUFFER_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType wptr(int n) {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_buffer.get((this.m_wpos + n + this.m_length) % this.m_length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType wptr() {
        int n = 0;
        String string = m_posmutex;
        synchronized (string) {
            return this.m_buffer.get((this.m_wpos + n + this.m_length) % this.m_length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode advanceWptr(int n) {
        if (n > 0 && n > this.m_length - this.m_fillcount || n < 0 && n < -this.m_fillcount) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        String string = m_posmutex;
        synchronized (string) {
            this.m_wpos = (this.m_wpos + n + this.m_length) % this.m_length;
            this.m_fillcount += n;
            return ReturnCode.BUFFER_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode advanceWptr() {
        int n = 1;
        if (n > 0 && n > this.m_length - this.m_fillcount || n < 0 && n < -this.m_fillcount) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        String string = m_posmutex;
        synchronized (string) {
            this.m_wpos = (this.m_wpos + n + this.m_length) % this.m_length;
            this.m_fillcount += n;
            return ReturnCode.BUFFER_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writable() {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_length - this.m_fillcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean full() {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_length == this.m_fillcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType rptr(int n) {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_buffer.get((this.m_rpos + n + this.m_length) % this.m_length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType rptr() {
        int n = 0;
        String string = m_posmutex;
        synchronized (string) {
            return this.m_buffer.get((this.m_rpos + n + this.m_length) % this.m_length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode advanceRptr(int n) {
        if (n > 0 && n > this.m_fillcount || n < 0 && n < this.m_fillcount - this.m_length) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        String string = m_posmutex;
        synchronized (string) {
            this.m_rpos = (this.m_rpos + n + this.m_length) % this.m_length;
            this.m_fillcount -= n;
            return ReturnCode.BUFFER_OK;
        }
    }

    @Override
    public ReturnCode advanceRptr() {
        return this.advanceRptr(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readable() {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_fillcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean empty() {
        String string = m_posmutex;
        synchronized (string) {
            return this.m_fillcount == 0;
        }
    }

    private void initLength(Properties properties) {
        if (properties.getProperty("length") != "") {
            try {
                int n = Integer.parseInt(properties.getProperty("length"));
                if (n > 0) {
                    this.length(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initWritePolicy(Properties properties) {
        String string = properties.getProperty("write.full_policy");
        if ((string = StringUtil.normalize(string)).equals("overwrite")) {
            this.m_overwrite = true;
            this.m_timedwrite = false;
        } else if (string.equals("do_nothing")) {
            this.m_overwrite = false;
            this.m_timedwrite = false;
        } else if (string.equals("block")) {
            this.m_overwrite = false;
            this.m_timedwrite = true;
            try {
                double d = Double.parseDouble(properties.getProperty("write.timeout"));
                if (!(d < 0.0)) {
                    this.m_wtimeout.convert(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initReadPolicy(Properties properties) {
        String string = properties.getProperty("read.empty_policy");
        if ((string = StringUtil.normalize(string)).equals("readback")) {
            this.m_readback = true;
            this.m_timedread = false;
        } else if (string.equals("do_nothing")) {
            this.m_readback = false;
            this.m_timedread = false;
        } else if (string.equals("block")) {
            this.m_readback = false;
            this.m_timedread = true;
            try {
                double d = Double.parseDouble(properties.getProperty("read.timeout"));
                if (!(d < 0.0)) {
                    this.m_rtimeout.convert(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected class condition {
        public String mutex = new String();
    }
}

