/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.ConnectorProfileListHolder;
import RTC.PortInterfacePolarity;
import RTC.PortInterfaceProfile;
import RTC.PortInterfaceProfileListHolder;
import RTC.PortProfile;
import RTC.PortService;
import RTC.PortServiceHelper;
import RTC.PortServiceListHolder;
import RTC.PortServicePOA;
import RTC.RTObject;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import java.util.UUID;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectionCallback;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.ConnectorProfileFactory;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.PortProfileFactory;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import jp.go.aist.rtm.RTC.util.operatorFunc;
import org.omg.CORBA.SystemException;

public abstract class PortBase
extends PortServicePOA {
    protected PortProfile m_profile = new PortProfile();
    protected static String m_profile_mutex = new String();
    protected PortService m_objref;
    protected Logbuf rtcout;
    protected ConnectionCallback m_onPublishInterfaces;
    protected ConnectionCallback m_onSubscribeInterfaces;
    protected ConnectionCallback m_onConnected;
    protected ConnectionCallback m_onUnsubscribeInterfaces;
    protected ConnectionCallback m_onDisconnected;
    protected ConnectionCallback m_onConnectionLost;

    public PortBase(String string) {
        this.m_profile.name = string;
        this.m_profile.owner = null;
        this.m_profile.interfaces = new PortInterfaceProfile[0];
        this.m_profile.connector_profiles = new ConnectorProfile[0];
        this.m_profile.properties = new NameValue[0];
        this.m_profile.port_ref = this.m_objref = PortServiceHelper.narrow(this._this()._duplicate());
        this.rtcout = new Logbuf(string);
        this.rtcout.setLevel("PARANOID");
        this.m_onPublishInterfaces = null;
        this.m_onSubscribeInterfaces = null;
        this.m_onConnected = null;
        this.m_onUnsubscribeInterfaces = null;
        this.m_onDisconnected = null;
        this.m_onConnectionLost = null;
    }

    @Override
    public PortService _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = PortServiceHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.m_objref;
    }

    public PortBase() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortProfile get_port_profile() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            return PortProfileFactory.clone(this.m_profile);
        }
    }

    public final PortProfile getPortProfile() {
        return this.m_profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectorProfile[] get_connector_profiles() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            int n = this.m_profile.connector_profiles.length;
            ConnectorProfile[] connectorProfileArray = new ConnectorProfile[n];
            for (int i = 0; i < n; ++i) {
                connectorProfileArray[i] = this.m_profile.connector_profiles[i];
            }
            return connectorProfileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectorProfile get_connector_profile(String string) {
        this.rtcout.println(2, "get_connector_profile(" + string + ")");
        String string2 = m_profile_mutex;
        synchronized (string2) {
            ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
            int n = CORBA_SeqUtil.find(connectorProfileListHolder, (equalFunctor)new find_conn_id(string));
            if (n < 0) {
                ConnectorProfile connectorProfile = ConnectorProfileFactory.create();
                return connectorProfile;
            }
            ConnectorProfile connectorProfile = this.m_profile.connector_profiles[n];
            ConnectorProfile connectorProfile2 = new ConnectorProfile(connectorProfile.name, connectorProfile.connector_id, connectorProfile.ports, connectorProfile.properties);
            return connectorProfile2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t connect(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        this.rtcout.println(2, "connect()");
        if (this.isEmptyId(connectorProfileHolder.value)) {
            object = m_profile_mutex;
            synchronized (object) {
                this.setUUID(connectorProfileHolder);
                assert (!this.isExistingConnId(connectorProfileHolder.value.connector_id));
            }
        }
        object = m_profile_mutex;
        synchronized (object) {
            if (this.isExistingConnId(connectorProfileHolder.value.connector_id)) {
                this.rtcout.println(6, "Connection already exists.");
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
        }
        object = new NVListHolder(connectorProfileHolder.value.properties);
        Properties properties = new Properties();
        NVUtil.copyToProperties(properties, (NVListHolder)object);
        if (null != properties.findNode("dataport")) {
            CORBA_SeqUtil.push_back((NVListHolder)object, NVUtil.newNV("dataport.serializer.cdr.endian", "little,big"));
            connectorProfileHolder.value.properties = ((NVListHolder)object).value;
        }
        try {
            ReturnCode_t returnCode_t = connectorProfileHolder.value.ports[0].notify_connect(connectorProfileHolder);
            if (!returnCode_t.equals(ReturnCode_t.RTC_OK)) {
                this.rtcout.println(6, "Connection failed. cleanup.");
                this.disconnect(connectorProfileHolder.value.connector_id);
            }
            return returnCode_t;
        }
        catch (Exception exception) {
            return ReturnCode_t.BAD_PARAMETER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t notify_connect(ConnectorProfileHolder connectorProfileHolder) {
        int n;
        this.rtcout.println(2, "notify_connect()");
        ReturnCode_t[] returnCode_tArray = new ReturnCode_t[]{ReturnCode_t.RTC_OK, ReturnCode_t.RTC_OK, ReturnCode_t.RTC_OK};
        returnCode_tArray[0] = this.publishInterfaces(connectorProfileHolder);
        if (!ReturnCode_t.RTC_OK.equals(returnCode_tArray[0])) {
            this.rtcout.println(6, "publishInterfaces() in notify_connect() failed.");
        }
        if (this.m_onPublishInterfaces != null) {
            this.m_onPublishInterfaces.run(connectorProfileHolder);
        }
        returnCode_tArray[1] = this.connectNext(connectorProfileHolder);
        if (!ReturnCode_t.RTC_OK.equals(returnCode_tArray[1])) {
            this.rtcout.println(6, "connectNext() in notify_connect() failed.");
        }
        if (this.m_onSubscribeInterfaces != null) {
            this.m_onSubscribeInterfaces.run(connectorProfileHolder);
        }
        returnCode_tArray[2] = this.subscribeInterfaces(connectorProfileHolder);
        if (!ReturnCode_t.RTC_OK.equals(returnCode_tArray[2])) {
            this.rtcout.println(6, "subscribeInterfaces() in notify_connect() failed.");
        }
        this.rtcout.println(0, this.m_profile.connector_profiles.length + " connectors are existing.");
        String string = m_profile_mutex;
        synchronized (string) {
            n = this.findConnProfileIndex(connectorProfileHolder.value.connector_id);
            if (n < 0) {
                ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
                CORBA_SeqUtil.push_back(connectorProfileListHolder, connectorProfileHolder.value);
                this.m_profile.connector_profiles = connectorProfileListHolder.value;
                this.rtcout.println(0, "New connector_id. Push backed.");
            } else {
                this.m_profile.connector_profiles[n] = connectorProfileHolder.value;
                this.rtcout.println(0, "Existing connector_id. Updated.");
            }
        }
        n = returnCode_tArray.length;
        for (int i = 0; i < n; ++i) {
            if (ReturnCode_t.RTC_OK.equals(returnCode_tArray[i])) continue;
            return returnCode_tArray[i];
        }
        if (this.m_onConnected != null) {
            this.m_onConnected.run(connectorProfileHolder);
        }
        return ReturnCode_t.RTC_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t disconnect(String string) {
        ConnectorProfile connectorProfile;
        this.rtcout.println(2, "disconnect(" + string + ")");
        int n = this.findConnProfileIndex(string);
        if (n < 0) {
            this.rtcout.println(6, "Invalid connector id: " + string);
            return ReturnCode_t.BAD_PARAMETER;
        }
        String string2 = m_profile_mutex;
        synchronized (string2) {
            connectorProfile = this.m_profile.connector_profiles[n];
        }
        if (connectorProfile.ports.length < 1) {
            this.rtcout.println(7, "ConnectorProfile has empty port list.");
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        for (PortService portService : connectorProfile.ports) {
            try {
                return portService.notify_disconnect(string);
            }
            catch (SystemException systemException) {
                this.rtcout.println(5, "Exception caught: minor code(" + systemException.minor + ")." + systemException.toString());
            }
            catch (Exception exception) {
                this.rtcout.println(5, "Unknown exception caught.");
            }
        }
        this.rtcout.println(6, "notify_disconnect() for all ports failed.");
        return ReturnCode_t.RTC_ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t notify_disconnect(String string) {
        this.rtcout.println(2, "notify_disconnect(" + string + ")");
        String string2 = m_profile_mutex;
        synchronized (string2) {
            Object object;
            int n = this.findConnProfileIndex(string);
            if (n < 0) {
                this.rtcout.println(6, "Invalid connector id: " + string);
                return ReturnCode_t.BAD_PARAMETER;
            }
            ConnectorProfile connectorProfile = this.m_profile.connector_profiles[n];
            ReturnCode_t returnCode_t = this.disconnectNext(connectorProfile);
            if (this.m_onUnsubscribeInterfaces != null) {
                object = new ConnectorProfileHolder(connectorProfile);
                this.m_onUnsubscribeInterfaces.run((ConnectorProfileHolder)object);
                connectorProfile = object.value;
            }
            this.unsubscribeInterfaces(connectorProfile);
            if (this.m_onDisconnected != null) {
                object = new ConnectorProfileHolder(connectorProfile);
                this.m_onDisconnected.run((ConnectorProfileHolder)object);
                connectorProfile = object.value;
            }
            object = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
            CORBA_SeqUtil.erase((ConnectorProfileListHolder)object, n);
            this.m_profile.connector_profiles = ((ConnectorProfileListHolder)object).value;
            return returnCode_t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t disconnect_all() {
        this.rtcout.println(2, "disconnect_all()");
        ConnectorProfileListHolder connectorProfileListHolder = null;
        Object object = m_profile_mutex;
        synchronized (object) {
            connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        }
        object = ReturnCode_t.RTC_OK;
        int n = connectorProfileListHolder.value.length;
        this.rtcout.println(3, "disconnecting " + n + " connections.");
        for (int i = 0; i < n; ++i) {
            ReturnCode_t returnCode_t = this.disconnect(connectorProfileListHolder.value[i].connector_id);
            if (returnCode_t.equals(ReturnCode_t.RTC_OK)) continue;
            object = returnCode_t;
        }
        return object;
    }

    public abstract void activateInterfaces();

    public abstract void deactivateInterfaces();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            this.m_profile.name = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PortProfile getProfile() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            return this.m_profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortRef(PortService portService) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            this.m_profile.port_ref = portService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortService getPortRef() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            return this.m_profile.port_ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(RTObject rTObject) {
        this.rtcout.println(2, "setOwner()");
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            this.m_profile.owner = (RTObject)rTObject._duplicate();
        }
    }

    public void setOnPublishInterfaces(ConnectionCallback connectionCallback) {
        this.m_onPublishInterfaces = connectionCallback;
    }

    public void setOnSubscribeInterfaces(ConnectionCallback connectionCallback) {
        this.m_onSubscribeInterfaces = connectionCallback;
    }

    public void setOnConnected(ConnectionCallback connectionCallback) {
        this.m_onConnected = connectionCallback;
    }

    public void setOnUnsubscribeInterfaces(ConnectionCallback connectionCallback) {
        this.m_onUnsubscribeInterfaces = connectionCallback;
    }

    public void setOnDisconnected(ConnectionCallback connectionCallback) {
        this.m_onDisconnected = connectionCallback;
    }

    public void setOnConnectionLost(ConnectionCallback connectionCallback) {
        this.m_onConnectionLost = connectionCallback;
    }

    protected abstract ReturnCode_t publishInterfaces(ConnectorProfileHolder var1);

    protected ReturnCode_t connectNext(ConnectorProfileHolder connectorProfileHolder) {
        PortServiceListHolder portServiceListHolder = new PortServiceListHolder(connectorProfileHolder.value.ports);
        int n = CORBA_SeqUtil.find(portServiceListHolder, (equalFunctor)new find_port_ref(this.m_profile.port_ref));
        connectorProfileHolder.value.ports = portServiceListHolder.value;
        if (n < 0) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        if (++n < connectorProfileHolder.value.ports.length) {
            PortService portService = connectorProfileHolder.value.ports[n];
            ReturnCode_t returnCode_t = portService.notify_connect(connectorProfileHolder);
            return returnCode_t;
        }
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t disconnectNext(ConnectorProfile connectorProfile) {
        PortServiceListHolder portServiceListHolder = new PortServiceListHolder(connectorProfile.ports);
        int n = CORBA_SeqUtil.find(portServiceListHolder, (equalFunctor)new find_port_ref(this.m_profile.port_ref));
        connectorProfile.ports = portServiceListHolder.value;
        if (n < 0) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        if (n == connectorProfile.ports.length - 1) {
            return ReturnCode_t.RTC_OK;
        }
        int n2 = connectorProfile.ports.length;
        for (int i = ++n; i < n2; ++i) {
            PortService portService = connectorProfile.ports[i];
            try {
                return portService.notify_disconnect(connectorProfile.connector_id);
            }
            catch (SystemException systemException) {
                this.rtcout.println(5, "Exception caught: minor code." + systemException.minor);
                continue;
            }
            catch (Exception exception) {
                this.rtcout.println(5, "Unknown exception caught.");
            }
        }
        return ReturnCode_t.RTC_ERROR;
    }

    protected abstract ReturnCode_t subscribeInterfaces(ConnectorProfileHolder var1);

    protected abstract void unsubscribeInterfaces(ConnectorProfile var1);

    protected boolean isEmptyId(ConnectorProfile connectorProfile) {
        return connectorProfile.connector_id.length() == 0;
    }

    protected String getUUID() {
        return UUID.randomUUID().toString();
    }

    protected void setUUID(ConnectorProfileHolder connectorProfileHolder) {
        connectorProfileHolder.value.connector_id = this.getUUID();
        assert (connectorProfileHolder.value.connector_id.length() != 0);
    }

    protected boolean isExistingConnId(String string) {
        ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int n = CORBA_SeqUtil.find(connectorProfileListHolder, (equalFunctor)new find_conn_id(string));
        this.m_profile.connector_profiles = connectorProfileListHolder.value;
        return n >= 0;
    }

    protected ConnectorProfile findConnProfile(String string) {
        ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int n = CORBA_SeqUtil.find(connectorProfileListHolder, (equalFunctor)new find_conn_id(string));
        this.m_profile.connector_profiles = connectorProfileListHolder.value;
        if (n < 0) {
            return ConnectorProfileFactory.create();
        }
        return this.m_profile.connector_profiles[n];
    }

    protected int findConnProfileIndex(String string) {
        ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int n = CORBA_SeqUtil.find(connectorProfileListHolder, (equalFunctor)new find_conn_id(string));
        this.m_profile.connector_profiles = connectorProfileListHolder.value;
        return n;
    }

    protected void updateConnectorProfile(ConnectorProfile connectorProfile) {
        ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int n = CORBA_SeqUtil.find(connectorProfileListHolder, (equalFunctor)new find_conn_id(connectorProfile.connector_id));
        this.m_profile.connector_profiles = connectorProfileListHolder.value;
        if (n < 0) {
            CORBA_SeqUtil.push_back(connectorProfileListHolder, connectorProfile);
            this.m_profile.connector_profiles = connectorProfileListHolder.value;
        } else {
            this.m_profile.connector_profiles[n] = connectorProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean eraseConnectorProfile(String string) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            ConnectorProfileListHolder connectorProfileListHolder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
            int n = CORBA_SeqUtil.find(connectorProfileListHolder, (equalFunctor)new find_conn_id(string));
            this.m_profile.connector_profiles = connectorProfileListHolder.value;
            if (n < 0) {
                return false;
            }
            CORBA_SeqUtil.erase(connectorProfileListHolder, n);
            this.m_profile.connector_profiles = connectorProfileListHolder.value;
            return true;
        }
    }

    protected boolean appendInterface(String string, String string2, PortInterfacePolarity portInterfacePolarity) {
        PortInterfaceProfileListHolder portInterfaceProfileListHolder = new PortInterfaceProfileListHolder(this.m_profile.interfaces);
        int n = CORBA_SeqUtil.find(portInterfaceProfileListHolder, (equalFunctor)new find_interface(string, portInterfacePolarity));
        this.m_profile.interfaces = portInterfaceProfileListHolder.value;
        if (n >= 0) {
            return false;
        }
        PortInterfaceProfile portInterfaceProfile = new PortInterfaceProfile(string, string2, portInterfacePolarity);
        CORBA_SeqUtil.push_back(portInterfaceProfileListHolder, portInterfaceProfile);
        this.m_profile.interfaces = portInterfaceProfileListHolder.value;
        return true;
    }

    protected boolean deleteInterface(String string, PortInterfacePolarity portInterfacePolarity) {
        PortInterfaceProfileListHolder portInterfaceProfileListHolder = new PortInterfaceProfileListHolder(this.m_profile.interfaces);
        int n = CORBA_SeqUtil.find(portInterfaceProfileListHolder, (equalFunctor)new find_interface(string, portInterfacePolarity));
        this.m_profile.interfaces = portInterfaceProfileListHolder.value;
        if (n < 0) {
            return false;
        }
        CORBA_SeqUtil.erase(portInterfaceProfileListHolder, n);
        this.m_profile.interfaces = portInterfaceProfileListHolder.value;
        return true;
    }

    protected <T> void addProperty(String string, T t, Class<T> clazz) {
        NVListHolder nVListHolder = new NVListHolder(this.m_profile.properties);
        CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNV(string, t, clazz));
        this.m_profile.properties = nVListHolder.value;
    }

    protected void appendProperty(String string, String string2) {
        NVListHolder nVListHolder = new NVListHolder(this.m_profile.properties);
        NVUtil.appendStringValue(nVListHolder, string, string2);
        this.m_profile.properties = nVListHolder.value;
    }

    protected class find_interface
    implements equalFunctor {
        private String m_instance_name;
        private PortInterfacePolarity m_polarity;

        public find_interface(String string, PortInterfacePolarity portInterfacePolarity) {
            this.m_instance_name = string;
            this.m_polarity = portInterfacePolarity;
        }

        @Override
        public boolean equalof(Object object) {
            return this.equalof((PortInterfaceProfile)object);
        }

        public boolean equalof(PortInterfaceProfile portInterfaceProfile) {
            return this.m_instance_name.equals(portInterfaceProfile.instance_name) && this.m_polarity.equals(portInterfaceProfile.polarity);
        }
    }

    protected class disconnect_all_func
    implements operatorFunc {
        public ReturnCode_t m_return_code = ReturnCode_t.RTC_OK;
        public PortBase m_port;

        public disconnect_all_func(PortBase portBase2) {
            this.m_port = portBase2;
        }

        @Override
        public void operator(Object object) {
            this.operator((ConnectorProfile)object);
        }

        public void operator(ConnectorProfile connectorProfile) {
            ReturnCode_t returnCode_t = this.m_port.disconnect(connectorProfile.connector_id);
            if (!returnCode_t.equals(ReturnCode_t.RTC_OK)) {
                this.m_return_code = returnCode_t;
            }
        }
    }

    protected class disconnect_func
    implements operatorFunc {
        public PortService m_port_ref;
        public ConnectorProfileHolder m_connector_profile;
        public ReturnCode_t m_return_code;

        public disconnect_func() {
            this.m_return_code = ReturnCode_t.RTC_OK;
        }

        public disconnect_func(PortService portService, ConnectorProfileHolder connectorProfileHolder) {
            this.m_port_ref = portService;
            this.m_connector_profile = connectorProfileHolder;
            this.m_return_code = ReturnCode_t.RTC_OK;
        }

        @Override
        public void operator(Object object) {
            ReturnCode_t returnCode_t;
            if (!this.m_port_ref._is_equivalent((PortService)object) && !(returnCode_t = ((PortService)object).disconnect(this.m_connector_profile.value.connector_id)).equals(ReturnCode_t.RTC_OK)) {
                this.m_return_code = returnCode_t;
            }
        }
    }

    protected class connect_func
    implements operatorFunc {
        public PortService m_port_ref;
        public ConnectorProfileHolder m_connector_profile;
        public ReturnCode_t m_return_code;

        public connect_func() {
        }

        public connect_func(PortService portService, ConnectorProfileHolder connectorProfileHolder) {
            this.m_port_ref = portService;
            this.m_connector_profile = connectorProfileHolder;
            this.m_return_code = ReturnCode_t.RTC_OK;
        }

        @Override
        public void operator(Object object) {
            ReturnCode_t returnCode_t;
            if (!this.m_port_ref._is_equivalent((PortService)object) && !(returnCode_t = ((PortService)object).notify_connect(this.m_connector_profile)).equals(ReturnCode_t.RTC_OK)) {
                this.m_return_code = returnCode_t;
            }
        }
    }

    protected class find_port_ref
    implements equalFunctor {
        public PortService m_port;

        public find_port_ref(PortService portService) {
            this.m_port = portService;
        }

        @Override
        public boolean equalof(Object object) {
            return this.equalof((PortService)object);
        }

        public boolean equalof(PortService portService) {
            return this.m_port._is_equivalent(portService);
        }
    }

    protected class find_conn_id
    implements equalFunctor {
        public String m_connector_id;

        public find_conn_id(String string) {
            this.m_connector_id = string;
        }

        @Override
        public boolean equalof(Object object) {
            return this.equalof((ConnectorProfile)object);
        }

        public boolean equalof(ConnectorProfile connectorProfile) {
            return this.m_connector_id.endsWith(connectorProfile.connector_id);
        }
    }
}

