/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;
import jp.go.aist.rtm.RTC.util.Pair;
import jp.go.aist.rtm.RTC.util.StringUtil;

public class Properties {
    private String name;
    private String value;
    private String default_value;
    private Properties root;
    private Vector<Properties> leaf = new Vector();
    private static final String EMPTY = "";

    public Properties() {
        this(EMPTY, EMPTY);
    }

    public Properties(String string) {
        this(string, EMPTY);
    }

    public Properties(String string, String string2) {
        this.name = string;
        this.value = string2;
        this.default_value = EMPTY;
        this.root = null;
        this.leaf.clear();
    }

    public Properties(Map<String, String> map) {
        this.name = EMPTY;
        this.value = EMPTY;
        this.default_value = EMPTY;
        this.root = null;
        this.leaf.clear();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setDefault(entry.getKey(), entry.getValue());
        }
    }

    public Properties(String[] stringArray) {
        this.name = EMPTY;
        this.value = EMPTY;
        this.default_value = EMPTY;
        this.root = null;
        this.leaf.clear();
        this.setDefaults(stringArray);
    }

    public Properties(Properties properties) {
        this.name = properties.name;
        this.value = properties.value;
        this.default_value = properties.default_value;
        this.root = null;
        Vector<String> vector = properties.propertyNames();
        for (int i = 0; i < vector.size(); ++i) {
            Properties properties2 = properties.findNode(vector.get(i));
            if (properties2 == null) continue;
            this.setDefault(vector.get(i), properties2.default_value);
            this.setProperty(vector.get(i), properties2.value);
        }
    }

    public void substitute(Properties properties) {
        this.clear();
        this.name = properties.name;
        this.value = properties.value;
        this.default_value = properties.default_value;
        Vector<String> vector = properties.propertyNames();
        for (int i = 0; i < vector.size(); ++i) {
            Properties properties2 = properties.findNode(vector.get(i));
            if (properties2 == null) continue;
            this.setDefault(vector.get(i), properties2.default_value);
            this.setProperty(vector.get(i), properties2.value);
        }
    }

    public void destruct() {
        this.clear();
        if (this.root != null) {
            this.root.removeNode(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    public Vector<Properties> getLeaf() {
        return this.leaf;
    }

    public Properties getRoot() {
        return this.root;
    }

    public String getProperty(String string) {
        Vector<String> vector = new Vector<String>();
        this.split(string, '.', vector);
        Properties properties = this._getNode(vector, 0, this);
        if (properties != null) {
            return properties.value.length() > 0 ? properties.value : properties.default_value;
        }
        return EMPTY;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3.length() == 0 ? string2 : string3;
    }

    public String getDefault(String string) {
        Vector<String> vector = new Vector<String>();
        this.split(string, '.', vector);
        Properties properties = this._getNode(vector, 0, this);
        if (properties != null) {
            return properties.default_value;
        }
        return EMPTY;
    }

    public String setProperty(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        this.split(string, '.', vector);
        Properties properties = this;
        for (int i = 0; i < vector.size(); ++i) {
            Properties properties2 = properties.hasKey(vector.get(i));
            if (properties2 == null) {
                properties2 = new Properties(vector.get(i));
                properties2.root = properties;
                properties.leaf.add(properties2);
            }
            properties = properties2;
        }
        String string3 = properties.value.length() > 0 ? properties.value : properties.default_value;
        properties.value = string2;
        return string3;
    }

    public String setDefault(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        this.split(string, '.', vector);
        Properties properties = this;
        for (int i = 0; i < vector.size(); ++i) {
            Properties properties2 = properties.hasKey(vector.get(i));
            if (properties2 == null) {
                properties2 = new Properties(vector.get(i));
                properties2.root = properties;
                properties.leaf.add(properties2);
            }
            properties = properties2;
        }
        properties.default_value = string2;
        return string2;
    }

    public void setDefaults(String[] stringArray) {
        int n = 0;
        while (n + 1 < stringArray.length) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            string = string.trim();
            string2 = string2.trim();
            this.setDefault(string, string2);
            n += 2;
        }
    }

    public void list(OutputStream outputStream) {
        this._store(outputStream, EMPTY, this);
    }

    public void load(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = EMPTY;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || string.charAt(0) == '#' || string.charAt(0) == '!') continue;
            if (string.charAt(string.length() - 1) == '\\' && !StringUtil.isEscaped(string, string.length() - 1)) {
                string = string.substring(0, string.length() - 1);
                string2 = string2 + string;
                continue;
            }
            if ((string2 = string2 + string).length() == 0) continue;
            Pair<String, String> pair = this.splitKeyValue(string2);
            String string3 = pair.getKey();
            String string4 = pair.getValue();
            string3 = StringUtil.unescape(string3);
            string3 = string3.trim();
            string4 = StringUtil.unescape(string4);
            string4 = string4.trim();
            this.setProperty(string3, string4);
            string2 = EMPTY;
        }
    }

    public void save(OutputStream outputStream, String string) {
        this.store(outputStream, string);
    }

    public void store(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write("# ");
        printWriter.write(string);
        printWriter.println();
        printWriter.flush();
        this._store(outputStream, EMPTY, this);
    }

    public final Vector<String> propertyNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.leaf.size(); ++i) {
            this._propertyNames(vector, this.leaf.get((int)i).name, this.leaf.get(i));
        }
        return vector;
    }

    public final int size() {
        return this.propertyNames().size();
    }

    public final Properties findNode(String string) {
        if (string.length() == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        this.split(string, '.', vector);
        return this._getNode(vector, 0, this);
    }

    public final Properties getNode(String string) {
        if (string.length() == 0) {
            return this;
        }
        Properties properties = this.findNode(string);
        if (properties != null) {
            return properties;
        }
        this.createNode(string);
        return this.findNode(string);
    }

    public boolean createNode(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (this.findNode(string) != null) {
            return false;
        }
        this.setProperty(string, EMPTY);
        return true;
    }

    public Properties removeNode(String string) {
        for (int i = 0; i < this.leaf.size(); ++i) {
            if (!this.leaf.get((int)i).name.equals(string)) continue;
            Properties properties = this.leaf.get(i);
            this.leaf.remove(i);
            return properties;
        }
        return null;
    }

    public final Properties hasKey(String string) {
        for (int i = 0; i < this.leaf.size(); ++i) {
            if (!this.leaf.get((int)i).name.equals(string)) continue;
            return this.leaf.get(i);
        }
        return null;
    }

    public void clear() {
        while (this.leaf.size() > 0) {
            Properties properties = this.leaf.get(this.leaf.size() - 1);
            if (properties == null) continue;
            properties.destruct();
        }
    }

    public void merge(Properties properties) {
        for (String string : properties.propertyNames()) {
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
        }
    }

    protected Pair<String, String> splitKeyValue(String string) {
        int n;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != ':' && string.charAt(n) != '=' || StringUtil.isEscaped(string, n)) continue;
            return new Pair<String, String>(string.substring(0, n).trim(), string.substring(n + 1).trim());
        }
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != ' ' || !StringUtil.isEscaped(string, n)) continue;
            return new Pair<String, String>(string.substring(0, n).trim(), string.substring(n + 1).trim());
        }
        return new Pair<String, String>(string, EMPTY);
    }

    protected boolean split(String string, char c, Vector<String> vector) {
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c || StringUtil.isEscaped(string, i)) continue;
            vector.add(string.substring(n, i));
            n = i + 1;
        }
        vector.add(string.substring(n));
        return true;
    }

    protected String indent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    protected Properties _getNode(Vector<String> vector, int n, Properties properties) {
        Properties properties2 = properties.hasKey(vector.get(n));
        if (properties2 == null) {
            return null;
        }
        if (n < vector.size() - 1) {
            return properties2._getNode(vector, ++n, properties2);
        }
        return properties2;
    }

    protected void _propertyNames(Vector<String> vector, String string, Properties properties) {
        if (!properties.leaf.isEmpty()) {
            for (int i = 0; i < properties.leaf.size(); ++i) {
                String string2 = string + '.' + properties.leaf.get((int)i).name;
                this._propertyNames(vector, string2, properties.leaf.get(i));
            }
        } else {
            vector.add(string);
        }
    }

    protected void _store(OutputStream outputStream, String string, Properties properties) {
        if (!properties.leaf.isEmpty()) {
            for (int i = 0; i < properties.leaf.size(); ++i) {
                String string2 = string.length() == 0 ? properties.leaf.get((int)i).name : string + '.' + properties.leaf.get((int)i).name;
                this._store(outputStream, string2, properties.leaf.get(i));
            }
        }
        if (properties.root != null && properties.value != null && properties.value.length() > 0) {
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.write(string);
            printWriter.write(" = ");
            printWriter.write(properties.value);
            printWriter.println();
            printWriter.flush();
        }
    }

    protected OutputStream _dump(OutputStream outputStream, Properties properties, int n) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        if (n != 0) {
            printWriter.write(this.indent(n));
            printWriter.write("- ");
            printWriter.write(properties.name);
        }
        if (properties.leaf.isEmpty()) {
            if (properties.value.length() == 0) {
                printWriter.write(": ");
                printWriter.write(properties.default_value);
                printWriter.println();
            } else {
                printWriter.write(": ");
                printWriter.write(properties.value);
                printWriter.println();
            }
            return outputStream;
        }
        if (n != 0) {
            printWriter.println();
        }
        for (int i = 0; i < properties.leaf.size(); ++i) {
            this._dump(outputStream, properties.leaf.get(i), n + 1);
        }
        return outputStream;
    }

    public String _dump(String string, Properties properties, int n) {
        String string2 = System.getProperty("line.separator");
        if (n != 0) {
            string = string + this.indent(n) + "- " + properties.name;
        }
        if (properties.leaf.isEmpty()) {
            string = properties.value.length() == 0 ? string + ": " + properties.default_value + string2 : string + ": " + properties.value + string2;
            return string;
        }
        if (n != 0) {
            string = string + string2;
        }
        for (int i = 0; i < properties.leaf.size(); ++i) {
            string = this._dump(string, properties.leaf.get(i), n + 1);
        }
        return string;
    }
}

