/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.Iterator;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Config;
import jp.go.aist.rtm.RTC.ConfigBase;
import jp.go.aist.rtm.RTC.find_conf;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.ValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAdmin {
    private Properties m_configsets = new Properties();
    private Properties m_emptyconf = new Properties();
    private Vector<ConfigBase> m_params = new Vector();
    private String m_activeId = new String();
    private boolean m_active;
    private boolean m_changed;
    Vector<String> m_newConfig = new Vector();

    public ConfigAdmin(Properties configsets) {
        this.m_configsets = configsets;
        this.m_activeId = new String("default");
        this.m_active = true;
        this.m_changed = false;
    }

    public void destruct() {
        int intIdx = 0;
        while (intIdx < this.m_params.size()) {
            if (this.m_params.elementAt(intIdx) != null) {
                this.m_params.setElementAt(null, intIdx);
            }
            ++intIdx;
        }
        this.m_params.clear();
    }

    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public boolean bindParameter(String param_name, ValueHolder var, String def_val) {
        if (this.isExist(param_name)) {
            return false;
        }
        try {
            var.stringFrom(def_val);
        }
        catch (Exception ex) {
            return false;
        }
        this.m_params.add(new Config(param_name, var, def_val));
        return true;
    }

    public void update(String config_set) {
        if (this.m_configsets.hasKey(config_set) == null) {
            return;
        }
        Properties prop = new Properties(this.m_configsets.getNode(config_set));
        int intIdx = 0;
        while (intIdx < this.m_params.size()) {
            if (prop.hasKey(this.m_params.elementAt((int)intIdx).name) != null) {
                this.m_params.elementAt(intIdx).update(prop.getProperty(this.m_params.elementAt((int)intIdx).name));
            }
            ++intIdx;
        }
    }

    public void update() {
        if (this.m_changed && this.m_active) {
            this.update(this.m_activeId);
            this.m_changed = false;
        }
    }

    public void update(String config_set, String config_param) {
        String key = new String(String.valueOf(config_set) + "." + config_param);
        for (ConfigBase configbase : this.m_params) {
            if (!new find_conf(config_param).equalof(configbase)) continue;
            configbase.update(this.m_configsets.getProperty(key));
            return;
        }
    }

    public boolean isExist(String param_name) {
        Iterator<ConfigBase> iterator = this.m_params.iterator();
        while (iterator.hasNext()) {
            if (!new find_conf(param_name).equalof(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public final String getActiveId() {
        return this.m_activeId;
    }

    public final boolean haveConfig(String config_id) {
        return this.m_configsets.hasKey(config_id) != null;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public final Vector<Properties> getConfigurationSets() {
        return this.m_configsets.getLeaf();
    }

    public final Properties getConfigurationSet(String config_id) {
        Properties p = new Properties(this.m_configsets.getNode(config_id));
        if (p == null) {
            return this.m_emptyconf;
        }
        return p;
    }

    public boolean setConfigurationSetValues(String config_id, Properties config_set) {
        if (!config_id.equals(config_set.getName())) {
            return false;
        }
        if (this.m_configsets.hasKey(config_id) == null) {
            return false;
        }
        this.m_configsets.getNode(config_id).merge(config_set);
        this.m_changed = true;
        this.m_active = true;
        return true;
    }

    public final Properties getActiveConfigurationSet() {
        Properties prop = this.m_configsets.getNode(this.m_activeId);
        if (prop == null) {
            return this.m_emptyconf;
        }
        Properties p = new Properties(prop);
        if (p == null) {
            return this.m_emptyconf;
        }
        return p;
    }

    public boolean addConfigurationSet(Properties configset) {
        if (this.m_configsets.hasKey(configset.getName()) != null) {
            return false;
        }
        String node = new String(configset.getName());
        this.m_configsets.createNode(node);
        this.m_configsets.getNode(node).merge(configset);
        this.m_newConfig.add(node);
        this.m_changed = true;
        this.m_active = false;
        return true;
    }

    public boolean removeConfigurationSet(String config_id) {
        int intIdx = 0;
        while (intIdx < this.m_newConfig.size()) {
            if (this.m_newConfig.elementAt(intIdx).equals(config_id)) {
                Properties p = new Properties(this.m_configsets.getNode(config_id));
                if (p != null) {
                    this.m_configsets.removeNode(p.getName());
                }
                this.m_newConfig.remove(intIdx);
                this.m_changed = true;
                this.m_active = false;
                return true;
            }
            ++intIdx;
        }
        return false;
    }

    public boolean activateConfigurationSet(String config_id) {
        if (config_id == null) {
            return false;
        }
        if (this.m_configsets.hasKey(config_id) == null) {
            return false;
        }
        this.m_activeId = config_id;
        this.m_active = true;
        this.m_changed = true;
        return true;
    }

    private ConfigAdmin(ConfigAdmin ca) {
        this.m_configsets = ca.m_configsets;
    }
}

