/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import jp.go.aist.rtm.RTC.util.StringHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CorbaNaming {
    protected ORB m_varORB;
    protected String m_nameServer = new String();
    protected NamingContextExt m_rootContext;
    private int m_blLength;

    public CorbaNaming(ORB orb) {
        this.m_varORB = orb;
        this.m_nameServer = "";
        this.m_rootContext = null;
        this.m_blLength = 100;
    }

    public CorbaNaming(ORB orb, String name_server) throws Exception {
        this.m_varORB = orb;
        this.m_nameServer = name_server;
        this.m_rootContext = null;
        this.m_blLength = 100;
        this.m_nameServer = "corbaloc:iiop:1.2@" + this.m_nameServer + "/NameService";
        Object obj = this.m_varORB.string_to_object(this.m_nameServer);
        this.m_rootContext = NamingContextExtHelper.narrow((Object)obj);
        if (this.m_rootContext == null) {
            throw new Exception("bad_alloc()");
        }
    }

    public void init(String name_server) throws Exception {
        this.m_nameServer = name_server;
        this.m_nameServer = "corbaloc:iiop:1.2@" + this.m_nameServer + "/NameService";
        Object obj = this.m_varORB.string_to_object(this.m_nameServer);
        this.m_rootContext = NamingContextExtHelper.narrow((Object)obj);
        if (this.m_rootContext == null) {
            throw new Exception("bad_alloc()");
        }
    }

    public void bind(NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bind(name, obj, true);
    }

    public void bind(NameComponent[] name, Object obj, boolean force) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            this.m_rootContext.bind(name, obj);
        }
        catch (NotFound ex) {
            if (force) {
                this.bindRecursive((NamingContext)this.m_rootContext, name, obj);
            }
            throw ex;
        }
        catch (CannotProceed ex) {
            if (force) {
                this.bindRecursive(ex.cxt, ex.rest_of_name, obj);
            }
            throw ex;
        }
        catch (AlreadyBound ex) {
            if (force) {
                this.bindRecursive((NamingContext)this.m_rootContext, name, obj);
            }
            throw ex;
        }
    }

    public void bindByString(String string_name, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bindByString(string_name, obj, true);
    }

    public void bindByString(String string_name, Object obj, boolean force) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bind(this.toName(string_name), obj, force);
    }

    public void bindRecursive(NamingContext context, NameComponent[] name, Object obj) throws CannotProceed, InvalidName, AlreadyBound, NotFound {
        int len = name.length;
        NamingContext cxt = (NamingContext)context._duplicate();
        int intIdx = 0;
        while (intIdx < len) {
            if (intIdx == len - 1) {
                cxt.rebind(this.subName(name, intIdx, intIdx), obj);
                return;
            }
            if (!this.isNamingContext((Object)cxt)) {
                throw new CannotProceed(cxt, this.subName(name, intIdx));
            }
            cxt = this.bindOrResolveContext(cxt, this.subName(name, intIdx, intIdx));
            ++intIdx;
        }
    }

    public void rebind(NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName {
        this.rebind(name, obj, true);
    }

    public void rebind(NameComponent[] name, Object obj, boolean force) throws NotFound, CannotProceed, InvalidName {
        try {
            this.m_rootContext.rebind(name, obj);
        }
        catch (NotFound ex) {
            if (force) {
                this.rebindRecursive((NamingContext)this.m_rootContext, name, obj);
            }
            throw ex;
        }
        catch (CannotProceed ex) {
            if (force) {
                this.rebindRecursive(ex.cxt, ex.rest_of_name, obj);
            }
            throw ex;
        }
    }

    public void rebindByString(String string_name, Object obj) throws NotFound, CannotProceed, InvalidName {
        this.rebindByString(string_name, obj, true);
    }

    public void rebindByString(String string_name, Object obj, boolean force) throws NotFound, CannotProceed, InvalidName {
        this.rebind(this.toName(string_name), obj, force);
    }

    public void rebindRecursive(NamingContext context, NameComponent[] name, Object obj) throws CannotProceed, InvalidName, NotFound {
        int len = name.length;
        NamingContext cxt = (NamingContext)context._duplicate();
        int intIdx = 0;
        while (intIdx < len) {
            if (intIdx == len - 1) {
                cxt.rebind(this.subName(name, intIdx, intIdx), obj);
                return;
            }
            if (this.isNamingContext((Object)cxt)) {
                try {
                    cxt = cxt.bind_new_context(this.subName(name, intIdx, intIdx));
                }
                catch (AlreadyBound ex) {
                    cxt = NamingContextExtHelper.narrow((Object)cxt.resolve(this.subName(name, intIdx, intIdx)));
                }
            } else {
                throw new CannotProceed(cxt, this.subName(name, intIdx));
            }
            ++intIdx;
        }
    }

    public void bindContext(NameComponent[] name, NamingContext name_cxt) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bindContext(name, name_cxt, true);
    }

    public void bindContext(NameComponent[] name, NamingContext name_cxt, boolean force) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bind(name, (Object)name_cxt, force);
    }

    public void bindContext(String string_name, NamingContext name_cxt) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bindContext(string_name, name_cxt, true);
    }

    public void bindContext(String string_name, NamingContext name_cxt, boolean force) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.bindContext(this.toName(string_name), name_cxt, force);
    }

    public void bindContextRecursive(NamingContext context, NameComponent[] name, NamingContext name_cxt) throws CannotProceed, InvalidName, AlreadyBound, NotFound {
        this.bindRecursive(context, name, (Object)name_cxt);
    }

    public void rebindContext(NameComponent[] name, NamingContext name_cxt) throws NotFound, CannotProceed, InvalidName {
        this.rebindContext(name, name_cxt, true);
    }

    public void rebindContext(NameComponent[] name, NamingContext name_cxt, boolean force) throws NotFound, CannotProceed, InvalidName {
        this.rebind(name, (Object)name_cxt, force);
    }

    public void rebindContext(String string_name, NamingContext name_cxt) throws NotFound, CannotProceed, InvalidName {
        this.rebindContext(string_name, name_cxt, true);
    }

    public void rebindContext(String string_name, NamingContext name_cxt, boolean force) throws NotFound, CannotProceed, InvalidName {
        this.rebindContext(this.toName(string_name), name_cxt, force);
    }

    public void rebindContextRecursive(NamingContext context, NameComponent[] name, NamingContext name_cxt) throws CannotProceed, InvalidName, NotFound {
        this.rebindRecursive(context, name, (Object)name_cxt);
    }

    public Object resolve(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        return this.m_rootContext.resolve(name);
    }

    public Object resolve(String string_name) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.toName(string_name));
    }

    public void unbind(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        this.m_rootContext.unbind(name);
    }

    public void unbind(String string_name) throws NotFound, CannotProceed, InvalidName {
        this.unbind(this.toName(string_name));
    }

    public NamingContext newContext() {
        return this.m_rootContext.new_context();
    }

    public NamingContext bindNewContext(NameComponent[] name) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        return this.bindNewContext(name, true);
    }

    public NamingContext bindNewContext(NameComponent[] name, boolean force) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            return this.m_rootContext.bind_new_context(name);
        }
        catch (NotFound ex) {
            if (force) {
                this.bindRecursive((NamingContext)this.m_rootContext, name, (Object)this.newContext());
            }
            throw ex;
        }
        catch (CannotProceed ex) {
            if (force) {
                this.bindRecursive(ex.cxt, ex.rest_of_name, (Object)this.newContext());
            }
            throw ex;
        }
        return null;
    }

    public NamingContext bindNewContext(String string_name) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        return this.bindNewContext(string_name, true);
    }

    public NamingContext bindNewContext(String string_name, boolean force) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        return this.bindNewContext(this.toName(string_name));
    }

    public void destroy(NamingContext context) throws NotEmpty {
        context.destroy();
    }

    public void destroyRecursive(NamingContext context) throws NotEmpty, NotFound, CannotProceed, InvalidName {
        BindingListHolder bl = new BindingListHolder();
        BindingIteratorHolder bi = new BindingIteratorHolder();
        boolean cont = true;
        context.list(this.m_blLength, bl, bi);
        while (cont) {
            int len = bl.value.length;
            int intIdx = 0;
            while (intIdx < len) {
                if (bl.value[intIdx].binding_type == BindingType.ncontext) {
                    NamingContextExt next_context = NamingContextExtHelper.narrow((Object)context.resolve(bl.value[intIdx].binding_name));
                    this.destroyRecursive((NamingContext)next_context);
                    context.unbind(bl.value[intIdx].binding_name);
                    next_context.destroy();
                } else if (bl.value[intIdx].binding_type == BindingType.nobject) {
                    context.unbind(bl.value[intIdx].binding_name);
                }
                ++intIdx;
            }
            if (bi == null) {
                cont = false;
                continue;
            }
            if (bi.value != null) {
                if (bi.value.next_n(this.m_blLength, bl)) continue;
                return;
            }
            return;
        }
        if (bi != null) {
            bi.value.destroy();
        }
    }

    public void clearAll() throws NotEmpty, NotFound, CannotProceed, InvalidName {
        this.destroyRecursive((NamingContext)this.m_rootContext);
    }

    public void list(NamingContext name_cxt, long how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        name_cxt.list((int)how_many, bl, bi);
    }

    public String toString(NameComponent[] name) throws InvalidName {
        if (name == null || name.equals("")) {
            throw new InvalidName();
        }
        int slen = 0;
        slen = this.getNameLength(name);
        StringHolder string_name = new StringHolder();
        string_name.value = new String();
        this.nameToString(name, string_name, slen);
        return string_name.value;
    }

    public NameComponent[] toName(String sname) throws InvalidName {
        if (sname == null || sname.equals("")) {
            throw new InvalidName();
        }
        String string_name = new String(sname);
        int nc_length = 0;
        String[] name_comps = string_name.split("/");
        nc_length = name_comps.length;
        if (nc_length <= 0) {
            throw new InvalidName();
        }
        NameComponent[] name = new NameComponent[nc_length];
        int intIdx = 0;
        while (intIdx < nc_length) {
            int pos = name_comps[intIdx].lastIndexOf(".");
            if (name[intIdx] == null) {
                name[intIdx] = new NameComponent();
            }
            if (pos >= 0) {
                name[intIdx].id = name_comps[intIdx].substring(0, pos);
                name[intIdx].kind = name_comps[intIdx].substring(pos + 1);
            } else {
                name[intIdx].id = name_comps[intIdx];
                name[intIdx].kind = "";
            }
            ++intIdx;
        }
        return name;
    }

    public String toUrl(String addr, String string_name) throws InvalidAddress, InvalidName {
        return this.m_rootContext.to_url(addr, string_name);
    }

    public Object resolveStr(String string_name) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        return this.resolve(string_name);
    }

    public NamingContext bindOrResolve(NamingContext context, NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName {
        context.rebind(name, obj);
        return context;
    }

    public NamingContext bindOrResolveContext(NamingContext context, NameComponent[] name, NamingContext new_context) throws NotFound, CannotProceed, InvalidName {
        return this.bindOrResolve(context, name, (Object)new_context);
    }

    public NamingContext bindOrResolveContext(NamingContext context, NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        NamingContext new_context = context.new_context();
        context.rebind_context(name, new_context);
        return new_context;
    }

    public final String getNameServer() {
        return this.m_nameServer;
    }

    public NamingContext getRootContext() {
        return this.m_rootContext;
    }

    public boolean isNamingContext(Object obj) {
        NamingContextExt nc = NamingContextExtHelper.narrow((Object)obj);
        return nc != null;
    }

    public boolean isNamingContext(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        return this.isNamingContext(this.resolve(name));
    }

    public boolean isNamingContext(String string_name) throws NotFound, CannotProceed, InvalidName {
        return this.isNamingContext(this.resolve(string_name));
    }

    public NameComponent[] subName(NameComponent[] name, long begin) {
        return this.subName(name, begin, -1L);
    }

    public NameComponent[] subName(NameComponent[] name, long begin, long end) {
        int sub_len;
        if (end < 0L) {
            end = name.length - 1;
        }
        if ((sub_len = (int)(end - (begin - 1L))) <= 0) {
            NameComponent[] sub_name = new NameComponent[]{};
            return sub_name;
        }
        NameComponent[] sub_name = new NameComponent[sub_len];
        int intIdx = 0;
        while (intIdx < sub_len) {
            sub_name[intIdx] = name[(int)(begin + (long)intIdx)];
            ++intIdx;
        }
        return sub_name;
    }

    protected void nameToString(NameComponent[] name, StringHolder string_name, long slen) {
        StringBuffer s = new StringBuffer(string_name.value);
        int intIdx = 0;
        while (intIdx < name.length) {
            int intIdx2 = 0;
            while (intIdx2 < name[intIdx].id.length()) {
                char id = name[intIdx].id.charAt(intIdx2);
                if (id == '/' || id == '.' || id == '\\') {
                    s.append('\\');
                }
                s.append(id);
                ++intIdx2;
            }
            if (name[intIdx].id.equals("") || !name[intIdx].kind.equals("")) {
                s.append('.');
            }
            intIdx2 = 0;
            while (intIdx2 < name[intIdx].kind.length()) {
                char kind = name[intIdx].kind.charAt(intIdx2);
                if (kind == '/' || kind == '.' || kind == '\\') {
                    s.append('\\');
                }
                s.append(kind);
                ++intIdx2;
            }
            s.append('/');
            ++intIdx;
        }
        string_name.value = s.toString();
    }

    protected int getNameLength(NameComponent[] name) {
        int slen = 0;
        int intIdx = 0;
        while (intIdx < name.length) {
            int intIdx2 = 0;
            while (intIdx2 < name[intIdx].id.length()) {
                char id = name[intIdx].id.charAt(intIdx2);
                if (id == '/' || id == '.' || id == '\\') {
                    ++slen;
                }
                ++slen;
                ++intIdx2;
            }
            if (name[intIdx].id.equals("") || !name[intIdx].kind.equals("")) {
                ++slen;
            }
            intIdx2 = 0;
            while (intIdx2 < name[intIdx].kind.length()) {
                char kind = name[intIdx].kind.charAt(intIdx2);
                if (kind == '/' || kind == '.' || kind == '\\') {
                    ++slen;
                }
                ++slen;
                ++intIdx2;
            }
            ++slen;
            ++intIdx;
        }
        return slen;
    }
}

