/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import java.util.Vector;
import jp.go.aist.rtm.RTC.port.InPort;
import jp.go.aist.rtm.RTC.port.InPortCorbaProvider;
import jp.go.aist.rtm.RTC.port.InPortProvider;
import jp.go.aist.rtm.RTC.port.OutPortConsumer;
import jp.go.aist.rtm.RTC.port.OutPortCorbaConsumer;
import jp.go.aist.rtm.RTC.port.PortBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataInPort<DataType>
extends PortBase {
    private Vector<Integer> m_dummy = new Vector();
    private Vector<InPortProvider> m_providers = new Vector();
    private Vector<OutPortConsumer> m_consumers = new Vector();

    public DataInPort(Class<DataType> DATA_TYPE_CLASS, String name, InPort<DataType> inPort) throws Exception {
        super(name);
        this.addProperty("port.port_type", "DataInPort");
        this.m_providers.add(new InPortCorbaProvider<DataType>(DATA_TYPE_CLASS, inPort));
        NVListHolder holder = new NVListHolder(this.m_profile.properties);
        this.m_providers.lastElement().publishInterfaceProfile(holder);
        this.m_profile.properties = holder.value;
        this.m_consumers.add(new OutPortCorbaConsumer<DataType>(DATA_TYPE_CLASS, inPort));
        this.m_dummy.add(1);
    }

    @Override
    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connector_profile) {
        if (this.m_dummy.size() != 1) {
            StringBuffer msg = new StringBuffer();
            msg.append("Memory access violation was detected.\n");
            msg.append("dummy.size(): ").append(this.m_dummy.size()).append("\n");
            msg.append("size() should be 1.\n");
            throw new AssertionError((Object)msg.toString());
        }
        for (InPortProvider provider : this.m_providers) {
            NVListHolder holder = new NVListHolder(connector_profile.value.properties);
            provider.publishInterface(holder);
            connector_profile.value.properties = holder.value;
        }
        return ReturnCode_t.RTC_OK;
    }

    @Override
    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connector_profile) {
        for (OutPortConsumer consumer : this.m_consumers) {
            consumer.subscribeInterface(new NVListHolder(connector_profile.value.properties));
        }
        return ReturnCode_t.RTC_OK;
    }

    @Override
    protected void unsubscribeInterfaces(ConnectorProfile connector_profile) {
        for (OutPortConsumer consumer : this.m_consumers) {
            consumer.unsubscribeInterface(new NVListHolder(connector_profile.properties));
        }
    }
}

