/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.buffer.RingBuffer;
import jp.go.aist.rtm.RTC.port.OnOverflow;
import jp.go.aist.rtm.RTC.port.OnRead;
import jp.go.aist.rtm.RTC.port.OnReadConvert;
import jp.go.aist.rtm.RTC.port.OnUnderflow;
import jp.go.aist.rtm.RTC.port.OnWrite;
import jp.go.aist.rtm.RTC.port.OnWriteConvert;
import jp.go.aist.rtm.RTC.port.OutPortBase;
import jp.go.aist.rtm.RTC.util.DataRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutPort<DataType>
extends OutPortBase
implements BufferBase<DataType> {
    private BufferBase<DataType> m_buffer;
    private DataRef<DataType> m_value;
    private long m_timeoutTick;
    private boolean m_readBlock;
    private long m_readTimeout;
    private boolean m_writeBlock;
    private long m_writeTimeout;
    private OnWrite<DataType> m_OnWrite;
    private OnWriteConvert<DataType> m_OnWriteConvert;
    private OnRead<DataType> m_OnRead;
    private OnReadConvert<DataType> m_OnReadConvert;
    private OnOverflow<DataType> m_OnOverflow;
    private OnUnderflow<DataType> m_OnUnderflow;

    public OutPort(String name, DataRef<DataType> valueRef) {
        this(new RingBuffer(8), name, valueRef);
    }

    public OutPort(String name, DataRef<DataType> valueRef, int length) {
        this(new RingBuffer(length), name, valueRef);
    }

    public OutPort(BufferBase<DataType> buffer, String name, DataRef<DataType> valueRef) {
        super(name);
        this.m_buffer = buffer;
        this.m_value = valueRef;
        this.m_timeoutTick = 1000L;
        this.m_readBlock = false;
        this.m_readTimeout = 0L;
        this.m_writeBlock = false;
        this.m_writeTimeout = 0L;
        this.m_OnWrite = null;
        this.m_OnWriteConvert = null;
        this.m_OnRead = null;
        this.m_OnReadConvert = null;
        this.m_OnOverflow = null;
        this.m_OnUnderflow = null;
    }

    @Override
    public boolean write(DataType value) {
        if (this.m_OnWrite != null) {
            this.m_OnWrite.run(value);
        }
        long timeout = this.m_writeTimeout;
        long tm_pre = System.nanoTime();
        long TIMEOUT_TICK_MSEC_PART = this.m_timeoutTick / 1000L;
        int TIMEOUT_TICK_NSEC_PART = (int)(this.m_timeoutTick % 1000L) * 1000;
        long count = 0L;
        while (this.m_writeBlock && this.isFull()) {
            if (this.m_writeTimeout < 0L) {
                try {
                    Thread.sleep(TIMEOUT_TICK_MSEC_PART, TIMEOUT_TICK_NSEC_PART);
                }
                catch (InterruptedException ignored) {
                    ignored.printStackTrace();
                }
                continue;
            }
            long tm_cur = System.nanoTime();
            long tm_diff = tm_cur - tm_pre;
            if ((timeout -= tm_diff / 1000L) < 0L) break;
            tm_pre = tm_cur;
            try {
                Thread.sleep(TIMEOUT_TICK_MSEC_PART, TIMEOUT_TICK_NSEC_PART);
            }
            catch (InterruptedException ignored) {
                ignored.printStackTrace();
            }
            ++count;
        }
        if (this.isFull()) {
            if (this.m_OnOverflow != null) {
                this.m_OnOverflow.run(value);
            }
            return false;
        }
        if (this.m_OnWriteConvert == null) {
            this.put(value);
        } else {
            this.put(this.m_OnWriteConvert.run(value));
        }
        this.update();
        return true;
    }

    public boolean write() {
        return this.write(this.m_value.v);
    }

    @Override
    public boolean read(DataRef<DataType> valueRef) {
        if (this.m_OnRead != null) {
            this.m_OnRead.run();
        }
        long timeout = this.m_readTimeout;
        long tm_pre = System.nanoTime();
        long TIMEOUT_TICK_MSEC_PART = this.m_timeoutTick / 1000L;
        int TIMEOUT_TICK_NSEC_PART = (int)(this.m_timeoutTick % 1000L) * 1000;
        while (this.m_readBlock && this.isEmpty()) {
            if (this.m_readTimeout < 0L) {
                try {
                    Thread.sleep(TIMEOUT_TICK_MSEC_PART, TIMEOUT_TICK_NSEC_PART);
                }
                catch (InterruptedException ignored) {
                    ignored.printStackTrace();
                }
                continue;
            }
            long tm_cur = System.nanoTime();
            long tm_diff = tm_cur - tm_pre;
            if ((timeout -= tm_diff / 1000L) < 0L) break;
            tm_pre = tm_cur;
            try {
                Thread.sleep(TIMEOUT_TICK_MSEC_PART, TIMEOUT_TICK_NSEC_PART);
            }
            catch (InterruptedException ignored) {
                ignored.printStackTrace();
            }
        }
        if (this.isEmpty()) {
            if (this.m_OnUnderflow != null) {
                valueRef.v = this.m_OnUnderflow.run();
                return false;
            }
            return false;
        }
        if (this.m_OnReadConvert == null) {
            valueRef.v = this.get();
            return true;
        }
        valueRef.v = this.m_OnReadConvert.run(this.get());
        return true;
    }

    public void setReadBlock(boolean block) {
        this.m_readBlock = block;
    }

    public void setWriteBlock(boolean block) {
        this.m_writeBlock = block;
    }

    public void setReadTimeout(long timeout) {
        this.m_readTimeout = timeout;
    }

    public void setWriteTimeout(long timeout) {
        this.m_writeTimeout = timeout;
    }

    public void setOnWrite(OnWrite<DataType> onWrite) {
        this.m_OnWrite = onWrite;
    }

    public void setOnWriteConvert(OnWriteConvert<DataType> onWriteConvert) {
        this.m_OnWriteConvert = onWriteConvert;
    }

    public void setOnOverflow(OnOverflow<DataType> onOverflow) {
        this.m_OnOverflow = onOverflow;
    }

    public void setOnRead(OnRead<DataType> onRead) {
        this.m_OnRead = onRead;
    }

    public void setOnReadConvert(OnReadConvert<DataType> onReadConvert) {
        this.m_OnReadConvert = onReadConvert;
    }

    public void setOnUnderflow(OnUnderflow<DataType> onUnderflow) {
        this.m_OnUnderflow = onUnderflow;
    }

    @Override
    public int length() {
        return this.m_buffer.length();
    }

    @Override
    public boolean isFull() {
        return this.m_buffer.isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.m_buffer.isEmpty();
    }

    @Override
    public void put(DataType data) {
        this.m_buffer.put(data);
    }

    @Override
    public DataType get() {
        return this.m_buffer.get();
    }

    @Override
    public boolean isNew() {
        return this.m_buffer.isNew();
    }
}

