/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.Port;
import RTC.PortListHolder;
import RTC.PortOperations;
import RTC.PortProfile;
import RTC.PortProfileListHolder;
import java.util.Vector;
import jp.go.aist.rtm.RTC.ObjectManager;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.PortListHolderFactory;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class PortAdmin {
    private ORB m_pORB;
    private POA m_pPOA;
    private PortListHolder m_portRefs = PortListHolderFactory.create();
    private ObjectManager<String, PortBase> m_portServants = new ObjectManager();

    public PortAdmin(ORB orb, POA poa) {
        this.m_pORB = orb;
        this.m_pPOA = poa;
    }

    public PortListHolder getPortList() {
        return PortListHolderFactory.clone(this.m_portRefs);
    }

    public final PortProfileListHolder getPortProfileList() {
        PortProfileListHolder port_profs = new PortProfileListHolder();
        port_profs.value = new PortProfile[0];
        port_prof_collect p = new port_prof_collect(port_profs);
        for (PortBase port : this.m_portServants.getObjects()) {
            p.operator(port);
        }
        return port_profs;
    }

    public Port getPortRef(String portName) {
        Port port = null;
        int index = CORBA_SeqUtil.find(this.m_portRefs, (equalFunctor)new find_port_name(portName));
        if (index >= 0) {
            port = this.m_portRefs.value[index];
        }
        return port;
    }

    public PortBase getPort(String portName) {
        return this.m_portServants.find(new find_port_name(portName));
    }

    public void registerPort(PortBase port) {
        CORBA_SeqUtil.push_back(this.m_portRefs, port.getPortRef());
        this.m_portServants.registerObject(port, new find_port_name(port.get_port_profile().name));
    }

    public void deletePort(PortBase port) {
        try {
            port.disconnect_all();
            String tmp = port.getProfile().name;
            CORBA_SeqUtil.erase_if(this.m_portRefs, (equalFunctor)new find_port_name(tmp));
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)port));
            port.setPortRef(null);
            this.m_portServants.unregisterObject(new find_port_name(tmp));
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    public void deletePortByName(String portName) {
        if (portName == null || portName.length() == 0) {
            return;
        }
        this.deletePort(this.m_portServants.find(new find_port_name(portName)));
    }

    public void finalizePorts() {
        Vector<PortBase> ports = this.m_portServants.getObjects();
        int i = 0;
        while (i < ports.size()) {
            this.deletePort(ports.elementAt(i));
            ++i;
        }
    }

    protected class find_port_name
    implements equalFunctor {
        public String m_name;

        public find_port_name(String name) {
            this.m_name = name;
        }

        public boolean equalof(Object element) {
            PortOperations port = (PortOperations)element;
            return this.m_name.equals(port.get_port_profile().name);
        }
    }

    protected class port_prof_collect {
        private PortProfileListHolder m_p;

        public port_prof_collect(PortProfileListHolder p) {
            this.m_p = p;
        }

        public void operator(PortBase port) {
            CORBA_SeqUtil.push_back(this.m_p, port.getPortProfile());
        }
    }
}

