/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.ConnectorProfileListHolder;
import RTC.Port;
import RTC.PortHelper;
import RTC.PortInterfacePolarity;
import RTC.PortInterfaceProfile;
import RTC.PortInterfaceProfileListHolder;
import RTC.PortListHolder;
import RTC.PortPOA;
import RTC.PortProfile;
import RTC.RTObject;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import java.util.UUID;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.ConnectorProfileFactory;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.PortProfileFactory;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import jp.go.aist.rtm.RTC.util.operatorFunc;

public abstract class PortBase
extends PortPOA {
    protected PortProfile m_profile = new PortProfile();
    protected Port m_objref;

    public PortBase(String name) {
        this.m_profile.name = new String(name);
        this.m_profile.owner = null;
        this.m_profile.interfaces = new PortInterfaceProfile[0];
        this.m_profile.connector_profiles = new ConnectorProfile[0];
        this.m_profile.properties = new NameValue[0];
        this.m_profile.port_ref = this.m_objref = PortHelper.narrow(this._this()._duplicate());
    }

    public Port _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = PortHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.m_objref;
    }

    public PortBase() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortProfile get_port_profile() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            return PortProfileFactory.clone(this.m_profile);
        }
    }

    public final PortProfile getPortProfile() {
        return this.m_profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorProfile[] get_connector_profiles() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            int length = this.m_profile.connector_profiles.length;
            ConnectorProfile[] conn_prof = new ConnectorProfile[length];
            int i = 0;
            while (i < length) {
                conn_prof[i] = this.m_profile.connector_profiles[i];
                ++i;
            }
            return conn_prof;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorProfile get_connector_profile(String connector_id) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
            int index = CORBA_SeqUtil.find(holder, (equalFunctor)new find_conn_id(connector_id));
            if (index < 0) {
                ConnectorProfile conn_prof = ConnectorProfileFactory.create();
                return conn_prof;
            }
            ConnectorProfile org_conn_prof = this.m_profile.connector_profiles[index];
            ConnectorProfile conn_prof = new ConnectorProfile(org_conn_prof.name, org_conn_prof.connector_id, org_conn_prof.ports, org_conn_prof.properties);
            return conn_prof;
        }
    }

    public ReturnCode_t connect(ConnectorProfileHolder connector_profile) {
        if (this.isEmptyId(connector_profile.value)) {
            this.setUUID(connector_profile);
            assert (!this.isExistingConnId(connector_profile.value.connector_id));
        }
        try {
            return connector_profile.value.ports[0].notify_connect(connector_profile);
        }
        catch (Exception ex) {
            return ReturnCode_t.BAD_PARAMETER;
        }
    }

    public ReturnCode_t notify_connect(ConnectorProfileHolder connector_profile) {
        ReturnCode_t retval = this.publishInterfaces(connector_profile);
        if (!ReturnCode_t.RTC_OK.equals(retval)) {
            return retval;
        }
        retval = this.connectNext(connector_profile);
        if (!ReturnCode_t.RTC_OK.equals(retval)) {
            return retval;
        }
        retval = this.subscribeInterfaces(connector_profile);
        if (!ReturnCode_t.RTC_OK.equals(retval)) {
            this.notify_disconnect(connector_profile.value.connector_id);
            return retval;
        }
        int index = this.findConnProfileIndex(connector_profile.value.connector_id);
        if (index < 0) {
            ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
            CORBA_SeqUtil.push_back(holder, connector_profile.value);
            this.m_profile.connector_profiles = holder.value;
        } else {
            this.m_profile.connector_profiles[index] = connector_profile.value;
        }
        return retval;
    }

    public ReturnCode_t disconnect(String connector_id) {
        if (!this.isExistingConnId(connector_id)) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        int index = this.findConnProfileIndex(connector_id);
        ConnectorProfile org_conn_prof = this.m_profile.connector_profiles[index];
        ConnectorProfile prof = new ConnectorProfile(org_conn_prof.name, org_conn_prof.connector_id, org_conn_prof.ports, org_conn_prof.properties);
        return prof.ports[0].notify_disconnect(connector_id);
    }

    public ReturnCode_t notify_disconnect(String connector_id) {
        if (!this.isExistingConnId(connector_id)) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        int index = this.findConnProfileIndex(connector_id);
        ConnectorProfile org_conn_prof = this.m_profile.connector_profiles[index];
        ConnectorProfile prof = new ConnectorProfile(org_conn_prof.name, org_conn_prof.connector_id, org_conn_prof.ports, org_conn_prof.properties);
        ReturnCode_t retval = this.disconnectNext(prof);
        this.unsubscribeInterfaces(prof);
        ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        CORBA_SeqUtil.erase(holder, index);
        this.m_profile.connector_profiles = holder.value;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode_t disconnect_all() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
            disconnect_all_func f = (disconnect_all_func)CORBA_SeqUtil.for_each(holder, (operatorFunc)new disconnect_all_func(this));
            this.m_profile.connector_profiles = holder.value;
            return f.m_return_code;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            this.m_profile.name = new String(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PortProfile getProfile() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            return this.m_profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortRef(Port port_ref) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            this.m_profile.port_ref = port_ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Port getPortRef() {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            return this.m_profile.port_ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(RTObject owner) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            this.m_profile.owner = owner;
        }
    }

    protected abstract ReturnCode_t publishInterfaces(ConnectorProfileHolder var1);

    protected ReturnCode_t connectNext(ConnectorProfileHolder connector_profile) {
        PortListHolder portsHolder = new PortListHolder(connector_profile.value.ports);
        int index = CORBA_SeqUtil.find(portsHolder, (equalFunctor)new find_port_ref(this.m_profile.port_ref));
        connector_profile.value.ports = portsHolder.value;
        if (index < 0) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        if (++index < connector_profile.value.ports.length) {
            Port p = connector_profile.value.ports[index];
            ReturnCode_t rc = p.notify_connect(connector_profile);
            return rc;
        }
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t disconnectNext(ConnectorProfile connector_profile) {
        PortListHolder holder = new PortListHolder(connector_profile.ports);
        int index = CORBA_SeqUtil.find(holder, (equalFunctor)new find_port_ref(this.m_profile.port_ref));
        connector_profile.ports = holder.value;
        if (index < 0) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        if (++index < connector_profile.ports.length) {
            Port p = connector_profile.ports[index];
            return p.notify_disconnect(connector_profile.connector_id);
        }
        this.unsubscribeInterfaces(connector_profile);
        return ReturnCode_t.RTC_OK;
    }

    protected abstract ReturnCode_t subscribeInterfaces(ConnectorProfileHolder var1);

    protected abstract void unsubscribeInterfaces(ConnectorProfile var1);

    protected boolean isEmptyId(ConnectorProfile connector_profile) {
        return connector_profile.connector_id.length() == 0;
    }

    protected String getUUID() {
        return UUID.randomUUID().toString();
    }

    protected void setUUID(ConnectorProfileHolder connector_profile) {
        connector_profile.value.connector_id = this.getUUID();
        assert (connector_profile.value.connector_id.length() != 0);
    }

    protected boolean isExistingConnId(String id) {
        ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int index = CORBA_SeqUtil.find(holder, (equalFunctor)new find_conn_id(id));
        this.m_profile.connector_profiles = holder.value;
        return index >= 0;
    }

    protected ConnectorProfile findConnProfile(String id) {
        ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int index = CORBA_SeqUtil.find(holder, (equalFunctor)new find_conn_id(id));
        this.m_profile.connector_profiles = holder.value;
        if (index < 0) {
            return ConnectorProfileFactory.create();
        }
        return this.m_profile.connector_profiles[index];
    }

    protected int findConnProfileIndex(String id) {
        ConnectorProfileListHolder holder = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int index = CORBA_SeqUtil.find(holder, (equalFunctor)new find_conn_id(id));
        this.m_profile.connector_profiles = holder.value;
        return index;
    }

    protected void updateConnectorProfile(ConnectorProfile connector_profile) {
        ConnectorProfileListHolder cprof_list = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
        int index = CORBA_SeqUtil.find(cprof_list, (equalFunctor)new find_conn_id(connector_profile.connector_id));
        this.m_profile.connector_profiles = cprof_list.value;
        if (index < 0) {
            CORBA_SeqUtil.push_back(cprof_list, connector_profile);
            this.m_profile.connector_profiles = cprof_list.value;
        } else {
            this.m_profile.connector_profiles[index] = connector_profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean eraseConnectorProfile(String connector_id) {
        PortProfile portProfile = this.m_profile;
        synchronized (portProfile) {
            int index;
            ConnectorProfileListHolder cprof_list;
            block4: {
                cprof_list = new ConnectorProfileListHolder(this.m_profile.connector_profiles);
                index = CORBA_SeqUtil.find(cprof_list, (equalFunctor)new find_conn_id(connector_id));
                this.m_profile.connector_profiles = cprof_list.value;
                if (index >= 0) break block4;
                return false;
            }
            CORBA_SeqUtil.erase(cprof_list, index);
            this.m_profile.connector_profiles = cprof_list.value;
            return true;
        }
    }

    protected boolean appendInterface(String instance_name, String type_name, PortInterfacePolarity polarity) {
        PortInterfaceProfileListHolder port_if_prof_list = new PortInterfaceProfileListHolder(this.m_profile.interfaces);
        int index = CORBA_SeqUtil.find(port_if_prof_list, (equalFunctor)new find_interface(instance_name, polarity));
        this.m_profile.interfaces = port_if_prof_list.value;
        if (index >= 0) {
            return false;
        }
        PortInterfaceProfile prof = new PortInterfaceProfile(instance_name, type_name, polarity);
        CORBA_SeqUtil.push_back(port_if_prof_list, prof);
        this.m_profile.interfaces = port_if_prof_list.value;
        return true;
    }

    protected boolean deleteInterface(String instance_name, PortInterfacePolarity polarity) {
        PortInterfaceProfileListHolder port_if_prof_list = new PortInterfaceProfileListHolder(this.m_profile.interfaces);
        int index = CORBA_SeqUtil.find(port_if_prof_list, (equalFunctor)new find_interface(instance_name, polarity));
        this.m_profile.interfaces = port_if_prof_list.value;
        if (index < 0) {
            return false;
        }
        CORBA_SeqUtil.erase(port_if_prof_list, index);
        this.m_profile.interfaces = port_if_prof_list.value;
        return true;
    }

    protected void addProperty(String key, short value) {
        NVListHolder holder = new NVListHolder(this.m_profile.properties);
        CORBA_SeqUtil.push_back(holder, NVUtil.newNV(key, value));
        this.m_profile.properties = holder.value;
    }

    protected void addProperty(String key, long value) {
        NVListHolder holder = new NVListHolder(this.m_profile.properties);
        CORBA_SeqUtil.push_back(holder, NVUtil.newNV(key, value));
        this.m_profile.properties = holder.value;
    }

    protected void addProperty(String key, float value) {
        NVListHolder holder = new NVListHolder(this.m_profile.properties);
        CORBA_SeqUtil.push_back(holder, NVUtil.newNV(key, value));
        this.m_profile.properties = holder.value;
    }

    protected void addProperty(String key, double value) {
        NVListHolder holder = new NVListHolder(this.m_profile.properties);
        CORBA_SeqUtil.push_back(holder, NVUtil.newNV(key, value));
        this.m_profile.properties = holder.value;
    }

    protected void addProperty(String key, String value) {
        NVListHolder holder = new NVListHolder(this.m_profile.properties);
        CORBA_SeqUtil.push_back(holder, NVUtil.newNV(key, value));
        this.m_profile.properties = holder.value;
    }

    protected class find_conn_id
    implements equalFunctor {
        public String m_connector_id;

        public find_conn_id(String connector_id) {
            this.m_connector_id = connector_id;
        }

        public boolean equalof(Object elem) {
            return this.equalof((ConnectorProfile)elem);
        }

        public boolean equalof(ConnectorProfile cprof) {
            return this.m_connector_id.endsWith(cprof.connector_id);
        }
    }

    protected class find_port_ref
    implements equalFunctor {
        public Port m_port;

        public find_port_ref(Port port) {
            this.m_port = port;
        }

        public boolean equalof(Object elem) {
            return this.equalof((Port)elem);
        }

        public boolean equalof(Port port) {
            return this.m_port._is_equivalent(port);
        }
    }

    protected class connect_func
    implements operatorFunc {
        public Port m_port_ref;
        public ConnectorProfileHolder m_connector_profile;
        public ReturnCode_t m_return_code;

        public connect_func() {
        }

        public connect_func(Port p, ConnectorProfileHolder prof) {
            this.m_port_ref = p;
            this.m_connector_profile = prof;
            this.m_return_code = ReturnCode_t.RTC_OK;
        }

        public void operator(Object elem) {
            ReturnCode_t retval;
            if (!this.m_port_ref._is_equivalent((Port)elem) && (retval = ((Port)elem).notify_connect(this.m_connector_profile)) != ReturnCode_t.RTC_OK) {
                this.m_return_code = retval;
            }
        }
    }

    protected class disconnect_func
    implements operatorFunc {
        public Port m_port_ref;
        public ConnectorProfileHolder m_connector_profile;
        public ReturnCode_t m_return_code;

        public disconnect_func() {
            this.m_return_code = ReturnCode_t.RTC_OK;
        }

        public disconnect_func(Port p, ConnectorProfileHolder prof) {
            this.m_port_ref = p;
            this.m_connector_profile = prof;
            this.m_return_code = ReturnCode_t.RTC_OK;
        }

        public void operator(Object elem) {
            ReturnCode_t retval;
            if (!this.m_port_ref._is_equivalent((Port)elem) && (retval = ((Port)elem).disconnect(this.m_connector_profile.value.connector_id)) != ReturnCode_t.RTC_OK) {
                this.m_return_code = retval;
            }
        }
    }

    protected class disconnect_all_func
    implements operatorFunc {
        public ReturnCode_t m_return_code = ReturnCode_t.RTC_OK;
        public PortBase m_port;

        public disconnect_all_func(PortBase port) {
            this.m_port = port;
        }

        public void operator(Object elem) {
            this.operator((ConnectorProfile)elem);
        }

        public void operator(ConnectorProfile cprof) {
            ReturnCode_t retval = this.m_port.disconnect(cprof.connector_id);
            if (!retval.equals(ReturnCode_t.RTC_OK)) {
                this.m_return_code = retval;
            }
        }
    }

    protected class find_interface
    implements equalFunctor {
        private String m_instance_name;
        private PortInterfacePolarity m_polarity;

        public find_interface(String instance_name, PortInterfacePolarity polarity) {
            this.m_instance_name = instance_name;
            this.m_polarity = polarity;
        }

        public boolean equalof(Object elem) {
            return this.equalof((PortInterfaceProfile)elem);
        }

        public boolean equalof(PortInterfaceProfile prof) {
            return this.m_instance_name.equals(prof.instance_name) && this.m_polarity.equals(prof.polarity);
        }
    }
}

