/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

public class TimeValue {
    private long tv_sec;
    private long tv_usec;

    public TimeValue() {
        this.tv_sec = 0L;
        this.tv_usec = 0L;
    }

    public TimeValue(long sec, long usec) {
        this.tv_sec = sec;
        this.tv_usec = usec;
    }

    public TimeValue(TimeValue tm) {
        this.tv_sec = tm.tv_sec;
        this.tv_usec = tm.tv_usec;
    }

    public long getSec() {
        return this.tv_sec;
    }

    public long getUsec() {
        return this.tv_usec;
    }

    public TimeValue minus(TimeValue tm) {
        TimeValue res = new TimeValue();
        if (this.tv_sec >= tm.tv_sec) {
            if (this.tv_usec >= tm.tv_usec) {
                res.tv_sec = this.tv_sec - tm.tv_sec;
                res.tv_usec = this.tv_usec - tm.tv_usec;
            } else {
                res.tv_sec = this.tv_sec - tm.tv_sec - 1L;
                res.tv_usec = this.tv_usec + 1000000L - tm.tv_usec;
            }
        } else if (tm.tv_usec >= this.tv_usec) {
            res.tv_sec = -(tm.tv_sec - this.tv_sec);
            res.tv_usec = -(tm.tv_usec - this.tv_usec);
        } else {
            res.tv_sec = -(tm.tv_sec - this.tv_sec - 1L);
            res.tv_usec = -(tm.tv_usec + 1000000L) + this.tv_usec;
        }
        return res;
    }

    public TimeValue plus(TimeValue tm) {
        TimeValue res = new TimeValue();
        res.tv_sec = this.tv_sec + tm.tv_sec;
        res.tv_usec = this.tv_usec + tm.tv_usec;
        if (res.tv_usec > 1000000L) {
            ++res.tv_sec;
            res.tv_usec -= 1000000L;
        }
        return res;
    }

    public TimeValue convert(double time) {
        this.tv_sec = (long)time;
        this.tv_usec = (long)((time - (double)this.tv_sec) * 1000000.0);
        return this;
    }

    public double toDouble() {
        return (double)this.tv_sec + (double)this.tv_usec / 1000000.0;
    }
}

