/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import OpenRTM.ComponentObserver;
import OpenRTM.ComponentObserverHelper;
import OpenRTM.StatusKind;
import OpenRTM.StatusKindHolder;
import RTC.ConnectorProfile;
import RTC.PortProfile;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import _SDOPackage.ServiceProfile;
import java.lang.reflect.Method;
import jp.go.aist.rtm.RTC.ConfigurationParamListener;
import jp.go.aist.rtm.RTC.ConfigurationSetListener;
import jp.go.aist.rtm.RTC.ConfigurationSetNameListener;
import jp.go.aist.rtm.RTC.ExecutionContextActionListener;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.PortActionListener;
import jp.go.aist.rtm.RTC.PostComponentActionListener;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.SdoServiceConsumerBase;
import jp.go.aist.rtm.RTC.SdoServiceConsumerFactory;
import jp.go.aist.rtm.RTC.port.CorbaConsumer;
import jp.go.aist.rtm.RTC.port.PortConnectRetListener;
import jp.go.aist.rtm.RTC.util.CallbackFunction;
import jp.go.aist.rtm.RTC.util.DataRef;
import jp.go.aist.rtm.RTC.util.ListenerBase;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import jp.go.aist.rtm.RTC.util.TimeValue;
import jp.go.aist.rtm.RTC.util.Timer;

public class ComponentObserverConsumer
implements SdoServiceConsumerBase,
CallbackFunction,
ObjectCreator<SdoServiceConsumerBase>,
ObjectDestructor {
    private RTObject_impl m_rtobj = null;
    private ServiceProfile m_profile;
    private CorbaConsumer<ComponentObserver> m_observer = new CorbaConsumer<ComponentObserver>(ComponentObserver.class);
    private boolean[] m_observed = new boolean[6];
    private CompStatMsg m_compstat = new CompStatMsg(this);
    private PortAction m_portaction = new PortAction(this);
    private ECAction m_ecaction = new ECAction(this);
    private ConfigAction m_configMsg = new ConfigAction(this);
    private TimeValue m_interval = new TimeValue(0L, 100000L);
    private boolean m_heartbeat = false;
    private ListenerBase m_hblistenerid = null;
    private Timer m_timer = new Timer(this.m_interval);

    public ComponentObserverConsumer() {
        for (int i = 0; i < 6; ++i) {
            this.m_observed[i] = false;
        }
    }

    @Override
    public boolean init(RTObject_impl rTObject_impl, ServiceProfile serviceProfile) {
        if (!this.m_observer.setObject(ComponentObserverHelper.narrow(serviceProfile.service))) {
            return false;
        }
        this.m_rtobj = rTObject_impl;
        this.m_profile = serviceProfile;
        NVListHolder nVListHolder = new NVListHolder(serviceProfile.properties);
        Properties properties = new Properties();
        NVUtil.copyToProperties(properties, nVListHolder);
        this.setHeartbeat(properties);
        this.setListeners(properties);
        return true;
    }

    @Override
    public boolean reinit(ServiceProfile serviceProfile) {
        CorbaConsumer corbaConsumer;
        if (!this.m_observer._ptr()._is_equivalent(serviceProfile.service)) {
            corbaConsumer = new CorbaConsumer();
            if (!corbaConsumer.setObject(serviceProfile.service)) {
                return false;
            }
            this.m_observer.releaseObject();
            this.m_observer.setObject(serviceProfile.service);
        }
        this.m_profile = serviceProfile;
        corbaConsumer = new NVListHolder(serviceProfile.properties);
        Properties properties = new Properties();
        NVUtil.copyToProperties(properties, (NVListHolder)((Object)corbaConsumer));
        this.setHeartbeat(properties);
        this.setListeners(properties);
        return true;
    }

    @Override
    public final ServiceProfile getProfile() {
        return this.m_profile;
    }

    @Override
    public void finalize() {
        this.unsetComponentProfileListeners();
        this.unsetComponentStatusListeners();
        this.unsetPortProfileListeners();
        this.unsetExecutionContextListeners();
        this.unsetConfigurationListeners();
        this.unsetHeartbeat();
    }

    protected void updateStatus(StatusKind statusKind, String string) {
        try {
            this.m_observer._ptr().update_status(statusKind, string);
        }
        catch (Exception exception) {
            this.m_rtobj.removeSdoServiceConsumer(this.m_profile.id);
        }
    }

    protected final String toString(StatusKind statusKind) {
        StatusKindHolder statusKindHolder = new StatusKindHolder(statusKind);
        try {
            String string = statusKindHolder._type().member_name(statusKind.value());
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected void setListeners(Properties properties) {
        int n;
        if (properties.getProperty("observed_status").length() < 1) {
            properties.setProperty("observed_status", "ALL");
        }
        String[] stringArray = properties.getProperty("observed_status").split(",");
        boolean[] blArray = new boolean[6];
        StatusKindHolder statusKindHolder = new StatusKindHolder();
        for (n = 0; n < 6; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            stringArray[n] = stringArray[n].toUpperCase();
            for (n2 = 0; n2 < 6; ++n2) {
                try {
                    if (!stringArray[n].equals(statusKindHolder._type().member_name(n2))) continue;
                    blArray[n2] = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!stringArray[n].equals("ALL")) continue;
            for (n2 = 0; n2 < 6; ++n2) {
                blArray[n2] = true;
            }
            break;
        }
        DataRef<Boolean> dataRef = new DataRef<Boolean>(new Boolean(true));
        dataRef.v = new Boolean(this.m_observed[0]);
        this.switchListeners(blArray[0], dataRef, this, "setComponentProfileListeners", "unsetComponentProfileListeners");
        this.m_observed[0] = (Boolean)dataRef.v;
        dataRef.v = new Boolean(this.m_observed[1]);
        this.switchListeners(blArray[1], dataRef, this, "setComponentStatusListeners", "unsetComponentStatusListeners");
        this.m_observed[1] = (Boolean)dataRef.v;
        dataRef.v = new Boolean(this.m_observed[2]);
        this.switchListeners(blArray[2], dataRef, this, "setExecutionContextListeners", "unsetExecutionContextListeners");
        this.m_observed[2] = (Boolean)dataRef.v;
        dataRef.v = new Boolean(this.m_observed[3]);
        this.switchListeners(blArray[3], dataRef, this, "setPortProfileListeners", "unsetPortProfileListeners");
        this.m_observed[3] = (Boolean)dataRef.v;
        dataRef.v = new Boolean(this.m_observed[4]);
        this.switchListeners(blArray[4], dataRef, this, "setConfigurationListeners", "unsetConfigurationListeners");
        this.m_observed[4] = (Boolean)dataRef.v;
    }

    protected <DataType> void switchListeners(boolean bl, DataRef<Boolean> dataRef, DataType DataType, String string, String string2) {
        if (!((Boolean)dataRef.v).booleanValue() && bl) {
            try {
                Class<?> clazz = DataType.getClass();
                Method method = clazz.getDeclaredMethod(string, null);
                method.invoke(DataType, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataRef.v = new Boolean(true);
        } else if (((Boolean)dataRef.v).booleanValue() && !bl) {
            try {
                Class<?> clazz = DataType.getClass();
                Method method = clazz.getDeclaredMethod(string2, null);
                method.invoke(DataType, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataRef.v = new Boolean(false);
        }
    }

    @Override
    public void doOperate() {
        this.updateStatus(StatusKind.from_int(5), "");
    }

    protected void setHeartbeat(Properties properties) {
        if (StringUtil.toBool(properties.getProperty("heartbeat.enable"), "YES", "NO", false)) {
            String string = properties.getProperty("heartbeat.interval");
            if (string.length() < 1) {
                this.m_interval.convert(1.0);
            } else {
                this.m_interval.convert(Double.parseDouble(string));
            }
            TimeValue timeValue = this.m_interval;
            this.m_hblistenerid = this.m_timer.registerListenerObj(this, timeValue);
            this.m_timer.start();
        } else if (this.m_heartbeat && this.m_hblistenerid != null) {
            this.unsetHeartbeat();
            this.m_timer.stop();
        }
    }

    protected void unsetHeartbeat() {
        this.m_timer.unregisterListener(this.m_hblistenerid);
        this.m_heartbeat = false;
        this.m_hblistenerid = null;
        this.m_timer.stop();
    }

    protected void setComponentStatusListeners() {
        if (this.m_compstat.activatedListener == null) {
            this.m_compstat.activatedListener = this.m_rtobj.addPostComponentActionListener(4, this.m_compstat, "onActivated");
        }
        if (this.m_compstat.deactivatedListener == null) {
            this.m_compstat.deactivatedListener = this.m_rtobj.addPostComponentActionListener(5, this.m_compstat, "onDeactivated");
        }
        if (this.m_compstat.resetListener == null) {
            this.m_compstat.resetListener = this.m_rtobj.addPostComponentActionListener(8, this.m_compstat, "onReset");
        }
        if (this.m_compstat.abortingListener == null) {
            this.m_compstat.abortingListener = this.m_rtobj.addPostComponentActionListener(6, this.m_compstat, "onAborting");
        }
        if (this.m_compstat.finalizeListener == null) {
            this.m_compstat.finalizeListener = this.m_rtobj.addPostComponentActionListener(1, this.m_compstat, "onFinalize");
        }
    }

    protected void unsetComponentStatusListeners() {
        if (this.m_compstat.activatedListener != null) {
            this.m_rtobj.removePostComponentActionListener(4, this.m_compstat.activatedListener);
            this.m_compstat.activatedListener = null;
        }
        if (this.m_compstat.deactivatedListener != null) {
            this.m_rtobj.removePostComponentActionListener(5, this.m_compstat.deactivatedListener);
            this.m_compstat.deactivatedListener = null;
        }
        if (this.m_compstat.resetListener != null) {
            this.m_rtobj.removePostComponentActionListener(8, this.m_compstat.resetListener);
            this.m_compstat.resetListener = null;
        }
        if (this.m_compstat.abortingListener != null) {
            this.m_rtobj.removePostComponentActionListener(6, this.m_compstat.abortingListener);
            this.m_compstat.abortingListener = null;
        }
        if (this.m_compstat.finalizeListener != null) {
            this.m_rtobj.removePostComponentActionListener(1, this.m_compstat.finalizeListener);
            this.m_compstat.finalizeListener = null;
        }
    }

    protected void setPortProfileListeners() {
        if (this.m_portaction.portAddListener == null) {
            this.m_portaction.portAddListener = this.m_rtobj.addPortActionListener(0, this.m_portaction, "onAddPort");
        }
        if (this.m_portaction.portRemoveListener == null) {
            this.m_portaction.portRemoveListener = this.m_rtobj.addPortActionListener(1, this.m_portaction, "onRemovePort");
        }
        if (this.m_portaction.portConnectListener == null) {
            this.m_portaction.portConnectListener = this.m_rtobj.addPortConnectRetListener(3, this.m_portaction, "onConnect");
        }
        if (this.m_portaction.portDisconnectListener == null) {
            this.m_portaction.portDisconnectListener = this.m_rtobj.addPortConnectRetListener(5, this.m_portaction, "onDisconnect");
        }
    }

    protected void unsetPortProfileListeners() {
        if (this.m_portaction.portAddListener != null) {
            this.m_rtobj.removePortActionListener(0, this.m_portaction.portAddListener);
            this.m_portaction.portAddListener = null;
        }
        if (this.m_portaction.portRemoveListener != null) {
            this.m_rtobj.removePortActionListener(1, this.m_portaction.portRemoveListener);
            this.m_portaction.portRemoveListener = null;
        }
        if (this.m_portaction.portConnectListener != null) {
            this.m_rtobj.removePortConnectRetListener(3, this.m_portaction.portConnectListener);
            this.m_portaction.portConnectListener = null;
        }
        if (this.m_portaction.portDisconnectListener != null) {
            this.m_rtobj.removePortConnectRetListener(5, this.m_portaction.portDisconnectListener);
            this.m_portaction.portDisconnectListener = null;
        }
    }

    protected void setExecutionContextListeners() {
        if (this.m_ecaction.ecAttached == null) {
            this.m_ecaction.ecAttached = this.m_rtobj.addExecutionContextActionListener(0, this.m_ecaction, "onAttached");
        }
        if (this.m_ecaction.ecDetached == null) {
            this.m_ecaction.ecDetached = this.m_rtobj.addExecutionContextActionListener(1, this.m_ecaction, "onDetached");
        }
        if (this.m_ecaction.ecRatechanged == null) {
            this.m_ecaction.ecRatechanged = this.m_rtobj.addPostComponentActionListener(11, this.m_ecaction, "onRateChanged");
        }
        if (this.m_ecaction.ecStartup == null) {
            this.m_ecaction.ecStartup = this.m_rtobj.addPostComponentActionListener(2, this.m_ecaction, "onStartup");
        }
        if (this.m_ecaction.ecShutdown == null) {
            this.m_ecaction.ecShutdown = this.m_rtobj.addPostComponentActionListener(3, this.m_ecaction, "onShutdown");
        }
    }

    protected void unsetExecutionContextListeners() {
        if (this.m_ecaction.ecAttached != null) {
            this.m_rtobj.removeExecutionContextActionListener(0, this.m_ecaction.ecAttached);
        }
        if (this.m_ecaction.ecDetached != null) {
            this.m_rtobj.removeExecutionContextActionListener(0, this.m_ecaction.ecDetached);
        }
        if (this.m_ecaction.ecRatechanged != null) {
            this.m_rtobj.removePostComponentActionListener(11, this.m_ecaction.ecRatechanged);
        }
        if (this.m_ecaction.ecStartup != null) {
            this.m_rtobj.removePostComponentActionListener(2, this.m_ecaction.ecStartup);
        }
        if (this.m_ecaction.ecShutdown != null) {
            this.m_rtobj.removePostComponentActionListener(3, this.m_ecaction.ecShutdown);
        }
    }

    protected void setComponentProfileListeners() {
    }

    protected void unsetComponentProfileListeners() {
    }

    protected void setConfigurationListeners() {
        this.m_configMsg.updateConfigParamListener = this.m_rtobj.addConfigurationParamListener(0, this.m_configMsg, "updateConfigParam");
        this.m_configMsg.setConfigSetListener = this.m_rtobj.addConfigurationSetListener(0, this.m_configMsg, "setConfigSet");
        this.m_configMsg.addConfigSetListener = this.m_rtobj.addConfigurationSetListener(1, this.m_configMsg, "addConfigSet");
        this.m_configMsg.updateConfigSetListener = this.m_rtobj.addConfigurationSetNameListener(0, this.m_configMsg, "updateConfigSet");
        this.m_configMsg.removeConfigSetListener = this.m_rtobj.addConfigurationSetNameListener(1, this.m_configMsg, "removeConfigSet");
        this.m_configMsg.activateConfigSetListener = this.m_rtobj.addConfigurationSetNameListener(2, this.m_configMsg, "activateConfigSet");
    }

    protected void unsetConfigurationListeners() {
        if (this.m_configMsg.updateConfigParamListener != null) {
            this.m_rtobj.removeConfigurationParamListener(0, this.m_configMsg.updateConfigParamListener);
            this.m_configMsg.updateConfigParamListener = null;
        }
        if (this.m_configMsg.setConfigSetListener != null) {
            this.m_rtobj.removeConfigurationSetListener(0, this.m_configMsg.setConfigSetListener);
            this.m_configMsg.setConfigSetListener = null;
        }
        if (this.m_configMsg.addConfigSetListener != null) {
            this.m_rtobj.removeConfigurationSetListener(1, this.m_configMsg.addConfigSetListener);
            this.m_configMsg.addConfigSetListener = null;
        }
        if (this.m_configMsg.updateConfigSetListener != null) {
            this.m_rtobj.removeConfigurationSetNameListener(0, this.m_configMsg.updateConfigSetListener);
            this.m_configMsg.updateConfigSetListener = null;
        }
        if (this.m_configMsg.removeConfigSetListener != null) {
            this.m_rtobj.removeConfigurationSetNameListener(1, this.m_configMsg.removeConfigSetListener);
            this.m_configMsg.removeConfigSetListener = null;
        }
        if (this.m_configMsg.activateConfigSetListener != null) {
            this.m_rtobj.removeConfigurationSetNameListener(2, this.m_configMsg.activateConfigSetListener);
            this.m_configMsg.activateConfigSetListener = null;
        }
    }

    @Override
    public SdoServiceConsumerBase creator_() {
        return new ComponentObserverConsumer();
    }

    @Override
    public void destructor_(Object object) {
        object = null;
    }

    public static void ComponentObserverConsumerInit() {
        SdoServiceConsumerFactory sdoServiceConsumerFactory = SdoServiceConsumerFactory.instance();
        sdoServiceConsumerFactory.addFactory(ComponentObserverHelper.id(), new ComponentObserverConsumer(), new ComponentObserverConsumer());
    }

    private class ConfigAction {
        public ConfigurationParamListener updateConfigParamListener = null;
        public ConfigurationSetListener setConfigSetListener = null;
        public ConfigurationSetListener addConfigSetListener = null;
        public ConfigurationSetNameListener updateConfigSetListener = null;
        public ConfigurationSetNameListener removeConfigSetListener = null;
        public ConfigurationSetNameListener activateConfigSetListener = null;
        private ComponentObserverConsumer m_coc;

        public ConfigAction(ComponentObserverConsumer componentObserverConsumer2) {
            this.m_coc = componentObserverConsumer2;
        }

        public void updateConfigParam(String string, String string2) {
            String string3 = "UPDATE_CONFIG_PARAM: ";
            string3 = string3 + string;
            string3 = string3 + ".";
            string3 = string3 + string2;
            this.m_coc.updateStatus(StatusKind.from_int(4), string3);
        }

        public void setConfigSet(Properties properties) {
            String string = "SET_CONFIG_SET: ";
            string = string + properties.getName();
            this.m_coc.updateStatus(StatusKind.from_int(4), string);
        }

        public void addConfigSet(Properties properties) {
            String string = "ADD_CONFIG_SET: ";
            string = string + properties.getName();
            this.m_coc.updateStatus(StatusKind.from_int(4), string);
        }

        public void updateConfigSet(String string) {
            String string2 = "UPDATE_CONFIG_SET: ";
            string2 = string2 + string;
            this.m_coc.updateStatus(StatusKind.from_int(4), string2);
        }

        public void removeConfigSet(String string) {
            String string2 = "REMOVE_CONFIG_SET: ";
            string2 = string2 + string;
            this.m_coc.updateStatus(StatusKind.from_int(4), string2);
        }

        public void activateConfigSet(String string) {
            String string2 = "ACTIVATE_CONFIG_SET: ";
            string2 = string2 + string;
            this.m_coc.updateStatus(StatusKind.from_int(4), string2);
        }
    }

    private class ECAction {
        public ExecutionContextActionListener ecAttached = null;
        public ExecutionContextActionListener ecDetached = null;
        public PostComponentActionListener ecRatechanged = null;
        public PostComponentActionListener ecStartup = null;
        public PostComponentActionListener ecShutdown = null;
        private ComponentObserverConsumer m_coc;

        public ECAction(ComponentObserverConsumer componentObserverConsumer2) {
            this.m_coc = componentObserverConsumer2;
        }

        public void onGeneric(String string, int n) {
            String string2 = string + n;
            this.m_coc.updateStatus(StatusKind.from_int(2), string2);
        }

        public void onAttached(int n) {
            this.onGeneric("ATTACHED:", n);
        }

        public void onDetached(int n) {
            this.onGeneric("DETACHED:", n);
        }

        public void onRateChanged(int n, ReturnCode_t returnCode_t) {
            if (returnCode_t == ReturnCode_t.RTC_OK) {
                this.onGeneric("RATE_CHANGED:", n);
            }
        }

        public void onStartup(int n, ReturnCode_t returnCode_t) {
            if (returnCode_t == ReturnCode_t.RTC_OK) {
                this.onGeneric("STARTUP:", n);
            }
        }

        public void onShutdown(int n, ReturnCode_t returnCode_t) {
            if (returnCode_t == ReturnCode_t.RTC_OK) {
                this.onGeneric("SHUTDOWN:", n);
            }
        }
    }

    private class PortAction {
        public PortActionListener portAddListener = null;
        public PortActionListener portRemoveListener = null;
        public PortConnectRetListener portConnectListener = null;
        public PortConnectRetListener portDisconnectListener = null;
        private ComponentObserverConsumer m_coc;

        public PortAction(ComponentObserverConsumer componentObserverConsumer2) {
            this.m_coc = componentObserverConsumer2;
        }

        public void onGeneric(String string, String string2) {
            String string3 = string;
            string3 = string3 + string2;
            this.m_coc.updateStatus(StatusKind.from_int(3), string3);
        }

        public void onAddPort(PortProfile portProfile) {
            this.onGeneric("ADD:", portProfile.name);
        }

        public void onRemovePort(PortProfile portProfile) {
            this.onGeneric("REMOVE:", portProfile.name);
        }

        public void onConnect(String string, ConnectorProfile connectorProfile, ReturnCode_t returnCode_t) {
            if (returnCode_t == ReturnCode_t.RTC_OK) {
                this.onGeneric("CONNECT:", string);
            }
        }

        public void onDisconnect(String string, ConnectorProfile connectorProfile, ReturnCode_t returnCode_t) {
            if (returnCode_t == ReturnCode_t.RTC_OK) {
                this.onGeneric("DISCONNECT:", string);
            }
        }
    }

    private class CompStatMsg {
        public PostComponentActionListener activatedListener = null;
        public PostComponentActionListener deactivatedListener = null;
        public PostComponentActionListener resetListener = null;
        public PostComponentActionListener abortingListener = null;
        public PostComponentActionListener finalizeListener = null;
        private ComponentObserverConsumer m_coc;

        public CompStatMsg(ComponentObserverConsumer componentObserverConsumer2) {
            this.m_coc = componentObserverConsumer2;
        }

        public void onGeneric(String string, int n, ReturnCode_t returnCode_t) {
            if (returnCode_t == ReturnCode_t.RTC_OK) {
                String string2 = string;
                string2 = string2 + n;
                this.m_coc.updateStatus(StatusKind.from_int(1), string2);
            }
        }

        public void onActivated(int n, ReturnCode_t returnCode_t) {
            this.onGeneric("ACTIVE:", n, returnCode_t);
        }

        public void onDeactivated(int n, ReturnCode_t returnCode_t) {
            this.onGeneric("INACTIVE:", n, returnCode_t);
        }

        public void onReset(int n, ReturnCode_t returnCode_t) {
            this.onGeneric("INACTIVE:", n, returnCode_t);
        }

        public void onAborting(int n, ReturnCode_t returnCode_t) {
            this.onGeneric("ERROR:", n, returnCode_t);
        }

        public void onFinalize(int n, ReturnCode_t returnCode_t) {
            this.onGeneric("FINALIZE:", n, returnCode_t);
        }
    }
}

