/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.Iterator;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Config;
import jp.go.aist.rtm.RTC.ConfigBase;
import jp.go.aist.rtm.RTC.ConfigurationListeners;
import jp.go.aist.rtm.RTC.ConfigurationParamListener;
import jp.go.aist.rtm.RTC.ConfigurationSetListener;
import jp.go.aist.rtm.RTC.ConfigurationSetNameListener;
import jp.go.aist.rtm.RTC.find_conf;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.ValueHolder;

public class ConfigAdmin {
    private Properties m_configsets = new Properties();
    private Properties m_emptyconf = new Properties();
    private Vector<ConfigBase> m_params = new Vector();
    private String m_activeId = new String();
    private boolean m_active;
    private boolean m_changed;
    private Vector<String> m_newConfig = new Vector();
    private ConfigurationListeners m_listeners = new ConfigurationListeners();

    public ConfigAdmin(Properties properties) {
        this.m_configsets = properties;
        this.m_activeId = "default";
        this.m_active = true;
        this.m_changed = false;
    }

    public void destruct() {
        for (int i = 0; i < this.m_params.size(); ++i) {
            if (this.m_params.elementAt(i) == null) continue;
            this.m_params.setElementAt(null, i);
        }
        this.m_params.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public boolean bindParameter(String string, ValueHolder valueHolder, String string2) {
        if (this.isExist(string)) {
            return false;
        }
        try {
            valueHolder.stringFrom(string2);
        }
        catch (Exception exception) {
            return false;
        }
        this.m_params.add(new Config(string, valueHolder, string2));
        return true;
    }

    public void update(String string) {
        if (this.m_configsets.hasKey(string) == null) {
            return;
        }
        Properties properties = new Properties(this.m_configsets.getNode(string));
        for (int i = 0; i < this.m_params.size(); ++i) {
            if (properties.hasKey(this.m_params.elementAt((int)i).name) == null) continue;
            this.m_params.elementAt(i).update(properties.getProperty(this.m_params.elementAt((int)i).name));
            this.onUpdate(string);
        }
    }

    public void update() {
        if (this.m_changed && this.m_active) {
            this.update(this.m_activeId);
            this.m_changed = false;
        }
    }

    public void update(String string, String string2) {
        String string3 = string + "." + string2;
        for (ConfigBase configBase : this.m_params) {
            if (!new find_conf(string2).equalof(configBase)) continue;
            configBase.update(this.m_configsets.getProperty(string3));
            this.onUpdateParam(string, string2);
            return;
        }
    }

    public boolean isExist(String string) {
        Iterator<ConfigBase> iterator = this.m_params.iterator();
        while (iterator.hasNext()) {
            if (!new find_conf(string).equalof(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public final String getActiveId() {
        return this.m_activeId;
    }

    public final boolean haveConfig(String string) {
        return this.m_configsets.hasKey(string) != null;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public final Vector<Properties> getConfigurationSets() {
        return this.m_configsets.getLeaf();
    }

    public final Properties getConfigurationSet(String string) {
        Properties properties = new Properties(this.m_configsets.getNode(string));
        if (properties == null) {
            return this.m_emptyconf;
        }
        return properties;
    }

    public boolean setConfigurationSetValues(String string, Properties properties) {
        if (!string.equals(properties.getName())) {
            return false;
        }
        if (this.m_configsets.hasKey(string) == null) {
            return false;
        }
        this.m_configsets.getNode(string).merge(properties);
        this.m_changed = true;
        this.m_active = true;
        this.onSetConfigurationSet(properties);
        return true;
    }

    public final Properties getActiveConfigurationSet() {
        Properties properties = this.m_configsets.getNode(this.m_activeId);
        if (properties == null) {
            return this.m_emptyconf;
        }
        Properties properties2 = new Properties(properties);
        if (properties2 == null) {
            return this.m_emptyconf;
        }
        return properties2;
    }

    public boolean addConfigurationSet(Properties properties) {
        if (this.m_configsets.hasKey(properties.getName()) != null) {
            return false;
        }
        String string = properties.getName();
        this.m_configsets.createNode(string);
        this.m_configsets.getNode(string).merge(properties);
        this.m_newConfig.add(string);
        this.m_changed = true;
        this.m_active = false;
        this.onAddConfigurationSet(properties);
        return true;
    }

    public boolean removeConfigurationSet(String string) {
        if (string.equals("default")) {
            return false;
        }
        if (this.m_activeId.equals(string)) {
            return false;
        }
        for (int i = 0; i < this.m_newConfig.size(); ++i) {
            if (!this.m_newConfig.elementAt(i).equals(string)) continue;
            Properties properties = new Properties(this.m_configsets.getNode(string));
            if (properties != null) {
                this.m_configsets.removeNode(properties.getName());
            }
            this.m_newConfig.remove(i);
            this.m_changed = true;
            this.m_active = false;
            this.onRemoveConfigurationSet(string);
            return true;
        }
        return false;
    }

    public boolean activateConfigurationSet(String string) {
        if (string == null) {
            return false;
        }
        if (string.charAt(0) == '_') {
            return false;
        }
        if (this.m_configsets.hasKey(string) == null) {
            return false;
        }
        this.m_activeId = string;
        this.m_active = true;
        this.m_changed = true;
        this.onActivateSet(string);
        return true;
    }

    public void setOnUpdate(ConfigurationSetNameListener configurationSetNameListener) {
        System.err.println("setOnUpdate function is obsolete.");
        System.err.println("Use addConfigurationSetNameListener instead.");
        this.m_listeners.configsetname_[0].addObserver(configurationSetNameListener);
    }

    public void setOnUpdateParam(ConfigurationParamListener configurationParamListener) {
        System.err.println("setOnUpdateParam function is obsolete.");
        System.err.println("Use addConfigurationParamListener instead.");
        this.m_listeners.configparam_[0].addObserver(configurationParamListener);
    }

    public void setOnSetConfigurationSet(ConfigurationSetListener configurationSetListener) {
        System.err.println("setOnSetConfigurationSet function is obsolete.");
        System.err.println("Use addConfigurationSetListener instead.");
        this.m_listeners.configset_[0].addObserver(configurationSetListener);
    }

    public void setOnAddConfigurationSet(ConfigurationSetListener configurationSetListener) {
        System.err.println("setOnAddConfigurationSet function is obsolete.");
        System.err.println("Use addConfigurationSetListener instead.");
        this.m_listeners.configset_[1].addObserver(configurationSetListener);
    }

    public void setOnRemoveConfigurationSet(ConfigurationSetNameListener configurationSetNameListener) {
        System.err.println("setOnRemoveConfigurationSet function is obsolete.");
        System.err.println("Use addConfigurationSetNameListener instead.");
        this.m_listeners.configsetname_[1].addObserver(configurationSetNameListener);
    }

    public void setOnActivateSet(ConfigurationSetNameListener configurationSetNameListener) {
        System.err.println("setOnActivateSet function is obsolete.");
        System.err.println("Use addConfigurationSetNameListener instead.");
        this.m_listeners.configsetname_[2].addObserver(configurationSetNameListener);
    }

    public void onUpdate(String string) {
        this.m_listeners.configsetname_[0].notify(string);
    }

    public void onUpdateParam(String string, String string2) {
        this.m_listeners.configparam_[0].notify(string, string2);
    }

    public void onSetConfigurationSet(Properties properties) {
        this.m_listeners.configset_[0].notify(properties);
    }

    public void onAddConfigurationSet(Properties properties) {
        this.m_listeners.configset_[1].notify(properties);
    }

    public void onRemoveConfigurationSet(String string) {
        this.m_listeners.configsetname_[1].notify(string);
    }

    public void onActivateSet(String string) {
        this.m_listeners.configsetname_[2].notify(string);
    }

    public void addConfigurationParamListener(int n, ConfigurationParamListener configurationParamListener, boolean bl) {
        if (n < 1) {
            this.m_listeners.configparam_[n].addObserver(configurationParamListener);
            return;
        }
    }

    public void addConfigurationParamListener(int n, ConfigurationParamListener configurationParamListener) {
        this.addConfigurationParamListener(n, configurationParamListener, true);
    }

    public void removeConfigurationParamListener(int n, ConfigurationParamListener configurationParamListener) {
        if (n < 1) {
            this.m_listeners.configparam_[n].deleteObserver(configurationParamListener);
            return;
        }
    }

    public void addConfigurationSetListener(int n, ConfigurationSetListener configurationSetListener, boolean bl) {
        if (n < 2) {
            this.m_listeners.configset_[n].addObserver(configurationSetListener);
            return;
        }
    }

    public void addConfigurationSetListener(int n, ConfigurationSetListener configurationSetListener) {
        this.addConfigurationSetListener(n, configurationSetListener, true);
    }

    public void removeConfigurationSetListener(int n, ConfigurationSetListener configurationSetListener) {
        if (n < 2) {
            this.m_listeners.configset_[n].deleteObserver(configurationSetListener);
            return;
        }
    }

    public void addConfigurationSetNameListener(int n, ConfigurationSetNameListener configurationSetNameListener, boolean bl) {
        if (n < 3) {
            this.m_listeners.configsetname_[n].addObserver(configurationSetNameListener);
            return;
        }
    }

    public void addConfigurationSetNameListener(int n, ConfigurationSetNameListener configurationSetNameListener) {
        this.addConfigurationSetNameListener(n, configurationSetNameListener, true);
    }

    public void removeConfigurationSetNameListener(int n, ConfigurationSetNameListener configurationSetNameListener) {
        if (n < 3) {
            this.m_listeners.configsetname_[n].deleteObserver(configurationSetNameListener);
            return;
        }
    }

    private ConfigAdmin(ConfigAdmin configAdmin) {
        this.m_configsets = configAdmin.m_configsets;
    }
}

