/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;
import jp.go.aist.rtm.RTC.DefaultConfiguration;
import jp.go.aist.rtm.RTC.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class ManagerConfig {
    public static final String[] CONFIG_FILE_PATH = new String[]{"./rtc.conf", "/etc/rtc.conf", "/etc/rtc/rtc.conf", "/usr/local/etc/rtc.conf", "/usr/local/etc/rtc/rtc.conf", null};
    public static final String CONFIG_FILE_ENV = "RTC_MANAGER_CONFIG";
    protected String m_configFile;
    protected boolean m_isMaster = false;
    protected Properties m_argprop = new Properties();

    public ManagerConfig() {
    }

    public ManagerConfig(String[] stringArray) throws Exception {
        this.init(stringArray);
    }

    public void init(String[] stringArray) throws Exception {
        this.parseArgs(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Properties properties) throws FileNotFoundException, IOException {
        properties.setDefaults(DefaultConfiguration.default_config);
        if (this.findConfigFile()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(this.m_configFile));
                properties.load(bufferedReader);
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        this.setSystemInformation(properties);
        if (this.m_isMaster) {
            properties.setProperty("manager.is_master", "YES");
        }
        properties.merge(this.m_argprop);
    }

    protected void parseArgs(String[] stringArray) throws IllegalArgumentException {
        int n;
        Object object;
        Options options = new Options();
        options.addOption("a", false, "create manager's corba service or not");
        options.addOption("f", true, "configuration file");
        options.addOption("l", true, "load module");
        options.addOption("o", true, "other options");
        options.addOption("p", true, "multiple endpoint options");
        options.addOption("d", false, "use default configuration");
        CommandLine commandLine = null;
        try {
            object = new BasicParser();
            commandLine = object.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Could not parse arguments.");
        }
        if (commandLine.hasOption("a")) {
            this.m_argprop.setProperty("manager.corba_servant", "NO");
        }
        if (commandLine.hasOption("f")) {
            this.m_configFile = commandLine.getOptionValue("f").trim();
        }
        if (commandLine.hasOption("l")) {
            // empty if block
        }
        if (commandLine.hasOption("o") && (n = ((String)(object = commandLine.getOptionValue("o").trim())).indexOf(":")) >= 0) {
            this.m_argprop.setProperty(((String)object).substring(0, n), ((String)object).substring(n + 1));
        }
        if (commandLine.hasOption("p")) {
            object = commandLine.getOptionValue("p").trim();
            try {
                n = Integer.parseInt((String)object);
                String string = ":";
                string = string + (String)object;
                this.m_argprop.setProperty("corba.endpoints", string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (commandLine.hasOption("d")) {
            this.m_isMaster = true;
        }
    }

    protected boolean findConfigFile() {
        if (this.m_configFile != null && this.m_configFile.length() != 0 && this.fileExist(this.m_configFile)) {
            return true;
        }
        String string = System.getenv(CONFIG_FILE_ENV);
        if (string != null && this.fileExist(string)) {
            this.m_configFile = string;
            return true;
        }
        int n = 0;
        while (CONFIG_FILE_PATH[n] != null) {
            if (this.fileExist(CONFIG_FILE_PATH[n])) {
                this.m_configFile = CONFIG_FILE_PATH[n];
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void setSystemInformation(Properties properties) {
        String string = "UNKNOWN";
        String string2 = "UNKNOWN";
        String string3 = "UNKNOWN";
        String string4 = "UNKNOWN";
        String string5 = "UNKNOWN";
        String string6 = "UNKNOWN";
        try {
            java.util.Properties properties2 = System.getProperties();
            string = properties2.getProperty("os.name");
            string3 = properties2.getProperty("os.version");
            string4 = properties2.getProperty("os.arch");
            string6 = System.getProperty("java.version") + new Random().nextInt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string5 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        properties.setProperty("os.name", string);
        properties.setProperty("os.release", string2);
        properties.setProperty("os.version", string3);
        properties.setProperty("os.arch", string4);
        properties.setProperty("os.hostname", string5);
        properties.setProperty("manager.pid", string6);
    }

    protected boolean fileExist(String string) {
        return new File(string).exists();
    }
}

