/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import RTC.ComponentProfile;
import RTC.ComponentProfileListHolder;
import RTC.RTCListHolder;
import RTC.RTObject;
import RTC.ReturnCode_t;
import RTM.ManagerHelper;
import RTM.ManagerListHolder;
import RTM.ManagerPOA;
import RTM.ManagerProfile;
import RTM.ModuleProfile;
import RTM.ModuleProfileListHolder;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import com.sun.corba.se.impl.orb.ORBImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.Servant;

public class ManagerServant
extends ManagerPOA {
    private Manager m_mgr;
    private RTM.Manager m_objref;
    protected Logbuf rtcout;
    private boolean m_isMaster;
    private String m_masterMutex = new String();
    private RTM.Manager[] m_masters = new RTM.Manager[1];
    private String m_slaveMutex = new String();
    private RTM.Manager[] m_slaves = new RTM.Manager[1];

    public ManagerServant() {
        this.rtcout = new Logbuf("ManagerServant");
        this.m_mgr = Manager.instance();
        Properties properties = this.m_mgr.getConfig();
        if (StringUtil.toBool(properties.getProperty("manager.is_master"), "YES", "NO", true)) {
            this.rtcout.println(2, "This manager is master.");
            try {
                this.m_mgr.getPOA().activate_object((Servant)this);
                ORBImpl oRBImpl = (ORBImpl)this.m_mgr.getORB();
                oRBImpl.register_initial_reference("manager", this.m_mgr.getPOA().servant_to_reference((Servant)this));
            }
            catch (Exception exception) {
                this.rtcout.println(5, "Manager CORBA servant creation failed." + exception);
                return;
            }
            if (!this.createINSManager()) {
                this.rtcout.println(5, "Manager CORBA servant creation failed.");
                return;
            }
            this.m_isMaster = true;
            this.rtcout.println(5, "Manager CORBA servant was successfully created.");
            return;
        }
        this.rtcout.println(2, "This manager is slave.");
        try {
            RTM.Manager manager = this.findManager(properties.getProperty("corba.master_manager"));
            if (manager == null) {
                this.rtcout.println(4, "Master manager not found.");
                return;
            }
            try {
                this.m_mgr.getPOA().activate_object((Servant)this);
                ORBImpl oRBImpl = (ORBImpl)this.m_mgr.getORB();
                oRBImpl.register_initial_reference("manager", this.m_mgr.getPOA().servant_to_reference((Servant)this));
            }
            catch (Exception exception) {
                this.rtcout.println(5, "Manager CORBA servant creation failed." + exception);
                return;
            }
            if (!this.createINSManager()) {
                this.rtcout.println(5, "Manager CORBA servant creation failed.");
                return;
            }
            this.add_master_manager(manager);
            manager.add_slave_manager(this.m_objref);
            return;
        }
        catch (Exception exception) {
            this.rtcout.println(6, "Unknown exception caught.");
            return;
        }
    }

    @Override
    public RTM.Manager _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = ManagerHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.m_objref;
    }

    public boolean createINSManager() {
        this.rtcout.println(3, "createINSManager()");
        try {
            this.rtcout.println(3, "gets object.");
            Object object = this.m_mgr.getORB().resolve_initial_references("manager");
            this.m_objref = ManagerHelper.narrow(object);
        }
        catch (Exception exception) {
            this.rtcout.println(5, "Manager CORBA servant creation failed." + exception);
            return false;
        }
        return true;
    }

    public RTM.Manager findManager(String string) {
        this.rtcout.println(2, "findManager(host_port = " + string + ")");
        try {
            Properties properties = this.m_mgr.getConfig();
            String string2 = properties.getProperty("manager.name");
            String string3 = "corbaloc:iiop:1.2@" + string + "/" + string2;
            this.rtcout.println(3, "corbaloc: " + string3);
            ORB oRB = ORBUtil.getOrb();
            Object object = oRB.string_to_object(string3);
            RTM.Manager manager = ManagerHelper.narrow(object);
            String string4 = oRB.object_to_string(object);
            this.rtcout.println(3, "Manager's IOR information: " + string4);
            return manager;
        }
        catch (SystemException systemException) {
            this.rtcout.println(3, "CORBA SystemException caught (CORBA." + systemException.toString() + ")");
            return null;
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Unknown exception caught.");
            return null;
        }
    }

    @Override
    public ReturnCode_t load_module(String string, String string2) {
        this.rtcout.println(2, "ManagerServant.load_module(" + string + ", " + string2 + ")");
        this.m_mgr.load(string, string2);
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t unload_module(String string) {
        this.rtcout.println(2, "ManagerServant.unload_module(" + string + ")");
        try {
            this.m_mgr.unload(string);
        }
        catch (Exception exception) {
            this.rtcout.println(5, "Exception caught.Not Found:" + string + " " + exception.toString());
        }
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ModuleProfile[] get_loadable_modules() {
        this.rtcout.println(2, "get_loadable_modules()");
        Vector<Properties> vector = this.m_mgr.getLoadableModules();
        ModuleProfile[] moduleProfileArray = new ModuleProfile[vector.size()];
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = new String();
            string = vector.elementAt(i)._dump(string, vector.elementAt(i), 0);
            this.rtcout.println(1, string);
            NVListHolder nVListHolder = new NVListHolder();
            NVUtil.copyFromProperties(nVListHolder, vector.elementAt(i));
            moduleProfileArray[i] = new ModuleProfile(nVListHolder.value);
        }
        return moduleProfileArray;
    }

    @Override
    public ModuleProfile[] get_loaded_modules() {
        this.rtcout.println(2, "get_loaded_modules()");
        ModuleProfileListHolder moduleProfileListHolder = new ModuleProfileListHolder();
        Vector<Properties> vector = this.m_mgr.getLoadedModules();
        moduleProfileListHolder.value = new ModuleProfile[vector.size()];
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = new String();
            string = vector.elementAt(i)._dump(string, vector.elementAt(i), 1);
            NVListHolder nVListHolder = new NVListHolder();
            NVUtil.copyFromProperties(nVListHolder, vector.elementAt(i));
            moduleProfileListHolder.value[i] = new ModuleProfile(nVListHolder.value);
        }
        return moduleProfileListHolder.value;
    }

    @Override
    public ModuleProfile[] get_factory_profiles() {
        this.rtcout.println(2, "get_factory_profiles()");
        Vector<Properties> vector = this.m_mgr.getFactoryProfiles();
        ModuleProfile[] moduleProfileArray = new ModuleProfile[vector.size()];
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Properties properties = vector.elementAt(i);
            String string = new String();
            string = properties._dump(string, properties, 0);
            NVListHolder nVListHolder = new NVListHolder();
            NVUtil.copyFromProperties(nVListHolder, properties);
            moduleProfileArray[i] = new ModuleProfile(nVListHolder.value);
        }
        return moduleProfileArray;
    }

    @Override
    public RTObject create_component(String string) {
        java.lang.Object object;
        this.rtcout.println(2, "create_component(" + string + ")");
        String string2 = string;
        int n = string2.indexOf("&manager=");
        int n2 = string2.indexOf("?manager=");
        if (n < 0 && n2 < 0) {
            RTObject_impl rTObject_impl = this.m_mgr.createComponent(string);
            if (rTObject_impl == null) {
                return null;
            }
            return rTObject_impl.getObjRef();
        }
        int n3 = n >= 0 ? n : n2;
        int n4 = string2.indexOf(38, n3 + 1);
        if (n4 < 0) {
            n4 = string2.length();
        }
        String string3 = string2.substring(n3 + 1, n4);
        this.rtcout.println(1, "Manager arg: " + string3);
        String[] stringArray = string3.split(":");
        if (stringArray.length != 2) {
            this.rtcout.println(5, "Invalid manager name: " + string3);
            return null;
        }
        int n5 = string3.indexOf("=");
        if (n5 < 0) {
            this.rtcout.println(5, "Invalid argument: " + string);
            return null;
        }
        string3 = string3.substring(n5 + 1);
        this.rtcout.println(3, "Manager is : " + string3);
        RTM.Manager manager = this.findManager(string3);
        if (manager == null) {
            object = new ArrayList<String>();
            object.add("rtcd_java");
            object.add("-p");
            object.add(stringArray[1]);
            this.rtcout.println(3, "Invoking command: " + object);
            try {
                ProcessBuilder processBuilder = new ProcessBuilder((List<String>)object);
                Process process = processBuilder.start();
            }
            catch (Exception exception) {
                this.rtcout.println(3, object + ": failed");
                return null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n6 = 0;
            while (manager == null) {
                manager = this.findManager(string3);
                if (++n6 > 1000) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (manager == null) {
            this.rtcout.println(5, "Manager cannot be found.");
            return null;
        }
        string2 = string2.substring(0, n3);
        this.rtcout.println(3, "Creating component on " + string3);
        this.rtcout.println(3, "arg: " + string2);
        try {
            object = manager.create_component(string2);
            this.rtcout.println(3, "Component created " + string2);
            return object;
        }
        catch (SystemException systemException) {
            this.rtcout.println(3, "Exception was caught while creating component.");
            return null;
        }
    }

    @Override
    public ReturnCode_t delete_component(String string) {
        this.rtcout.println(2, "delete_component(" + string + ")");
        this.m_mgr.deleteComponent(string);
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public RTObject[] get_components() {
        int n;
        this.rtcout.println(2, "get_component()");
        Vector<RTObject_impl> vector = this.m_mgr.getComponents();
        RTCListHolder rTCListHolder = new RTCListHolder();
        rTCListHolder.value = new RTObject[vector.size()];
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            rTCListHolder.value[n] = vector.elementAt(n).getObjRef();
        }
        this.rtcout.println(3, this.m_slaves.length + " slaves exists.");
        n2 = this.m_slaves.length;
        for (n = 0; n < n2; ++n) {
            RTObject[] rTObjectArray;
            try {
                if (this.m_slaves[n] != null) {
                    rTObjectArray = this.m_slaves[n].get_components();
                    RTCListHolder rTCListHolder2 = new RTCListHolder(rTObjectArray);
                    CORBA_SeqUtil.push_back_list(rTCListHolder, rTCListHolder2);
                    continue;
                }
            }
            catch (Exception exception) {
                this.rtcout.println(4, "slave (" + n + ") has disappeared.");
                this.m_slaves[n] = null;
            }
            rTObjectArray = new ManagerListHolder(this.m_slaves);
            CORBA_SeqUtil.erase((ManagerListHolder)rTObjectArray, n);
            --n;
            this.m_slaves = rTObjectArray.value;
        }
        return rTCListHolder.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentProfile[] get_component_profiles() {
        this.rtcout.println(2, "get_component_profiles()");
        ComponentProfileListHolder componentProfileListHolder = new ComponentProfileListHolder();
        Vector<RTObject_impl> vector = this.m_mgr.getComponents();
        componentProfileListHolder.value = new ComponentProfile[vector.size()];
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            componentProfileListHolder.value[i] = vector.elementAt(i).get_component_profile();
        }
        String string = this.m_slaveMutex;
        synchronized (string) {
            this.rtcout.println(3, this.m_slaves.length + " slaves exists.");
            int n2 = this.m_slaves.length;
            for (n = 0; n < n2; ++n) {
                ComponentProfile[] componentProfileArray;
                try {
                    if (this.m_slaves[n] != null) {
                        componentProfileArray = this.m_slaves[n].get_component_profiles();
                        ComponentProfileListHolder componentProfileListHolder2 = new ComponentProfileListHolder(componentProfileArray);
                        CORBA_SeqUtil.push_back_list(componentProfileListHolder, componentProfileListHolder2);
                        continue;
                    }
                }
                catch (Exception exception) {
                    this.rtcout.println(4, "slave (" + n + ") has disappeared.");
                    this.m_slaves[n] = null;
                }
                componentProfileArray = new ManagerListHolder(this.m_slaves);
                CORBA_SeqUtil.erase((ManagerListHolder)componentProfileArray, n);
                --n;
                this.m_slaves = componentProfileArray.value;
            }
        }
        return componentProfileListHolder.value;
    }

    @Override
    public ManagerProfile get_profile() {
        this.rtcout.println(2, "get_profile()");
        NVListHolder nVListHolder = new NVListHolder();
        ManagerProfile managerProfile = new ManagerProfile();
        NVUtil.copyFromProperties(nVListHolder, this.m_mgr.getConfig().getNode("manager"));
        managerProfile.properties = nVListHolder.value;
        return managerProfile;
    }

    @Override
    public NameValue[] get_configuration() {
        this.rtcout.println(2, "get_configuration()");
        NVListHolder nVListHolder = new NVListHolder();
        NVUtil.copyFromProperties(nVListHolder, this.m_mgr.getConfig());
        return nVListHolder.value;
    }

    @Override
    public ReturnCode_t set_configuration(String string, String string2) {
        this.rtcout.println(2, "set_configuration()");
        this.m_mgr.getConfig().setProperty(string, string2);
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public boolean is_master() {
        this.rtcout.println(2, "is_master(): " + this.m_isMaster);
        return this.m_isMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RTM.Manager[] get_master_managers() {
        this.rtcout.println(2, "get_master_managers()");
        String string = this.m_masterMutex;
        synchronized (string) {
            ManagerListHolder managerListHolder = new ManagerListHolder(this.m_masters);
            return managerListHolder.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t add_master_manager(RTM.Manager manager) {
        String string = this.m_masterMutex;
        synchronized (string) {
            this.rtcout.println(2, "add_master_manager(), " + this.m_masters.length + " masters");
            ManagerListHolder managerListHolder = new ManagerListHolder(this.m_masters);
            long l = CORBA_SeqUtil.find(managerListHolder, (equalFunctor)new is_equiv(manager));
            if (l >= 0L) {
                this.rtcout.println(6, "Already exists.");
                return ReturnCode_t.BAD_PARAMETER;
            }
            CORBA_SeqUtil.push_back(managerListHolder, (RTM.Manager)manager._duplicate());
            this.m_masters = managerListHolder.value;
            this.rtcout.println(2, "add_master_manager() done, " + this.m_masters.length + " masters");
            return ReturnCode_t.RTC_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t remove_master_manager(RTM.Manager manager) {
        String string = this.m_masterMutex;
        synchronized (string) {
            this.rtcout.println(2, "remove_master_manager(), " + this.m_masters.length + " masters");
            ManagerListHolder managerListHolder = new ManagerListHolder(this.m_masters);
            long l = CORBA_SeqUtil.find(managerListHolder, (equalFunctor)new is_equiv(manager));
            if (l < 0L) {
                this.rtcout.println(6, "Not found.");
                return ReturnCode_t.BAD_PARAMETER;
            }
            CORBA_SeqUtil.erase(managerListHolder, (int)l);
            this.m_masters = managerListHolder.value;
            this.rtcout.println(2, "remove_master_manager() done, " + this.m_masters.length + " masters");
            return ReturnCode_t.RTC_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RTM.Manager[] get_slave_managers() {
        String string = this.m_masterMutex;
        synchronized (string) {
            this.rtcout.println(2, "get_slave_managers(), " + this.m_slaves.length + " slaves");
            ManagerListHolder managerListHolder = new ManagerListHolder(this.m_slaves);
            return managerListHolder.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t add_slave_manager(RTM.Manager manager) {
        String string = this.m_masterMutex;
        synchronized (string) {
            this.rtcout.println(2, "add_slave_manager(), " + this.m_slaves.length + " slaves");
            ManagerListHolder managerListHolder = new ManagerListHolder(this.m_slaves);
            long l = CORBA_SeqUtil.find(managerListHolder, (equalFunctor)new is_equiv(manager));
            if (l >= 0L) {
                this.rtcout.println(6, "Already exists.");
                return ReturnCode_t.BAD_PARAMETER;
            }
            CORBA_SeqUtil.push_back(managerListHolder, (RTM.Manager)manager._duplicate());
            this.m_slaves = managerListHolder.value;
            this.rtcout.println(2, "add_slave_manager() done, " + this.m_slaves.length + " slaves");
            return ReturnCode_t.RTC_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t remove_slave_manager(RTM.Manager manager) {
        String string = this.m_masterMutex;
        synchronized (string) {
            this.rtcout.println(2, "remove_slave_manager(), " + this.m_slaves.length + " slaves");
            ManagerListHolder managerListHolder = new ManagerListHolder(this.m_slaves);
            long l = CORBA_SeqUtil.find(managerListHolder, (equalFunctor)new is_equiv(manager));
            if (l < 0L) {
                this.rtcout.println(6, "Not found.");
                return ReturnCode_t.BAD_PARAMETER;
            }
            CORBA_SeqUtil.erase(managerListHolder, (int)l);
            this.m_slaves = managerListHolder.value;
            this.rtcout.println(2, "remove_slave_manager() done, " + this.m_slaves.length + " slaves");
            return ReturnCode_t.RTC_OK;
        }
    }

    @Override
    public ReturnCode_t fork() {
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t shutdown() {
        this.m_mgr.terminate();
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t restart() {
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public Object get_service(String string) {
        return null;
    }

    public RTM.Manager getObjRef() {
        return this.m_objref;
    }

    private class is_equiv
    implements equalFunctor {
        private RTM.Manager m_mgr;

        public is_equiv(RTM.Manager manager) {
            this.m_mgr = (RTM.Manager)manager._duplicate();
        }

        @Override
        public boolean equalof(java.lang.Object object) {
            return this.m_mgr._is_equivalent((RTM.Manager)object);
        }
    }
}

