/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.HashMap;
import jp.go.aist.rtm.RTC.StateAction;
import jp.go.aist.rtm.RTC.StateHolder;

public class StateMachine<STATE, LISTENER> {
    protected int m_num;
    protected LISTENER m_listener;
    protected HashMap<STATE, StateAction> m_entry;
    protected HashMap<STATE, StateAction> m_predo;
    protected HashMap<STATE, StateAction> m_do;
    protected HashMap<STATE, StateAction> m_postdo;
    protected HashMap<STATE, StateAction> m_exit;
    protected StateAction m_transit;
    protected StateHolder<STATE> m_states = new StateHolder();

    public StateMachine(int n) {
        this.m_num = n;
        this.m_entry = new HashMap();
        this.m_predo = new HashMap();
        this.m_do = new HashMap();
        this.m_postdo = new HashMap();
        this.m_exit = new HashMap();
        this.m_transit = null;
    }

    public void setNOP() {
        this.m_entry = new HashMap();
        this.m_predo = new HashMap();
        this.m_do = new HashMap();
        this.m_postdo = new HashMap();
        this.m_exit = new HashMap();
        this.m_transit = null;
    }

    public void setListener(LISTENER LISTENER) {
        this.m_listener = LISTENER;
    }

    public boolean setEntryAction(STATE STATE, StateAction stateAction) {
        this.m_entry.put(STATE, stateAction);
        return true;
    }

    public boolean setPreDoAction(STATE STATE, StateAction stateAction) {
        this.m_predo.put(STATE, stateAction);
        return true;
    }

    public boolean setDoAction(STATE STATE, StateAction stateAction) {
        this.m_do.put(STATE, stateAction);
        return true;
    }

    public boolean setPostDoAction(STATE STATE, StateAction stateAction) {
        this.m_postdo.put(STATE, stateAction);
        return true;
    }

    public boolean setExitAction(STATE STATE, StateAction stateAction) {
        this.m_exit.put(STATE, stateAction);
        return true;
    }

    public boolean setTransitionAction(StateAction stateAction) {
        this.m_transit = stateAction;
        return true;
    }

    public void setStartState(StateHolder stateHolder) {
        this.m_states.curr = stateHolder.curr;
        this.m_states.prev = stateHolder.prev;
        this.m_states.next = stateHolder.next;
    }

    public synchronized STATE getState() {
        return this.m_states.curr;
    }

    public synchronized boolean isIn(STATE STATE) {
        return this.m_states.curr == STATE;
    }

    public synchronized void goTo(STATE STATE) {
        this.m_states.next = STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worker() {
        StateHolder stateHolder;
        StateHolder<STATE> stateHolder2 = this.m_states;
        synchronized (stateHolder2) {
            stateHolder = new StateHolder(this.m_states);
        }
        if (stateHolder.curr == stateHolder.next) {
            if (this.m_predo.get(stateHolder.curr) != null) {
                this.m_predo.get(stateHolder.curr).doAction(stateHolder);
            }
            if (this.need_trans()) {
                return;
            }
            if (this.m_do.get(stateHolder.curr) != null) {
                this.m_do.get(stateHolder.curr).doAction(stateHolder);
            }
            if (this.need_trans()) {
                return;
            }
            if (this.m_postdo.get(stateHolder.curr) != null) {
                this.m_postdo.get(stateHolder.curr).doAction(stateHolder);
            }
        } else {
            if (this.m_exit.get(stateHolder.curr) != null) {
                this.m_exit.get(stateHolder.curr).doAction(stateHolder);
            }
            stateHolder2 = this.m_states;
            synchronized (stateHolder2) {
                stateHolder = new StateHolder(this.m_states);
            }
            if (stateHolder.curr != stateHolder.next) {
                stateHolder.curr = stateHolder.next;
                if (this.m_entry.get(stateHolder.curr) != null) {
                    this.m_entry.get(stateHolder.curr).doAction(stateHolder);
                }
                this.update_curr(stateHolder.curr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean need_trans() {
        StateHolder<STATE> stateHolder = this.m_states;
        synchronized (stateHolder) {
            return this.m_states.curr != this.m_states.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update_curr(STATE STATE) {
        StateHolder<STATE> stateHolder = this.m_states;
        synchronized (stateHolder) {
            this.m_states.curr = STATE;
        }
    }
}

