/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.spi.orb.ORB;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.buffer.RingBuffer;
import jp.go.aist.rtm.RTC.port.InPortBase;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.OnOverflow;
import jp.go.aist.rtm.RTC.port.OnRead;
import jp.go.aist.rtm.RTC.port.OnReadConvert;
import jp.go.aist.rtm.RTC.port.OnUnderflow;
import jp.go.aist.rtm.RTC.port.OnWrite;
import jp.go.aist.rtm.RTC.port.OnWriteConvert;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.DataRef;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.Streamable;

public class InPort<DataType>
extends InPortBase {
    private static final long TIMEOUT_TICK_USEC = 10L;
    private static final long TIMEOUT_TICK_MSEC_PART = 0L;
    private static final int TIMEOUT_TICK_NSEC_PART = 10000;
    private BufferBase<DataType> m_superClass;
    private String m_name;
    private DataRef<DataType> m_value;
    private boolean m_readBlock;
    private long m_readTimeout;
    private boolean m_writeBlock;
    private long m_writeTimeout;
    private OnWrite<DataType> m_OnWrite;
    private OnWriteConvert<DataType> m_OnWriteConvert;
    private OnRead<DataType> m_OnRead;
    private OnReadConvert<DataType> m_OnReadConvert;
    private OnOverflow<DataType> m_OnOverflow;
    private OnUnderflow<DataType> m_OnUnderflow;
    private Streamable m_streamable = null;
    private Field m_field = null;
    private ORB m_spi_orb;
    private org.omg.CORBA.ORB m_orb;

    private static <DataType> String toTypeCode(DataRef<DataType> dataRef) {
        String string = dataRef.v.getClass().getSimpleName();
        return string;
    }

    private static <DataType> String toRepositoryId(DataRef<DataType> dataRef) {
        String string = new String();
        Class<?> clazz = dataRef.v.getClass();
        String string2 = clazz.getName();
        try {
            Class<?> clazz2 = Class.forName(string2 + "Helper");
            Method method = clazz2.getMethod("id", new Class[0]);
            string = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private DataType read_stream(DataRef<DataType> dataRef, InputStream inputStream) {
        try {
            this.m_streamable._read(inputStream);
            dataRef.v = this.m_field.get(this.m_streamable);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.rtcout.println(5, "Exception caught." + illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.rtcout.println(5, "Exception caught." + illegalArgumentException.toString());
        }
        return (DataType)dataRef.v;
    }

    public InPort(BufferBase<DataType> bufferBase, String string, DataRef<DataType> dataRef, boolean bl, boolean bl2, long l, long l2) {
        super(string, InPort.toRepositoryId(dataRef));
        this.m_name = string;
        this.m_value = dataRef;
        this.m_readBlock = bl;
        this.m_writeBlock = bl2;
        this.m_readTimeout = l;
        this.m_writeTimeout = l2;
        this.m_OnWrite = null;
        this.m_OnWriteConvert = null;
        this.m_OnRead = null;
        this.m_OnReadConvert = null;
        this.m_OnOverflow = null;
        this.m_OnUnderflow = null;
        this.m_spi_orb = (ORB)ORBUtil.getOrb();
        this.m_orb = ORBUtil.getOrb();
        Class<?> clazz = dataRef.v.getClass();
        String string2 = clazz.getName();
        try {
            Class<?> clazz2 = Class.forName(string2 + "Holder", true, this.getClass().getClassLoader());
            this.m_streamable = (Streamable)clazz2.newInstance();
            this.m_field = this.m_streamable.getClass().getField("value");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.rtcout.println(5, "Exception caught." + noSuchFieldException.toString());
        }
        catch (InstantiationException instantiationException) {
            this.rtcout.println(5, "Exception caught." + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.rtcout.println(5, "Exception caught." + classNotFoundException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.rtcout.println(5, "Exception caught." + illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.rtcout.println(5, "Exception caught." + illegalArgumentException.toString());
        }
    }

    public InPort(String string, DataRef<DataType> dataRef) {
        this(new RingBuffer(8), string, dataRef, false, false, 0L, 0L);
    }

    public String name() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNew() {
        this.rtcout.println(2, "isNew()");
        int n = 0;
        String string = m_connectorsMutex;
        synchronized (string) {
            Vector vector = this.m_connectors;
            synchronized (vector) {
                if (this.m_connectors.size() == 0) {
                    this.rtcout.println(3, "no connectors");
                    return false;
                }
                n = ((InPortConnector)this.m_connectors.elementAt(0)).getBuffer().readable();
            }
        }
        if (n > 0) {
            this.rtcout.println(3, "isNew() = true, readable data: " + n);
            return true;
        }
        this.rtcout.println(3, "isNew() = false, no readable data");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read() {
        this.rtcout.println(2, "DataType read()");
        String string = m_connectorsMutex;
        synchronized (string) {
            ReturnCode returnCode;
            if (this.m_OnRead != null) {
                this.m_OnRead.run();
                this.rtcout.println(2, "OnRead called");
            }
            EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.m_spi_orb, this.isLittleEndian());
            DataRef<InputStream> dataRef = new DataRef<InputStream>(encapsOutputStream.create_input_stream());
            Vector vector = this.m_connectors;
            synchronized (vector) {
                if (this.m_connectors.size() == 0) {
                    this.rtcout.println(3, "no connectors");
                    return false;
                }
                returnCode = ((InPortConnector)this.m_connectors.elementAt(0)).read(dataRef);
            }
            if (returnCode.equals((Object)ReturnCode.PORT_OK)) {
                this.rtcout.println(3, "data read succeeded");
                this.m_value.v = this.read_stream(this.m_value, (InputStream)dataRef.v);
                if (this.m_OnReadConvert != null) {
                    this.m_value.v = this.m_OnReadConvert.run(this.m_value.v);
                    this.rtcout.println(3, "OnReadConvert called");
                    return true;
                }
                return true;
            }
            if (returnCode.equals((Object)ReturnCode.BUFFER_EMPTY)) {
                this.rtcout.println(5, "buffer empty");
                return false;
            }
            if (returnCode.equals((Object)ReturnCode.BUFFER_TIMEOUT)) {
                this.rtcout.println(5, "buffer read timeout");
                return false;
            }
            this.rtcout.println(6, "unknown retern value from buffer.read()");
            return false;
        }
    }

    public void update() {
        this.read();
    }

    public DataType extract() {
        this.read();
        return (DataType)this.m_value.v;
    }

    public void setOnWrite(OnWrite<DataType> onWrite) {
        this.m_OnWrite = onWrite;
    }

    public void setOnWriteConvert(OnWriteConvert<DataType> onWriteConvert) {
        this.m_OnWriteConvert = onWriteConvert;
    }

    public void setOnRead(OnRead<DataType> onRead) {
        this.m_OnRead = onRead;
    }

    public void setOnReadConvert(OnReadConvert<DataType> onReadConvert) {
        this.m_OnReadConvert = onReadConvert;
    }

    public void setOnOverflow(OnOverflow<DataType> onOverflow) {
        this.m_OnOverflow = onOverflow;
    }

    public void setOnUnderflow(OnUnderflow<DataType> onUnderflow) {
        this.m_OnUnderflow = onUnderflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.rtcout.println(2, "isEmpty()");
        int n = 0;
        String string = m_connectorsMutex;
        synchronized (string) {
            Vector vector = this.m_connectors;
            synchronized (vector) {
                if (this.m_connectors.size() == 0) {
                    this.rtcout.println(3, "no connectors");
                    return true;
                }
                n = ((InPortConnector)this.m_connectors.elementAt(0)).getBuffer().readable();
            }
        }
        if (n == 0) {
            this.rtcout.println(3, "isEmpty() = true, buffer is empty");
            return true;
        }
        this.rtcout.println(3, "isEmpty() = false, data exists in the buffer");
        return false;
    }

    public boolean setStreamable(Streamable streamable) {
        try {
            this.m_streamable = streamable;
            this.m_field = this.m_streamable.getClass().getField("value");
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.rtcout.println(5, "Exception caught." + noSuchFieldException.toString());
            return false;
        }
    }
}

