/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import OpenRTM.InPortCdr;
import OpenRTM.PortStatus;
import _SDOPackage.NVListHolder;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.spi.orb.ORB;
import jp.go.aist.rtm.RTC.InPortConsumerFactory;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.CorbaConsumer;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.OutputStream;

public class InPortCorbaCdrConsumer
extends CorbaConsumer<InPortCdr>
implements InPortConsumer,
ObjectCreator<InPortConsumer>,
ObjectDestructor {
    private Logbuf rtcout;
    private Properties m_properties;
    private ORB m_spi_orb = (ORB)ORBUtil.getOrb();
    private OutPortConnector m_connector;
    private org.omg.CORBA.ORB m_orb;

    public InPortCorbaCdrConsumer() {
        super(InPortCdr.class);
        this.rtcout = new Logbuf("InPortCorbaCdrConsumer");
        this.m_spi_orb = (ORB)ORBUtil.getOrb();
        this.m_orb = ORBUtil.getOrb();
    }

    @Override
    public void init(Properties properties) {
        this.m_properties = properties;
    }

    @Override
    public ReturnCode put(OutputStream outputStream) {
        this.rtcout.println(0, "put");
        EncapsOutputStream encapsOutputStream = (EncapsOutputStream)outputStream;
        byte[] byArray = encapsOutputStream.toByteArray();
        EncapsOutputStream encapsOutputStream2 = new EncapsOutputStream(this.m_spi_orb, this.m_connector.isLittleEndian());
        encapsOutputStream2.write_octet_array(byArray, 0, byArray.length);
        try {
            PortStatus portStatus = ((InPortCdr)this._ptr()).put(encapsOutputStream2.toByteArray());
            return this.convertReturn(portStatus);
        }
        catch (Exception exception) {
            return ReturnCode.CONNECTION_LOST;
        }
    }

    @Override
    public void publishInterfaceProfile(NVListHolder nVListHolder) {
    }

    @Override
    public boolean subscribeInterface(NVListHolder nVListHolder) {
        this.rtcout.println(2, "subscribeInterface()");
        if (nVListHolder.value == null) {
            this.rtcout.println(3, "NVListHolder is null.");
            return false;
        }
        this.rtcout.println(3, "Length of NVListHolder:" + nVListHolder.value.length);
        this.rtcout.println(3, NVUtil.toString(nVListHolder));
        if (this.subscribeFromIor(nVListHolder)) {
            return true;
        }
        return this.subscribeFromRef(nVListHolder);
    }

    @Override
    public void unsubscribeInterface(NVListHolder nVListHolder) {
        this.rtcout.println(2, "unsubscribeInterface()");
        this.rtcout.println(3, NVUtil.toString(nVListHolder));
        if (this.unsubscribeFromIor(nVListHolder)) {
            return;
        }
        this.unsubscribeFromRef(nVListHolder);
    }

    private boolean subscribeFromIor(NVListHolder nVListHolder) {
        String string;
        this.rtcout.println(2, "subscribeFromIor()");
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.inport_ior");
        if (n < 0) {
            this.rtcout.println(6, "inport_ior not found");
            return false;
        }
        this.rtcout.println(3, "index:" + n);
        try {
            this.rtcout.println(3, "type:" + nVListHolder.value[n].value.type());
            string = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : nVListHolder.value[n].value.extract_string();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.rtcout.println(6, "inport_ior has no string");
            return false;
        }
        org.omg.CORBA.ORB oRB = ORBUtil.getOrb();
        Object object = oRB.string_to_object(string);
        if (object == null) {
            this.rtcout.println(6, "invalid IOR string has been passed");
            return false;
        }
        if (!super.setObject(object)) {
            this.rtcout.println(5, "Setting object to consumer failed.");
            return false;
        }
        return true;
    }

    private boolean subscribeFromRef(NVListHolder nVListHolder) {
        Object object;
        this.rtcout.println(2, "subscribeFromRef()");
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.inport_ref");
        if (n < 0) {
            this.rtcout.println(6, "inport_ref not found");
            return false;
        }
        try {
            object = nVListHolder.value[n].value.extract_Object();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.rtcout.println(6, "prop[inport_ref] is not objref");
            return true;
        }
        if (object == null) {
            this.rtcout.println(6, "prop[inport_ref] is not objref");
            return false;
        }
        if (!super.setObject(object)) {
            this.rtcout.println(6, "Setting object to consumer failed.");
            return false;
        }
        return true;
    }

    private boolean unsubscribeFromIor(NVListHolder nVListHolder) {
        String string;
        this.rtcout.println(2, "unsubscribeFromIor()");
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.inport_ior");
        if (n < 0) {
            this.rtcout.println(6, "inport_ior not found");
            return false;
        }
        try {
            string = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : nVListHolder.value[n].value.extract_string();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.rtcout.println(6, "inport_ior has no string");
            return false;
        }
        org.omg.CORBA.ORB oRB = ORBUtil.getOrb();
        Object object = oRB.string_to_object(string);
        if (!((InPortCdr)this._ptr())._is_equivalent(object)) {
            this.rtcout.println(6, "connector property inconsistency");
            return false;
        }
        this.releaseObject();
        return true;
    }

    private boolean unsubscribeFromRef(NVListHolder nVListHolder) {
        Object object;
        this.rtcout.println(2, "unsubscribeFromRef()");
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.inport_ref");
        if (n < 0) {
            return false;
        }
        try {
            object = nVListHolder.value[n].value.extract_Object();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.rtcout.println(6, "prop[inport_ref] is not objref");
            return false;
        }
        if (!((InPortCdr)this._ptr())._is_equivalent(object)) {
            this.rtcout.println(6, "connector property inconsistency");
            return false;
        }
        this.releaseObject();
        return true;
    }

    protected ReturnCode convertReturn(PortStatus portStatus) {
        switch (portStatus.value()) {
            case 0: {
                return ReturnCode.PORT_OK;
            }
            case 1: {
                return ReturnCode.PORT_ERROR;
            }
            case 2: {
                return ReturnCode.BUFFER_FULL;
            }
            case 3: {
                return ReturnCode.BUFFER_EMPTY;
            }
            case 4: {
                return ReturnCode.BUFFER_TIMEOUT;
            }
        }
        return ReturnCode.UNKNOWN_ERROR;
    }

    @Override
    public InPortConsumer creator_() {
        return new InPortCorbaCdrConsumer();
    }

    @Override
    public void destructor_(java.lang.Object object) {
        object = null;
    }

    public static void InPortCorbaCdrConsumerInit() {
        InPortConsumerFactory inPortConsumerFactory = InPortConsumerFactory.instance();
        inPortConsumerFactory.addFactory("corba_cdr", new InPortCorbaCdrConsumer(), new InPortCorbaCdrConsumer());
    }

    @Override
    public void setConnector(OutPortConnector outPortConnector) {
        this.m_connector = outPortConnector;
    }
}

