/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.PortProfile;
import RTC.PortProfileListHolder;
import RTC.PortService;
import RTC.PortServiceListHolder;
import RTC.PortServiceOperations;
import java.util.Vector;
import jp.go.aist.rtm.RTC.ObjectManager;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.PortServiceListHolderFactory;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class PortAdmin {
    private POA m_pPOA;
    private ORB m_pORB;
    private PortServiceListHolder m_portRefs = PortServiceListHolderFactory.create();
    private ObjectManager<String, PortBase> m_portServants = new ObjectManager();
    private Logbuf rtcout;

    public PortAdmin(ORB oRB, POA pOA) {
        this.m_pORB = oRB;
        this.m_pPOA = pOA;
        this.rtcout = new Logbuf("PortAdmin");
    }

    public PortServiceListHolder getPortList() {
        return PortServiceListHolderFactory.clone(this.m_portRefs);
    }

    public PortServiceListHolder getPortServiceList() {
        return PortServiceListHolderFactory.clone(this.m_portRefs);
    }

    public void activatePorts() {
        Vector<PortBase> vector = this.m_portServants.getObjects();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector.get(i).activateInterfaces();
        }
    }

    public void deactivatePorts() {
        Vector<PortBase> vector = this.m_portServants.getObjects();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector.get(i).deactivateInterfaces();
        }
    }

    public final PortProfileListHolder getPortProfileList() {
        PortProfileListHolder portProfileListHolder = new PortProfileListHolder();
        portProfileListHolder.value = new PortProfile[0];
        port_prof_collect port_prof_collect2 = new port_prof_collect(portProfileListHolder);
        for (PortService portService : this.m_portRefs.value) {
            port_prof_collect2.operator(portService);
        }
        return portProfileListHolder;
    }

    public PortService getPortRef(String string) {
        PortService portService = null;
        int n = CORBA_SeqUtil.find(this.m_portRefs, (equalFunctor)new find_port_name(string));
        if (n >= 0) {
            portService = this.m_portRefs.value[n];
        }
        return portService;
    }

    public PortBase getPort(String string) {
        return this.m_portServants.find(new find_port_name(string));
    }

    public boolean addPort(PortBase portBase) {
        int n = CORBA_SeqUtil.find(this.m_portRefs, (equalFunctor)new find_port_name(portBase.getName()));
        if (n != -1) {
            return false;
        }
        CORBA_SeqUtil.push_back(this.m_portRefs, portBase.getPortRef());
        return this.m_portServants.registerObject(portBase, new find_port_name(portBase.get_port_profile().name));
    }

    public boolean addPort(PortService portService) {
        PortProfile portProfile = portService.get_port_profile();
        String string = portProfile.name;
        if (CORBA_SeqUtil.find(this.m_portRefs, (equalFunctor)new find_port_name(string)) != -1) {
            return false;
        }
        CORBA_SeqUtil.push_back(this.m_portRefs, portService);
        return true;
    }

    public void registerPort(PortBase portBase) {
        CORBA_SeqUtil.push_back(this.m_portRefs, portBase.getPortRef());
        this.m_portServants.registerObject(portBase, new find_port_name(portBase.get_port_profile().name));
    }

    public void registerPort(PortService portService) {
        if (!this.addPort(portService)) {
            this.rtcout.println(6, "registerPort(PortService_ptr) failed.");
        }
    }

    public boolean removePort(PortBase portBase) {
        try {
            portBase.disconnect_all();
            String string = portBase.getProfile().name;
            CORBA_SeqUtil.erase_if(this.m_portRefs, (equalFunctor)new find_port_name(string));
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)portBase));
            portBase.setPortRef(null);
            return this.m_portServants.unregisterObject(new find_port_name(string)) != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean removePort(PortService portService) {
        try {
            CORBA_SeqUtil.erase_if(this.m_portRefs, (equalFunctor)new find_port(portService));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void deletePort(PortBase portBase) {
        if (!this.removePort(portBase)) {
            this.rtcout.println(6, "deletePort(PortBase&) failed.");
        }
    }

    public void deletePort(PortService portService) {
        if (!this.removePort(portService)) {
            this.rtcout.println(6, "deletePort(PortService) failed.");
        }
    }

    public void deletePortByName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.removePort(this.m_portServants.find(new find_port_name(string)));
    }

    public void finalizePorts() {
        Vector<PortBase> vector = this.m_portServants.getObjects();
        for (int i = 0; i < vector.size(); ++i) {
            this.deletePort(vector.elementAt(i));
        }
    }

    protected class port_prof_collect {
        private PortProfileListHolder m_p;

        public port_prof_collect(PortProfileListHolder portProfileListHolder) {
            this.m_p = portProfileListHolder;
        }

        public void operator(PortService portService) {
            CORBA_SeqUtil.push_back(this.m_p, portService.get_port_profile());
        }
    }

    protected class find_port
    implements equalFunctor {
        public PortService m_port;

        public find_port(PortService portService) {
            this.m_port = portService;
        }

        @Override
        public boolean equalof(Object object) {
            return this.m_port._is_equivalent((PortService)object);
        }
    }

    protected class find_port_name
    implements equalFunctor {
        public String m_name;

        public find_port_name(String string) {
            this.m_name = string;
        }

        @Override
        public boolean equalof(Object object) {
            PortServiceOperations portServiceOperations = (PortServiceOperations)object;
            return this.m_name.equals(portServiceOperations.get_port_profile().name);
        }
    }
}

