/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.Iterator;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Config;
import jp.go.aist.rtm.RTC.ConfigBase;
import jp.go.aist.rtm.RTC.find_conf;
import jp.go.aist.rtm.RTC.util.OnActivateSetCallbackFunc;
import jp.go.aist.rtm.RTC.util.OnAddConfigurationAddCallbackFunc;
import jp.go.aist.rtm.RTC.util.OnRemoveConfigurationSetCallbackFunc;
import jp.go.aist.rtm.RTC.util.OnSetConfigurationSetCallbackFunc;
import jp.go.aist.rtm.RTC.util.OnUpdateCallbackFunc;
import jp.go.aist.rtm.RTC.util.OnUpdateParamCallbackFunc;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.ValueHolder;

public class ConfigAdmin {
    private Properties m_configsets = new Properties();
    private Properties m_emptyconf = new Properties();
    private Vector<ConfigBase> m_params = new Vector();
    private String m_activeId = new String();
    private boolean m_active;
    private boolean m_changed;
    private Vector<String> m_newConfig = new Vector();
    private OnUpdateCallbackFunc m_updateCb;
    private OnUpdateParamCallbackFunc m_updateParamCb;
    private OnSetConfigurationSetCallbackFunc m_setConfigSetCb;
    private OnAddConfigurationAddCallbackFunc m_addConfigSetCb;
    private OnRemoveConfigurationSetCallbackFunc m_removeConfigSetCb;
    private OnActivateSetCallbackFunc m_activateSetCb;

    public ConfigAdmin(Properties properties) {
        this.m_configsets = properties;
        this.m_activeId = "default";
        this.m_active = true;
        this.m_changed = false;
        this.m_updateCb = null;
        this.m_updateParamCb = null;
        this.m_setConfigSetCb = null;
        this.m_addConfigSetCb = null;
        this.m_removeConfigSetCb = null;
        this.m_activateSetCb = null;
    }

    public void destruct() {
        for (int i = 0; i < this.m_params.size(); ++i) {
            if (this.m_params.elementAt(i) == null) continue;
            this.m_params.setElementAt(null, i);
        }
        this.m_params.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public boolean bindParameter(String string, ValueHolder valueHolder, String string2) {
        if (this.isExist(string)) {
            return false;
        }
        try {
            valueHolder.stringFrom(string2);
        }
        catch (Exception exception) {
            return false;
        }
        this.m_params.add(new Config(string, valueHolder, string2));
        return true;
    }

    public void update(String string) {
        if (this.m_configsets.hasKey(string) == null) {
            return;
        }
        Properties properties = new Properties(this.m_configsets.getNode(string));
        for (int i = 0; i < this.m_params.size(); ++i) {
            if (properties.hasKey(this.m_params.elementAt((int)i).name) == null) continue;
            this.m_params.elementAt(i).update(properties.getProperty(this.m_params.elementAt((int)i).name));
            this.onUpdate(string);
        }
    }

    public void update() {
        if (this.m_changed && this.m_active) {
            this.update(this.m_activeId);
            this.m_changed = false;
        }
    }

    public void update(String string, String string2) {
        String string3 = string + "." + string2;
        for (ConfigBase configBase : this.m_params) {
            if (!new find_conf(string2).equalof(configBase)) continue;
            configBase.update(this.m_configsets.getProperty(string3));
            this.onUpdateParam(string, string2);
            return;
        }
    }

    public boolean isExist(String string) {
        Iterator<ConfigBase> iterator = this.m_params.iterator();
        while (iterator.hasNext()) {
            if (!new find_conf(string).equalof(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public final String getActiveId() {
        return this.m_activeId;
    }

    public final boolean haveConfig(String string) {
        return this.m_configsets.hasKey(string) != null;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public final Vector<Properties> getConfigurationSets() {
        return this.m_configsets.getLeaf();
    }

    public final Properties getConfigurationSet(String string) {
        Properties properties = new Properties(this.m_configsets.getNode(string));
        if (properties == null) {
            return this.m_emptyconf;
        }
        return properties;
    }

    public boolean setConfigurationSetValues(String string, Properties properties) {
        if (!string.equals(properties.getName())) {
            return false;
        }
        if (this.m_configsets.hasKey(string) == null) {
            return false;
        }
        this.m_configsets.getNode(string).merge(properties);
        this.m_changed = true;
        this.m_active = true;
        this.onSetConfigurationSet(properties);
        return true;
    }

    public final Properties getActiveConfigurationSet() {
        Properties properties = this.m_configsets.getNode(this.m_activeId);
        if (properties == null) {
            return this.m_emptyconf;
        }
        Properties properties2 = new Properties(properties);
        if (properties2 == null) {
            return this.m_emptyconf;
        }
        return properties2;
    }

    public boolean addConfigurationSet(Properties properties) {
        if (this.m_configsets.hasKey(properties.getName()) != null) {
            return false;
        }
        String string = properties.getName();
        this.m_configsets.createNode(string);
        this.m_configsets.getNode(string).merge(properties);
        this.m_newConfig.add(string);
        this.m_changed = true;
        this.m_active = false;
        this.onAddConfigurationSet(properties);
        return true;
    }

    public boolean removeConfigurationSet(String string) {
        for (int i = 0; i < this.m_newConfig.size(); ++i) {
            if (!this.m_newConfig.elementAt(i).equals(string)) continue;
            Properties properties = new Properties(this.m_configsets.getNode(string));
            if (properties != null) {
                this.m_configsets.removeNode(properties.getName());
            }
            this.m_newConfig.remove(i);
            this.m_changed = true;
            this.m_active = false;
            this.onRemoveConfigurationSet(string);
            return true;
        }
        return false;
    }

    public boolean activateConfigurationSet(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_configsets.hasKey(string) == null) {
            return false;
        }
        this.m_activeId = string;
        this.m_active = true;
        this.m_changed = true;
        this.onActivateSet(string);
        return true;
    }

    public void setOnUpdate(OnUpdateCallbackFunc onUpdateCallbackFunc) {
        this.m_updateCb = onUpdateCallbackFunc;
    }

    public void setOnUpdateParam(OnUpdateParamCallbackFunc onUpdateParamCallbackFunc) {
        this.m_updateParamCb = onUpdateParamCallbackFunc;
    }

    public void setOnSetConfigurationSet(OnSetConfigurationSetCallbackFunc onSetConfigurationSetCallbackFunc) {
        this.m_setConfigSetCb = onSetConfigurationSetCallbackFunc;
    }

    public void setOnAddConfigurationSet(OnAddConfigurationAddCallbackFunc onAddConfigurationAddCallbackFunc) {
        this.m_addConfigSetCb = onAddConfigurationAddCallbackFunc;
    }

    public void setOnRemoveConfigurationSet(OnRemoveConfigurationSetCallbackFunc onRemoveConfigurationSetCallbackFunc) {
        this.m_removeConfigSetCb = onRemoveConfigurationSetCallbackFunc;
    }

    public void setOnActivateSet(OnActivateSetCallbackFunc onActivateSetCallbackFunc) {
        this.m_activateSetCb = onActivateSetCallbackFunc;
    }

    public void onUpdate(String string) {
        if (this.m_updateCb != null) {
            this.m_updateCb.operator(string);
        }
    }

    public void onUpdateParam(String string, String string2) {
        if (this.m_updateParamCb != null) {
            this.m_updateParamCb.operator(string, string2);
        }
    }

    public void onSetConfigurationSet(Properties properties) {
        if (this.m_setConfigSetCb != null) {
            this.m_setConfigSetCb.operator(properties);
        }
    }

    public void onAddConfigurationSet(Properties properties) {
        if (this.m_addConfigSetCb != null) {
            this.m_addConfigSetCb.operator(properties);
        }
    }

    public void onRemoveConfigurationSet(String string) {
        if (this.m_removeConfigSetCb != null) {
            this.m_removeConfigSetCb.operator(string);
        }
    }

    public void onActivateSet(String string) {
        if (this.m_activateSetCb != null) {
            this.m_activateSetCb.operator(string);
        }
    }

    private ConfigAdmin(ConfigAdmin configAdmin) {
        this.m_configsets = configAdmin.m_configsets;
    }

    class OnActivateSetCallback
    implements OnActivateSetCallbackFunc {
        OnActivateSetCallback() {
        }

        @Override
        public void operator(String string) {
        }
    }

    class OnRemoveConfigurationSetCallback
    implements OnRemoveConfigurationSetCallbackFunc {
        OnRemoveConfigurationSetCallback() {
        }

        @Override
        public void operator(String string) {
        }
    }

    class OnAddConfigurationAddCallback
    implements OnAddConfigurationAddCallbackFunc {
        OnAddConfigurationAddCallback() {
        }

        @Override
        public void operator(Properties properties) {
        }
    }

    class OnSetConfigurationSetCallback
    implements OnSetConfigurationSetCallbackFunc {
        OnSetConfigurationSetCallback() {
        }

        @Override
        public void operator(Properties properties) {
        }
    }

    class OnUpdateParamCallback
    implements OnUpdateParamCallbackFunc {
        OnUpdateParamCallback() {
        }

        @Override
        public void operator(String string, String string2) {
        }
    }

    class OnUpdateCallback
    implements OnUpdateCallbackFunc {
        OnUpdateCallback() {
        }

        @Override
        public void operator(String string) {
        }
    }
}

