/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.PortInterfacePolarity;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.CorbaConsumerBase;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVListHolderFactory;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.operatorFunc;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHelper;
import org.omg.CORBA.TCKind;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class CorbaPort
extends PortBase {
    private NVListHolder m_providers = NVListHolderFactory.create();
    private Vector<Consumer> m_consumers = new Vector();
    protected HashMap<String, ProviderInfo> m_servants = new HashMap();
    protected Logbuf rtcout;

    public CorbaPort(String string) {
        super(string);
        this.addProperty("port.port_type", "CorbaPort", String.class);
        this.rtcout = new Logbuf("CorbaPort");
    }

    public boolean registerProvider(String string, String string2, Servant servant) throws ServantAlreadyActive, WrongPolicy, ObjectNotActive {
        this.rtcout.println(2, "registerProvider(instance=" + string + ", type_name=" + string2 + ")");
        if (!this.appendInterface(string, string2, PortInterfacePolarity.PROVIDED)) {
            return false;
        }
        byte[] byArray = null;
        try {
            byArray = this._default_POA().servant_to_id(servant);
        }
        catch (Exception exception) {
            this.rtcout.println(5, "Exception caught." + exception.toString());
        }
        try {
            this._default_POA().activate_object_with_id(byArray, servant);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            this.rtcout.println(5, "Exception caught." + servantAlreadyActive.toString());
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            this.rtcout.println(5, "Exception caught." + objectAlreadyActive.toString());
        }
        Object object = this._default_POA().id_to_reference(byArray);
        StringBuffer stringBuffer = new StringBuffer("port");
        stringBuffer.append(".").append(string2).append(".").append(string);
        ORB oRB = ORBUtil.getOrb();
        String string3 = oRB.object_to_string(object);
        CORBA_SeqUtil.push_back(this.m_providers, NVUtil.newNVString(stringBuffer.toString(), string3));
        this.m_servants.put(string, new ProviderInfo(servant, byArray));
        return true;
    }

    public boolean registerConsumer(String string, String string2, CorbaConsumerBase corbaConsumerBase) {
        this.rtcout.println(2, "registerConsumer()");
        if (!this.appendInterface(string, string2, PortInterfacePolarity.REQUIRED)) {
            return false;
        }
        Consumer consumer = new Consumer(string, string2, corbaConsumerBase);
        this.m_consumers.add(consumer);
        return true;
    }

    @Override
    public void activateInterfaces() {
        Set<String> set = this.m_servants.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                String string = iterator.next();
                this._default_POA().activate_object_with_id(this.m_servants.get((java.lang.Object)string).oid, this.m_servants.get((java.lang.Object)string).servant);
            }
            catch (ServantAlreadyActive servantAlreadyActive) {
            }
            catch (ObjectAlreadyActive objectAlreadyActive) {
            }
            catch (WrongPolicy wrongPolicy) {}
        }
    }

    @Override
    public void deactivateInterfaces() {
        Set<String> set = this.m_servants.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                String string = iterator.next();
                this._default_POA().deactivate_object(this.m_servants.get((java.lang.Object)string).oid);
            }
            catch (ObjectNotActive objectNotActive) {
            }
            catch (WrongPolicy wrongPolicy) {}
        }
    }

    @Override
    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        this.rtcout.println(2, "publishInterfaces()");
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        CORBA_SeqUtil.push_back_list(nVListHolder, this.m_providers);
        connectorProfileHolder.value.properties = nVListHolder.value;
        return ReturnCode_t.RTC_OK;
    }

    @Override
    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        this.rtcout.println(2, "subscribeInterfaces()");
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        ORB oRB = Manager.instance().getORB();
        int n = this.m_consumers.size();
        for (int i = 0; i < n; ++i) {
            int n2 = NVUtil.find_index(nVListHolder, this.m_consumers.get((int)i).name);
            if (n2 < 0) continue;
            Any any = nVListHolder.value[n2].value;
            String string = null;
            string = any.type().kind() == TCKind.tk_wstring ? any.extract_wstring() : (any.type().kind() == TCKind.tk_string ? any.extract_string() : any.extract_Value().toString());
            Object object = oRB.string_to_object(string);
            if (object == null) {
                this.rtcout.println(6, "Extracted object is nul reference");
                continue;
            }
            boolean bl = this.m_consumers.get((int)i).consumer.setObject(object);
            if (bl) continue;
            this.rtcout.println(6, "Cannot narrow reference");
        }
        return ReturnCode_t.RTC_OK;
    }

    @Override
    protected void unsubscribeInterfaces(ConnectorProfile connectorProfile) {
        NVListHolder nVListHolder = new NVListHolder(connectorProfile.properties);
        CORBA_SeqUtil.for_each(nVListHolder, (operatorFunc)new unsubscribe(this.m_consumers));
        connectorProfile.properties = nVListHolder.value;
    }

    private class ProviderInfo {
        public Servant servant = null;
        public byte[] oid = null;

        public ProviderInfo() {
        }

        public ProviderInfo(Servant servant, byte[] byArray) {
            this.servant = servant;
            this.oid = byArray;
        }
    }

    private class unsubscribe
    implements operatorFunc {
        private Vector<Consumer> m_cons;
        private int m_len;

        public unsubscribe(Vector<Consumer> vector) {
            this.m_cons = new Vector<Consumer>(vector);
            this.m_len = vector.size();
        }

        @Override
        public void operator(java.lang.Object object) {
            this.operator((NameValue)object);
        }

        public void operator(NameValue nameValue) {
            for (int i = 0; i < this.m_len; ++i) {
                if (!this.m_cons.get((int)i).name.equals(nameValue.name)) continue;
                this.m_cons.get((int)i).consumer.releaseObject();
            }
        }
    }

    private class subscribe
    implements operatorFunc {
        private Vector<Consumer> m_cons;
        private int m_len;

        public subscribe(Vector<Consumer> vector) {
            this.m_cons = new Vector<Consumer>(vector);
            this.m_len = vector.size();
        }

        @Override
        public void operator(java.lang.Object object) {
            this.operator((NameValue)object);
        }

        public void operator(NameValue nameValue) {
            for (int i = 0; i < this.m_len; ++i) {
                if (!this.m_cons.get((int)i).name.equals(nameValue.name)) continue;
                try {
                    Object object = ObjectHelper.extract((Any)nameValue.value);
                    if (object == null) continue;
                    this.m_cons.get((int)i).consumer.setObject(object);
                    continue;
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    // empty catch block
                }
            }
        }
    }

    private class Consumer {
        public String name;
        public CorbaConsumerBase consumer;

        public Consumer(String string, String string2, CorbaConsumerBase corbaConsumerBase) {
            this.name = "port." + string2 + "." + string;
            this.consumer = corbaConsumerBase;
        }

        public Consumer(Consumer consumer) {
            this.name = consumer.name;
            this.consumer = consumer.consumer;
        }
    }
}

