// -*- C++ -*-
/*!
 *
 * @file BufferStatus.h
 * @brief Buffer status enum definition
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 */

#ifndef RTC_BUFFERSTATUS_H
#define RTC_BUFFERSTATUS_H

namespace RTC
{
  /*!
   * @if jp
   * @class BufferStatus mixin class
   * @brief BufferStatus mixin 饹
   *
   * Υ饹ϡenum줿꥿󥳡ɤ򡢥ХåեϢ֥
   * ǶѤ뤿 mixin 饹Ǥ롣Υ꥿󥳡ɤ
   * Ѥ륯饹ǤϡBufferStatus 饹public Ѿ define
   * Ƥ BUFFERSTATUS_ENUM 򥯥饹˵Ҥ뤳ȤѲǽȤ
   * 롣ˤꡢenum  ReturnCode_t Ȥ typedef ʸ
   * ReturnCode_t ѤǤ褦ˤȤȤˡ֤̾ enum 
   * 줿Ƽ̻Ҥ饹̾Ƴ롣
   *
   * @else
   * @class BufferStatus mixin class
   * @brief BufferStatus mixin class
   *
   * This is a mixin class to provide enumed return codes that are
   * commonly utilised in buffer realted sub-classes. To use this
   * class, sub-class should inherit this class as a public super
   * class, and declare BUFFERSTATUS_ENUM defined below. Consequently,
   * ReturnCode_t type that is typedefed by this macro can be used in
   * the sub-class, and enumed identifiers are imported to the class's
   * namespace.
   *
   * @endif
   */
  class BufferStatus
  {
  public:
    /*!
     * @if jp
     * @brief BufferStatus ꥿󥳡
     *
     * ХåեϢΥ饹Ƕ̤Υ꥿󥳡
     *
     * - BUFFER_OK:            ｪλ
     * - BUFFER_ERROR:         Хåե顼
     * - BUFFER_FULL:          Хåեե
     * - BUFFER_EMPTY:         Хåեץƥ
     * - NOT_SUPPORTED:        ̤ݡȵǽ
     * - TIMEOUT:              ॢ
     * - PRECONDITION_NOT_MET: Ƥʤ
     *
     * @else
     * @brief DataPortStatus return codes
     *
     * Common return codes for buffer classes.
     *
     * - BUFFER_OK:            Normal return
     * - BUFFER_ERROR:         Buffer error
     * - BUFFER_FULL:          Buffer full
     * - BUFFER_EMPTY:         Buffer empty
     * - NOT_SUPPORTED:        Not supported function
     * - TIMEOUT:              Timeout
     * - PRECONDITION_NOT_MET: Precodition not met
     *
     * @endif
     */
    enum Enum
      {
        BUFFER_OK = 0,
        BUFFER_ERROR,
        BUFFER_FULL,
        BUFFER_EMPTY,
        NOT_SUPPORTED,
        TIMEOUT,
        PRECONDITION_NOT_MET
      };

    /*!
     * @if jp
     *
     * @brief BufferStatus ꥿󥳡ɤʸѴ
     *
     * BufferStatus ꥿󥳡ɤʸѴ
     *
     * @param status Ѵо BufferStatus ꥿󥳡
     *
     * @return ʸѴ
     *
     * @else
     *
     * @brief Convert BufferStatus into the string.
     *
     * Convert BufferStatus into the string.
     *
     * @param status The target BufferStatus for transformation
     *
     * @return Trnasformation result of string representation
     *
     * @endif
     */
    static const char* toString(Enum status)
    {
      const char* str[] = {
        "BUFFER_OK",
        "BUFFER_ERROR",
        "BUFFER_FULL",
        "BUFFER_EMPTY",
        "NOT_SUPPORTED",
        "TIMEOUT",
        "PRECONDITION_NOT_MET"
      };
      return str[status];
    }
  };
}; // namespace RTC

/*!
 * @if jp
 *
 * @brief ::RTC::BufferStatus Ƴ
 * 
 * ::RTC::BufferStatus Ƥ Enum Τ٤ƤΥФ͡
 * ڡƳ뤿ΥޥBufferStatus Ѥ륯饹ˤ
 * ơ饹Ƭˤ DATAPORTSTATUS_ENUM 򵭺ܤǡ
 * BufferStatus Ƥ enum Ф̾黻Ҥʤ˥
 * ǽˤʤ롣
 *
 * @else
 *
 * @brief Importing ::RTC::BufferStatus macro
 *
 * This macro imports all the member of enum declared in
 * ::RTC::BufferStatus into the current namespace.  Inserting at the
 * head of class declaration, classes which utilize BufferStatus can
 * access Enum members of BufferStatus without using namespace
 * resolve operator.
 *
 * @endif
 */
#define BUFFERSTATUS_ENUM \
  typedef ::RTC::BufferStatus::Enum ReturnCode;       \
  using ::RTC::BufferStatus::BUFFER_OK;               \
  using ::RTC::BufferStatus::BUFFER_ERROR;            \
  using ::RTC::BufferStatus::BUFFER_FULL;             \
  using ::RTC::BufferStatus::BUFFER_EMPTY;            \
  using ::RTC::BufferStatus::NOT_SUPPORTED;           \
  using ::RTC::BufferStatus::TIMEOUT;                 \
  using ::RTC::BufferStatus::PRECONDITION_NOT_MET;

#endif // RTC_BUFFERSTATUS_H
