// -*- C++ -*-
/*!
 * @file InPortBase.h
 * @brief RTC::Port implementation for InPort
 * @date $Date: 2008-01-13 15:06:40 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006-2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef RTC_INPORTBASE_H
#define RTC_INPORTBASE_H

#include <rtm/PortBase.h>
#include <rtm/DataPortStatus.h>
#include <rtm/CdrBufferBase.h>
#include <rtm/ConnectorListener.h>

/*!
 * @if jp
 * @namespace RTC
 *
 * @brief RTݡͥ
 *
 * @else
 *
 * @namespace RTC
 *
 * @brief RT-Component
 *
 * @endif
 */
namespace RTC
{
  class InPortProvider;
  class OutPortConsumer;
  class InPortConnector;

  /*!
   * @if jp
   * @class InPortBase
   * @brief InPort  Port
   *
   * ǡϥݡȤμ饹
   *
   * @since 0.4.0
   *
   * @else
   * @class InPortBase
   * @brief Port for InPort
   *
   * This is an implementation class for the data input port.
   *
   * @since 0.4.0
   *
   * @endif
   */
  class InPortBase
    : public PortBase, public DataPortStatus
  {
  public:
    DATAPORTSTATUS_ENUM

    typedef std::vector<InPortConnector*> ConnectorList;

    /*!
     * @if jp
     * @brief 󥹥ȥ饯
     *
     * 󥹥ȥ饯
     *
     * @param name ݡ̾
     * @param data_type ǡ
     *
     * @else
     * @brief Constructor
     *
     * Constructor
     *
     * @param name Port name
     * @param data_type Data type
     *
     * @endif
     */
    InPortBase(const char* name, const char* data_type);
    
    /*!
     * @if jp
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~InPortBase(void);

    /*!
     * @if jp
     * @brief ץѥƥν
     *
     * ꤵ줿ץѥƥǽ롣
     *
     * @param prop ꤹץѥƥ
     * @else
     * @brief Initializing properties
     *
     * This method initializes the port in the specified property. 
     *
     * @param prop Property for setting ports
     * @endif
     */
    void init(coil::Properties& prop);

    /*!
     * @if jp
     * @brief RTObject_impl::readAll()ƤФ벾۴ؿ
     *
     * DataPort ǡɤ߽Ф
     *
     * @return true:,false:
     * @else
     * @brief It is a virtual method that is called from RTObject_impl::readAll().
     * This method reads out data from DataPort. 
     *
     * @return true:Success,false:Failure
     * @endif
     */
    virtual bool read() = 0;

    /*!
     * @if jp
     * @brief ץѥƥ
     *
     * ݡȤΥץѥƥ롣
     *
     * @return ץѥƥ
     * @else
     * @brief Get properties
     *
     * This method gets properties in the port. 
     *
     * @return Properties
     * @endif
     */
    coil::Properties& properties();

    /*!
     * @if jp
     * @brief Connector 
     *
     * ߽ͭƤ륳ͥ롣
     *
     * @return connector Υꥹ
     *
     * @else
     *
     * @brief Connector list
     *
     * This operation returns connector list
     *
     * @return connector list
     *
     * @endif
     */
    const std::vector<InPortConnector*>& connectors();

    /*!
     * @if jp
     * @brief ConnectorProfile 
     *
     * ߽ͭƤ륳ͥProfile롣
     *
     * @return ConnectorProfile Υꥹ
     *
     * @else
     *
     * @brief ConnectorProfile list
     *
     * This operation returns ConnectorProfile list
     *
     * @return connector list
     *
     * @endif
     */
    ConnectorInfoList getConnectorProfiles();

    /*!
     * @if jp
     * @brief ConnectorId 
     *
     * ߽ͭƤ륳ͥID롣
     *
     * @return ConnectorId Υꥹ
     *
     * @else
     *
     * @brief ConnectorId list
     *
     * This operation returns ConnectorId list
     *
     * @return connector list
     *
     * @endif
     */
    coil::vstring getConnectorIds();

    /*!
     * @if jp
     * @brief Connector̾
     *
     * ߽ͭƤ륳ͥ̾롣
     *
     * @return Connector̾Υꥹ
     *
     * @else
     *
     * @brief Connector name list
     *
     * This operation returns Connector name list
     *
     * @return connector name list
     *
     * @endif
     */
    coil::vstring getConnectorNames();

    /*!
     * @if jp
     * @brief ConnectorProfileIDǼ
     *
     * ߽ͭƤ륳ͥIDǼ롣
     *
     * @param id Connector ID
     * @return ͥؤΥݥ
     *
     * @else
     *
     * @brief Getting ConnectorProfile by ID
     *
     * This operation returns Connector specified by ID.
     *
     * @param id Connector ID
     * @return A pointer to connector
     *
     * @endif
     */
    InPortConnector* getConnectorById(const char* id);

     /*!
     * @if jp
     * @brief ConnectorProfile̾Ǽ
     *
     * ߽ͭƤ륳ͥ̾Ǽ롣
     *
     * @param name Connector name
     * @return ͥؤΥݥ
     *
     * @else
     *
     * @brief Getting Connector by name
     *
     * This operation returns Connector specified by name.
     *
     * @param id Connector ID
     * @return A pointer to connector
     *
     * @endif
     */
   InPortConnector* getConnectorByName(const char* name);

    /*!
     * @if jp
     * @brief ConnectorProfileIDǼ
     *
     * ߽ͭƤ륳ͥIDǼ롣
     *
     * @param id Connector ID
     * @param prof ConnectorProfile
     * @return false ꤷIDʤ
     *
     * @else
     *
     * @brief Getting ConnectorProfile by name
     *
     * This operation returns ConnectorProfile specified by name
     *
     * @param id Connector ID
     * @param prof ConnectorProfile
     * @return falsespecified ID does not exist
     *
     * @endif
     */
    bool getConnectorProfileById(const char* id,
                                 ConnectorInfo& prof);

    /*!
     * @if jp
     * @brief ConnectorProfile̾Ǽ
     *
     * ߽ͭƤ륳ͥ̾Ǽ롣
     *
     * @param name Connector name
     * @param prof ConnectorProfile
     * @return false ꤷ̾ʤ
     *
     * @else
     *
     * @brief Getting ConnectorProfile by name
     *
     * This operation returns ConnectorProfile specified by name
     *
     * @param id Connector ID
     * @param prof ConnectorProfile
     * @return false specified name does not exist
     *
     * @endif
     */
    bool getConnectorProfileByName(const char* name,
                                   ConnectorInfo& prof);


    /*!
     * @if jp
     *
     * @brief InPort activates 
     *
     * Port ϿƤƤΥ󥿡ե activate 롣
     *
     * @else
     *
     * @brief Activate all Port interfaces
     *
     * This operation activate all interfaces that is registered in the
     * ports.
     *
     * @endif
     */
    virtual void activateInterfaces();

    /*!
     * @if jp
     *
     * @brief Ƥ Port Υ󥿡ե deactivates 
     *
     * Port ϿƤƤΥ󥿡ե deactivate 롣
     *
     * @else
     *
     * @brief Deactivate all Port interfaces
     *
     * This operation deactivate all interfaces that is registered in the
     * ports.
     *
     * @endif
     */
    virtual void deactivateInterfaces();

    /*!
     * @if jp
     * @brief ConnectorDataListener ꥹʤɲä
     *
     * Хåե񤭹ߤޤɤ߽Ф٥Ȥ˴ϢƼꥹʤꤹ롣
     *
     * ǤꥹʤΥפȥХå٥Ȥϰʲ̤
     *
     * - ON_BUFFER_WRITE:          Хåե񤭹߻
     * - ON_BUFFER_FULL:           Хåեե
     * - ON_BUFFER_WRITE_TIMEOUT:  Хåե񤭹ߥॢȻ
     * - ON_BUFFER_OVERWRITE:      Хåե񤭻
     * - ON_BUFFER_READ:           Хåեɤ߽Ф
     * - ON_SEND:                  InProtؤ
     * - ON_RECEIVED:              InProtؤλ
     * - ON_SEND_ERTIMEOUT:        OutPort¦ॢȻ
     * - ON_SEND_ERERROR:          OutPort¦顼
     * - ON_RECEIVER_FULL:         InProt¦Хåեե
     * - ON_RECEIVER_TIMEOUT:      InProt¦ХåեॢȻ
     * - ON_RECEIVER_ERROR:        InProt¦顼
     *
     * ꥹʤ ConnectorDataListener ѾʲΥ˥
     * operator() Ƥɬפ롣
     *
     * ConnectorDataListener::
     *         operator()(const ConnectorProfile&, const cdrStream&)
     *
     * ǥեȤǤϡδؿͿꥹʥ֥Ȥνͭ
     * OutPort˰ܤꡢOutPortλ⤷ϡ
     * removeConnectorDataListener() ˤ˼ưŪ˲Τ롣
     * ꥹʥ֥ȤνͭƤӽФ¦ǰݻϡ3
     *  false ꤷưŪʲΤ뤳ȤǤ롣
     *
     * @param listener_type ꥹʥ
     * @param listener ꥹʥ֥ȤؤΥݥ
     * @param autoclean ꥹʥ֥ȤμưŪΤԤɤΥե饰
     *
     * @else
     * @brief Adding BufferDataListener type listener
     *
     * This operation adds certain listeners related to buffer writing and
     * reading events.
     * The following listener types are available.
     *
     * - ON_BUFFER_WRITE:          At the time of buffer write
     * - ON_BUFFER_FULL:           At the time of buffer full
     * - ON_BUFFER_WRITE_TIMEOUT:  At the time of buffer write timeout
     * - ON_BUFFER_OVERWRITE:      At the time of buffer overwrite
     * - ON_BUFFER_READ:           At the time of buffer read
     * - ON_SEND:                  At the time of sending to InPort
     * - ON_RECEIVED:              At the time of finishing sending to InPort
     * - ON_SENDER_TIMEOUT:        At the time of timeout of OutPort
     * - ON_SENDER_ERROR:          At the time of error of OutPort
     * - ON_RECEIVER_FULL:         At the time of bufferfull of InPort
     * - ON_RECEIVER_TIMEOUT:      At the time of timeout of InPort
     * - ON_RECEIVER_ERROR:        At the time of error of InPort
     *
     * Listeners should have the following function operator().
     *
     * ConnectorDataListener::
     *         operator()(const ConnectorProfile&, const cdrStream&)
     *
     * The ownership of the given listener object is transferred to
     * this OutPort object in default.  The given listener object will
     * be destroied automatically in the OutPort's dtor or if the
     * listener is deleted by removeConnectorDataListener() function.
     * If you want to keep ownership of the listener object, give
     * "false" value to 3rd argument to inhibit automatic destruction.
     *
     * @param listener_type A listener type
     * @param listener A pointer to a listener object
     * @param autoclean A flag for automatic listener destruction
     *
     * @endif
     */
    void addConnectorDataListener(ConnectorDataListenerType listener_type,
                                  ConnectorDataListener* listener,
                                  bool autoclean = true);


    /*!
     * @if jp
     * @brief ConnectorDataListener ꥹʤ
     *
     * ꤷƼꥹʤ롣
     * 
     * @param listener_type ꥹʥ
     * @param listener ꥹʥ֥ȤؤΥݥ
     *
     * @else
     * @brief Removing BufferDataListener type listener
     *
     * This operation removes a specified listener.
     *     
     * @param listener_type A listener type
     * @param listener A pointer to a listener object
     *
     * @endif
     */
    void removeConnectorDataListener(ConnectorDataListenerType listener_type,
                                     ConnectorDataListener* listener);
    

    /*!
     * @if jp
     * @brief ConnectorListener ꥹʤɲä
     *
     * Хåե񤭹ߤޤɤ߽Ф٥Ȥ˴ϢƼꥹʤꤹ롣
     *
     * ǤꥹʤΥפ
     *
     * - ON_BUFFER_EMPTY:       Хåեξ
     * - ON_BUFFER_READTIMEOUT: ХåեǥॢȤ
     *
     * ꥹʤϰʲΥ˥ operator() Ƥɬפ롣
     *
     * ConnectorListener::operator()(const ConnectorProfile&)
     *
     * ǥեȤǤϡδؿͿꥹʥ֥Ȥνͭ
     * OutPort˰ܤꡢOutPortλ⤷ϡ
     * removeConnectorListener() ˤ˼ưŪ˲Τ롣
     * ꥹʥ֥ȤνͭƤӽФ¦ǰݻϡ3
     *  false ꤷưŪʲΤ뤳ȤǤ롣
     *
     * @param listener_type ꥹʥ
     * @param listener ꥹʥ֥ȤؤΥݥ
     * @param autoclean ꥹʥ֥ȤμưŪΤԤɤΥե饰
     *
     * @else
     * @brief Adding ConnectorListener type listener
     *
     * This operation adds certain listeners related to buffer writing and
     * reading events.
     * The following listener types are available.
     *
     * - ON_BUFFER_EMPTY:       At the time of buffer empty
     * - ON_BUFFER_READTIMEOUT: At the time of buffer read timeout
     *
     * Listeners should have the following function operator().
     *
     * ConnectorListener::operator()(const ConnectorProfile&)
     *  
     * The ownership of the given listener object is transferred to
     * this OutPort object in default.  The given listener object will
     * be destroied automatically in the OutPort's dtor or if the
     * listener is deleted by removeConnectorListener() function.
     * If you want to keep ownership of the listener object, give
     * "false" value to 3rd argument to inhibit automatic destruction.
     *
     * @param listener_type A listener type
     * @param listener A pointer to a listener object
     * @param autoclean A flag for automatic listener destruction
     *
     * @endif
     */
    void addConnectorListener(ConnectorListenerType callback_type,
                              ConnectorListener* listener,
                              bool autoclean = true);

    /*!
     * @if jp
     * @brief ConnectorDataListener ꥹʤ
     *
     * ꤷƼꥹʤ롣
     * 
     * @param listener_type ꥹʥ
     * @param listener ꥹʥ֥ȤؤΥݥ
     *
     * @else
     * @brief Removing BufferDataListener type listener
     *
     * This operation removes a specified listener.
     *     
     * @param listener_type A listener type
     * @param listener A pointer to a listener object
     *
     * @endif
     */
    void removeConnectorListener(ConnectorListenerType callback_type,
                                 ConnectorListener* listener);

    /*!
     * @if jp
     * @brief endian ֤
     *
     * endian bool֤ͤ
     *
     * @return m_littleEndian littleξtruebigξfalse ֤
     *
     * @else
     * @brief
     *
     * return it whether endian setting.
     *
     *@return Return true in the case of "little", false in "big" than it.
     *
     * @endif
     */
    bool isLittleEndian();

    /*!
     * @if jp
     *
     * @brief [CORBA interface] Port ³Ԥ
     *
     * Ϳ줿 ConnectoionProfile ξ˴ŤPort֤³Ω
     * 롣δؿϼ˥ץꥱץġ뤫Ƥӽ
     * ȤȤƤ롣
     * 
     * @param connector_profile ConnectorProfile
     * @return ReturnCode_t Υ꥿󥳡
     *
     * @else
     *
     * @brief [CORBA interface] Connect the Port
     *
     * This operation establishes connection according to the given
     * ConnectionProfile inforamtion. This function is premised on
     * calling from mainly application program or tools.
     *
     * @param connector_profile The ConnectorProfile.
     * @return ReturnCode_t The return code of ReturnCode_t type.
     *
     * @endif
     */
    virtual ReturnCode_t
    connect(ConnectorProfile& connector_profile)
      throw (CORBA::SystemException);

  protected:

    /*!
     * @if jp
     * @brief Interface
     *
     * Interface롣
     *  ConnectorProfile ˳ǼƤ dataflow_type  push 
     * ξϡꤵ줿 interface_type  InPortProvider ˴ؤ
     *  ConnectorProfile::properties ˽߸ƤӽФ¦᤹
     *
     *  dataport.dataflow_type
     *
     * @param connector_profile ͥץե
     *
     * @return ReturnCode_t Υ꥿󥳡
     *
     * @else
     * @brief Publish interface information
     *
     * Publish interface information.
     * Assign the Provider information that owned by this port
     * to ConnectorProfile#properties
     *
     * @param connector_profile The connector profile
     *
     * @return The return code of ReturnCode_t type
     *
     * @endif
     */
    virtual ReturnCode_t
    publishInterfaces(ConnectorProfile& connector_profile);
    
    /*!
     * @if jp
     * @brief Interface³
     *
     * Interface³롣
     * PortͭConsumerŬ礹Provider˴ؤ 
     * ConnectorProfile#properties Ф
     * ConsumerCORBA֥ȻȤꤹ롣
     *
     * @param connector_profile ͥץե
     *
     * @return ReturnCode_t Υ꥿󥳡
     *
     * @else
     * @brief Subscribe to the interface
     *
     * Subscribe to interface.
     * Derive Provider information that matches Consumer owned by the Port 
     * from ConnectorProfile#properties and 
     * set the Consumer to the reference of the CORBA object.
     *
     * @param connector_profile The connector profile
     *
     * @return ReturnCode_t The return code of ReturnCode_t type
     *
     * @endif
     */
    virtual ReturnCode_t
    subscribeInterfaces(const ConnectorProfile& connector_profile);
    
    /*!
     * @if jp
     * @brief Interfaceؤ³
     *
     * Interfaceؤ³롣
     * Ϳ줿ConnectorProfile˴ϢConsumerꤵ줿ƤObject
     * ³롣
     *
     * @param connector_profile ͥץե
     *
     * @else
     * @brief Disconnect the interface connection
     *
     * Disconnect the interface connection.
     * Release all objects set in Consumer associated with 
     * given ConnectorProfile and unscribe the interface.
     *
     * @param connector_profile The connector profile
     *
     * @endif
     */
    virtual void
    unsubscribeInterfaces(const ConnectorProfile& connector_profile);


    /*!
     * @if jp
     * @brief InPort provider ν
     * @else
     * @brief InPort provider initialization
     * @endif
     */
    void initProviders();

    /*!
     * @if jp
     * @brief OutPort consumer ν
     * @else
     * @brief OutPort consumer initialization
     * @endif
     */
    void initConsumers();

    /*!
     * @if jp
     * @brief ꥢ饤Υǥå
     *
     * Ϳ줿ץѥƥꤵƤ롢ǡΥꥢ饤Υ
     * ǥå롣ǥ꤬ʤƤ
     * Сtrue ֤ littleEndian ˡͤȥ륨ǥ
     * Ǥ true ӥåǥǤ false ֤롣
     *
     * @param prop åץѥƥ
     * @param littleEndian ǥtrue:little,false:big
     * @return true:"serializer"¸ߤʤ ޤ ¸ߤƤƤ롣
,false:"serializer"¸ߤƤ뤬Ƥ ޤ ¸ߤƤ뤬Ƥ"little","big" ʳ
     *
     * @else
     *
     * @brief Checking endian flag of serializer
     *
     * This operation checks endian flag of data serializer that is
     * specified properties. If valid specification is found, this
     * operation returns true and set argument littleEndian. True
     * means little endian, false means big endian.
     *
     * @param prop Properties
     * @param littleEndian Endian Information(true:little,false:big)
     * @return true:"Serializer" key doesn't exist. or  "Serializer" key exists and there is a content.
     *
     *false:There is no content though "Serializer" key exists. or ithe content is not "Little. " though "Serializer" key exists. or The content is not "little" or "big" though "Serializer" key exists.
     *
     * @endif
     */
    bool checkEndian(const coil::Properties& prop, bool& littleEndian);

    /*!
     * @if jp
     * @brief InPort provider 
     *
     * InPortProvider  ConnectorProfile ˸롣
     * ˼Ԥ 0 ֤
     *
     * @else
     * @brief InPort provider creation
     * @endif
     */
    InPortProvider*
    createProvider(ConnectorProfile& cprof, coil::Properties& prop);

    /*!
     * @if jp
     * @brief OutPort consumer 
     *
     * OutPortConsumer 롣
     * ˼Ԥ 0 ֤
     *
     * @else
     * @brief InPort provider creation
     * @endif
     */
    OutPortConsumer*
    createConsumer(const ConnectorProfile& cprof, coil::Properties& prop);

    /*!
     * @if jp
     * @brief InPortPushConnector 
     *
     * Connector  m_connectors ¸롣
     * ˼Ԥ 0 ֤
     *
     * @else
     * @brief InPortPushConnector creation
     * @endif
     */
    InPortConnector*
    createConnector(ConnectorProfile& cprof, coil::Properties& prop,
                    InPortProvider* provider);
    /*!
     * @if jp
     * @brief InPortPullConnector 
     *
     * Connector  m_connectors ¸롣
     * ˼Ԥ 0 ֤
     *
     * @else
     * @brief InPortPullConnector creation
     * @endif
     */
    InPortConnector*
    createConnector(const ConnectorProfile& cprof, coil::Properties& prop,
                    OutPortConsumer* consumer);

  protected:
    /*!
     * @if jp
     * @brief Хåե⡼
     *
     * true:single buffer mode.
     * false:multi buffer mode.
     *
     * @else
     * @brief Buffer mode
     *
     * true:single buffer mode.
     * false:multi buffer mode.
     *
     * @endif
     */
    bool m_singlebuffer;
    /*!
     * @if jp
     * @brief Хåե
     * @else
     * @brief Buffer
     * @endif
     */
    CdrBufferBase* m_thebuffer;
    /*!
     * @if jp
     * @brief ץѥƥ
     * @else
     * @brief Properties
     * @endif
     */
    coil::Properties m_properties;
    /*!
     * @if jp
     * @brief Ѳǽprovider
     * @else
     * @brief Available providers
     * @endif
     */
    coil::vstring m_providerTypes;
    /*!
     * @if jp
     * @brief Ѳǽconsumer
     * @else
     * @brief Available consumers
     * @endif
     */
    coil::vstring m_consumerTypes;
    /*!
     * @if jp
     * @brief ³ꥹ
     * @else
     * @brief Connection list
     * @endif
     */
    ConnectorList m_connectors;
    /*!
     * @if jp
     * @brief ³ǥ 
     * @else
     * @brief Connected Endian
     * @endif
     */
    bool m_littleEndian;

    /*!
     * @if jp
     * @brief ConnectorDataListener ꥹ
     * @else
     * @brief ConnectorDataListener listener
     * @endif
     */
    ConnectorListeners m_listeners;
  };
}; // namespace RTC

#endif // RTC_INPORTBASE_H
