/*
    Copyright 2021 Picovoice Inc.

    You may not use this file except in compliance with the license. A copy of the license is located in the "LICENSE"
    file accompanying this source.

    Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
    specific language governing permissions and limitations under the License.
*/

#ifndef PV_PARAMS_H
#define PV_PARAMS_H

#include <stdint.h>

#if defined(__PV_LANGUAGE_ENGLISH__)

// Wake-word = porcupine
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x99, 0x25, 0xf3, 0xbc, 0xfb, 0x72, 0x93, 0xb0, 0xfe, 0x97, 0x36, 0xb7, 0xd7, 0xca, 0xb8, 0xd3, 0x51, 0x04,
        0x0e, 0x4b, 0x5d, 0x0f, 0x29, 0x65, 0xdd, 0x75, 0xc0, 0x7b, 0xed, 0x9a, 0xc4, 0xbf, 0xf5, 0xbe, 0x3c, 0x83,
        0x09, 0x1a, 0xa6, 0xce, 0x69, 0xad, 0x30, 0xee, 0x42, 0x71, 0x06, 0x88, 0x9a, 0xec, 0x72, 0xb6, 0x03, 0xef,
        0xe0, 0xad, 0x4d, 0xe4, 0x4a, 0xbb, 0xe1, 0xfe, 0x27, 0x23, 0x49, 0x42, 0xfb, 0x43, 0x7a, 0x17, 0xee, 0x6a,
        0xbb, 0x91, 0xc5, 0xff, 0x1d, 0x54, 0xef, 0x0e, 0x63, 0xce, 0xb0, 0xda, 0x9e, 0x3e, 0x0f, 0x81, 0x1e, 0x6f,
        0x03, 0xc6, 0x8e, 0x0d, 0x8e, 0x31, 0xc9, 0x80, 0x7d, 0x46, 0x91, 0x70, 0x64, 0x71, 0xf7, 0xf0, 0x78, 0xec,
        0x32, 0x6c, 0xce, 0x5d, 0xb9, 0xad, 0xe3, 0x8a, 0x9e, 0xbb, 0x31, 0x26, 0x15, 0x2b, 0x70, 0x1e, 0x45, 0xda,
        0xff, 0x58, 0xb0, 0x2a, 0x52, 0x2f, 0x5d, 0x25, 0xd4, 0x93, 0x0a, 0xf3, 0x54, 0xe6, 0xea, 0xb5, 0x51, 0xbe,
        0x0d, 0x04, 0xec, 0x2b, 0x64, 0x81, 0x68, 0x1d, 0x8a, 0xd2, 0xa1, 0xd7, 0xea, 0xdf, 0x4d, 0x97, 0xda, 0x5a,
        0xb9, 0xbe, 0x97, 0xf7, 0x3e, 0xf6, 0xf4, 0x48, 0xc6, 0xc0, 0x65, 0x00, 0xe0, 0xf7, 0x19, 0x69, 0x23, 0xfe,
        0x15, 0x0f, 0xd2, 0x11, 0xd8, 0xa6, 0x26, 0xa2, 0x63, 0x2f, 0x1a, 0x63, 0x8c, 0xd7, 0x08, 0xa4, 0x01, 0x53,
        0x2a, 0x3e, 0x96, 0x7d, 0xe4, 0xda, 0x39, 0xc2, 0x8c, 0x04, 0x3f, 0xc3, 0x43, 0xae, 0xb2, 0xed, 0xe3, 0x1c,
        0xf4, 0x36, 0x44, 0xe7, 0xc5, 0x12, 0x6e, 0xa4, 0x21, 0x4f, 0xfc, 0xbc, 0xe8, 0x38, 0x15, 0xcf, 0xb6, 0xcf,
        0xac, 0x8b, 0x20, 0x30, 0xea, 0x8b, 0xeb, 0xca, 0x67, 0x16, 0x09, 0xf8, 0x9a, 0x19, 0x36, 0x1c, 0x08, 0xf3,
        0x7c, 0xd7, 0xa6, 0xa8, 0xf8, 0xfb, 0x86, 0xff, 0xa2, 0x09, 0x86, 0xf5, 0x73, 0xa3, 0xa0, 0x57, 0xff, 0x1a,
        0xef, 0xe6, 0x87, 0xa1, 0xb0, 0xa5, 0x85, 0x30, 0xe3, 0x9b, 0x19, 0x43, 0x57, 0x68, 0x57, 0x19, 0xa7, 0x5b,
        0x05, 0xd1, 0x8a, 0x19, 0xe5, 0xb3, 0x67, 0x1c, 0xf3, 0x4a, 0x2f, 0xda, 0x53, 0xa4, 0xf9, 0xf2, 0x53, 0xd6,
        0xa9, 0x29, 0x73, 0xd4, 0x2f, 0xf8, 0xe5, 0x7d, 0xa2, 0x74, 0x9d, 0xfa, 0x4f, 0xb8, 0xd8, 0xfd, 0x4c, 0x97,
        0xe8, 0x0b, 0x1f, 0x0f, 0xa7, 0x4b, 0x43, 0x4e, 0x52, 0xd6, 0x38, 0x20, 0x41, 0x75, 0x6b, 0xbe, 0xaa, 0xc9,
        0xa2, 0x97, 0xae, 0x08, 0xce, 0x26, 0xb5, 0x02, 0x79, 0x38, 0x55, 0x62, 0x95, 0xce, 0xe9, 0xda, 0x73, 0xe5,
        0x62, 0xff, 0x6e, 0x9a, 0x85, 0x17, 0xbc, 0xe5, 0x2b, 0x35, 0x87, 0x94, 0x85, 0xa9, 0x64, 0x77, 0xe8, 0xec,
        0x18, 0xe7, 0x21, 0x55, 0x06, 0x23, 0x50, 0x11, 0xf4, 0x1f, 0x38, 0xf5, 0x77, 0xec, 0xc4, 0x2d, 0xda, 0xc4,
        0x03, 0xd5, 0x64, 0xbd, 0x68, 0x68, 0x4a, 0x6d, 0xd5, 0x33, 0x8f, 0xc1, 0xce, 0xa9, 0xae, 0xac, 0x49, 0xe5,
        0xb5, 0xbb, 0xbe, 0x51, 0x03, 0xf9, 0x95, 0x5f, 0x33, 0x05, 0xac, 0x11, 0x10, 0x92, 0x69, 0xc2, 0x0f, 0xa9,
        0x7e, 0x3c, 0xd9, 0x2c, 0x60, 0x01, 0x4f, 0xdb, 0x9f, 0x0a, 0x09, 0xb5, 0x6a, 0x44, 0xbb, 0xcd, 0x99, 0xa4,
        0x5d, 0x60, 0xea, 0xa9, 0xb1, 0x4f, 0xe6, 0x42, 0xea, 0xb8, 0x24, 0xc8, 0xcb, 0xd3, 0xd5, 0x74, 0xdd, 0x54,
        0x3c, 0x78, 0x89, 0x1f, 0xed, 0xb8, 0x3f, 0x4b, 0x50, 0x88, 0x2e, 0x42, 0x8b, 0xe6, 0xf4, 0x24, 0x4e, 0xdd,
        0x81, 0x95, 0x03, 0x7a, 0x35, 0x8e, 0x31, 0x9a, 0xdf, 0x85, 0xc9, 0xdc, 0xdd, 0xc6, 0x3f, 0x61, 0x6d, 0x81,
        0x7f, 0x58, 0xdc, 0x76, 0x4d, 0x76, 0x87, 0x6b, 0x43, 0x89, 0x6b, 0xb8, 0x1c, 0x46, 0x7e, 0xdd, 0x8f, 0xd4,
        0x77, 0xe5, 0xde, 0x42, 0x93, 0x67, 0x83, 0x95, 0x97, 0xa0, 0x5a, 0xf8, 0x1e, 0x34, 0x5d, 0x8e, 0xd8, 0x32,
        0xe2, 0x55, 0x83, 0x2e, 0x8e, 0x50, 0xe8, 0xbd, 0x96, 0x7a, 0xda, 0x0b, 0x6f, 0xe8, 0x7c, 0x0d, 0x1c, 0x8b,
        0xa8, 0x92, 0xce, 0x27, 0x70, 0xe6, 0x90, 0x78, 0x4e, 0x3e, 0x0c, 0x8a, 0x54, 0xc7, 0xec, 0x13, 0xf0, 0x9b,
        0x0a, 0x36, 0xd3, 0xb4, 0x44, 0x51, 0xff, 0xd0, 0x8a, 0x4e, 0x0c, 0x76, 0xf5, 0x02, 0x54, 0xc2, 0xf6, 0x78,
        0x21, 0xdc, 0xe1, 0xb0, 0xe5, 0x99, 0x4c, 0x82, 0x2d, 0xb0, 0xbc, 0x39, 0x18, 0x7e, 0xc7, 0xff, 0x7d, 0x22,
        0x67, 0xfc, 0x85, 0x51, 0x46, 0x7a, 0x85, 0x7a, 0xef, 0xb1, 0x2e, 0x3c, 0xcf, 0x5a, 0xd4, 0x7c, 0xc0, 0x06,
        0x0d, 0xc6, 0x95, 0x86, 0x28, 0x93, 0x26, 0x30, 0x96, 0xfe, 0xe4, 0x4a, 0x06, 0xf0, 0x1a, 0xb8, 0x7b, 0x1b,
        0x05, 0xdf, 0xf7, 0x44, 0x49, 0x1c, 0x29, 0xc7, 0x87, 0x3e, 0xd8, 0x1d, 0xff, 0x62, 0x6c, 0xa7, 0xdd, 0x04,
        0xfc, 0x36, 0x79, 0x38, 0x1e, 0xb8, 0xc1, 0x47, 0xef, 0x04, 0xcb, 0xbe, 0xff, 0x0b, 0x0a, 0x7a, 0x2c, 0x2f,
        0x2d, 0x74, 0x45, 0xd2, 0xf5, 0x05, 0xe4, 0xd8, 0x2b, 0xde, 0x3b, 0x92, 0x67, 0x07, 0xe9, 0x4f, 0xaa, 0x78,
        0x83, 0x0c, 0x54, 0x6a, 0x59, 0xad, 0xb1, 0x7a, 0x90, 0xc7, 0xa5, 0x36, 0xbb, 0x1d, 0x77, 0x85, 0x61, 0x05,
        0xc5, 0x4a, 0x63, 0xb1, 0x27, 0xb4, 0x1d, 0xb2, 0x05, 0x7e, 0x06, 0x3e, 0xc8, 0xec, 0x63, 0x75, 0x22, 0x2a,
        0x43, 0xb5, 0xfa, 0xee, 0x96, 0x37, 0x05, 0xd9, 0xb1, 0x17, 0x27, 0x16, 0x6d, 0x42, 0xb7, 0xed, 0xc7, 0x14,
        0x2e, 0xc0, 0xa7, 0xed, 0x81, 0x56, 0x7a, 0xa5, 0x46, 0x58, 0x0e, 0x48, 0x94, 0x84, 0x56, 0x6b, 0xd2, 0xc4,
        0x86, 0x89, 0xc7, 0x97, 0xb2, 0xcb, 0xed, 0x08, 0xa6, 0xde, 0xef, 0x35, 0x25, 0x68, 0xc2, 0x5b, 0xf0, 0xad,
        0x30, 0xc8, 0x25, 0xa5, 0x54, 0xb8, 0xcd, 0x16, 0xaa, 0x34, 0x47, 0xca, 0x1f, 0x4f, 0x13, 0x06, 0x23, 0x84,
        0x6d, 0x7f, 0x2b, 0x2e, 0x1e, 0xad, 0x1b, 0xf3, 0x53, 0x3c, 0xa5, 0xa8, 0x3f, 0x2f, 0x40, 0x30, 0x8c, 0xea,
        0x9f, 0xc8, 0x2a, 0x22, 0x16, 0xc2, 0xed, 0xd4, 0x58, 0x38, 0x22, 0xdc, 0x06, 0x19, 0x45, 0x25, 0x06, 0x5d,
        0x35, 0x4d, 0xfe, 0xeb, 0xc2, 0x81, 0x03, 0x28, 0x40, 0x8b, 0x88, 0x01, 0x6d, 0x9e, 0x20, 0xc9, 0xe3, 0xbc,
        0xfd, 0xc8, 0x73, 0x17, 0xd8, 0x56, 0xc6, 0x85, 0xd2, 0x80, 0x6e, 0x4a, 0xa5, 0xde, 0xfd, 0xb6, 0xe9, 0x64,
        0xdf, 0x70, 0xf7, 0xa4, 0x3e, 0x4c, 0x57, 0x12, 0x77, 0x2d, 0x3e, 0x1d, 0xc1, 0xed, 0x48, 0x05, 0xea, 0x6f,
        0x2b, 0xe1, 0x7a, 0x2c, 0x45, 0xc2, 0x07, 0xd2, 0xf5, 0xa1, 0xdb, 0x25, 0x4c, 0x8f, 0x0e, 0x01, 0x38, 0xbe,
        0x54, 0xb5, 0x00, 0x99, 0x92, 0x71, 0xdd, 0x64, 0x8e, 0xfb, 0x3f, 0x7f, 0x28, 0xb1, 0x81, 0xe9, 0xa4, 0x58,
        0x10, 0xab, 0x07, 0x6e, 0x01, 0x6a, 0xf1, 0x4b, 0xe7, 0xb4, 0x6e, 0x78, 0xfe, 0xa6, 0x47, 0x86, 0xd8, 0x19,
        0x51, 0x7f, 0xcf, 0x10, 0xaf, 0x83, 0xeb, 0x5d, 0xcd, 0xf5, 0xf6, 0xaf, 0x19, 0x3f, 0xd9, 0xd4, 0x27, 0x99,
        0xba, 0x91, 0xbe, 0x20, 0x8f, 0x81, 0x2e, 0x60, 0xb7, 0xb6, 0xfb, 0x06, 0x02, 0x0b, 0x26, 0xdb, 0xbc, 0x98,
        0x09, 0xe8, 0xfa, 0x97, 0xc1, 0x7b, 0x89, 0xd9, 0x27, 0x35, 0x4e, 0x33, 0x9f, 0xb4, 0x0f, 0xe3, 0x14, 0x43,
        0x9b, 0xb4, 0x5f, 0xd3, 0x30, 0x01, 0xa8, 0xe5, 0xf8, 0xc5, 0x95, 0x78, 0x35, 0xc2, 0xa1, 0xe8, 0x82, 0xe4,
        0x5a, 0xb2, 0xcf, 0x35, 0x4e, 0x57, 0xe3, 0xa2, 0xfa, 0xee, 0xe1, 0xdc, 0xb1, 0xce, 0x7d, 0x5e, 0xe5, 0xec,
        0x3a, 0x2f, 0x03, 0xd7, 0x50, 0x44, 0x73, 0x48, 0x93, 0xa2, 0x0c, 0x3a, 0xdc, 0xea, 0x25, 0x97, 0x7d, 0xa5,
        0x23, 0xeb, 0x3d, 0x1a, 0x86, 0xe1, 0x2a, 0x83, 0x85, 0xb0, 0xc3, 0x69, 0xc1, 0xfc, 0x70, 0x3a, 0x06, 0xfb,
        0x41, 0xa2, 0xf7, 0xe5, 0x83, 0xbc, 0x2c, 0x99, 0xdd, 0xb1, 0x6c, 0x08, 0x53, 0x8a, 0xe5, 0x7a, 0x45, 0x32,
        0x01, 0xc7, 0x9b, 0x4b, 0xe2, 0x06, 0xef, 0xbb, 0x34, 0x07, 0xdb, 0x75, 0x74, 0x2b, 0xd1, 0x7a, 0xdd, 0x8c,
        0x6c, 0x94, 0x47, 0xe5, 0x1f, 0xa3, 0x82, 0x8e, 0xeb, 0xe3, 0xd9, 0xff, 0x34, 0xa6, 0x33, 0x63, 0x39, 0x5c,
        0xc1, 0xd1, 0x1d, 0x41, 0x19, 0xe0, 0x5d, 0xb1, 0x07, 0xfd, 0x8b, 0xbf, 0x08, 0xf6, 0x53, 0xb3, 0xa5, 0xc7,
        0x8e, 0xc2, 0x12, 0x81, 0x8c, 0x5a, 0x2e, 0xd9, 0x1d, 0x0e, 0xda, 0x08, 0x7c, 0xe2, 0x66, 0x1c, 0x56, 0x32,
        0xae, 0x44, 0x20, 0xcd, 0xc8, 0xcf, 0x99, 0x75, 0xb0, 0x42, 0x7b, 0x72, 0x4e, 0x1e, 0xdc, 0x0d, 0xae, 0xce,
        0x4d, 0x82, 0xec, 0x44, 0x7c, 0xee, 0x2b, 0x76, 0xbb, 0xf7, 0x07, 0x45, 0xfb, 0xc9, 0x41, 0x43, 0x22, 0xb9,
        0x9a, 0x89, 0xb9, 0x10, 0xf0, 0x43, 0xd2, 0x7f, 0xef, 0x93, 0x93, 0x32, 0x75, 0xf9, 0xa3, 0xf7, 0x89, 0x60,
        0x04, 0xb5, 0xf4, 0x5c, 0xe8, 0x1b, 0x67, 0xdc, 0x13, 0xfa, 0x09, 0x96, 0x1a, 0x4b, 0x97, 0xfa, 0xac, 0xe3,
        0xca, 0x81, 0x42, 0x50, 0xf8, 0x11, 0x7a, 0x68, 0x17, 0xd6, 0xbc, 0x63, 0x44, 0x2c, 0xf6, 0xac, 0x06, 0x57,
        0xf0, 0xff, 0x6b, 0x2a, 0xee, 0xff, 0x28, 0xb0, 0xa0, 0x5e, 0x5c, 0x96, 0x39, 0x28, 0xde, 0x48, 0x87, 0x87,
        0xd6, 0x10, 0x22, 0x5e, 0x0c, 0xa5, 0x26, 0xc8, 0x8b, 0xe5, 0xeb, 0xea, 0xbd, 0x66, 0x23, 0x92, 0x0e, 0xc6,
        0x50, 0x11, 0x53, 0xec, 0x05, 0x8c, 0x8d, 0x97, 0x2a, 0x67, 0x42, 0xf9, 0x53, 0x5f, 0x8b, 0xb6, 0x5f, 0xa7,
        0xac, 0x18, 0x1d, 0x8d, 0xbb, 0xe8, 0xe9, 0x2b, 0xd5, 0x83, 0xfe, 0x74, 0x00, 0x7e, 0x8f, 0x34, 0x69, 0xa5,
        0xeb, 0x82, 0x72, 0x2c, 0x03, 0x28, 0x59, 0x3a, 0x13, 0x04, 0xb0, 0xb6, 0x4d, 0x8c, 0xb3, 0x23, 0xad, 0x3e,
        0x6b, 0x24, 0x53, 0xb3, 0x06, 0xe3, 0xb8, 0xe0, 0x7a, 0xfd, 0x75, 0xbf, 0xea, 0xd3, 0xe8, 0x7c, 0xb7, 0x94,
        0x0c, 0xa2, 0x1b, 0x0c, 0xbf, 0xa8, 0x63, 0x68, 0x44, 0x11, 0xb3, 0x54, 0xd0, 0xa4, 0xf5, 0x58, 0x10, 0x42,
        0xeb, 0xe6, 0x17, 0x29, 0x75, 0xea, 0xb9, 0x55, 0x09, 0xac, 0xef, 0x63, 0xff, 0xb2, 0x2f, 0x2c, 0xed, 0x7b,
        0x4c, 0x9d, 0xda, 0x2b, 0xb9, 0xbf, 0x6b, 0xb1, 0xc4, 0x7b, 0xb8, 0x90, 0xb6, 0x1b, 0x43, 0x6a, 0xf7, 0x13,
        0x6d, 0xf3, 0x0f, 0x5e, 0xc0, 0xa2, 0xe7, 0xa3, 0xc5, 0xd9, 0x2e, 0x59, 0x93, 0x2a, 0xef, 0x3d, 0x71, 0x97,
        0x57, 0xbf, 0x5b, 0x78, 0xbc, 0x82, 0xf5, 0xd1, 0x8d, 0x5c, 0xde, 0x29, 0x50, 0x0a, 0x71, 0xb3, 0x2c, 0x24,
        0x7f, 0x1a, 0xf0, 0x43, 0xd7, 0x59, 0x2e, 0xcc, 0x49, 0x1f, 0xe4, 0xb9, 0x32, 0x10, 0x07, 0xc5, 0xec, 0x7a,
        0x0d, 0x1c, 0xfd, 0x24, 0xfc, 0xdf, 0x2d, 0xc7, 0xad, 0xeb, 0xae, 0xa3, 0xf3, 0x84, 0xec, 0x69, 0xb9, 0xd1,
        0xbf, 0x8d, 0x35, 0xb7, 0xc4, 0x1e, 0x8a, 0xff, 0xbd, 0x1d, 0x6b, 0x89, 0xab, 0x40, 0x85, 0x5b, 0xd3, 0x61,
        0x1e, 0x5f, 0x19, 0x3e, 0xd2, 0xfd, 0xcd, 0x5f, 0x92, 0xf6, 0x2c, 0x24, 0x61, 0x41, 0x3f, 0xc8, 0x87, 0xbb,
        0x0a, 0xa4, 0x0c, 0x99, 0xe7, 0xf3, 0x24, 0x6a, 0xe3, 0xf5, 0x9d, 0xb9, 0x8b, 0x2c, 0x75, 0x66, 0xe3, 0xdc,
        0x29, 0x06, 0xf3, 0x0a, 0x63, 0xdd, 0x26, 0x51, 0x1a, 0x35, 0x75, 0x6b, 0x86, 0xe3, 0x43, 0x80, 0x93, 0x6d,
        0xb3, 0x6c, 0x43, 0x2a, 0xdd, 0x1e, 0xd5, 0xcc, 0x1c, 0x35, 0xe1, 0xd3, 0x70, 0x08, 0x37, 0x42, 0x3c, 0x97,
        0x58, 0x59, 0xfe, 0xc7, 0x4e, 0xd3, 0x24, 0x69, 0x81, 0x36, 0x5f, 0xac, 0x4c, 0xec, 0xec, 0x7f, 0xa8, 0x09,
        0x20, 0xbf, 0xa2, 0xd6, 0x3b, 0xd0, 0x0d, 0x01, 0x29, 0x9c, 0xef, 0x23, 0x36, 0xb5, 0x8b, 0xa0, 0xff, 0x58,
        0xbe, 0x19, 0x83, 0xba, 0x48, 0x42, 0x32, 0xb4, 0x7f, 0x35, 0x3a, 0xc0, 0x5b, 0x62, 0x4f, 0x12, 0xbd, 0xcd,
        0xd6, 0x0a, 0x7c, 0xe9, 0xf2, 0x49, 0x44, 0xa5, 0x6e, 0xc2, 0x4d, 0x7e, 0x62, 0xc5, 0xf2, 0x62, 0xcc, 0x12,
        0xcf, 0x16, 0x64, 0x7e, 0xfe, 0x4e, 0xd9, 0x58, 0x4b, 0x98, 0x69, 0x85, 0xa8, 0x76, 0x4d, 0xbe, 0xab, 0x3b,
        0xf0, 0x02, 0xc2, 0x54, 0x2f, 0x57, 0xad, 0x77, 0x00, 0xe9, 0xbc, 0x02, 0x20, 0x94, 0x91, 0x80, 0x86, 0x29,
        0x46, 0xc4, 0x8d, 0xa1, 0xf1, 0x56, 0xa2, 0xd2, 0x89, 0x34, 0xfe, 0x12, 0x56, 0x57, 0xec, 0xe9, 0xce, 0xcc,
        0xb8, 0xa1, 0xf7, 0x23, 0x02, 0x7f, 0xed, 0x33, 0x80, 0xbd, 0x99, 0xc0, 0x80, 0x2d, 0xd2, 0xa6, 0xea, 0xf7,
        0xe9, 0x92, 0xac, 0xd4, 0x0d, 0x22, 0xb5, 0x36, 0x39, 0xc7, 0x7b, 0x2c
};

// Wake-word = picovoice
static const uint8_t PICOVOICE_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0xad, 0x20, 0xb5, 0x54, 0x47, 0xcb, 0xea, 0xb9, 0xb0, 0x13, 0xa2, 0x23, 0x13, 0xd2, 0xdc, 0xa8, 0x2e, 0x2a,
        0x9e, 0xc7, 0xf7, 0x28, 0x2f, 0x0e, 0xc3, 0xd8, 0xeb, 0xf7, 0x61, 0x83, 0x19, 0x7e, 0x0d, 0x56, 0x40, 0x1b,
        0xa8, 0x9d, 0x5c, 0x27, 0x81, 0x13, 0xb8, 0x14, 0x93, 0x8e, 0x6e, 0x11, 0x7f, 0xa1, 0x10, 0xeb, 0xa0, 0x8a,
        0xf8, 0xcf, 0xa3, 0xaa, 0x8f, 0x58, 0x60, 0x08, 0x98, 0x0b, 0x50, 0x4d, 0x52, 0xe6, 0x71, 0xa3, 0xe3, 0x8c,
        0x3c, 0x11, 0x9d, 0x7a, 0xc8, 0x94, 0xb4, 0xc3, 0x00, 0x9f, 0xa5, 0x3b, 0xe6, 0x25, 0x1e, 0x48, 0xd3, 0x77,
        0x73, 0xc3, 0x2e, 0x48, 0x9a, 0x20, 0xd9, 0xe1, 0x87, 0x51, 0xd3, 0xc0, 0x4f, 0xc8, 0x27, 0x1c, 0x1c, 0xc6,
        0x97, 0xaf, 0x1f, 0xd5, 0x34, 0x94, 0xc4, 0x6d, 0xc6, 0x53, 0x11, 0xaf, 0x93, 0x96, 0xdf, 0xac, 0x7e, 0xaf,
        0x0b, 0xe0, 0xa6, 0x90, 0x27, 0xe5, 0xd8, 0x3d, 0x09, 0x72, 0xcc, 0xe6, 0xb1, 0xe5, 0x3a, 0xb6, 0x7e, 0x5a,
        0x6b, 0x95, 0xd5, 0x26, 0x08, 0xda, 0x46, 0xce, 0x90, 0x14, 0x58, 0x57, 0xe6, 0x4f, 0xbb, 0x63, 0x70, 0x9b,
        0xac, 0xba, 0x91, 0xa0, 0xc1, 0x64, 0xbb, 0xd7, 0x81, 0x31, 0xb6, 0x95, 0xb7, 0x91, 0x46, 0x22, 0xd8, 0x18,
        0x97, 0xc8, 0x3e, 0x22, 0x63, 0x3d, 0xcc, 0x2d, 0x44, 0x38, 0x69, 0x25, 0x76, 0xbe, 0x2a, 0xec, 0x52, 0x8b,
        0x2a, 0x58, 0x90, 0xf8, 0x0d, 0x4e, 0x41, 0xf8, 0x8e, 0x34, 0x88, 0x3c, 0xe5, 0x7b, 0xe2, 0xd7, 0xf5, 0x61,
        0xaf, 0x8f, 0x91, 0x19, 0xfa, 0x01, 0x36, 0x78, 0x6e, 0xfe, 0x6d, 0x07, 0x0b, 0x71, 0x5b, 0x26, 0x82, 0x3c,
        0x24, 0x96, 0xfe, 0xa7, 0x4f, 0x13, 0x2b, 0x59, 0xec, 0x9d, 0xf2, 0x31, 0x20, 0xe1, 0x5f, 0x73, 0x37, 0xe8,
        0xe7, 0x33, 0x50, 0xc0, 0x60, 0x65, 0xbc, 0xc7, 0xbc, 0x81, 0x60, 0x5d, 0x58, 0xf5, 0x10, 0xb7, 0x50, 0xba,
        0x1e, 0xa2, 0x6e, 0x3f, 0x06, 0x46, 0xd0, 0x19, 0xd4, 0xe5, 0x81, 0x61, 0x45, 0xde, 0x38, 0x30, 0xcf, 0x51,
        0x55, 0x9c, 0x98, 0xeb, 0x83, 0x6c, 0xd7, 0x75, 0xbe, 0xe5, 0x59, 0xc6, 0xd3, 0xb3, 0x6b, 0xc3, 0x87, 0x96,
        0x3d, 0x8f, 0xad, 0xe0, 0x3f, 0x38, 0x09, 0x6f, 0x9d, 0x94, 0xa0, 0x75, 0x5e, 0x8a, 0x24, 0xf1, 0x21, 0x95,
        0xa7, 0xe3, 0x58, 0xe4, 0x19, 0xcc, 0x8e, 0xf8, 0x2a, 0x74, 0xf5, 0x92, 0x7e, 0xfa, 0xc9, 0xca, 0x59, 0x7b,
        0xbc, 0xd7, 0x41, 0xc1, 0x43, 0x67, 0x70, 0x4a, 0x6a, 0x76, 0x5e, 0xea, 0x56, 0x8b, 0x22, 0xec, 0xc6, 0x59,
        0x3e, 0x98, 0x67, 0x36, 0xc3, 0x38, 0x1f, 0xa9, 0xb2, 0x5a, 0xc7, 0x19, 0x69, 0x99, 0x80, 0x58, 0xda, 0x6d,
        0xc7, 0x9e, 0x56, 0x7d, 0xfa, 0x8b, 0xbe, 0x21, 0x66, 0x79, 0xde, 0x48, 0x36, 0x0e, 0xe9, 0x75, 0x48, 0x37,
        0x6c, 0x13, 0x17, 0x52, 0x45, 0xe5, 0x3e, 0x23, 0xa8, 0x7c, 0x6a, 0xcd, 0x8b, 0xba, 0xa5, 0x35, 0x7b, 0x83,
        0x87, 0xae, 0x1c, 0x6a, 0x97, 0xf7, 0x99, 0x57, 0xd0, 0xb2, 0xf1, 0x4e, 0xce, 0x47, 0x38, 0xd1, 0xd2, 0xc9,
        0xaf, 0xe0, 0x61, 0x3b, 0x46, 0xa9, 0xda, 0x83, 0xa0, 0xd3, 0xea, 0xa3, 0x5c, 0x96, 0xa2, 0x52, 0xd5, 0xc5,
        0xea, 0x81, 0x83, 0x0d, 0x84, 0x0b, 0x80, 0x1e, 0x37, 0xd0, 0xb7, 0x52, 0xfb, 0x74, 0xaf, 0x0d, 0x96, 0x91,
        0x3a, 0x4d, 0xfc, 0x77, 0xbd, 0xb5, 0x5b, 0x52, 0x22, 0x80, 0x53, 0x86, 0xf7, 0x2a, 0xdf, 0x58, 0xa0, 0x61,
        0x05, 0x2d, 0x01, 0xd4, 0xfd, 0xd7, 0xf8, 0xcd, 0x69, 0x67, 0x08, 0xd0, 0x6e, 0x01, 0x26, 0x2c, 0xac, 0x19,
        0x8b, 0x06, 0x3a, 0x98, 0x5a, 0x32, 0x8f, 0x5e, 0x4c, 0x95, 0x57, 0x5f, 0x32, 0x3c, 0x17, 0x6b, 0xa5, 0x4c,
        0x83, 0xce, 0x9d, 0x36, 0x1c, 0xcd, 0xb6, 0x83, 0x42, 0x01, 0xe1, 0x36, 0x51, 0xe9, 0x90, 0xfe, 0x1b, 0x19,
        0xc9, 0xd9, 0xc8, 0x98, 0xc0, 0x39, 0x77, 0x71, 0x62, 0x61, 0x03, 0x33, 0x72, 0x9d, 0xe0, 0xdb, 0x4d, 0xa1,
        0xa1, 0x5e, 0x61, 0xc3, 0xfb, 0xae, 0x7a, 0x6a, 0x72, 0x6c, 0xba, 0xb0, 0x21, 0xb2, 0xf8, 0x55, 0xf7, 0x8e,
        0xd0, 0x74, 0x6f, 0x71, 0x13, 0xfa, 0x31, 0x1c, 0x99, 0x59, 0x2f, 0xd9, 0x8b, 0x10, 0x6f, 0x73, 0x7b, 0x2a,
        0xff, 0xe7, 0x5d, 0xb9, 0xe1, 0xd9, 0x1b, 0xa7, 0x4f, 0x1d, 0xdb, 0xa3, 0x20, 0x8a, 0x46, 0x64, 0x58, 0x53,
        0xd8, 0x52, 0x58, 0xcf, 0x20, 0x9e, 0x31, 0x57, 0xb1, 0xfc, 0x6b, 0xf3, 0x7c, 0x98, 0x65, 0x9c, 0xc3, 0x67,
        0x72, 0x6c, 0x6e, 0x77, 0x99, 0x9f, 0x1b, 0xfd, 0x7c, 0x64, 0x14, 0xc4, 0x4d, 0xb8, 0xa1, 0xa6, 0xdd, 0x7f,
        0x2b, 0x4f, 0x07, 0x0d, 0xb6, 0x2c, 0x84, 0xe7, 0x60, 0x67, 0x52, 0xdc, 0xb6, 0xc6, 0x09, 0x50, 0x79, 0xea,
        0x77, 0x61, 0xf5, 0x47, 0x3a, 0xa7, 0x95, 0xae, 0x97, 0xbe, 0x8b, 0x0b, 0xe8, 0xb9, 0x5d, 0x74, 0x10, 0x7e,
        0xa5, 0xc2, 0x10, 0x49, 0x5e, 0x46, 0x05, 0x55, 0x02, 0x98, 0xc1, 0xef, 0x2d, 0xcf, 0xfe, 0xc4, 0x33, 0xf0,
        0xd7, 0x54, 0xaf, 0x7f, 0xaf, 0x35, 0x8c, 0xde, 0xb2, 0xad, 0x9e, 0x0e, 0xf8, 0x45, 0x1f, 0xbc, 0x5b, 0x9a,
        0xb1, 0x94, 0x7d, 0x70, 0x63, 0x28, 0x8a, 0xd6, 0xdd, 0xf0, 0x59, 0x15, 0xfd, 0xc4, 0x86, 0xfb, 0xe0, 0x17,
        0x75, 0x23, 0xf6, 0x82, 0x42, 0xca, 0x95, 0xe4, 0xb4, 0x54, 0xaa, 0xad, 0x56, 0xd3, 0xa1, 0x28, 0x9a, 0x0d,
        0x9e, 0xb0, 0x91, 0x85, 0xb3, 0x88, 0xab, 0x67, 0x34, 0xa8, 0xce, 0x56, 0xca, 0xdd, 0x6a, 0x61, 0x32, 0x1d,
        0x86, 0xe8, 0x3d, 0x91, 0x4f, 0x94, 0xef, 0x42, 0xd2, 0x45, 0x04, 0x59, 0xfa, 0x13, 0x4c, 0xda, 0x80, 0xe0,
        0xd1, 0x6e, 0x61, 0xa2, 0x9d, 0xae, 0xe3, 0x35, 0xe5, 0x48, 0x95, 0xbb, 0x6f, 0xe4, 0xef, 0x52, 0x79, 0x70,
        0x76, 0x06, 0x14, 0x7d, 0x16, 0x93, 0x19, 0xd2, 0xed, 0x41, 0x69, 0x1e, 0x5e, 0x5a, 0x35, 0x1a, 0x82, 0x1c,
        0x54, 0x0d, 0x9b, 0xee, 0x90, 0x79, 0x27, 0x85, 0xf1, 0x7c, 0x05, 0x17, 0x37, 0x65, 0xa0, 0x23, 0x6b, 0xe1,
        0x26, 0xe2, 0x52, 0x2d, 0x46, 0xc2, 0xb7, 0x91, 0xdf, 0x5d, 0x86, 0x30, 0x96, 0x95, 0x89, 0xc6, 0xd5, 0xe6,
        0xd7, 0xa3, 0x0e, 0xa5, 0xae, 0x5f, 0x21, 0x6a, 0x64, 0x6f, 0x3a, 0x59, 0x7d, 0xc2, 0x70, 0x3c, 0x6e, 0xed,
        0xb0, 0x38, 0x06, 0x8e, 0xb1, 0x4f, 0x6f, 0x5f, 0x5e, 0x08, 0x21, 0x1a, 0xfc, 0x6a, 0xc1, 0x12, 0xde, 0xca,
        0x88, 0x9c, 0x0e, 0xec, 0x0e, 0x76, 0xe1, 0x5e, 0x2b, 0x20, 0x62, 0x38, 0x6e, 0x49, 0x13, 0xbd, 0x40, 0xc3,
        0x0f, 0x54, 0x28, 0x1b, 0x23, 0x6e, 0x04, 0x66, 0x3a, 0xa9, 0x68, 0x4c, 0x9a, 0x3e, 0xc7, 0xdb, 0x03, 0x6c,
        0x98, 0xa2, 0x51, 0xc4
};

// Wake-word = bumblebee
static const uint8_t BUMBLEBEE_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x86, 0xf7, 0x33, 0xf1, 0x15, 0x8f, 0xde, 0x41, 0xa2, 0xa9, 0x93, 0x8f, 0x55, 0xb0, 0xc9, 0xad, 0x7d, 0x4e,
        0xd9, 0xf8, 0xb4, 0x91, 0xbe, 0x92, 0xd2, 0x1b, 0xea, 0xf1, 0xd0, 0xfb, 0xab, 0x95, 0x13, 0xcf, 0x62, 0x8a,
        0xcc, 0x49, 0xe1, 0xdd, 0x8a, 0x75, 0x5e, 0x71, 0xe0, 0x9d, 0x45, 0x4a, 0xea, 0xd6, 0x2a, 0xa2, 0x3f, 0x42,
        0xc4, 0x0e, 0x30, 0x39, 0xb7, 0x7c, 0xc0, 0xa1, 0x2e, 0xad, 0xf2, 0x41, 0x13, 0xd9, 0x53, 0x25, 0xdc, 0x81,
        0xfd, 0x0d, 0x67, 0x75, 0xa3, 0xaf, 0x8a, 0x7d, 0x6f, 0xfc, 0x84, 0x9b, 0x1e, 0x11, 0xe2, 0x36, 0xe6, 0x7c,
        0x80, 0x33, 0x16, 0x6f, 0xe4, 0xd2, 0x1e, 0xfe, 0x46, 0x9d, 0x97, 0xc5, 0x42, 0x2b, 0x0a, 0xa3, 0x83, 0x02,
        0xba, 0x35, 0xe5, 0x0d, 0x2c, 0x01, 0x52, 0x85, 0xe2, 0xf2, 0xab, 0xd6, 0x8d, 0xa6, 0xa0, 0xd3, 0x34, 0x9f,
        0x0f, 0x82, 0xcd, 0xfc, 0x12, 0xa8, 0xc0, 0x8e, 0x07, 0x31, 0xc4, 0x15, 0x70, 0x5d, 0xcb, 0x29, 0xf4, 0x22,
        0x65, 0x3b, 0x6b, 0x69, 0xc9, 0x75, 0x3e, 0x74, 0xed, 0x35, 0x77, 0x00, 0xbf, 0x31, 0x91, 0xb0, 0x7c, 0xf5,
        0xbd, 0x61, 0x8d, 0x9e, 0xe3, 0xa8, 0x44, 0x56, 0x76, 0x41, 0x06, 0x75, 0xa7, 0xd1, 0x1e, 0x30, 0xd3, 0x49,
        0x8c, 0xdb, 0xa5, 0x6c, 0x4c, 0xb0, 0xea, 0xfc, 0xe0, 0x83, 0x4e, 0xb0, 0xc3, 0x3f, 0xf6, 0x9d, 0xe1, 0x79,
        0xa5, 0x07, 0xb2, 0x8c, 0x6d, 0x3b, 0xe1, 0xbc, 0x63, 0x09, 0xc4, 0x31, 0xce, 0xa2, 0xde, 0xd7, 0xb4, 0xeb,
        0xd5, 0x2e, 0xdc, 0xb6, 0xda, 0xc3, 0x82, 0xaa, 0xb5, 0x6d, 0x77, 0x08, 0x3b, 0xe5, 0xd7, 0x59, 0x10, 0x10,
        0x4b, 0xd5, 0xf9, 0x53, 0x81, 0xd4, 0xdd, 0x39, 0xbf, 0x3b, 0x5b, 0x0d, 0xc1, 0x52, 0x04, 0xeb, 0xa7, 0xe1,
        0xf4, 0x17, 0x50, 0xbd, 0x03, 0xa7, 0x8c, 0x1c, 0x22, 0x9c, 0x19, 0x37, 0x39, 0x41, 0x9c, 0xa8, 0x89, 0x4a,
        0x55, 0x5d, 0x43, 0x66, 0xb7, 0x28, 0x02, 0x24, 0xcf, 0x29, 0x32, 0x73, 0xef, 0xa4, 0x6f, 0xb2, 0xc7, 0x41,
        0x92, 0x46, 0xd5, 0x27, 0x31, 0xa9, 0xef, 0xec, 0x33, 0x28, 0x9a, 0xdc, 0x1c, 0x86, 0xd4, 0x1b, 0x8d, 0x2b,
        0x7d, 0x84, 0xac, 0x33, 0x14, 0x4a, 0xee, 0x12, 0x6c, 0x72, 0xa0, 0xc5, 0x69, 0xab, 0xbe, 0xe5, 0x23, 0x75,
        0x18, 0xf8, 0x7f, 0x64, 0x55, 0x80, 0xe6, 0xd0, 0x3c, 0x5d, 0x15, 0x8d, 0xea, 0x81, 0x1f, 0xcc, 0x28, 0x82,
        0x26, 0x68, 0x6a, 0xcc, 0xd0, 0xac, 0xf4, 0xdc, 0xd2, 0xe6, 0xa8, 0xe1, 0x0b, 0xb9, 0x2a, 0x7e, 0x14, 0x7c,
        0x5a, 0x5f, 0xa0, 0x14, 0x14, 0xaa, 0x4b, 0x9f, 0x47, 0xd7, 0xcb, 0xc5, 0x7d, 0xea, 0x72, 0xdd, 0x05, 0x4c,
        0xa4, 0xa4, 0xa1, 0x87, 0xa7, 0x6c, 0x62, 0x99, 0x92, 0x70, 0xfc, 0x1e, 0x23, 0xf9, 0xb3, 0x06, 0xb3, 0xa5,
        0x78, 0x20, 0x3b, 0x12, 0xc0, 0x39, 0x22, 0xe6, 0x51, 0x03, 0x22, 0x8c, 0x85, 0x67, 0x26, 0xb3, 0x6b, 0x5a,
        0x99, 0x73, 0x36, 0xbf, 0x8a, 0x98, 0x05, 0x28, 0xa5, 0xaf, 0xed, 0x5a, 0x26, 0xcd, 0x3e, 0x78, 0x49, 0x8a,
        0x6e, 0xee, 0x42, 0x1e, 0xa9, 0xde, 0x72, 0xc1, 0xec, 0x32, 0xa0, 0x80, 0xad, 0xf8, 0x0c, 0xb1, 0x09, 0x05,
        0x45, 0x11, 0x89, 0xca, 0x5e, 0xf4, 0xca, 0xd9, 0x01, 0x24, 0x11, 0xea, 0x3b, 0xd9, 0xaf, 0x21, 0x18, 0x03,
        0xee, 0xdd, 0x19, 0xcd, 0xf9, 0x65, 0xe3, 0x57, 0x93, 0x46, 0x6e, 0x85, 0x0c, 0x7a, 0xc6, 0x44, 0x5e, 0x79,
        0x8e, 0xc9, 0x34, 0x00, 0xc8, 0x4b, 0x38, 0x80, 0x80, 0x9d, 0x83, 0x11, 0x24, 0x30, 0xb0, 0x6d, 0xb3, 0xa2,
        0x22, 0x48, 0xb4, 0x95, 0x2d, 0x1b, 0xca, 0x3f, 0x1a, 0x55, 0x93, 0x3c, 0x23, 0x38, 0x05, 0x94, 0xe6, 0x18,
        0x73, 0x96, 0x79, 0x3c, 0x8a, 0x84, 0x85, 0xba, 0x6c, 0x41, 0xc0, 0x8c, 0x76, 0x98, 0x92, 0xda, 0xa5, 0x99,
        0x90, 0xb7, 0xd9, 0xdb, 0x04, 0xc1, 0xc9, 0xab, 0x03, 0xdf, 0xc5, 0x36, 0xbe, 0xb3, 0xc6, 0x3d, 0x17, 0x87,
        0x22, 0x2d, 0x6f, 0x04, 0x4b, 0xbb, 0xd2, 0xf1, 0x71, 0x82, 0x0f, 0xfa, 0xaa, 0xe5, 0x82, 0xf0, 0x71, 0x61,
        0x01, 0x54, 0x81, 0x8d, 0x92, 0x84, 0x9b, 0xc2, 0xe8, 0x6f, 0x2d, 0x1a, 0x32, 0x69, 0x10, 0x92, 0x91, 0x3e,
        0x2f, 0xaa, 0x08, 0x49, 0x49, 0xcc, 0x06, 0x84, 0xcb, 0x74, 0x37, 0xf0, 0x7f, 0x7b, 0x81, 0x71, 0x4b, 0x15,
        0x72, 0xc3, 0xef, 0xd6, 0x66, 0x6c, 0x6d, 0x5c, 0x33, 0xe8, 0xe7, 0x93, 0x56, 0x0c, 0x43, 0x05, 0xbb, 0x1c,
        0xdb, 0x7c, 0xec, 0x14, 0xbd, 0xd7, 0xda, 0xef, 0x42, 0x6f, 0x52, 0xfd, 0x40, 0x21, 0xe3, 0x87, 0x1e, 0x57,
        0x70, 0xa3, 0xcb, 0x75, 0x8e, 0x39, 0x6a, 0x27, 0xa3, 0xf0, 0x9f, 0x58, 0x35, 0x45, 0x77, 0xa4, 0x8c, 0x92,
        0x9d, 0x41, 0x86, 0x83, 0xcf, 0x8e, 0xf5, 0x47, 0x9c, 0xd0, 0x98, 0x52, 0xc7, 0xfd, 0x99, 0xf2, 0x7f, 0xf9,
        0x04, 0xfa, 0x5b, 0x8a, 0xe7, 0x87, 0x72, 0xff, 0x53, 0x0e, 0x2e, 0x90, 0xd5, 0xec, 0x3f, 0x7d, 0x63, 0x07,
        0xaa, 0x0d, 0xbe, 0xc8, 0xe5, 0xb3, 0xfb, 0xf9, 0xfd, 0x29, 0x6e, 0x71, 0xeb, 0x2a, 0xb1, 0xc5, 0x6f, 0x78,
        0x67, 0x9e, 0xb6, 0x87, 0x72, 0xdc, 0x94, 0x8b, 0x8a, 0xc5, 0x46, 0x48, 0xf6, 0xb8, 0x69, 0x5b, 0x4c, 0x90,
        0x76, 0x71, 0x75, 0x40, 0xbf, 0x4b, 0x7c, 0x22, 0xde, 0xeb, 0x4c, 0x8f, 0x60, 0x52, 0xc7, 0x8b, 0x1e, 0x3e,
        0x2b, 0x35, 0x80, 0x04, 0x35, 0x0a, 0x54, 0xf6, 0x70, 0x0a, 0xdd, 0xd1, 0xf2, 0xb5, 0x91, 0xb7, 0xd7, 0x84,
        0x44, 0xa2, 0xb3, 0x11, 0xda, 0x56, 0xea, 0x7a, 0xd8, 0xde, 0x84, 0x25, 0x8c, 0x95, 0xda, 0x0a, 0xe3, 0x7f,
        0x30, 0x09, 0x58, 0x45, 0x36, 0x72, 0x20, 0xaf, 0xe4, 0x16, 0x44, 0x81, 0x6c, 0x73, 0x1c, 0x49, 0xbc, 0x25,
        0x13, 0x69, 0x6c, 0xaf, 0xc7, 0x03, 0x14, 0xbb, 0x2b, 0x65, 0x23, 0x3a, 0x6a, 0x71, 0x49, 0x07, 0x3b, 0x09,
        0x27, 0xde, 0x7b, 0xed, 0xf7, 0x30, 0xa6, 0x0a, 0x3a, 0x5a, 0x96, 0x92, 0x3d, 0xdc, 0xeb, 0x53, 0x3d, 0x7d,
        0xec, 0x58, 0x24, 0xba, 0xdd, 0xce, 0x6b, 0x78, 0x42, 0x8c, 0x44, 0x9f, 0x78, 0x9e, 0xed, 0x3c, 0x77, 0x2f,
        0x84, 0x06, 0x23, 0x56, 0x92, 0x95, 0x59, 0xca, 0x1c, 0xa9, 0x0a, 0x2e, 0x10, 0xa9, 0xa1, 0xe1, 0x13, 0xd4,
        0xc4, 0xfa, 0x32, 0x37, 0xd2, 0x96, 0x32, 0xdf, 0x6f, 0x12, 0xdb, 0x66, 0x53, 0xd1, 0x64, 0xbb, 0xd4, 0xcc,
        0xc9, 0x9b, 0x13, 0xa0, 0xf5, 0xf3, 0xd5, 0x3d, 0x7b, 0x23, 0x28, 0x8b, 0xf3, 0x0c, 0x9a, 0xe5, 0x7c, 0x97,
        0xe4, 0x9d, 0xdd, 0xf0, 0xa3, 0xa4, 0x53, 0x53, 0x20, 0xc3, 0x19, 0xde, 0x1d, 0xf0, 0xa4, 0xc8, 0x0f, 0x49,
        0xbe, 0x6d, 0xa2, 0x5b, 0x7f, 0x96, 0xb3, 0x55, 0x52, 0xe9, 0xa0, 0x4a, 0x80, 0x9d, 0xf0, 0x1f, 0x97, 0x94,
        0x80, 0x37, 0xf7, 0x01, 0xc3, 0xad, 0xc0, 0x55, 0x50, 0xbe, 0xaa, 0x2c, 0x5c, 0xc7, 0x20, 0x54, 0x2a, 0x51,
        0x90, 0xef, 0xaf, 0x99, 0xf9, 0x99, 0x58, 0x47, 0xf8, 0xbd, 0xcd, 0xb2, 0x80, 0x02, 0x44, 0x75, 0xa8, 0xb9,
        0x8c, 0x60, 0xf1, 0x75, 0x93, 0x24, 0x35, 0xc4, 0x19, 0x69, 0x20, 0xa6, 0x5d, 0xff, 0xac, 0xa3, 0x98, 0x06,
        0x49, 0x3f, 0x54, 0xb8, 0x51, 0x8e, 0x8a, 0xe9, 0x5e, 0x6d, 0x1d, 0x83
};

// Wake-word = alexa
static const uint8_t ALEXA_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x71, 0x9f, 0x0a, 0x1d, 0x2c, 0x10, 0x6c, 0xd8, 0xb7, 0xf4, 0x9a, 0x0f, 0xff, 0xd5, 0x46, 0x5e, 0x51, 0xda,
        0xf3, 0xee, 0x44, 0x70, 0x89, 0x54, 0x56, 0x1b, 0xf8, 0x72, 0x0b, 0xb6, 0x18, 0xed, 0xa4, 0x30, 0x39, 0x05,
        0xef, 0xad, 0x94, 0x0c, 0x72, 0x1a, 0x62, 0xd6, 0x4e, 0xf6, 0xb2, 0xc3, 0x1e, 0x40, 0x39, 0xcf, 0x29, 0x10,
        0xa7, 0x0b, 0x19, 0xb7, 0x8f, 0x29, 0x14, 0x47, 0xdb, 0xfb, 0x64, 0x61, 0x5e, 0x86, 0x26, 0x1b, 0xe6, 0x25,
        0x1b, 0xea, 0xc8, 0x95, 0xea, 0xc4, 0x6f, 0x28, 0xe9, 0x6f, 0xaa, 0x35, 0xa1, 0x3a, 0x8c, 0xe9, 0x7c, 0x0f,
        0xd0, 0x9b, 0x37, 0x5d, 0x41, 0x2d, 0x72, 0x1a, 0x91, 0x3c, 0x27, 0x96, 0x4c, 0x6d, 0x38, 0x0a, 0x75, 0x0f,
        0xe4, 0x39, 0xf3, 0x67, 0x71, 0x50, 0xfd, 0x0d, 0x8c, 0xe6, 0x02, 0x4d, 0x78, 0xc4, 0xbb, 0xd8, 0x35, 0xc8,
        0xb0, 0x65, 0x89, 0x3f, 0xeb, 0x4b, 0x17, 0xf7, 0xff, 0xb9, 0x0c, 0x0e, 0x25, 0x05, 0x94, 0x49, 0xe5, 0xbd,
        0x07, 0x56, 0xbb, 0x98, 0x27, 0xf4, 0x21, 0x3b, 0x33, 0x71, 0x44, 0xd0, 0x5b, 0x5a, 0x48, 0x4a, 0xf4, 0x73,
        0xa5, 0x9a, 0x04, 0x49, 0x1d, 0xdd, 0x67, 0xa9, 0x42, 0xab, 0x98, 0x0f, 0x9d, 0xa0, 0xaa, 0x2d, 0x6e, 0xf2,
        0x4e, 0x03, 0x8a, 0x3e, 0x7d, 0x03, 0x95, 0x7f, 0xdc, 0xe6, 0x9e, 0xc5, 0xd3, 0xb4, 0x65, 0xa1, 0x81, 0xf3,
        0x33, 0x0a, 0x35, 0x3b, 0xd6, 0x61, 0xad, 0x4d, 0x27, 0xa8, 0x62, 0x30, 0x93, 0x96, 0xc1, 0x13, 0x02, 0xab,
        0xdb, 0x90, 0x15, 0xd7, 0xb9, 0xbf, 0x14, 0x7a, 0x30, 0x88, 0xac, 0x15, 0x1e, 0xa2, 0x56, 0xbb, 0x56, 0x87,
        0x35, 0xdd, 0xa2, 0x71, 0x7f, 0x71, 0x85, 0x5f, 0xf7, 0x6e, 0x1d, 0x5e, 0x77, 0x2f, 0x18, 0x37, 0x74, 0x2d,
        0x95, 0x53, 0xd9, 0xb4, 0x32, 0x37, 0xb2, 0x42, 0x0b, 0x85, 0x15, 0x1a, 0x92, 0xb5, 0xb2, 0x21, 0xf5, 0x6d,
        0xe2, 0x2a, 0xd8, 0x7b, 0x2e, 0x84, 0xa9, 0x07, 0xc4, 0xaf, 0xe7, 0x81, 0x8b, 0x89, 0x0b, 0x03, 0xf1, 0xd9,
        0x7b, 0x9c, 0x86, 0xc6, 0x8e, 0xee, 0x76, 0x68, 0xad, 0xad, 0x8d, 0xe7, 0x35, 0x2d, 0xd6, 0x79, 0x6c, 0x38,
        0xa2, 0xf8, 0xa9, 0x5f, 0xba, 0xfc, 0x6d, 0x79, 0x7b, 0xf3, 0x9b, 0x68, 0xea, 0x61, 0x02, 0x79, 0xd3, 0x0d,
        0x9b, 0x7b, 0x49, 0x6f, 0xab, 0x3b, 0x90, 0x47, 0x1b, 0x58, 0x97, 0x56, 0x6a, 0xaf, 0xa2, 0x4f, 0xa7, 0x41,
        0xa5, 0xbc, 0x4a, 0x82, 0x86, 0xd3, 0x3c, 0x50, 0x7a, 0xb9, 0x4a, 0x6a, 0xb0, 0xe2, 0xa3, 0xc8, 0x7f, 0xb5,
        0x54, 0x98, 0xc1, 0x77, 0xc6, 0xe6, 0xe0, 0x97, 0x9f, 0x9b, 0x8c, 0xce, 0xdb, 0x28, 0x73, 0x2e, 0xdc, 0xa6,
        0xdc, 0x3f, 0x31, 0xfc, 0x5a, 0x4b, 0xe4, 0xa1, 0xae, 0x43, 0xc2, 0x2b, 0x84, 0xd9, 0x2a, 0x73, 0x31, 0xf6,
        0x5b, 0xcd, 0xeb, 0x00, 0x65, 0x49, 0x1a, 0x09, 0xfe, 0xa9, 0x11, 0x0c, 0xc6, 0xbb, 0x9e, 0xfa, 0xcd, 0x7a,
        0x96, 0x94, 0xba, 0xc7, 0xf7, 0x06, 0x11, 0x59, 0xf3, 0x54, 0xc2, 0x21, 0xc5, 0x57, 0x9c, 0xe6, 0xbd, 0xa7,
        0xcf, 0xf6, 0xea, 0xef, 0xbe, 0x70, 0x4b, 0x63, 0x47, 0x08, 0x18, 0x27, 0xff, 0x5e, 0xda, 0xf7, 0xe0, 0x64,
        0x37, 0xce, 0x71, 0x23, 0x62, 0x6e, 0x13, 0x5f, 0x08, 0x53, 0xe6, 0x8c, 0x79, 0x7f, 0xff, 0xef, 0x67, 0x98,
        0xca, 0x05, 0xb9, 0x0e, 0x1f, 0xb5, 0x57, 0x18, 0xb8, 0x2e, 0xfa, 0x27, 0xff, 0xcf, 0xd5, 0x2a, 0x0e, 0xfb,
        0x54, 0x37, 0xf3, 0x84, 0x1f, 0x8e, 0x8f, 0x79, 0x47, 0x7c, 0xa1, 0x20, 0x85, 0xa0, 0x6c, 0x86, 0xcd, 0x36,
        0x03, 0xbc, 0x10, 0x12, 0x62, 0xd2, 0x9d, 0x25, 0x9d, 0x62, 0xc9, 0x96, 0x59, 0xa5, 0x6e, 0x54, 0x7f, 0xbd,
        0xc1, 0xfb, 0x7a, 0x80, 0x49, 0xd2, 0x1e, 0x32, 0x06, 0x8d, 0x9d, 0x91, 0xbd, 0x2e, 0x81, 0xe8, 0x02, 0xd7,
        0x8a, 0x7e, 0xcd, 0xf9, 0x4b, 0x3c, 0x2e, 0xee, 0xdb, 0x2b, 0x85, 0xb0, 0xa1, 0xdc, 0x12, 0xe3, 0x91, 0xad,
        0xf0, 0xaa, 0x84, 0x4d, 0xfb, 0x35, 0xbf, 0x22, 0x51, 0xea, 0x36, 0x09, 0x17, 0x8b, 0xea, 0x26, 0x3f, 0xc0,
        0xf4, 0x4d, 0x72, 0x1a, 0xca, 0xab, 0x36, 0x63, 0x20, 0x66, 0xc4, 0xa1, 0xa1, 0x60, 0xd5, 0x28, 0x56, 0x3c,
        0xd7, 0x63, 0x34, 0x12, 0xfe, 0x0c, 0x24, 0x34, 0x97, 0x32, 0xb7, 0xde, 0x01, 0x64, 0x38, 0x02, 0x5e, 0xe1,
        0xe3, 0xee, 0x15, 0x13, 0xa4, 0x54, 0x5c, 0xac, 0x0e, 0x86, 0x3a, 0x3f, 0x98, 0xa8, 0xdf, 0x71, 0x14, 0x26,
        0x75, 0xd6, 0xd8, 0x89, 0xc9, 0x63, 0x9a, 0xf0, 0x88, 0xa0, 0x61, 0x62, 0x76, 0x07, 0x43, 0xc6, 0xd3, 0x2a,
        0xaf, 0xeb, 0xff, 0xf4, 0xa9, 0x72, 0x2c, 0x10, 0x75, 0xfa, 0xaa, 0x3d, 0x6c, 0xd4, 0x39, 0x48, 0x08, 0x77,
        0x9a, 0x9d, 0x53, 0x8e, 0x2a, 0xf5, 0x3d, 0xfd, 0x5b, 0x80, 0x15, 0x05, 0x30, 0xdc, 0x28, 0xd1, 0x7a, 0xfd,
        0x4f, 0x7e, 0x32, 0xbf, 0x56, 0x7c, 0xb2, 0x02, 0x92, 0x78, 0x04, 0x3a, 0x33, 0xdc, 0xe2, 0xd7, 0x12, 0x98,
        0xee, 0x26, 0x3e, 0xe9, 0x81, 0x91, 0x1d, 0x23, 0x9a, 0x95, 0xb2, 0x79, 0x36, 0xe1, 0x31, 0xc9, 0x40, 0x37,
        0x94, 0x5a, 0x58, 0x1a, 0x55, 0x72, 0x65, 0xa3, 0xf5, 0x7b, 0x5b, 0x64, 0x02, 0x2f, 0xa7, 0x4a, 0x72, 0xa4,
        0x44, 0xbc, 0x62, 0x39, 0x63, 0x2e, 0xfe, 0x21, 0xe1, 0x80, 0xe7, 0xf8, 0x10, 0xfa, 0xd1, 0x62, 0xc4, 0xfb,
        0x35, 0x72, 0xd8, 0x45, 0xa6, 0xb3, 0xea, 0x32, 0xb1, 0x83, 0x28, 0xb3, 0x1d, 0x23, 0x19, 0x6d, 0xff, 0x97,
        0xc6, 0x88, 0x23, 0x44, 0x5c, 0xf2, 0x3c, 0x20, 0xfe, 0x6b, 0x3d, 0xf3, 0xfd, 0x09, 0xcb, 0x9b, 0x2b, 0x06,
        0xdd, 0xfa, 0xed, 0xd4, 0xea, 0xf5, 0x1b, 0xaf, 0xc2, 0x73, 0x62, 0x9e, 0x4c, 0xfa, 0xc3, 0xd7, 0xf8, 0x19,
        0x7f, 0xb2, 0x50, 0xc3, 0x95, 0xae, 0x5f, 0xa1, 0x05, 0xe1, 0xd3, 0x58, 0xde, 0xf5, 0x03, 0x09, 0xf9, 0xdb,
        0x68, 0xa2, 0x28, 0x07, 0xec, 0x83, 0x1a, 0x13, 0x38, 0x20, 0xbf, 0xaf, 0xc9, 0xe2, 0x05, 0x06, 0x22, 0x1c,
        0x29, 0xcc, 0x7b, 0xb0, 0xb8, 0x34, 0x4e, 0xfb, 0x28, 0xc5, 0xd8, 0x90, 0xbe, 0x29, 0x87, 0x52, 0x94, 0xc6,
        0x9a, 0x11, 0x2d, 0xbe, 0x1b, 0x0c, 0xe8, 0x4c, 0xa6, 0x2d, 0x9c, 0xe7, 0x6e, 0x51, 0x82, 0x36, 0x70, 0x9d,
        0x2b, 0x4a, 0x23, 0x3e, 0x04, 0xb8, 0xb9, 0x22, 0xdc, 0xf1, 0x4d, 0xa9, 0x41, 0xc6, 0x58, 0x2c, 0x4b, 0xfa,
        0x77, 0x88, 0x3b, 0x43, 0x5b, 0x1d, 0x9e, 0xe9, 0x21, 0x4b, 0xa8, 0xb0, 0x01, 0x7c, 0x0c, 0x68, 0x6d, 0xec,
        0xca, 0x0a, 0x84, 0x06, 0xd3, 0x62, 0x47, 0x93, 0x1f, 0x1b, 0xf1, 0xd6, 0x3e, 0x46, 0x74, 0x4b, 0x70, 0x5e,
        0xfe, 0xa5, 0x82, 0x79, 0x0a, 0xa8, 0xaa, 0x63, 0x55, 0xd9, 0xde, 0x64, 0x9f, 0xd2, 0xad, 0x79, 0xa5, 0xa9,
        0x6b, 0xfb, 0xd5, 0xfd, 0x99, 0xd0, 0xd7, 0x07, 0x0b, 0x44, 0x26, 0x51, 0xf4, 0x8f, 0x57, 0x07, 0x5a, 0xd4,
        0x09, 0x77, 0x05, 0x09, 0x90, 0xda, 0x3a, 0xb4, 0x8f, 0x21, 0x7f, 0xf8, 0x98, 0xbe, 0x3a, 0xfd, 0x3c, 0x57,
        0x34, 0x26, 0x76, 0xdf, 0xad, 0x59, 0x94, 0xaa, 0xbe, 0xee, 0x56, 0x97, 0x79, 0x1d, 0x11, 0x28, 0xd2, 0x12,
        0xf2, 0xfe, 0xa7, 0xc2, 0x00, 0x25, 0x6d, 0x58, 0x07, 0xb3, 0x59, 0xfd, 0xcc, 0x4c, 0x10, 0xeb, 0xd2, 0x5c,
        0x7e, 0x5e, 0x18, 0x51, 0xf5, 0x8f, 0xd7, 0x78, 0xb6, 0x44, 0x89, 0x23, 0x14, 0x3b, 0x73, 0xab, 0x30, 0x15,
        0xba, 0xc6, 0x98, 0xd9, 0xbb, 0x2b, 0xb6, 0xb8, 0x07, 0x8f, 0xef, 0x61, 0x84, 0x8f, 0x7c, 0x52, 0x44, 0x26,
        0xa8, 0x19, 0xe9, 0xa4, 0x9a, 0x72, 0xb5, 0x4a, 0xff, 0x7e, 0x5b, 0x33, 0x39, 0x68, 0x7c, 0x87, 0x86, 0x11,
        0xc8, 0x5d, 0x5f, 0x55, 0x8e, 0x2f, 0x6b, 0x46, 0x8b, 0x0c, 0xdd, 0x7f, 0x99, 0x5e, 0xc2, 0x57, 0x2b, 0xf7,
        0x9f, 0x8d, 0x61, 0xfa, 0xc8, 0x07, 0x91, 0xfb, 0x16, 0x5f, 0xd9, 0xf8, 0x52, 0x41, 0xf1, 0x4d, 0x21, 0x63,
        0x9e, 0x12, 0xe7, 0xf4, 0x5e, 0xf8, 0xb0, 0x25, 0x9b, 0xe8, 0x3e, 0x67, 0x1a, 0xc9, 0x05, 0xa9, 0xcf, 0x30,
        0x2c, 0x7d, 0xe6, 0xf0, 0x7e, 0x89, 0xef, 0x2e, 0xf6, 0x80, 0x69, 0x7e, 0x1a, 0x13, 0x3c, 0xa5, 0xf4, 0x87,
        0xd6, 0xb8, 0x2f, 0x41, 0x37, 0x0b, 0x03, 0x6e, 0xc8, 0xdc, 0x23, 0x50, 0xc5, 0x1b, 0xbb, 0x81, 0xc2, 0x97,
        0x18, 0x17, 0xfd, 0xc4, 0x33, 0xc2, 0xca, 0xa0, 0x2e, 0x2c, 0xa0, 0x84, 0xc8, 0x76, 0x76, 0x7e, 0x3f, 0x79,
        0x65, 0x5c, 0x87, 0x8c, 0x13, 0xf2, 0x6a, 0x97, 0x1d, 0xc0, 0x21, 0xa7, 0x05, 0xa8, 0x38, 0xa3, 0xdd, 0xf4,
        0x28, 0xa7, 0xb1, 0xd3, 0x42, 0x6b, 0x03, 0x21, 0xa9, 0x3e, 0x4a, 0x7e, 0x2c, 0x99, 0x6e, 0x87, 0xae, 0x8b,
        0xad, 0x37, 0xb1, 0xb6, 0x62, 0x3d, 0x09, 0x81, 0xe4, 0xd3, 0xe8, 0x9f, 0x70, 0xb9, 0xad, 0x54, 0xe4, 0xc9,
        0x59, 0x7f, 0xa0, 0xf4, 0xe5, 0xfc, 0x14, 0x6d, 0xd6, 0xf0, 0xe7, 0x1b, 0xdb, 0xa1, 0x5a, 0x76, 0x55, 0x1c,
        0x9d, 0x89, 0x61, 0xb1, 0x73, 0x9f, 0x96, 0x15, 0x9d, 0x39, 0x1f, 0xc3, 0x79, 0x50, 0x59, 0x2d, 0xc3, 0x6a,
        0xa6, 0x8e, 0xa0, 0xba, 0x25, 0xf2, 0x5a, 0xc5, 0xa1, 0x1d, 0x22, 0x84, 0x31, 0x8f, 0x83, 0xaa, 0x9c, 0x36,
        0xa0, 0xba, 0xff, 0x88, 0x12, 0x39, 0x29, 0x10, 0x0a, 0xef, 0xd7, 0xaf, 0x1b, 0xc7, 0x95, 0x70, 0xa2, 0x55,
        0xa1, 0x7e, 0x48, 0x2a, 0xb8, 0x34, 0x90, 0xd6, 0x6a, 0x8f, 0xef, 0x26, 0x5a, 0x06, 0x87, 0xc5, 0x96, 0x0d,
        0xe9, 0xd9, 0x6f, 0xbc, 0x69, 0xf4, 0xf0, 0xae, 0x98, 0x9c, 0xb8, 0x4f, 0x1a, 0xe0, 0xa5, 0x05, 0xa2, 0x4a,
        0x8c, 0x7f, 0x17, 0x15, 0xf2, 0xba, 0x71, 0xef, 0x15, 0xab, 0xcd, 0x34, 0x4c, 0xa3, 0x8b, 0x55, 0x48, 0xcc,
        0xc2, 0x1a, 0x3e, 0x2a, 0x06, 0xe4, 0xb7, 0xc3, 0xe5, 0x4f, 0x3d, 0x6e, 0x80, 0x2b, 0xe3, 0xb3, 0x67, 0x72,
        0xea, 0xba, 0x71, 0x17, 0xbe, 0x69, 0x74, 0x88, 0xd3, 0xdb, 0x42, 0x97, 0x2e, 0x23
};

#endif

#if defined(__PV_LANGUAGE_GERMAN__)

// Wake-word = hey computer
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x6a, 0xf1, 0x38, 0x41, 0xe6, 0x51, 0xbb, 0x3d, 0xff, 0x93, 0x65, 0xd6, 0x11, 0x63, 0x7d, 0xbb, 0x65, 0x57,
        0x90, 0x17, 0xc2, 0xe0, 0x3a, 0x2e, 0xe9, 0xd8, 0x93, 0x46, 0xe4, 0x69, 0x1f, 0x17, 0x13, 0x78, 0xd4, 0xc8,
        0x36, 0x39, 0xf0, 0xbf, 0xa6, 0x2b, 0x96, 0xb7, 0xff, 0xd2, 0x67, 0x1b, 0xcc, 0x8b, 0xe8, 0xfb, 0xa0, 0x9d,
        0x50, 0xe7, 0xc9, 0xc3, 0x93, 0x44, 0xc5, 0xf5, 0xe8, 0xa7, 0x7c, 0x01, 0x74, 0x53, 0x60, 0x58, 0xb6, 0x9a,
        0xb2, 0xbc, 0x58, 0x7d, 0xfc, 0xe9, 0xd5, 0xf9, 0x6b, 0x4c, 0xea, 0x5f, 0x17, 0x5d, 0xb7, 0xe4, 0x26, 0xa6,
        0xdb, 0xc6, 0x43, 0xc2, 0x06, 0xfe, 0x44, 0xa3, 0x20, 0xa5, 0x40, 0x0d, 0x54, 0xc0, 0x5b, 0xa2, 0xd0, 0x47,
        0x6d, 0x65, 0x7a, 0xcc, 0xf1, 0xb7, 0x46, 0x0d, 0xb0, 0x62, 0xa3, 0xc4, 0xda, 0x6b, 0xeb, 0xd8, 0x40, 0x35,
        0xef, 0x71, 0xcd, 0x58, 0x22, 0xfc, 0xcf, 0x3b, 0x08, 0x92, 0xcc, 0x24, 0xb1, 0x1e, 0x4e, 0xe0, 0xd3, 0x87,
        0x00, 0xdb, 0xf3, 0xa7, 0x5d, 0x73, 0x6c, 0x0d, 0x9c, 0xfe, 0xf9, 0xa3, 0x70, 0x94, 0x84, 0xad, 0xb8, 0xa5,
        0x72, 0x2b, 0x36, 0x4e, 0x5f, 0xd2, 0xda, 0x9d, 0x85, 0x9e, 0xcc, 0xa9, 0x81, 0xed, 0x46, 0x1e, 0x1c, 0x33,
        0xf4, 0x67, 0xb6, 0xde, 0x5c, 0x55, 0xaf, 0x88, 0xf8, 0x18, 0x44, 0x7a, 0x0a, 0xc0, 0x75, 0xe3, 0xcc, 0x51,
        0x23, 0x0e, 0x9b, 0xde, 0x03, 0x4c, 0xae, 0xde, 0x2b, 0xb5, 0x71, 0xff, 0x23, 0x62, 0x17, 0xe0, 0x42, 0xbd,
        0x66, 0xae, 0x4f, 0xea, 0x1c, 0xb7, 0xe3, 0xa8, 0xbe, 0xbd, 0x60, 0x4f, 0x7c, 0xf3, 0x37, 0x0d, 0x2a, 0x2c,
        0x3e, 0x82, 0x87, 0x21, 0xce, 0x14, 0xf5, 0x6f, 0x8b, 0x90, 0xfc, 0x9d, 0xf5, 0x67, 0x4c, 0x16, 0xe4, 0x54,
        0xf9, 0x8c, 0x86, 0x65, 0xd4, 0x51, 0x26, 0x18, 0xaf, 0x78, 0xb7, 0x0a, 0xd6, 0xb4, 0xe8, 0x6e, 0x22, 0x48,
        0xa3, 0xb5, 0x7d, 0x09, 0x05, 0x95, 0xed, 0x1e, 0xea, 0x54, 0xbb, 0xf4, 0x13, 0x94, 0xe1, 0xcb, 0x6c, 0x8b,
        0xac, 0x2e, 0x26, 0xa8, 0x9d, 0xbf, 0xc1, 0x09, 0x9d, 0xb3, 0x0d, 0x55, 0x70, 0x23, 0x41, 0x6e, 0x2b, 0xa6,
        0x64, 0x1a, 0x5e, 0x6a, 0x71, 0xfc, 0x17, 0xc9, 0x80, 0x73, 0x13, 0x8a, 0x76, 0xfb, 0x23, 0x82, 0xfa, 0xc4,
        0x41, 0x5d, 0xd9, 0x11, 0xce, 0xbd, 0xdc, 0x64, 0x1d, 0x3e, 0x90, 0x8b, 0x2d, 0xd9, 0x7f, 0xd8, 0xa8, 0xd4,
        0x29, 0xce, 0x88, 0xeb, 0x07, 0xd5, 0xa6, 0x88, 0xd7, 0x35, 0x73, 0x4b, 0x95, 0x41, 0xb9, 0x6c, 0xe7, 0x91,
        0xee, 0x65, 0x57, 0xa6, 0xb4, 0xd3, 0x80, 0x47, 0xb3, 0x73, 0xa0, 0x7f, 0x13, 0x27, 0x62, 0x4c, 0x77, 0xb2,
        0xeb, 0x08, 0x42, 0xd5, 0x58, 0x6a, 0xdb, 0x79, 0x8e, 0xb3, 0x22, 0xfe, 0xb6, 0x2a, 0x5b, 0x87, 0x0c, 0x81,
        0x96, 0x57, 0x1b, 0xf8, 0xba, 0x1b, 0xf6, 0xea, 0xff, 0x79, 0x7a, 0x24, 0xff, 0x33, 0xa5, 0x81, 0xb7, 0x41,
        0x65, 0xdf, 0x7f, 0xb9, 0xd1, 0x99, 0x36, 0x82, 0x93, 0x5c, 0x56, 0xaf, 0x6f, 0x71, 0x2c, 0x20, 0xf2, 0xf5,
        0x86, 0xa2, 0x48, 0xcf, 0xf0, 0x7f, 0xd4, 0x0a, 0x1d, 0xd3, 0x21, 0xa1, 0x93, 0x94, 0xab, 0x1f, 0x94, 0xfc,
        0x0f, 0x25, 0x8a, 0x28, 0x7d, 0xd4, 0xc4, 0x20, 0x6f, 0xff, 0xcf, 0xee, 0x1a, 0x96, 0xda, 0xbf, 0x00, 0x5f,
        0x1d, 0x07, 0xda, 0xee, 0xdb, 0x40, 0x9a, 0x24, 0x48, 0x01, 0xcf, 0x7c, 0x62, 0x6f, 0x3a, 0x9e, 0x64, 0x96,
        0x29, 0x59, 0xd0, 0xff, 0xed, 0xca, 0x3e, 0xb3, 0xa2, 0x37, 0x0c, 0x1f, 0x41, 0xc7, 0x86, 0xd8, 0xe2, 0xb2,
        0xd2, 0x30, 0x52, 0xeb, 0xe2, 0xc5, 0x4d, 0x9c, 0xe0, 0x0c, 0x89, 0x4f, 0x59, 0xae, 0x2a, 0x83, 0x88, 0x5d,
        0xaf, 0x3e, 0xdf, 0xe6, 0xe4, 0x72, 0x59, 0x42, 0x8e, 0xef, 0x0a, 0x28, 0x3d, 0x8e
};

#endif

#if defined(__PV_LANGUAGE_SPANISH__)

// Wake-word = hola computadora
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x3c, 0x56, 0xe5, 0xcd, 0xf3, 0x09, 0x14, 0x5c, 0x02, 0x06, 0xdd, 0x75, 0xbc, 0x76, 0xfa, 0xc1, 0x8d, 0xf8,
        0xe9, 0x3f, 0xe8, 0x7a, 0xc4, 0x3e, 0x82, 0x69, 0xbd, 0x7e, 0xb7, 0xb1, 0xaa, 0x02, 0x34, 0xfb, 0x06, 0x00,
        0x0a, 0x06, 0x78, 0x96, 0x04, 0x9a, 0x8b, 0x9e, 0xe4, 0x6c, 0x75, 0xd3, 0x3a, 0x59, 0xba, 0xa1, 0x09, 0xee,
        0xe9, 0xf4, 0xaf, 0xdf, 0x6f, 0xbb, 0x2d, 0x6c, 0x32, 0x39, 0x0e, 0xa5, 0x5c, 0x61, 0xd8, 0xc1, 0xa0, 0xc5,
        0x47, 0xc5, 0xcd, 0xbf, 0x35, 0xcb, 0xa0, 0x42, 0x0a, 0xc7, 0x89, 0x3c, 0x0f, 0xe5, 0x22, 0xbe, 0x2f, 0xb5,
        0x93, 0x23, 0xe0, 0x7b, 0xb9, 0x59, 0xaa, 0x4b, 0xd5, 0x73, 0x77, 0xcf, 0x9b, 0x38, 0xf3, 0xc8, 0x0e, 0x35,
        0xf9, 0x75, 0xf3, 0x3a, 0x23, 0x57, 0xc3, 0xc3, 0x0b, 0xe0, 0x0d, 0x06, 0xbf, 0x8a, 0x40, 0x3a, 0x1e, 0xef,
        0x10, 0x68, 0xcf, 0x9b, 0xf7, 0xcf, 0xc0, 0x2b, 0x42, 0x1e, 0xde, 0x22, 0xbc, 0xd2, 0xd0, 0xb0, 0xaf, 0x66,
        0xc0, 0x9f, 0x1b, 0x08, 0x58, 0x0a, 0xe0, 0xbb, 0x7d, 0xa1, 0x98, 0x35, 0x69, 0x03, 0x77, 0x7b, 0x7e, 0xa2,
        0xe6, 0x59, 0x82, 0x79, 0xcb, 0xf1, 0xb3, 0xd9, 0x75, 0xa6, 0x61, 0x04, 0x88, 0x30, 0xec, 0x52, 0xc2, 0xa9,
        0x0d, 0xc7, 0x9e, 0xf2, 0x35, 0x83, 0x33, 0x33, 0x92, 0x24, 0xaf, 0x6a, 0xd2, 0x24, 0xf7, 0x2c, 0xb8, 0x06,
        0xce, 0xbe, 0x56, 0x81, 0x93, 0x43, 0xce, 0xfe, 0x6f, 0x44, 0x17, 0x5d, 0xf1, 0x92, 0x95, 0x4f, 0x96, 0xc9,
        0x5a, 0xee, 0xfb, 0x1d, 0x15, 0x2e, 0x63, 0x5f, 0x31, 0x6b, 0x09, 0x4f, 0x8c, 0x46, 0xcd, 0x4d, 0x37, 0xd0,
        0x9e, 0xe2, 0x7c, 0x8d, 0x78, 0x9e, 0x98, 0xee, 0x01, 0xc7, 0x5a, 0x5b, 0xbe, 0x79, 0x16, 0xfa, 0xa6, 0x1c,
        0x84, 0x01, 0xd0, 0x68, 0xeb, 0x95, 0x2d, 0x75, 0x98, 0xdf, 0x80, 0xc1, 0x11, 0x89, 0xf3, 0x20, 0x07, 0x11,
        0x0a, 0xc3, 0xc9, 0x42, 0x92, 0x85, 0x54, 0x65, 0x96, 0x7f, 0x86, 0xf4, 0x90, 0xfc, 0x48, 0x7d, 0x22, 0x91,
        0x25, 0xeb, 0xe8, 0x2f, 0x71, 0x2d, 0x9d, 0x3d, 0x44, 0x2d, 0x45, 0x63, 0xaa, 0x9a, 0xcb, 0x4c, 0x63, 0x0f,
        0x99, 0xf1, 0x7f, 0xb2, 0xf9, 0x20, 0xa9, 0x31, 0x1a, 0xfe, 0x9e, 0xec, 0xcf, 0x6f, 0xc8, 0xee, 0x55, 0xd3,
        0x83, 0x82, 0x67, 0xb0, 0xce, 0x29, 0x36, 0x6b, 0x84, 0x00, 0xf5, 0xbb, 0xc0, 0xdc, 0x5a, 0xef, 0xdd, 0xb6,
        0xb0, 0x06, 0x2d, 0x24, 0x46, 0xe2, 0x49, 0xb3, 0xc5, 0x7e, 0x82, 0xe0, 0x3f, 0x4e, 0x9d, 0xdd, 0x26, 0xaa,
        0x4f, 0x3e, 0xab, 0x1f, 0xfd, 0x79, 0x93, 0xbc, 0xd7, 0xd5, 0x4a, 0x29, 0x9a, 0x11, 0x7b, 0xe1, 0x9b, 0xbb,
        0xa1, 0xd6, 0x47, 0x18, 0xa4, 0x0c, 0x5f, 0x84, 0xf7, 0xac, 0x49, 0xad, 0xf1, 0x64, 0x96, 0x6f, 0x0b, 0xbd,
        0xce, 0x96, 0x1b, 0xa6, 0xed, 0xe6, 0x5d, 0xed, 0x10, 0x2c, 0xd2, 0x76, 0xb0, 0xe9, 0x4a, 0x18, 0xdf, 0x26,
        0xe1, 0x0b, 0xb3, 0x80, 0xb2, 0x5b, 0xe0, 0xf9, 0x35, 0x62, 0x34, 0x0a, 0xa1, 0xe7, 0xce, 0x75, 0x96, 0x88,
        0x82, 0xa9, 0xbb, 0x5d, 0xa3, 0xa4, 0xaf, 0x17, 0xd4, 0x5a, 0xe6, 0xd4, 0x45, 0xb7, 0xfa, 0x6f, 0x92, 0x87,
        0x26, 0xf2, 0x11, 0xd9, 0x76, 0xcf, 0x89, 0x10, 0xb1, 0x2c, 0xc4, 0x1d, 0x64, 0xb1, 0x3d, 0x98, 0x55, 0x71,
        0x93, 0x42, 0x4f, 0x97, 0x6b, 0xe7, 0xd1, 0x6e, 0xc6, 0x7e, 0x8d, 0xed, 0x7a, 0xfa, 0x17, 0x15, 0x73, 0xa7,
        0x12, 0x63, 0x72, 0x31, 0xa1, 0x5e, 0xed, 0xb0, 0x57, 0x98, 0xa3, 0x78, 0x68, 0xde, 0xea, 0x63, 0x0b, 0xb1,
        0xbc, 0x27, 0xeb, 0x1a, 0xd6, 0xb6, 0xdf, 0xb7, 0xfe, 0x4a, 0x34, 0x1f, 0x63, 0x18, 0x60, 0x13, 0xfd, 0x94,
        0x9b, 0x3e, 0x00, 0xe0, 0xa5, 0x4f, 0x21, 0x20, 0x4b, 0x73, 0xea, 0x3b, 0xf3, 0x5c, 0x30, 0xa5, 0x3e, 0x7a,
        0xe3, 0x4f, 0xf4, 0x8c, 0x47, 0xa0, 0x89, 0xc8, 0x31, 0x89, 0x64, 0x30, 0x75, 0x54, 0x98, 0xbf, 0xfd, 0x7a,
        0xc3, 0x43, 0x53, 0xab, 0x9b, 0x49, 0xbf, 0x5e, 0x4c, 0xcc, 0x5d, 0x9a, 0x55, 0xef, 0x00, 0x02, 0x4d, 0xce,
        0xd9, 0x4d, 0x09, 0xd0, 0x5d, 0xdd, 0x00, 0x1f, 0x8d, 0x53, 0x54, 0x84, 0x20, 0xdd, 0x92, 0x29, 0xc1, 0x7d,
        0x1e, 0x61, 0x6d, 0x8a, 0xe8, 0x7d, 0x9b, 0xe6, 0x1c, 0x9c, 0x44, 0xac, 0xbe, 0x3e, 0xe0, 0xd2, 0x21, 0x00,
        0x6b, 0x95, 0xec, 0xab, 0x67, 0x1f, 0x2e, 0xe6, 0x3c, 0xc9, 0xbf, 0x0d, 0x80, 0x29, 0x79, 0xa1, 0xa5, 0x35,
        0xfb, 0x32, 0xe4, 0xc6, 0x84, 0x3b
};

#endif

#if defined(__PV_LANGUAGE_FRENCH__)

// Wake-word = salut ordinateur
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0xa9, 0x4c, 0xcf, 0xd0, 0x8c, 0xab, 0x0e, 0xcc, 0x8e, 0x9e, 0xb6, 0x51, 0xa0, 0x4a, 0xae, 0x72, 0x5f, 0x3d,
        0xb5, 0xe7, 0x88, 0x6a, 0x61, 0x6e, 0x62, 0x4b, 0x54, 0xcb, 0x1d, 0x34, 0xd7, 0xf2, 0x06, 0xd0, 0x2b, 0xf2,
        0x99, 0xe0, 0xa2, 0xa2, 0x1c, 0xe7, 0x38, 0xdb, 0xf3, 0xbc, 0xb8, 0x26, 0xff, 0xd1, 0x00, 0x2d, 0xb4, 0x4d,
        0x0e, 0xf3, 0x75, 0x8c, 0x4d, 0x3a, 0x7c, 0xff, 0x6d, 0x49, 0x50, 0x3b, 0xcf, 0x64, 0x1b, 0x1e, 0x69, 0x9e,
        0xb3, 0xc5, 0x98, 0x18, 0x1b, 0x0c, 0x7e, 0xab, 0xbb, 0x89, 0xb9, 0x40, 0x5b, 0xbd, 0xb7, 0x06, 0xd9, 0x13,
        0x23, 0xd9, 0xdd, 0x09, 0xc1, 0xd7, 0x09, 0x25, 0xaf, 0x6d, 0xca, 0xe6, 0x15, 0x69, 0x05, 0x5e, 0x15, 0x04,
        0xba, 0xd6, 0x54, 0x65, 0xfb, 0xd9, 0x00, 0x4e, 0xd7, 0xc8, 0xd6, 0xd8, 0xcb, 0xff, 0xbc, 0x4f, 0x39, 0x5e,
        0x6f, 0x0c, 0x35, 0x1a, 0x2e, 0xa6, 0x35, 0x5b, 0x1e, 0xdb, 0xd9, 0x57, 0xfb, 0x95, 0xc9, 0x4b, 0xab, 0x7d,
        0x66, 0x36, 0x66, 0x2e, 0x78, 0x09, 0x4c, 0x60, 0x1e, 0x02, 0xd6, 0x06, 0x47, 0x9d, 0xb2, 0xfb, 0x6b, 0x9b,
        0x41, 0x5e, 0x0e, 0xa2, 0xf8, 0x66, 0x77, 0x0b, 0xde, 0x31, 0x91, 0x8f, 0x6f, 0xd5, 0x17, 0x3a, 0x43, 0xd9,
        0xe3, 0x52, 0xfe, 0xd8, 0xd0, 0xe5, 0x15, 0xd5, 0x2f, 0x54, 0x60, 0x91, 0x19, 0xae, 0xbf, 0xbf, 0x87, 0xb8,
        0x01, 0x9b, 0xd8, 0xd7, 0x50, 0xab, 0xa1, 0x29, 0xa9, 0x7a, 0x98, 0x29, 0xea, 0x7c, 0x65, 0xfe, 0x5f, 0xd5,
        0x94, 0x22, 0xc4, 0x05, 0x60, 0xbd, 0xe4, 0x78, 0xf5, 0xfe, 0x5e, 0x3c, 0x3a, 0xa5, 0x40, 0x16, 0xe9, 0xf4,
        0x0c, 0x7f, 0xda, 0xe3, 0x28, 0x1b, 0xa7, 0x1d, 0x2c, 0x0f, 0x7f, 0x06, 0xe0, 0x7e, 0x73, 0x38, 0x72, 0xc6,
        0x41, 0x0d, 0x2d, 0x55, 0x0b, 0x20, 0xa3, 0x77, 0x40, 0xb2, 0xab, 0x8b, 0x50, 0x41, 0x0c, 0x88, 0xa1, 0x55,
        0x36, 0x7e, 0x81, 0x33, 0x76, 0x42, 0x04, 0x37, 0xa3, 0xd5, 0x31, 0x36, 0x7a, 0xe3, 0xca, 0x22, 0xbb, 0x49,
        0x10, 0x31, 0x49, 0x80, 0xf9, 0x42, 0x7c, 0x4e, 0x5d, 0xf2, 0x52, 0xeb, 0xaa, 0x66, 0xa4, 0xc8, 0x15, 0x61,
        0xc0, 0xe7, 0x88, 0xba, 0x04, 0x08, 0x6e, 0xbe, 0x85, 0x85, 0x2a, 0x19, 0xcc, 0x0d, 0x07, 0x88, 0xc2, 0x66,
        0x1e, 0x1d, 0x6b, 0x24, 0x8f, 0xcc, 0xdd, 0xc4, 0xb1, 0x39, 0xec, 0x28, 0x61, 0xf6, 0x10, 0x52, 0x5b, 0x29,
        0x94, 0x45, 0xb1, 0x29, 0x53, 0x66, 0x4c, 0xe9, 0xea, 0x17, 0x9b, 0x54, 0xb2, 0xdc, 0xc7, 0x61, 0xf4, 0x77,
        0xb6, 0xac, 0x47, 0x24, 0x47, 0x83, 0xc1, 0x0e, 0x0d, 0x62, 0x8f, 0x24, 0x36, 0x0a, 0x77, 0x1e, 0xbb, 0x9e,
        0xf3, 0xbd, 0xb3, 0xf8, 0x4b, 0x8a, 0xe7, 0x99, 0x5f, 0x35, 0x15, 0xaf, 0x93, 0x1a, 0x4c, 0x6f, 0xec, 0x20,
        0xa2, 0x77, 0x0f, 0xb4, 0x4d, 0x01, 0xfd, 0xb6, 0x79, 0x01, 0x2b, 0x4a, 0x8c, 0xa3, 0x6a, 0x43, 0x21, 0xb3,
        0x75, 0xb1, 0x5d, 0xda, 0xb4, 0x31, 0x9b, 0x9c, 0xf5, 0x5c, 0xb8, 0xde, 0x84, 0xfd, 0x2d, 0x5d, 0xca, 0x07,
        0x0a, 0x19, 0x69, 0x92, 0x11, 0x1f, 0xe5, 0x7d, 0x7b, 0x29, 0x0d, 0x61, 0x1a, 0x36, 0x6c, 0xe7, 0x68, 0x2f,
        0x22, 0x51, 0x38, 0xb6, 0xb6, 0xa8, 0x10, 0x9e, 0x14, 0x41, 0xb5, 0x51, 0x90, 0x86, 0x11, 0xbb, 0x96, 0xbc,
        0x7c, 0xdb, 0x9c, 0x44, 0xfa, 0xcb, 0x48, 0x4d, 0x14, 0x5e, 0xeb, 0x77, 0x78, 0x5e, 0x9e, 0xdd, 0xc2, 0x8f,
        0x2e, 0xd6, 0xa7, 0x2e, 0x62, 0x17, 0x5e, 0x12, 0xd9, 0x54, 0x9d, 0x3c, 0x2a, 0xdd, 0xbe, 0xec, 0x0b, 0xe4,
        0x52, 0x49, 0xfe, 0xca, 0x40, 0xf0, 0x09, 0x45, 0x6c, 0xd7, 0x27, 0x26, 0xa3, 0x37, 0xeb, 0x74, 0xad, 0x37,
        0xd0, 0xab, 0x42, 0xf8, 0x80, 0xb2, 0x5b, 0x02, 0x1b, 0x77, 0xe9, 0xd0, 0xdf, 0xc6, 0xc8, 0xfc, 0x0d, 0x8a,
        0xeb, 0x99, 0x51, 0xb9, 0x40, 0x8e, 0x00, 0x4e, 0xeb, 0x69, 0x6d, 0xd1, 0x84, 0x43, 0x91, 0xf9, 0x83, 0x54,
        0xc6, 0xda, 0x76, 0x83, 0x40, 0xe5, 0x52, 0xcb, 0x95, 0xd3, 0xc0, 0x8b, 0xfa, 0xf7, 0x05, 0xae, 0xd5, 0x2d,
        0x1d, 0xc0, 0x27, 0x76, 0x29, 0x44, 0xe7, 0x09, 0x0b, 0x4b, 0x20, 0x99, 0x47, 0x3e, 0x22, 0x7d, 0x2e, 0xf1,
        0xc1, 0x54, 0x00, 0x82, 0x72, 0xfe, 0x42, 0x31, 0x60, 0xb3, 0x7d, 0x74, 0x64, 0xac, 0xa4, 0x78, 0x71, 0x7b,
        0x1c, 0x78, 0x43, 0x9c
};

#endif


#endif // PV_PARAMS
