
/*
    Copyright 2020-2022 Picovoice Inc.

    You may not use this file except in compliance with the license. A copy of the license is located in the "LICENSE"
    file accompanying this source.

    Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
    specific language governing permissions and limitations under the License.
*/

#ifndef PV_PARAMS_H
#define PV_PARAMS_H

#include <stdint.h>

#if defined(__PV_LANGUAGE_ENGLISH__)

// Wake-word = porcupine
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0xda, 0x9b, 0x4a, 0x7e, 0x93, 0xcc, 0x9b, 0x3f, 0xa1, 0x26, 0xbe, 0xb0, 0x62, 0xe8, 0x27, 0x94, 0x6b, 0x12,
        0x90, 0x34, 0x40, 0x23, 0x5a, 0x5a, 0x6a, 0xca, 0xbe, 0x2e, 0x25, 0x0e, 0x71, 0xe1, 0xa7, 0xa1, 0xda, 0x74,
        0xa6, 0x62, 0x01, 0x7e, 0xcc, 0x5f, 0x55, 0x2d, 0x05, 0xda, 0xe9, 0x89, 0xdf, 0xb2, 0x65, 0x13, 0x56, 0xb9,
        0xe1, 0xd1, 0x26, 0x6f, 0x62, 0xfb, 0x50, 0x63, 0xbb, 0xb1, 0x7c, 0xf8, 0xc0, 0x84, 0xed, 0x35, 0xfe, 0xc5,
        0xd1, 0x08, 0x20, 0x44, 0xd2, 0x7c, 0x18, 0xc0, 0x8c, 0x48, 0xfd, 0x6c, 0x46, 0x23, 0xdb, 0x6d, 0xb9, 0xde,
        0x88, 0x43, 0xec, 0x78, 0xb6, 0x55, 0x30, 0xa4, 0x4d, 0xb1, 0xaf, 0x42, 0x3c, 0xce, 0xb6, 0xd0, 0x82, 0x0f,
        0xd4, 0xfa, 0x38, 0x83, 0x92, 0xe3, 0x89, 0x4b, 0xd3, 0xe8, 0xf9, 0xd2, 0xef, 0x2f, 0xd1, 0x7c, 0x00, 0x6c,
        0xa9, 0x64, 0xeb, 0x9c, 0xde, 0xbb, 0x27, 0x96, 0x21, 0xa3, 0xdb, 0x38, 0x06, 0xe6, 0xbe, 0x9d, 0xf5, 0x1c,
        0x61, 0xc9, 0x0c, 0x76, 0x06, 0x16, 0x49, 0xac, 0x8d, 0x9f, 0xea, 0x1d, 0x04, 0x50, 0xa7, 0x0a, 0x17, 0xc2,
        0xf0, 0xb6, 0x37, 0x5f, 0x0f, 0xd9, 0x76, 0x31, 0x7f, 0x43, 0x23, 0x91, 0x74, 0xbc, 0x0c, 0xe3, 0x26, 0x93,
        0x39, 0x28, 0x87, 0xcc, 0x85, 0x38, 0xec, 0x92, 0x07, 0x98, 0x68, 0x88, 0x0c, 0x4a, 0x63, 0x37, 0x2b, 0x21,
        0xe9, 0x65, 0x69, 0x1c, 0x66, 0xd5, 0x8c, 0xa7, 0xd5, 0xa8, 0x6e, 0x1c, 0xa2, 0xdf, 0x78, 0xac, 0xf6, 0xd2,
        0xe7, 0xbb, 0x9e, 0xd5, 0x21, 0x6f, 0x8c, 0xdc, 0xc7, 0x71, 0x01, 0xc6, 0x71, 0xc5, 0x14, 0xc3, 0x4a, 0xca,
        0x53, 0xd4, 0xaa, 0xc2, 0x52, 0xd5, 0x3e, 0xbd, 0x6e, 0x91, 0x66, 0xb9, 0x68, 0x5f, 0x3c, 0xce, 0x75, 0xc4,
        0x74, 0x3a, 0x11, 0x6b, 0xa7, 0x6c, 0xea, 0x1a, 0x01, 0xe6, 0x89, 0xfe, 0xdb, 0x99, 0xd7, 0x78, 0x7f, 0x3b,
        0x0e, 0xc5, 0x50, 0x9e, 0xc4, 0x4a, 0x9e, 0xa7, 0x4b, 0x30, 0x77, 0x3b, 0x9e, 0xff, 0x13, 0x61, 0x4f, 0xa6,
        0x4b, 0x55, 0x5a, 0xdf, 0x3e, 0x95, 0x1a, 0x19, 0x21, 0xe1, 0x11, 0xb2, 0xc4, 0xba, 0x52, 0x8c, 0x05, 0xaf,
        0xd0, 0x84, 0xd4, 0xde, 0x1e, 0xe2, 0x01, 0x6f, 0x7c, 0xaf, 0xe2, 0xac, 0x49, 0xd2, 0x5b, 0x45, 0xea, 0x3d,
        0x58, 0xde, 0x3f, 0x07, 0xaf, 0x3e, 0x41, 0x0f, 0x6a, 0xce, 0x68, 0x96, 0xe5, 0x08, 0x78, 0xb3, 0x3a, 0x92,
        0xb2, 0x30, 0x02, 0x7d, 0xa8, 0x73, 0x82, 0x8a, 0xb0, 0x11, 0x61, 0x5b, 0xc1, 0xab, 0xec, 0x2d, 0x25, 0x9a,
        0xae, 0x1a, 0xc6, 0x85, 0xdb, 0xce, 0x16, 0xb6, 0x64, 0x02, 0xb8, 0x5e, 0x15, 0x97, 0x07, 0xd7, 0xed, 0xac,
        0xff, 0x36, 0xa8, 0xe5, 0xd0, 0x4e, 0x17, 0x51, 0x1b, 0xf3, 0x35, 0xfd, 0x91, 0x16, 0x74, 0xc7, 0x05, 0xb6,
        0x7c, 0x0b, 0x4c, 0x8e, 0x1c, 0x38, 0x25, 0x13, 0xb9, 0x71, 0xa5, 0xf5, 0xba, 0x11, 0x2b, 0x71, 0xc6, 0x16,
        0x90, 0xdd, 0x83, 0xb9, 0x5e, 0xaa, 0x50, 0x8b, 0x63, 0x82, 0x97, 0x1f, 0xde, 0x5c, 0xdc, 0xfa, 0x2b, 0xb9,
        0xce, 0xf4, 0xbf, 0x9f, 0xa5, 0xd5, 0xe9, 0x5c, 0x2b, 0xe7, 0x78, 0x27, 0xe6, 0xd1, 0x81, 0xaf, 0xfd, 0xdd,
        0x4e, 0x4d, 0xb2, 0xce, 0xe4, 0x86, 0xfa, 0xad, 0x08, 0x85, 0x58, 0x3b, 0x6e, 0x6a, 0x42, 0x9c, 0x24, 0x5c,
        0x54, 0x85, 0x68, 0xe5, 0x69, 0x79, 0x80, 0x40, 0x2a, 0x05, 0xb5, 0xe1, 0x6d, 0x42, 0xba, 0x4d, 0xb5, 0x76,
        0xa4, 0x01, 0xe7, 0x11, 0xbc, 0x16, 0x69, 0x6f, 0x7a, 0x4a, 0xd5, 0x61, 0x9f, 0x07, 0x4b, 0xd7, 0xd5, 0x60,
        0x85, 0x21, 0x9b, 0x99, 0x77, 0xf2, 0xf6, 0x3d, 0xba, 0x30, 0xee, 0x54, 0xa8, 0xb4, 0x36, 0xa4, 0x12, 0xa9,
        0x22, 0x82, 0x83, 0x3c, 0x8c, 0x59, 0x35, 0x80, 0xd1, 0x52, 0x0e, 0x10, 0x49, 0x5e, 0xc4, 0xb0, 0x2f, 0x14,
        0x63, 0xaf, 0x40, 0x70, 0x3c, 0x38, 0x41, 0x1b, 0x5d, 0x79, 0x18, 0xc1, 0x2d, 0xb0, 0xa3, 0x1f, 0x25, 0x92,
        0xb7, 0x56, 0x7d, 0xd2, 0xa9, 0xbc, 0x86, 0x5c, 0x42, 0x2b, 0x78, 0xf7, 0x89, 0x7f, 0x8b, 0x48, 0x4c, 0x59,
        0xde, 0x30, 0x5b, 0x67, 0xbe, 0x3b, 0x5b, 0x7e, 0xa2, 0xf7, 0x8a, 0x26, 0x6f, 0x69, 0x61, 0x9e, 0xf7, 0x4f,
        0x67, 0xd2, 0x8f, 0xe8, 0x82, 0x6c, 0x14, 0x9d, 0x83, 0x47, 0x48, 0xf0, 0x56, 0x83, 0x4f, 0x9c, 0x0f, 0xdb,
        0xdb, 0x59, 0x05, 0x56, 0x1d, 0x12, 0xe8, 0x9a, 0x0c, 0xe8, 0x95, 0x32, 0x98, 0x10, 0x66, 0xcd, 0xf7, 0xf6,
        0x23, 0xdd, 0x63, 0xe3, 0x12, 0xb8, 0xed, 0xac, 0x10, 0x1a, 0x74, 0x15, 0xef, 0xaa, 0xe9, 0x4b, 0x0c, 0x59,
        0x04, 0xa5, 0x8e, 0x88, 0x26, 0xd8, 0x06, 0x14, 0x61, 0x49, 0x46, 0x3e, 0x57, 0x30, 0x91, 0x91, 0x32, 0x94,
        0xa9, 0x59, 0xbe, 0x1a, 0x1b, 0x40, 0x1d, 0x1a, 0x67, 0x0b, 0xa2, 0xc7, 0x8f, 0xdc, 0x67, 0x77, 0x9a, 0x1e,
        0x3b, 0x03, 0xb5, 0x9b, 0xb0, 0xbb, 0x4b, 0xe0, 0x52, 0x87, 0xa3, 0x56, 0xe2, 0xdc, 0x54, 0xa4, 0xce, 0xa3,
        0x63, 0x01, 0x94, 0xf5, 0x99, 0xd7, 0x99, 0xdb, 0xb9, 0x79, 0x4a, 0x26, 0xeb, 0xe6, 0xc8, 0x42, 0xe2, 0x00,
        0xf7, 0x8d, 0x7e, 0xcf, 0xa9, 0x22, 0x89, 0xed, 0x39, 0xe9, 0xc2, 0x75, 0xe1, 0x3a, 0x2f, 0xc4, 0x91, 0x72,
        0xde, 0x22, 0x95, 0xba, 0x38, 0xe7, 0x40, 0x2f, 0x47, 0xd0, 0x1e, 0x38, 0xee, 0xa1, 0x0a, 0x7d, 0xc7, 0xa9,
        0xc6, 0xe0, 0x1d, 0x7c, 0x6a, 0x39, 0xb5, 0x7b, 0xfc, 0xd3, 0x14, 0xe5, 0xae, 0xcb, 0x54, 0xbf, 0x56, 0x62,
        0x56, 0x79, 0x65, 0x0c, 0x8b, 0x47, 0x2c, 0x44, 0xd6, 0x84, 0x60, 0x69, 0x35, 0x20, 0x2d, 0xc1, 0xe6, 0xb3,
        0xf8, 0x65, 0x9f, 0x69, 0xc0, 0x80, 0x1c, 0xc5, 0x55, 0x07, 0x81, 0x08, 0x53, 0x05, 0x37, 0xd8, 0x7d, 0xe5,
        0xcc, 0x0c, 0x10, 0x1e, 0x10, 0x63, 0x1e, 0x7c, 0x15, 0xe8, 0x56, 0x83, 0xc4, 0xd3, 0xff, 0xc7, 0x71, 0x20,
        0x46, 0x31, 0xff, 0x43, 0x13, 0x80, 0x8e, 0xa2, 0x75, 0x78, 0xf5, 0xda, 0x8f, 0x1b, 0x79, 0x20, 0x0d, 0xb9,
        0x30, 0xce, 0x53, 0x71, 0x0e, 0x8e, 0xd2, 0xb2, 0x98, 0xc7, 0x30, 0xbf, 0x74, 0x21, 0x6b, 0x8c, 0x40, 0x80,
        0x1c, 0x8f, 0xb7, 0x10, 0x2b, 0xaf, 0xc4, 0x3d, 0x4f, 0x14, 0x47, 0xff, 0xef, 0x50, 0xd8, 0x37, 0x1a, 0x68,
        0xae, 0x7d, 0x33, 0x40, 0x47, 0xd7, 0x9c, 0x59, 0xcb, 0xf0, 0x80, 0x9b, 0x83, 0x92, 0x34, 0xce, 0x3c, 0x0c,
        0x0a, 0x56, 0x3c, 0x2a, 0x93, 0x26, 0x85, 0xe7, 0x8b, 0xd2, 0xce, 0x10, 0xef, 0x18, 0xd1, 0xf5, 0x43, 0x3a,
        0xde, 0x6e, 0x71, 0x5c, 0x54, 0x49, 0xa2, 0xdf, 0xa8, 0x33, 0x96, 0x3f, 0x52, 0xef, 0x90, 0x4e, 0xd5, 0x19,
        0xa5, 0xaa, 0x06, 0x92, 0xa6, 0x2b, 0xc4, 0x68, 0x7d, 0x5d, 0x3b, 0xc6, 0x28, 0x04, 0xc3, 0xbe, 0x15, 0x38,
        0xa7, 0x9b, 0xe8, 0x32, 0xf0, 0x3b, 0x49, 0x67, 0xb5, 0xd8, 0x6d, 0x21, 0x02, 0xd9, 0xe7, 0x45, 0xe8, 0xa5,
        0xc8, 0x93, 0x99, 0xc9, 0xeb, 0xf6, 0x97, 0xd6, 0x4f, 0x87, 0xf6, 0xca, 0x9e, 0x49, 0x9d, 0x8e, 0x87, 0x0e,
        0x25, 0x39, 0xfa, 0x8d, 0xb9, 0x7d, 0x5e, 0x96, 0x27, 0xf9, 0x07, 0x34, 0x04, 0x2a, 0x6f, 0x12, 0x52, 0x51,
        0x6e, 0x19, 0x33, 0x2d, 0x99, 0xb7, 0x2c, 0xae, 0x58, 0xec, 0x46, 0xe4, 0x48, 0x13, 0x90, 0x83, 0x3f, 0x70,
        0xaa, 0xaf, 0xa3, 0x73, 0x17, 0x49, 0x07, 0x4a, 0x2f, 0x71, 0x36, 0x29, 0xa3, 0x2f, 0x94, 0x15, 0x56, 0xb5,
        0x10, 0x89, 0x46, 0xf1, 0xee, 0x83, 0x57, 0xe4, 0xd2, 0xac, 0xe8, 0xca, 0x88, 0x2f, 0xaa, 0x0e, 0x01, 0xb9,
        0xf8, 0xa1, 0xf3, 0x45, 0xb0, 0x2d, 0x57, 0xe0, 0x17, 0x1e, 0x98, 0xe1, 0xfa, 0xf8, 0x91, 0x01, 0x20, 0xf8,
        0xa3, 0x59, 0xea, 0x93, 0xb8, 0x9a, 0x51, 0x4f, 0xce, 0xce, 0x97, 0x27, 0xd9, 0xb4, 0x8f, 0x6f, 0xd8, 0xe0,
        0x15, 0x5b, 0x3b, 0x52, 0x37, 0x56, 0x00, 0x04, 0xdf, 0xa5, 0x32, 0x5f, 0xb3, 0xe8, 0x0c, 0xae, 0xf4, 0x03,
        0x73, 0x5c, 0x46, 0x23, 0x0b, 0x4c, 0x9d, 0xee, 0x5c, 0x73, 0xcf, 0x89, 0x10, 0x9c, 0xad, 0x39, 0x7f, 0xcc,
        0xda, 0x38, 0xfd, 0x73, 0x1b, 0x16, 0xa7, 0xa4, 0xa0, 0xf4, 0xb7, 0x06, 0x25, 0xc8, 0x36, 0x67, 0x76, 0xd1,
        0x76, 0xf4, 0xde, 0xfc, 0x26, 0xfe, 0x0b, 0x9b, 0x32, 0x61, 0xa5, 0xb3, 0x40, 0xd2, 0x94, 0xf0, 0x0a, 0xfa,
        0x2f, 0x8a, 0x4c, 0x79, 0x45, 0xed, 0xf8, 0xac, 0x02, 0x33, 0x89, 0x41, 0x2a, 0x81, 0xd4, 0xd4, 0x67, 0x2a,
        0xcd, 0x86, 0xab, 0xa7, 0x92, 0x0b, 0xff, 0xf1, 0x33, 0x8a, 0x36, 0x6d, 0x36, 0xc6, 0xd2, 0xe0, 0x66, 0xed,
        0x0c, 0x5e, 0xd0, 0xfb, 0x05, 0x4a, 0xfa, 0x85, 0xc7, 0x6a, 0xe2, 0x10, 0xdf, 0x9b, 0xd3, 0x3e, 0x9b, 0xa6,
        0xe2, 0x9d, 0xf4, 0x57, 0xc2, 0xca, 0x8e, 0x10, 0x1a, 0x53, 0x16, 0x9e, 0xc7, 0x7b, 0x34, 0xcf, 0xb6, 0x67,
        0x79, 0xef, 0xe4, 0x62, 0xf0, 0xe5, 0x6c, 0x0a, 0xe9, 0xcc, 0x40, 0x1c, 0x6f, 0x99, 0x83, 0x85, 0xd9, 0x6f,
        0x7c, 0x4a, 0x62, 0x1f, 0x0c, 0xa8, 0xad, 0x7c, 0x8c, 0x3d, 0xc2, 0x32, 0x34, 0x21, 0xfc, 0xb3, 0xad, 0xe5,
        0x6e, 0xef, 0x04, 0x4a, 0x9f, 0x68, 0x59, 0x1e, 0xde, 0x1f, 0x25, 0xd5, 0x79, 0x4f, 0x47, 0x0c, 0xa1, 0x04,
        0xef, 0xc7, 0x82, 0x43, 0xc2, 0x13, 0xe8, 0x3b, 0x08, 0x84, 0xcb, 0xb8, 0x0c, 0x9a, 0x17, 0xe0, 0xe3, 0xf2,
        0x1b, 0xa7, 0xf5, 0x90, 0x68, 0xee, 0x54, 0x4d, 0x20, 0x78, 0x78, 0xc4, 0x8f, 0x65, 0x64, 0xa3, 0x97, 0x7f,
        0xad, 0xd6, 0x1c, 0x20, 0x4c, 0x05, 0xd8, 0x3a, 0xaf, 0x8e, 0x73, 0x55, 0x9d, 0x46, 0x74, 0x96, 0x44, 0x4e,
        0x63, 0xa8, 0x69, 0xcd, 0xf0, 0x79, 0x65, 0xf4, 0x0e, 0x3d, 0x68, 0x71, 0xe9, 0xa5, 0x8b, 0x78, 0xec, 0x51,
        0xc4, 0x67, 0x3d, 0xa0, 0xed, 0xcd, 0x10, 0x13, 0xc5, 0x31, 0xca, 0x57, 0x83, 0x1f, 0x47, 0xd0, 0xd7, 0x64,
        0x43, 0x66, 0xd2, 0xc2, 0xe1, 0xf8, 0x06, 0xc2, 0x84, 0xf8, 0x11, 0xb4, 0x46, 0x7a, 0x69, 0x0f, 0xbf, 0x06,
        0xbc, 0x6d, 0x20, 0xd6, 0x41, 0x70, 0xf3, 0x86, 0x74, 0x54, 0xb0, 0x48, 0x23, 0x31, 0xfa, 0x07, 0x1b, 0xba,
        0x4e, 0x23, 0xd9, 0xb1, 0x21, 0xad, 0x8a, 0xb0, 0xf1, 0xd9, 0x5d, 0x91, 0x78, 0xc2, 0x86, 0x33, 0xbe, 0xf4,
        0xf3, 0xac, 0x67, 0x30, 0x8f, 0xf0, 0xa7, 0x0a, 0x2e, 0x36, 0xe6, 0xed, 0x68, 0xe7, 0xde, 0x06, 0x75, 0x23,
        0x63, 0x62, 0xf8, 0x9a, 0xc2, 0x66, 0x7e, 0x43, 0xf6, 0x0c, 0x60, 0x77, 0x20, 0x2d, 0xa4, 0x39, 0xf8, 0xd3,
        0x37, 0x29, 0xc4, 0xb6, 0x74, 0x2f, 0x7b, 0x73, 0xd0, 0xfc, 0x5f, 0xd2, 0x79, 0xfd, 0x0f, 0xd7, 0x6f, 0x8c,
        0x62, 0x3d, 0x41, 0x98, 0x7f, 0x13, 0x7f, 0xfb, 0x92, 0xe5, 0xa7, 0xbf, 0xec, 0x6f, 0x37, 0x72, 0x43, 0xc5,
        0x3b, 0xb3, 0xb7, 0xb3, 0x15, 0xa3, 0x64, 0x5f, 0x8e, 0x73, 0x3a, 0xdd, 0xa3, 0xe9, 0x76, 0xe6, 0x35, 0x93,
        0x5c, 0x4b, 0x70, 0xd6, 0xf7, 0xbc, 0x47, 0xa9, 0x81, 0x7b, 0xce, 0xb5, 0x77, 0xe4, 0x4c, 0x7a, 0x76, 0x8c,
        0xc1, 0xfd, 0x88, 0xd0, 0x93, 0x70, 0x00, 0xc2, 0xfa, 0x3f, 0x18, 0x10, 0xb8, 0xdc, 0x44, 0xb8, 0x37, 0x30,
        0x88, 0x6d, 0x61, 0x0b, 0x25, 0xf4, 0xd1, 0x44, 0x12, 0xbd, 0x68, 0x79, 0xc8, 0xf0, 0x77, 0xef, 0x21, 0x84,
        0x5f, 0x71, 0xd5, 0x53, 0x66, 0xda, 0xc8, 0x4a, 0x53, 0xe5, 0xfd, 0xa0, 0x14, 0x36, 0x99, 0x40, 0x47, 0x4e,
        0x0b, 0x20, 0x64, 0x11, 0x32, 0xf8, 0xfb, 0xc1, 0x66, 0x43, 0x8f, 0xdb, 0x0d, 0x88, 0xfe, 0x48, 0xed, 0x3f,
        0xd0, 0x1a, 0x9c, 0xe4, 0x78, 0xb0, 0x66, 0x3a, 0x7b, 0xea, 0x39, 0xa2, 0x59, 0x44, 0x1e, 0xdd, 0x65, 0xa9,
        0x2c, 0x71, 0x9a, 0x95, 0xc1, 0xea, 0x03, 0x2d, 0x32, 0x35, 0xf8, 0x2a, 0xb4, 0x55, 0x79, 0xce, 0x90, 0xdb,
        0x53, 0x40, 0x60, 0x03, 0x0a, 0x99, 0x5d, 0x56, 0x13, 0x64, 0x41, 0x8e, 0x63, 0x85, 0x48, 0xfa, 0x8d, 0x74,
        0x0e, 0x68, 0xb7, 0xd9, 0xd3, 0x5c, 0xc3, 0x07, 0x67, 0xa1, 0x1c, 0x98, 0x4f, 0xec, 0x61, 0x37, 0x49, 0x06,
        0x93, 0x6b, 0xd0, 0xf9, 0xe9, 0x31, 0x5a, 0xc9, 0xbc, 0x48, 0x8a, 0x02, 0x42, 0x3a, 0xad, 0xd3, 0x2a, 0x01,
        0x47, 0x58, 0xb8, 0x54, 0xad, 0x1e, 0xa8, 0xe3, 0xce, 0x84, 0xa6, 0xdc, 0xaf, 0x8f, 0xa3, 0x69, 0xb1, 0x99,
        0x21, 0x42, 0x2f, 0x7b, 0xbc, 0x37, 0x99, 0xd5, 0xe0, 0xb9, 0x06, 0x67, 0xef, 0x73, 0x3d, 0x33, 0x87, 0x76,
        0x56, 0x1b, 0x8f, 0x89, 0x1d, 0x77, 0xc3, 0x7a, 0x4b, 0xce, 0x26, 0x72, 0xa3, 0xfd
};

// Wake-word = picovoice
static const uint8_t PICOVOICE_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0xe1, 0x93, 0xe5, 0xf6, 0xae, 0x97, 0x6b, 0xbe, 0x36, 0x1b, 0xfe, 0x24, 0x77, 0x2b, 0xa2, 0xa8, 0xed, 0xc8,
        0x31, 0x5a, 0x17, 0xb7, 0x4e, 0xef, 0xd0, 0xc0, 0xe9, 0x11, 0x99, 0x2a, 0xb8, 0x13, 0x65, 0x07, 0x32, 0x24,
        0xb2, 0x8d, 0xfd, 0x01, 0x0f, 0x16, 0x8e, 0x98, 0x55, 0xfd, 0x91, 0x79, 0x9d, 0x3d, 0x4a, 0xa2, 0x3c, 0x3f,
        0x46, 0x36, 0x40, 0x37, 0x23, 0x7d, 0xd3, 0x31, 0x17, 0xa3, 0x26, 0x72, 0xf1, 0x5f, 0xab, 0x19, 0x3a, 0x57,
        0x9b, 0x52, 0xc6, 0x16, 0x17, 0x01, 0x46, 0x19, 0xfe, 0x17, 0x13, 0xd1, 0xda, 0xbe, 0x5b, 0x50, 0x2d, 0x08,
        0xd8, 0x55, 0x4d, 0xf9, 0x69, 0x4f, 0x4b, 0x89, 0xd9, 0xea, 0x97, 0x7a, 0xab, 0x41, 0x68, 0xe2, 0x50, 0xfa,
        0xf2, 0xbb, 0xa4, 0x60, 0x89, 0xfd, 0x1b, 0x73, 0x6d, 0x71, 0xec, 0x03, 0xec, 0xc9, 0xc7, 0x18, 0x72, 0x16,
        0xa9, 0xfc, 0x05, 0x2f, 0xa7, 0x46, 0x6d, 0x55, 0xe8, 0x88, 0x03, 0xcc, 0x87, 0x91, 0xe5, 0x09, 0x75, 0xf4,
        0x9e, 0x35, 0xb9, 0x2d, 0x1c, 0xc4, 0x79, 0x52, 0xad, 0xb9, 0xcd, 0xd6, 0x07, 0x45, 0x79, 0xb8, 0xcf, 0x70,
        0xea, 0xe4, 0x3e, 0x89, 0x65, 0xdd, 0xf1, 0xb4, 0x7e, 0x74, 0xf7, 0xbc, 0xc5, 0x18, 0x86, 0x77, 0x12, 0xd0,
        0x91, 0x73, 0xdb, 0x8a, 0x71, 0x79, 0xac, 0x43, 0x1a, 0x7c, 0x0a, 0xca, 0x6e, 0xe4, 0x69, 0x51, 0xf9, 0x29,
        0xc3, 0x47, 0x0d, 0xfa, 0x94, 0x54, 0x5c, 0xc8, 0x41, 0x90, 0x43, 0x6a, 0x86, 0x7d, 0xf7, 0x49, 0x2e, 0x6d,
        0xe1, 0x91, 0x5b, 0xc6, 0xbe, 0x86, 0x7c, 0xa7, 0xe9, 0x18, 0x61, 0x07, 0x89, 0x9e, 0x1e, 0xdc, 0xe6, 0x14,
        0x6c, 0x0b, 0xd5, 0xcb, 0x52, 0x4c, 0xf8, 0xb8, 0x6d, 0x9d, 0xc8, 0x13, 0xbd, 0xca, 0x34, 0xde, 0x5a, 0xe8,
        0xe3, 0x01, 0x9b, 0x5d, 0x04, 0xc6, 0x02, 0xa9, 0x00, 0x6d, 0x82, 0x31, 0xf7, 0xb4, 0xc3, 0xf4, 0xe3, 0xb8,
        0x5b, 0xcd, 0xf0, 0x1c, 0x0a, 0xda, 0x4e, 0x81, 0xb5, 0xed, 0xd7, 0x1f, 0x38, 0x41, 0xb2, 0x97, 0x20, 0xa8,
        0x71, 0x52, 0xa2, 0xb2, 0x63, 0x55, 0x26, 0xe3, 0x74, 0x17, 0x5e, 0xe7, 0x5f, 0xf7, 0x89, 0x9b, 0x44, 0xaf,
        0x33, 0x20, 0x93, 0x0c, 0xdb, 0x79, 0x89, 0xa7, 0x30, 0xac, 0xe0, 0xde, 0xbd, 0x58, 0xa3, 0x26, 0x02, 0x7c,
        0xe7, 0xba, 0x71, 0xbe, 0x59, 0xe9, 0xbb, 0x46, 0x6a, 0xd3, 0x64, 0x29, 0x02, 0x43, 0x7e, 0xd8, 0x5a, 0xb1,
        0x21, 0xb1, 0x23, 0xc3, 0xdf, 0xee, 0xd2, 0x4a, 0x22, 0x14, 0x7b, 0x33, 0xda, 0x1f, 0x43, 0x57, 0x0b, 0xde,
        0x5e, 0x27, 0x74, 0xfb, 0x0c, 0xac, 0x62, 0x58, 0x75, 0x93, 0xcb, 0x4a, 0x6b, 0xfc, 0x87, 0x5a, 0x3d, 0xda,
        0x33, 0xb1, 0x89, 0x59, 0xc2, 0x25, 0xd8, 0xc7, 0xa0, 0xcc, 0xd0, 0x99, 0x6c, 0x65, 0x55, 0x04, 0x07, 0x12,
        0x73, 0xd6, 0xf7, 0x43, 0x0c, 0xad, 0xc9, 0x8a, 0xc1, 0x40, 0x1f, 0x3c, 0x38, 0x87, 0x9e, 0x6f, 0x47, 0xa8,
        0x12, 0xdd, 0xbf, 0x0a, 0xe4, 0x66, 0x68, 0x16, 0x75, 0x50, 0x69, 0x31, 0x8c, 0xbe, 0xfe, 0x4d, 0x77, 0x60,
        0x26, 0xa0, 0xbd, 0xd9, 0xf6, 0x6a, 0x7b, 0xa1, 0x98, 0x8c, 0xc0, 0xb0, 0x09, 0x17, 0xd7, 0xae, 0x34, 0x54,
        0xf8, 0x9a, 0x2e, 0x10, 0xa1, 0x11, 0x0e, 0x99, 0x23, 0x2e, 0x4e, 0x54, 0x5a, 0xd9, 0xac, 0x0b, 0x8f, 0xeb,
        0x33, 0xca, 0xac, 0x2b, 0x8a, 0x47, 0xad, 0xe2, 0xf2, 0x87, 0x45, 0x33, 0x9a, 0xde, 0xa6, 0x7a, 0xd7, 0x5e,
        0x4e, 0x7d, 0x79, 0x73, 0x51, 0x07, 0x63, 0x95, 0xb8, 0xfe, 0x93, 0x12, 0x94, 0xcc, 0xd9, 0x32, 0x58, 0xf7,
        0x38, 0xb2, 0xc1, 0xdc, 0xea, 0x7f, 0xda, 0x86, 0xba, 0x6e, 0xe8, 0x68, 0x16, 0x86, 0xde, 0x62, 0xc3, 0xa0,
        0x6a, 0x24, 0x62, 0x31, 0x26, 0x17, 0x91, 0x6b, 0xc8, 0x99, 0x21, 0xd7, 0x86, 0x1f, 0xa6, 0x76, 0x84, 0x95,
        0x99, 0x69, 0x76, 0xc0, 0x89, 0x3d, 0xe7, 0x70, 0xf1, 0x1e, 0xb7, 0x83, 0x5f, 0x0c, 0x73, 0xbd, 0xe8, 0xbe,
        0x74, 0xa8, 0xfe, 0x5e, 0xdb, 0x6f, 0x1c, 0xc4, 0xba, 0x7a, 0x4b, 0x51, 0xd7, 0x42, 0x05, 0xeb, 0xbc, 0x89,
        0xe9, 0xcd, 0x5e, 0x72, 0x6a, 0xdf, 0x92, 0xd9, 0x6b, 0x65, 0xe8, 0x80, 0x13, 0xc3, 0x1e, 0x93, 0xfe, 0x8c,
        0x17, 0xb0, 0x83, 0xb5, 0x43, 0x7e, 0xd5, 0xa0, 0xcb, 0xa4, 0x9a, 0x3d, 0xf8, 0x31, 0x87, 0xdf, 0x2a, 0x09,
        0xb1, 0x69, 0x9d, 0xe7, 0x2e, 0x5b, 0xef, 0x36, 0x3b, 0x68, 0x39, 0x45, 0x0a, 0xe1, 0xb2, 0xbe, 0x90, 0x03,
        0xfa, 0x2c, 0xbe, 0x47, 0x21, 0xa1, 0x9b, 0x20, 0xc6, 0x40, 0x38, 0xf9, 0x8c, 0xc0, 0xae, 0x4a, 0x0d, 0x3c,
        0xa3, 0x27, 0x92, 0x0b, 0x8f, 0x03, 0x7a, 0x9a, 0x34, 0x61, 0xbf, 0x99, 0x10, 0x0e, 0xd7, 0xad, 0xfd, 0x72,
        0x36, 0xdd, 0x0a, 0x2d, 0x14, 0x41, 0xd6, 0x4e, 0x62, 0x3f, 0x44, 0xb8, 0xc6, 0x88, 0xef, 0x28, 0x26, 0xfd,
        0xbc, 0xf7, 0x0e, 0xf3, 0x67, 0xd9, 0x2b, 0x67, 0x86, 0x37, 0xda, 0x4a, 0xc7, 0x2e, 0x55, 0x06, 0xe9, 0x19,
        0xb2, 0x74, 0x16, 0x8e, 0x2d, 0x34, 0x9b, 0x09, 0x70, 0x4b, 0x33, 0x2d, 0xd6, 0x47, 0x05, 0x2a, 0x9c, 0xff,
        0xda, 0xfe, 0x15, 0xc9, 0xa1, 0xdd, 0x8e, 0x2f, 0xe6, 0xa1, 0x89, 0x8c, 0x6e, 0x5b, 0x1a, 0x28, 0x9b, 0xdc,
        0x80, 0x32, 0xd5, 0x84, 0x93, 0xd0, 0xcc, 0xed, 0x17, 0xe9, 0x9e, 0x65, 0xc9, 0x0d, 0xe6, 0x2c, 0x3a, 0xc2,
        0xef, 0x68, 0xd5, 0x64, 0x61, 0x99, 0x94, 0x1b, 0x6f, 0xf9, 0x2b, 0x31, 0xb2, 0x8c, 0x8f, 0x09, 0xb1, 0x9b,
        0x09, 0x8c, 0xa2, 0x12, 0x15, 0x38, 0x8b, 0x4b, 0xdf, 0xd3, 0x22, 0x4d, 0xea, 0xec, 0xf9, 0x8a, 0x97, 0x59,
        0x26, 0xaa, 0x0e, 0x67, 0xf6, 0x34, 0x81, 0x32, 0xf3, 0x32, 0x47, 0x17, 0xf5, 0xe6, 0x2c, 0x47, 0xf4, 0xba,
        0x38, 0xf9, 0xc2, 0xf1, 0x43, 0x7e, 0x6f, 0x39, 0xde, 0x36, 0x95, 0x25, 0x0c, 0x65, 0x59, 0x9d, 0x50, 0xa5,
        0x4f, 0x79, 0x8c, 0xd9, 0x0c, 0xf5, 0xcd, 0x77, 0xa1, 0x3a, 0xda, 0x81, 0x9a, 0xba, 0xdb, 0xe4, 0x65, 0x9a,
        0x25, 0x55, 0x36, 0x16, 0xb5, 0xcb, 0x28, 0xc5, 0xb2, 0x1b, 0x3e, 0x78, 0xb1, 0xd7, 0xe7, 0x26, 0x7b, 0x2d,
        0x03, 0x71, 0xc7, 0x36, 0xcf, 0xc3, 0xb5, 0x6d, 0xd1, 0x55, 0x4d, 0x3d, 0x63, 0x7c, 0xe4, 0xc9, 0xfe, 0x1b,
        0xd8, 0x64, 0xa9, 0x08, 0x56, 0x63, 0x3c, 0x8b, 0xfb, 0x45, 0x33, 0x5a, 0x6d, 0xea, 0x39, 0x7b, 0x52, 0x0b,
        0x3e, 0xef, 0x6e, 0x4e, 0xa5, 0xf2, 0x16, 0xc4, 0x3e, 0x9a, 0x70, 0xe2, 0xf4, 0x74, 0x80, 0xb8, 0x00, 0x72,
        0xbc, 0x54, 0x30, 0x44, 0xc3, 0x85, 0x5e, 0x28, 0xa9, 0xf0, 0x42, 0xe9, 0xbd, 0xb7, 0x4c, 0xc6, 0x39, 0x30,
        0xa3, 0xf2, 0xa2, 0x53, 0x5c, 0x1f, 0x07, 0x90, 0xdf, 0x0e, 0x35, 0xea, 0x7d, 0x93, 0x04, 0x13, 0xaa, 0x6f,
        0x40, 0x70, 0xc5, 0x80, 0xbf, 0xa3, 0xf7, 0xf9, 0x1f, 0x36, 0x48, 0x6e, 0x6d, 0xe1, 0xe5, 0xfb, 0x86, 0x33,
        0x92, 0x12, 0x07, 0xc7, 0x55, 0xd1, 0x0c, 0x58, 0xb9, 0xf9, 0xa2, 0xcd, 0x00, 0x80, 0x29, 0x7c, 0xc6, 0x2b,
        0x3f, 0x50, 0x65, 0x93, 0x6f, 0xd0, 0x70, 0xa8, 0x30, 0x47, 0x03, 0x3b, 0x8b, 0xf4, 0x3d, 0x26, 0x3b, 0x11,
        0xcd, 0xd4, 0x72, 0x28, 0x0e, 0x2d, 0xef, 0xef, 0x56, 0x02, 0x57, 0x5e, 0x8d, 0x53, 0x81, 0xd5, 0x49, 0xb8,
        0xf6, 0xf9, 0x39, 0x81, 0xa5, 0xa2, 0x0f, 0xd0, 0x2d, 0x76, 0xd2, 0x4a, 0x50, 0xa2, 0x79, 0x14, 0x53, 0xe3,
        0x8b, 0x1f, 0xbd, 0xd9, 0x28, 0x14, 0x3b, 0x06, 0x24, 0x1e, 0x67, 0x70, 0xc3, 0xd4, 0x90, 0xbd, 0xfc, 0xac,
        0x72, 0x99, 0xc8, 0xa2, 0x8c, 0x5f, 0x24, 0x8a, 0x20, 0x96, 0x60, 0x12, 0x09, 0x37, 0xcb, 0x56, 0x37, 0xa4,
        0x03, 0x95, 0xe6, 0xde, 0xc1, 0x13, 0x46, 0xa8, 0xf5, 0x5f, 0x27, 0x3e, 0xf7, 0x50, 0x3d, 0x63, 0xff, 0xb2,
        0xea, 0xc5, 0xb3, 0x1b, 0x2c, 0x0a, 0x6b, 0x8e, 0xe6, 0x0d, 0x7b, 0x58, 0x9d, 0xbe, 0x69, 0xbb, 0xff, 0xe8,
        0x74, 0x7f, 0x8b, 0x82
};

// Wake-word = bumblebee
static const uint8_t BUMBLEBEE_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0xfe, 0x35, 0x9d, 0x0d, 0x6c, 0x83, 0xcb, 0xd8, 0x6c, 0x75, 0x72, 0x37, 0xa9, 0x8a, 0xbc, 0xb1, 0xff, 0x1a,
        0xea, 0x38, 0xc3, 0xba, 0x56, 0x0c, 0x4d, 0xf9, 0xcb, 0x1f, 0x8d, 0x36, 0xd3, 0x8a, 0x00, 0xc4, 0x5c, 0x82,
        0xd2, 0x43, 0x7f, 0xa3, 0x0b, 0x98, 0x70, 0x76, 0xc2, 0x45, 0x99, 0xd0, 0xfd, 0x76, 0x30, 0x89, 0xee, 0xac,
        0x5c, 0x55, 0x24, 0x34, 0x0d, 0x77, 0xc8, 0x1c, 0x83, 0x26, 0x16, 0x00, 0xc1, 0xce, 0x5d, 0x7d, 0xf8, 0x2a,
        0x49, 0x42, 0xcb, 0xe0, 0xb8, 0x60, 0xdc, 0x2e, 0x3e, 0x03, 0x1d, 0x71, 0x92, 0xa8, 0x43, 0xd7, 0x5d, 0xe9,
        0x41, 0x55, 0x6c, 0x38, 0x91, 0x77, 0x59, 0xcc, 0x8f, 0x14, 0xd2, 0x3b, 0x02, 0x77, 0x68, 0xe9, 0x87, 0xec,
        0x30, 0x2f, 0xab, 0x0d, 0xc2, 0x8b, 0xf9, 0x18, 0xbc, 0xbc, 0xdb, 0x58, 0xeb, 0xf6, 0x83, 0x0c, 0xf9, 0x90,
        0x14, 0xf2, 0x5e, 0x79, 0x52, 0x4e, 0xe2, 0x65, 0x24, 0x45, 0xbe, 0x91, 0x5a, 0x18, 0x39, 0x02, 0xf3, 0xf6,
        0x4a, 0x08, 0x71, 0x94, 0x98, 0xb5, 0xaa, 0xe6, 0x46, 0x6f, 0x08, 0x14, 0x4e, 0xf7, 0x25, 0xc5, 0xed, 0xaa,
        0x83, 0x3b, 0x6c, 0x62, 0x39, 0x6e, 0xd4, 0xd8, 0x80, 0x0e, 0x28, 0x84, 0x54, 0x09, 0x09, 0x4e, 0x5d, 0x87,
        0x3c, 0xda, 0xd6, 0x8c, 0xc8, 0x99, 0xef, 0x59, 0x4f, 0x04, 0x11, 0x19, 0x2f, 0xd4, 0xe7, 0xd4, 0xe1, 0x7a,
        0x38, 0x31, 0x98, 0x7a, 0x19, 0x46, 0x55, 0x1d, 0x7f, 0xeb, 0x55, 0x45, 0xcf, 0xb9, 0x5a, 0xa8, 0xf5, 0x63,
        0x3a, 0x03, 0xb4, 0x90, 0x8f, 0xcf, 0x91, 0x97, 0x76, 0x8c, 0x03, 0xb2, 0x6c, 0x4c, 0x3c, 0x20, 0x16, 0x14,
        0xb8, 0x56, 0x0c, 0x86, 0x10, 0xa2, 0x2c, 0x49, 0xbe, 0xef, 0x8b, 0x35, 0x40, 0x9e, 0x14, 0x21, 0xad, 0x71,
        0x2d, 0x7d, 0xb5, 0x5b, 0xb2, 0x30, 0x23, 0x4c, 0x48, 0x8f, 0x27, 0xa2, 0x01, 0x39, 0x75, 0xbc, 0x15, 0x79,
        0x64, 0xf5, 0xc8, 0x44, 0xe4, 0xf8, 0x5b, 0x03, 0x0b, 0xe8, 0x62, 0xad, 0xb0, 0x42, 0x02, 0x19, 0xfa, 0x72,
        0x46, 0xe0, 0xb6, 0x1a, 0x3e, 0x4a, 0xcd, 0x42, 0x56, 0x0f, 0xcf, 0xce, 0x77, 0xfd, 0x3b, 0x35, 0xa9, 0x36,
        0xa5, 0x95, 0x2d, 0xbf, 0x14, 0x3f, 0x2f, 0xaf, 0x9c, 0x27, 0xda, 0x22, 0xac, 0x4a, 0x9b, 0x7e, 0xb0, 0x7d,
        0x65, 0xdd, 0x64, 0x67, 0x35, 0x23, 0x1b, 0xe2, 0x3b, 0xe9, 0x26, 0xe9, 0xe3, 0x63, 0xc9, 0x1c, 0xf8, 0xff,
        0xd9, 0xd7, 0x20, 0x2b, 0x61, 0x42, 0x24, 0x63, 0xc5, 0xa5, 0xd6, 0x3d, 0x33, 0xff, 0xdf, 0xb9, 0xba, 0x11,
        0x87, 0x34, 0x63, 0x52, 0xd4, 0xa1, 0x1a, 0x11, 0xe9, 0xb8, 0xda, 0xd8, 0xa9, 0xe8, 0xec, 0x5e, 0xde, 0x48,
        0x6f, 0x19, 0x1e, 0x29, 0x18, 0x93, 0x81, 0xc9, 0x5f, 0xc4, 0x95, 0x8c, 0xaf, 0x0b, 0x5d, 0xc4, 0x49, 0x09,
        0x0d, 0xe8, 0x9a, 0xe6, 0x66, 0xb2, 0xd7, 0x1c, 0x81, 0x1c, 0x2d, 0xb7, 0x10, 0x68, 0x3e, 0x1f, 0xcc, 0xb0,
        0xf9, 0xe3, 0x93, 0xe2, 0x0e, 0xd2, 0x8c, 0x22, 0x49, 0x90, 0x3a, 0x89, 0x7e, 0x53, 0x22, 0x95, 0x42, 0x3a,
        0x0f, 0x1a, 0x2b, 0xf1, 0xa4, 0x5a, 0x5f, 0xa3, 0x78, 0xf3, 0x26, 0x20, 0xf1, 0xfe, 0xe0, 0x8c, 0x72, 0xe1,
        0x9c, 0xa7, 0x71, 0x84, 0x43, 0xc9, 0x87, 0xac, 0x45, 0x27, 0x3b, 0x1e, 0x1d, 0xcc, 0x69, 0x5b, 0x7c, 0xdd,
        0xb4, 0xb8, 0x61, 0x88, 0xfe, 0x93, 0x95, 0x1d, 0xec, 0xd3, 0xc4, 0x54, 0xcc, 0xa8, 0xd8, 0x4b, 0x3f, 0xcd,
        0xa6, 0xff, 0xdb, 0xa0, 0x6d, 0x99, 0xc2, 0xbd, 0x26, 0xe8, 0xad, 0x32, 0xca, 0x99, 0x24, 0x36, 0x83, 0xbf,
        0x0e, 0x0b, 0xac, 0x8e, 0x45, 0x3c, 0xfc, 0x4a, 0x76, 0x51, 0xc3, 0xa3, 0xef, 0x5c, 0x00, 0x55, 0x94, 0x52,
        0xd4, 0x8e, 0x54, 0x05, 0xd8, 0x0d, 0x0f, 0x61, 0xd8, 0x38, 0x75, 0x77, 0x70, 0x29, 0xf7, 0x53, 0xf3, 0x3f,
        0x11, 0x01, 0x2f, 0x12, 0xf1, 0x51, 0x8d, 0x29, 0x12, 0x7c, 0xe0, 0x84, 0xc4, 0x72, 0xde, 0x7c, 0x4f, 0xa8,
        0xd8, 0xf4, 0x3e, 0x5f, 0xc4, 0x8a, 0xf9, 0x64, 0x92, 0x06, 0xb5, 0x56, 0x62, 0x7e, 0x85, 0x3f, 0xa6, 0x74,
        0x21, 0x32, 0x4a, 0x89, 0x6a, 0xe4, 0x69, 0x25, 0x4f, 0xc9, 0x05, 0x5e, 0xf9, 0x60, 0xeb, 0x9d, 0x97, 0x83,
        0xe0, 0x98, 0x89, 0xb2, 0x41, 0xc8, 0xb5, 0x8b, 0x2c, 0x19, 0x7d, 0xf5, 0x81, 0x87, 0x5f, 0x1e, 0x89, 0xcf,
        0x9b, 0xb6, 0x29, 0x9f, 0x0c, 0xac, 0x3f, 0x7c, 0x93, 0xed, 0xd4, 0x5c, 0x1b, 0xed, 0x48, 0x66, 0x7a, 0x13,
        0xf6, 0x39, 0x1a, 0x17, 0x48, 0x49, 0xfe, 0xda, 0x25, 0x28, 0xd1, 0xdb, 0xde, 0xf4, 0x45, 0xd2, 0x2c, 0x47,
        0x9a, 0x1a, 0x09, 0xb8, 0xa8, 0x85, 0x76, 0xc3, 0x8c, 0x41, 0xb4, 0x5e, 0xcc, 0xe4, 0x4e, 0x74, 0xb1, 0x1d,
        0x62, 0xdf, 0x35, 0x82, 0xde, 0xc2, 0x95, 0xc4, 0x79, 0x2b, 0x62, 0x58, 0xa7, 0x34, 0xe7, 0x26, 0x46, 0x99,
        0xfd, 0xfa, 0x5e, 0x34, 0xb8, 0x95, 0x5b, 0xec, 0xa2, 0x15, 0xb7, 0x98, 0x0f, 0xa8, 0xee, 0x6b, 0x48, 0x99,
        0x5d, 0x0a, 0x12, 0x4b, 0xf1, 0x9d, 0x1a, 0xde, 0xf9, 0xab, 0x1e, 0xd2, 0x44, 0x89, 0xcd, 0xe0, 0x6d, 0xda,
        0x50, 0xf0, 0x31, 0x65, 0x44, 0x81, 0xf9, 0x08, 0xe7, 0xfd, 0xc6, 0xc1, 0x2f, 0xa2, 0xb5, 0xad, 0xe2, 0x78,
        0xb3, 0x25, 0xc5, 0xf4, 0x50, 0x16, 0x68, 0x36, 0x63, 0x90, 0x1d, 0x35, 0x96, 0x38, 0xd6, 0x30, 0x33, 0x74,
        0xab, 0x58, 0x93, 0xb6, 0x4a, 0x42, 0x7f, 0xa4, 0x31, 0x01, 0x00, 0xfe, 0x38, 0x83, 0x38, 0x72, 0x6b, 0xb5,
        0xd0, 0xdc, 0x3d, 0x4e, 0x4e, 0xfb, 0xbb, 0x69, 0xb8, 0x31, 0xee, 0x04, 0xc9, 0xbc, 0xec, 0xe1, 0x4c, 0xf4,
        0x15, 0x7d, 0x61, 0xed, 0x4d, 0x10, 0x14, 0xf1, 0x04, 0x61, 0xc5, 0x1e, 0xc4, 0xe8, 0x46, 0x98, 0xa2, 0x70,
        0x47, 0x6d, 0xbc, 0xbf, 0x70, 0x29, 0x86, 0x9f, 0x60, 0xe8, 0xcc, 0x6e, 0x29, 0x0f, 0xe2, 0xb4, 0xb5, 0xfc,
        0xe2, 0xd0, 0x89, 0x49, 0x44, 0xa2, 0x73, 0xa4, 0x94, 0x05, 0xd7, 0x8d, 0x65, 0x9a, 0x1d, 0x1d, 0x32, 0xff,
        0xdb, 0xa7, 0x8a, 0xa9, 0x35, 0x37, 0x2c, 0xb9, 0x8a, 0x2b, 0x98, 0x17, 0x2d, 0x5f, 0x5a, 0x70, 0xe1, 0x3f,
        0x02, 0xf8, 0xdb, 0x4e, 0xd4, 0x3b, 0x6c, 0x40, 0xc4, 0x19, 0xb4, 0xc6, 0x83, 0x6f, 0xdb, 0x80, 0x3d, 0xe6,
        0x8e, 0x54, 0xf9, 0x2f, 0x53, 0x41, 0xff, 0x87, 0x6d, 0x25, 0x79, 0xc5, 0x1d, 0xdb, 0xfe, 0xa4, 0x54, 0x8c,
        0xda, 0xa6, 0x86, 0xd4, 0x01, 0xfd, 0x4f, 0x90, 0x79, 0xff, 0x5a, 0x7d, 0x24, 0x79, 0x2e, 0x87, 0xb3, 0xa8,
        0x37, 0x9d, 0x42, 0x27, 0x3f, 0x6a, 0x54, 0x7e, 0xd7, 0xd1, 0x08, 0xe1, 0x38, 0x6d, 0xc0, 0x55, 0xd9, 0x97,
        0xcc, 0xeb, 0x95, 0x83, 0xe9, 0x15, 0x42, 0x7e, 0xc3, 0x1f, 0x8f, 0x07, 0xaa, 0x67, 0x49, 0xa8, 0x1f, 0x14,
        0x52, 0xb9, 0xfe, 0x7a, 0x10, 0x2e, 0x2c, 0x9a, 0x26, 0xd7, 0xfd, 0x69, 0x89, 0x40, 0x51, 0x1b, 0x4d, 0x1d,
        0xa8, 0x13, 0x71, 0xcb, 0xeb, 0xd3, 0xfe, 0x36, 0x2a, 0x65, 0xdc, 0x28, 0xf9, 0x70, 0x3f, 0x86, 0x80, 0xad,
        0x6b, 0xd6, 0xa6, 0xca, 0x85, 0x23, 0x51, 0x2d, 0x62, 0xff, 0x8e, 0x7b, 0x5f, 0xe3, 0x7d, 0x50, 0x65, 0xfb,
        0x1f, 0x11, 0x46, 0x5c, 0xd1, 0xc4, 0x88, 0x29, 0x28, 0xd7, 0xd0, 0x10, 0x32, 0x18, 0x95, 0xb7, 0x21, 0x12,
        0xc3, 0x95, 0xac, 0x37, 0xcd, 0x71, 0x2e, 0x76, 0xf3, 0x3c, 0x5d, 0x64, 0x3a, 0xe0
};

// Wake-word = alexa
static const uint8_t ALEXA_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x6e, 0x3a, 0x35, 0x3a, 0x41, 0x97, 0x69, 0xae, 0x43, 0xa0, 0xe4, 0x5e, 0x9f, 0x7c, 0x5e, 0x68, 0x8d, 0x3d,
        0x5a, 0xa7, 0xd1, 0x45, 0xf7, 0x5f, 0x30, 0x26, 0x1c, 0x0a, 0xef, 0xb7, 0xa1, 0xdc, 0xc3, 0x05, 0x78, 0x94,
        0xbc, 0x57, 0x2a, 0x28, 0xcf, 0x3a, 0xb5, 0x77, 0xb3, 0x89, 0xae, 0x9a, 0x7f, 0x46, 0xe6, 0x42, 0x33, 0xf8,
        0x7f, 0x60, 0x66, 0xda, 0x65, 0xe6, 0x5a, 0x22, 0x15, 0xcd, 0x7d, 0x9e, 0xbf, 0x4a, 0xce, 0x9d, 0x89, 0x13,
        0xd4, 0x41, 0x63, 0x8d, 0x53, 0x0f, 0xd7, 0x6a, 0x6f, 0x6c, 0x01, 0x35, 0x2b, 0xba, 0xa6, 0xb4, 0xff, 0xd5,
        0xa4, 0x1e, 0x52, 0x32, 0x5d, 0x5b, 0x70, 0xe0, 0x9d, 0x94, 0x7f, 0x74, 0x50, 0xe5, 0xb5, 0x34, 0x62, 0x69,
        0xab, 0x2f, 0xb4, 0x04, 0xe2, 0xcb, 0xbe, 0x3d, 0x84, 0x63, 0xc0, 0x3f, 0x79, 0x7f, 0x23, 0x35, 0x69, 0x44,
        0xde, 0x1e, 0x72, 0x25, 0xfa, 0xaf, 0x90, 0xb4, 0xb9, 0x1b, 0xe2, 0x04, 0x38, 0x3e, 0x56, 0xb6, 0x9d, 0xe0,
        0xc2, 0x6c, 0x31, 0xda, 0xef, 0xb4, 0xd2, 0x05, 0x3b, 0x69, 0xde, 0x29, 0x27, 0x8a, 0xae, 0xa9, 0xf8, 0x15,
        0x34, 0xb6, 0xc2, 0xde, 0xc8, 0xf9, 0x27, 0xea, 0xed, 0xd8, 0x4f, 0x49, 0xcf, 0xce, 0x9e, 0xdd, 0x60, 0xf9,
        0xe1, 0x6c, 0x18, 0x42, 0x9a, 0xf6, 0x1b, 0x82, 0x9d, 0x72, 0x64, 0x47, 0xd9, 0x15, 0x18, 0x7d, 0x2a, 0xcc,
        0x99, 0x78, 0x59, 0xdf, 0xa6, 0x6e, 0x6a, 0x40, 0xd6, 0x35, 0x79, 0x95, 0xdf, 0x18, 0xbf, 0x98, 0x6c, 0x49,
        0x42, 0x5c, 0x5f, 0xd8, 0xdf, 0x76, 0x70, 0xbb, 0x01, 0x0b, 0x49, 0x69, 0xe2, 0x05, 0xca, 0xc2, 0xc9, 0xe3,
        0x4b, 0x65, 0x38, 0xb2, 0x87, 0xfc, 0x0e, 0xd3, 0x8b, 0xb0, 0x8a, 0xa1, 0x9b, 0xc7, 0x21, 0xde, 0x7c, 0xf0,
        0xa7, 0x79, 0x20, 0x8d, 0x75, 0xbd, 0xd8, 0xd4, 0x39, 0xae, 0x6d, 0x51, 0xab, 0xff, 0xe1, 0x61, 0x37, 0x50,
        0xd3, 0x7a, 0xdc, 0xa0, 0x2e, 0x35, 0xc8, 0x07, 0xfa, 0xcc, 0x62, 0xc0, 0xe7, 0x7f, 0x42, 0x7f, 0x78, 0xac,
        0xeb, 0x6a, 0xc7, 0xbd, 0x48, 0xc5, 0x20, 0x4e, 0x8b, 0xa2, 0xe5, 0x8b, 0xbd, 0xd7, 0xe0, 0x0a, 0xa3, 0xfc,
        0x42, 0xb8, 0x60, 0x28, 0xa9, 0xca, 0x1d, 0xd7, 0x01, 0x48, 0x58, 0x8d, 0x61, 0xc9, 0x16, 0xd3, 0xf0, 0x75,
        0x48, 0x9d, 0x13, 0x86, 0xfb, 0x20, 0x27, 0x5d, 0xc1, 0x14, 0x6b, 0x89, 0x82, 0x59, 0xe4, 0x7e, 0x81, 0x89,
        0x48, 0x66, 0x21, 0x98, 0xe7, 0xc1, 0x88, 0xa9, 0x40, 0xc4, 0x2d, 0x33, 0x05, 0x67, 0x46, 0x32, 0xe5, 0x0f,
        0x02, 0x40, 0x5d, 0x83, 0x66, 0xf5, 0xad, 0x82, 0xdb, 0xec, 0x70, 0x3e, 0x72, 0xf1, 0x71, 0x77, 0x94, 0x00,
        0xee, 0x51, 0xe9, 0xd0, 0x73, 0xd5, 0x1f, 0xb2, 0x19, 0x71, 0xc1, 0xd0, 0xb2, 0xbf, 0xa0, 0x0f, 0x91, 0xc9,
        0xa4, 0xcc, 0x3e, 0x29, 0x85, 0x45, 0xa3, 0xe7, 0xec, 0x9c, 0x04, 0x41, 0x17, 0x06, 0x54, 0x93, 0xf2, 0xe6,
        0x4e, 0xdf, 0x4e, 0x24, 0x5c, 0x9a, 0xfc, 0xa2, 0x79, 0x9e, 0xc2, 0x67, 0xdb, 0xcb, 0x3f, 0xa4, 0xc6, 0x6f,
        0xde, 0x50, 0xfc, 0xe0, 0xbe, 0x7a, 0x1b, 0x2c, 0xd8, 0x18, 0xe3, 0x36, 0xd5, 0x84, 0x54, 0xe6, 0xc5, 0xe9,
        0x14, 0x45, 0xaa, 0x34, 0x0f, 0xb5, 0xdd, 0x15, 0xb2, 0xe5, 0xa7, 0xdf, 0x87, 0xce, 0x64, 0x91, 0x63, 0x74,
        0x07, 0xb4, 0xf3, 0xff, 0x7b, 0xb4, 0xcb, 0x77, 0xb8, 0x50, 0xab, 0xd2, 0xcc, 0x78, 0x82, 0xd8, 0xb7, 0x9b,
        0x9a, 0xde, 0xa7, 0xb5, 0x0d, 0xd9, 0x7c, 0x62, 0x1c, 0xc0, 0x0f, 0x0a, 0x3c, 0xeb, 0xd2, 0x14, 0x27, 0x8b,
        0xa6, 0xdb, 0x38, 0xa9, 0x3c, 0x67, 0x9a, 0x44, 0x04, 0xbe, 0xb5, 0x35, 0x60, 0xa2, 0xeb, 0xc7, 0x95, 0xf0,
        0x6e, 0xd1, 0xc6, 0x15, 0x51, 0x9b, 0x2a, 0x32, 0x2d, 0x1a, 0x82, 0xf7, 0xc4, 0xcf, 0xb5, 0x3d, 0xa5, 0x17,
        0xd5, 0x51, 0xa1, 0x4e, 0x48, 0x44, 0x52, 0x10, 0x62, 0x4c, 0xc5, 0x30, 0xf1, 0x9d, 0x65, 0x5a, 0xb7, 0x52,
        0x4c, 0x50, 0xc3, 0x71, 0x20, 0xd9, 0x60, 0xd5, 0x6e, 0x40, 0x7b, 0x4f, 0x87, 0x39, 0x0b, 0x59, 0xb2, 0x99,
        0xa6, 0x8c, 0x24, 0x7c, 0x8a, 0x8f, 0x85, 0x9e, 0xef, 0x30, 0x81, 0xf5, 0xb2, 0x59, 0xf6, 0xb6, 0x9e, 0x2d,
        0x8d, 0xf8, 0x50, 0x56, 0x2e, 0x1a, 0x3b, 0x0e, 0x74, 0x05, 0xb3, 0x22, 0xc4, 0xea, 0x1b, 0x5e, 0xe1, 0x19,
        0x3d, 0xbc, 0x3d, 0x56, 0x4f, 0x88, 0x3d, 0x9d, 0xd5, 0xc1, 0x8f, 0x15, 0x22, 0x2c, 0x8f, 0x2f, 0xd5, 0x3a,
        0xf2, 0x93, 0x73, 0x5f, 0x9d, 0x3e, 0x4f, 0xf5, 0xf5, 0x09, 0x53, 0xd0, 0x18, 0xe6, 0xad, 0x16, 0x65, 0x2a,
        0x11, 0x80, 0xe3, 0x3d, 0x73, 0x18, 0x54, 0xfb, 0x59, 0x1b, 0x27, 0x94, 0x94, 0x58, 0x33, 0xcf, 0x3a, 0x0f,
        0x30, 0x6e, 0xbf, 0x2b, 0x8b, 0x9e, 0x53, 0x89, 0x1a, 0x1f, 0xee, 0x1d, 0x32, 0xac, 0x2d, 0x8c, 0xf8, 0x3d,
        0xd0, 0x91, 0x54, 0xd6, 0x85, 0xf7, 0x45, 0xc8, 0x15, 0xe6, 0x27, 0x47, 0x0a, 0xc3, 0x65, 0x96, 0x52, 0xa7,
        0x38, 0xea, 0x56, 0x79, 0xfa, 0x24, 0x72, 0xa1, 0xdd, 0x8a, 0x5b, 0xb4, 0xfc, 0xdf, 0xae, 0x71, 0x14, 0x32,
        0xe9, 0x0a, 0x0c, 0xf1, 0x04, 0x27, 0x73, 0xb4, 0x6f, 0x80, 0x81, 0xc0, 0x84, 0xc1, 0x15, 0xaa, 0xc8, 0xcb,
        0xa1, 0x9f, 0xe4, 0x2e, 0x0d, 0x9b, 0xc4, 0xf8, 0x09, 0x8d, 0xac, 0x7e, 0xf1, 0x4e, 0xb5, 0xb4, 0xb0, 0xcc,
        0x74, 0x7b, 0x36, 0xdd, 0xd6, 0xb5, 0x16, 0xfb, 0x70, 0xac, 0xa5, 0x5d, 0x69, 0x79, 0xdd, 0x7a, 0xc2, 0x5c,
        0x3c, 0x09, 0x5b, 0x64, 0xf1, 0x88, 0xa8, 0xf5, 0x08, 0x23, 0xfb, 0xf7, 0x3a, 0x5a, 0x30, 0xa3, 0xe6, 0x11,
        0xd1, 0x13, 0x60, 0x29, 0x82, 0x96, 0xbd, 0x4d, 0xc8, 0x22, 0x64, 0xfa, 0x6f, 0xce, 0x9a, 0x2c, 0x3b, 0xe1,
        0x4a, 0x50, 0xe5, 0x68, 0x76, 0xfe, 0x7e, 0x0c, 0x79, 0x82, 0x69, 0x75, 0x42, 0x9d, 0x19, 0xc7, 0x4a, 0x79,
        0x31, 0xed, 0x8a, 0x36, 0xe2, 0x7e, 0x03, 0x3c, 0xb4, 0x30, 0xc4, 0x5e, 0xb5, 0x42, 0x4a, 0x6e, 0x50, 0x2b,
        0x63, 0xfd, 0x41, 0xc8, 0x72, 0x78, 0x03, 0xd8, 0x29, 0x07, 0xde, 0x32, 0x6a, 0x3b, 0x1d, 0x3b, 0x81, 0xdd,
        0x34, 0x63, 0xce, 0x6c, 0x97, 0x19, 0x75, 0xb8, 0xac, 0xbf, 0x27, 0x89, 0x73, 0xb3, 0x61, 0xc7, 0xa9, 0x74,
        0xbd, 0x3f, 0x1b, 0x10, 0x0c, 0x6e, 0xf8, 0xdf, 0x55, 0x4f, 0x0f, 0xfa, 0x48, 0x70, 0x51, 0x6f, 0x8e, 0x27,
        0x02, 0x3a, 0xff, 0xb4, 0x94, 0x9e, 0x42, 0x3e, 0x28, 0x5e, 0x1e, 0x97, 0xc4, 0xfe, 0x65, 0x0f, 0xa1, 0x34,
        0xac, 0x1a, 0x22, 0xc0, 0x60, 0xbe, 0x53, 0xfe, 0xf8, 0x03, 0xe9, 0x30, 0x18, 0xae, 0x59, 0x7f, 0x4f, 0xff,
        0xd8, 0x11, 0x2b, 0x16, 0x2d, 0x49, 0xbe, 0x7a, 0xb8, 0x19, 0xeb, 0xea, 0xdf, 0x5c, 0x4b, 0x05, 0xe4, 0xa9,
        0x80, 0x36, 0x76, 0xa1, 0xae, 0x64, 0xe3, 0x81, 0x0c, 0xbc, 0x86, 0xad, 0xa1, 0x93, 0xb7, 0x3e, 0xf6, 0xad,
        0xf5, 0x86, 0x08, 0xdd, 0x3f, 0x53, 0xb7, 0xde, 0xb8, 0xdf, 0x34, 0xa5, 0xc3, 0xe5, 0xad, 0xe6, 0xc0, 0x1a,
        0x0f, 0x19, 0x31, 0xce, 0x56, 0x91, 0x4c, 0x81, 0xf1, 0x31, 0x87, 0xcb, 0x7f, 0x91, 0xfd, 0x59, 0x22, 0xc8,
        0x8b, 0x1c, 0x8b, 0xc1, 0x1d, 0x64, 0x85, 0xa6, 0x81, 0xba, 0x45, 0xe6, 0xef, 0xcc, 0x31, 0x50, 0x91, 0x94,
        0x42, 0xd2, 0xe2, 0x98, 0x44, 0xab, 0x76, 0x65, 0x0d, 0x96, 0x94, 0xee, 0x18, 0x90, 0x68, 0xcf, 0x8f, 0xf5,
        0x0a, 0x59, 0x26, 0xc4, 0x00, 0x93, 0xdc, 0xe6, 0x24, 0x8b, 0x73, 0x41, 0x79, 0x6b, 0xb5, 0x06, 0xeb, 0xf1,
        0xb3, 0x49, 0x96, 0x45, 0xfc, 0x5d, 0xfb, 0x2d, 0x23, 0xd9, 0xef, 0x0b, 0x91, 0x7d, 0xdf, 0x05, 0x31, 0x12,
        0x2b, 0x6e, 0xc5, 0x09, 0x8b, 0x23, 0x30, 0xa4, 0xfb, 0x53, 0x9b, 0x20, 0x43, 0xd2, 0xc4, 0x31, 0xe2, 0xe0,
        0xf6, 0xe9, 0xf6, 0xc3, 0xdd, 0x53, 0x41, 0x88, 0x12, 0x5e, 0xca, 0x30, 0x98, 0x47, 0x98, 0xf0, 0xf5, 0x01,
        0x6b, 0xfa, 0x19, 0xfb, 0xbb, 0x2e, 0x64, 0x9d, 0x97, 0x37, 0xb4, 0x1a, 0xb0, 0x1f, 0x35, 0x04, 0xe3, 0xf8,
        0xdf, 0x56, 0x53, 0x82, 0x39, 0x46, 0xb7, 0xf0, 0x3b, 0x89, 0x03, 0xb7, 0xa9, 0xaf, 0x5b, 0x5b, 0x24, 0xb9,
        0xe1, 0x84, 0x25, 0xde, 0x60, 0xcc, 0x9e, 0x45, 0x26, 0x4e, 0x94, 0x5e, 0x4a, 0x0d, 0x2f, 0xee, 0x93, 0x87,
        0x44, 0x03, 0x33, 0x9e, 0xc3, 0x43, 0x73, 0xea, 0xe6, 0x66, 0x6d, 0xfb, 0x34, 0x9f, 0x76, 0xe7, 0x55, 0x54,
        0x9c, 0xa5, 0x8e, 0x02, 0x3a, 0x63, 0xdf, 0xac, 0xa1, 0x1b, 0x7f, 0xe9, 0xca, 0x86, 0xe7, 0xd2, 0xc1, 0x77,
        0x26, 0x16, 0xd2, 0x2a, 0xcb, 0x49, 0xb5, 0xaf, 0x1f, 0xd2, 0x05, 0x74, 0xbc, 0xa6, 0xa4, 0xe5, 0x2b, 0x37,
        0x23, 0x44, 0x9d, 0x90, 0x31, 0x27, 0x20, 0x4d, 0x01, 0x63, 0xc7, 0xfa, 0x77, 0x3b, 0xf0, 0x16, 0x0d, 0x8d,
        0x19, 0x28, 0x4f, 0x28, 0xf7, 0x9f, 0x94, 0xf9, 0x41, 0xeb, 0x2e, 0xae, 0x0d, 0x1a, 0x41, 0x4f, 0xf3, 0xde,
        0x0f, 0x79, 0xcd, 0x3e, 0x19, 0xe3, 0x0b, 0x92, 0xfd, 0xcd, 0xb0, 0x19, 0xf8, 0xab, 0x78, 0x42, 0x10, 0x75,
        0xa2, 0xd4, 0x61, 0x43, 0x62, 0xa1, 0x4c, 0x8a, 0x2f, 0xf5, 0x6a, 0xae, 0x36, 0x8f, 0x56, 0x23, 0x26, 0x3f,
        0x16, 0x2c, 0x09, 0x91, 0x6e, 0x8f, 0x63, 0x23, 0x41, 0xd6, 0x0c, 0xc9, 0xa2, 0x80, 0xd3, 0x44, 0x9f, 0x89,
        0x73, 0x4f, 0x3b, 0x52, 0x6b, 0xa0, 0x7b, 0x4c, 0x35, 0xfa, 0x72, 0x2a, 0x37, 0x6d, 0x53, 0x70, 0xaf, 0x77,
        0xe0, 0x9f, 0x0a, 0x97, 0x4d, 0xf1, 0x58, 0xad, 0x01, 0xd1, 0x47, 0xc2, 0x01, 0xd8, 0xbf, 0xde, 0x20, 0x7d,
        0xab, 0x3f, 0x79, 0x86, 0xb5, 0x3e, 0xe4, 0x32, 0xfa, 0x52, 0xf2, 0xa6, 0x29, 0x17, 0xec, 0x3f, 0xf5, 0x3a,
        0x2b, 0x70, 0x12, 0x4e, 0xb0, 0x95, 0x6c, 0x82, 0xb1, 0xeb, 0x19, 0x85, 0x72, 0x5f, 0xd9, 0xbc, 0x8d, 0x38,
        0xe2, 0x44, 0x26, 0x56, 0x3e, 0x27, 0x8d, 0x8d, 0xc4, 0x86, 0x85, 0x6c, 0xfa, 0x0e, 0x86, 0x18, 0x7a, 0xcc,
        0x02, 0x77, 0x3a, 0x4a, 0x12, 0x87, 0x23, 0xe9, 0xc4, 0x53, 0xc9, 0x42, 0xec, 0xaf, 0x6a, 0x08
};

#endif

#if defined(__PV_LANGUAGE_GERMAN__)

// Wake-word = hey computer
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x13, 0x7c, 0x17, 0x90, 0xfe, 0x0c, 0xde, 0xcc, 0xd9, 0x35, 0xf0, 0xfb, 0x70, 0x70, 0xc3, 0xe0, 0x47, 0xfc,
        0xe1, 0xa4, 0x02, 0x0d, 0xdc, 0x45, 0x07, 0x75, 0x67, 0xbe, 0x7c, 0x7e, 0x1a, 0x12, 0xd2, 0xce, 0x30, 0x34,
        0x7c, 0x06, 0x58, 0x68, 0x62, 0x55, 0xbc, 0xb2, 0xae, 0xa8, 0x69, 0xcb, 0x22, 0x45, 0x5d, 0x80, 0x72, 0xa1,
        0x87, 0x68, 0xcc, 0x95, 0xb6, 0xbe, 0x9a, 0x7d, 0x6b, 0x9c, 0x55, 0x68, 0x04, 0x20, 0x4c, 0x38, 0xb1, 0x65,
        0xb1, 0xd9, 0xd8, 0x60, 0x46, 0xdc, 0x19, 0x06, 0xd4, 0xb2, 0x67, 0xbc, 0xbc, 0x7f, 0x20, 0x4d, 0xcf, 0xdb,
        0x10, 0xae, 0x25, 0x72, 0xec, 0x4b, 0x2f, 0xce, 0xd5, 0x59, 0xcd, 0x2e, 0xe6, 0x0f, 0xad, 0x56, 0xb5, 0x62,
        0x02, 0x62, 0x15, 0x0c, 0xf8, 0x6f, 0x0e, 0xed, 0x61, 0x2e, 0x7c, 0x30, 0xf4, 0x67, 0x99, 0xf2, 0x81, 0x52,
        0x19, 0x6c, 0xa5, 0xc3, 0x49, 0x0d, 0x01, 0x0d, 0xe4, 0x1c, 0x54, 0x0e, 0xd6, 0x8a, 0x89, 0xff, 0x22, 0xf1,
        0xda, 0x7a, 0x10, 0x74, 0x7a, 0xb2, 0x02, 0x1b, 0x98, 0xa9, 0x93, 0x96, 0x3b, 0xec, 0x32, 0xe3, 0x85, 0x34,
        0x16, 0xe8, 0x95, 0xe5, 0x33, 0x04, 0x7d, 0x7f, 0xcd, 0xc6, 0xe9, 0xdb, 0xa2, 0xcc, 0xa9, 0xd0, 0xe7, 0x86,
        0xa4, 0x2d, 0x42, 0x9e, 0x65, 0x6b, 0xc1, 0xaf, 0x8a, 0x68, 0x12, 0x35, 0x39, 0xb6, 0xea, 0xd4, 0xb7, 0x8d,
        0x26, 0xe2, 0x6a, 0x7a, 0x51, 0x3f, 0x3e, 0x15, 0xe8, 0x72, 0x91, 0x3a, 0x39, 0x00, 0xb5, 0xf1, 0xf3, 0x5d,
        0xe1, 0xd9, 0xd4, 0x09, 0xbf, 0x9c, 0xef, 0x25, 0xd5, 0x92, 0xe7, 0xd9, 0x0d, 0x4f, 0x89, 0x3c, 0x51, 0x5c,
        0x2a, 0xa0, 0xd3, 0x75, 0x40, 0x95, 0x85, 0xfb, 0x61, 0x8b, 0xb4, 0xc0, 0x5c, 0xaa, 0x14, 0x74, 0x55, 0xa7,
        0xf5, 0xd8, 0xa2, 0x72, 0x6f, 0x14, 0x53, 0xf5, 0xaf, 0x8a, 0xa8, 0xae, 0xd2, 0x77, 0xfb, 0x91, 0x57, 0x3a,
        0xe9, 0x48, 0x8a, 0x42, 0x82, 0xfa, 0x49, 0x3f, 0x43, 0x55, 0x99, 0x32, 0x2a, 0x4c, 0xf8, 0x02, 0xea, 0x2b,
        0xfc, 0xc9, 0x56, 0x64, 0x31, 0x1f, 0xf5, 0xc3, 0x5e, 0xe5, 0x88, 0x7d, 0x77, 0x06, 0xa3, 0x9c, 0x39, 0xa9,
        0x9c, 0xf4, 0x35, 0x67, 0xb8, 0x93, 0x61, 0xa2, 0xec, 0x53, 0xb7, 0x37, 0x45, 0xff, 0xf0, 0xe7, 0xc8, 0xef,
        0x1d, 0x58, 0x96, 0xc8, 0xa1, 0x0f, 0x74, 0xf1, 0xb4, 0x86, 0xd6, 0xe3, 0x4a, 0x08, 0xf4, 0x86, 0x31, 0xed,
        0xdf, 0xa7, 0x99, 0x73, 0x0d, 0xec, 0x3c, 0x11, 0xfd, 0x6d, 0x32, 0x7c, 0x69, 0x0a, 0xd9, 0xb3, 0x65, 0xcb,
        0xd2, 0x87, 0xc8, 0xf8, 0x83, 0x25, 0xb3, 0xed, 0xd6, 0x63, 0xf1, 0x87, 0xfe, 0x06, 0xf0, 0x14, 0xcc, 0x87,
        0x68, 0xd7, 0xbd, 0xdf, 0x81, 0x89, 0xc9, 0x7b, 0x21, 0xf0, 0x90, 0x87, 0xe3, 0x2c, 0x72, 0xb0, 0x07, 0x47,
        0xab, 0xc9, 0xa3, 0xb8, 0x5d, 0xbe, 0x96, 0x66, 0x83, 0xf6, 0xc1, 0x8e, 0x60, 0x11, 0x7e, 0x76, 0x9c, 0xa0,
        0x28, 0x2e, 0xd7, 0x0e, 0x63, 0x46, 0x54, 0x4f, 0xde, 0xad, 0x27, 0x7a, 0xd8, 0xf0, 0xc8, 0xb5, 0x97, 0xf9,
        0x39, 0x57, 0x46, 0x0f, 0xbf, 0xdb, 0xc2, 0xe1, 0xa3, 0x40, 0xad, 0xfe, 0xff, 0x30, 0x2b, 0xd0, 0x09, 0xdd,
        0x13, 0xa6, 0x03, 0x83, 0xae, 0x65, 0x69, 0x6f, 0x4f, 0xb6, 0x68, 0xaa, 0xfc, 0x32, 0xc6, 0xff, 0x0a, 0xb5,
        0xe0, 0x03, 0x77, 0x7d, 0x63, 0x35, 0xdd, 0xcd, 0x61, 0x08, 0x68, 0xb3, 0x80, 0x79, 0x5d, 0x2b, 0x1c, 0x87,
        0x4c, 0xe7, 0x85, 0x90, 0x0e, 0x55, 0x81, 0xd6, 0x23, 0x4e, 0x75, 0x63, 0xb5, 0x48, 0x5a, 0x90, 0x27, 0xc5,
        0x1f, 0xc4, 0x71, 0x08, 0x10, 0x44, 0xbc, 0xe2, 0x9d, 0xad, 0x62, 0xd2, 0x22, 0x23, 0x28, 0x35, 0x84, 0x92,
        0x51, 0xa2, 0x21, 0x7c, 0xe2, 0x43, 0xb4, 0xc7, 0x1b, 0x4e, 0x23, 0x14, 0x40, 0xf5, 0xec, 0x11, 0x87, 0x9f,
        0x9a, 0x60, 0x55, 0xbf, 0xb0, 0x38, 0xef, 0xd6, 0x41, 0x09, 0x8d, 0xaa, 0x6b, 0xcc, 0x2a, 0x12
};

#endif

#if defined(__PV_LANGUAGE_SPANISH__)

// Wake-word = hola computadora
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0x39, 0xdf, 0xe0, 0x14, 0x43, 0xd6, 0xf2, 0xcb, 0xdd, 0xc9, 0x5a, 0xb5, 0xa5, 0x4f, 0xe3, 0x48, 0x53, 0x3a,
        0x4c, 0x29, 0xb3, 0x25, 0x39, 0x71, 0x0c, 0xe9, 0xa1, 0x6a, 0xce, 0x35, 0x1a, 0x37, 0x40, 0x47, 0x48, 0x23,
        0x42, 0xa6, 0x06, 0x92, 0x10, 0x0b, 0x5b, 0xf2, 0xf8, 0x82, 0xd4, 0x2d, 0x55, 0x8a, 0x02, 0x35, 0x24, 0x58,
        0xed, 0x57, 0xed, 0xda, 0x59, 0xaf, 0x8a, 0x76, 0x5f, 0x4f, 0x1c, 0xda, 0x1a, 0xb5, 0x60, 0x12, 0x03, 0x14,
        0xa5, 0xd5, 0xe2, 0x8a, 0x95, 0x9d, 0x50, 0x2e, 0xa1, 0x3f, 0xbb, 0x41, 0xf1, 0xdf, 0x19, 0x44, 0x4c, 0x59,
        0x3b, 0x7b, 0xe2, 0x08, 0x64, 0xa9, 0xd5, 0x68, 0xd9, 0x0a, 0x41, 0x17, 0xbc, 0x1b, 0xa4, 0xa0, 0xf9, 0x4e,
        0x20, 0x15, 0x11, 0xa2, 0x44, 0xe2, 0x17, 0xf2, 0xb1, 0xf4, 0x1c, 0xd8, 0xea, 0xc1, 0x7e, 0xc3, 0x6e, 0x80,
        0x42, 0x3c, 0x98, 0x6b, 0xfb, 0x6f, 0xcc, 0x51, 0x11, 0x4e, 0xd9, 0x40, 0x17, 0xdd, 0xef, 0xf3, 0x0b, 0x67,
        0xd6, 0xdb, 0x4e, 0x59, 0x72, 0xbe, 0x9b, 0xec, 0x78, 0x71, 0x2f, 0x58, 0x66, 0x1a, 0xa8, 0x56, 0x43, 0x04,
        0xe2, 0x48, 0xd2, 0x58, 0x55, 0x25, 0x65, 0xce, 0xd2, 0xeb, 0x32, 0x64, 0xc4, 0x17, 0x8c, 0x1b, 0xd1, 0x28,
        0x4b, 0xdc, 0x3d, 0x1b, 0xb2, 0xfc, 0xa1, 0x2a, 0xbd, 0x1e, 0xaa, 0x4f, 0x7d, 0x65, 0xf3, 0x69, 0xcf, 0xd9,
        0x8c, 0x8a, 0x30, 0x7e, 0x8e, 0x4a, 0x76, 0x72, 0xd6, 0xc0, 0x92, 0xb5, 0xfa, 0x80, 0xc2, 0xee, 0x79, 0xa8,
        0xf0, 0x86, 0xd0, 0x1f, 0x45, 0x01, 0xd3, 0x35, 0xf2, 0x63, 0x38, 0xc1, 0x81, 0x01, 0x56, 0x91, 0xb1, 0x5a,
        0x15, 0xc2, 0x2c, 0x86, 0xe1, 0x61, 0x2b, 0x30, 0x6c, 0xe0, 0xd8, 0x70, 0x58, 0x06, 0x9f, 0xc0, 0x1e, 0x8d,
        0xc0, 0xbf, 0x15, 0x51, 0x16, 0xd2, 0xc2, 0x1b, 0x3a, 0x81, 0xf7, 0x0b, 0xbf, 0x75, 0xf6, 0xab, 0x11, 0x77,
        0x6d, 0x65, 0x5c, 0xaa, 0x94, 0x72, 0x70, 0x2c, 0x24, 0xfc, 0xa1, 0xa3, 0x11, 0x47, 0x93, 0x4e, 0x54, 0xf8,
        0x08, 0x55, 0x66, 0xaa, 0x01, 0xc9, 0x91, 0xfe, 0xda, 0xbe, 0x89, 0xe1, 0xe3, 0xcd, 0x43, 0xb7, 0xca, 0x41,
        0x24, 0x6f, 0x9c, 0x27, 0x18, 0xe1, 0xd9, 0x86, 0xc4, 0xb6, 0xdb, 0xc8, 0x10, 0xf0, 0x6a, 0x52, 0x71, 0xf4,
        0x72, 0xeb, 0x03, 0x53, 0xe2, 0xe3, 0xc0, 0x7b, 0xbb, 0x92, 0xb9, 0xa0, 0xdb, 0xf6, 0x53, 0x31, 0x85, 0xfd,
        0xc3, 0xaf, 0x5f, 0x7d, 0x9a, 0xd6, 0xad, 0x11, 0xbc, 0x97, 0xcf, 0x48, 0x3c, 0x66, 0xd8, 0xf0, 0xce, 0x53,
        0x96, 0xa6, 0x22, 0x9c, 0x77, 0x01, 0x01, 0xd4, 0xfb, 0xd8, 0x9c, 0x3a, 0x2e, 0x1e, 0x9b, 0x61, 0x44, 0x9d,
        0xa1, 0x92, 0x5d, 0xd7, 0x97, 0x9d, 0xa5, 0x62, 0x13, 0xcd, 0x19, 0x9d, 0xbf, 0x55, 0x69, 0x26, 0xcb, 0x2c,
        0xe3, 0x12, 0x11, 0x7e, 0x98, 0xfd, 0x01, 0x9e, 0x87, 0x16, 0x7b, 0x82, 0x11, 0xb2, 0x4d, 0xcd, 0x90, 0xdd,
        0xad, 0x24, 0xd3, 0xcb, 0x58, 0xe6, 0xf5, 0x6f, 0x3f, 0xff, 0x38, 0xb3, 0xaa, 0x06, 0xf1, 0x1c, 0xed, 0x27,
        0x13, 0x81, 0x78, 0x23, 0x8a, 0x68, 0xdc, 0xba, 0xed, 0x81, 0x61, 0x5f, 0xd5, 0xa8, 0xb9, 0x79, 0x0e, 0x27,
        0xab, 0x85, 0xe9, 0x49, 0xe3, 0x1f, 0xf2, 0xa1, 0xe3, 0xb8, 0x78, 0x97, 0x71, 0x7f, 0xcc, 0x71, 0xe4, 0x65,
        0xd5, 0x9b, 0xe8, 0xdf, 0xad, 0xf9, 0x70, 0x52, 0x4b, 0xd3, 0xe0, 0xd2, 0x65, 0xd4, 0x95, 0x1a, 0x11, 0x69,
        0x62, 0x9f, 0x04, 0x36, 0x10, 0xd9, 0x0e, 0xec, 0xce, 0x2d, 0x51, 0x0f, 0xb3, 0x12, 0x31, 0x0c, 0x4e, 0x12,
        0x2a, 0x3b, 0xf6, 0xaa, 0xa7, 0x2b, 0x79, 0x97, 0x7b, 0x01, 0x58, 0xf6, 0x14, 0x7f, 0xd1, 0xe9, 0x03, 0x0c,
        0xd5, 0x51, 0x8f, 0xce, 0xcf, 0xbd, 0x27, 0x6b, 0x0b, 0xd8, 0x23, 0x62, 0x9c, 0x62, 0x2b, 0xcd, 0xef, 0x98,
        0xbb, 0xc1, 0x1a, 0xb2, 0x22, 0x52, 0x67, 0xd9, 0x68, 0x36, 0xc0, 0xf4, 0xd6, 0xa5, 0xfe, 0x1f, 0x33, 0x99,
        0x0e, 0xad, 0x7f, 0x0e, 0xf7, 0x56, 0x40, 0x8f, 0x5b, 0x08, 0xa1, 0x38, 0x26, 0xb3, 0xef, 0x10, 0x9c, 0x18,
        0x37, 0xe6, 0x4f, 0xc8, 0xb3, 0x0b, 0x9f, 0x7d, 0x8d, 0x49, 0xd4, 0x3c, 0x56, 0xf9, 0xff, 0x51, 0xaf, 0xad,
        0x4c, 0x25, 0x61, 0x87, 0xd1, 0x3f, 0xb7, 0x55, 0x10, 0x22, 0xb5, 0xcd, 0x82, 0xee, 0x83, 0xe9, 0x60, 0x19,
        0x32, 0xea, 0x33, 0x33, 0x2d, 0xa0, 0x59, 0x92, 0xde, 0x45, 0xab, 0xe4, 0x53, 0xe1, 0x46, 0xd5, 0x7b, 0x18,
        0xaf, 0xf9, 0xa2, 0x29, 0xef, 0x13, 0x33, 0xc6, 0x28, 0xe5, 0xd5, 0x6c, 0xed, 0x7e, 0x36, 0xc5, 0xc6, 0x92,
        0xcc, 0xd1, 0xb1, 0x35, 0xd8, 0x52, 0x49, 0xad
};

#endif

#if defined(__PV_LANGUAGE_FRENCH__)

// Wake-word = salut ordinateur
static const uint8_t DEFAULT_KEYWORD_ARRAY[] __attribute__ ((aligned (16))) = {
        0xf5, 0x96, 0xc5, 0xf9, 0x3d, 0x2d, 0x22, 0x2c, 0x3a, 0x50, 0xba, 0x14, 0x53, 0x03, 0xcf, 0x09, 0x55, 0x4d,
        0x67, 0x3b, 0x41, 0x09, 0x64, 0xa6, 0xc2, 0x72, 0x6c, 0x33, 0x32, 0xe9, 0x92, 0xd8, 0x01, 0xaa, 0x8e, 0x6d,
        0xed, 0x25, 0xe8, 0xfa, 0xe2, 0x04, 0xb4, 0x09, 0x17, 0x7d, 0x9a, 0x16, 0xca, 0xdf, 0x7b, 0xf7, 0x55, 0x13,
        0x6a, 0xf7, 0x59, 0x25, 0x1a, 0x7a, 0x4e, 0x1f, 0xcd, 0x3d, 0xa2, 0xc3, 0x7d, 0xaa, 0x6d, 0x37, 0x29, 0xe0,
        0xf0, 0xdd, 0xf9, 0x4f, 0xa8, 0x91, 0x86, 0xc5, 0x7b, 0xc9, 0xeb, 0xd8, 0x9d, 0xa6, 0xd7, 0x9d, 0xc2, 0xe2,
        0x4c, 0xe5, 0x62, 0x50, 0xbd, 0x23, 0xd3, 0x49, 0x5c, 0xc3, 0xa3, 0x38, 0x42, 0x22, 0xbd, 0x04, 0xa0, 0xd7,
        0xb2, 0x21, 0x09, 0x53, 0xd9, 0x75, 0xb9, 0x5a, 0xf5, 0xbd, 0x45, 0xd0, 0xf8, 0x0e, 0xdf, 0xbc, 0x47, 0xae,
        0x1d, 0x79, 0xd9, 0xa3, 0xca, 0x57, 0xb8, 0xd6, 0xd2, 0xc7, 0xb4, 0x91, 0x7e, 0xdc, 0x5b, 0x2e, 0x94, 0x00,
        0xf3, 0xb8, 0x1c, 0xbf, 0xc2, 0x55, 0xf0, 0x63, 0xd4, 0x88, 0x39, 0x7b, 0x14, 0x9d, 0xd7, 0x17, 0xa6, 0xc1,
        0xc9, 0x4b, 0x9c, 0x72, 0xb1, 0xa1, 0x34, 0x8c, 0x0d, 0xe4, 0x2a, 0x0f, 0xb1, 0x21, 0xcc, 0xcd, 0x76, 0x60,
        0xe1, 0xb8, 0x52, 0xb1, 0x8f, 0xe9, 0x72, 0xe1, 0x99, 0xc1, 0x0a, 0xe0, 0xe0, 0xe8, 0x2c, 0xe3, 0x1e, 0xd8,
        0x28, 0xc6, 0xd9, 0x1a, 0x12, 0xf5, 0x21, 0x9b, 0x14, 0xf3, 0x26, 0xae, 0x92, 0x5e, 0xd5, 0xa4, 0x18, 0x17,
        0x70, 0x08, 0xb5, 0x0d, 0x97, 0xa4, 0x61, 0x0f, 0xf0, 0x5e, 0x2d, 0xd1, 0x83, 0x16, 0x49, 0x2b, 0x45, 0x22,
        0x94, 0x9e, 0x10, 0xdd, 0xfb, 0xe5, 0xe0, 0x2b, 0x3d, 0x58, 0xe5, 0x87, 0x67, 0x37, 0xfd, 0xe3, 0xca, 0x74,
        0x91, 0x31, 0xeb, 0x06, 0xc1, 0xc2, 0xfc, 0x24, 0x25, 0xbe, 0x01, 0x44, 0x14, 0xe5, 0x16, 0xa7, 0x12, 0x6f,
        0x12, 0x71, 0xf3, 0x6a, 0x8f, 0x1f, 0x7f, 0xe9, 0x58, 0xb5, 0x72, 0xbb, 0xca, 0xd1, 0xbf, 0x0a, 0x19, 0xc0,
        0xfe, 0x63, 0x55, 0xa7, 0x92, 0x2e, 0x1d, 0xc7, 0xcb, 0xa9, 0x51, 0x85, 0xad, 0x49, 0x82, 0xa0, 0x05, 0x37,
        0xb0, 0xe0, 0xc6, 0x58, 0x4b, 0x54, 0xdb, 0x70, 0x24, 0xf7, 0xed, 0xaf, 0x4a, 0x1e, 0x22, 0x49, 0x8c, 0x99,
        0x1e, 0xa5, 0x22, 0x12, 0x77, 0x51, 0xc1, 0x8c, 0x50, 0x21, 0x3d, 0xf7, 0x56, 0x36, 0x90, 0x8b, 0xa9, 0x7d,
        0x9e, 0x11, 0xb0, 0xd8, 0x78, 0x7c, 0x77, 0x15, 0x65, 0x5e, 0x3c, 0x47, 0xe4, 0xad, 0xab, 0x5e, 0xd4, 0xe0,
        0xd5, 0xbc, 0x82, 0x54, 0x70, 0xc1, 0xe4, 0x12, 0x07, 0xc7, 0xdf, 0xba, 0xaf, 0x8f, 0xcd, 0x46, 0x84, 0x10,
        0x52, 0x09, 0xd4, 0x0c, 0x0d, 0xfe, 0x90, 0x26, 0x1b, 0xf2, 0x03, 0x24, 0x6a, 0x4b, 0xa3, 0xb2, 0x83, 0x94,
        0x34, 0x52, 0x4d, 0x7c, 0x88, 0x0d, 0x2b, 0x9f, 0x4b, 0x53, 0x80, 0x07, 0x87, 0x29, 0xff, 0x76, 0xac, 0xdd,
        0x9c, 0xaf, 0x41, 0x67, 0x0d, 0xd7, 0x5f, 0x65, 0xde, 0x06, 0x33, 0xf8, 0x06, 0x2c, 0x27, 0x4d, 0xb9, 0x11,
        0xeb, 0xa9, 0xf6, 0xa6, 0x32, 0xc7, 0xd6, 0x0a, 0xfb, 0x4f, 0xd8, 0x21, 0x1b, 0x49, 0x4e, 0x80, 0xb2, 0x4c,
        0x08, 0x76, 0x87, 0x84, 0x3e, 0xca, 0x6b, 0xb5, 0x3b, 0xe9, 0xb3, 0x1d, 0x4d, 0x02, 0x7e, 0xbe, 0xef, 0xa4,
        0x99, 0x1e, 0xa8, 0x62, 0xae, 0x3a, 0x9b, 0x74, 0xb4, 0x55, 0xce, 0xb5, 0x18, 0x11, 0x33, 0xb3, 0x86, 0x1a,
        0xea, 0xcf, 0x47, 0x14, 0x47, 0xb9, 0xd7, 0x9e, 0xc1, 0xaf, 0xe3, 0xd8, 0xe6, 0x58, 0x2d, 0xa2, 0x2e, 0xac,
        0xd4, 0x62, 0xdb, 0xc8, 0x60, 0x8c, 0x46, 0x83, 0xb3, 0x27, 0x8d, 0xbf, 0x4d, 0x5b, 0xa6, 0xf0, 0xe7, 0x50,
        0x37, 0x66, 0x3c, 0x84, 0x82, 0x5c, 0xe3, 0x4d, 0xda, 0xcb, 0xb8, 0x65, 0x8d, 0xe8, 0x14, 0x24, 0xfd, 0x78,
        0x54, 0xc1, 0xa1, 0x98, 0x66, 0x4f, 0x2b, 0x5d, 0x76, 0x0f, 0xda, 0x05, 0x2d, 0xf8, 0xf8, 0x58, 0xc6, 0xbc,
        0x9a, 0xdb, 0xe1, 0xb9, 0x15, 0xe0, 0x48, 0x20, 0x7c, 0xf8, 0x98, 0xf2, 0xf1, 0x3a, 0x5c, 0x3e, 0xfa, 0xe1,
        0x01, 0x22, 0xc2, 0x71, 0x7e, 0x69, 0xde, 0x1b, 0x62, 0x96, 0x8f, 0x7f, 0x60, 0xe1, 0x93, 0x97, 0x19, 0xd6,
        0x84, 0x03, 0x5e, 0x5b, 0xa7, 0x2a, 0x51, 0x63, 0xa2, 0x3e, 0x76, 0xbb, 0x34, 0xad, 0xea, 0x2f, 0x18, 0xb4,
        0xb4, 0x4f, 0x79, 0x50, 0xb0, 0xa8, 0x84, 0x3d, 0xf4, 0xfb, 0x0b, 0x9d, 0x6a, 0x82, 0xf1, 0x44, 0x39, 0xac,
        0xfd, 0xa5, 0x09, 0xc6, 0x37, 0x07
};

#endif


#endif // PV_PARAMS

