# Porcupine NodeJS Demos

This package provides two demonstration command-line applications for Porcupine: a file based demo, which scans a compatible WAV file for keywords, and a microphone demo, which listens for keywords and outputs detections live.

## Introduction to Porcupine

Porcupine is a highly accurate and lightweight wake word engine. It enables building always-listening voice-enabled applications using cutting edge voice AI.

Porcupine is:

- private and offline
- [accurate](https://github.com/Picovoice/wake-word-benchmark)
- [resource efficient](https://www.youtube.com/watch?v=T0tAnh8tUQg) (runs even on microcontrollers)
- data efficient (wake words can be easily generated by simply typing them, without needing thousands of hours of bespoke audio training data and manual effort)
- scalable to many simultaneous wake-words / always-on voice commands
- cross-platform

To learn more about Porcupine, see the [product](https://picovoice.ai/products/porcupine/), [documentation](https://picovoice.ai/docs/), and [GitHub](https://github.com/Picovoice/porcupine/) pages.

## Compatibility

These demos run Porcupine on **NodeJS 12+** on the following platforms:

- Windows (x86_64)
- Linux (x86_64)
- macOS (x86_64, arm64)
- Raspberry Pi (2,3,4)
- NVIDIA Jetson (Nano)
- BeagleBone

### Web Browsers

These demos and the bindings upon which they are built are for NodeJS and **do not work in a browser**. Looking to run Porcupine in-browser? See the [@picovoice/porcupine-web-en-worker](https://www.npmjs.com/package/@picovoice/porcupine-web-en-worker) package.

## AccessKey

Porcupine requires a valid `AccessKey` at initialization. `AccessKey`s act as your credentials when using Porcupine SDKs.
You can create your `AccessKey` for free. Make sure to keep your `AccessKey` secret.

To obtain your `AccessKey`:
1. Login or Signup for a free account on the [Picovoice Console](https://picovoice.ai/console/).
2. Once logged in, go to the [`AccessKey` tab](https://console.picovoice.ai/access_key) to create one or use an existing `AccessKey`.

### Microphone demo

The microphone demo allows you monitor microphone input for keywords using Porcupine. 

## Install NPM package

To install the demos and make them available on the command line, use either of the following `yarn` or `npm` commands:

```console
yarn global add @picovoice/porcupine-node-demo
```

(or)

```console
npm install -g @picovoice/porcupine-node-demo
```

### Run the mic demo

Use `ppn-mic-demo` to run the mic demo. First select an input audio device to start recording audio:

```console
ppn-mic-demo --show_audio_devices
```

This command prints a list of the available devices and its inputs:

```console
index: 0, device name: USB Audio Device
index: 1, device name: MacBook Air Microphone
```

Specify the input audio device with `--audio_device_index` and either built-in 
keywords with `--keywords` or paths to Porcupine `.ppn` files with `--keyword_file_paths`.
Provide your Picovoice AccessKey with `--access_key`.

Here is an example using Audio Device Index which will listen for "grapefruit" keyword:

```console
ppn-mic-demo \
--access_key ${ACCESS_KEY} \
--keywords grapefruit \
--audio_device_index 0
```

Wake word detections will display in the console:

```console
$ ppn-mic-demo --access_key ${ACCESS_KEY} --keywords grapefruit
Using device: USB Audio Device
Listening for wake word(s): grapefruit
Press ctrl+c to exit.

...

Detected 'grapefruit'
```

### Run the file demo

The file-based demo allows you to scan a compatible wave file for keywords using Porcupine. Note: **The demo requires 16KHz, 16-bit linear PCM, single-channel (mono) WAV files**.

To run the file-based demo,

e.g. check the input wave file for the built-in keywords "grasshopper" and "bumblebee" against the audio sample that is included with the porcupine repository:

```console
ppn-file-demo \
--access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keywords grasshopper,bumblebee
```

Detections of each keyword will be output in the terminal, along with their time location in the file:

```console
ppn-file-demo \
--access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keywords grasshopper
Detected keyword 'bumblebee' @ 16.096s
Detected keyword 'grasshopper' @ 28.896s
```

## Common Demo Options

The microphone and file demos both have additional options.

To see the full set of options, use `--help`:

```console
ppn-mic-demo --help
```

```console
ppn-file-demo --help
```

```console
Usage: ppn-file-demo [options]

Options:
  -i, --input_audio_file_path <string>  input audio wave file in 16-bit 16KHz linear PCM format (mono)
  -a, --access_key <string>             AccessKey obtain from the Picovoice Console (https://console.picovoice.ai/)
  -k, --keyword_file_paths <string>     absolute path(s) to porcupine keyword files (.ppn)
  -b, --keywords <string>               built in keyword(s)
                                        (americano,blueberry,bumblebee,grapefruit,grasshopper,picovoice,porcupine,terminator)
  -l, --library_file_path <string>      absolute path to porcupine dynamic library
  -m, --model_file_path <string>        absolute path to porcupine model
  -s, --sensitivity <number>            sensitivity value between 0 and 1 (default: 0.5)
  -h, --help                            display help for command
```

### Sensitivity

The sensitivity is a floating point value in the range [0,1] which specifies the tradeoff between miss rate and false alarm. The demo defaults to 0.5. You can override this with `--sensitivity`:

```console
ppn-mic-demo \
--access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keywords bumblebee \
--sensitivity 0.65
```

### Custom keyword (ppn) files

Porcupine includes several built-in keywords, which are stored as `.ppn` files. To train custom PPN files, see the [Picovoice Console](https://picovoice.ai/console/).

Unlike the built-in keywords, custom PPN files generated with the Picovoice Console carry restrictions including (but not limited to): training allowance, time limits, available platforms, and commercial usage.

#### Providing custom ppn files

You can specify non-builtin keywords as absolute paths to `.ppn` keyword files, using `--keyword_file_paths`. The PPN keyword files must be compatible with the platform you are running.

e.g. for Linux (x86_64), using two keywords: "bumblebee" and "grasshopper":

```console
ppn-file-demo \
--access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keyword_file_paths ../../resources/keyword_files/linux/grasshopper_linux.ppn,../../resources/keyword_files/linux/bumblebee_linux.ppn
```

### Custom library and model files

You may override the porcupine model and dynamic libraries by specifying their absolute paths with `--model_file_path` and `--library_file_path`, respectively. As with keyword files, the dynamic library is specific to the platform.

e.g. for macOS (x86_64):

```console
ppn-file-demo \
--access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keywords terminator \
--library_file_path ../../lib/mac/x86_64/libpv_porcupine.dylib \
--model_file_path ../../lib/common/porcupine_params.pv
```

## Running the demos from the GitHub repository

Use one of `yarn` or `npm` to install the package dependencies from the demo/nodejs folder:

```console
cd demo/nodejs
yarn
```

(or)

```console
cd demo/nodejs
npm install
```

### Microphone demo

Use `yarn mic` (or `npm run mic`) to run the mic demo from the demos/nodejs directory. For `npm run`, note the extra `--` needed before specifying commands. This is to disambiguate whether the options are intended for npm or for the demo script.

```console
yarn mic --access_key ${ACCESS_KEY} --keywords grapefruit
```

(or)

```console
npm run mic -- --access_key ${ACCESS_KEY} --keywords grapefruit
```

### File demo

Use `yarn file` or `npm run file` from the `demos/nodejs` directory. For `npm run`, note the extra `--` needed before specifying commands. This is to disambiguate whether the options are intended for npm or for the demo script.

```console
yarn file --access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keywords grasshopper
```

(or)

```console
npm run file -- --access_key ${ACCESS_KEY} \
--input_audio_file_path ../../resources/audio_samples/multiple_keywords.wav \
--keywords grasshopper
```
