# Visual Studio 2019 Build of QuanergyClient

## Prerequisites
These instructions were tested for the following configuration. Please install prerequisites as needed.

* Windows 10 64-bit - version 1703 or higher (recommend updating to the latest)
* Visual Studio 2019 - Tested with latest Community Edition version (16.5.4) available at the time of writing [here](https://visualstudio.microsoft.com/thank-you-downloading-visual-studio/?sku=Community&rel=16). During install, select "Desktop Development with C++"
* PowerShell - all command line commands expect PowerShell.
* Git - Tested with latest version (2.27.0) available at the time of writing [here](https://git-scm.com/download/win).
* CMake - Tested with latest version (3.17.2) available at the time of writing [here](https://github.com/Kitware/CMake/releases/download/v3.17.2/cmake-3.17.2-win64-x64.msi). During install, select "Add CMake to the system path for all users."

## Clone the SDK repository.
```
mkdir C:\QuanergySystems\
cd C:\QuanergySystems\
git clone https://github.com/QuanergySystems/quanergy_client.git
```

## Install vcpkg
Install [Microsoft vcpkg package manager](https://docs.microsoft.com/en-us/cpp/build/vcpkg). We will be using the April 2020 release.
```
cd C:\QuanergySystems\
git clone --branch 2020.04 https://github.com/Microsoft/vcpkg.git
cd vcpkg
.\bootstrap-vcpkg.bat
.\vcpkg integrate install
```
## Install Dependencies and Prepare Solution
Install [PCL](https://pointclouds.org/) and other dependencies from vcpkg. This builds from source, brings in all dependencies, and builds release and debug versions. As such, it can take quite a while (several hours) and may use a significant amount of space (up to 30 GB). We use the `--clean-after-build` flag to reduce the long term space requirements. You may omit this if space is not a concern. We also offer instructions to [install only release dependencies](#install-only-release-dependencies) as an optional way to reduce both build time and space requirements.

To install both release and debug libraries of dependencies:
```
.\vcpkg install pcl:x64-windows boost-program-options:x64-windows boost-accumulators:x64-windows
```

Use CMake to configure Visual Studio 2019 Solution
```
cd C:\QuanergySystems\quanergy_client
mkdir build
cd build
cmake .. -DCMAKE_TOOLCHAIN_FILE="C:\QuanergySystems\vcpkg\scripts\buildsystems\vcpkg.cmake"
```

### Troubleshooting
* If you are using Cylance SmartProtect AntiVirus, you may get a build failure of VTK due to a Debug DLL being quarantined. To build only release libraries, follow the instructions to [install only release dependencies](#install-only-release-dependencies).

## Install Only Release Dependendencies
Skip these instructions if you have successfully built all dependencies with the preceding instructions. These instructions constrain the dependency build to release only. This is done by creating a custom vcpkg triplet that specifies release only. Additionally, a patch is applied to fix a couple of bugs in the release-only build instructions. The `--clean-after-build` flag is used to reduce the long term space requirements. You may omit this if space is not a concern.
```
cd C:\QuanergySystems\vcpkg
cp .\triplets\x64-windows.cmake .\triplets\x64-windows-release.cmake
Add-Content .\triplets\x64-windows-release.cmake "set(VCPKG_BUILD_TYPE release)"
git apply C:\QuanergySystems\quanergy_client\readme\vcpkg.patch
.\vcpkg install pcl:x64-windows-release boost-program-options:x64-windows-release boost-accumulators:x64-windows-release --clean-after-build
```
Use CMake to configure Visual Studio 2019 Solution
```
cd "C:\QuanergySystems\quanergy_client"
mkdir build
cd build
cmake .. -DVCPKG_TARGET_TRIPLET=x64-windows-release -DCMAKE_TOOLCHAIN_FILE="C:\QuanergySystems\vcpkg\scripts\buildsystems\vcpkg.cmake"
```

## SDK Build Instructions

Build quanergy_client code and visualizer application in Visual Studio 2019.

* Open QuanergyClient.sln in C:\QuanergySystems\quanergy_client\build\
* Verify "Release" is selected as the Solution Configuration.
* Right-click on ALL_BUILD in the Solution Explorer and select "Build".

## Test build
```
cd C:\QuanergySystems\quanergy_client\build\
.\Release\visualizer.exe --help
.\Release\visualizer.exe --host <IP Address of Sensor>
```

Cloud Viewer window should appear. When sensor is up to speed, use mouse to manipulate the view of point cloud.

**NOTE:** The point cloud may not appear until the mouse is used to move the view.
