
#include <unistd.h>
#include <string>

#include <rokubimini/Reading.hpp>

#include <rokubimini_manager/Manager.hpp>

using namespace rokubimini;

int main(int argc, char** argv)
{
  constexpr static unsigned int WAIT_MICRO_SECONDS = 5000;
  const bool is_standalone = false;
  const bool install_signal_handler = false;

  std::string setup_file;
  if (argc == 2)
  {
    setup_file = argv[1];
  }
  else
  {
    ROS_WARN_STREAM("No config file specified");
    ROS_ERROR_STREAM(
        "Correct usage 'rosrun rokubimini_ethercat rokubimini_ethercat_ethercat_example path_to_setup_file'");
  }

  RokubiminiManager rokubimini_manager(is_standalone, install_signal_handler);
  rokubimini_manager.loadSetup(setup_file);
  rokubimini_manager.startup();

  auto rokubiminis = rokubimini_manager.getRokubiminis();

  rokubimini::Reading reading;

  while (true)
  {
    rokubimini_manager.update();
    usleep(WAIT_MICRO_SECONDS);
  }

  rokubimini_manager.shutdown();
  return 0;
}