/*
 * Copyright (c) 2011, Dorian Scholz, TU Darmstadt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the TU Darmstadt nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef rqt_rviz__RViz_H
#define rqt_rviz__RViz_H

#include <rqt_gui_cpp/plugin.h>
#include <rviz/visualization_frame.h>
#include <OGRE/OgreLog.h>

#include <QDockWidget>
#include <QMenuBar>

namespace rqt_rviz {

class RViz
  : public rqt_gui_cpp::Plugin
{

  Q_OBJECT

public:

  RViz();

  ~RViz();

  virtual void initPlugin(qt_gui_cpp::PluginContext& context);

  virtual void saveSettings(qt_gui_cpp::Settings& plugin_settings, qt_gui_cpp::Settings& instance_settings) const;

  virtual void restoreSettings(const qt_gui_cpp::Settings& plugin_settings, const qt_gui_cpp::Settings& instance_settings);

  bool hasConfiguration() const;

  void triggerConfiguration();

  virtual bool eventFilter(QObject* watched, QEvent* event);

protected Q_SLOTS:
  void onDisplayConfigChanged(const QString& fullpath);

protected:
  void parseArguments();

  qt_gui_cpp::PluginContext* context_;

  rviz::VisualizationFrame* widget_;

  Ogre::Log* log_;

  bool hide_menu_;
  std::string display_config_;
  bool ogre_log_;

  /** @brief Pointer to menu bar. */
  QMenuBar* menu_bar_;
};

}

#endif // rqt_rviz__RViz_H
