// clang-format off

/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x1000004a generated on 2019-04-02 01:57:40.892043
/// Generated using solver transform6d
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#include <tesseract_common/macros.h>
TESSERACT_COMMON_IGNORE_WARNINGS_PUSH
#ifndef IKFAST_HAS_LIBRARY
#define IKFAST_HAS_LIBRARY
#define IKFAST_NO_MAIN
#endif
#include <tesseract_kinematics/ikfast/external/ikfast.h>  // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION == 61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b)                                                                                               \
  {                                                                                                                    \
    if (!(b))                                                                                                          \
    {                                                                                                                  \
      std::stringstream ss;                                                                                            \
      ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " << __PRETTY_FUNCTION__ << ": Assertion '"      \
         << #b << "' failed";                                                                                          \
      throw std::runtime_error(ss.str());                                                                              \
    }                                                                                                                  \
  }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI ((IkReal)6.28318530717959)
#define IKPI ((IkReal)3.14159265358979)
#define IKPI_2 ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif  // _MSC_VER

// lapack routines
extern "C" {
void dgetrf_(const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
void zgetrf_(const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
void dgesv_(const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
void dgetrs_(const char* trans,
             const int* n,
             const int* nrhs,
             double* a,
             const int* lda,
             int* ipiv,
             double* b,
             const int* ldb,
             int* info);
void dgeev_(const char* jobvl,
            const char* jobvr,
            const int* n,
            double* a,
            const int* lda,
            double* wr,
            double* wi,
            double* vl,
            const int* ldvl,
            double* vr,
            const int* ldvr,
            double* work,
            const int* lwork,
            int* info);
}

using namespace std;  // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE
{
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f * f; }
inline double IKsqr(double f) { return f * f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and
// evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they
// can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif

inline float IKasin(float f)
{
  IKFAST_ASSERT(f > -1 - IKFAST_SINCOS_THRESH && f < 1 + IKFAST_SINCOS_THRESH);  // any more error implies something is
                                                                                 // wrong with the solver
  if (f <= -1)
    return float(-IKPI_2);
  else if (f >= 1)
    return float(IKPI_2);
  return asinf(f);
}
inline double IKasin(double f)
{
  IKFAST_ASSERT(f > -1 - IKFAST_SINCOS_THRESH && f < 1 + IKFAST_SINCOS_THRESH);  // any more error implies something is
                                                                                 // wrong with the solver
  if (f <= -1)
    return -IKPI_2;
  else if (f >= 1)
    return IKPI_2;
  return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
  while (x < 0)
  {
    x += y;
  }
  return fmodf(x, y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
  while (x < 0)
  {
    x += y;
  }
  return fmod(x, y);
}

inline float IKacos(float f)
{
  IKFAST_ASSERT(f > -1 - IKFAST_SINCOS_THRESH && f < 1 + IKFAST_SINCOS_THRESH);  // any more error implies something is
                                                                                 // wrong with the solver
  if (f <= -1)
    return float(IKPI);
  else if (f >= 1)
    return float(0);
  return acosf(f);
}
inline double IKacos(double f)
{
  IKFAST_ASSERT(f > -1 - IKFAST_SINCOS_THRESH && f < 1 + IKFAST_SINCOS_THRESH);  // any more error implies something is
                                                                                 // wrong with the solver
  if (f <= -1)
    return IKPI;
  else if (f >= 1)
    return 0;
  return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f)
{
  if (f <= 0.0f)
    return 0.0f;
  return sqrtf(f);
}
inline double IKsqrt(double f)
{
  if (f <= 0.0)
    return 0.0;
  return sqrt(f);
}
inline float IKatan2Simple(float fy, float fx) { return atan2f(fy, fx); }
inline float IKatan2(float fy, float fx)
{
  if (isnan(fy))
  {
    IKFAST_ASSERT(!isnan(fx));  // if both are nan, probably wrong value will be returned
    return float(IKPI_2);
  }
  else if (isnan(fx))
  {
    return 0;
  }
  return atan2f(fy, fx);
}
inline double IKatan2Simple(double fy, double fx) { return atan2(fy, fx); }
inline double IKatan2(double fy, double fx)
{
  if (isnan(fy))
  {
    IKFAST_ASSERT(!isnan(fx));  // if both are nan, probably wrong value will be returned
    return IKPI_2;
  }
  else if (isnan(fx))
  {
    return 0;
  }
  return atan2(fy, fx);
}

template <typename T>
struct CheckValue
{
  T value;
  bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
  CheckValue<T> ret;
  ret.valid = false;
  ret.value = 0;
  if (!isnan(fy) && !isnan(fx))
  {
    if (IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH)
    {
      ret.value = IKatan2Simple(fy, fx);
      ret.valid = true;
    }
  }
  return ret;
}

inline float IKsign(float f)
{
  if (f > 0)
  {
    return float(1);
  }
  else if (f < 0)
  {
    return float(-1);
  }
  return 0;
}

inline double IKsign(double f)
{
  if (f > 0)
  {
    return 1.0;
  }
  else if (f < 0)
  {
    return -1.0;
  }
  return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
  CheckValue<T> ret;
  ret.valid = true;
  if (n == 0)
  {
    ret.value = 1.0;
    return ret;
  }
  else if (n == 1)
  {
    ret.value = f;
    return ret;
  }
  else if (n < 0)
  {
    if (f == 0)
    {
      ret.valid = false;
      ret.value = (T)1.0e30;
      return ret;
    }
    if (n == -1)
    {
      ret.value = T(1.0) / f;
      return ret;
    }
  }

  int num = n > 0 ? n : -n;
  if (num == 2)
  {
    ret.value = f * f;
  }
  else if (num == 3)
  {
    ret.value = f * f * f;
  }
  else
  {
    ret.value = 1.0;
    while (num > 0)
    {
      if (num & 1)
      {
        ret.value *= f;
      }
      num >>= 1;
      f *= f;
    }
  }

  if (n < 0)
  {
    ret.value = T(1.0) / ret.value;
  }
  return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot)
{
  IkReal x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, x21, x22, x23,
      x24, x25, x26, x27, x28, x29, x30, x31, x32, x33, x34, x35, x36, x37, x38, x39, x40, x41, x42, x43, x44, x45, x46,
      x47, x48, x49, x50, x51, x52, x53, x54, x55, x56, x57, x58, x59, x60, x61, x62, x63, x64, x65, x66, x67, x68;
  x0 = IKcos(j[0]);
  x1 = IKcos(j[1]);
  x2 = IKcos(j[2]);
  x3 = IKsin(j[0]);
  x4 = IKsin(j[2]);
  x5 = IKcos(j[3]);
  x6 = IKsin(j[1]);
  x7 = IKsin(j[3]);
  x8 = IKcos(j[4]);
  x9 = IKsin(j[4]);
  x10 = IKcos(j[6]);
  x11 = IKsin(j[6]);
  x12 = IKsin(j[5]);
  x13 = IKcos(j[5]);
  x14 = ((0.4) * x3);
  x15 = ((0.15085) * x5);
  x16 = ((1.0) * x5);
  x17 = ((1.0) * x8);
  x18 = ((1.0) * x7);
  x19 = ((1.0) * x4);
  x20 = ((1.0) * x13);
  x21 = ((1.0) * x1);
  x22 = ((0.15085) * x7);
  x23 = ((0.15085) * x8);
  x24 = ((0.4) * x5);
  x25 = ((0.4) * x2);
  x26 = ((1.0) * x9);
  x27 = ((0.15085) * x9);
  x28 = (x0 * x6);
  x29 = (x0 * x4);
  x30 = ((-1.0) * x9);
  x31 = (x5 * x6);
  x32 = (x6 * x9);
  x33 = (x2 * x3);
  x34 = ((-1.0) * x8);
  x35 = (x6 * x7);
  x36 = (x1 * x2);
  x37 = (x0 * x2);
  x38 = (x2 * x6);
  x39 = (x3 * x6);
  x40 = (x19 * x3);
  x41 = (x16 * x38);
  x42 = (x19 * x32);
  x43 = ((((-1.0) * x40)) + ((x0 * x36)));
  x44 = (x29 + ((x1 * x33)));
  x45 = (((x1 * x5)) + ((x2 * x35)));
  x46 = (x40 + (((-1.0) * x21 * x37)));
  x47 = ((((-1.0) * x37)) + ((x1 * x40)));
  x48 = ((((-1.0) * x1 * x18)) + x41);
  x49 = (((x0 * x1 * x19)) + (((1.0) * x33)));
  x50 = ((((-1.0) * x0 * x19)) + (((-1.0) * x21 * x33)));
  x51 = (x12 * x45);
  x52 = (x43 * x5);
  x53 = (x48 * x8);
  x54 = (x47 * x9);
  x55 = (x49 * x9);
  x56 = (x50 * x7);
  x57 = (x52 + ((x28 * x7)));
  x58 = (((x3 * x35)) + ((x44 * x5)));
  x59 = (((x46 * x7)) + ((x28 * x5)));
  x60 = ((((-1.0) * x42)) + x53);
  x61 = (((x26 * (((((-1.0) * x1 * x7)) + x41)))) + ((x17 * x4 * x6)));
  x62 = ((((-1.0) * x18 * x28)) + (((-1.0) * x16 * x43)));
  x63 = (((x3 * x31)) + x56);
  x64 = ((((-1.0) * x18 * x39)) + (((-1.0) * x16 * x44)));
  x65 = (x12 * x59);
  x66 = (x62 * x8);
  x67 = (x12 * x63);
  x68 = (x54 + ((x64 * x8)));
  eerot[0] =
      ((((-1.0) * x10 *
         (((((1.0) * x65)) + (((1.0) * x13 * ((((x8 * (((((-1.0) * x28 * x7)) + (((-1.0) * x52)))))) + x55)))))))) +
       ((x11 * (((((-1.0) * x17 * x49)) + (((-1.0) * x26 * x57)))))));
  eerot[1] = (((x11 * ((((x13 * ((x55 + x66)))) + x65)))) + ((x10 * ((((x34 * x49)) + ((x30 * x57)))))));
  eerot[2] = (((x13 * x59)) + ((x12 * (((((-1.0) * x17 * x62)) + (((-1.0) * x26 * x49)))))));
  eetrans[0] = (((x7 * (((((-1.0) * x0 * x1 * x25)) + ((x14 * x4)))))) + ((x13 * ((((x22 * x46)) + ((x15 * x28)))))) +
                (((0.4) * x28)) + ((x12 * (((((-1.0) * x27 * x49)) + (((-1.0) * x23 * x62)))))) + ((x24 * x28)));
  eerot[3] = (((x10 * (((((-1.0) * x20 * x68)) + (((-1.0) * x67)))))) + ((x11 * ((((x34 * x47)) + ((x30 * x58)))))));
  eerot[4] = (((x10 * (((((-1.0) * x17 * x47)) + (((-1.0) * x26 * x58)))))) + ((x11 * ((((x13 * x68)) + x67)))));
  eerot[5] = (((x13 * x63)) + ((x12 * (((((-1.0) * x17 * x64)) + (((-1.0) * x26 * x47)))))));
  eetrans[1] = (((x13 * ((((x15 * x39)) + ((x22 * x50)))))) + ((x7 * (((((-1.0) * x14 * x36)) + (((-0.4) * x29)))))) +
                ((x14 * x6)) + ((x14 * x31)) + ((x12 * (((((-1.0) * x27 * x47)) + (((-1.0) * x23 * x64)))))));
  eerot[6] = (((x11 * x61)) + ((x10 * (((((-1.0) * x20 * x60)) + (((-1.0) * x51)))))));
  eerot[7] = (((x11 * ((((x13 * x60)) + x51)))) + ((x10 * x61)));
  eerot[8] = (((x12 * (((((-1.0) * x17 * x48)) + x42)))) + ((x13 * x45)));
  eetrans[2] = ((0.34) + ((x1 * x24)) + (((0.4) * x1)) + ((x12 * ((((x27 * x4 * x6)) + (((-1.0) * x23 * x48)))))) +
                ((x13 * ((((x1 * x15)) + ((x22 * x38)))))) + ((x25 * x35)));
}

IKFAST_API int GetNumFreeParameters() { return 1; }
IKFAST_API int* GetFreeParameters()
{
  static int freeparams[] = { 4 };
  return freeparams;
}
IKFAST_API int GetNumJoints() { return 7; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver
{
public:
  IkReal j0, cj0, sj0, htj0, j0mul, j1, cj1, sj1, htj1, j1mul, j2, cj2, sj2, htj2, j2mul, j3, cj3, sj3, htj3, j3mul, j5,
      cj5, sj5, htj5, j5mul, j6, cj6, sj6, htj6, j6mul, j4, cj4, sj4, htj4, new_r00, r00, rxp0_0, new_r01, r01, rxp0_1,
      new_r02, r02, rxp0_2, new_r10, r10, rxp1_0, new_r11, r11, rxp1_1, new_r12, r12, rxp1_2, new_r20, r20, rxp2_0,
      new_r21, r21, rxp2_1, new_r22, r22, rxp2_2, new_px, px, npx, new_py, py, npy, new_pz, pz, npz, pp;
  unsigned char _ij0[2], _nj0, _ij1[2], _nj1, _ij2[2], _nj2, _ij3[2], _nj3, _ij5[2], _nj5, _ij6[2], _nj6, _ij4[2], _nj4;

  IkReal j100, cj100, sj100;
  unsigned char _ij100[2], _nj100;
  bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions)
  {
    j0 = numeric_limits<IkReal>::quiet_NaN();
    _ij0[0] = -1;
    _ij0[1] = -1;
    _nj0 = -1;
    j1 = numeric_limits<IkReal>::quiet_NaN();
    _ij1[0] = -1;
    _ij1[1] = -1;
    _nj1 = -1;
    j2 = numeric_limits<IkReal>::quiet_NaN();
    _ij2[0] = -1;
    _ij2[1] = -1;
    _nj2 = -1;
    j3 = numeric_limits<IkReal>::quiet_NaN();
    _ij3[0] = -1;
    _ij3[1] = -1;
    _nj3 = -1;
    j5 = numeric_limits<IkReal>::quiet_NaN();
    _ij5[0] = -1;
    _ij5[1] = -1;
    _nj5 = -1;
    j6 = numeric_limits<IkReal>::quiet_NaN();
    _ij6[0] = -1;
    _ij6[1] = -1;
    _nj6 = -1;
    _ij4[0] = -1;
    _ij4[1] = -1;
    _nj4 = 0;
    for (int dummyiter = 0; dummyiter < 1; ++dummyiter)
    {
      solutions.Clear();
      j4 = pfree[0];
      cj4 = cos(pfree[0]);
      sj4 = sin(pfree[0]), htj4 = tan(pfree[0] * 0.5);
      r00 = eerot[0 * 3 + 0];
      r01 = eerot[0 * 3 + 1];
      r02 = eerot[0 * 3 + 2];
      r10 = eerot[1 * 3 + 0];
      r11 = eerot[1 * 3 + 1];
      r12 = eerot[1 * 3 + 2];
      r20 = eerot[2 * 3 + 0];
      r21 = eerot[2 * 3 + 1];
      r22 = eerot[2 * 3 + 2];
      px = eetrans[0];
      py = eetrans[1];
      pz = eetrans[2];

      new_r00 = ((-1.0) * r00);
      new_r01 = ((-1.0) * r01);
      new_r02 = r02;
      new_px = (px + (((-0.15085) * r02)));
      new_r10 = ((-1.0) * r10);
      new_r11 = ((-1.0) * r11);
      new_r12 = r12;
      new_py = (py + (((-0.15085) * r12)));
      new_r20 = ((-1.0) * r20);
      new_r21 = ((-1.0) * r21);
      new_r22 = r22;
      new_pz = ((-0.34) + pz + (((-0.15085) * r22)));
      r00 = new_r00;
      r01 = new_r01;
      r02 = new_r02;
      r10 = new_r10;
      r11 = new_r11;
      r12 = new_r12;
      r20 = new_r20;
      r21 = new_r21;
      r22 = new_r22;
      px = new_px;
      py = new_py;
      pz = new_pz;
      IkReal x69 = ((1.0) * px);
      IkReal x70 = ((1.0) * pz);
      IkReal x71 = ((1.0) * py);
      pp = ((px * px) + (py * py) + (pz * pz));
      npx = (((px * r00)) + ((py * r10)) + ((pz * r20)));
      npy = (((px * r01)) + ((py * r11)) + ((pz * r21)));
      npz = (((px * r02)) + ((py * r12)) + ((pz * r22)));
      rxp0_0 = ((((-1.0) * r20 * x71)) + ((pz * r10)));
      rxp0_1 = (((px * r20)) + (((-1.0) * r00 * x70)));
      rxp0_2 = ((((-1.0) * r10 * x69)) + ((py * r00)));
      rxp1_0 = ((((-1.0) * r21 * x71)) + ((pz * r11)));
      rxp1_1 = (((px * r21)) + (((-1.0) * r01 * x70)));
      rxp1_2 = ((((-1.0) * r11 * x69)) + ((py * r01)));
      rxp2_0 = ((((-1.0) * r22 * x71)) + ((pz * r12)));
      rxp2_1 = (((px * r22)) + (((-1.0) * r02 * x70)));
      rxp2_2 = ((((-1.0) * r12 * x69)) + ((py * r02)));
      {
        IkReal j3array[2], cj3array[2], sj3array[2];
        bool j3valid[2] = { false };
        _nj3 = 2;
        cj3array[0] = ((-1.0) + (((3.125) * pp)));
        if (cj3array[0] >= -1 - IKFAST_SINCOS_THRESH && cj3array[0] <= 1 + IKFAST_SINCOS_THRESH)
        {
          j3valid[0] = j3valid[1] = true;
          j3array[0] = IKacos(cj3array[0]);
          sj3array[0] = IKsin(j3array[0]);
          cj3array[1] = cj3array[0];
          j3array[1] = -j3array[0];
          sj3array[1] = -sj3array[0];
        }
        else if (isnan(cj3array[0]))
        {
          // probably any value will work
          j3valid[0] = true;
          cj3array[0] = 1;
          sj3array[0] = 0;
          j3array[0] = 0;
        }
        for (int ij3 = 0; ij3 < 2; ++ij3)
        {
          if (!j3valid[ij3])
          {
            continue;
          }
          _ij3[0] = ij3;
          _ij3[1] = -1;
          for (int iij3 = ij3 + 1; iij3 < 2; ++iij3)
          {
            if (j3valid[iij3] && IKabs(cj3array[ij3] - cj3array[iij3]) < IKFAST_SOLUTION_THRESH &&
                IKabs(sj3array[ij3] - sj3array[iij3]) < IKFAST_SOLUTION_THRESH)
            {
              j3valid[iij3] = false;
              _ij3[1] = iij3;
              break;
            }
          }
          j3 = j3array[ij3];
          cj3 = cj3array[ij3];
          sj3 = sj3array[ij3];

          {
            IkReal j6eval[2];
            j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
            j6eval[1] = ((npx * npx) + (npy * npy));
            if (IKabs(j6eval[0]) < 0.0000010000000000 || IKabs(j6eval[1]) < 0.0000010000000000)
            {
              {
                IkReal j5eval[2];
                j5eval[0] = ((1.0) + (cj3 * cj3) + (((2.0) * cj3)) + (((cj4 * cj4) * (sj3 * sj3))));
                j5eval[1] = ((((2.5) * (IKabs(((0.4) + (((0.4) * cj3))))))) + (IKabs((cj4 * sj3))));
                if (IKabs(j5eval[0]) < 0.0000010000000000 || IKabs(j5eval[1]) < 0.0000010000000000)
                {
                  {
                    IkReal evalcond[2];
                    bool bgotonextstatement = true;
                    do
                    {
                      evalcond[0] =
                          ((-3.14159265358979) +
                           (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j3)))), 6.28318530717959)));
                      evalcond[1] = pp;
                      if (IKabs(evalcond[0]) < 0.0000050000000000 && IKabs(evalcond[1]) < 0.0000050000000000)
                      {
                        bgotonextstatement = false;
                        {
                          IkReal j6eval[1];
                          sj3 = 0;
                          cj3 = -1.0;
                          j3 = 3.14159265358979;
                          j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                          if (IKabs(j6eval[0]) < 0.0000010000000000)
                          {
                            continue;  // no branches [j5, j6]
                          }
                          else
                          {
                            {
                              IkReal j6array[2], cj6array[2], sj6array[2];
                              bool j6valid[2] = { false };
                              _nj6 = 2;
                              CheckValue<IkReal> x73 =
                                  IKatan2WithCheck(IkReal(((-1.0) * npx)), IkReal(npy), IKFAST_ATAN2_MAGTHRESH);
                              if (!x73.valid)
                              {
                                continue;
                              }
                              IkReal x72 = x73.value;
                              j6array[0] = ((-1.0) * x72);
                              sj6array[0] = IKsin(j6array[0]);
                              cj6array[0] = IKcos(j6array[0]);
                              j6array[1] = ((3.14159265358979) + (((-1.0) * x72)));
                              sj6array[1] = IKsin(j6array[1]);
                              cj6array[1] = IKcos(j6array[1]);
                              if (j6array[0] > IKPI)
                              {
                                j6array[0] -= IK2PI;
                              }
                              else if (j6array[0] < -IKPI)
                              {
                                j6array[0] += IK2PI;
                              }
                              j6valid[0] = true;
                              if (j6array[1] > IKPI)
                              {
                                j6array[1] -= IK2PI;
                              }
                              else if (j6array[1] < -IKPI)
                              {
                                j6array[1] += IK2PI;
                              }
                              j6valid[1] = true;
                              for (int ij6 = 0; ij6 < 2; ++ij6)
                              {
                                if (!j6valid[ij6])
                                {
                                  continue;
                                }
                                _ij6[0] = ij6;
                                _ij6[1] = -1;
                                for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                {
                                  if (j6valid[iij6] && IKabs(cj6array[ij6] - cj6array[iij6]) < IKFAST_SOLUTION_THRESH &&
                                      IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                                  {
                                    j6valid[iij6] = false;
                                    _ij6[1] = iij6;
                                    break;
                                  }
                                }
                                j6 = j6array[ij6];
                                cj6 = cj6array[ij6];
                                sj6 = sj6array[ij6];
                                {
                                  IkReal evalcond[1];
                                  evalcond[0] = ((((-1.0) * npy * (IKcos(j6)))) + (((-1.0) * npx * (IKsin(j6)))));
                                  if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                  {
                                    continue;
                                  }
                                }

                                {
                                  IkReal j5eval[1];
                                  sj3 = 0;
                                  cj3 = -1.0;
                                  j3 = 3.14159265358979;
                                  j5eval[0] = IKabs((((cj6 * npx)) + (((-1.0) * npy * sj6))));
                                  if (IKabs(j5eval[0]) < 0.0000000100000000)
                                  {
                                    continue;  // no branches [j5]
                                  }
                                  else
                                  {
                                    IkReal op[2 + 1], zeror[2];
                                    int numroots;
                                    IkReal x74 = (npy * sj6);
                                    IkReal x75 = (cj6 * npx);
                                    op[0] = (x75 + (((-1.0) * x74)));
                                    op[1] = 0;
                                    op[2] = (x74 + (((-1.0) * x75)));
                                    polyroots2(op, zeror, numroots);
                                    IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
                                    int numsolutions = 0;
                                    for (int ij5 = 0; ij5 < numroots; ++ij5)
                                    {
                                      IkReal htj5 = zeror[ij5];
                                      tempj5array[0] = ((2.0) * (atan(htj5)));
                                      for (int kj5 = 0; kj5 < 1; ++kj5)
                                      {
                                        j5array[numsolutions] = tempj5array[kj5];
                                        if (j5array[numsolutions] > IKPI)
                                        {
                                          j5array[numsolutions] -= IK2PI;
                                        }
                                        else if (j5array[numsolutions] < -IKPI)
                                        {
                                          j5array[numsolutions] += IK2PI;
                                        }
                                        sj5array[numsolutions] = IKsin(j5array[numsolutions]);
                                        cj5array[numsolutions] = IKcos(j5array[numsolutions]);
                                        numsolutions++;
                                      }
                                    }
                                    bool j5valid[2] = { true, true };
                                    _nj5 = 2;
                                    for (int ij5 = 0; ij5 < numsolutions; ++ij5)
                                    {
                                      if (!j5valid[ij5])
                                      {
                                        continue;
                                      }
                                      j5 = j5array[ij5];
                                      cj5 = cj5array[ij5];
                                      sj5 = sj5array[ij5];
                                      htj5 = IKtan(j5 / 2);

                                      _ij5[0] = ij5;
                                      _ij5[1] = -1;
                                      for (int iij5 = ij5 + 1; iij5 < numsolutions; ++iij5)
                                      {
                                        if (j5valid[iij5] &&
                                            IKabs(cj5array[ij5] - cj5array[iij5]) < IKFAST_SOLUTION_THRESH &&
                                            IKabs(sj5array[ij5] - sj5array[iij5]) < IKFAST_SOLUTION_THRESH)
                                        {
                                          j5valid[iij5] = false;
                                          _ij5[1] = iij5;
                                          break;
                                        }
                                      }
                                      rotationfunction0(solutions);
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    } while (0);
                    if (bgotonextstatement)
                    {
                      bool bgotonextstatement = true;
                      do
                      {
                        if (1)
                        {
                          bgotonextstatement = false;
                          continue;  // branch miss [j5, j6]
                        }
                      } while (0);
                      if (bgotonextstatement)
                      {
                      }
                    }
                  }
                }
                else
                {
                  {
                    IkReal j5array[2], cj5array[2], sj5array[2];
                    bool j5valid[2] = { false };
                    _nj5 = 2;
                    IkReal x1007 = ((0.4) + (((0.4) * cj3)));
                    CheckValue<IkReal> x1010 =
                        IKatan2WithCheck(IkReal(x1007), IkReal(((0.4) * cj4 * sj3)), IKFAST_ATAN2_MAGTHRESH);
                    if (!x1010.valid)
                    {
                      continue;
                    }
                    IkReal x1008 = ((1.0) * (x1010.value));
                    if ((((((0.16) * (cj4 * cj4) * (sj3 * sj3))) + (x1007 * x1007))) < -0.00001)
                      continue;
                    CheckValue<IkReal> x1011 = IKPowWithIntegerCheck(
                        IKabs(IKsqrt(((((0.16) * (cj4 * cj4) * (sj3 * sj3))) + (x1007 * x1007)))), -1);
                    if (!x1011.valid)
                    {
                      continue;
                    }
                    if (((npz * (x1011.value))) < -1 - IKFAST_SINCOS_THRESH ||
                        ((npz * (x1011.value))) > 1 + IKFAST_SINCOS_THRESH)
                      continue;
                    IkReal x1009 = IKasin((npz * (x1011.value)));
                    j5array[0] = (x1009 + (((-1.0) * x1008)));
                    sj5array[0] = IKsin(j5array[0]);
                    cj5array[0] = IKcos(j5array[0]);
                    j5array[1] = ((3.14159265358979) + (((-1.0) * x1009)) + (((-1.0) * x1008)));
                    sj5array[1] = IKsin(j5array[1]);
                    cj5array[1] = IKcos(j5array[1]);
                    if (j5array[0] > IKPI)
                    {
                      j5array[0] -= IK2PI;
                    }
                    else if (j5array[0] < -IKPI)
                    {
                      j5array[0] += IK2PI;
                    }
                    j5valid[0] = true;
                    if (j5array[1] > IKPI)
                    {
                      j5array[1] -= IK2PI;
                    }
                    else if (j5array[1] < -IKPI)
                    {
                      j5array[1] += IK2PI;
                    }
                    j5valid[1] = true;
                    for (int ij5 = 0; ij5 < 2; ++ij5)
                    {
                      if (!j5valid[ij5])
                      {
                        continue;
                      }
                      _ij5[0] = ij5;
                      _ij5[1] = -1;
                      for (int iij5 = ij5 + 1; iij5 < 2; ++iij5)
                      {
                        if (j5valid[iij5] && IKabs(cj5array[ij5] - cj5array[iij5]) < IKFAST_SOLUTION_THRESH &&
                            IKabs(sj5array[ij5] - sj5array[iij5]) < IKFAST_SOLUTION_THRESH)
                        {
                          j5valid[iij5] = false;
                          _ij5[1] = iij5;
                          break;
                        }
                      }
                      j5 = j5array[ij5];
                      cj5 = cj5array[ij5];
                      sj5 = sj5array[ij5];

                      {
                        IkReal j6eval[3];
                        IkReal x1012 = npy * npy;
                        IkReal x1013 = npx * npx;
                        IkReal x1014 = (cj5 * sj4);
                        IkReal x1015 = (cj5 * x1013);
                        IkReal x1016 = (cj5 * x1012);
                        IkReal x1017 = ((5.0) * npz * sj5);
                        IkReal x1018 = ((2.0) * npy * sj3);
                        IkReal x1019 = ((2.0) * npx * sj3);
                        j6eval[0] = (x1015 + x1016);
                        j6eval[1] = ((IKabs((((x1014 * x1019)) + ((cj4 * x1018)) + (((-1.0) * npy * x1017))))) +
                                     (IKabs((((x1014 * x1018)) + (((-1.0) * cj4 * x1019)) + ((npx * x1017))))));
                        j6eval[2] = IKsign(((((5.0) * x1016)) + (((5.0) * x1015))));
                        if (IKabs(j6eval[0]) < 0.0000010000000000 || IKabs(j6eval[1]) < 0.0000010000000000 ||
                            IKabs(j6eval[2]) < 0.0000010000000000)
                        {
                          {
                            IkReal j6eval[3];
                            IkReal x1020 = npy * npy;
                            IkReal x1021 = npx * npx;
                            IkReal x1022 = ((2.0) * cj3);
                            IkReal x1023 = ((5.0) * sj5);
                            IkReal x1024 = ((2.0) * npx);
                            IkReal x1025 = ((2.0) * npy);
                            IkReal x1026 = ((5.0) * cj5 * npz);
                            IkReal x1027 = (sj3 * sj4 * sj5);
                            j6eval[0] = (((sj5 * x1021)) + ((sj5 * x1020)));
                            j6eval[1] = IKsign((((x1021 * x1023)) + ((x1020 * x1023))));
                            j6eval[2] =
                                ((IKabs((x1024 + ((npx * x1022)) + (((-1.0) * npx * x1026)) + ((x1025 * x1027))))) +
                                 (IKabs((((npy * x1026)) + (((-1.0) * x1025)) + (((-1.0) * npy * x1022)) +
                                         ((x1024 * x1027))))));
                            if (IKabs(j6eval[0]) < 0.0000010000000000 || IKabs(j6eval[1]) < 0.0000010000000000 ||
                                IKabs(j6eval[2]) < 0.0000010000000000)
                            {
                              {
                                IkReal j6eval[3];
                                IkReal x1028 = npx * npx;
                                IkReal x1029 = npy * npy;
                                IkReal x1030 = ((2.0) * sj5);
                                IkReal x1031 = ((2.0) * sj3);
                                IkReal x1032 = (cj4 * cj5);
                                j6eval[0] = (x1029 + x1028);
                                j6eval[1] = ((IKabs(((((-1.0) * npx * x1031 * x1032)) + ((npy * sj4 * x1031)) +
                                                     ((npx * x1030)) + ((cj3 * npx * x1030))))) +
                                             (IKabs((((npx * sj4 * x1031)) + ((npy * x1031 * x1032)) +
                                                     (((-1.0) * cj3 * npy * x1030)) + (((-1.0) * npy * x1030))))));
                                j6eval[2] = IKsign(((((5.0) * x1028)) + (((5.0) * x1029))));
                                if (IKabs(j6eval[0]) < 0.0000010000000000 || IKabs(j6eval[1]) < 0.0000010000000000 ||
                                    IKabs(j6eval[2]) < 0.0000010000000000)
                                {
                                  {
                                    IkReal evalcond[2];
                                    bool bgotonextstatement = true;
                                    do
                                    {
                                      evalcond[0] = ((-3.14159265358979) +
                                                     (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j3)))),
                                                             6.28318530717959)));
                                      evalcond[1] = pp;
                                      if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                          IKabs(evalcond[1]) < 0.0000050000000000)
                                      {
                                        bgotonextstatement = false;
                                        {
                                          IkReal j6eval[1];
                                          sj3 = 0;
                                          cj3 = -1.0;
                                          j3 = 3.14159265358979;
                                          j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                          if (IKabs(j6eval[0]) < 0.0000010000000000)
                                          {
                                            {
                                              IkReal j6eval[1];
                                              sj3 = 0;
                                              cj3 = -1.0;
                                              j3 = 3.14159265358979;
                                              j6eval[0] = ((IKabs((npx * sj5))) + (IKabs((npy * sj5))));
                                              if (IKabs(j6eval[0]) < 0.0000010000000000)
                                              {
                                                {
                                                  IkReal j6eval[1];
                                                  sj3 = 0;
                                                  cj3 = -1.0;
                                                  j3 = 3.14159265358979;
                                                  j6eval[0] = ((IKabs((cj5 * npx))) + (IKabs((cj5 * npy))));
                                                  if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                  {
                                                    {
                                                      IkReal evalcond[1];
                                                      bool bgotonextstatement = true;
                                                      do
                                                      {
                                                        evalcond[0] = ((-3.14159265358979) +
                                                                       (IKfmod(((3.14159265358979) +
                                                                                (IKabs(((-1.5707963267949) + j5)))),
                                                                               6.28318530717959)));
                                                        if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                        {
                                                          bgotonextstatement = false;
                                                          {
                                                            IkReal j6eval[1];
                                                            sj3 = 0;
                                                            cj3 = -1.0;
                                                            j3 = 3.14159265358979;
                                                            sj5 = 1.0;
                                                            cj5 = 0;
                                                            j5 = 1.5707963267949;
                                                            j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                                            if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                            {
                                                              continue;  // no branches [j6]
                                                            }
                                                            else
                                                            {
                                                              {
                                                                IkReal j6array[2], cj6array[2], sj6array[2];
                                                                bool j6valid[2] = { false };
                                                                _nj6 = 2;
                                                                CheckValue<IkReal> x1034 =
                                                                    IKatan2WithCheck(IkReal(((-1.0) * npx)),
                                                                                     IkReal(npy),
                                                                                     IKFAST_ATAN2_MAGTHRESH);
                                                                if (!x1034.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                IkReal x1033 = x1034.value;
                                                                j6array[0] = ((-1.0) * x1033);
                                                                sj6array[0] = IKsin(j6array[0]);
                                                                cj6array[0] = IKcos(j6array[0]);
                                                                j6array[1] = ((3.14159265358979) + (((-1.0) * x1033)));
                                                                sj6array[1] = IKsin(j6array[1]);
                                                                cj6array[1] = IKcos(j6array[1]);
                                                                if (j6array[0] > IKPI)
                                                                {
                                                                  j6array[0] -= IK2PI;
                                                                }
                                                                else if (j6array[0] < -IKPI)
                                                                {
                                                                  j6array[0] += IK2PI;
                                                                }
                                                                j6valid[0] = true;
                                                                if (j6array[1] > IKPI)
                                                                {
                                                                  j6array[1] -= IK2PI;
                                                                }
                                                                else if (j6array[1] < -IKPI)
                                                                {
                                                                  j6array[1] += IK2PI;
                                                                }
                                                                j6valid[1] = true;
                                                                for (int ij6 = 0; ij6 < 2; ++ij6)
                                                                {
                                                                  if (!j6valid[ij6])
                                                                  {
                                                                    continue;
                                                                  }
                                                                  _ij6[0] = ij6;
                                                                  _ij6[1] = -1;
                                                                  for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                                  {
                                                                    if (j6valid[iij6] &&
                                                                        IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                            IKFAST_SOLUTION_THRESH &&
                                                                        IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                            IKFAST_SOLUTION_THRESH)
                                                                    {
                                                                      j6valid[iij6] = false;
                                                                      _ij6[1] = iij6;
                                                                      break;
                                                                    }
                                                                  }
                                                                  j6 = j6array[ij6];
                                                                  cj6 = cj6array[ij6];
                                                                  sj6 = sj6array[ij6];
                                                                  {
                                                                    IkReal evalcond[1];
                                                                    evalcond[0] = ((((-1.0) * npy * (IKcos(j6)))) +
                                                                                   (((-1.0) * npx * (IKsin(j6)))));
                                                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                                                    {
                                                                      continue;
                                                                    }
                                                                  }

                                                                  rotationfunction0(solutions);
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      } while (0);
                                                      if (bgotonextstatement)
                                                      {
                                                        bool bgotonextstatement = true;
                                                        do
                                                        {
                                                          evalcond[0] = ((-3.14159265358979) +
                                                                         (IKfmod(((3.14159265358979) +
                                                                                  (IKabs(((1.5707963267949) + j5)))),
                                                                                 6.28318530717959)));
                                                          if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                          {
                                                            bgotonextstatement = false;
                                                            {
                                                              IkReal j6eval[1];
                                                              sj3 = 0;
                                                              cj3 = -1.0;
                                                              j3 = 3.14159265358979;
                                                              sj5 = -1.0;
                                                              cj5 = 0;
                                                              j5 = -1.5707963267949;
                                                              j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                                              if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                              {
                                                                continue;  // no branches [j6]
                                                              }
                                                              else
                                                              {
                                                                {
                                                                  IkReal j6array[2], cj6array[2], sj6array[2];
                                                                  bool j6valid[2] = { false };
                                                                  _nj6 = 2;
                                                                  CheckValue<IkReal> x1036 =
                                                                      IKatan2WithCheck(IkReal(npx),
                                                                                       IkReal(((-1.0) * npy)),
                                                                                       IKFAST_ATAN2_MAGTHRESH);
                                                                  if (!x1036.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x1035 = x1036.value;
                                                                  j6array[0] = ((-1.0) * x1035);
                                                                  sj6array[0] = IKsin(j6array[0]);
                                                                  cj6array[0] = IKcos(j6array[0]);
                                                                  j6array[1] =
                                                                      ((3.14159265358979) + (((-1.0) * x1035)));
                                                                  sj6array[1] = IKsin(j6array[1]);
                                                                  cj6array[1] = IKcos(j6array[1]);
                                                                  if (j6array[0] > IKPI)
                                                                  {
                                                                    j6array[0] -= IK2PI;
                                                                  }
                                                                  else if (j6array[0] < -IKPI)
                                                                  {
                                                                    j6array[0] += IK2PI;
                                                                  }
                                                                  j6valid[0] = true;
                                                                  if (j6array[1] > IKPI)
                                                                  {
                                                                    j6array[1] -= IK2PI;
                                                                  }
                                                                  else if (j6array[1] < -IKPI)
                                                                  {
                                                                    j6array[1] += IK2PI;
                                                                  }
                                                                  j6valid[1] = true;
                                                                  for (int ij6 = 0; ij6 < 2; ++ij6)
                                                                  {
                                                                    if (!j6valid[ij6])
                                                                    {
                                                                      continue;
                                                                    }
                                                                    _ij6[0] = ij6;
                                                                    _ij6[1] = -1;
                                                                    for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                                    {
                                                                      if (j6valid[iij6] &&
                                                                          IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                              IKFAST_SOLUTION_THRESH &&
                                                                          IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                              IKFAST_SOLUTION_THRESH)
                                                                      {
                                                                        j6valid[iij6] = false;
                                                                        _ij6[1] = iij6;
                                                                        break;
                                                                      }
                                                                    }
                                                                    j6 = j6array[ij6];
                                                                    cj6 = cj6array[ij6];
                                                                    sj6 = sj6array[ij6];
                                                                    {
                                                                      IkReal evalcond[1];
                                                                      evalcond[0] = ((((-1.0) * npy * (IKcos(j6)))) +
                                                                                     (((-1.0) * npx * (IKsin(j6)))));
                                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                                                      {
                                                                        continue;
                                                                      }
                                                                    }

                                                                    rotationfunction0(solutions);
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        } while (0);
                                                        if (bgotonextstatement)
                                                        {
                                                          bool bgotonextstatement = true;
                                                          do
                                                          {
                                                            evalcond[0] = ((-3.14159265358979) +
                                                                           (IKfmod(((3.14159265358979) + (IKabs(j5))),
                                                                                   6.28318530717959)));
                                                            if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                            {
                                                              bgotonextstatement = false;
                                                              {
                                                                IkReal j6eval[1];
                                                                sj3 = 0;
                                                                cj3 = -1.0;
                                                                j3 = 3.14159265358979;
                                                                sj5 = 0;
                                                                cj5 = 1.0;
                                                                j5 = 0;
                                                                j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                                                if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                                {
                                                                  continue;  // no branches [j6]
                                                                }
                                                                else
                                                                {
                                                                  {
                                                                    IkReal j6array[2], cj6array[2], sj6array[2];
                                                                    bool j6valid[2] = { false };
                                                                    _nj6 = 2;
                                                                    CheckValue<IkReal> x1038 =
                                                                        IKatan2WithCheck(IkReal(((-1.0) * npx)),
                                                                                         IkReal(npy),
                                                                                         IKFAST_ATAN2_MAGTHRESH);
                                                                    if (!x1038.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    IkReal x1037 = x1038.value;
                                                                    j6array[0] = ((-1.0) * x1037);
                                                                    sj6array[0] = IKsin(j6array[0]);
                                                                    cj6array[0] = IKcos(j6array[0]);
                                                                    j6array[1] =
                                                                        ((3.14159265358979) + (((-1.0) * x1037)));
                                                                    sj6array[1] = IKsin(j6array[1]);
                                                                    cj6array[1] = IKcos(j6array[1]);
                                                                    if (j6array[0] > IKPI)
                                                                    {
                                                                      j6array[0] -= IK2PI;
                                                                    }
                                                                    else if (j6array[0] < -IKPI)
                                                                    {
                                                                      j6array[0] += IK2PI;
                                                                    }
                                                                    j6valid[0] = true;
                                                                    if (j6array[1] > IKPI)
                                                                    {
                                                                      j6array[1] -= IK2PI;
                                                                    }
                                                                    else if (j6array[1] < -IKPI)
                                                                    {
                                                                      j6array[1] += IK2PI;
                                                                    }
                                                                    j6valid[1] = true;
                                                                    for (int ij6 = 0; ij6 < 2; ++ij6)
                                                                    {
                                                                      if (!j6valid[ij6])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij6[0] = ij6;
                                                                      _ij6[1] = -1;
                                                                      for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                                      {
                                                                        if (j6valid[iij6] &&
                                                                            IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                                IKFAST_SOLUTION_THRESH &&
                                                                            IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                                IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j6valid[iij6] = false;
                                                                          _ij6[1] = iij6;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j6 = j6array[ij6];
                                                                      cj6 = cj6array[ij6];
                                                                      sj6 = sj6array[ij6];
                                                                      {
                                                                        IkReal evalcond[1];
                                                                        evalcond[0] = ((((-1.0) * npy * (IKcos(j6)))) +
                                                                                       (((-1.0) * npx * (IKsin(j6)))));
                                                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      rotationfunction0(solutions);
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          } while (0);
                                                          if (bgotonextstatement)
                                                          {
                                                            bool bgotonextstatement = true;
                                                            do
                                                            {
                                                              evalcond[0] =
                                                                  ((-3.14159265358979) +
                                                                   (IKfmod(((3.14159265358979) +
                                                                            (IKabs(((-3.14159265358979) + j5)))),
                                                                           6.28318530717959)));
                                                              if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                              {
                                                                bgotonextstatement = false;
                                                                {
                                                                  IkReal j6eval[1];
                                                                  sj3 = 0;
                                                                  cj3 = -1.0;
                                                                  j3 = 3.14159265358979;
                                                                  sj5 = 0;
                                                                  cj5 = -1.0;
                                                                  j5 = 3.14159265358979;
                                                                  j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                                                  if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                                  {
                                                                    continue;  // no branches [j6]
                                                                  }
                                                                  else
                                                                  {
                                                                    {
                                                                      IkReal j6array[2], cj6array[2], sj6array[2];
                                                                      bool j6valid[2] = { false };
                                                                      _nj6 = 2;
                                                                      CheckValue<IkReal> x1040 =
                                                                          IKatan2WithCheck(IkReal(npx),
                                                                                           IkReal(((-1.0) * npy)),
                                                                                           IKFAST_ATAN2_MAGTHRESH);
                                                                      if (!x1040.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      IkReal x1039 = x1040.value;
                                                                      j6array[0] = ((-1.0) * x1039);
                                                                      sj6array[0] = IKsin(j6array[0]);
                                                                      cj6array[0] = IKcos(j6array[0]);
                                                                      j6array[1] =
                                                                          ((3.14159265358979) + (((-1.0) * x1039)));
                                                                      sj6array[1] = IKsin(j6array[1]);
                                                                      cj6array[1] = IKcos(j6array[1]);
                                                                      if (j6array[0] > IKPI)
                                                                      {
                                                                        j6array[0] -= IK2PI;
                                                                      }
                                                                      else if (j6array[0] < -IKPI)
                                                                      {
                                                                        j6array[0] += IK2PI;
                                                                      }
                                                                      j6valid[0] = true;
                                                                      if (j6array[1] > IKPI)
                                                                      {
                                                                        j6array[1] -= IK2PI;
                                                                      }
                                                                      else if (j6array[1] < -IKPI)
                                                                      {
                                                                        j6array[1] += IK2PI;
                                                                      }
                                                                      j6valid[1] = true;
                                                                      for (int ij6 = 0; ij6 < 2; ++ij6)
                                                                      {
                                                                        if (!j6valid[ij6])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij6[0] = ij6;
                                                                        _ij6[1] = -1;
                                                                        for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                                        {
                                                                          if (j6valid[iij6] &&
                                                                              IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                              IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                                  IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j6valid[iij6] = false;
                                                                            _ij6[1] = iij6;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j6 = j6array[ij6];
                                                                        cj6 = cj6array[ij6];
                                                                        sj6 = sj6array[ij6];
                                                                        {
                                                                          IkReal evalcond[1];
                                                                          evalcond[0] =
                                                                              ((((-1.0) * npy * (IKcos(j6)))) +
                                                                               (((-1.0) * npx * (IKsin(j6)))));
                                                                          if (IKabs(evalcond[0]) >
                                                                              IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        rotationfunction0(solutions);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            } while (0);
                                                            if (bgotonextstatement)
                                                            {
                                                              bool bgotonextstatement = true;
                                                              do
                                                              {
                                                                if (1)
                                                                {
                                                                  bgotonextstatement = false;
                                                                  continue;  // branch miss [j6]
                                                                }
                                                              } while (0);
                                                              if (bgotonextstatement)
                                                              {
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                  else
                                                  {
                                                    {
                                                      IkReal j6array[2], cj6array[2], sj6array[2];
                                                      bool j6valid[2] = { false };
                                                      _nj6 = 2;
                                                      CheckValue<IkReal> x1042 =
                                                          IKatan2WithCheck(IkReal(((-1.0) * cj5 * npx)),
                                                                           IkReal((cj5 * npy)),
                                                                           IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x1042.valid)
                                                      {
                                                        continue;
                                                      }
                                                      IkReal x1041 = x1042.value;
                                                      j6array[0] = ((-1.0) * x1041);
                                                      sj6array[0] = IKsin(j6array[0]);
                                                      cj6array[0] = IKcos(j6array[0]);
                                                      j6array[1] = ((3.14159265358979) + (((-1.0) * x1041)));
                                                      sj6array[1] = IKsin(j6array[1]);
                                                      cj6array[1] = IKcos(j6array[1]);
                                                      if (j6array[0] > IKPI)
                                                      {
                                                        j6array[0] -= IK2PI;
                                                      }
                                                      else if (j6array[0] < -IKPI)
                                                      {
                                                        j6array[0] += IK2PI;
                                                      }
                                                      j6valid[0] = true;
                                                      if (j6array[1] > IKPI)
                                                      {
                                                        j6array[1] -= IK2PI;
                                                      }
                                                      else if (j6array[1] < -IKPI)
                                                      {
                                                        j6array[1] += IK2PI;
                                                      }
                                                      j6valid[1] = true;
                                                      for (int ij6 = 0; ij6 < 2; ++ij6)
                                                      {
                                                        if (!j6valid[ij6])
                                                        {
                                                          continue;
                                                        }
                                                        _ij6[0] = ij6;
                                                        _ij6[1] = -1;
                                                        for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                        {
                                                          if (j6valid[iij6] &&
                                                              IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                  IKFAST_SOLUTION_THRESH &&
                                                              IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                  IKFAST_SOLUTION_THRESH)
                                                          {
                                                            j6valid[iij6] = false;
                                                            _ij6[1] = iij6;
                                                            break;
                                                          }
                                                        }
                                                        j6 = j6array[ij6];
                                                        cj6 = cj6array[ij6];
                                                        sj6 = sj6array[ij6];
                                                        {
                                                          IkReal evalcond[3];
                                                          IkReal x1043 = IKsin(j6);
                                                          IkReal x1044 = IKcos(j6);
                                                          IkReal x1045 = ((1.0) * npx);
                                                          IkReal x1046 = (npy * x1043);
                                                          evalcond[0] = (x1046 + (((-1.0) * x1044 * x1045)));
                                                          evalcond[1] =
                                                              ((((-1.0) * x1043 * x1045)) + (((-1.0) * npy * x1044)));
                                                          evalcond[2] =
                                                              (((sj5 * x1046)) + (((-1.0) * sj5 * x1044 * x1045)));
                                                          if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH)
                                                          {
                                                            continue;
                                                          }
                                                        }

                                                        rotationfunction0(solutions);
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                              else
                                              {
                                                {
                                                  IkReal j6array[2], cj6array[2], sj6array[2];
                                                  bool j6valid[2] = { false };
                                                  _nj6 = 2;
                                                  CheckValue<IkReal> x1048 =
                                                      IKatan2WithCheck(IkReal(((-1.0) * npx * sj5)),
                                                                       IkReal((npy * sj5)),
                                                                       IKFAST_ATAN2_MAGTHRESH);
                                                  if (!x1048.valid)
                                                  {
                                                    continue;
                                                  }
                                                  IkReal x1047 = x1048.value;
                                                  j6array[0] = ((-1.0) * x1047);
                                                  sj6array[0] = IKsin(j6array[0]);
                                                  cj6array[0] = IKcos(j6array[0]);
                                                  j6array[1] = ((3.14159265358979) + (((-1.0) * x1047)));
                                                  sj6array[1] = IKsin(j6array[1]);
                                                  cj6array[1] = IKcos(j6array[1]);
                                                  if (j6array[0] > IKPI)
                                                  {
                                                    j6array[0] -= IK2PI;
                                                  }
                                                  else if (j6array[0] < -IKPI)
                                                  {
                                                    j6array[0] += IK2PI;
                                                  }
                                                  j6valid[0] = true;
                                                  if (j6array[1] > IKPI)
                                                  {
                                                    j6array[1] -= IK2PI;
                                                  }
                                                  else if (j6array[1] < -IKPI)
                                                  {
                                                    j6array[1] += IK2PI;
                                                  }
                                                  j6valid[1] = true;
                                                  for (int ij6 = 0; ij6 < 2; ++ij6)
                                                  {
                                                    if (!j6valid[ij6])
                                                    {
                                                      continue;
                                                    }
                                                    _ij6[0] = ij6;
                                                    _ij6[1] = -1;
                                                    for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                    {
                                                      if (j6valid[iij6] &&
                                                          IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                              IKFAST_SOLUTION_THRESH &&
                                                          IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                              IKFAST_SOLUTION_THRESH)
                                                      {
                                                        j6valid[iij6] = false;
                                                        _ij6[1] = iij6;
                                                        break;
                                                      }
                                                    }
                                                    j6 = j6array[ij6];
                                                    cj6 = cj6array[ij6];
                                                    sj6 = sj6array[ij6];
                                                    {
                                                      IkReal evalcond[3];
                                                      IkReal x1049 = IKsin(j6);
                                                      IkReal x1050 = IKcos(j6);
                                                      IkReal x1051 = ((1.0) * npx);
                                                      IkReal x1052 = (npy * x1049);
                                                      evalcond[0] = (x1052 + (((-1.0) * x1050 * x1051)));
                                                      evalcond[1] =
                                                          ((((-1.0) * npy * x1050)) + (((-1.0) * x1049 * x1051)));
                                                      evalcond[2] =
                                                          ((((-1.0) * cj5 * x1050 * x1051)) + ((cj5 * x1052)));
                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH)
                                                      {
                                                        continue;
                                                      }
                                                    }

                                                    rotationfunction0(solutions);
                                                  }
                                                }
                                              }
                                            }
                                          }
                                          else
                                          {
                                            {
                                              IkReal j6array[2], cj6array[2], sj6array[2];
                                              bool j6valid[2] = { false };
                                              _nj6 = 2;
                                              CheckValue<IkReal> x1054 = IKatan2WithCheck(
                                                  IkReal(((-1.0) * npx)), IkReal(npy), IKFAST_ATAN2_MAGTHRESH);
                                              if (!x1054.valid)
                                              {
                                                continue;
                                              }
                                              IkReal x1053 = x1054.value;
                                              j6array[0] = ((-1.0) * x1053);
                                              sj6array[0] = IKsin(j6array[0]);
                                              cj6array[0] = IKcos(j6array[0]);
                                              j6array[1] = ((3.14159265358979) + (((-1.0) * x1053)));
                                              sj6array[1] = IKsin(j6array[1]);
                                              cj6array[1] = IKcos(j6array[1]);
                                              if (j6array[0] > IKPI)
                                              {
                                                j6array[0] -= IK2PI;
                                              }
                                              else if (j6array[0] < -IKPI)
                                              {
                                                j6array[0] += IK2PI;
                                              }
                                              j6valid[0] = true;
                                              if (j6array[1] > IKPI)
                                              {
                                                j6array[1] -= IK2PI;
                                              }
                                              else if (j6array[1] < -IKPI)
                                              {
                                                j6array[1] += IK2PI;
                                              }
                                              j6valid[1] = true;
                                              for (int ij6 = 0; ij6 < 2; ++ij6)
                                              {
                                                if (!j6valid[ij6])
                                                {
                                                  continue;
                                                }
                                                _ij6[0] = ij6;
                                                _ij6[1] = -1;
                                                for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                {
                                                  if (j6valid[iij6] &&
                                                      IKabs(cj6array[ij6] - cj6array[iij6]) < IKFAST_SOLUTION_THRESH &&
                                                      IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                                                  {
                                                    j6valid[iij6] = false;
                                                    _ij6[1] = iij6;
                                                    break;
                                                  }
                                                }
                                                j6 = j6array[ij6];
                                                cj6 = cj6array[ij6];
                                                sj6 = sj6array[ij6];
                                                {
                                                  IkReal evalcond[3];
                                                  IkReal x1055 = IKsin(j6);
                                                  IkReal x1056 = IKcos(j6);
                                                  IkReal x1057 = ((1.0) * npx);
                                                  IkReal x1058 = (npy * x1055);
                                                  evalcond[0] = ((((-1.0) * npy * x1056)) + (((-1.0) * x1055 * x1057)));
                                                  evalcond[1] = (((sj5 * x1058)) + (((-1.0) * sj5 * x1056 * x1057)));
                                                  evalcond[2] = ((((-1.0) * cj5 * x1056 * x1057)) + ((cj5 * x1058)));
                                                  if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH)
                                                  {
                                                    continue;
                                                  }
                                                }

                                                rotationfunction0(solutions);
                                              }
                                            }
                                          }
                                        }
                                      }
                                    } while (0);
                                    if (bgotonextstatement)
                                    {
                                      bool bgotonextstatement = true;
                                      do
                                      {
                                        evalcond[0] = ((-3.14159265358979) +
                                                       (IKfmod(((3.14159265358979) + (IKabs(j5))), 6.28318530717959)));
                                        if (IKabs(evalcond[0]) < 0.0000050000000000)
                                        {
                                          bgotonextstatement = false;
                                          {
                                            IkReal j6eval[3];
                                            sj5 = 0;
                                            cj5 = 1.0;
                                            j5 = 0;
                                            IkReal x1059 = npx * npx;
                                            IkReal x1060 = npy * npy;
                                            IkReal x1061 = (npy * sj3);
                                            IkReal x1062 = (npx * sj3);
                                            j6eval[0] = (x1059 + x1060);
                                            j6eval[1] = ((IKabs(((((-1.0) * cj4 * x1062)) + ((sj4 * x1061))))) +
                                                         (IKabs((((cj4 * x1061)) + ((sj4 * x1062))))));
                                            j6eval[2] = IKsign(((((5.0) * x1060)) + (((5.0) * x1059))));
                                            if (IKabs(j6eval[0]) < 0.0000010000000000 ||
                                                IKabs(j6eval[1]) < 0.0000010000000000 ||
                                                IKabs(j6eval[2]) < 0.0000010000000000)
                                            {
                                              {
                                                IkReal evalcond[1];
                                                bool bgotonextstatement = true;
                                                do
                                                {
                                                  evalcond[0] =
                                                      ((-3.14159265358979) +
                                                       (IKfmod(((3.14159265358979) + (IKabs(j3))), 6.28318530717959)));
                                                  if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                  {
                                                    bgotonextstatement = false;
                                                    {
                                                      IkReal j6eval[1];
                                                      sj5 = 0;
                                                      cj5 = 1.0;
                                                      j5 = 0;
                                                      sj3 = 0;
                                                      cj3 = 1.0;
                                                      j3 = 0;
                                                      j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                                      if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                      {
                                                        continue;  // no branches [j6]
                                                      }
                                                      else
                                                      {
                                                        {
                                                          IkReal j6array[2], cj6array[2], sj6array[2];
                                                          bool j6valid[2] = { false };
                                                          _nj6 = 2;
                                                          CheckValue<IkReal> x1064 =
                                                              IKatan2WithCheck(IkReal(((-1.0) * npx)),
                                                                               IkReal(npy),
                                                                               IKFAST_ATAN2_MAGTHRESH);
                                                          if (!x1064.valid)
                                                          {
                                                            continue;
                                                          }
                                                          IkReal x1063 = x1064.value;
                                                          j6array[0] = ((-1.0) * x1063);
                                                          sj6array[0] = IKsin(j6array[0]);
                                                          cj6array[0] = IKcos(j6array[0]);
                                                          j6array[1] = ((3.14159265358979) + (((-1.0) * x1063)));
                                                          sj6array[1] = IKsin(j6array[1]);
                                                          cj6array[1] = IKcos(j6array[1]);
                                                          if (j6array[0] > IKPI)
                                                          {
                                                            j6array[0] -= IK2PI;
                                                          }
                                                          else if (j6array[0] < -IKPI)
                                                          {
                                                            j6array[0] += IK2PI;
                                                          }
                                                          j6valid[0] = true;
                                                          if (j6array[1] > IKPI)
                                                          {
                                                            j6array[1] -= IK2PI;
                                                          }
                                                          else if (j6array[1] < -IKPI)
                                                          {
                                                            j6array[1] += IK2PI;
                                                          }
                                                          j6valid[1] = true;
                                                          for (int ij6 = 0; ij6 < 2; ++ij6)
                                                          {
                                                            if (!j6valid[ij6])
                                                            {
                                                              continue;
                                                            }
                                                            _ij6[0] = ij6;
                                                            _ij6[1] = -1;
                                                            for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                            {
                                                              if (j6valid[iij6] &&
                                                                  IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                      IKFAST_SOLUTION_THRESH &&
                                                                  IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                      IKFAST_SOLUTION_THRESH)
                                                              {
                                                                j6valid[iij6] = false;
                                                                _ij6[1] = iij6;
                                                                break;
                                                              }
                                                            }
                                                            j6 = j6array[ij6];
                                                            cj6 = cj6array[ij6];
                                                            sj6 = sj6array[ij6];
                                                            {
                                                              IkReal evalcond[1];
                                                              evalcond[0] = ((((-1.0) * npy * (IKcos(j6)))) +
                                                                             (((-1.0) * npx * (IKsin(j6)))));
                                                              if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                                              {
                                                                continue;
                                                              }
                                                            }

                                                            rotationfunction0(solutions);
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                } while (0);
                                                if (bgotonextstatement)
                                                {
                                                  bool bgotonextstatement = true;
                                                  do
                                                  {
                                                    if (1)
                                                    {
                                                      bgotonextstatement = false;
                                                      continue;  // branch miss [j6]
                                                    }
                                                  } while (0);
                                                  if (bgotonextstatement)
                                                  {
                                                  }
                                                }
                                              }
                                            }
                                            else
                                            {
                                              {
                                                IkReal j6array[1], cj6array[1], sj6array[1];
                                                bool j6valid[1] = { false };
                                                _nj6 = 1;
                                                IkReal x1065 = ((2.0) * sj3);
                                                CheckValue<IkReal> x1066 = IKatan2WithCheck(
                                                    IkReal((((cj4 * npy * x1065)) + ((npx * sj4 * x1065)))),
                                                    IkReal(((((-1.0) * cj4 * npx * x1065)) + ((npy * sj4 * x1065)))),
                                                    IKFAST_ATAN2_MAGTHRESH);
                                                if (!x1066.valid)
                                                {
                                                  continue;
                                                }
                                                CheckValue<IkReal> x1067 = IKPowWithIntegerCheck(
                                                    IKsign(((((5.0) * (npx * npx))) + (((5.0) * (npy * npy))))), -1);
                                                if (!x1067.valid)
                                                {
                                                  continue;
                                                }
                                                j6array[0] = ((-1.5707963267949) + (x1066.value) +
                                                              (((1.5707963267949) * (x1067.value))));
                                                sj6array[0] = IKsin(j6array[0]);
                                                cj6array[0] = IKcos(j6array[0]);
                                                if (j6array[0] > IKPI)
                                                {
                                                  j6array[0] -= IK2PI;
                                                }
                                                else if (j6array[0] < -IKPI)
                                                {
                                                  j6array[0] += IK2PI;
                                                }
                                                j6valid[0] = true;
                                                for (int ij6 = 0; ij6 < 1; ++ij6)
                                                {
                                                  if (!j6valid[ij6])
                                                  {
                                                    continue;
                                                  }
                                                  _ij6[0] = ij6;
                                                  _ij6[1] = -1;
                                                  for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                                  {
                                                    if (j6valid[iij6] &&
                                                        IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                            IKFAST_SOLUTION_THRESH &&
                                                        IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                                                    {
                                                      j6valid[iij6] = false;
                                                      _ij6[1] = iij6;
                                                      break;
                                                    }
                                                  }
                                                  j6 = j6array[ij6];
                                                  cj6 = cj6array[ij6];
                                                  sj6 = sj6array[ij6];
                                                  {
                                                    IkReal evalcond[2];
                                                    IkReal x1068 = IKsin(j6);
                                                    IkReal x1069 = IKcos(j6);
                                                    IkReal x1070 = ((0.4) * sj3);
                                                    IkReal x1071 = ((1.0) * x1069);
                                                    evalcond[0] = ((((-1.0) * npx * x1071)) + (((-1.0) * cj4 * x1070)) +
                                                                   ((npy * x1068)));
                                                    evalcond[1] = ((((-1.0) * npy * x1071)) + (((-1.0) * npx * x1068)) +
                                                                   ((sj4 * x1070)));
                                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH)
                                                    {
                                                      continue;
                                                    }
                                                  }

                                                  rotationfunction0(solutions);
                                                }
                                              }
                                            }
                                          }
                                        }
                                      } while (0);
                                      if (bgotonextstatement)
                                      {
                                        bool bgotonextstatement = true;
                                        do
                                        {
                                          evalcond[0] =
                                              ((-3.14159265358979) +
                                               (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j5)))),
                                                       6.28318530717959)));
                                          if (IKabs(evalcond[0]) < 0.0000050000000000)
                                          {
                                            bgotonextstatement = false;
                                            {
                                              IkReal j6eval[3];
                                              sj5 = 0;
                                              cj5 = -1.0;
                                              j5 = 3.14159265358979;
                                              IkReal x1072 = npx * npx;
                                              IkReal x1073 = npy * npy;
                                              IkReal x1074 = (cj4 * sj3);
                                              IkReal x1075 = (sj3 * sj4);
                                              j6eval[0] = (x1072 + x1073);
                                              j6eval[1] = ((IKabs((((npx * x1074)) + ((npy * x1075))))) +
                                                           (IKabs(((((-1.0) * npy * x1074)) + ((npx * x1075))))));
                                              j6eval[2] = IKsign(((((5.0) * x1073)) + (((5.0) * x1072))));
                                              if (IKabs(j6eval[0]) < 0.0000010000000000 ||
                                                  IKabs(j6eval[1]) < 0.0000010000000000 ||
                                                  IKabs(j6eval[2]) < 0.0000010000000000)
                                              {
                                                {
                                                  IkReal evalcond[1];
                                                  bool bgotonextstatement = true;
                                                  do
                                                  {
                                                    evalcond[0] = ((-3.14159265358979) +
                                                                   (IKfmod(((3.14159265358979) + (IKabs(j3))),
                                                                           6.28318530717959)));
                                                    if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                    {
                                                      bgotonextstatement = false;
                                                      {
                                                        IkReal j6eval[1];
                                                        sj5 = 0;
                                                        cj5 = -1.0;
                                                        j5 = 3.14159265358979;
                                                        sj3 = 0;
                                                        cj3 = 1.0;
                                                        j3 = 0;
                                                        j6eval[0] = ((IKabs(npy)) + (IKabs(npx)));
                                                        if (IKabs(j6eval[0]) < 0.0000010000000000)
                                                        {
                                                          continue;  // no branches [j6]
                                                        }
                                                        else
                                                        {
                                                          {
                                                            IkReal j6array[2], cj6array[2], sj6array[2];
                                                            bool j6valid[2] = { false };
                                                            _nj6 = 2;
                                                            CheckValue<IkReal> x1077 =
                                                                IKatan2WithCheck(IkReal(npx),
                                                                                 IkReal(((-1.0) * npy)),
                                                                                 IKFAST_ATAN2_MAGTHRESH);
                                                            if (!x1077.valid)
                                                            {
                                                              continue;
                                                            }
                                                            IkReal x1076 = x1077.value;
                                                            j6array[0] = ((-1.0) * x1076);
                                                            sj6array[0] = IKsin(j6array[0]);
                                                            cj6array[0] = IKcos(j6array[0]);
                                                            j6array[1] = ((3.14159265358979) + (((-1.0) * x1076)));
                                                            sj6array[1] = IKsin(j6array[1]);
                                                            cj6array[1] = IKcos(j6array[1]);
                                                            if (j6array[0] > IKPI)
                                                            {
                                                              j6array[0] -= IK2PI;
                                                            }
                                                            else if (j6array[0] < -IKPI)
                                                            {
                                                              j6array[0] += IK2PI;
                                                            }
                                                            j6valid[0] = true;
                                                            if (j6array[1] > IKPI)
                                                            {
                                                              j6array[1] -= IK2PI;
                                                            }
                                                            else if (j6array[1] < -IKPI)
                                                            {
                                                              j6array[1] += IK2PI;
                                                            }
                                                            j6valid[1] = true;
                                                            for (int ij6 = 0; ij6 < 2; ++ij6)
                                                            {
                                                              if (!j6valid[ij6])
                                                              {
                                                                continue;
                                                              }
                                                              _ij6[0] = ij6;
                                                              _ij6[1] = -1;
                                                              for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                                                              {
                                                                if (j6valid[iij6] &&
                                                                    IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                        IKFAST_SOLUTION_THRESH &&
                                                                    IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                        IKFAST_SOLUTION_THRESH)
                                                                {
                                                                  j6valid[iij6] = false;
                                                                  _ij6[1] = iij6;
                                                                  break;
                                                                }
                                                              }
                                                              j6 = j6array[ij6];
                                                              cj6 = cj6array[ij6];
                                                              sj6 = sj6array[ij6];
                                                              {
                                                                IkReal evalcond[1];
                                                                evalcond[0] = ((((-1.0) * npy * (IKcos(j6)))) +
                                                                               (((-1.0) * npx * (IKsin(j6)))));
                                                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                                                {
                                                                  continue;
                                                                }
                                                              }

                                                              rotationfunction0(solutions);
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  } while (0);
                                                  if (bgotonextstatement)
                                                  {
                                                    bool bgotonextstatement = true;
                                                    do
                                                    {
                                                      if (1)
                                                      {
                                                        bgotonextstatement = false;
                                                        continue;  // branch miss [j6]
                                                      }
                                                    } while (0);
                                                    if (bgotonextstatement)
                                                    {
                                                    }
                                                  }
                                                }
                                              }
                                              else
                                              {
                                                {
                                                  IkReal j6array[1], cj6array[1], sj6array[1];
                                                  bool j6valid[1] = { false };
                                                  _nj6 = 1;
                                                  IkReal x1078 = ((2.0) * sj3);
                                                  CheckValue<IkReal> x1079 = IKPowWithIntegerCheck(
                                                      IKsign(((((5.0) * (npx * npx))) + (((5.0) * (npy * npy))))), -1);
                                                  if (!x1079.valid)
                                                  {
                                                    continue;
                                                  }
                                                  CheckValue<IkReal> x1080 = IKatan2WithCheck(
                                                      IkReal(((((-1.0) * cj4 * npy * x1078)) + ((npx * sj4 * x1078)))),
                                                      IkReal((((cj4 * npx * x1078)) + ((npy * sj4 * x1078)))),
                                                      IKFAST_ATAN2_MAGTHRESH);
                                                  if (!x1080.valid)
                                                  {
                                                    continue;
                                                  }
                                                  j6array[0] = ((-1.5707963267949) +
                                                                (((1.5707963267949) * (x1079.value))) + (x1080.value));
                                                  sj6array[0] = IKsin(j6array[0]);
                                                  cj6array[0] = IKcos(j6array[0]);
                                                  if (j6array[0] > IKPI)
                                                  {
                                                    j6array[0] -= IK2PI;
                                                  }
                                                  else if (j6array[0] < -IKPI)
                                                  {
                                                    j6array[0] += IK2PI;
                                                  }
                                                  j6valid[0] = true;
                                                  for (int ij6 = 0; ij6 < 1; ++ij6)
                                                  {
                                                    if (!j6valid[ij6])
                                                    {
                                                      continue;
                                                    }
                                                    _ij6[0] = ij6;
                                                    _ij6[1] = -1;
                                                    for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                                    {
                                                      if (j6valid[iij6] &&
                                                          IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                              IKFAST_SOLUTION_THRESH &&
                                                          IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                              IKFAST_SOLUTION_THRESH)
                                                      {
                                                        j6valid[iij6] = false;
                                                        _ij6[1] = iij6;
                                                        break;
                                                      }
                                                    }
                                                    j6 = j6array[ij6];
                                                    cj6 = cj6array[ij6];
                                                    sj6 = sj6array[ij6];
                                                    {
                                                      IkReal evalcond[2];
                                                      IkReal x1081 = IKsin(j6);
                                                      IkReal x1082 = IKcos(j6);
                                                      IkReal x1083 = ((0.4) * sj3);
                                                      IkReal x1084 = ((1.0) * npy);
                                                      evalcond[0] = ((((-1.0) * x1081 * x1084)) + ((npx * x1082)) +
                                                                     (((-1.0) * cj4 * x1083)));
                                                      evalcond[1] = ((((-1.0) * x1082 * x1084)) + ((sj4 * x1083)) +
                                                                     (((-1.0) * npx * x1081)));
                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH)
                                                      {
                                                        continue;
                                                      }
                                                    }

                                                    rotationfunction0(solutions);
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        } while (0);
                                        if (bgotonextstatement)
                                        {
                                          bool bgotonextstatement = true;
                                          do
                                          {
                                            evalcond[0] =
                                                ((-3.14159265358979) +
                                                 (IKfmod(((3.14159265358979) + (IKabs(((-1.5707963267949) + j5)))),
                                                         6.28318530717959)));
                                            if (IKabs(evalcond[0]) < 0.0000050000000000)
                                            {
                                              bgotonextstatement = false;
                                              {
                                                IkReal j6eval[3];
                                                sj5 = 1.0;
                                                cj5 = 0;
                                                j5 = 1.5707963267949;
                                                IkReal x1085 = npx * npx;
                                                IkReal x1086 = npy * npy;
                                                IkReal x1087 = ((2.0) * cj3);
                                                IkReal x1088 = ((2.0) * npx);
                                                IkReal x1089 = (sj3 * sj4);
                                                IkReal x1090 = ((2.0) * npy);
                                                j6eval[0] = (x1086 + x1085);
                                                j6eval[1] = ((IKabs((x1088 + ((x1089 * x1090)) + ((npx * x1087))))) +
                                                             (IKabs(((((-1.0) * x1090)) + (((-1.0) * npy * x1087)) +
                                                                     ((x1088 * x1089))))));
                                                j6eval[2] = IKsign(((((5.0) * x1085)) + (((5.0) * x1086))));
                                                if (IKabs(j6eval[0]) < 0.0000010000000000 ||
                                                    IKabs(j6eval[1]) < 0.0000010000000000 ||
                                                    IKabs(j6eval[2]) < 0.0000010000000000)
                                                {
                                                  continue;  // no branches [j6]
                                                }
                                                else
                                                {
                                                  {
                                                    IkReal j6array[1], cj6array[1], sj6array[1];
                                                    bool j6valid[1] = { false };
                                                    _nj6 = 1;
                                                    IkReal x1091 = ((2.0) * cj3);
                                                    IkReal x1092 = ((2.0) * npx);
                                                    IkReal x1093 = (sj3 * sj4);
                                                    IkReal x1094 = ((2.0) * npy);
                                                    CheckValue<IkReal> x1095 = IKatan2WithCheck(
                                                        IkReal(((((-1.0) * x1094)) + ((x1092 * x1093)) +
                                                                (((-1.0) * npy * x1091)))),
                                                        IkReal((((npx * x1091)) + x1092 + ((x1093 * x1094)))),
                                                        IKFAST_ATAN2_MAGTHRESH);
                                                    if (!x1095.valid)
                                                    {
                                                      continue;
                                                    }
                                                    CheckValue<IkReal> x1096 = IKPowWithIntegerCheck(
                                                        IKsign(((((5.0) * (npx * npx))) + (((5.0) * (npy * npy))))),
                                                        -1);
                                                    if (!x1096.valid)
                                                    {
                                                      continue;
                                                    }
                                                    j6array[0] = ((-1.5707963267949) + (x1095.value) +
                                                                  (((1.5707963267949) * (x1096.value))));
                                                    sj6array[0] = IKsin(j6array[0]);
                                                    cj6array[0] = IKcos(j6array[0]);
                                                    if (j6array[0] > IKPI)
                                                    {
                                                      j6array[0] -= IK2PI;
                                                    }
                                                    else if (j6array[0] < -IKPI)
                                                    {
                                                      j6array[0] += IK2PI;
                                                    }
                                                    j6valid[0] = true;
                                                    for (int ij6 = 0; ij6 < 1; ++ij6)
                                                    {
                                                      if (!j6valid[ij6])
                                                      {
                                                        continue;
                                                      }
                                                      _ij6[0] = ij6;
                                                      _ij6[1] = -1;
                                                      for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                                      {
                                                        if (j6valid[iij6] &&
                                                            IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                IKFAST_SOLUTION_THRESH &&
                                                            IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                IKFAST_SOLUTION_THRESH)
                                                        {
                                                          j6valid[iij6] = false;
                                                          _ij6[1] = iij6;
                                                          break;
                                                        }
                                                      }
                                                      j6 = j6array[ij6];
                                                      cj6 = cj6array[ij6];
                                                      sj6 = sj6array[ij6];
                                                      {
                                                        IkReal evalcond[2];
                                                        IkReal x1097 = IKsin(j6);
                                                        IkReal x1098 = IKcos(j6);
                                                        IkReal x1099 = ((1.0) * npx);
                                                        evalcond[0] = ((0.4) + (((0.4) * cj3)) + ((npy * x1097)) +
                                                                       (((-1.0) * x1098 * x1099)));
                                                        evalcond[1] =
                                                            ((((-1.0) * x1097 * x1099)) + (((-1.0) * npy * x1098)) +
                                                             (((0.4) * sj3 * sj4)));
                                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH)
                                                        {
                                                          continue;
                                                        }
                                                      }

                                                      rotationfunction0(solutions);
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          } while (0);
                                          if (bgotonextstatement)
                                          {
                                            bool bgotonextstatement = true;
                                            do
                                            {
                                              evalcond[0] =
                                                  ((-3.14159265358979) +
                                                   (IKfmod(((3.14159265358979) + (IKabs(((1.5707963267949) + j5)))),
                                                           6.28318530717959)));
                                              if (IKabs(evalcond[0]) < 0.0000050000000000)
                                              {
                                                bgotonextstatement = false;
                                                {
                                                  IkReal j6eval[3];
                                                  sj5 = -1.0;
                                                  cj5 = 0;
                                                  j5 = -1.5707963267949;
                                                  IkReal x1100 = npx * npx;
                                                  IkReal x1101 = npy * npy;
                                                  IkReal x1102 = ((2.0) * cj3);
                                                  IkReal x1103 = ((2.0) * npx);
                                                  IkReal x1104 = (sj3 * sj4);
                                                  IkReal x1105 = ((2.0) * npy);
                                                  j6eval[0] = (x1100 + x1101);
                                                  j6eval[1] = ((IKabs(((((-1.0) * npx * x1102)) + ((x1104 * x1105)) +
                                                                       (((-1.0) * x1103))))) +
                                                               (IKabs((x1105 + ((npy * x1102)) + ((x1103 * x1104))))));
                                                  j6eval[2] = IKsign(((((5.0) * x1101)) + (((5.0) * x1100))));
                                                  if (IKabs(j6eval[0]) < 0.0000010000000000 ||
                                                      IKabs(j6eval[1]) < 0.0000010000000000 ||
                                                      IKabs(j6eval[2]) < 0.0000010000000000)
                                                  {
                                                    continue;  // no branches [j6]
                                                  }
                                                  else
                                                  {
                                                    {
                                                      IkReal j6array[1], cj6array[1], sj6array[1];
                                                      bool j6valid[1] = { false };
                                                      _nj6 = 1;
                                                      IkReal x1106 = ((2.0) * cj3);
                                                      IkReal x1107 = ((2.0) * npx);
                                                      IkReal x1108 = (sj3 * sj4);
                                                      IkReal x1109 = ((2.0) * npy);
                                                      CheckValue<IkReal> x1110 = IKPowWithIntegerCheck(
                                                          IKsign(((((5.0) * (npx * npx))) + (((5.0) * (npy * npy))))),
                                                          -1);
                                                      if (!x1110.valid)
                                                      {
                                                        continue;
                                                      }
                                                      CheckValue<IkReal> x1111 = IKatan2WithCheck(
                                                          IkReal((x1109 + ((npy * x1106)) + ((x1107 * x1108)))),
                                                          IkReal((((x1108 * x1109)) + (((-1.0) * npx * x1106)) +
                                                                  (((-1.0) * x1107)))),
                                                          IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x1111.valid)
                                                      {
                                                        continue;
                                                      }
                                                      j6array[0] =
                                                          ((-1.5707963267949) + (((1.5707963267949) * (x1110.value))) +
                                                           (x1111.value));
                                                      sj6array[0] = IKsin(j6array[0]);
                                                      cj6array[0] = IKcos(j6array[0]);
                                                      if (j6array[0] > IKPI)
                                                      {
                                                        j6array[0] -= IK2PI;
                                                      }
                                                      else if (j6array[0] < -IKPI)
                                                      {
                                                        j6array[0] += IK2PI;
                                                      }
                                                      j6valid[0] = true;
                                                      for (int ij6 = 0; ij6 < 1; ++ij6)
                                                      {
                                                        if (!j6valid[ij6])
                                                        {
                                                          continue;
                                                        }
                                                        _ij6[0] = ij6;
                                                        _ij6[1] = -1;
                                                        for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                                        {
                                                          if (j6valid[iij6] &&
                                                              IKabs(cj6array[ij6] - cj6array[iij6]) <
                                                                  IKFAST_SOLUTION_THRESH &&
                                                              IKabs(sj6array[ij6] - sj6array[iij6]) <
                                                                  IKFAST_SOLUTION_THRESH)
                                                          {
                                                            j6valid[iij6] = false;
                                                            _ij6[1] = iij6;
                                                            break;
                                                          }
                                                        }
                                                        j6 = j6array[ij6];
                                                        cj6 = cj6array[ij6];
                                                        sj6 = sj6array[ij6];
                                                        {
                                                          IkReal evalcond[2];
                                                          IkReal x1112 = IKsin(j6);
                                                          IkReal x1113 = IKcos(j6);
                                                          IkReal x1114 = ((1.0) * x1112);
                                                          evalcond[0] = ((0.4) + ((npx * x1113)) +
                                                                         (((-1.0) * npy * x1114)) + (((0.4) * cj3)));
                                                          evalcond[1] =
                                                              ((((-1.0) * npy * x1113)) + (((-1.0) * npx * x1114)) +
                                                               (((0.4) * sj3 * sj4)));
                                                          if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH)
                                                          {
                                                            continue;
                                                          }
                                                        }

                                                        rotationfunction0(solutions);
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            } while (0);
                                            if (bgotonextstatement)
                                            {
                                              bool bgotonextstatement = true;
                                              do
                                              {
                                                if (1)
                                                {
                                                  bgotonextstatement = false;
                                                  continue;  // branch miss [j6]
                                                }
                                              } while (0);
                                              if (bgotonextstatement)
                                              {
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                                else
                                {
                                  {
                                    IkReal j6array[1], cj6array[1], sj6array[1];
                                    bool j6valid[1] = { false };
                                    _nj6 = 1;
                                    IkReal x1115 = ((2.0) * sj5);
                                    IkReal x1116 = ((2.0) * sj3);
                                    IkReal x1117 = (cj4 * cj5);
                                    CheckValue<IkReal> x1118 = IKatan2WithCheck(
                                        IkReal((((npy * x1116 * x1117)) + (((-1.0) * npy * x1115)) +
                                                ((npx * sj4 * x1116)) + (((-1.0) * cj3 * npy * x1115)))),
                                        IkReal((((npx * x1115)) + (((-1.0) * npx * x1116 * x1117)) +
                                                ((npy * sj4 * x1116)) + ((cj3 * npx * x1115)))),
                                        IKFAST_ATAN2_MAGTHRESH);
                                    if (!x1118.valid)
                                    {
                                      continue;
                                    }
                                    CheckValue<IkReal> x1119 = IKPowWithIntegerCheck(
                                        IKsign(((((5.0) * (npx * npx))) + (((5.0) * (npy * npy))))), -1);
                                    if (!x1119.valid)
                                    {
                                      continue;
                                    }
                                    j6array[0] =
                                        ((-1.5707963267949) + (x1118.value) + (((1.5707963267949) * (x1119.value))));
                                    sj6array[0] = IKsin(j6array[0]);
                                    cj6array[0] = IKcos(j6array[0]);
                                    if (j6array[0] > IKPI)
                                    {
                                      j6array[0] -= IK2PI;
                                    }
                                    else if (j6array[0] < -IKPI)
                                    {
                                      j6array[0] += IK2PI;
                                    }
                                    j6valid[0] = true;
                                    for (int ij6 = 0; ij6 < 1; ++ij6)
                                    {
                                      if (!j6valid[ij6])
                                      {
                                        continue;
                                      }
                                      _ij6[0] = ij6;
                                      _ij6[1] = -1;
                                      for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                      {
                                        if (j6valid[iij6] &&
                                            IKabs(cj6array[ij6] - cj6array[iij6]) < IKFAST_SOLUTION_THRESH &&
                                            IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                                        {
                                          j6valid[iij6] = false;
                                          _ij6[1] = iij6;
                                          break;
                                        }
                                      }
                                      j6 = j6array[ij6];
                                      cj6 = cj6array[ij6];
                                      sj6 = sj6array[ij6];
                                      {
                                        IkReal evalcond[4];
                                        IkReal x1120 = IKsin(j6);
                                        IkReal x1121 = IKcos(j6);
                                        IkReal x1122 = ((0.4) * sj3);
                                        IkReal x1123 = ((1.0) * npx);
                                        IkReal x1124 = ((0.4) * sj5);
                                        IkReal x1125 = (npy * x1120);
                                        evalcond[0] =
                                            ((((-1.0) * npy * x1121)) + ((sj4 * x1122)) + (((-1.0) * x1120 * x1123)));
                                        evalcond[1] = (((npz * sj5)) + (((-1.0) * cj4 * x1122)) +
                                                       (((-1.0) * cj5 * x1121 * x1123)) + ((cj5 * x1125)));
                                        evalcond[2] = ((0.4) + (((0.4) * cj3)) + (((-1.0) * sj5 * x1121 * x1123)) +
                                                       (((-1.0) * cj5 * npz)) + ((sj5 * x1125)));
                                        evalcond[3] = ((((-1.0) * cj4 * cj5 * x1122)) + x1124 + x1125 +
                                                       (((-1.0) * x1121 * x1123)) + ((cj3 * x1124)));
                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                        {
                                          continue;
                                        }
                                      }

                                      rotationfunction0(solutions);
                                    }
                                  }
                                }
                              }
                            }
                            else
                            {
                              {
                                IkReal j6array[1], cj6array[1], sj6array[1];
                                bool j6valid[1] = { false };
                                _nj6 = 1;
                                IkReal x1126 = ((2.0) * cj3);
                                IkReal x1127 = ((5.0) * sj5);
                                IkReal x1128 = ((2.0) * npx);
                                IkReal x1129 = ((2.0) * npy);
                                IkReal x1130 = ((5.0) * cj5 * npz);
                                IkReal x1131 = (sj3 * sj4 * sj5);
                                CheckValue<IkReal> x1132 = IKPowWithIntegerCheck(
                                    IKsign((((x1127 * (npy * npy))) + ((x1127 * (npx * npx))))), -1);
                                if (!x1132.valid)
                                {
                                  continue;
                                }
                                CheckValue<IkReal> x1133 = IKatan2WithCheck(
                                    IkReal(((((-1.0) * npy * x1126)) + ((npy * x1130)) + (((-1.0) * x1129)) +
                                            ((x1128 * x1131)))),
                                    IkReal((x1128 + ((npx * x1126)) + (((-1.0) * npx * x1130)) + ((x1129 * x1131)))),
                                    IKFAST_ATAN2_MAGTHRESH);
                                if (!x1133.valid)
                                {
                                  continue;
                                }
                                j6array[0] =
                                    ((-1.5707963267949) + (((1.5707963267949) * (x1132.value))) + (x1133.value));
                                sj6array[0] = IKsin(j6array[0]);
                                cj6array[0] = IKcos(j6array[0]);
                                if (j6array[0] > IKPI)
                                {
                                  j6array[0] -= IK2PI;
                                }
                                else if (j6array[0] < -IKPI)
                                {
                                  j6array[0] += IK2PI;
                                }
                                j6valid[0] = true;
                                for (int ij6 = 0; ij6 < 1; ++ij6)
                                {
                                  if (!j6valid[ij6])
                                  {
                                    continue;
                                  }
                                  _ij6[0] = ij6;
                                  _ij6[1] = -1;
                                  for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                  {
                                    if (j6valid[iij6] &&
                                        IKabs(cj6array[ij6] - cj6array[iij6]) < IKFAST_SOLUTION_THRESH &&
                                        IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                                    {
                                      j6valid[iij6] = false;
                                      _ij6[1] = iij6;
                                      break;
                                    }
                                  }
                                  j6 = j6array[ij6];
                                  cj6 = cj6array[ij6];
                                  sj6 = sj6array[ij6];
                                  {
                                    IkReal evalcond[4];
                                    IkReal x1134 = IKsin(j6);
                                    IkReal x1135 = IKcos(j6);
                                    IkReal x1136 = ((0.4) * sj3);
                                    IkReal x1137 = ((1.0) * npx);
                                    IkReal x1138 = ((0.4) * sj5);
                                    IkReal x1139 = (npy * x1134);
                                    evalcond[0] =
                                        ((((-1.0) * npy * x1135)) + ((sj4 * x1136)) + (((-1.0) * x1134 * x1137)));
                                    evalcond[1] = ((((-1.0) * cj4 * x1136)) + ((npz * sj5)) +
                                                   (((-1.0) * cj5 * x1135 * x1137)) + ((cj5 * x1139)));
                                    evalcond[2] = ((0.4) + (((-1.0) * sj5 * x1135 * x1137)) + (((0.4) * cj3)) +
                                                   (((-1.0) * cj5 * npz)) + ((sj5 * x1139)));
                                    evalcond[3] = (x1139 + x1138 + ((cj3 * x1138)) + (((-1.0) * cj4 * cj5 * x1136)) +
                                                   (((-1.0) * x1135 * x1137)));
                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                    {
                                      continue;
                                    }
                                  }

                                  rotationfunction0(solutions);
                                }
                              }
                            }
                          }
                        }
                        else
                        {
                          {
                            IkReal j6array[1], cj6array[1], sj6array[1];
                            bool j6valid[1] = { false };
                            _nj6 = 1;
                            IkReal x1140 = (cj5 * sj4);
                            IkReal x1141 = ((5.0) * cj5);
                            IkReal x1142 = ((5.0) * npz * sj5);
                            IkReal x1143 = ((2.0) * npy * sj3);
                            IkReal x1144 = ((2.0) * npx * sj3);
                            CheckValue<IkReal> x1145 = IKatan2WithCheck(
                                IkReal((((x1140 * x1144)) + (((-1.0) * npy * x1142)) + ((cj4 * x1143)))),
                                IkReal((((x1140 * x1143)) + (((-1.0) * cj4 * x1144)) + ((npx * x1142)))),
                                IKFAST_ATAN2_MAGTHRESH);
                            if (!x1145.valid)
                            {
                              continue;
                            }
                            CheckValue<IkReal> x1146 =
                                IKPowWithIntegerCheck(IKsign((((x1141 * (npx * npx))) + ((x1141 * (npy * npy))))), -1);
                            if (!x1146.valid)
                            {
                              continue;
                            }
                            j6array[0] = ((-1.5707963267949) + (x1145.value) + (((1.5707963267949) * (x1146.value))));
                            sj6array[0] = IKsin(j6array[0]);
                            cj6array[0] = IKcos(j6array[0]);
                            if (j6array[0] > IKPI)
                            {
                              j6array[0] -= IK2PI;
                            }
                            else if (j6array[0] < -IKPI)
                            {
                              j6array[0] += IK2PI;
                            }
                            j6valid[0] = true;
                            for (int ij6 = 0; ij6 < 1; ++ij6)
                            {
                              if (!j6valid[ij6])
                              {
                                continue;
                              }
                              _ij6[0] = ij6;
                              _ij6[1] = -1;
                              for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                              {
                                if (j6valid[iij6] && IKabs(cj6array[ij6] - cj6array[iij6]) < IKFAST_SOLUTION_THRESH &&
                                    IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                                {
                                  j6valid[iij6] = false;
                                  _ij6[1] = iij6;
                                  break;
                                }
                              }
                              j6 = j6array[ij6];
                              cj6 = cj6array[ij6];
                              sj6 = sj6array[ij6];
                              {
                                IkReal evalcond[4];
                                IkReal x1147 = IKsin(j6);
                                IkReal x1148 = IKcos(j6);
                                IkReal x1149 = ((0.4) * sj3);
                                IkReal x1150 = ((1.0) * npx);
                                IkReal x1151 = ((0.4) * sj5);
                                IkReal x1152 = (npy * x1147);
                                evalcond[0] = (((sj4 * x1149)) + (((-1.0) * x1147 * x1150)) + (((-1.0) * npy * x1148)));
                                evalcond[1] = (((npz * sj5)) + (((-1.0) * cj4 * x1149)) +
                                               (((-1.0) * cj5 * x1148 * x1150)) + ((cj5 * x1152)));
                                evalcond[2] = ((0.4) + (((0.4) * cj3)) + ((sj5 * x1152)) + (((-1.0) * cj5 * npz)) +
                                               (((-1.0) * sj5 * x1148 * x1150)));
                                evalcond[3] = (x1151 + x1152 + ((cj3 * x1151)) + (((-1.0) * x1148 * x1150)) +
                                               (((-1.0) * cj4 * cj5 * x1149)));
                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                {
                                  continue;
                                }
                              }

                              rotationfunction0(solutions);
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
            else
            {
              {
                IkReal j6array[2], cj6array[2], sj6array[2];
                bool j6valid[2] = { false };
                _nj6 = 2;
                CheckValue<IkReal> x1155 =
                    IKatan2WithCheck(IkReal(((-1.0) * npy)), IkReal(((-1.0) * npx)), IKFAST_ATAN2_MAGTHRESH);
                if (!x1155.valid)
                {
                  continue;
                }
                IkReal x1153 = ((1.0) * (x1155.value));
                if ((((npx * npx) + (npy * npy))) < -0.00001)
                  continue;
                CheckValue<IkReal> x1156 = IKPowWithIntegerCheck(IKabs(IKsqrt(((npx * npx) + (npy * npy)))), -1);
                if (!x1156.valid)
                {
                  continue;
                }
                if ((((0.4) * sj3 * sj4 * (x1156.value))) < -1 - IKFAST_SINCOS_THRESH ||
                    (((0.4) * sj3 * sj4 * (x1156.value))) > 1 + IKFAST_SINCOS_THRESH)
                  continue;
                IkReal x1154 = IKasin(((0.4) * sj3 * sj4 * (x1156.value)));
                j6array[0] = ((((-1.0) * x1153)) + (((-1.0) * x1154)));
                sj6array[0] = IKsin(j6array[0]);
                cj6array[0] = IKcos(j6array[0]);
                j6array[1] = ((3.14159265358979) + x1154 + (((-1.0) * x1153)));
                sj6array[1] = IKsin(j6array[1]);
                cj6array[1] = IKcos(j6array[1]);
                if (j6array[0] > IKPI)
                {
                  j6array[0] -= IK2PI;
                }
                else if (j6array[0] < -IKPI)
                {
                  j6array[0] += IK2PI;
                }
                j6valid[0] = true;
                if (j6array[1] > IKPI)
                {
                  j6array[1] -= IK2PI;
                }
                else if (j6array[1] < -IKPI)
                {
                  j6array[1] += IK2PI;
                }
                j6valid[1] = true;
                for (int ij6 = 0; ij6 < 2; ++ij6)
                {
                  if (!j6valid[ij6])
                  {
                    continue;
                  }
                  _ij6[0] = ij6;
                  _ij6[1] = -1;
                  for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                  {
                    if (j6valid[iij6] && IKabs(cj6array[ij6] - cj6array[iij6]) < IKFAST_SOLUTION_THRESH &&
                        IKabs(sj6array[ij6] - sj6array[iij6]) < IKFAST_SOLUTION_THRESH)
                    {
                      j6valid[iij6] = false;
                      _ij6[1] = iij6;
                      break;
                    }
                  }
                  j6 = j6array[ij6];
                  cj6 = cj6array[ij6];
                  sj6 = sj6array[ij6];

                  {
                    IkReal j5eval[3];
                    IkReal x1157 = (cj6 * npx);
                    IkReal x1158 = (npy * sj6);
                    IkReal x1159 = ((2.0) * cj3);
                    IkReal x1160 = ((5.0) * npz);
                    IkReal x1161 = ((0.8) * cj4 * sj3);
                    IkReal x1162 = (cj4 * npz * sj3);
                    j5eval[0] = (x1158 + x1162 + ((cj3 * x1158)) + (((-1.0) * cj3 * x1157)) + (((-1.0) * x1157)));
                    j5eval[1] = ((IKabs(((-0.8) + (((-1.6) * cj3)) + ((npz * x1160)) + (((-0.8) * (cj3 * cj3)))))) +
                                 (IKabs((x1161 + ((cj3 * x1161)) + ((x1158 * x1160)) + (((-1.0) * x1157 * x1160))))));
                    j5eval[2] = IKsign(((((-1.0) * x1157 * x1159)) + ((x1158 * x1159)) + (((2.0) * x1158)) +
                                        (((2.0) * x1162)) + (((-2.0) * x1157))));
                    if (IKabs(j5eval[0]) < 0.0000010000000000 || IKabs(j5eval[1]) < 0.0000010000000000 ||
                        IKabs(j5eval[2]) < 0.0000010000000000)
                    {
                      {
                        IkReal j5eval[3];
                        IkReal x1163 = cj3 * cj3;
                        IkReal x1164 = cj4 * cj4;
                        IkReal x1165 = ((10.0) * cj3);
                        IkReal x1166 = (npy * sj6);
                        IkReal x1167 = (cj6 * npx);
                        IkReal x1168 = ((4.0) * x1164);
                        IkReal x1169 = ((10.0) * cj4 * sj3);
                        j5eval[0] = ((1.0) + x1164 + x1163 + (((-1.0) * x1163 * x1164)) + (((2.0) * cj3)));
                        j5eval[1] =
                            IKsign(((4.0) + x1168 + (((8.0) * cj3)) + (((-1.0) * x1163 * x1168)) + (((4.0) * x1163))));
                        j5eval[2] = ((IKabs((((x1165 * x1167)) + ((npz * x1169)) + (((10.0) * x1167)) +
                                             (((-10.0) * x1166)) + (((-1.0) * x1165 * x1166))))) +
                                     (IKabs((((x1166 * x1169)) + (((10.0) * npz)) + ((npz * x1165)) +
                                             (((-1.0) * x1167 * x1169))))));
                        if (IKabs(j5eval[0]) < 0.0000010000000000 || IKabs(j5eval[1]) < 0.0000010000000000 ||
                            IKabs(j5eval[2]) < 0.0000010000000000)
                        {
                          {
                            IkReal j5eval[3];
                            IkReal x1170 = cj6 * cj6;
                            IkReal x1171 = npy * npy;
                            IkReal x1172 = npx * npx;
                            IkReal x1173 = npz * npz;
                            IkReal x1174 = ((2.0) * cj3);
                            IkReal x1175 = (cj6 * npx);
                            IkReal x1176 = ((2.0) * npz);
                            IkReal x1177 = (cj4 * sj3);
                            IkReal x1178 = ((2.0) * npy * sj6);
                            IkReal x1179 = (x1170 * x1171);
                            IkReal x1180 = (x1170 * x1172);
                            j5eval[0] = (x1180 + x1173 + x1171 + (((-1.0) * x1175 * x1178)) + (((-1.0) * x1179)));
                            j5eval[1] =
                                ((IKabs((((x1174 * x1175)) + ((x1176 * x1177)) + (((2.0) * x1175)) +
                                         (((-1.0) * npy * sj6 * x1174)) + (((-1.0) * x1178))))) +
                                 (IKabs((x1176 + ((x1177 * x1178)) + ((npz * x1174)) + (((-2.0) * x1175 * x1177))))));
                            j5eval[2] = IKsign(((((5.0) * x1180)) + (((-5.0) * x1179)) + (((5.0) * x1171)) +
                                                (((5.0) * x1173)) + (((-10.0) * npy * sj6 * x1175))));
                            if (IKabs(j5eval[0]) < 0.0000010000000000 || IKabs(j5eval[1]) < 0.0000010000000000 ||
                                IKabs(j5eval[2]) < 0.0000010000000000)
                            {
                              {
                                IkReal evalcond[2];
                                bool bgotonextstatement = true;
                                do
                                {
                                  evalcond[0] = ((-3.14159265358979) +
                                                 (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j3)))),
                                                         6.28318530717959)));
                                  evalcond[1] = pp;
                                  if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                      IKabs(evalcond[1]) < 0.0000050000000000)
                                  {
                                    bgotonextstatement = false;
                                    {
                                      IkReal j5eval[1];
                                      sj3 = 0;
                                      cj3 = -1.0;
                                      j3 = 3.14159265358979;
                                      j5eval[0] = IKabs((((cj6 * npx)) + (((-1.0) * npy * sj6))));
                                      if (IKabs(j5eval[0]) < 0.0000000100000000)
                                      {
                                        continue;  // no branches [j5]
                                      }
                                      else
                                      {
                                        IkReal op[2 + 1], zeror[2];
                                        int numroots;
                                        IkReal x1181 = (npy * sj6);
                                        IkReal x1182 = (cj6 * npx);
                                        op[0] = (x1182 + (((-1.0) * x1181)));
                                        op[1] = 0;
                                        op[2] = (x1181 + (((-1.0) * x1182)));
                                        polyroots2(op, zeror, numroots);
                                        IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
                                        int numsolutions = 0;
                                        for (int ij5 = 0; ij5 < numroots; ++ij5)
                                        {
                                          IkReal htj5 = zeror[ij5];
                                          tempj5array[0] = ((2.0) * (atan(htj5)));
                                          for (int kj5 = 0; kj5 < 1; ++kj5)
                                          {
                                            j5array[numsolutions] = tempj5array[kj5];
                                            if (j5array[numsolutions] > IKPI)
                                            {
                                              j5array[numsolutions] -= IK2PI;
                                            }
                                            else if (j5array[numsolutions] < -IKPI)
                                            {
                                              j5array[numsolutions] += IK2PI;
                                            }
                                            sj5array[numsolutions] = IKsin(j5array[numsolutions]);
                                            cj5array[numsolutions] = IKcos(j5array[numsolutions]);
                                            numsolutions++;
                                          }
                                        }
                                        bool j5valid[2] = { true, true };
                                        _nj5 = 2;
                                        for (int ij5 = 0; ij5 < numsolutions; ++ij5)
                                        {
                                          if (!j5valid[ij5])
                                          {
                                            continue;
                                          }
                                          j5 = j5array[ij5];
                                          cj5 = cj5array[ij5];
                                          sj5 = sj5array[ij5];
                                          htj5 = IKtan(j5 / 2);

                                          _ij5[0] = ij5;
                                          _ij5[1] = -1;
                                          for (int iij5 = ij5 + 1; iij5 < numsolutions; ++iij5)
                                          {
                                            if (j5valid[iij5] &&
                                                IKabs(cj5array[ij5] - cj5array[iij5]) < IKFAST_SOLUTION_THRESH &&
                                                IKabs(sj5array[ij5] - sj5array[iij5]) < IKFAST_SOLUTION_THRESH)
                                            {
                                              j5valid[iij5] = false;
                                              _ij5[1] = iij5;
                                              break;
                                            }
                                          }
                                          rotationfunction0(solutions);
                                        }
                                      }
                                    }
                                  }
                                } while (0);
                                if (bgotonextstatement)
                                {
                                  bool bgotonextstatement = true;
                                  do
                                  {
                                    if (1)
                                    {
                                      bgotonextstatement = false;
                                      continue;  // branch miss [j5]
                                    }
                                  } while (0);
                                  if (bgotonextstatement)
                                  {
                                  }
                                }
                              }
                            }
                            else
                            {
                              {
                                IkReal j5array[1], cj5array[1], sj5array[1];
                                bool j5valid[1] = { false };
                                _nj5 = 1;
                                IkReal x1183 = cj6 * cj6;
                                IkReal x1184 = npy * npy;
                                IkReal x1185 = (npy * sj6);
                                IkReal x1186 = ((2.0) * cj3);
                                IkReal x1187 = (cj6 * npx);
                                IkReal x1188 = ((2.0) * npz);
                                IkReal x1189 = (cj4 * sj3);
                                IkReal x1190 = ((5.0) * x1184);
                                CheckValue<IkReal> x1191 = IKPowWithIntegerCheck(
                                    IKsign((x1190 + (((-10.0) * x1185 * x1187)) + (((5.0) * (npz * npz))) +
                                            (((-1.0) * x1183 * x1190)) + (((5.0) * x1183 * (npx * npx))))),
                                    -1);
                                if (!x1191.valid)
                                {
                                  continue;
                                }
                                CheckValue<IkReal> x1192 =
                                    IKatan2WithCheck(IkReal((((x1186 * x1187)) + ((x1188 * x1189)) + (((2.0) * x1187)) +
                                                             (((-2.0) * x1185)) + (((-1.0) * x1185 * x1186)))),
                                                     IkReal(((((2.0) * x1185 * x1189)) + x1188 +
                                                             (((-2.0) * x1187 * x1189)) + ((npz * x1186)))),
                                                     IKFAST_ATAN2_MAGTHRESH);
                                if (!x1192.valid)
                                {
                                  continue;
                                }
                                j5array[0] =
                                    ((-1.5707963267949) + (((1.5707963267949) * (x1191.value))) + (x1192.value));
                                sj5array[0] = IKsin(j5array[0]);
                                cj5array[0] = IKcos(j5array[0]);
                                if (j5array[0] > IKPI)
                                {
                                  j5array[0] -= IK2PI;
                                }
                                else if (j5array[0] < -IKPI)
                                {
                                  j5array[0] += IK2PI;
                                }
                                j5valid[0] = true;
                                for (int ij5 = 0; ij5 < 1; ++ij5)
                                {
                                  if (!j5valid[ij5])
                                  {
                                    continue;
                                  }
                                  _ij5[0] = ij5;
                                  _ij5[1] = -1;
                                  for (int iij5 = ij5 + 1; iij5 < 1; ++iij5)
                                  {
                                    if (j5valid[iij5] &&
                                        IKabs(cj5array[ij5] - cj5array[iij5]) < IKFAST_SOLUTION_THRESH &&
                                        IKabs(sj5array[ij5] - sj5array[iij5]) < IKFAST_SOLUTION_THRESH)
                                    {
                                      j5valid[iij5] = false;
                                      _ij5[1] = iij5;
                                      break;
                                    }
                                  }
                                  j5 = j5array[ij5];
                                  cj5 = cj5array[ij5];
                                  sj5 = sj5array[ij5];
                                  {
                                    IkReal evalcond[4];
                                    IkReal x1193 = IKcos(j5);
                                    IkReal x1194 = IKsin(j5);
                                    IkReal x1195 = (npy * sj6);
                                    IkReal x1196 = ((1.0) * npz);
                                    IkReal x1197 = ((1.0) * cj6 * npx);
                                    IkReal x1198 = ((0.4) * cj4 * sj3);
                                    IkReal x1199 = ((0.4) * x1194);
                                    IkReal x1200 = ((0.4) * x1193);
                                    evalcond[0] = (x1200 + ((x1194 * x1198)) + (((-1.0) * x1196)) + ((cj3 * x1200)));
                                    evalcond[1] = ((((-1.0) * x1193 * x1197)) + (((-1.0) * x1198)) + ((npz * x1194)) +
                                                   ((x1193 * x1195)));
                                    evalcond[2] = ((0.4) + (((-1.0) * x1193 * x1196)) + ((x1194 * x1195)) +
                                                   (((-1.0) * x1194 * x1197)) + (((0.4) * cj3)));
                                    evalcond[3] = (x1199 + x1195 + (((-1.0) * x1193 * x1198)) + (((-1.0) * x1197)) +
                                                   ((cj3 * x1199)));
                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                    {
                                      continue;
                                    }
                                  }

                                  rotationfunction0(solutions);
                                }
                              }
                            }
                          }
                        }
                        else
                        {
                          {
                            IkReal j5array[1], cj5array[1], sj5array[1];
                            bool j5valid[1] = { false };
                            _nj5 = 1;
                            IkReal x1201 = cj3 * cj3;
                            IkReal x1202 = cj4 * cj4;
                            IkReal x1203 = ((10.0) * cj3);
                            IkReal x1204 = (npy * sj6);
                            IkReal x1205 = (cj6 * npx);
                            IkReal x1206 = ((10.0) * cj4 * sj3);
                            IkReal x1207 = ((4.0) * x1202);
                            CheckValue<IkReal> x1208 =
                                IKPowWithIntegerCheck(IKsign(((4.0) + x1207 + (((8.0) * cj3)) + (((4.0) * x1201)) +
                                                              (((-1.0) * x1201 * x1207)))),
                                                      -1);
                            if (!x1208.valid)
                            {
                              continue;
                            }
                            CheckValue<IkReal> x1209 =
                                IKatan2WithCheck(IkReal(((((-10.0) * x1204)) + (((10.0) * x1205)) + ((npz * x1206)) +
                                                         ((x1203 * x1205)) + (((-1.0) * x1203 * x1204)))),
                                                 IkReal((((x1204 * x1206)) + (((10.0) * npz)) + ((npz * x1203)) +
                                                         (((-1.0) * x1205 * x1206)))),
                                                 IKFAST_ATAN2_MAGTHRESH);
                            if (!x1209.valid)
                            {
                              continue;
                            }
                            j5array[0] = ((-1.5707963267949) + (((1.5707963267949) * (x1208.value))) + (x1209.value));
                            sj5array[0] = IKsin(j5array[0]);
                            cj5array[0] = IKcos(j5array[0]);
                            if (j5array[0] > IKPI)
                            {
                              j5array[0] -= IK2PI;
                            }
                            else if (j5array[0] < -IKPI)
                            {
                              j5array[0] += IK2PI;
                            }
                            j5valid[0] = true;
                            for (int ij5 = 0; ij5 < 1; ++ij5)
                            {
                              if (!j5valid[ij5])
                              {
                                continue;
                              }
                              _ij5[0] = ij5;
                              _ij5[1] = -1;
                              for (int iij5 = ij5 + 1; iij5 < 1; ++iij5)
                              {
                                if (j5valid[iij5] && IKabs(cj5array[ij5] - cj5array[iij5]) < IKFAST_SOLUTION_THRESH &&
                                    IKabs(sj5array[ij5] - sj5array[iij5]) < IKFAST_SOLUTION_THRESH)
                                {
                                  j5valid[iij5] = false;
                                  _ij5[1] = iij5;
                                  break;
                                }
                              }
                              j5 = j5array[ij5];
                              cj5 = cj5array[ij5];
                              sj5 = sj5array[ij5];
                              {
                                IkReal evalcond[4];
                                IkReal x1210 = IKcos(j5);
                                IkReal x1211 = IKsin(j5);
                                IkReal x1212 = (npy * sj6);
                                IkReal x1213 = ((1.0) * npz);
                                IkReal x1214 = ((1.0) * cj6 * npx);
                                IkReal x1215 = ((0.4) * cj4 * sj3);
                                IkReal x1216 = ((0.4) * x1211);
                                IkReal x1217 = ((0.4) * x1210);
                                evalcond[0] = (x1217 + ((cj3 * x1217)) + ((x1211 * x1215)) + (((-1.0) * x1213)));
                                evalcond[1] = (((x1210 * x1212)) + ((npz * x1211)) + (((-1.0) * x1210 * x1214)) +
                                               (((-1.0) * x1215)));
                                evalcond[2] = ((0.4) + (((0.4) * cj3)) + (((-1.0) * x1210 * x1213)) +
                                               (((-1.0) * x1211 * x1214)) + ((x1211 * x1212)));
                                evalcond[3] =
                                    (x1212 + x1216 + (((-1.0) * x1210 * x1215)) + ((cj3 * x1216)) + (((-1.0) * x1214)));
                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                {
                                  continue;
                                }
                              }

                              rotationfunction0(solutions);
                            }
                          }
                        }
                      }
                    }
                    else
                    {
                      {
                        IkReal j5array[1], cj5array[1], sj5array[1];
                        bool j5valid[1] = { false };
                        _nj5 = 1;
                        IkReal x1218 = (npy * sj6);
                        IkReal x1219 = (cj6 * npx);
                        IkReal x1220 = ((2.0) * cj3);
                        IkReal x1221 = ((5.0) * npz);
                        IkReal x1222 = ((0.8) * cj4 * sj3);
                        CheckValue<IkReal> x1223 = IKatan2WithCheck(
                            IkReal(((-0.8) + ((npz * x1221)) + (((-1.6) * cj3)) + (((-0.8) * (cj3 * cj3))))),
                            IkReal((x1222 + ((cj3 * x1222)) + ((x1218 * x1221)) + (((-1.0) * x1219 * x1221)))),
                            IKFAST_ATAN2_MAGTHRESH);
                        if (!x1223.valid)
                        {
                          continue;
                        }
                        CheckValue<IkReal> x1224 = IKPowWithIntegerCheck(
                            IKsign((((x1218 * x1220)) + (((2.0) * x1218)) + (((-1.0) * x1219 * x1220)) +
                                    (((-2.0) * x1219)) + (((2.0) * cj4 * npz * sj3)))),
                            -1);
                        if (!x1224.valid)
                        {
                          continue;
                        }
                        j5array[0] = ((-1.5707963267949) + (x1223.value) + (((1.5707963267949) * (x1224.value))));
                        sj5array[0] = IKsin(j5array[0]);
                        cj5array[0] = IKcos(j5array[0]);
                        if (j5array[0] > IKPI)
                        {
                          j5array[0] -= IK2PI;
                        }
                        else if (j5array[0] < -IKPI)
                        {
                          j5array[0] += IK2PI;
                        }
                        j5valid[0] = true;
                        for (int ij5 = 0; ij5 < 1; ++ij5)
                        {
                          if (!j5valid[ij5])
                          {
                            continue;
                          }
                          _ij5[0] = ij5;
                          _ij5[1] = -1;
                          for (int iij5 = ij5 + 1; iij5 < 1; ++iij5)
                          {
                            if (j5valid[iij5] && IKabs(cj5array[ij5] - cj5array[iij5]) < IKFAST_SOLUTION_THRESH &&
                                IKabs(sj5array[ij5] - sj5array[iij5]) < IKFAST_SOLUTION_THRESH)
                            {
                              j5valid[iij5] = false;
                              _ij5[1] = iij5;
                              break;
                            }
                          }
                          j5 = j5array[ij5];
                          cj5 = cj5array[ij5];
                          sj5 = sj5array[ij5];
                          {
                            IkReal evalcond[4];
                            IkReal x1225 = IKcos(j5);
                            IkReal x1226 = IKsin(j5);
                            IkReal x1227 = (npy * sj6);
                            IkReal x1228 = ((1.0) * npz);
                            IkReal x1229 = ((1.0) * cj6 * npx);
                            IkReal x1230 = ((0.4) * cj4 * sj3);
                            IkReal x1231 = ((0.4) * x1226);
                            IkReal x1232 = ((0.4) * x1225);
                            evalcond[0] = (((cj3 * x1232)) + x1232 + (((-1.0) * x1228)) + ((x1226 * x1230)));
                            evalcond[1] =
                                (((npz * x1226)) + (((-1.0) * x1225 * x1229)) + (((-1.0) * x1230)) + ((x1225 * x1227)));
                            evalcond[2] = ((0.4) + (((-1.0) * x1225 * x1228)) + (((0.4) * cj3)) +
                                           (((-1.0) * x1226 * x1229)) + ((x1226 * x1227)));
                            evalcond[3] =
                                (((cj3 * x1231)) + x1231 + x1227 + (((-1.0) * x1225 * x1230)) + (((-1.0) * x1229)));
                            if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                            {
                              continue;
                            }
                          }

                          rotationfunction0(solutions);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    return solutions.GetNumSolutions() > 0;
  }
  inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions)
  {
    for (int rotationiter = 0; rotationiter < 1; ++rotationiter)
    {
      IkReal x76 = (r02 * sj5);
      IkReal x77 = ((1.0) * cj5);
      IkReal x78 = ((1.0) * sj6);
      IkReal x79 = ((1.0) * cj4);
      IkReal x80 = ((1.0) * cj3);
      IkReal x81 = ((1.0) * sj4);
      IkReal x82 = ((1.0) * cj6);
      IkReal x83 = ((((-1.0) * r01 * x78)) + ((cj6 * r00)));
      IkReal x84 = (((cj6 * r10)) + (((-1.0) * r11 * x78)));
      IkReal x85 = ((((-1.0) * r21 * x78)) + ((cj6 * r20)));
      IkReal x86 = ((((-1.0) * r00 * x78)) + (((-1.0) * r01 * x82)));
      IkReal x87 = ((((-1.0) * r11 * x82)) + (((-1.0) * r10 * x78)));
      IkReal x88 = ((((-1.0) * r20 * x78)) + (((-1.0) * r21 * x82)));
      IkReal x89 = (((sj5 * x83)) + ((cj5 * r02)));
      IkReal x90 = ((((-1.0) * x77 * x83)) + x76);
      IkReal x91 = ((((-1.0) * x77 * x84)) + ((r12 * sj5)));
      IkReal x92 = (((cj5 * r12)) + ((sj5 * x84)));
      IkReal x93 = (((r22 * sj5)) + (((-1.0) * x77 * x85)));
      IkReal x94 = (((cj5 * r22)) + ((sj5 * x85)));
      IkReal x95 = (sj4 * x86);
      IkReal x96 = ((1.0) * x88);
      IkReal x97 = ((((-1.0) * x81 * x87)) + ((cj4 * x91)));
      IkReal x98 = ((((-1.0) * x81 * x88)) + ((cj4 * x93)));
      new_r00 = ((((-1.0) * x80 * ((((cj4 * (((((-1.0) * cj5 * x83)) + x76)))) + (((-1.0) * x95)))))) + ((sj3 * x89)));
      new_r01 = ((((-1.0) * x79 * x86)) + (((-1.0) * x81 * x90)));
      new_r02 = (((cj3 * x89)) + ((sj3 * (((((-1.0) * x81 * x86)) + ((cj4 * x90)))))));
      new_r10 = (((sj3 * x92)) + (((-1.0) * x80 * x97)));
      new_r11 = ((((-1.0) * x79 * x87)) + (((-1.0) * x81 * x91)));
      new_r12 = (((sj3 * x97)) + ((cj3 * x92)));
      new_r20 = (((sj3 * x94)) + (((-1.0) * x80 * x98)));
      new_r21 = ((((-1.0) * x79 * x88)) + (((-1.0) * x81 * x93)));
      new_r22 = (((sj3 * x98)) + ((cj3 * x94)));
      {
        IkReal j1array[2], cj1array[2], sj1array[2];
        bool j1valid[2] = { false };
        _nj1 = 2;
        cj1array[0] = new_r22;
        if (cj1array[0] >= -1 - IKFAST_SINCOS_THRESH && cj1array[0] <= 1 + IKFAST_SINCOS_THRESH)
        {
          j1valid[0] = j1valid[1] = true;
          j1array[0] = IKacos(cj1array[0]);
          sj1array[0] = IKsin(j1array[0]);
          cj1array[1] = cj1array[0];
          j1array[1] = -j1array[0];
          sj1array[1] = -sj1array[0];
        }
        else if (isnan(cj1array[0]))
        {
          // probably any value will work
          j1valid[0] = true;
          cj1array[0] = 1;
          sj1array[0] = 0;
          j1array[0] = 0;
        }
        for (int ij1 = 0; ij1 < 2; ++ij1)
        {
          if (!j1valid[ij1])
          {
            continue;
          }
          _ij1[0] = ij1;
          _ij1[1] = -1;
          for (int iij1 = ij1 + 1; iij1 < 2; ++iij1)
          {
            if (j1valid[iij1] && IKabs(cj1array[ij1] - cj1array[iij1]) < IKFAST_SOLUTION_THRESH &&
                IKabs(sj1array[ij1] - sj1array[iij1]) < IKFAST_SOLUTION_THRESH)
            {
              j1valid[iij1] = false;
              _ij1[1] = iij1;
              break;
            }
          }
          j1 = j1array[ij1];
          cj1 = cj1array[ij1];
          sj1 = sj1array[ij1];

          {
            IkReal j0eval[3];
            j0eval[0] = sj1;
            j0eval[1] = ((IKabs(new_r12)) + (IKabs(new_r02)));
            j0eval[2] = IKsign(sj1);
            if (IKabs(j0eval[0]) < 0.0000010000000000 || IKabs(j0eval[1]) < 0.0000010000000000 ||
                IKabs(j0eval[2]) < 0.0000010000000000)
            {
              {
                IkReal j2eval[3];
                j2eval[0] = sj1;
                j2eval[1] = IKsign(sj1);
                j2eval[2] = ((IKabs(new_r20)) + (IKabs(new_r21)));
                if (IKabs(j2eval[0]) < 0.0000010000000000 || IKabs(j2eval[1]) < 0.0000010000000000 ||
                    IKabs(j2eval[2]) < 0.0000010000000000)
                {
                  {
                    IkReal j0eval[2];
                    j0eval[0] = new_r12;
                    j0eval[1] = sj1;
                    if (IKabs(j0eval[0]) < 0.0000010000000000 || IKabs(j0eval[1]) < 0.0000010000000000)
                    {
                      {
                        IkReal evalcond[5];
                        bool bgotonextstatement = true;
                        do
                        {
                          evalcond[0] =
                              ((-3.14159265358979) + (IKfmod(((3.14159265358979) + (IKabs(j1))), 6.28318530717959)));
                          evalcond[1] = new_r21;
                          evalcond[2] = new_r02;
                          evalcond[3] = new_r12;
                          evalcond[4] = new_r20;
                          if (IKabs(evalcond[0]) < 0.0000050000000000 && IKabs(evalcond[1]) < 0.0000050000000000 &&
                              IKabs(evalcond[2]) < 0.0000050000000000 && IKabs(evalcond[3]) < 0.0000050000000000 &&
                              IKabs(evalcond[4]) < 0.0000050000000000)
                          {
                            bgotonextstatement = false;
                            IkReal j2mul = 1;
                            j2 = 0;
                            j0mul = -1.0;
                            if (IKabs(((-1.0) * new_r10)) < IKFAST_ATAN2_MAGTHRESH &&
                                IKabs(((-1.0) * new_r00)) < IKFAST_ATAN2_MAGTHRESH &&
                                IKabs(IKsqr(((-1.0) * new_r10)) + IKsqr(((-1.0) * new_r00)) - 1) <=
                                    IKFAST_SINCOS_THRESH)
                              continue;
                            j0 = IKatan2(((-1.0) * new_r10), ((-1.0) * new_r00));
                            {
                              std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                              vinfos[0].jointtype = 1;
                              vinfos[0].foffset = j0;
                              vinfos[0].fmul = j0mul;
                              vinfos[0].freeind = 0;
                              vinfos[0].maxsolutions = 0;
                              vinfos[1].jointtype = 1;
                              vinfos[1].foffset = j1;
                              vinfos[1].indices[0] = _ij1[0];
                              vinfos[1].indices[1] = _ij1[1];
                              vinfos[1].maxsolutions = _nj1;
                              vinfos[2].jointtype = 1;
                              vinfos[2].foffset = j2;
                              vinfos[2].fmul = j2mul;
                              vinfos[2].freeind = 0;
                              vinfos[2].maxsolutions = 0;
                              vinfos[3].jointtype = 1;
                              vinfos[3].foffset = j3;
                              vinfos[3].indices[0] = _ij3[0];
                              vinfos[3].indices[1] = _ij3[1];
                              vinfos[3].maxsolutions = _nj3;
                              vinfos[4].jointtype = 1;
                              vinfos[4].foffset = j4;
                              vinfos[4].indices[0] = _ij4[0];
                              vinfos[4].indices[1] = _ij4[1];
                              vinfos[4].maxsolutions = _nj4;
                              vinfos[5].jointtype = 1;
                              vinfos[5].foffset = j5;
                              vinfos[5].indices[0] = _ij5[0];
                              vinfos[5].indices[1] = _ij5[1];
                              vinfos[5].maxsolutions = _nj5;
                              vinfos[6].jointtype = 1;
                              vinfos[6].foffset = j6;
                              vinfos[6].indices[0] = _ij6[0];
                              vinfos[6].indices[1] = _ij6[1];
                              vinfos[6].maxsolutions = _nj6;
                              std::vector<int> vfree(1);
                              vfree[0] = 2;
                              solutions.AddSolution(vinfos, vfree);
                            }
                          }
                        } while (0);
                        if (bgotonextstatement)
                        {
                          bool bgotonextstatement = true;
                          do
                          {
                            evalcond[0] = ((-3.14159265358979) +
                                           (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j1)))),
                                                   6.28318530717959)));
                            evalcond[1] = new_r21;
                            evalcond[2] = new_r02;
                            evalcond[3] = new_r12;
                            evalcond[4] = new_r20;
                            if (IKabs(evalcond[0]) < 0.0000050000000000 && IKabs(evalcond[1]) < 0.0000050000000000 &&
                                IKabs(evalcond[2]) < 0.0000050000000000 && IKabs(evalcond[3]) < 0.0000050000000000 &&
                                IKabs(evalcond[4]) < 0.0000050000000000)
                            {
                              bgotonextstatement = false;
                              IkReal j2mul = 1;
                              j2 = 0;
                              j0mul = 1.0;
                              if (IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH &&
                                  IKabs(((-1.0) * new_r11)) < IKFAST_ATAN2_MAGTHRESH &&
                                  IKabs(IKsqr(new_r10) + IKsqr(((-1.0) * new_r11)) - 1) <= IKFAST_SINCOS_THRESH)
                                continue;
                              j0 = IKatan2(new_r10, ((-1.0) * new_r11));
                              {
                                std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                vinfos[0].jointtype = 1;
                                vinfos[0].foffset = j0;
                                vinfos[0].fmul = j0mul;
                                vinfos[0].freeind = 0;
                                vinfos[0].maxsolutions = 0;
                                vinfos[1].jointtype = 1;
                                vinfos[1].foffset = j1;
                                vinfos[1].indices[0] = _ij1[0];
                                vinfos[1].indices[1] = _ij1[1];
                                vinfos[1].maxsolutions = _nj1;
                                vinfos[2].jointtype = 1;
                                vinfos[2].foffset = j2;
                                vinfos[2].fmul = j2mul;
                                vinfos[2].freeind = 0;
                                vinfos[2].maxsolutions = 0;
                                vinfos[3].jointtype = 1;
                                vinfos[3].foffset = j3;
                                vinfos[3].indices[0] = _ij3[0];
                                vinfos[3].indices[1] = _ij3[1];
                                vinfos[3].maxsolutions = _nj3;
                                vinfos[4].jointtype = 1;
                                vinfos[4].foffset = j4;
                                vinfos[4].indices[0] = _ij4[0];
                                vinfos[4].indices[1] = _ij4[1];
                                vinfos[4].maxsolutions = _nj4;
                                vinfos[5].jointtype = 1;
                                vinfos[5].foffset = j5;
                                vinfos[5].indices[0] = _ij5[0];
                                vinfos[5].indices[1] = _ij5[1];
                                vinfos[5].maxsolutions = _nj5;
                                vinfos[6].jointtype = 1;
                                vinfos[6].foffset = j6;
                                vinfos[6].indices[0] = _ij6[0];
                                vinfos[6].indices[1] = _ij6[1];
                                vinfos[6].maxsolutions = _nj6;
                                std::vector<int> vfree(1);
                                vfree[0] = 2;
                                solutions.AddSolution(vinfos, vfree);
                              }
                            }
                          } while (0);
                          if (bgotonextstatement)
                          {
                            bool bgotonextstatement = true;
                            do
                            {
                              evalcond[0] = ((IKabs(new_r12)) + (IKabs(new_r02)));
                              if (IKabs(evalcond[0]) < 0.0000050000000000)
                              {
                                bgotonextstatement = false;
                                {
                                  IkReal j0eval[1];
                                  new_r02 = 0;
                                  new_r12 = 0;
                                  new_r20 = 0;
                                  new_r21 = 0;
                                  IkReal x99 = new_r22 * new_r22;
                                  IkReal x100 = ((16.0) * new_r10);
                                  IkReal x101 = ((16.0) * new_r01);
                                  IkReal x102 = ((16.0) * new_r22);
                                  IkReal x103 = ((8.0) * new_r11);
                                  IkReal x104 = ((8.0) * new_r00);
                                  IkReal x105 = (x100 * x99);
                                  IkReal x106 = (x101 * x99);
                                  j0eval[0] =
                                      ((IKabs(
                                           ((((16.0) * new_r00)) + (((-32.0) * new_r00 * x99)) + ((new_r11 * x102))))) +
                                       (IKabs(((((-1.0) * x105)) + x100))) + (IKabs(((((-1.0) * x100)) + x105))) +
                                       (IKabs(((((32.0) * new_r11)) + (((-1.0) * new_r00 * x102)) +
                                               (((-16.0) * new_r11 * x99))))) +
                                       (IKabs(((((-1.0) * x101)) + x106))) +
                                       (IKabs((((x103 * x99)) + (((-1.0) * new_r22 * x104))))) +
                                       (IKabs((((new_r22 * x103)) + (((-1.0) * x104))))) +
                                       (IKabs(((((-1.0) * x106)) + x101))));
                                  if (IKabs(j0eval[0]) < 0.0000000100000000)
                                  {
                                    continue;  // no branches [j0, j2]
                                  }
                                  else
                                  {
                                    IkReal op[4 + 1], zeror[4];
                                    int numroots;
                                    IkReal j0evalpoly[1];
                                    IkReal x107 = new_r22 * new_r22;
                                    IkReal x108 = ((16.0) * new_r10);
                                    IkReal x109 = (new_r11 * new_r22);
                                    IkReal x110 = (x107 * x108);
                                    IkReal x111 = ((((8.0) * x109)) + (((-8.0) * new_r00)));
                                    op[0] = x111;
                                    op[1] = ((((-1.0) * x110)) + x108);
                                    op[2] = ((((16.0) * x109)) + (((-32.0) * new_r00 * x107)) + (((16.0) * new_r00)));
                                    op[3] = ((((-1.0) * x108)) + x110);
                                    op[4] = x111;
                                    polyroots4(op, zeror, numroots);
                                    IkReal j0array[4], cj0array[4], sj0array[4], tempj0array[1];
                                    int numsolutions = 0;
                                    for (int ij0 = 0; ij0 < numroots; ++ij0)
                                    {
                                      IkReal htj0 = zeror[ij0];
                                      tempj0array[0] = ((2.0) * (atan(htj0)));
                                      for (int kj0 = 0; kj0 < 1; ++kj0)
                                      {
                                        j0array[numsolutions] = tempj0array[kj0];
                                        if (j0array[numsolutions] > IKPI)
                                        {
                                          j0array[numsolutions] -= IK2PI;
                                        }
                                        else if (j0array[numsolutions] < -IKPI)
                                        {
                                          j0array[numsolutions] += IK2PI;
                                        }
                                        sj0array[numsolutions] = IKsin(j0array[numsolutions]);
                                        cj0array[numsolutions] = IKcos(j0array[numsolutions]);
                                        numsolutions++;
                                      }
                                    }
                                    bool j0valid[4] = { true, true, true, true };
                                    _nj0 = 4;
                                    for (int ij0 = 0; ij0 < numsolutions; ++ij0)
                                    {
                                      if (!j0valid[ij0])
                                      {
                                        continue;
                                      }
                                      j0 = j0array[ij0];
                                      cj0 = cj0array[ij0];
                                      sj0 = sj0array[ij0];
                                      htj0 = IKtan(j0 / 2);

                                      IkReal x112 = ((16.0) * new_r01);
                                      IkReal x113 = new_r22 * new_r22;
                                      IkReal x114 = (new_r00 * new_r22);
                                      IkReal x115 = ((8.0) * x114);
                                      IkReal x116 = (new_r11 * x113);
                                      IkReal x117 = (x112 * x113);
                                      IkReal x118 = ((8.0) * x116);
                                      j0evalpoly[0] =
                                          (((htj0 * (((((-1.0) * x117)) + x112)))) +
                                           (((htj0 * htj0 * htj0) * (((((-1.0) * x112)) + x117)))) + (((-1.0) * x115)) +
                                           x118 +
                                           (((htj0 * htj0) *
                                             (((((32.0) * new_r11)) + (((-16.0) * x114)) + (((-16.0) * x116)))))) +
                                           (((htj0 * htj0 * htj0 * htj0) * (((((-1.0) * x115)) + x118)))));
                                      if (IKabs(j0evalpoly[0]) > 0.0000001000000000)
                                      {
                                        continue;
                                      }
                                      _ij0[0] = ij0;
                                      _ij0[1] = -1;
                                      for (int iij0 = ij0 + 1; iij0 < numsolutions; ++iij0)
                                      {
                                        if (j0valid[iij0] &&
                                            IKabs(cj0array[ij0] - cj0array[iij0]) < IKFAST_SOLUTION_THRESH &&
                                            IKabs(sj0array[ij0] - sj0array[iij0]) < IKFAST_SOLUTION_THRESH)
                                        {
                                          j0valid[iij0] = false;
                                          _ij0[1] = iij0;
                                          break;
                                        }
                                      }
                                      {
                                        IkReal j2eval[3];
                                        new_r02 = 0;
                                        new_r12 = 0;
                                        new_r20 = 0;
                                        new_r21 = 0;
                                        IkReal x119 = cj0 * cj0;
                                        IkReal x120 = new_r22 * new_r22;
                                        IkReal x121 = ((1.0) * cj0);
                                        IkReal x122 = (new_r22 * sj0);
                                        IkReal x123 = (x120 + x119 + (((-1.0) * x119 * x120)));
                                        j2eval[0] = x123;
                                        j2eval[1] =
                                            ((IKabs(((((-1.0) * new_r10 * x122)) + (((-1.0) * new_r11 * x121))))) +
                                             (IKabs(((((-1.0) * new_r10 * x121)) + ((new_r11 * x122))))));
                                        j2eval[2] = IKsign(x123);
                                        if (IKabs(j2eval[0]) < 0.0000010000000000 ||
                                            IKabs(j2eval[1]) < 0.0000010000000000 ||
                                            IKabs(j2eval[2]) < 0.0000010000000000)
                                        {
                                          {
                                            IkReal j2eval[1];
                                            new_r02 = 0;
                                            new_r12 = 0;
                                            new_r20 = 0;
                                            new_r21 = 0;
                                            j2eval[0] = new_r22;
                                            if (IKabs(j2eval[0]) < 0.0000010000000000)
                                            {
                                              {
                                                IkReal j2eval[1];
                                                new_r02 = 0;
                                                new_r12 = 0;
                                                new_r20 = 0;
                                                new_r21 = 0;
                                                j2eval[0] = cj0;
                                                if (IKabs(j2eval[0]) < 0.0000010000000000)
                                                {
                                                  {
                                                    IkReal evalcond[1];
                                                    bool bgotonextstatement = true;
                                                    do
                                                    {
                                                      evalcond[0] = ((-3.14159265358979) +
                                                                     (IKfmod(((3.14159265358979) +
                                                                              (IKabs(((-1.5707963267949) + j0)))),
                                                                             6.28318530717959)));
                                                      if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                      {
                                                        bgotonextstatement = false;
                                                        {
                                                          IkReal j2array[1], cj2array[1], sj2array[1];
                                                          bool j2valid[1] = { false };
                                                          _nj2 = 1;
                                                          if (IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH &&
                                                              IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH &&
                                                              IKabs(IKsqr(new_r00) + IKsqr(new_r01) - 1) <=
                                                                  IKFAST_SINCOS_THRESH)
                                                            continue;
                                                          j2array[0] = IKatan2(new_r00, new_r01);
                                                          sj2array[0] = IKsin(j2array[0]);
                                                          cj2array[0] = IKcos(j2array[0]);
                                                          if (j2array[0] > IKPI)
                                                          {
                                                            j2array[0] -= IK2PI;
                                                          }
                                                          else if (j2array[0] < -IKPI)
                                                          {
                                                            j2array[0] += IK2PI;
                                                          }
                                                          j2valid[0] = true;
                                                          for (int ij2 = 0; ij2 < 1; ++ij2)
                                                          {
                                                            if (!j2valid[ij2])
                                                            {
                                                              continue;
                                                            }
                                                            _ij2[0] = ij2;
                                                            _ij2[1] = -1;
                                                            for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                            {
                                                              if (j2valid[iij2] &&
                                                                  IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                      IKFAST_SOLUTION_THRESH &&
                                                                  IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                      IKFAST_SOLUTION_THRESH)
                                                              {
                                                                j2valid[iij2] = false;
                                                                _ij2[1] = iij2;
                                                                break;
                                                              }
                                                            }
                                                            j2 = j2array[ij2];
                                                            cj2 = cj2array[ij2];
                                                            sj2 = sj2array[ij2];
                                                            {
                                                              IkReal evalcond[4];
                                                              IkReal x124 = IKsin(j2);
                                                              IkReal x125 = IKcos(j2);
                                                              evalcond[0] = x125;
                                                              evalcond[1] = ((-1.0) * x124);
                                                              evalcond[2] = (x124 + (((-1.0) * new_r00)));
                                                              evalcond[3] = (x125 + (((-1.0) * new_r01)));
                                                              if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                                              {
                                                                continue;
                                                              }
                                                            }

                                                            {
                                                              std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                              vinfos[0].jointtype = 1;
                                                              vinfos[0].foffset = j0;
                                                              vinfos[0].indices[0] = _ij0[0];
                                                              vinfos[0].indices[1] = _ij0[1];
                                                              vinfos[0].maxsolutions = _nj0;
                                                              vinfos[1].jointtype = 1;
                                                              vinfos[1].foffset = j1;
                                                              vinfos[1].indices[0] = _ij1[0];
                                                              vinfos[1].indices[1] = _ij1[1];
                                                              vinfos[1].maxsolutions = _nj1;
                                                              vinfos[2].jointtype = 1;
                                                              vinfos[2].foffset = j2;
                                                              vinfos[2].indices[0] = _ij2[0];
                                                              vinfos[2].indices[1] = _ij2[1];
                                                              vinfos[2].maxsolutions = _nj2;
                                                              vinfos[3].jointtype = 1;
                                                              vinfos[3].foffset = j3;
                                                              vinfos[3].indices[0] = _ij3[0];
                                                              vinfos[3].indices[1] = _ij3[1];
                                                              vinfos[3].maxsolutions = _nj3;
                                                              vinfos[4].jointtype = 1;
                                                              vinfos[4].foffset = j4;
                                                              vinfos[4].indices[0] = _ij4[0];
                                                              vinfos[4].indices[1] = _ij4[1];
                                                              vinfos[4].maxsolutions = _nj4;
                                                              vinfos[5].jointtype = 1;
                                                              vinfos[5].foffset = j5;
                                                              vinfos[5].indices[0] = _ij5[0];
                                                              vinfos[5].indices[1] = _ij5[1];
                                                              vinfos[5].maxsolutions = _nj5;
                                                              vinfos[6].jointtype = 1;
                                                              vinfos[6].foffset = j6;
                                                              vinfos[6].indices[0] = _ij6[0];
                                                              vinfos[6].indices[1] = _ij6[1];
                                                              vinfos[6].maxsolutions = _nj6;
                                                              std::vector<int> vfree(0);
                                                              solutions.AddSolution(vinfos, vfree);
                                                            }
                                                          }
                                                        }
                                                      }
                                                    } while (0);
                                                    if (bgotonextstatement)
                                                    {
                                                      bool bgotonextstatement = true;
                                                      do
                                                      {
                                                        evalcond[0] = ((-3.14159265358979) +
                                                                       (IKfmod(((3.14159265358979) +
                                                                                (IKabs(((1.5707963267949) + j0)))),
                                                                               6.28318530717959)));
                                                        if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                        {
                                                          bgotonextstatement = false;
                                                          {
                                                            IkReal j2array[1], cj2array[1], sj2array[1];
                                                            bool j2valid[1] = { false };
                                                            _nj2 = 1;
                                                            if (IKabs(((-1.0) * new_r00)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                IKabs(((-1.0) * new_r01)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                IKabs(IKsqr(((-1.0) * new_r00)) +
                                                                      IKsqr(((-1.0) * new_r01)) - 1) <=
                                                                    IKFAST_SINCOS_THRESH)
                                                              continue;
                                                            j2array[0] =
                                                                IKatan2(((-1.0) * new_r00), ((-1.0) * new_r01));
                                                            sj2array[0] = IKsin(j2array[0]);
                                                            cj2array[0] = IKcos(j2array[0]);
                                                            if (j2array[0] > IKPI)
                                                            {
                                                              j2array[0] -= IK2PI;
                                                            }
                                                            else if (j2array[0] < -IKPI)
                                                            {
                                                              j2array[0] += IK2PI;
                                                            }
                                                            j2valid[0] = true;
                                                            for (int ij2 = 0; ij2 < 1; ++ij2)
                                                            {
                                                              if (!j2valid[ij2])
                                                              {
                                                                continue;
                                                              }
                                                              _ij2[0] = ij2;
                                                              _ij2[1] = -1;
                                                              for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                              {
                                                                if (j2valid[iij2] &&
                                                                    IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                        IKFAST_SOLUTION_THRESH &&
                                                                    IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                        IKFAST_SOLUTION_THRESH)
                                                                {
                                                                  j2valid[iij2] = false;
                                                                  _ij2[1] = iij2;
                                                                  break;
                                                                }
                                                              }
                                                              j2 = j2array[ij2];
                                                              cj2 = cj2array[ij2];
                                                              sj2 = sj2array[ij2];
                                                              {
                                                                IkReal evalcond[4];
                                                                IkReal x126 = IKcos(j2);
                                                                IkReal x127 = IKsin(j2);
                                                                evalcond[0] = x126;
                                                                evalcond[1] = (x127 + new_r00);
                                                                evalcond[2] = (x126 + new_r01);
                                                                evalcond[3] = ((-1.0) * x127);
                                                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH)
                                                                {
                                                                  continue;
                                                                }
                                                              }

                                                              {
                                                                std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                                vinfos[0].jointtype = 1;
                                                                vinfos[0].foffset = j0;
                                                                vinfos[0].indices[0] = _ij0[0];
                                                                vinfos[0].indices[1] = _ij0[1];
                                                                vinfos[0].maxsolutions = _nj0;
                                                                vinfos[1].jointtype = 1;
                                                                vinfos[1].foffset = j1;
                                                                vinfos[1].indices[0] = _ij1[0];
                                                                vinfos[1].indices[1] = _ij1[1];
                                                                vinfos[1].maxsolutions = _nj1;
                                                                vinfos[2].jointtype = 1;
                                                                vinfos[2].foffset = j2;
                                                                vinfos[2].indices[0] = _ij2[0];
                                                                vinfos[2].indices[1] = _ij2[1];
                                                                vinfos[2].maxsolutions = _nj2;
                                                                vinfos[3].jointtype = 1;
                                                                vinfos[3].foffset = j3;
                                                                vinfos[3].indices[0] = _ij3[0];
                                                                vinfos[3].indices[1] = _ij3[1];
                                                                vinfos[3].maxsolutions = _nj3;
                                                                vinfos[4].jointtype = 1;
                                                                vinfos[4].foffset = j4;
                                                                vinfos[4].indices[0] = _ij4[0];
                                                                vinfos[4].indices[1] = _ij4[1];
                                                                vinfos[4].maxsolutions = _nj4;
                                                                vinfos[5].jointtype = 1;
                                                                vinfos[5].foffset = j5;
                                                                vinfos[5].indices[0] = _ij5[0];
                                                                vinfos[5].indices[1] = _ij5[1];
                                                                vinfos[5].maxsolutions = _nj5;
                                                                vinfos[6].jointtype = 1;
                                                                vinfos[6].foffset = j6;
                                                                vinfos[6].indices[0] = _ij6[0];
                                                                vinfos[6].indices[1] = _ij6[1];
                                                                vinfos[6].maxsolutions = _nj6;
                                                                std::vector<int> vfree(0);
                                                                solutions.AddSolution(vinfos, vfree);
                                                              }
                                                            }
                                                          }
                                                        }
                                                      } while (0);
                                                      if (bgotonextstatement)
                                                      {
                                                        bool bgotonextstatement = true;
                                                        do
                                                        {
                                                          IkReal x128 = new_r22 * new_r22;
                                                          CheckValue<IkReal> x129 =
                                                              IKPowWithIntegerCheck(((1.0) + (((-1.0) * x128))), -1);
                                                          if (!x129.valid)
                                                          {
                                                            continue;
                                                          }
                                                          if ((((-1.0) * x128 * (x129.value))) < -0.00001)
                                                            continue;
                                                          IkReal gconst12 = IKsqrt(((-1.0) * x128 * (x129.value)));
                                                          evalcond[0] =
                                                              ((-3.14159265358979) +
                                                               (IKfmod(((3.14159265358979) +
                                                                        (IKabs((cj0 + (((-1.0) * gconst12))))) +
                                                                        (IKabs(((-1.0) + (IKsign(sj0)))))),
                                                                       6.28318530717959)));
                                                          if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                          {
                                                            bgotonextstatement = false;
                                                            {
                                                              IkReal j2eval[1];
                                                              IkReal x130 = new_r22 * new_r22;
                                                              new_r02 = 0;
                                                              new_r12 = 0;
                                                              new_r20 = 0;
                                                              new_r21 = 0;
                                                              if ((((1.0) + (((-1.0) * (gconst12 * gconst12))))) <
                                                                  -0.00001)
                                                                continue;
                                                              sj0 =
                                                                  IKsqrt(((1.0) + (((-1.0) * (gconst12 * gconst12)))));
                                                              cj0 = gconst12;
                                                              if ((gconst12) < -1 - IKFAST_SINCOS_THRESH ||
                                                                  (gconst12) > 1 + IKFAST_SINCOS_THRESH)
                                                                continue;
                                                              j0 = IKacos(gconst12);
                                                              CheckValue<IkReal> x131 = IKPowWithIntegerCheck(
                                                                  ((1.0) + (((-1.0) * x130))), -1);
                                                              if (!x131.valid)
                                                              {
                                                                continue;
                                                              }
                                                              if ((((-1.0) * x130 * (x131.value))) < -0.00001)
                                                                continue;
                                                              IkReal gconst12 = IKsqrt(((-1.0) * x130 * (x131.value)));
                                                              j2eval[0] = ((IKabs(new_r11)) + (IKabs(new_r10)));
                                                              if (IKabs(j2eval[0]) < 0.0000010000000000)
                                                              {
                                                                {
                                                                  IkReal j2array[1], cj2array[1], sj2array[1];
                                                                  bool j2valid[1] = { false };
                                                                  _nj2 = 1;
                                                                  CheckValue<IkReal> x132 =
                                                                      IKPowWithIntegerCheck(gconst12, -1);
                                                                  if (!x132.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  if ((((1.0) + (((-1.0) * (gconst12 * gconst12))))) <
                                                                      -0.00001)
                                                                    continue;
                                                                  if (IKabs(((-1.0) * new_r10 * (x132.value))) <
                                                                          IKFAST_ATAN2_MAGTHRESH &&
                                                                      IKabs((((new_r01 *
                                                                               (IKsqrt(((1.0) +
                                                                                        (((-1.0) *
                                                                                          (gconst12 * gconst12)))))))) +
                                                                             (((-1.0) * gconst12 * new_r11)))) <
                                                                          IKFAST_ATAN2_MAGTHRESH &&
                                                                      IKabs(IKsqr(((-1.0) * new_r10 * (x132.value))) +
                                                                            IKsqr((
                                                                                ((new_r01 *
                                                                                  (IKsqrt(((1.0) + (((-1.0) *
                                                                                                     (gconst12 *
                                                                                                      gconst12)))))))) +
                                                                                (((-1.0) * gconst12 * new_r11)))) -
                                                                            1) <= IKFAST_SINCOS_THRESH)
                                                                    continue;
                                                                  j2array[0] = IKatan2(
                                                                      ((-1.0) * new_r10 * (x132.value)),
                                                                      (((new_r01 *
                                                                         (IKsqrt(((1.0) + (((-1.0) * (gconst12 *
                                                                                                      gconst12)))))))) +
                                                                       (((-1.0) * gconst12 * new_r11))));
                                                                  sj2array[0] = IKsin(j2array[0]);
                                                                  cj2array[0] = IKcos(j2array[0]);
                                                                  if (j2array[0] > IKPI)
                                                                  {
                                                                    j2array[0] -= IK2PI;
                                                                  }
                                                                  else if (j2array[0] < -IKPI)
                                                                  {
                                                                    j2array[0] += IK2PI;
                                                                  }
                                                                  j2valid[0] = true;
                                                                  for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                  {
                                                                    if (!j2valid[ij2])
                                                                    {
                                                                      continue;
                                                                    }
                                                                    _ij2[0] = ij2;
                                                                    _ij2[1] = -1;
                                                                    for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                    {
                                                                      if (j2valid[iij2] &&
                                                                          IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                              IKFAST_SOLUTION_THRESH &&
                                                                          IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                              IKFAST_SOLUTION_THRESH)
                                                                      {
                                                                        j2valid[iij2] = false;
                                                                        _ij2[1] = iij2;
                                                                        break;
                                                                      }
                                                                    }
                                                                    j2 = j2array[ij2];
                                                                    cj2 = cj2array[ij2];
                                                                    sj2 = sj2array[ij2];
                                                                    {
                                                                      IkReal evalcond[8];
                                                                      IkReal x133 = IKsin(j2);
                                                                      IkReal x134 = IKcos(j2);
                                                                      if ((((1.0) +
                                                                            (((-1.0) * (gconst12 * gconst12))))) <
                                                                          -0.00001)
                                                                        continue;
                                                                      IkReal x135 = IKsqrt(
                                                                          ((1.0) + (((-1.0) * (gconst12 * gconst12)))));
                                                                      IkReal x136 = ((1.0) * x135);
                                                                      evalcond[0] = x134;
                                                                      evalcond[1] = ((-1.0) * x133);
                                                                      evalcond[2] = (((gconst12 * x133)) + new_r10);
                                                                      evalcond[3] = (((gconst12 * x134)) + new_r11);
                                                                      evalcond[4] =
                                                                          ((((-1.0) * x133 * x136)) + new_r00);
                                                                      evalcond[5] =
                                                                          ((((-1.0) * x134 * x136)) + new_r01);
                                                                      evalcond[6] = ((((-1.0) * new_r00 * x136)) +
                                                                                     x133 + ((gconst12 * new_r10)));
                                                                      evalcond[7] = ((((-1.0) * new_r01 * x136)) +
                                                                                     x134 + ((gconst12 * new_r11)));
                                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                      {
                                                                        continue;
                                                                      }
                                                                    }

                                                                    {
                                                                      std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                          vinfos(7);
                                                                      vinfos[0].jointtype = 1;
                                                                      vinfos[0].foffset = j0;
                                                                      vinfos[0].indices[0] = _ij0[0];
                                                                      vinfos[0].indices[1] = _ij0[1];
                                                                      vinfos[0].maxsolutions = _nj0;
                                                                      vinfos[1].jointtype = 1;
                                                                      vinfos[1].foffset = j1;
                                                                      vinfos[1].indices[0] = _ij1[0];
                                                                      vinfos[1].indices[1] = _ij1[1];
                                                                      vinfos[1].maxsolutions = _nj1;
                                                                      vinfos[2].jointtype = 1;
                                                                      vinfos[2].foffset = j2;
                                                                      vinfos[2].indices[0] = _ij2[0];
                                                                      vinfos[2].indices[1] = _ij2[1];
                                                                      vinfos[2].maxsolutions = _nj2;
                                                                      vinfos[3].jointtype = 1;
                                                                      vinfos[3].foffset = j3;
                                                                      vinfos[3].indices[0] = _ij3[0];
                                                                      vinfos[3].indices[1] = _ij3[1];
                                                                      vinfos[3].maxsolutions = _nj3;
                                                                      vinfos[4].jointtype = 1;
                                                                      vinfos[4].foffset = j4;
                                                                      vinfos[4].indices[0] = _ij4[0];
                                                                      vinfos[4].indices[1] = _ij4[1];
                                                                      vinfos[4].maxsolutions = _nj4;
                                                                      vinfos[5].jointtype = 1;
                                                                      vinfos[5].foffset = j5;
                                                                      vinfos[5].indices[0] = _ij5[0];
                                                                      vinfos[5].indices[1] = _ij5[1];
                                                                      vinfos[5].maxsolutions = _nj5;
                                                                      vinfos[6].jointtype = 1;
                                                                      vinfos[6].foffset = j6;
                                                                      vinfos[6].indices[0] = _ij6[0];
                                                                      vinfos[6].indices[1] = _ij6[1];
                                                                      vinfos[6].maxsolutions = _nj6;
                                                                      std::vector<int> vfree(0);
                                                                      solutions.AddSolution(vinfos, vfree);
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                              else
                                                              {
                                                                {
                                                                  IkReal j2array[1], cj2array[1], sj2array[1];
                                                                  bool j2valid[1] = { false };
                                                                  _nj2 = 1;
                                                                  CheckValue<IkReal> x137 =
                                                                      IKatan2WithCheck(IkReal(((-1.0) * new_r10)),
                                                                                       IkReal(((-1.0) * new_r11)),
                                                                                       IKFAST_ATAN2_MAGTHRESH);
                                                                  if (!x137.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  CheckValue<IkReal> x138 =
                                                                      IKPowWithIntegerCheck(IKsign(gconst12), -1);
                                                                  if (!x138.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  j2array[0] = ((-1.5707963267949) + (x137.value) +
                                                                                (((1.5707963267949) * (x138.value))));
                                                                  sj2array[0] = IKsin(j2array[0]);
                                                                  cj2array[0] = IKcos(j2array[0]);
                                                                  if (j2array[0] > IKPI)
                                                                  {
                                                                    j2array[0] -= IK2PI;
                                                                  }
                                                                  else if (j2array[0] < -IKPI)
                                                                  {
                                                                    j2array[0] += IK2PI;
                                                                  }
                                                                  j2valid[0] = true;
                                                                  for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                  {
                                                                    if (!j2valid[ij2])
                                                                    {
                                                                      continue;
                                                                    }
                                                                    _ij2[0] = ij2;
                                                                    _ij2[1] = -1;
                                                                    for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                    {
                                                                      if (j2valid[iij2] &&
                                                                          IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                              IKFAST_SOLUTION_THRESH &&
                                                                          IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                              IKFAST_SOLUTION_THRESH)
                                                                      {
                                                                        j2valid[iij2] = false;
                                                                        _ij2[1] = iij2;
                                                                        break;
                                                                      }
                                                                    }
                                                                    j2 = j2array[ij2];
                                                                    cj2 = cj2array[ij2];
                                                                    sj2 = sj2array[ij2];
                                                                    {
                                                                      IkReal evalcond[8];
                                                                      IkReal x139 = IKsin(j2);
                                                                      IkReal x140 = IKcos(j2);
                                                                      if ((((1.0) +
                                                                            (((-1.0) * (gconst12 * gconst12))))) <
                                                                          -0.00001)
                                                                        continue;
                                                                      IkReal x141 = IKsqrt(
                                                                          ((1.0) + (((-1.0) * (gconst12 * gconst12)))));
                                                                      IkReal x142 = ((1.0) * x141);
                                                                      evalcond[0] = x140;
                                                                      evalcond[1] = ((-1.0) * x139);
                                                                      evalcond[2] = (((gconst12 * x139)) + new_r10);
                                                                      evalcond[3] = (((gconst12 * x140)) + new_r11);
                                                                      evalcond[4] =
                                                                          ((((-1.0) * x139 * x142)) + new_r00);
                                                                      evalcond[5] =
                                                                          ((((-1.0) * x140 * x142)) + new_r01);
                                                                      evalcond[6] =
                                                                          (x139 + (((-1.0) * new_r00 * x142)) +
                                                                           ((gconst12 * new_r10)));
                                                                      evalcond[7] = ((((-1.0) * new_r01 * x142)) +
                                                                                     x140 + ((gconst12 * new_r11)));
                                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                      {
                                                                        continue;
                                                                      }
                                                                    }

                                                                    {
                                                                      std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                          vinfos(7);
                                                                      vinfos[0].jointtype = 1;
                                                                      vinfos[0].foffset = j0;
                                                                      vinfos[0].indices[0] = _ij0[0];
                                                                      vinfos[0].indices[1] = _ij0[1];
                                                                      vinfos[0].maxsolutions = _nj0;
                                                                      vinfos[1].jointtype = 1;
                                                                      vinfos[1].foffset = j1;
                                                                      vinfos[1].indices[0] = _ij1[0];
                                                                      vinfos[1].indices[1] = _ij1[1];
                                                                      vinfos[1].maxsolutions = _nj1;
                                                                      vinfos[2].jointtype = 1;
                                                                      vinfos[2].foffset = j2;
                                                                      vinfos[2].indices[0] = _ij2[0];
                                                                      vinfos[2].indices[1] = _ij2[1];
                                                                      vinfos[2].maxsolutions = _nj2;
                                                                      vinfos[3].jointtype = 1;
                                                                      vinfos[3].foffset = j3;
                                                                      vinfos[3].indices[0] = _ij3[0];
                                                                      vinfos[3].indices[1] = _ij3[1];
                                                                      vinfos[3].maxsolutions = _nj3;
                                                                      vinfos[4].jointtype = 1;
                                                                      vinfos[4].foffset = j4;
                                                                      vinfos[4].indices[0] = _ij4[0];
                                                                      vinfos[4].indices[1] = _ij4[1];
                                                                      vinfos[4].maxsolutions = _nj4;
                                                                      vinfos[5].jointtype = 1;
                                                                      vinfos[5].foffset = j5;
                                                                      vinfos[5].indices[0] = _ij5[0];
                                                                      vinfos[5].indices[1] = _ij5[1];
                                                                      vinfos[5].maxsolutions = _nj5;
                                                                      vinfos[6].jointtype = 1;
                                                                      vinfos[6].foffset = j6;
                                                                      vinfos[6].indices[0] = _ij6[0];
                                                                      vinfos[6].indices[1] = _ij6[1];
                                                                      vinfos[6].maxsolutions = _nj6;
                                                                      std::vector<int> vfree(0);
                                                                      solutions.AddSolution(vinfos, vfree);
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        } while (0);
                                                        if (bgotonextstatement)
                                                        {
                                                          bool bgotonextstatement = true;
                                                          do
                                                          {
                                                            IkReal x143 = new_r22 * new_r22;
                                                            CheckValue<IkReal> x144 =
                                                                IKPowWithIntegerCheck(((1.0) + (((-1.0) * x143))), -1);
                                                            if (!x144.valid)
                                                            {
                                                              continue;
                                                            }
                                                            if ((((-1.0) * x143 * (x144.value))) < -0.00001)
                                                              continue;
                                                            IkReal gconst12 = IKsqrt(((-1.0) * x143 * (x144.value)));
                                                            evalcond[0] =
                                                                ((-3.14159265358979) +
                                                                 (IKfmod(((3.14159265358979) +
                                                                          (IKabs((cj0 + (((-1.0) * gconst12))))) +
                                                                          (IKabs(((1.0) + (IKsign(sj0)))))),
                                                                         6.28318530717959)));
                                                            if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                            {
                                                              bgotonextstatement = false;
                                                              {
                                                                IkReal j2eval[1];
                                                                IkReal x145 = new_r22 * new_r22;
                                                                new_r02 = 0;
                                                                new_r12 = 0;
                                                                new_r20 = 0;
                                                                new_r21 = 0;
                                                                if ((((1.0) + (((-1.0) * (gconst12 * gconst12))))) <
                                                                    -0.00001)
                                                                  continue;
                                                                sj0 = ((-1.0) *
                                                                       (IKsqrt(((1.0) +
                                                                                (((-1.0) * (gconst12 * gconst12)))))));
                                                                cj0 = gconst12;
                                                                if ((gconst12) < -1 - IKFAST_SINCOS_THRESH ||
                                                                    (gconst12) > 1 + IKFAST_SINCOS_THRESH)
                                                                  continue;
                                                                j0 = ((-1.0) * (IKacos(gconst12)));
                                                                CheckValue<IkReal> x146 = IKPowWithIntegerCheck(
                                                                    ((1.0) + (((-1.0) * x145))), -1);
                                                                if (!x146.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                if ((((-1.0) * x145 * (x146.value))) < -0.00001)
                                                                  continue;
                                                                IkReal gconst12 =
                                                                    IKsqrt(((-1.0) * x145 * (x146.value)));
                                                                j2eval[0] = ((IKabs(new_r11)) + (IKabs(new_r10)));
                                                                if (IKabs(j2eval[0]) < 0.0000010000000000)
                                                                {
                                                                  {
                                                                    IkReal j2array[1], cj2array[1], sj2array[1];
                                                                    bool j2valid[1] = { false };
                                                                    _nj2 = 1;
                                                                    CheckValue<IkReal> x147 =
                                                                        IKPowWithIntegerCheck(gconst12, -1);
                                                                    if (!x147.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    if ((((1.0) + (((-1.0) * (gconst12 * gconst12))))) <
                                                                        -0.00001)
                                                                      continue;
                                                                    if (IKabs(((-1.0) * new_r10 * (x147.value))) <
                                                                            IKFAST_ATAN2_MAGTHRESH &&
                                                                        IKabs(((((-1.0) * new_r01 *
                                                                                 (IKsqrt(((1.0) +
                                                                                          (((-1.0) * (gconst12 *
                                                                                                      gconst12)))))))) +
                                                                               (((-1.0) * gconst12 * new_r11)))) <
                                                                            IKFAST_ATAN2_MAGTHRESH &&
                                                                        IKabs(IKsqr(((-1.0) * new_r10 * (x147.value))) +
                                                                              IKsqr(((((-1.0) * new_r01 *
                                                                                       (IKsqrt(((1.0) +
                                                                                                (((-1.0) *
                                                                                                  (gconst12 *
                                                                                                   gconst12)))))))) +
                                                                                     (((-1.0) * gconst12 * new_r11)))) -
                                                                              1) <= IKFAST_SINCOS_THRESH)
                                                                      continue;
                                                                    j2array[0] = IKatan2(
                                                                        ((-1.0) * new_r10 * (x147.value)),
                                                                        ((((-1.0) * new_r01 *
                                                                           (IKsqrt((
                                                                               (1.0) +
                                                                               (((-1.0) * (gconst12 * gconst12)))))))) +
                                                                         (((-1.0) * gconst12 * new_r11))));
                                                                    sj2array[0] = IKsin(j2array[0]);
                                                                    cj2array[0] = IKcos(j2array[0]);
                                                                    if (j2array[0] > IKPI)
                                                                    {
                                                                      j2array[0] -= IK2PI;
                                                                    }
                                                                    else if (j2array[0] < -IKPI)
                                                                    {
                                                                      j2array[0] += IK2PI;
                                                                    }
                                                                    j2valid[0] = true;
                                                                    for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                    {
                                                                      if (!j2valid[ij2])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij2[0] = ij2;
                                                                      _ij2[1] = -1;
                                                                      for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                      {
                                                                        if (j2valid[iij2] &&
                                                                            IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                                IKFAST_SOLUTION_THRESH &&
                                                                            IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                                IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j2valid[iij2] = false;
                                                                          _ij2[1] = iij2;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j2 = j2array[ij2];
                                                                      cj2 = cj2array[ij2];
                                                                      sj2 = sj2array[ij2];
                                                                      {
                                                                        IkReal evalcond[8];
                                                                        IkReal x148 = IKsin(j2);
                                                                        IkReal x149 = IKcos(j2);
                                                                        if ((((1.0) +
                                                                              (((-1.0) * (gconst12 * gconst12))))) <
                                                                            -0.00001)
                                                                          continue;
                                                                        IkReal x150 = IKsqrt(
                                                                            ((1.0) +
                                                                             (((-1.0) * (gconst12 * gconst12)))));
                                                                        evalcond[0] = x149;
                                                                        evalcond[1] = ((-1.0) * x148);
                                                                        evalcond[2] = (((gconst12 * x148)) + new_r10);
                                                                        evalcond[3] = (((gconst12 * x149)) + new_r11);
                                                                        evalcond[4] = (((x148 * x150)) + new_r00);
                                                                        evalcond[5] = (((x149 * x150)) + new_r01);
                                                                        evalcond[6] = (((new_r00 * x150)) + x148 +
                                                                                       ((gconst12 * new_r10)));
                                                                        evalcond[7] = (((new_r01 * x150)) + x149 +
                                                                                       ((gconst12 * new_r11)));
                                                                        if (IKabs(evalcond[0]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[1]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[2]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[3]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[4]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[5]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[6]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      {
                                                                        std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                            vinfos(7);
                                                                        vinfos[0].jointtype = 1;
                                                                        vinfos[0].foffset = j0;
                                                                        vinfos[0].indices[0] = _ij0[0];
                                                                        vinfos[0].indices[1] = _ij0[1];
                                                                        vinfos[0].maxsolutions = _nj0;
                                                                        vinfos[1].jointtype = 1;
                                                                        vinfos[1].foffset = j1;
                                                                        vinfos[1].indices[0] = _ij1[0];
                                                                        vinfos[1].indices[1] = _ij1[1];
                                                                        vinfos[1].maxsolutions = _nj1;
                                                                        vinfos[2].jointtype = 1;
                                                                        vinfos[2].foffset = j2;
                                                                        vinfos[2].indices[0] = _ij2[0];
                                                                        vinfos[2].indices[1] = _ij2[1];
                                                                        vinfos[2].maxsolutions = _nj2;
                                                                        vinfos[3].jointtype = 1;
                                                                        vinfos[3].foffset = j3;
                                                                        vinfos[3].indices[0] = _ij3[0];
                                                                        vinfos[3].indices[1] = _ij3[1];
                                                                        vinfos[3].maxsolutions = _nj3;
                                                                        vinfos[4].jointtype = 1;
                                                                        vinfos[4].foffset = j4;
                                                                        vinfos[4].indices[0] = _ij4[0];
                                                                        vinfos[4].indices[1] = _ij4[1];
                                                                        vinfos[4].maxsolutions = _nj4;
                                                                        vinfos[5].jointtype = 1;
                                                                        vinfos[5].foffset = j5;
                                                                        vinfos[5].indices[0] = _ij5[0];
                                                                        vinfos[5].indices[1] = _ij5[1];
                                                                        vinfos[5].maxsolutions = _nj5;
                                                                        vinfos[6].jointtype = 1;
                                                                        vinfos[6].foffset = j6;
                                                                        vinfos[6].indices[0] = _ij6[0];
                                                                        vinfos[6].indices[1] = _ij6[1];
                                                                        vinfos[6].maxsolutions = _nj6;
                                                                        std::vector<int> vfree(0);
                                                                        solutions.AddSolution(vinfos, vfree);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                                else
                                                                {
                                                                  {
                                                                    IkReal j2array[1], cj2array[1], sj2array[1];
                                                                    bool j2valid[1] = { false };
                                                                    _nj2 = 1;
                                                                    CheckValue<IkReal> x151 =
                                                                        IKatan2WithCheck(IkReal(((-1.0) * new_r10)),
                                                                                         IkReal(((-1.0) * new_r11)),
                                                                                         IKFAST_ATAN2_MAGTHRESH);
                                                                    if (!x151.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    CheckValue<IkReal> x152 =
                                                                        IKPowWithIntegerCheck(IKsign(gconst12), -1);
                                                                    if (!x152.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    j2array[0] = ((-1.5707963267949) + (x151.value) +
                                                                                  (((1.5707963267949) * (x152.value))));
                                                                    sj2array[0] = IKsin(j2array[0]);
                                                                    cj2array[0] = IKcos(j2array[0]);
                                                                    if (j2array[0] > IKPI)
                                                                    {
                                                                      j2array[0] -= IK2PI;
                                                                    }
                                                                    else if (j2array[0] < -IKPI)
                                                                    {
                                                                      j2array[0] += IK2PI;
                                                                    }
                                                                    j2valid[0] = true;
                                                                    for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                    {
                                                                      if (!j2valid[ij2])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij2[0] = ij2;
                                                                      _ij2[1] = -1;
                                                                      for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                      {
                                                                        if (j2valid[iij2] &&
                                                                            IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                                IKFAST_SOLUTION_THRESH &&
                                                                            IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                                IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j2valid[iij2] = false;
                                                                          _ij2[1] = iij2;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j2 = j2array[ij2];
                                                                      cj2 = cj2array[ij2];
                                                                      sj2 = sj2array[ij2];
                                                                      {
                                                                        IkReal evalcond[8];
                                                                        IkReal x153 = IKsin(j2);
                                                                        IkReal x154 = IKcos(j2);
                                                                        if ((((1.0) +
                                                                              (((-1.0) * (gconst12 * gconst12))))) <
                                                                            -0.00001)
                                                                          continue;
                                                                        IkReal x155 = IKsqrt(
                                                                            ((1.0) +
                                                                             (((-1.0) * (gconst12 * gconst12)))));
                                                                        evalcond[0] = x154;
                                                                        evalcond[1] = ((-1.0) * x153);
                                                                        evalcond[2] = (((gconst12 * x153)) + new_r10);
                                                                        evalcond[3] = (((gconst12 * x154)) + new_r11);
                                                                        evalcond[4] = (((x153 * x155)) + new_r00);
                                                                        evalcond[5] = (((x154 * x155)) + new_r01);
                                                                        evalcond[6] = (((new_r00 * x155)) + x153 +
                                                                                       ((gconst12 * new_r10)));
                                                                        evalcond[7] = (((new_r01 * x155)) + x154 +
                                                                                       ((gconst12 * new_r11)));
                                                                        if (IKabs(evalcond[0]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[1]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[2]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[3]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[4]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[5]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[6]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      {
                                                                        std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                            vinfos(7);
                                                                        vinfos[0].jointtype = 1;
                                                                        vinfos[0].foffset = j0;
                                                                        vinfos[0].indices[0] = _ij0[0];
                                                                        vinfos[0].indices[1] = _ij0[1];
                                                                        vinfos[0].maxsolutions = _nj0;
                                                                        vinfos[1].jointtype = 1;
                                                                        vinfos[1].foffset = j1;
                                                                        vinfos[1].indices[0] = _ij1[0];
                                                                        vinfos[1].indices[1] = _ij1[1];
                                                                        vinfos[1].maxsolutions = _nj1;
                                                                        vinfos[2].jointtype = 1;
                                                                        vinfos[2].foffset = j2;
                                                                        vinfos[2].indices[0] = _ij2[0];
                                                                        vinfos[2].indices[1] = _ij2[1];
                                                                        vinfos[2].maxsolutions = _nj2;
                                                                        vinfos[3].jointtype = 1;
                                                                        vinfos[3].foffset = j3;
                                                                        vinfos[3].indices[0] = _ij3[0];
                                                                        vinfos[3].indices[1] = _ij3[1];
                                                                        vinfos[3].maxsolutions = _nj3;
                                                                        vinfos[4].jointtype = 1;
                                                                        vinfos[4].foffset = j4;
                                                                        vinfos[4].indices[0] = _ij4[0];
                                                                        vinfos[4].indices[1] = _ij4[1];
                                                                        vinfos[4].maxsolutions = _nj4;
                                                                        vinfos[5].jointtype = 1;
                                                                        vinfos[5].foffset = j5;
                                                                        vinfos[5].indices[0] = _ij5[0];
                                                                        vinfos[5].indices[1] = _ij5[1];
                                                                        vinfos[5].maxsolutions = _nj5;
                                                                        vinfos[6].jointtype = 1;
                                                                        vinfos[6].foffset = j6;
                                                                        vinfos[6].indices[0] = _ij6[0];
                                                                        vinfos[6].indices[1] = _ij6[1];
                                                                        vinfos[6].maxsolutions = _nj6;
                                                                        std::vector<int> vfree(0);
                                                                        solutions.AddSolution(vinfos, vfree);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          } while (0);
                                                          if (bgotonextstatement)
                                                          {
                                                            bool bgotonextstatement = true;
                                                            do
                                                            {
                                                              IkReal x156 = new_r22 * new_r22;
                                                              CheckValue<IkReal> x157 = IKPowWithIntegerCheck(
                                                                  ((1.0) + (((-1.0) * x156))), -1);
                                                              if (!x157.valid)
                                                              {
                                                                continue;
                                                              }
                                                              if ((((-1.0) * x156 * (x157.value))) < -0.00001)
                                                                continue;
                                                              IkReal gconst13 =
                                                                  ((-1.0) * (IKsqrt(((-1.0) * x156 * (x157.value)))));
                                                              evalcond[0] =
                                                                  ((-3.14159265358979) +
                                                                   (IKfmod(((3.14159265358979) +
                                                                            (IKabs((cj0 + (((-1.0) * gconst13))))) +
                                                                            (IKabs(((-1.0) + (IKsign(sj0)))))),
                                                                           6.28318530717959)));
                                                              if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                              {
                                                                bgotonextstatement = false;
                                                                {
                                                                  IkReal j2eval[1];
                                                                  IkReal x158 = new_r22 * new_r22;
                                                                  new_r02 = 0;
                                                                  new_r12 = 0;
                                                                  new_r20 = 0;
                                                                  new_r21 = 0;
                                                                  if ((((1.0) + (((-1.0) * (gconst13 * gconst13))))) <
                                                                      -0.00001)
                                                                    continue;
                                                                  sj0 = IKsqrt(
                                                                      ((1.0) + (((-1.0) * (gconst13 * gconst13)))));
                                                                  cj0 = gconst13;
                                                                  if ((gconst13) < -1 - IKFAST_SINCOS_THRESH ||
                                                                      (gconst13) > 1 + IKFAST_SINCOS_THRESH)
                                                                    continue;
                                                                  j0 = IKacos(gconst13);
                                                                  CheckValue<IkReal> x159 = IKPowWithIntegerCheck(
                                                                      ((1.0) + (((-1.0) * x158))), -1);
                                                                  if (!x159.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  if ((((-1.0) * x158 * (x159.value))) < -0.00001)
                                                                    continue;
                                                                  IkReal gconst13 =
                                                                      ((-1.0) *
                                                                       (IKsqrt(((-1.0) * x158 * (x159.value)))));
                                                                  j2eval[0] = ((IKabs(new_r11)) + (IKabs(new_r10)));
                                                                  if (IKabs(j2eval[0]) < 0.0000010000000000)
                                                                  {
                                                                    {
                                                                      IkReal j2array[1], cj2array[1], sj2array[1];
                                                                      bool j2valid[1] = { false };
                                                                      _nj2 = 1;
                                                                      CheckValue<IkReal> x160 =
                                                                          IKPowWithIntegerCheck(gconst13, -1);
                                                                      if (!x160.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      if ((((1.0) +
                                                                            (((-1.0) * (gconst13 * gconst13))))) <
                                                                          -0.00001)
                                                                        continue;
                                                                      if (IKabs(((-1.0) * new_r10 * (x160.value))) <
                                                                              IKFAST_ATAN2_MAGTHRESH &&
                                                                          IKabs((
                                                                              (((-1.0) * gconst13 * new_r11)) +
                                                                              ((new_r01 *
                                                                                (IKsqrt(((1.0) + (((-1.0) *
                                                                                                   (gconst13 *
                                                                                                    gconst13)))))))))) <
                                                                              IKFAST_ATAN2_MAGTHRESH &&
                                                                          IKabs(
                                                                              IKsqr(((-1.0) * new_r10 * (x160.value))) +
                                                                              IKsqr(((((-1.0) * gconst13 * new_r11)) +
                                                                                     ((new_r01 *
                                                                                       (IKsqrt(((1.0) +
                                                                                                (((-1.0) *
                                                                                                  (gconst13 *
                                                                                                   gconst13)))))))))) -
                                                                              1) <= IKFAST_SINCOS_THRESH)
                                                                        continue;
                                                                      j2array[0] = IKatan2(
                                                                          ((-1.0) * new_r10 * (x160.value)),
                                                                          ((((-1.0) * gconst13 * new_r11)) +
                                                                           ((new_r01 *
                                                                             (IKsqrt(((1.0) +
                                                                                      (((-1.0) *
                                                                                        (gconst13 * gconst13))))))))));
                                                                      sj2array[0] = IKsin(j2array[0]);
                                                                      cj2array[0] = IKcos(j2array[0]);
                                                                      if (j2array[0] > IKPI)
                                                                      {
                                                                        j2array[0] -= IK2PI;
                                                                      }
                                                                      else if (j2array[0] < -IKPI)
                                                                      {
                                                                        j2array[0] += IK2PI;
                                                                      }
                                                                      j2valid[0] = true;
                                                                      for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                      {
                                                                        if (!j2valid[ij2])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij2[0] = ij2;
                                                                        _ij2[1] = -1;
                                                                        for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                        {
                                                                          if (j2valid[iij2] &&
                                                                              IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                              IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                                  IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j2valid[iij2] = false;
                                                                            _ij2[1] = iij2;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j2 = j2array[ij2];
                                                                        cj2 = cj2array[ij2];
                                                                        sj2 = sj2array[ij2];
                                                                        {
                                                                          IkReal evalcond[8];
                                                                          IkReal x161 = IKsin(j2);
                                                                          IkReal x162 = IKcos(j2);
                                                                          if ((((1.0) +
                                                                                (((-1.0) * (gconst13 * gconst13))))) <
                                                                              -0.00001)
                                                                            continue;
                                                                          IkReal x163 = IKsqrt(
                                                                              ((1.0) +
                                                                               (((-1.0) * (gconst13 * gconst13)))));
                                                                          IkReal x164 = ((1.0) * x163);
                                                                          evalcond[0] = x162;
                                                                          evalcond[1] = ((-1.0) * x161);
                                                                          evalcond[2] = (new_r10 + ((gconst13 * x161)));
                                                                          evalcond[3] = (new_r11 + ((gconst13 * x162)));
                                                                          evalcond[4] =
                                                                              ((((-1.0) * x161 * x164)) + new_r00);
                                                                          evalcond[5] =
                                                                              ((((-1.0) * x162 * x164)) + new_r01);
                                                                          evalcond[6] = ((((-1.0) * new_r00 * x164)) +
                                                                                         x161 + ((gconst13 * new_r10)));
                                                                          evalcond[7] = (x162 + ((gconst13 * new_r11)) +
                                                                                         (((-1.0) * new_r01 * x164)));
                                                                          if (IKabs(evalcond[0]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[1]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[2]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[3]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[4]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[5]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[6]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[7]) >
                                                                                  IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        {
                                                                          std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                              vinfos(7);
                                                                          vinfos[0].jointtype = 1;
                                                                          vinfos[0].foffset = j0;
                                                                          vinfos[0].indices[0] = _ij0[0];
                                                                          vinfos[0].indices[1] = _ij0[1];
                                                                          vinfos[0].maxsolutions = _nj0;
                                                                          vinfos[1].jointtype = 1;
                                                                          vinfos[1].foffset = j1;
                                                                          vinfos[1].indices[0] = _ij1[0];
                                                                          vinfos[1].indices[1] = _ij1[1];
                                                                          vinfos[1].maxsolutions = _nj1;
                                                                          vinfos[2].jointtype = 1;
                                                                          vinfos[2].foffset = j2;
                                                                          vinfos[2].indices[0] = _ij2[0];
                                                                          vinfos[2].indices[1] = _ij2[1];
                                                                          vinfos[2].maxsolutions = _nj2;
                                                                          vinfos[3].jointtype = 1;
                                                                          vinfos[3].foffset = j3;
                                                                          vinfos[3].indices[0] = _ij3[0];
                                                                          vinfos[3].indices[1] = _ij3[1];
                                                                          vinfos[3].maxsolutions = _nj3;
                                                                          vinfos[4].jointtype = 1;
                                                                          vinfos[4].foffset = j4;
                                                                          vinfos[4].indices[0] = _ij4[0];
                                                                          vinfos[4].indices[1] = _ij4[1];
                                                                          vinfos[4].maxsolutions = _nj4;
                                                                          vinfos[5].jointtype = 1;
                                                                          vinfos[5].foffset = j5;
                                                                          vinfos[5].indices[0] = _ij5[0];
                                                                          vinfos[5].indices[1] = _ij5[1];
                                                                          vinfos[5].maxsolutions = _nj5;
                                                                          vinfos[6].jointtype = 1;
                                                                          vinfos[6].foffset = j6;
                                                                          vinfos[6].indices[0] = _ij6[0];
                                                                          vinfos[6].indices[1] = _ij6[1];
                                                                          vinfos[6].maxsolutions = _nj6;
                                                                          std::vector<int> vfree(0);
                                                                          solutions.AddSolution(vinfos, vfree);
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                  else
                                                                  {
                                                                    {
                                                                      IkReal j2array[1], cj2array[1], sj2array[1];
                                                                      bool j2valid[1] = { false };
                                                                      _nj2 = 1;
                                                                      CheckValue<IkReal> x165 =
                                                                          IKatan2WithCheck(IkReal(((-1.0) * new_r10)),
                                                                                           IkReal(((-1.0) * new_r11)),
                                                                                           IKFAST_ATAN2_MAGTHRESH);
                                                                      if (!x165.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      CheckValue<IkReal> x166 =
                                                                          IKPowWithIntegerCheck(IKsign(gconst13), -1);
                                                                      if (!x166.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      j2array[0] =
                                                                          ((-1.5707963267949) + (x165.value) +
                                                                           (((1.5707963267949) * (x166.value))));
                                                                      sj2array[0] = IKsin(j2array[0]);
                                                                      cj2array[0] = IKcos(j2array[0]);
                                                                      if (j2array[0] > IKPI)
                                                                      {
                                                                        j2array[0] -= IK2PI;
                                                                      }
                                                                      else if (j2array[0] < -IKPI)
                                                                      {
                                                                        j2array[0] += IK2PI;
                                                                      }
                                                                      j2valid[0] = true;
                                                                      for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                      {
                                                                        if (!j2valid[ij2])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij2[0] = ij2;
                                                                        _ij2[1] = -1;
                                                                        for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                        {
                                                                          if (j2valid[iij2] &&
                                                                              IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                              IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                                  IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j2valid[iij2] = false;
                                                                            _ij2[1] = iij2;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j2 = j2array[ij2];
                                                                        cj2 = cj2array[ij2];
                                                                        sj2 = sj2array[ij2];
                                                                        {
                                                                          IkReal evalcond[8];
                                                                          IkReal x167 = IKsin(j2);
                                                                          IkReal x168 = IKcos(j2);
                                                                          if ((((1.0) +
                                                                                (((-1.0) * (gconst13 * gconst13))))) <
                                                                              -0.00001)
                                                                            continue;
                                                                          IkReal x169 = IKsqrt(
                                                                              ((1.0) +
                                                                               (((-1.0) * (gconst13 * gconst13)))));
                                                                          IkReal x170 = ((1.0) * x169);
                                                                          evalcond[0] = x168;
                                                                          evalcond[1] = ((-1.0) * x167);
                                                                          evalcond[2] = (new_r10 + ((gconst13 * x167)));
                                                                          evalcond[3] = (new_r11 + ((gconst13 * x168)));
                                                                          evalcond[4] =
                                                                              (new_r00 + (((-1.0) * x167 * x170)));
                                                                          evalcond[5] =
                                                                              ((((-1.0) * x168 * x170)) + new_r01);
                                                                          evalcond[6] = (x167 + ((gconst13 * new_r10)) +
                                                                                         (((-1.0) * new_r00 * x170)));
                                                                          evalcond[7] = (x168 + ((gconst13 * new_r11)) +
                                                                                         (((-1.0) * new_r01 * x170)));
                                                                          if (IKabs(evalcond[0]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[1]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[2]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[3]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[4]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[5]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[6]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[7]) >
                                                                                  IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        {
                                                                          std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                              vinfos(7);
                                                                          vinfos[0].jointtype = 1;
                                                                          vinfos[0].foffset = j0;
                                                                          vinfos[0].indices[0] = _ij0[0];
                                                                          vinfos[0].indices[1] = _ij0[1];
                                                                          vinfos[0].maxsolutions = _nj0;
                                                                          vinfos[1].jointtype = 1;
                                                                          vinfos[1].foffset = j1;
                                                                          vinfos[1].indices[0] = _ij1[0];
                                                                          vinfos[1].indices[1] = _ij1[1];
                                                                          vinfos[1].maxsolutions = _nj1;
                                                                          vinfos[2].jointtype = 1;
                                                                          vinfos[2].foffset = j2;
                                                                          vinfos[2].indices[0] = _ij2[0];
                                                                          vinfos[2].indices[1] = _ij2[1];
                                                                          vinfos[2].maxsolutions = _nj2;
                                                                          vinfos[3].jointtype = 1;
                                                                          vinfos[3].foffset = j3;
                                                                          vinfos[3].indices[0] = _ij3[0];
                                                                          vinfos[3].indices[1] = _ij3[1];
                                                                          vinfos[3].maxsolutions = _nj3;
                                                                          vinfos[4].jointtype = 1;
                                                                          vinfos[4].foffset = j4;
                                                                          vinfos[4].indices[0] = _ij4[0];
                                                                          vinfos[4].indices[1] = _ij4[1];
                                                                          vinfos[4].maxsolutions = _nj4;
                                                                          vinfos[5].jointtype = 1;
                                                                          vinfos[5].foffset = j5;
                                                                          vinfos[5].indices[0] = _ij5[0];
                                                                          vinfos[5].indices[1] = _ij5[1];
                                                                          vinfos[5].maxsolutions = _nj5;
                                                                          vinfos[6].jointtype = 1;
                                                                          vinfos[6].foffset = j6;
                                                                          vinfos[6].indices[0] = _ij6[0];
                                                                          vinfos[6].indices[1] = _ij6[1];
                                                                          vinfos[6].maxsolutions = _nj6;
                                                                          std::vector<int> vfree(0);
                                                                          solutions.AddSolution(vinfos, vfree);
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            } while (0);
                                                            if (bgotonextstatement)
                                                            {
                                                              bool bgotonextstatement = true;
                                                              do
                                                              {
                                                                IkReal x171 = new_r22 * new_r22;
                                                                CheckValue<IkReal> x172 = IKPowWithIntegerCheck(
                                                                    ((1.0) + (((-1.0) * x171))), -1);
                                                                if (!x172.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                if ((((-1.0) * x171 * (x172.value))) < -0.00001)
                                                                  continue;
                                                                IkReal gconst13 =
                                                                    ((-1.0) * (IKsqrt(((-1.0) * x171 * (x172.value)))));
                                                                evalcond[0] =
                                                                    ((-3.14159265358979) +
                                                                     (IKfmod(((3.14159265358979) +
                                                                              (IKabs(((1.0) + (IKsign(sj0))))) +
                                                                              (IKabs((cj0 + (((-1.0) * gconst13)))))),
                                                                             6.28318530717959)));
                                                                if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                                {
                                                                  bgotonextstatement = false;
                                                                  {
                                                                    IkReal j2eval[1];
                                                                    IkReal x173 = new_r22 * new_r22;
                                                                    new_r02 = 0;
                                                                    new_r12 = 0;
                                                                    new_r20 = 0;
                                                                    new_r21 = 0;
                                                                    if ((((1.0) + (((-1.0) * (gconst13 * gconst13))))) <
                                                                        -0.00001)
                                                                      continue;
                                                                    sj0 = ((-1.0) *
                                                                           (IKsqrt(((1.0) + (((-1.0) * (gconst13 *
                                                                                                        gconst13)))))));
                                                                    cj0 = gconst13;
                                                                    if ((gconst13) < -1 - IKFAST_SINCOS_THRESH ||
                                                                        (gconst13) > 1 + IKFAST_SINCOS_THRESH)
                                                                      continue;
                                                                    j0 = ((-1.0) * (IKacos(gconst13)));
                                                                    CheckValue<IkReal> x174 = IKPowWithIntegerCheck(
                                                                        ((1.0) + (((-1.0) * x173))), -1);
                                                                    if (!x174.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    if ((((-1.0) * x173 * (x174.value))) < -0.00001)
                                                                      continue;
                                                                    IkReal gconst13 =
                                                                        ((-1.0) *
                                                                         (IKsqrt(((-1.0) * x173 * (x174.value)))));
                                                                    j2eval[0] = ((IKabs(new_r11)) + (IKabs(new_r10)));
                                                                    if (IKabs(j2eval[0]) < 0.0000010000000000)
                                                                    {
                                                                      {
                                                                        IkReal j2array[1], cj2array[1], sj2array[1];
                                                                        bool j2valid[1] = { false };
                                                                        _nj2 = 1;
                                                                        CheckValue<IkReal> x175 =
                                                                            IKPowWithIntegerCheck(gconst13, -1);
                                                                        if (!x175.valid)
                                                                        {
                                                                          continue;
                                                                        }
                                                                        if ((((1.0) +
                                                                              (((-1.0) * (gconst13 * gconst13))))) <
                                                                            -0.00001)
                                                                          continue;
                                                                        if (IKabs(((-1.0) * new_r10 * (x175.value))) <
                                                                                IKFAST_ATAN2_MAGTHRESH &&
                                                                            IKabs(((((-1.0) * gconst13 * new_r11)) +
                                                                                   (((-1.0) * new_r01 *
                                                                                     (IKsqrt(((1.0) +
                                                                                              (((-1.0) *
                                                                                                (gconst13 *
                                                                                                 gconst13)))))))))) <
                                                                                IKFAST_ATAN2_MAGTHRESH &&
                                                                            IKabs(IKsqr(((-1.0) * new_r10 *
                                                                                         (x175.value))) +
                                                                                  IKsqr((
                                                                                      (((-1.0) * gconst13 * new_r11)) +
                                                                                      (((-1.0) * new_r01 *
                                                                                        (IKsqrt(((1.0) +
                                                                                                 (((-1.0) *
                                                                                                   (gconst13 *
                                                                                                    gconst13)))))))))) -
                                                                                  1) <= IKFAST_SINCOS_THRESH)
                                                                          continue;
                                                                        j2array[0] = IKatan2(
                                                                            ((-1.0) * new_r10 * (x175.value)),
                                                                            ((((-1.0) * gconst13 * new_r11)) +
                                                                             (((-1.0) * new_r01 *
                                                                               (IKsqrt(((1.0) +
                                                                                        (((-1.0) * (gconst13 *
                                                                                                    gconst13))))))))));
                                                                        sj2array[0] = IKsin(j2array[0]);
                                                                        cj2array[0] = IKcos(j2array[0]);
                                                                        if (j2array[0] > IKPI)
                                                                        {
                                                                          j2array[0] -= IK2PI;
                                                                        }
                                                                        else if (j2array[0] < -IKPI)
                                                                        {
                                                                          j2array[0] += IK2PI;
                                                                        }
                                                                        j2valid[0] = true;
                                                                        for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                        {
                                                                          if (!j2valid[ij2])
                                                                          {
                                                                            continue;
                                                                          }
                                                                          _ij2[0] = ij2;
                                                                          _ij2[1] = -1;
                                                                          for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                          {
                                                                            if (j2valid[iij2] &&
                                                                                IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                                    IKFAST_SOLUTION_THRESH &&
                                                                                IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                                    IKFAST_SOLUTION_THRESH)
                                                                            {
                                                                              j2valid[iij2] = false;
                                                                              _ij2[1] = iij2;
                                                                              break;
                                                                            }
                                                                          }
                                                                          j2 = j2array[ij2];
                                                                          cj2 = cj2array[ij2];
                                                                          sj2 = sj2array[ij2];
                                                                          {
                                                                            IkReal evalcond[8];
                                                                            IkReal x176 = IKsin(j2);
                                                                            IkReal x177 = IKcos(j2);
                                                                            if ((((1.0) +
                                                                                  (((-1.0) * (gconst13 * gconst13))))) <
                                                                                -0.00001)
                                                                              continue;
                                                                            IkReal x178 = IKsqrt(
                                                                                ((1.0) +
                                                                                 (((-1.0) * (gconst13 * gconst13)))));
                                                                            evalcond[0] = x177;
                                                                            evalcond[1] = ((-1.0) * x176);
                                                                            evalcond[2] =
                                                                                (new_r10 + ((gconst13 * x176)));
                                                                            evalcond[3] =
                                                                                (new_r11 + ((gconst13 * x177)));
                                                                            evalcond[4] = (((x176 * x178)) + new_r00);
                                                                            evalcond[5] = (new_r01 + ((x177 * x178)));
                                                                            evalcond[6] = (((new_r00 * x178)) + x176 +
                                                                                           ((gconst13 * new_r10)));
                                                                            evalcond[7] = (((new_r01 * x178)) + x177 +
                                                                                           ((gconst13 * new_r11)));
                                                                            if (IKabs(evalcond[0]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[1]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[2]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[3]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[4]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[5]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[6]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[7]) >
                                                                                    IKFAST_EVALCOND_THRESH)
                                                                            {
                                                                              continue;
                                                                            }
                                                                          }

                                                                          {
                                                                            std::vector<
                                                                                IkSingleDOFSolutionBase<IkReal> >
                                                                                vinfos(7);
                                                                            vinfos[0].jointtype = 1;
                                                                            vinfos[0].foffset = j0;
                                                                            vinfos[0].indices[0] = _ij0[0];
                                                                            vinfos[0].indices[1] = _ij0[1];
                                                                            vinfos[0].maxsolutions = _nj0;
                                                                            vinfos[1].jointtype = 1;
                                                                            vinfos[1].foffset = j1;
                                                                            vinfos[1].indices[0] = _ij1[0];
                                                                            vinfos[1].indices[1] = _ij1[1];
                                                                            vinfos[1].maxsolutions = _nj1;
                                                                            vinfos[2].jointtype = 1;
                                                                            vinfos[2].foffset = j2;
                                                                            vinfos[2].indices[0] = _ij2[0];
                                                                            vinfos[2].indices[1] = _ij2[1];
                                                                            vinfos[2].maxsolutions = _nj2;
                                                                            vinfos[3].jointtype = 1;
                                                                            vinfos[3].foffset = j3;
                                                                            vinfos[3].indices[0] = _ij3[0];
                                                                            vinfos[3].indices[1] = _ij3[1];
                                                                            vinfos[3].maxsolutions = _nj3;
                                                                            vinfos[4].jointtype = 1;
                                                                            vinfos[4].foffset = j4;
                                                                            vinfos[4].indices[0] = _ij4[0];
                                                                            vinfos[4].indices[1] = _ij4[1];
                                                                            vinfos[4].maxsolutions = _nj4;
                                                                            vinfos[5].jointtype = 1;
                                                                            vinfos[5].foffset = j5;
                                                                            vinfos[5].indices[0] = _ij5[0];
                                                                            vinfos[5].indices[1] = _ij5[1];
                                                                            vinfos[5].maxsolutions = _nj5;
                                                                            vinfos[6].jointtype = 1;
                                                                            vinfos[6].foffset = j6;
                                                                            vinfos[6].indices[0] = _ij6[0];
                                                                            vinfos[6].indices[1] = _ij6[1];
                                                                            vinfos[6].maxsolutions = _nj6;
                                                                            std::vector<int> vfree(0);
                                                                            solutions.AddSolution(vinfos, vfree);
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                    else
                                                                    {
                                                                      {
                                                                        IkReal j2array[1], cj2array[1], sj2array[1];
                                                                        bool j2valid[1] = { false };
                                                                        _nj2 = 1;
                                                                        CheckValue<IkReal> x179 =
                                                                            IKatan2WithCheck(IkReal(((-1.0) * new_r10)),
                                                                                             IkReal(((-1.0) * new_r11)),
                                                                                             IKFAST_ATAN2_MAGTHRESH);
                                                                        if (!x179.valid)
                                                                        {
                                                                          continue;
                                                                        }
                                                                        CheckValue<IkReal> x180 =
                                                                            IKPowWithIntegerCheck(IKsign(gconst13), -1);
                                                                        if (!x180.valid)
                                                                        {
                                                                          continue;
                                                                        }
                                                                        j2array[0] =
                                                                            ((-1.5707963267949) + (x179.value) +
                                                                             (((1.5707963267949) * (x180.value))));
                                                                        sj2array[0] = IKsin(j2array[0]);
                                                                        cj2array[0] = IKcos(j2array[0]);
                                                                        if (j2array[0] > IKPI)
                                                                        {
                                                                          j2array[0] -= IK2PI;
                                                                        }
                                                                        else if (j2array[0] < -IKPI)
                                                                        {
                                                                          j2array[0] += IK2PI;
                                                                        }
                                                                        j2valid[0] = true;
                                                                        for (int ij2 = 0; ij2 < 1; ++ij2)
                                                                        {
                                                                          if (!j2valid[ij2])
                                                                          {
                                                                            continue;
                                                                          }
                                                                          _ij2[0] = ij2;
                                                                          _ij2[1] = -1;
                                                                          for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                                          {
                                                                            if (j2valid[iij2] &&
                                                                                IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                                    IKFAST_SOLUTION_THRESH &&
                                                                                IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                                    IKFAST_SOLUTION_THRESH)
                                                                            {
                                                                              j2valid[iij2] = false;
                                                                              _ij2[1] = iij2;
                                                                              break;
                                                                            }
                                                                          }
                                                                          j2 = j2array[ij2];
                                                                          cj2 = cj2array[ij2];
                                                                          sj2 = sj2array[ij2];
                                                                          {
                                                                            IkReal evalcond[8];
                                                                            IkReal x181 = IKsin(j2);
                                                                            IkReal x182 = IKcos(j2);
                                                                            if ((((1.0) +
                                                                                  (((-1.0) * (gconst13 * gconst13))))) <
                                                                                -0.00001)
                                                                              continue;
                                                                            IkReal x183 = IKsqrt(
                                                                                ((1.0) +
                                                                                 (((-1.0) * (gconst13 * gconst13)))));
                                                                            evalcond[0] = x182;
                                                                            evalcond[1] = ((-1.0) * x181);
                                                                            evalcond[2] =
                                                                                (((gconst13 * x181)) + new_r10);
                                                                            evalcond[3] =
                                                                                (((gconst13 * x182)) + new_r11);
                                                                            evalcond[4] = (new_r00 + ((x181 * x183)));
                                                                            evalcond[5] = (new_r01 + ((x182 * x183)));
                                                                            evalcond[6] = (((new_r00 * x183)) + x181 +
                                                                                           ((gconst13 * new_r10)));
                                                                            evalcond[7] = (((new_r01 * x183)) + x182 +
                                                                                           ((gconst13 * new_r11)));
                                                                            if (IKabs(evalcond[0]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[1]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[2]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[3]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[4]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[5]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[6]) >
                                                                                    IKFAST_EVALCOND_THRESH ||
                                                                                IKabs(evalcond[7]) >
                                                                                    IKFAST_EVALCOND_THRESH)
                                                                            {
                                                                              continue;
                                                                            }
                                                                          }

                                                                          {
                                                                            std::vector<
                                                                                IkSingleDOFSolutionBase<IkReal> >
                                                                                vinfos(7);
                                                                            vinfos[0].jointtype = 1;
                                                                            vinfos[0].foffset = j0;
                                                                            vinfos[0].indices[0] = _ij0[0];
                                                                            vinfos[0].indices[1] = _ij0[1];
                                                                            vinfos[0].maxsolutions = _nj0;
                                                                            vinfos[1].jointtype = 1;
                                                                            vinfos[1].foffset = j1;
                                                                            vinfos[1].indices[0] = _ij1[0];
                                                                            vinfos[1].indices[1] = _ij1[1];
                                                                            vinfos[1].maxsolutions = _nj1;
                                                                            vinfos[2].jointtype = 1;
                                                                            vinfos[2].foffset = j2;
                                                                            vinfos[2].indices[0] = _ij2[0];
                                                                            vinfos[2].indices[1] = _ij2[1];
                                                                            vinfos[2].maxsolutions = _nj2;
                                                                            vinfos[3].jointtype = 1;
                                                                            vinfos[3].foffset = j3;
                                                                            vinfos[3].indices[0] = _ij3[0];
                                                                            vinfos[3].indices[1] = _ij3[1];
                                                                            vinfos[3].maxsolutions = _nj3;
                                                                            vinfos[4].jointtype = 1;
                                                                            vinfos[4].foffset = j4;
                                                                            vinfos[4].indices[0] = _ij4[0];
                                                                            vinfos[4].indices[1] = _ij4[1];
                                                                            vinfos[4].maxsolutions = _nj4;
                                                                            vinfos[5].jointtype = 1;
                                                                            vinfos[5].foffset = j5;
                                                                            vinfos[5].indices[0] = _ij5[0];
                                                                            vinfos[5].indices[1] = _ij5[1];
                                                                            vinfos[5].maxsolutions = _nj5;
                                                                            vinfos[6].jointtype = 1;
                                                                            vinfos[6].foffset = j6;
                                                                            vinfos[6].indices[0] = _ij6[0];
                                                                            vinfos[6].indices[1] = _ij6[1];
                                                                            vinfos[6].maxsolutions = _nj6;
                                                                            std::vector<int> vfree(0);
                                                                            solutions.AddSolution(vinfos, vfree);
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              } while (0);
                                                              if (bgotonextstatement)
                                                              {
                                                                bool bgotonextstatement = true;
                                                                do
                                                                {
                                                                  if (1)
                                                                  {
                                                                    bgotonextstatement = false;
                                                                    continue;  // branch miss [j2]
                                                                  }
                                                                } while (0);
                                                                if (bgotonextstatement)
                                                                {
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                                else
                                                {
                                                  {
                                                    IkReal j2array[1], cj2array[1], sj2array[1];
                                                    bool j2valid[1] = { false };
                                                    _nj2 = 1;
                                                    IkReal x184 = (new_r01 * new_r22);
                                                    IkReal x185 = (cj0 * new_r11);
                                                    CheckValue<IkReal> x186 = IKPowWithIntegerCheck(cj0, -1);
                                                    if (!x186.valid)
                                                    {
                                                      continue;
                                                    }
                                                    if (IKabs(((x186.value) *
                                                               ((((new_r22 * sj0 * x185)) + ((x184 * (cj0 * cj0))) +
                                                                 (((-1.0) * x184)) + (((-1.0) * new_r10)))))) <
                                                            IKFAST_ATAN2_MAGTHRESH &&
                                                        IKabs((((new_r01 * sj0)) + (((-1.0) * x185)))) <
                                                            IKFAST_ATAN2_MAGTHRESH &&
                                                        IKabs(
                                                            IKsqr(((x186.value) *
                                                                   ((((new_r22 * sj0 * x185)) + ((x184 * (cj0 * cj0))) +
                                                                     (((-1.0) * x184)) + (((-1.0) * new_r10)))))) +
                                                            IKsqr((((new_r01 * sj0)) + (((-1.0) * x185)))) - 1) <=
                                                            IKFAST_SINCOS_THRESH)
                                                      continue;
                                                    j2array[0] =
                                                        IKatan2(((x186.value) *
                                                                 ((((new_r22 * sj0 * x185)) + ((x184 * (cj0 * cj0))) +
                                                                   (((-1.0) * x184)) + (((-1.0) * new_r10))))),
                                                                (((new_r01 * sj0)) + (((-1.0) * x185))));
                                                    sj2array[0] = IKsin(j2array[0]);
                                                    cj2array[0] = IKcos(j2array[0]);
                                                    if (j2array[0] > IKPI)
                                                    {
                                                      j2array[0] -= IK2PI;
                                                    }
                                                    else if (j2array[0] < -IKPI)
                                                    {
                                                      j2array[0] += IK2PI;
                                                    }
                                                    j2valid[0] = true;
                                                    for (int ij2 = 0; ij2 < 1; ++ij2)
                                                    {
                                                      if (!j2valid[ij2])
                                                      {
                                                        continue;
                                                      }
                                                      _ij2[0] = ij2;
                                                      _ij2[1] = -1;
                                                      for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                      {
                                                        if (j2valid[iij2] &&
                                                            IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                IKFAST_SOLUTION_THRESH &&
                                                            IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                IKFAST_SOLUTION_THRESH)
                                                        {
                                                          j2valid[iij2] = false;
                                                          _ij2[1] = iij2;
                                                          break;
                                                        }
                                                      }
                                                      j2 = j2array[ij2];
                                                      cj2 = cj2array[ij2];
                                                      sj2 = sj2array[ij2];
                                                      {
                                                        IkReal evalcond[10];
                                                        IkReal x187 = IKcos(j2);
                                                        IkReal x188 = IKsin(j2);
                                                        IkReal x189 = (cj0 * new_r22);
                                                        IkReal x190 = ((1.0) * sj0);
                                                        IkReal x191 = (new_r22 * sj0);
                                                        IkReal x192 = (new_r22 * x188);
                                                        IkReal x193 = ((1.0) * x188);
                                                        evalcond[0] =
                                                            (x188 + (((-1.0) * new_r00 * x190)) + ((cj0 * new_r10)));
                                                        evalcond[1] =
                                                            (x187 + (((-1.0) * new_r01 * x190)) + ((cj0 * new_r11)));
                                                        evalcond[2] = (((new_r10 * sj0)) + ((new_r22 * x187)) +
                                                                       ((cj0 * new_r00)));
                                                        evalcond[3] = (((new_r10 * x191)) + ((new_r00 * x189)) + x187);
                                                        evalcond[4] = (((cj0 * x188)) + ((x187 * x191)) + new_r10);
                                                        evalcond[5] =
                                                            (((new_r11 * sj0)) + (((-1.0) * x192)) + ((cj0 * new_r01)));
                                                        evalcond[6] =
                                                            ((((-1.0) * x188 * x190)) + ((x187 * x189)) + new_r00);
                                                        evalcond[7] =
                                                            (((cj0 * x187)) + (((-1.0) * x190 * x192)) + new_r11);
                                                        evalcond[8] = (((new_r11 * x191)) + ((new_r01 * x189)) +
                                                                       (((-1.0) * x193)));
                                                        evalcond[9] = ((((-1.0) * x189 * x193)) +
                                                                       (((-1.0) * x187 * x190)) + new_r01);
                                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH)
                                                        {
                                                          continue;
                                                        }
                                                      }

                                                      {
                                                        std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                        vinfos[0].jointtype = 1;
                                                        vinfos[0].foffset = j0;
                                                        vinfos[0].indices[0] = _ij0[0];
                                                        vinfos[0].indices[1] = _ij0[1];
                                                        vinfos[0].maxsolutions = _nj0;
                                                        vinfos[1].jointtype = 1;
                                                        vinfos[1].foffset = j1;
                                                        vinfos[1].indices[0] = _ij1[0];
                                                        vinfos[1].indices[1] = _ij1[1];
                                                        vinfos[1].maxsolutions = _nj1;
                                                        vinfos[2].jointtype = 1;
                                                        vinfos[2].foffset = j2;
                                                        vinfos[2].indices[0] = _ij2[0];
                                                        vinfos[2].indices[1] = _ij2[1];
                                                        vinfos[2].maxsolutions = _nj2;
                                                        vinfos[3].jointtype = 1;
                                                        vinfos[3].foffset = j3;
                                                        vinfos[3].indices[0] = _ij3[0];
                                                        vinfos[3].indices[1] = _ij3[1];
                                                        vinfos[3].maxsolutions = _nj3;
                                                        vinfos[4].jointtype = 1;
                                                        vinfos[4].foffset = j4;
                                                        vinfos[4].indices[0] = _ij4[0];
                                                        vinfos[4].indices[1] = _ij4[1];
                                                        vinfos[4].maxsolutions = _nj4;
                                                        vinfos[5].jointtype = 1;
                                                        vinfos[5].foffset = j5;
                                                        vinfos[5].indices[0] = _ij5[0];
                                                        vinfos[5].indices[1] = _ij5[1];
                                                        vinfos[5].maxsolutions = _nj5;
                                                        vinfos[6].jointtype = 1;
                                                        vinfos[6].foffset = j6;
                                                        vinfos[6].indices[0] = _ij6[0];
                                                        vinfos[6].indices[1] = _ij6[1];
                                                        vinfos[6].maxsolutions = _nj6;
                                                        std::vector<int> vfree(0);
                                                        solutions.AddSolution(vinfos, vfree);
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                            else
                                            {
                                              {
                                                IkReal j2array[1], cj2array[1], sj2array[1];
                                                bool j2valid[1] = { false };
                                                _nj2 = 1;
                                                IkReal x194 = ((1.0) * cj0);
                                                CheckValue<IkReal> x195 = IKPowWithIntegerCheck(new_r22, -1);
                                                if (!x195.valid)
                                                {
                                                  continue;
                                                }
                                                if (IKabs((((new_r00 * sj0)) + (((-1.0) * new_r10 * x194)))) <
                                                        IKFAST_ATAN2_MAGTHRESH &&
                                                    IKabs(((x195.value) * (((((-1.0) * new_r10 * sj0)) +
                                                                            (((-1.0) * new_r00 * x194)))))) <
                                                        IKFAST_ATAN2_MAGTHRESH &&
                                                    IKabs(IKsqr((((new_r00 * sj0)) + (((-1.0) * new_r10 * x194)))) +
                                                          IKsqr(((x195.value) * (((((-1.0) * new_r10 * sj0)) +
                                                                                  (((-1.0) * new_r00 * x194)))))) -
                                                          1) <= IKFAST_SINCOS_THRESH)
                                                  continue;
                                                j2array[0] = IKatan2((((new_r00 * sj0)) + (((-1.0) * new_r10 * x194))),
                                                                     ((x195.value) * (((((-1.0) * new_r10 * sj0)) +
                                                                                       (((-1.0) * new_r00 * x194))))));
                                                sj2array[0] = IKsin(j2array[0]);
                                                cj2array[0] = IKcos(j2array[0]);
                                                if (j2array[0] > IKPI)
                                                {
                                                  j2array[0] -= IK2PI;
                                                }
                                                else if (j2array[0] < -IKPI)
                                                {
                                                  j2array[0] += IK2PI;
                                                }
                                                j2valid[0] = true;
                                                for (int ij2 = 0; ij2 < 1; ++ij2)
                                                {
                                                  if (!j2valid[ij2])
                                                  {
                                                    continue;
                                                  }
                                                  _ij2[0] = ij2;
                                                  _ij2[1] = -1;
                                                  for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                  {
                                                    if (j2valid[iij2] &&
                                                        IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                            IKFAST_SOLUTION_THRESH &&
                                                        IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                                    {
                                                      j2valid[iij2] = false;
                                                      _ij2[1] = iij2;
                                                      break;
                                                    }
                                                  }
                                                  j2 = j2array[ij2];
                                                  cj2 = cj2array[ij2];
                                                  sj2 = sj2array[ij2];
                                                  {
                                                    IkReal evalcond[10];
                                                    IkReal x196 = IKcos(j2);
                                                    IkReal x197 = IKsin(j2);
                                                    IkReal x198 = (cj0 * new_r22);
                                                    IkReal x199 = ((1.0) * sj0);
                                                    IkReal x200 = (new_r22 * sj0);
                                                    IkReal x201 = (new_r22 * x197);
                                                    IkReal x202 = ((1.0) * x197);
                                                    evalcond[0] =
                                                        (x197 + (((-1.0) * new_r00 * x199)) + ((cj0 * new_r10)));
                                                    evalcond[1] =
                                                        (x196 + (((-1.0) * new_r01 * x199)) + ((cj0 * new_r11)));
                                                    evalcond[2] =
                                                        (((new_r10 * sj0)) + ((new_r22 * x196)) + ((cj0 * new_r00)));
                                                    evalcond[3] = (((new_r00 * x198)) + ((new_r10 * x200)) + x196);
                                                    evalcond[4] = (((x196 * x200)) + ((cj0 * x197)) + new_r10);
                                                    evalcond[5] =
                                                        (((new_r11 * sj0)) + ((cj0 * new_r01)) + (((-1.0) * x201)));
                                                    evalcond[6] =
                                                        ((((-1.0) * x197 * x199)) + ((x196 * x198)) + new_r00);
                                                    evalcond[7] = (((cj0 * x196)) + (((-1.0) * x199 * x201)) + new_r11);
                                                    evalcond[8] =
                                                        (((new_r01 * x198)) + ((new_r11 * x200)) + (((-1.0) * x202)));
                                                    evalcond[9] =
                                                        ((((-1.0) * x196 * x199)) + (((-1.0) * x198 * x202)) + new_r01);
                                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH)
                                                    {
                                                      continue;
                                                    }
                                                  }

                                                  {
                                                    std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                    vinfos[0].jointtype = 1;
                                                    vinfos[0].foffset = j0;
                                                    vinfos[0].indices[0] = _ij0[0];
                                                    vinfos[0].indices[1] = _ij0[1];
                                                    vinfos[0].maxsolutions = _nj0;
                                                    vinfos[1].jointtype = 1;
                                                    vinfos[1].foffset = j1;
                                                    vinfos[1].indices[0] = _ij1[0];
                                                    vinfos[1].indices[1] = _ij1[1];
                                                    vinfos[1].maxsolutions = _nj1;
                                                    vinfos[2].jointtype = 1;
                                                    vinfos[2].foffset = j2;
                                                    vinfos[2].indices[0] = _ij2[0];
                                                    vinfos[2].indices[1] = _ij2[1];
                                                    vinfos[2].maxsolutions = _nj2;
                                                    vinfos[3].jointtype = 1;
                                                    vinfos[3].foffset = j3;
                                                    vinfos[3].indices[0] = _ij3[0];
                                                    vinfos[3].indices[1] = _ij3[1];
                                                    vinfos[3].maxsolutions = _nj3;
                                                    vinfos[4].jointtype = 1;
                                                    vinfos[4].foffset = j4;
                                                    vinfos[4].indices[0] = _ij4[0];
                                                    vinfos[4].indices[1] = _ij4[1];
                                                    vinfos[4].maxsolutions = _nj4;
                                                    vinfos[5].jointtype = 1;
                                                    vinfos[5].foffset = j5;
                                                    vinfos[5].indices[0] = _ij5[0];
                                                    vinfos[5].indices[1] = _ij5[1];
                                                    vinfos[5].maxsolutions = _nj5;
                                                    vinfos[6].jointtype = 1;
                                                    vinfos[6].foffset = j6;
                                                    vinfos[6].indices[0] = _ij6[0];
                                                    vinfos[6].indices[1] = _ij6[1];
                                                    vinfos[6].maxsolutions = _nj6;
                                                    std::vector<int> vfree(0);
                                                    solutions.AddSolution(vinfos, vfree);
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                        else
                                        {
                                          {
                                            IkReal j2array[1], cj2array[1], sj2array[1];
                                            bool j2valid[1] = { false };
                                            _nj2 = 1;
                                            IkReal x203 = cj0 * cj0;
                                            IkReal x204 = new_r22 * new_r22;
                                            IkReal x205 = ((1.0) * cj0);
                                            IkReal x206 = (new_r22 * sj0);
                                            CheckValue<IkReal> x207 = IKatan2WithCheck(
                                                IkReal((((new_r11 * x206)) + (((-1.0) * new_r10 * x205)))),
                                                IkReal(((((-1.0) * new_r11 * x205)) + (((-1.0) * new_r10 * x206)))),
                                                IKFAST_ATAN2_MAGTHRESH);
                                            if (!x207.valid)
                                            {
                                              continue;
                                            }
                                            CheckValue<IkReal> x208 = IKPowWithIntegerCheck(
                                                IKsign((x204 + x203 + (((-1.0) * x203 * x204)))), -1);
                                            if (!x208.valid)
                                            {
                                              continue;
                                            }
                                            j2array[0] = ((-1.5707963267949) + (x207.value) +
                                                          (((1.5707963267949) * (x208.value))));
                                            sj2array[0] = IKsin(j2array[0]);
                                            cj2array[0] = IKcos(j2array[0]);
                                            if (j2array[0] > IKPI)
                                            {
                                              j2array[0] -= IK2PI;
                                            }
                                            else if (j2array[0] < -IKPI)
                                            {
                                              j2array[0] += IK2PI;
                                            }
                                            j2valid[0] = true;
                                            for (int ij2 = 0; ij2 < 1; ++ij2)
                                            {
                                              if (!j2valid[ij2])
                                              {
                                                continue;
                                              }
                                              _ij2[0] = ij2;
                                              _ij2[1] = -1;
                                              for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                              {
                                                if (j2valid[iij2] &&
                                                    IKabs(cj2array[ij2] - cj2array[iij2]) < IKFAST_SOLUTION_THRESH &&
                                                    IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                                {
                                                  j2valid[iij2] = false;
                                                  _ij2[1] = iij2;
                                                  break;
                                                }
                                              }
                                              j2 = j2array[ij2];
                                              cj2 = cj2array[ij2];
                                              sj2 = sj2array[ij2];
                                              {
                                                IkReal evalcond[10];
                                                IkReal x209 = IKcos(j2);
                                                IkReal x210 = IKsin(j2);
                                                IkReal x211 = (cj0 * new_r22);
                                                IkReal x212 = ((1.0) * sj0);
                                                IkReal x213 = (new_r22 * sj0);
                                                IkReal x214 = (new_r22 * x210);
                                                IkReal x215 = ((1.0) * x210);
                                                evalcond[0] = (x210 + (((-1.0) * new_r00 * x212)) + ((cj0 * new_r10)));
                                                evalcond[1] = (x209 + (((-1.0) * new_r01 * x212)) + ((cj0 * new_r11)));
                                                evalcond[2] =
                                                    (((new_r10 * sj0)) + ((new_r22 * x209)) + ((cj0 * new_r00)));
                                                evalcond[3] = (x209 + ((new_r00 * x211)) + ((new_r10 * x213)));
                                                evalcond[4] = (((cj0 * x210)) + ((x209 * x213)) + new_r10);
                                                evalcond[5] =
                                                    (((new_r11 * sj0)) + (((-1.0) * x214)) + ((cj0 * new_r01)));
                                                evalcond[6] = (((x209 * x211)) + (((-1.0) * x210 * x212)) + new_r00);
                                                evalcond[7] = (((cj0 * x209)) + new_r11 + (((-1.0) * x212 * x214)));
                                                evalcond[8] =
                                                    (((new_r01 * x211)) + (((-1.0) * x215)) + ((new_r11 * x213)));
                                                evalcond[9] =
                                                    ((((-1.0) * x211 * x215)) + new_r01 + (((-1.0) * x209 * x212)));
                                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH ||
                                                    IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH)
                                                {
                                                  continue;
                                                }
                                              }

                                              {
                                                std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                vinfos[0].jointtype = 1;
                                                vinfos[0].foffset = j0;
                                                vinfos[0].indices[0] = _ij0[0];
                                                vinfos[0].indices[1] = _ij0[1];
                                                vinfos[0].maxsolutions = _nj0;
                                                vinfos[1].jointtype = 1;
                                                vinfos[1].foffset = j1;
                                                vinfos[1].indices[0] = _ij1[0];
                                                vinfos[1].indices[1] = _ij1[1];
                                                vinfos[1].maxsolutions = _nj1;
                                                vinfos[2].jointtype = 1;
                                                vinfos[2].foffset = j2;
                                                vinfos[2].indices[0] = _ij2[0];
                                                vinfos[2].indices[1] = _ij2[1];
                                                vinfos[2].maxsolutions = _nj2;
                                                vinfos[3].jointtype = 1;
                                                vinfos[3].foffset = j3;
                                                vinfos[3].indices[0] = _ij3[0];
                                                vinfos[3].indices[1] = _ij3[1];
                                                vinfos[3].maxsolutions = _nj3;
                                                vinfos[4].jointtype = 1;
                                                vinfos[4].foffset = j4;
                                                vinfos[4].indices[0] = _ij4[0];
                                                vinfos[4].indices[1] = _ij4[1];
                                                vinfos[4].maxsolutions = _nj4;
                                                vinfos[5].jointtype = 1;
                                                vinfos[5].foffset = j5;
                                                vinfos[5].indices[0] = _ij5[0];
                                                vinfos[5].indices[1] = _ij5[1];
                                                vinfos[5].maxsolutions = _nj5;
                                                vinfos[6].jointtype = 1;
                                                vinfos[6].foffset = j6;
                                                vinfos[6].indices[0] = _ij6[0];
                                                vinfos[6].indices[1] = _ij6[1];
                                                vinfos[6].maxsolutions = _nj6;
                                                std::vector<int> vfree(0);
                                                solutions.AddSolution(vinfos, vfree);
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            } while (0);
                            if (bgotonextstatement)
                            {
                              bool bgotonextstatement = true;
                              do
                              {
                                if (1)
                                {
                                  bgotonextstatement = false;
                                  continue;  // branch miss [j0, j2]
                                }
                              } while (0);
                              if (bgotonextstatement)
                              {
                              }
                            }
                          }
                        }
                      }
                    }
                    else
                    {
                      {
                        IkReal j0array[1], cj0array[1], sj0array[1];
                        bool j0valid[1] = { false };
                        _nj0 = 1;
                        CheckValue<IkReal> x217 = IKPowWithIntegerCheck(sj1, -1);
                        if (!x217.valid)
                        {
                          continue;
                        }
                        IkReal x216 = x217.value;
                        CheckValue<IkReal> x218 = IKPowWithIntegerCheck(new_r12, -1);
                        if (!x218.valid)
                        {
                          continue;
                        }
                        if (IKabs((x216 * (x218.value) *
                                   (((1.0) + (((-1.0) * (new_r02 * new_r02))) + (((-1.0) * (cj1 * cj1))))))) <
                                IKFAST_ATAN2_MAGTHRESH &&
                            IKabs((new_r02 * x216)) < IKFAST_ATAN2_MAGTHRESH &&
                            IKabs(IKsqr((x216 * (x218.value) *
                                         (((1.0) + (((-1.0) * (new_r02 * new_r02))) + (((-1.0) * (cj1 * cj1))))))) +
                                  IKsqr((new_r02 * x216)) - 1) <= IKFAST_SINCOS_THRESH)
                          continue;
                        j0array[0] = IKatan2((x216 * (x218.value) *
                                              (((1.0) + (((-1.0) * (new_r02 * new_r02))) + (((-1.0) * (cj1 * cj1)))))),
                                             (new_r02 * x216));
                        sj0array[0] = IKsin(j0array[0]);
                        cj0array[0] = IKcos(j0array[0]);
                        if (j0array[0] > IKPI)
                        {
                          j0array[0] -= IK2PI;
                        }
                        else if (j0array[0] < -IKPI)
                        {
                          j0array[0] += IK2PI;
                        }
                        j0valid[0] = true;
                        for (int ij0 = 0; ij0 < 1; ++ij0)
                        {
                          if (!j0valid[ij0])
                          {
                            continue;
                          }
                          _ij0[0] = ij0;
                          _ij0[1] = -1;
                          for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                          {
                            if (j0valid[iij0] && IKabs(cj0array[ij0] - cj0array[iij0]) < IKFAST_SOLUTION_THRESH &&
                                IKabs(sj0array[ij0] - sj0array[iij0]) < IKFAST_SOLUTION_THRESH)
                            {
                              j0valid[iij0] = false;
                              _ij0[1] = iij0;
                              break;
                            }
                          }
                          j0 = j0array[ij0];
                          cj0 = cj0array[ij0];
                          sj0 = sj0array[ij0];
                          {
                            IkReal evalcond[8];
                            IkReal x219 = IKcos(j0);
                            IkReal x220 = IKsin(j0);
                            IkReal x221 = ((1.0) * cj1);
                            IkReal x222 = ((1.0) * sj1);
                            IkReal x223 = (new_r12 * x220);
                            IkReal x224 = (new_r02 * x219);
                            evalcond[0] = ((((-1.0) * x219 * x222)) + new_r02);
                            evalcond[1] = ((((-1.0) * x220 * x222)) + new_r12);
                            evalcond[2] = (((new_r12 * x219)) + (((-1.0) * new_r02 * x220)));
                            evalcond[3] = (x223 + x224 + (((-1.0) * x222)));
                            evalcond[4] = (((cj1 * x224)) + ((cj1 * x223)) + (((-1.0) * new_r22 * x222)));
                            evalcond[5] = ((((-1.0) * new_r10 * x220 * x222)) + (((-1.0) * new_r00 * x219 * x222)) +
                                           (((-1.0) * new_r20 * x221)));
                            evalcond[6] = ((((-1.0) * new_r11 * x220 * x222)) + (((-1.0) * new_r01 * x219 * x222)) +
                                           (((-1.0) * new_r21 * x221)));
                            evalcond[7] = ((1.0) + (((-1.0) * x222 * x223)) + (((-1.0) * x222 * x224)) +
                                           (((-1.0) * new_r22 * x221)));
                            if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                            {
                              continue;
                            }
                          }

                          {
                            IkReal j2eval[3];
                            j2eval[0] = sj1;
                            j2eval[1] = IKsign(sj1);
                            j2eval[2] = ((IKabs(new_r20)) + (IKabs(new_r21)));
                            if (IKabs(j2eval[0]) < 0.0000010000000000 || IKabs(j2eval[1]) < 0.0000010000000000 ||
                                IKabs(j2eval[2]) < 0.0000010000000000)
                            {
                              {
                                IkReal j2eval[2];
                                j2eval[0] = sj1;
                                j2eval[1] = cj0;
                                if (IKabs(j2eval[0]) < 0.0000010000000000 || IKabs(j2eval[1]) < 0.0000010000000000)
                                {
                                  {
                                    IkReal j2eval[3];
                                    j2eval[0] = sj1;
                                    j2eval[1] = cj1;
                                    j2eval[2] = sj0;
                                    if (IKabs(j2eval[0]) < 0.0000010000000000 ||
                                        IKabs(j2eval[1]) < 0.0000010000000000 || IKabs(j2eval[2]) < 0.0000010000000000)
                                    {
                                      {
                                        IkReal evalcond[5];
                                        bool bgotonextstatement = true;
                                        do
                                        {
                                          evalcond[0] =
                                              ((-3.14159265358979) +
                                               (IKfmod(((3.14159265358979) + (IKabs(j1))), 6.28318530717959)));
                                          evalcond[1] = new_r21;
                                          evalcond[2] = new_r02;
                                          evalcond[3] = new_r12;
                                          evalcond[4] = new_r20;
                                          if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                              IKabs(evalcond[1]) < 0.0000050000000000 &&
                                              IKabs(evalcond[2]) < 0.0000050000000000 &&
                                              IKabs(evalcond[3]) < 0.0000050000000000 &&
                                              IKabs(evalcond[4]) < 0.0000050000000000)
                                          {
                                            bgotonextstatement = false;
                                            {
                                              IkReal j2array[1], cj2array[1], sj2array[1];
                                              bool j2valid[1] = { false };
                                              _nj2 = 1;
                                              IkReal x225 = ((1.0) * cj0);
                                              if (IKabs(((((-1.0) * new_r10 * x225)) + ((new_r00 * sj0)))) <
                                                      IKFAST_ATAN2_MAGTHRESH &&
                                                  IKabs(((((-1.0) * new_r10 * sj0)) + (((-1.0) * new_r00 * x225)))) <
                                                      IKFAST_ATAN2_MAGTHRESH &&
                                                  IKabs(IKsqr(((((-1.0) * new_r10 * x225)) + ((new_r00 * sj0)))) +
                                                        IKsqr(((((-1.0) * new_r10 * sj0)) +
                                                               (((-1.0) * new_r00 * x225)))) -
                                                        1) <= IKFAST_SINCOS_THRESH)
                                                continue;
                                              j2array[0] =
                                                  IKatan2(((((-1.0) * new_r10 * x225)) + ((new_r00 * sj0))),
                                                          ((((-1.0) * new_r10 * sj0)) + (((-1.0) * new_r00 * x225))));
                                              sj2array[0] = IKsin(j2array[0]);
                                              cj2array[0] = IKcos(j2array[0]);
                                              if (j2array[0] > IKPI)
                                              {
                                                j2array[0] -= IK2PI;
                                              }
                                              else if (j2array[0] < -IKPI)
                                              {
                                                j2array[0] += IK2PI;
                                              }
                                              j2valid[0] = true;
                                              for (int ij2 = 0; ij2 < 1; ++ij2)
                                              {
                                                if (!j2valid[ij2])
                                                {
                                                  continue;
                                                }
                                                _ij2[0] = ij2;
                                                _ij2[1] = -1;
                                                for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                {
                                                  if (j2valid[iij2] &&
                                                      IKabs(cj2array[ij2] - cj2array[iij2]) < IKFAST_SOLUTION_THRESH &&
                                                      IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                                  {
                                                    j2valid[iij2] = false;
                                                    _ij2[1] = iij2;
                                                    break;
                                                  }
                                                }
                                                j2 = j2array[ij2];
                                                cj2 = cj2array[ij2];
                                                sj2 = sj2array[ij2];
                                                {
                                                  IkReal evalcond[8];
                                                  IkReal x226 = IKcos(j2);
                                                  IkReal x227 = IKsin(j2);
                                                  IkReal x228 = ((1.0) * sj0);
                                                  IkReal x229 = (cj0 * x226);
                                                  IkReal x230 = (cj0 * x227);
                                                  IkReal x231 = (x227 * x228);
                                                  evalcond[0] = (((new_r10 * sj0)) + x226 + ((cj0 * new_r00)));
                                                  evalcond[1] =
                                                      (x227 + ((cj0 * new_r10)) + (((-1.0) * new_r00 * x228)));
                                                  evalcond[2] =
                                                      ((((-1.0) * new_r01 * x228)) + x226 + ((cj0 * new_r11)));
                                                  evalcond[3] = (((sj0 * x226)) + x230 + new_r10);
                                                  evalcond[4] =
                                                      (((new_r11 * sj0)) + ((cj0 * new_r01)) + (((-1.0) * x227)));
                                                  evalcond[5] = ((((-1.0) * x231)) + x229 + new_r00);
                                                  evalcond[6] = ((((-1.0) * x231)) + x229 + new_r11);
                                                  evalcond[7] =
                                                      (new_r01 + (((-1.0) * x226 * x228)) + (((-1.0) * x230)));
                                                  if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                  {
                                                    continue;
                                                  }
                                                }

                                                {
                                                  std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                  vinfos[0].jointtype = 1;
                                                  vinfos[0].foffset = j0;
                                                  vinfos[0].indices[0] = _ij0[0];
                                                  vinfos[0].indices[1] = _ij0[1];
                                                  vinfos[0].maxsolutions = _nj0;
                                                  vinfos[1].jointtype = 1;
                                                  vinfos[1].foffset = j1;
                                                  vinfos[1].indices[0] = _ij1[0];
                                                  vinfos[1].indices[1] = _ij1[1];
                                                  vinfos[1].maxsolutions = _nj1;
                                                  vinfos[2].jointtype = 1;
                                                  vinfos[2].foffset = j2;
                                                  vinfos[2].indices[0] = _ij2[0];
                                                  vinfos[2].indices[1] = _ij2[1];
                                                  vinfos[2].maxsolutions = _nj2;
                                                  vinfos[3].jointtype = 1;
                                                  vinfos[3].foffset = j3;
                                                  vinfos[3].indices[0] = _ij3[0];
                                                  vinfos[3].indices[1] = _ij3[1];
                                                  vinfos[3].maxsolutions = _nj3;
                                                  vinfos[4].jointtype = 1;
                                                  vinfos[4].foffset = j4;
                                                  vinfos[4].indices[0] = _ij4[0];
                                                  vinfos[4].indices[1] = _ij4[1];
                                                  vinfos[4].maxsolutions = _nj4;
                                                  vinfos[5].jointtype = 1;
                                                  vinfos[5].foffset = j5;
                                                  vinfos[5].indices[0] = _ij5[0];
                                                  vinfos[5].indices[1] = _ij5[1];
                                                  vinfos[5].maxsolutions = _nj5;
                                                  vinfos[6].jointtype = 1;
                                                  vinfos[6].foffset = j6;
                                                  vinfos[6].indices[0] = _ij6[0];
                                                  vinfos[6].indices[1] = _ij6[1];
                                                  vinfos[6].maxsolutions = _nj6;
                                                  std::vector<int> vfree(0);
                                                  solutions.AddSolution(vinfos, vfree);
                                                }
                                              }
                                            }
                                          }
                                        } while (0);
                                        if (bgotonextstatement)
                                        {
                                          bool bgotonextstatement = true;
                                          do
                                          {
                                            evalcond[0] =
                                                ((-3.14159265358979) +
                                                 (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j1)))),
                                                         6.28318530717959)));
                                            evalcond[1] = new_r21;
                                            evalcond[2] = new_r02;
                                            evalcond[3] = new_r12;
                                            evalcond[4] = new_r20;
                                            if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                IKabs(evalcond[1]) < 0.0000050000000000 &&
                                                IKabs(evalcond[2]) < 0.0000050000000000 &&
                                                IKabs(evalcond[3]) < 0.0000050000000000 &&
                                                IKabs(evalcond[4]) < 0.0000050000000000)
                                            {
                                              bgotonextstatement = false;
                                              {
                                                IkReal j2array[1], cj2array[1], sj2array[1];
                                                bool j2valid[1] = { false };
                                                _nj2 = 1;
                                                IkReal x232 = ((1.0) * cj0);
                                                if (IKabs(((((-1.0) * new_r11 * sj0)) + (((-1.0) * new_r10 * x232)))) <
                                                        IKFAST_ATAN2_MAGTHRESH &&
                                                    IKabs((((new_r10 * sj0)) + (((-1.0) * new_r11 * x232)))) <
                                                        IKFAST_ATAN2_MAGTHRESH &&
                                                    IKabs(IKsqr(((((-1.0) * new_r11 * sj0)) +
                                                                 (((-1.0) * new_r10 * x232)))) +
                                                          IKsqr((((new_r10 * sj0)) + (((-1.0) * new_r11 * x232)))) -
                                                          1) <= IKFAST_SINCOS_THRESH)
                                                  continue;
                                                j2array[0] =
                                                    IKatan2(((((-1.0) * new_r11 * sj0)) + (((-1.0) * new_r10 * x232))),
                                                            (((new_r10 * sj0)) + (((-1.0) * new_r11 * x232))));
                                                sj2array[0] = IKsin(j2array[0]);
                                                cj2array[0] = IKcos(j2array[0]);
                                                if (j2array[0] > IKPI)
                                                {
                                                  j2array[0] -= IK2PI;
                                                }
                                                else if (j2array[0] < -IKPI)
                                                {
                                                  j2array[0] += IK2PI;
                                                }
                                                j2valid[0] = true;
                                                for (int ij2 = 0; ij2 < 1; ++ij2)
                                                {
                                                  if (!j2valid[ij2])
                                                  {
                                                    continue;
                                                  }
                                                  _ij2[0] = ij2;
                                                  _ij2[1] = -1;
                                                  for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                  {
                                                    if (j2valid[iij2] &&
                                                        IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                            IKFAST_SOLUTION_THRESH &&
                                                        IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                                    {
                                                      j2valid[iij2] = false;
                                                      _ij2[1] = iij2;
                                                      break;
                                                    }
                                                  }
                                                  j2 = j2array[ij2];
                                                  cj2 = cj2array[ij2];
                                                  sj2 = sj2array[ij2];
                                                  {
                                                    IkReal evalcond[8];
                                                    IkReal x233 = IKsin(j2);
                                                    IkReal x234 = IKcos(j2);
                                                    IkReal x235 = ((1.0) * sj0);
                                                    IkReal x236 = (cj0 * x233);
                                                    IkReal x237 = ((1.0) * x234);
                                                    IkReal x238 = (x234 * x235);
                                                    evalcond[0] = (((new_r11 * sj0)) + x233 + ((cj0 * new_r01)));
                                                    evalcond[1] =
                                                        (x233 + ((cj0 * new_r10)) + (((-1.0) * new_r00 * x235)));
                                                    evalcond[2] =
                                                        (x234 + (((-1.0) * new_r01 * x235)) + ((cj0 * new_r11)));
                                                    evalcond[3] =
                                                        (((new_r10 * sj0)) + (((-1.0) * x237)) + ((cj0 * new_r00)));
                                                    evalcond[4] = (((sj0 * x233)) + new_r11 + ((cj0 * x234)));
                                                    evalcond[5] = ((((-1.0) * x238)) + x236 + new_r10);
                                                    evalcond[6] = ((((-1.0) * x238)) + x236 + new_r01);
                                                    evalcond[7] =
                                                        ((((-1.0) * x233 * x235)) + (((-1.0) * cj0 * x237)) + new_r00);
                                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                        IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                    {
                                                      continue;
                                                    }
                                                  }

                                                  {
                                                    std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                    vinfos[0].jointtype = 1;
                                                    vinfos[0].foffset = j0;
                                                    vinfos[0].indices[0] = _ij0[0];
                                                    vinfos[0].indices[1] = _ij0[1];
                                                    vinfos[0].maxsolutions = _nj0;
                                                    vinfos[1].jointtype = 1;
                                                    vinfos[1].foffset = j1;
                                                    vinfos[1].indices[0] = _ij1[0];
                                                    vinfos[1].indices[1] = _ij1[1];
                                                    vinfos[1].maxsolutions = _nj1;
                                                    vinfos[2].jointtype = 1;
                                                    vinfos[2].foffset = j2;
                                                    vinfos[2].indices[0] = _ij2[0];
                                                    vinfos[2].indices[1] = _ij2[1];
                                                    vinfos[2].maxsolutions = _nj2;
                                                    vinfos[3].jointtype = 1;
                                                    vinfos[3].foffset = j3;
                                                    vinfos[3].indices[0] = _ij3[0];
                                                    vinfos[3].indices[1] = _ij3[1];
                                                    vinfos[3].maxsolutions = _nj3;
                                                    vinfos[4].jointtype = 1;
                                                    vinfos[4].foffset = j4;
                                                    vinfos[4].indices[0] = _ij4[0];
                                                    vinfos[4].indices[1] = _ij4[1];
                                                    vinfos[4].maxsolutions = _nj4;
                                                    vinfos[5].jointtype = 1;
                                                    vinfos[5].foffset = j5;
                                                    vinfos[5].indices[0] = _ij5[0];
                                                    vinfos[5].indices[1] = _ij5[1];
                                                    vinfos[5].maxsolutions = _nj5;
                                                    vinfos[6].jointtype = 1;
                                                    vinfos[6].foffset = j6;
                                                    vinfos[6].indices[0] = _ij6[0];
                                                    vinfos[6].indices[1] = _ij6[1];
                                                    vinfos[6].maxsolutions = _nj6;
                                                    std::vector<int> vfree(0);
                                                    solutions.AddSolution(vinfos, vfree);
                                                  }
                                                }
                                              }
                                            }
                                          } while (0);
                                          if (bgotonextstatement)
                                          {
                                            bool bgotonextstatement = true;
                                            do
                                            {
                                              evalcond[0] =
                                                  ((-3.14159265358979) +
                                                   (IKfmod(((3.14159265358979) + (IKabs(((-1.5707963267949) + j1)))),
                                                           6.28318530717959)));
                                              evalcond[1] = new_r22;
                                              if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                  IKabs(evalcond[1]) < 0.0000050000000000)
                                              {
                                                bgotonextstatement = false;
                                                {
                                                  IkReal j2array[1], cj2array[1], sj2array[1];
                                                  bool j2valid[1] = { false };
                                                  _nj2 = 1;
                                                  if (IKabs(((-1.0) * new_r21)) < IKFAST_ATAN2_MAGTHRESH &&
                                                      IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH &&
                                                      IKabs(IKsqr(((-1.0) * new_r21)) + IKsqr(new_r20) - 1) <=
                                                          IKFAST_SINCOS_THRESH)
                                                    continue;
                                                  j2array[0] = IKatan2(((-1.0) * new_r21), new_r20);
                                                  sj2array[0] = IKsin(j2array[0]);
                                                  cj2array[0] = IKcos(j2array[0]);
                                                  if (j2array[0] > IKPI)
                                                  {
                                                    j2array[0] -= IK2PI;
                                                  }
                                                  else if (j2array[0] < -IKPI)
                                                  {
                                                    j2array[0] += IK2PI;
                                                  }
                                                  j2valid[0] = true;
                                                  for (int ij2 = 0; ij2 < 1; ++ij2)
                                                  {
                                                    if (!j2valid[ij2])
                                                    {
                                                      continue;
                                                    }
                                                    _ij2[0] = ij2;
                                                    _ij2[1] = -1;
                                                    for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                    {
                                                      if (j2valid[iij2] &&
                                                          IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                              IKFAST_SOLUTION_THRESH &&
                                                          IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                              IKFAST_SOLUTION_THRESH)
                                                      {
                                                        j2valid[iij2] = false;
                                                        _ij2[1] = iij2;
                                                        break;
                                                      }
                                                    }
                                                    j2 = j2array[ij2];
                                                    cj2 = cj2array[ij2];
                                                    sj2 = sj2array[ij2];
                                                    {
                                                      IkReal evalcond[8];
                                                      IkReal x239 = IKsin(j2);
                                                      IkReal x240 = IKcos(j2);
                                                      IkReal x241 = ((1.0) * sj0);
                                                      evalcond[0] = (x239 + new_r21);
                                                      evalcond[1] = ((((-1.0) * x240)) + new_r20);
                                                      evalcond[2] = (((new_r02 * x239)) + new_r10);
                                                      evalcond[3] = (((cj0 * x240)) + new_r11);
                                                      evalcond[4] = (new_r00 + (((-1.0) * x239 * x241)));
                                                      evalcond[5] = ((((-1.0) * x240 * x241)) + new_r01);
                                                      evalcond[6] =
                                                          ((((-1.0) * new_r00 * x241)) + x239 + ((cj0 * new_r10)));
                                                      evalcond[7] =
                                                          ((((-1.0) * new_r01 * x241)) + x240 + ((cj0 * new_r11)));
                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                      {
                                                        continue;
                                                      }
                                                    }

                                                    {
                                                      std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                      vinfos[0].jointtype = 1;
                                                      vinfos[0].foffset = j0;
                                                      vinfos[0].indices[0] = _ij0[0];
                                                      vinfos[0].indices[1] = _ij0[1];
                                                      vinfos[0].maxsolutions = _nj0;
                                                      vinfos[1].jointtype = 1;
                                                      vinfos[1].foffset = j1;
                                                      vinfos[1].indices[0] = _ij1[0];
                                                      vinfos[1].indices[1] = _ij1[1];
                                                      vinfos[1].maxsolutions = _nj1;
                                                      vinfos[2].jointtype = 1;
                                                      vinfos[2].foffset = j2;
                                                      vinfos[2].indices[0] = _ij2[0];
                                                      vinfos[2].indices[1] = _ij2[1];
                                                      vinfos[2].maxsolutions = _nj2;
                                                      vinfos[3].jointtype = 1;
                                                      vinfos[3].foffset = j3;
                                                      vinfos[3].indices[0] = _ij3[0];
                                                      vinfos[3].indices[1] = _ij3[1];
                                                      vinfos[3].maxsolutions = _nj3;
                                                      vinfos[4].jointtype = 1;
                                                      vinfos[4].foffset = j4;
                                                      vinfos[4].indices[0] = _ij4[0];
                                                      vinfos[4].indices[1] = _ij4[1];
                                                      vinfos[4].maxsolutions = _nj4;
                                                      vinfos[5].jointtype = 1;
                                                      vinfos[5].foffset = j5;
                                                      vinfos[5].indices[0] = _ij5[0];
                                                      vinfos[5].indices[1] = _ij5[1];
                                                      vinfos[5].maxsolutions = _nj5;
                                                      vinfos[6].jointtype = 1;
                                                      vinfos[6].foffset = j6;
                                                      vinfos[6].indices[0] = _ij6[0];
                                                      vinfos[6].indices[1] = _ij6[1];
                                                      vinfos[6].maxsolutions = _nj6;
                                                      std::vector<int> vfree(0);
                                                      solutions.AddSolution(vinfos, vfree);
                                                    }
                                                  }
                                                }
                                              }
                                            } while (0);
                                            if (bgotonextstatement)
                                            {
                                              bool bgotonextstatement = true;
                                              do
                                              {
                                                evalcond[0] =
                                                    ((-3.14159265358979) +
                                                     (IKfmod(((3.14159265358979) + (IKabs(((1.5707963267949) + j1)))),
                                                             6.28318530717959)));
                                                evalcond[1] = new_r22;
                                                if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                    IKabs(evalcond[1]) < 0.0000050000000000)
                                                {
                                                  bgotonextstatement = false;
                                                  {
                                                    IkReal j2array[1], cj2array[1], sj2array[1];
                                                    bool j2valid[1] = { false };
                                                    _nj2 = 1;
                                                    if (IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH &&
                                                        IKabs(((-1.0) * new_r20)) < IKFAST_ATAN2_MAGTHRESH &&
                                                        IKabs(IKsqr(new_r21) + IKsqr(((-1.0) * new_r20)) - 1) <=
                                                            IKFAST_SINCOS_THRESH)
                                                      continue;
                                                    j2array[0] = IKatan2(new_r21, ((-1.0) * new_r20));
                                                    sj2array[0] = IKsin(j2array[0]);
                                                    cj2array[0] = IKcos(j2array[0]);
                                                    if (j2array[0] > IKPI)
                                                    {
                                                      j2array[0] -= IK2PI;
                                                    }
                                                    else if (j2array[0] < -IKPI)
                                                    {
                                                      j2array[0] += IK2PI;
                                                    }
                                                    j2valid[0] = true;
                                                    for (int ij2 = 0; ij2 < 1; ++ij2)
                                                    {
                                                      if (!j2valid[ij2])
                                                      {
                                                        continue;
                                                      }
                                                      _ij2[0] = ij2;
                                                      _ij2[1] = -1;
                                                      for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                      {
                                                        if (j2valid[iij2] &&
                                                            IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                IKFAST_SOLUTION_THRESH &&
                                                            IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                IKFAST_SOLUTION_THRESH)
                                                        {
                                                          j2valid[iij2] = false;
                                                          _ij2[1] = iij2;
                                                          break;
                                                        }
                                                      }
                                                      j2 = j2array[ij2];
                                                      cj2 = cj2array[ij2];
                                                      sj2 = sj2array[ij2];
                                                      {
                                                        IkReal evalcond[8];
                                                        IkReal x242 = IKcos(j2);
                                                        IkReal x243 = IKsin(j2);
                                                        IkReal x244 = ((1.0) * sj0);
                                                        IkReal x245 = ((1.0) * x243);
                                                        evalcond[0] = (x242 + new_r20);
                                                        evalcond[1] = ((((-1.0) * x245)) + new_r21);
                                                        evalcond[2] = (((cj0 * x242)) + new_r11);
                                                        evalcond[3] = ((((-1.0) * new_r02 * x245)) + new_r10);
                                                        evalcond[4] = ((((-1.0) * x243 * x244)) + new_r00);
                                                        evalcond[5] = ((((-1.0) * x242 * x244)) + new_r01);
                                                        evalcond[6] =
                                                            ((((-1.0) * new_r00 * x244)) + x243 + ((cj0 * new_r10)));
                                                        evalcond[7] =
                                                            ((((-1.0) * new_r01 * x244)) + x242 + ((cj0 * new_r11)));
                                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                            IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                        {
                                                          continue;
                                                        }
                                                      }

                                                      {
                                                        std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                        vinfos[0].jointtype = 1;
                                                        vinfos[0].foffset = j0;
                                                        vinfos[0].indices[0] = _ij0[0];
                                                        vinfos[0].indices[1] = _ij0[1];
                                                        vinfos[0].maxsolutions = _nj0;
                                                        vinfos[1].jointtype = 1;
                                                        vinfos[1].foffset = j1;
                                                        vinfos[1].indices[0] = _ij1[0];
                                                        vinfos[1].indices[1] = _ij1[1];
                                                        vinfos[1].maxsolutions = _nj1;
                                                        vinfos[2].jointtype = 1;
                                                        vinfos[2].foffset = j2;
                                                        vinfos[2].indices[0] = _ij2[0];
                                                        vinfos[2].indices[1] = _ij2[1];
                                                        vinfos[2].maxsolutions = _nj2;
                                                        vinfos[3].jointtype = 1;
                                                        vinfos[3].foffset = j3;
                                                        vinfos[3].indices[0] = _ij3[0];
                                                        vinfos[3].indices[1] = _ij3[1];
                                                        vinfos[3].maxsolutions = _nj3;
                                                        vinfos[4].jointtype = 1;
                                                        vinfos[4].foffset = j4;
                                                        vinfos[4].indices[0] = _ij4[0];
                                                        vinfos[4].indices[1] = _ij4[1];
                                                        vinfos[4].maxsolutions = _nj4;
                                                        vinfos[5].jointtype = 1;
                                                        vinfos[5].foffset = j5;
                                                        vinfos[5].indices[0] = _ij5[0];
                                                        vinfos[5].indices[1] = _ij5[1];
                                                        vinfos[5].maxsolutions = _nj5;
                                                        vinfos[6].jointtype = 1;
                                                        vinfos[6].foffset = j6;
                                                        vinfos[6].indices[0] = _ij6[0];
                                                        vinfos[6].indices[1] = _ij6[1];
                                                        vinfos[6].maxsolutions = _nj6;
                                                        std::vector<int> vfree(0);
                                                        solutions.AddSolution(vinfos, vfree);
                                                      }
                                                    }
                                                  }
                                                }
                                              } while (0);
                                              if (bgotonextstatement)
                                              {
                                                bool bgotonextstatement = true;
                                                do
                                                {
                                                  evalcond[0] =
                                                      ((-3.14159265358979) +
                                                       (IKfmod(((3.14159265358979) + (IKabs(j0))), 6.28318530717959)));
                                                  evalcond[1] = new_r12;
                                                  if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                      IKabs(evalcond[1]) < 0.0000050000000000)
                                                  {
                                                    bgotonextstatement = false;
                                                    {
                                                      IkReal j2array[1], cj2array[1], sj2array[1];
                                                      bool j2valid[1] = { false };
                                                      _nj2 = 1;
                                                      if (IKabs(((-1.0) * new_r10)) < IKFAST_ATAN2_MAGTHRESH &&
                                                          IKabs(((-1.0) * new_r11)) < IKFAST_ATAN2_MAGTHRESH &&
                                                          IKabs(IKsqr(((-1.0) * new_r10)) + IKsqr(((-1.0) * new_r11)) -
                                                                1) <= IKFAST_SINCOS_THRESH)
                                                        continue;
                                                      j2array[0] = IKatan2(((-1.0) * new_r10), ((-1.0) * new_r11));
                                                      sj2array[0] = IKsin(j2array[0]);
                                                      cj2array[0] = IKcos(j2array[0]);
                                                      if (j2array[0] > IKPI)
                                                      {
                                                        j2array[0] -= IK2PI;
                                                      }
                                                      else if (j2array[0] < -IKPI)
                                                      {
                                                        j2array[0] += IK2PI;
                                                      }
                                                      j2valid[0] = true;
                                                      for (int ij2 = 0; ij2 < 1; ++ij2)
                                                      {
                                                        if (!j2valid[ij2])
                                                        {
                                                          continue;
                                                        }
                                                        _ij2[0] = ij2;
                                                        _ij2[1] = -1;
                                                        for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                        {
                                                          if (j2valid[iij2] &&
                                                              IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                  IKFAST_SOLUTION_THRESH &&
                                                              IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                  IKFAST_SOLUTION_THRESH)
                                                          {
                                                            j2valid[iij2] = false;
                                                            _ij2[1] = iij2;
                                                            break;
                                                          }
                                                        }
                                                        j2 = j2array[ij2];
                                                        cj2 = cj2array[ij2];
                                                        sj2 = sj2array[ij2];
                                                        {
                                                          IkReal evalcond[8];
                                                          IkReal x246 = IKsin(j2);
                                                          IkReal x247 = IKcos(j2);
                                                          IkReal x248 = ((1.0) * sj1);
                                                          IkReal x249 = ((1.0) * x246);
                                                          evalcond[0] = (x246 + new_r10);
                                                          evalcond[1] = (x247 + new_r11);
                                                          evalcond[2] = (new_r21 + ((sj1 * x246)));
                                                          evalcond[3] = (((cj1 * x247)) + new_r00);
                                                          evalcond[4] = (new_r20 + (((-1.0) * x247 * x248)));
                                                          evalcond[5] = ((((-1.0) * cj1 * x249)) + new_r01);
                                                          evalcond[6] =
                                                              (((cj1 * new_r00)) + x247 + (((-1.0) * new_r20 * x248)));
                                                          evalcond[7] = ((((-1.0) * new_r21 * x248)) +
                                                                         ((cj1 * new_r01)) + (((-1.0) * x249)));
                                                          if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                              IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                          {
                                                            continue;
                                                          }
                                                        }

                                                        {
                                                          std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                          vinfos[0].jointtype = 1;
                                                          vinfos[0].foffset = j0;
                                                          vinfos[0].indices[0] = _ij0[0];
                                                          vinfos[0].indices[1] = _ij0[1];
                                                          vinfos[0].maxsolutions = _nj0;
                                                          vinfos[1].jointtype = 1;
                                                          vinfos[1].foffset = j1;
                                                          vinfos[1].indices[0] = _ij1[0];
                                                          vinfos[1].indices[1] = _ij1[1];
                                                          vinfos[1].maxsolutions = _nj1;
                                                          vinfos[2].jointtype = 1;
                                                          vinfos[2].foffset = j2;
                                                          vinfos[2].indices[0] = _ij2[0];
                                                          vinfos[2].indices[1] = _ij2[1];
                                                          vinfos[2].maxsolutions = _nj2;
                                                          vinfos[3].jointtype = 1;
                                                          vinfos[3].foffset = j3;
                                                          vinfos[3].indices[0] = _ij3[0];
                                                          vinfos[3].indices[1] = _ij3[1];
                                                          vinfos[3].maxsolutions = _nj3;
                                                          vinfos[4].jointtype = 1;
                                                          vinfos[4].foffset = j4;
                                                          vinfos[4].indices[0] = _ij4[0];
                                                          vinfos[4].indices[1] = _ij4[1];
                                                          vinfos[4].maxsolutions = _nj4;
                                                          vinfos[5].jointtype = 1;
                                                          vinfos[5].foffset = j5;
                                                          vinfos[5].indices[0] = _ij5[0];
                                                          vinfos[5].indices[1] = _ij5[1];
                                                          vinfos[5].maxsolutions = _nj5;
                                                          vinfos[6].jointtype = 1;
                                                          vinfos[6].foffset = j6;
                                                          vinfos[6].indices[0] = _ij6[0];
                                                          vinfos[6].indices[1] = _ij6[1];
                                                          vinfos[6].maxsolutions = _nj6;
                                                          std::vector<int> vfree(0);
                                                          solutions.AddSolution(vinfos, vfree);
                                                        }
                                                      }
                                                    }
                                                  }
                                                } while (0);
                                                if (bgotonextstatement)
                                                {
                                                  bool bgotonextstatement = true;
                                                  do
                                                  {
                                                    evalcond[0] = ((-3.14159265358979) +
                                                                   (IKfmod(((3.14159265358979) +
                                                                            (IKabs(((-3.14159265358979) + j0)))),
                                                                           6.28318530717959)));
                                                    evalcond[1] = new_r12;
                                                    if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                        IKabs(evalcond[1]) < 0.0000050000000000)
                                                    {
                                                      bgotonextstatement = false;
                                                      {
                                                        IkReal j2array[1], cj2array[1], sj2array[1];
                                                        bool j2valid[1] = { false };
                                                        _nj2 = 1;
                                                        if (IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH &&
                                                            IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH &&
                                                            IKabs(IKsqr(new_r10) + IKsqr(new_r11) - 1) <=
                                                                IKFAST_SINCOS_THRESH)
                                                          continue;
                                                        j2array[0] = IKatan2(new_r10, new_r11);
                                                        sj2array[0] = IKsin(j2array[0]);
                                                        cj2array[0] = IKcos(j2array[0]);
                                                        if (j2array[0] > IKPI)
                                                        {
                                                          j2array[0] -= IK2PI;
                                                        }
                                                        else if (j2array[0] < -IKPI)
                                                        {
                                                          j2array[0] += IK2PI;
                                                        }
                                                        j2valid[0] = true;
                                                        for (int ij2 = 0; ij2 < 1; ++ij2)
                                                        {
                                                          if (!j2valid[ij2])
                                                          {
                                                            continue;
                                                          }
                                                          _ij2[0] = ij2;
                                                          _ij2[1] = -1;
                                                          for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                          {
                                                            if (j2valid[iij2] &&
                                                                IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                    IKFAST_SOLUTION_THRESH &&
                                                                IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                    IKFAST_SOLUTION_THRESH)
                                                            {
                                                              j2valid[iij2] = false;
                                                              _ij2[1] = iij2;
                                                              break;
                                                            }
                                                          }
                                                          j2 = j2array[ij2];
                                                          cj2 = cj2array[ij2];
                                                          sj2 = sj2array[ij2];
                                                          {
                                                            IkReal evalcond[8];
                                                            IkReal x250 = IKsin(j2);
                                                            IkReal x251 = IKcos(j2);
                                                            IkReal x252 = ((1.0) * sj1);
                                                            IkReal x253 = ((1.0) * new_r00);
                                                            IkReal x254 = ((1.0) * new_r01);
                                                            IkReal x255 = ((1.0) * x250);
                                                            evalcond[0] = (((sj1 * x250)) + new_r21);
                                                            evalcond[1] = (x250 + (((-1.0) * new_r10)));
                                                            evalcond[2] = (x251 + (((-1.0) * new_r11)));
                                                            evalcond[3] = ((((-1.0) * x251 * x252)) + new_r20);
                                                            evalcond[4] = (((cj1 * x251)) + (((-1.0) * x253)));
                                                            evalcond[5] = ((((-1.0) * cj1 * x255)) + (((-1.0) * x254)));
                                                            evalcond[6] = (x251 + (((-1.0) * cj1 * x253)) +
                                                                           (((-1.0) * new_r20 * x252)));
                                                            evalcond[7] = ((((-1.0) * new_r21 * x252)) +
                                                                           (((-1.0) * cj1 * x254)) + (((-1.0) * x255)));
                                                            if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                            {
                                                              continue;
                                                            }
                                                          }

                                                          {
                                                            std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                            vinfos[0].jointtype = 1;
                                                            vinfos[0].foffset = j0;
                                                            vinfos[0].indices[0] = _ij0[0];
                                                            vinfos[0].indices[1] = _ij0[1];
                                                            vinfos[0].maxsolutions = _nj0;
                                                            vinfos[1].jointtype = 1;
                                                            vinfos[1].foffset = j1;
                                                            vinfos[1].indices[0] = _ij1[0];
                                                            vinfos[1].indices[1] = _ij1[1];
                                                            vinfos[1].maxsolutions = _nj1;
                                                            vinfos[2].jointtype = 1;
                                                            vinfos[2].foffset = j2;
                                                            vinfos[2].indices[0] = _ij2[0];
                                                            vinfos[2].indices[1] = _ij2[1];
                                                            vinfos[2].maxsolutions = _nj2;
                                                            vinfos[3].jointtype = 1;
                                                            vinfos[3].foffset = j3;
                                                            vinfos[3].indices[0] = _ij3[0];
                                                            vinfos[3].indices[1] = _ij3[1];
                                                            vinfos[3].maxsolutions = _nj3;
                                                            vinfos[4].jointtype = 1;
                                                            vinfos[4].foffset = j4;
                                                            vinfos[4].indices[0] = _ij4[0];
                                                            vinfos[4].indices[1] = _ij4[1];
                                                            vinfos[4].maxsolutions = _nj4;
                                                            vinfos[5].jointtype = 1;
                                                            vinfos[5].foffset = j5;
                                                            vinfos[5].indices[0] = _ij5[0];
                                                            vinfos[5].indices[1] = _ij5[1];
                                                            vinfos[5].maxsolutions = _nj5;
                                                            vinfos[6].jointtype = 1;
                                                            vinfos[6].foffset = j6;
                                                            vinfos[6].indices[0] = _ij6[0];
                                                            vinfos[6].indices[1] = _ij6[1];
                                                            vinfos[6].maxsolutions = _nj6;
                                                            std::vector<int> vfree(0);
                                                            solutions.AddSolution(vinfos, vfree);
                                                          }
                                                        }
                                                      }
                                                    }
                                                  } while (0);
                                                  if (bgotonextstatement)
                                                  {
                                                    bool bgotonextstatement = true;
                                                    do
                                                    {
                                                      evalcond[0] = ((-3.14159265358979) +
                                                                     (IKfmod(((3.14159265358979) +
                                                                              (IKabs(((-1.5707963267949) + j0)))),
                                                                             6.28318530717959)));
                                                      evalcond[1] = new_r02;
                                                      if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                          IKabs(evalcond[1]) < 0.0000050000000000)
                                                      {
                                                        bgotonextstatement = false;
                                                        {
                                                          IkReal j2array[1], cj2array[1], sj2array[1];
                                                          bool j2valid[1] = { false };
                                                          _nj2 = 1;
                                                          if (IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH &&
                                                              IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH &&
                                                              IKabs(IKsqr(new_r00) + IKsqr(new_r01) - 1) <=
                                                                  IKFAST_SINCOS_THRESH)
                                                            continue;
                                                          j2array[0] = IKatan2(new_r00, new_r01);
                                                          sj2array[0] = IKsin(j2array[0]);
                                                          cj2array[0] = IKcos(j2array[0]);
                                                          if (j2array[0] > IKPI)
                                                          {
                                                            j2array[0] -= IK2PI;
                                                          }
                                                          else if (j2array[0] < -IKPI)
                                                          {
                                                            j2array[0] += IK2PI;
                                                          }
                                                          j2valid[0] = true;
                                                          for (int ij2 = 0; ij2 < 1; ++ij2)
                                                          {
                                                            if (!j2valid[ij2])
                                                            {
                                                              continue;
                                                            }
                                                            _ij2[0] = ij2;
                                                            _ij2[1] = -1;
                                                            for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                            {
                                                              if (j2valid[iij2] &&
                                                                  IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                      IKFAST_SOLUTION_THRESH &&
                                                                  IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                      IKFAST_SOLUTION_THRESH)
                                                              {
                                                                j2valid[iij2] = false;
                                                                _ij2[1] = iij2;
                                                                break;
                                                              }
                                                            }
                                                            j2 = j2array[ij2];
                                                            cj2 = cj2array[ij2];
                                                            sj2 = sj2array[ij2];
                                                            {
                                                              IkReal evalcond[8];
                                                              IkReal x256 = IKsin(j2);
                                                              IkReal x257 = IKcos(j2);
                                                              IkReal x258 = ((1.0) * sj1);
                                                              IkReal x259 = ((1.0) * x256);
                                                              evalcond[0] = (((sj1 * x256)) + new_r21);
                                                              evalcond[1] = (x256 + (((-1.0) * new_r00)));
                                                              evalcond[2] = (x257 + (((-1.0) * new_r01)));
                                                              evalcond[3] = (((cj1 * x257)) + new_r10);
                                                              evalcond[4] = ((((-1.0) * x257 * x258)) + new_r20);
                                                              evalcond[5] = ((((-1.0) * cj1 * x259)) + new_r11);
                                                              evalcond[6] = (((cj1 * new_r10)) + x257 +
                                                                             (((-1.0) * new_r20 * x258)));
                                                              evalcond[7] = ((((-1.0) * new_r21 * x258)) +
                                                                             ((cj1 * new_r11)) + (((-1.0) * x259)));
                                                              if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                  IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                              {
                                                                continue;
                                                              }
                                                            }

                                                            {
                                                              std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                              vinfos[0].jointtype = 1;
                                                              vinfos[0].foffset = j0;
                                                              vinfos[0].indices[0] = _ij0[0];
                                                              vinfos[0].indices[1] = _ij0[1];
                                                              vinfos[0].maxsolutions = _nj0;
                                                              vinfos[1].jointtype = 1;
                                                              vinfos[1].foffset = j1;
                                                              vinfos[1].indices[0] = _ij1[0];
                                                              vinfos[1].indices[1] = _ij1[1];
                                                              vinfos[1].maxsolutions = _nj1;
                                                              vinfos[2].jointtype = 1;
                                                              vinfos[2].foffset = j2;
                                                              vinfos[2].indices[0] = _ij2[0];
                                                              vinfos[2].indices[1] = _ij2[1];
                                                              vinfos[2].maxsolutions = _nj2;
                                                              vinfos[3].jointtype = 1;
                                                              vinfos[3].foffset = j3;
                                                              vinfos[3].indices[0] = _ij3[0];
                                                              vinfos[3].indices[1] = _ij3[1];
                                                              vinfos[3].maxsolutions = _nj3;
                                                              vinfos[4].jointtype = 1;
                                                              vinfos[4].foffset = j4;
                                                              vinfos[4].indices[0] = _ij4[0];
                                                              vinfos[4].indices[1] = _ij4[1];
                                                              vinfos[4].maxsolutions = _nj4;
                                                              vinfos[5].jointtype = 1;
                                                              vinfos[5].foffset = j5;
                                                              vinfos[5].indices[0] = _ij5[0];
                                                              vinfos[5].indices[1] = _ij5[1];
                                                              vinfos[5].maxsolutions = _nj5;
                                                              vinfos[6].jointtype = 1;
                                                              vinfos[6].foffset = j6;
                                                              vinfos[6].indices[0] = _ij6[0];
                                                              vinfos[6].indices[1] = _ij6[1];
                                                              vinfos[6].maxsolutions = _nj6;
                                                              std::vector<int> vfree(0);
                                                              solutions.AddSolution(vinfos, vfree);
                                                            }
                                                          }
                                                        }
                                                      }
                                                    } while (0);
                                                    if (bgotonextstatement)
                                                    {
                                                      bool bgotonextstatement = true;
                                                      do
                                                      {
                                                        evalcond[0] = ((-3.14159265358979) +
                                                                       (IKfmod(((3.14159265358979) +
                                                                                (IKabs(((1.5707963267949) + j0)))),
                                                                               6.28318530717959)));
                                                        evalcond[1] = new_r02;
                                                        if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                            IKabs(evalcond[1]) < 0.0000050000000000)
                                                        {
                                                          bgotonextstatement = false;
                                                          {
                                                            IkReal j2array[1], cj2array[1], sj2array[1];
                                                            bool j2valid[1] = { false };
                                                            _nj2 = 1;
                                                            if (IKabs(((-1.0) * new_r00)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                IKabs(((-1.0) * new_r01)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                IKabs(IKsqr(((-1.0) * new_r00)) +
                                                                      IKsqr(((-1.0) * new_r01)) - 1) <=
                                                                    IKFAST_SINCOS_THRESH)
                                                              continue;
                                                            j2array[0] =
                                                                IKatan2(((-1.0) * new_r00), ((-1.0) * new_r01));
                                                            sj2array[0] = IKsin(j2array[0]);
                                                            cj2array[0] = IKcos(j2array[0]);
                                                            if (j2array[0] > IKPI)
                                                            {
                                                              j2array[0] -= IK2PI;
                                                            }
                                                            else if (j2array[0] < -IKPI)
                                                            {
                                                              j2array[0] += IK2PI;
                                                            }
                                                            j2valid[0] = true;
                                                            for (int ij2 = 0; ij2 < 1; ++ij2)
                                                            {
                                                              if (!j2valid[ij2])
                                                              {
                                                                continue;
                                                              }
                                                              _ij2[0] = ij2;
                                                              _ij2[1] = -1;
                                                              for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                                              {
                                                                if (j2valid[iij2] &&
                                                                    IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                        IKFAST_SOLUTION_THRESH &&
                                                                    IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                        IKFAST_SOLUTION_THRESH)
                                                                {
                                                                  j2valid[iij2] = false;
                                                                  _ij2[1] = iij2;
                                                                  break;
                                                                }
                                                              }
                                                              j2 = j2array[ij2];
                                                              cj2 = cj2array[ij2];
                                                              sj2 = sj2array[ij2];
                                                              {
                                                                IkReal evalcond[8];
                                                                IkReal x260 = IKsin(j2);
                                                                IkReal x261 = IKcos(j2);
                                                                IkReal x262 = ((1.0) * new_r11);
                                                                IkReal x263 = ((1.0) * sj1);
                                                                IkReal x264 = ((1.0) * new_r10);
                                                                IkReal x265 = ((1.0) * x260);
                                                                evalcond[0] = (x260 + new_r00);
                                                                evalcond[1] = (x261 + new_r01);
                                                                evalcond[2] = (new_r21 + ((sj1 * x260)));
                                                                evalcond[3] = ((((-1.0) * x261 * x263)) + new_r20);
                                                                evalcond[4] = (((cj1 * x261)) + (((-1.0) * x264)));
                                                                evalcond[5] =
                                                                    ((((-1.0) * cj1 * x265)) + (((-1.0) * x262)));
                                                                evalcond[6] = ((((-1.0) * cj1 * x264)) + x261 +
                                                                               (((-1.0) * new_r20 * x263)));
                                                                evalcond[7] =
                                                                    ((((-1.0) * cj1 * x262)) +
                                                                     (((-1.0) * new_r21 * x263)) + (((-1.0) * x265)));
                                                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                {
                                                                  continue;
                                                                }
                                                              }

                                                              {
                                                                std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                                vinfos[0].jointtype = 1;
                                                                vinfos[0].foffset = j0;
                                                                vinfos[0].indices[0] = _ij0[0];
                                                                vinfos[0].indices[1] = _ij0[1];
                                                                vinfos[0].maxsolutions = _nj0;
                                                                vinfos[1].jointtype = 1;
                                                                vinfos[1].foffset = j1;
                                                                vinfos[1].indices[0] = _ij1[0];
                                                                vinfos[1].indices[1] = _ij1[1];
                                                                vinfos[1].maxsolutions = _nj1;
                                                                vinfos[2].jointtype = 1;
                                                                vinfos[2].foffset = j2;
                                                                vinfos[2].indices[0] = _ij2[0];
                                                                vinfos[2].indices[1] = _ij2[1];
                                                                vinfos[2].maxsolutions = _nj2;
                                                                vinfos[3].jointtype = 1;
                                                                vinfos[3].foffset = j3;
                                                                vinfos[3].indices[0] = _ij3[0];
                                                                vinfos[3].indices[1] = _ij3[1];
                                                                vinfos[3].maxsolutions = _nj3;
                                                                vinfos[4].jointtype = 1;
                                                                vinfos[4].foffset = j4;
                                                                vinfos[4].indices[0] = _ij4[0];
                                                                vinfos[4].indices[1] = _ij4[1];
                                                                vinfos[4].maxsolutions = _nj4;
                                                                vinfos[5].jointtype = 1;
                                                                vinfos[5].foffset = j5;
                                                                vinfos[5].indices[0] = _ij5[0];
                                                                vinfos[5].indices[1] = _ij5[1];
                                                                vinfos[5].maxsolutions = _nj5;
                                                                vinfos[6].jointtype = 1;
                                                                vinfos[6].foffset = j6;
                                                                vinfos[6].indices[0] = _ij6[0];
                                                                vinfos[6].indices[1] = _ij6[1];
                                                                vinfos[6].maxsolutions = _nj6;
                                                                std::vector<int> vfree(0);
                                                                solutions.AddSolution(vinfos, vfree);
                                                              }
                                                            }
                                                          }
                                                        }
                                                      } while (0);
                                                      if (bgotonextstatement)
                                                      {
                                                        bool bgotonextstatement = true;
                                                        do
                                                        {
                                                          evalcond[0] = ((IKabs(new_r20)) + (IKabs(new_r21)));
                                                          if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                          {
                                                            bgotonextstatement = false;
                                                            {
                                                              IkReal j2eval[1];
                                                              new_r21 = 0;
                                                              new_r20 = 0;
                                                              new_r02 = 0;
                                                              new_r12 = 0;
                                                              j2eval[0] = IKabs(new_r22);
                                                              if (IKabs(j2eval[0]) < 0.0000000100000000)
                                                              {
                                                                continue;  // no branches [j2]
                                                              }
                                                              else
                                                              {
                                                                IkReal op[2 + 1], zeror[2];
                                                                int numroots;
                                                                op[0] = ((-1.0) * new_r22);
                                                                op[1] = 0;
                                                                op[2] = new_r22;
                                                                polyroots2(op, zeror, numroots);
                                                                IkReal j2array[2], cj2array[2], sj2array[2],
                                                                    tempj2array[1];
                                                                int numsolutions = 0;
                                                                for (int ij2 = 0; ij2 < numroots; ++ij2)
                                                                {
                                                                  IkReal htj2 = zeror[ij2];
                                                                  tempj2array[0] = ((2.0) * (atan(htj2)));
                                                                  for (int kj2 = 0; kj2 < 1; ++kj2)
                                                                  {
                                                                    j2array[numsolutions] = tempj2array[kj2];
                                                                    if (j2array[numsolutions] > IKPI)
                                                                    {
                                                                      j2array[numsolutions] -= IK2PI;
                                                                    }
                                                                    else if (j2array[numsolutions] < -IKPI)
                                                                    {
                                                                      j2array[numsolutions] += IK2PI;
                                                                    }
                                                                    sj2array[numsolutions] =
                                                                        IKsin(j2array[numsolutions]);
                                                                    cj2array[numsolutions] =
                                                                        IKcos(j2array[numsolutions]);
                                                                    numsolutions++;
                                                                  }
                                                                }
                                                                bool j2valid[2] = { true, true };
                                                                _nj2 = 2;
                                                                for (int ij2 = 0; ij2 < numsolutions; ++ij2)
                                                                {
                                                                  if (!j2valid[ij2])
                                                                  {
                                                                    continue;
                                                                  }
                                                                  j2 = j2array[ij2];
                                                                  cj2 = cj2array[ij2];
                                                                  sj2 = sj2array[ij2];
                                                                  htj2 = IKtan(j2 / 2);

                                                                  _ij2[0] = ij2;
                                                                  _ij2[1] = -1;
                                                                  for (int iij2 = ij2 + 1; iij2 < numsolutions; ++iij2)
                                                                  {
                                                                    if (j2valid[iij2] &&
                                                                        IKabs(cj2array[ij2] - cj2array[iij2]) <
                                                                            IKFAST_SOLUTION_THRESH &&
                                                                        IKabs(sj2array[ij2] - sj2array[iij2]) <
                                                                            IKFAST_SOLUTION_THRESH)
                                                                    {
                                                                      j2valid[iij2] = false;
                                                                      _ij2[1] = iij2;
                                                                      break;
                                                                    }
                                                                  }
                                                                  {
                                                                    std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                        vinfos(7);
                                                                    vinfos[0].jointtype = 1;
                                                                    vinfos[0].foffset = j0;
                                                                    vinfos[0].indices[0] = _ij0[0];
                                                                    vinfos[0].indices[1] = _ij0[1];
                                                                    vinfos[0].maxsolutions = _nj0;
                                                                    vinfos[1].jointtype = 1;
                                                                    vinfos[1].foffset = j1;
                                                                    vinfos[1].indices[0] = _ij1[0];
                                                                    vinfos[1].indices[1] = _ij1[1];
                                                                    vinfos[1].maxsolutions = _nj1;
                                                                    vinfos[2].jointtype = 1;
                                                                    vinfos[2].foffset = j2;
                                                                    vinfos[2].indices[0] = _ij2[0];
                                                                    vinfos[2].indices[1] = _ij2[1];
                                                                    vinfos[2].maxsolutions = _nj2;
                                                                    vinfos[3].jointtype = 1;
                                                                    vinfos[3].foffset = j3;
                                                                    vinfos[3].indices[0] = _ij3[0];
                                                                    vinfos[3].indices[1] = _ij3[1];
                                                                    vinfos[3].maxsolutions = _nj3;
                                                                    vinfos[4].jointtype = 1;
                                                                    vinfos[4].foffset = j4;
                                                                    vinfos[4].indices[0] = _ij4[0];
                                                                    vinfos[4].indices[1] = _ij4[1];
                                                                    vinfos[4].maxsolutions = _nj4;
                                                                    vinfos[5].jointtype = 1;
                                                                    vinfos[5].foffset = j5;
                                                                    vinfos[5].indices[0] = _ij5[0];
                                                                    vinfos[5].indices[1] = _ij5[1];
                                                                    vinfos[5].maxsolutions = _nj5;
                                                                    vinfos[6].jointtype = 1;
                                                                    vinfos[6].foffset = j6;
                                                                    vinfos[6].indices[0] = _ij6[0];
                                                                    vinfos[6].indices[1] = _ij6[1];
                                                                    vinfos[6].maxsolutions = _nj6;
                                                                    std::vector<int> vfree(0);
                                                                    solutions.AddSolution(vinfos, vfree);
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        } while (0);
                                                        if (bgotonextstatement)
                                                        {
                                                          bool bgotonextstatement = true;
                                                          do
                                                          {
                                                            if (1)
                                                            {
                                                              bgotonextstatement = false;
                                                              continue;  // branch miss [j2]
                                                            }
                                                          } while (0);
                                                          if (bgotonextstatement)
                                                          {
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                    else
                                    {
                                      {
                                        IkReal j2array[1], cj2array[1], sj2array[1];
                                        bool j2valid[1] = { false };
                                        _nj2 = 1;
                                        CheckValue<IkReal> x267 = IKPowWithIntegerCheck(sj1, -1);
                                        if (!x267.valid)
                                        {
                                          continue;
                                        }
                                        IkReal x266 = x267.value;
                                        CheckValue<IkReal> x268 = IKPowWithIntegerCheck(cj1, -1);
                                        if (!x268.valid)
                                        {
                                          continue;
                                        }
                                        CheckValue<IkReal> x269 = IKPowWithIntegerCheck(sj0, -1);
                                        if (!x269.valid)
                                        {
                                          continue;
                                        }
                                        if (IKabs(((-1.0) * new_r21 * x266)) < IKFAST_ATAN2_MAGTHRESH &&
                                            IKabs((x266 * (x268.value) * (x269.value) *
                                                   ((((cj0 * new_r21)) + (((-1.0) * new_r10 * sj1)))))) <
                                                IKFAST_ATAN2_MAGTHRESH &&
                                            IKabs(IKsqr(((-1.0) * new_r21 * x266)) +
                                                  IKsqr((x266 * (x268.value) * (x269.value) *
                                                         ((((cj0 * new_r21)) + (((-1.0) * new_r10 * sj1)))))) -
                                                  1) <= IKFAST_SINCOS_THRESH)
                                          continue;
                                        j2array[0] = IKatan2(((-1.0) * new_r21 * x266),
                                                             (x266 * (x268.value) * (x269.value) *
                                                              ((((cj0 * new_r21)) + (((-1.0) * new_r10 * sj1))))));
                                        sj2array[0] = IKsin(j2array[0]);
                                        cj2array[0] = IKcos(j2array[0]);
                                        if (j2array[0] > IKPI)
                                        {
                                          j2array[0] -= IK2PI;
                                        }
                                        else if (j2array[0] < -IKPI)
                                        {
                                          j2array[0] += IK2PI;
                                        }
                                        j2valid[0] = true;
                                        for (int ij2 = 0; ij2 < 1; ++ij2)
                                        {
                                          if (!j2valid[ij2])
                                          {
                                            continue;
                                          }
                                          _ij2[0] = ij2;
                                          _ij2[1] = -1;
                                          for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                          {
                                            if (j2valid[iij2] &&
                                                IKabs(cj2array[ij2] - cj2array[iij2]) < IKFAST_SOLUTION_THRESH &&
                                                IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                            {
                                              j2valid[iij2] = false;
                                              _ij2[1] = iij2;
                                              break;
                                            }
                                          }
                                          j2 = j2array[ij2];
                                          cj2 = cj2array[ij2];
                                          sj2 = sj2array[ij2];
                                          {
                                            IkReal evalcond[12];
                                            IkReal x270 = IKsin(j2);
                                            IkReal x271 = IKcos(j2);
                                            IkReal x272 = ((1.0) * sj0);
                                            IkReal x273 = ((1.0) * sj1);
                                            IkReal x274 = (cj0 * new_r00);
                                            IkReal x275 = (cj1 * sj0);
                                            IkReal x276 = (cj0 * new_r01);
                                            IkReal x277 = (cj1 * x271);
                                            IkReal x278 = (cj1 * x270);
                                            evalcond[0] = (new_r21 + ((sj1 * x270)));
                                            evalcond[1] = ((((-1.0) * x271 * x273)) + new_r20);
                                            evalcond[2] = ((((-1.0) * new_r00 * x272)) + x270 + ((cj0 * new_r10)));
                                            evalcond[3] = ((((-1.0) * new_r01 * x272)) + x271 + ((cj0 * new_r11)));
                                            evalcond[4] = (((new_r10 * sj0)) + x277 + x274);
                                            evalcond[5] = (((x271 * x275)) + new_r10 + ((cj0 * x270)));
                                            evalcond[6] = ((((-1.0) * x278)) + ((new_r11 * sj0)) + x276);
                                            evalcond[7] = ((((-1.0) * x270 * x272)) + new_r00 + ((cj0 * x277)));
                                            evalcond[8] = ((((-1.0) * x272 * x278)) + new_r11 + ((cj0 * x271)));
                                            evalcond[9] =
                                                ((((-1.0) * cj0 * x278)) + (((-1.0) * x271 * x272)) + new_r01);
                                            evalcond[10] = (((cj1 * x274)) + x271 + (((-1.0) * new_r20 * x273)) +
                                                            ((new_r10 * x275)));
                                            evalcond[11] = ((((-1.0) * x270)) + ((cj1 * x276)) +
                                                            (((-1.0) * new_r21 * x273)) + ((new_r11 * x275)));
                                            if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH ||
                                                IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH)
                                            {
                                              continue;
                                            }
                                          }

                                          {
                                            std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                            vinfos[0].jointtype = 1;
                                            vinfos[0].foffset = j0;
                                            vinfos[0].indices[0] = _ij0[0];
                                            vinfos[0].indices[1] = _ij0[1];
                                            vinfos[0].maxsolutions = _nj0;
                                            vinfos[1].jointtype = 1;
                                            vinfos[1].foffset = j1;
                                            vinfos[1].indices[0] = _ij1[0];
                                            vinfos[1].indices[1] = _ij1[1];
                                            vinfos[1].maxsolutions = _nj1;
                                            vinfos[2].jointtype = 1;
                                            vinfos[2].foffset = j2;
                                            vinfos[2].indices[0] = _ij2[0];
                                            vinfos[2].indices[1] = _ij2[1];
                                            vinfos[2].maxsolutions = _nj2;
                                            vinfos[3].jointtype = 1;
                                            vinfos[3].foffset = j3;
                                            vinfos[3].indices[0] = _ij3[0];
                                            vinfos[3].indices[1] = _ij3[1];
                                            vinfos[3].maxsolutions = _nj3;
                                            vinfos[4].jointtype = 1;
                                            vinfos[4].foffset = j4;
                                            vinfos[4].indices[0] = _ij4[0];
                                            vinfos[4].indices[1] = _ij4[1];
                                            vinfos[4].maxsolutions = _nj4;
                                            vinfos[5].jointtype = 1;
                                            vinfos[5].foffset = j5;
                                            vinfos[5].indices[0] = _ij5[0];
                                            vinfos[5].indices[1] = _ij5[1];
                                            vinfos[5].maxsolutions = _nj5;
                                            vinfos[6].jointtype = 1;
                                            vinfos[6].foffset = j6;
                                            vinfos[6].indices[0] = _ij6[0];
                                            vinfos[6].indices[1] = _ij6[1];
                                            vinfos[6].maxsolutions = _nj6;
                                            std::vector<int> vfree(0);
                                            solutions.AddSolution(vinfos, vfree);
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                                else
                                {
                                  {
                                    IkReal j2array[1], cj2array[1], sj2array[1];
                                    bool j2valid[1] = { false };
                                    _nj2 = 1;
                                    CheckValue<IkReal> x280 = IKPowWithIntegerCheck(sj1, -1);
                                    if (!x280.valid)
                                    {
                                      continue;
                                    }
                                    IkReal x279 = x280.value;
                                    CheckValue<IkReal> x281 = IKPowWithIntegerCheck(cj0, -1);
                                    if (!x281.valid)
                                    {
                                      continue;
                                    }
                                    if (IKabs(((-1.0) * new_r21 * x279)) < IKFAST_ATAN2_MAGTHRESH &&
                                        IKabs((x279 * (x281.value) *
                                               (((((-1.0) * cj1 * new_r21 * sj0)) + (((-1.0) * new_r11 * sj1)))))) <
                                            IKFAST_ATAN2_MAGTHRESH &&
                                        IKabs(
                                            IKsqr(((-1.0) * new_r21 * x279)) +
                                            IKsqr((x279 * (x281.value) *
                                                   (((((-1.0) * cj1 * new_r21 * sj0)) + (((-1.0) * new_r11 * sj1)))))) -
                                            1) <= IKFAST_SINCOS_THRESH)
                                      continue;
                                    j2array[0] =
                                        IKatan2(((-1.0) * new_r21 * x279),
                                                (x279 * (x281.value) *
                                                 (((((-1.0) * cj1 * new_r21 * sj0)) + (((-1.0) * new_r11 * sj1))))));
                                    sj2array[0] = IKsin(j2array[0]);
                                    cj2array[0] = IKcos(j2array[0]);
                                    if (j2array[0] > IKPI)
                                    {
                                      j2array[0] -= IK2PI;
                                    }
                                    else if (j2array[0] < -IKPI)
                                    {
                                      j2array[0] += IK2PI;
                                    }
                                    j2valid[0] = true;
                                    for (int ij2 = 0; ij2 < 1; ++ij2)
                                    {
                                      if (!j2valid[ij2])
                                      {
                                        continue;
                                      }
                                      _ij2[0] = ij2;
                                      _ij2[1] = -1;
                                      for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                      {
                                        if (j2valid[iij2] &&
                                            IKabs(cj2array[ij2] - cj2array[iij2]) < IKFAST_SOLUTION_THRESH &&
                                            IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                        {
                                          j2valid[iij2] = false;
                                          _ij2[1] = iij2;
                                          break;
                                        }
                                      }
                                      j2 = j2array[ij2];
                                      cj2 = cj2array[ij2];
                                      sj2 = sj2array[ij2];
                                      {
                                        IkReal evalcond[12];
                                        IkReal x282 = IKsin(j2);
                                        IkReal x283 = IKcos(j2);
                                        IkReal x284 = ((1.0) * sj0);
                                        IkReal x285 = ((1.0) * sj1);
                                        IkReal x286 = (cj0 * new_r00);
                                        IkReal x287 = (cj1 * sj0);
                                        IkReal x288 = (cj0 * new_r01);
                                        IkReal x289 = (cj1 * x283);
                                        IkReal x290 = (cj1 * x282);
                                        evalcond[0] = (new_r21 + ((sj1 * x282)));
                                        evalcond[1] = (new_r20 + (((-1.0) * x283 * x285)));
                                        evalcond[2] = ((((-1.0) * new_r00 * x284)) + x282 + ((cj0 * new_r10)));
                                        evalcond[3] = (x283 + (((-1.0) * new_r01 * x284)) + ((cj0 * new_r11)));
                                        evalcond[4] = (((new_r10 * sj0)) + x289 + x286);
                                        evalcond[5] = (((cj0 * x282)) + new_r10 + ((x283 * x287)));
                                        evalcond[6] = ((((-1.0) * x290)) + ((new_r11 * sj0)) + x288);
                                        evalcond[7] = (((cj0 * x289)) + (((-1.0) * x282 * x284)) + new_r00);
                                        evalcond[8] = ((((-1.0) * x284 * x290)) + ((cj0 * x283)) + new_r11);
                                        evalcond[9] = ((((-1.0) * cj0 * x290)) + new_r01 + (((-1.0) * x283 * x284)));
                                        evalcond[10] =
                                            (x283 + (((-1.0) * new_r20 * x285)) + ((cj1 * x286)) + ((new_r10 * x287)));
                                        evalcond[11] = ((((-1.0) * x282)) + (((-1.0) * new_r21 * x285)) +
                                                        ((new_r11 * x287)) + ((cj1 * x288)));
                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH ||
                                            IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH)
                                        {
                                          continue;
                                        }
                                      }

                                      {
                                        std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                        vinfos[0].jointtype = 1;
                                        vinfos[0].foffset = j0;
                                        vinfos[0].indices[0] = _ij0[0];
                                        vinfos[0].indices[1] = _ij0[1];
                                        vinfos[0].maxsolutions = _nj0;
                                        vinfos[1].jointtype = 1;
                                        vinfos[1].foffset = j1;
                                        vinfos[1].indices[0] = _ij1[0];
                                        vinfos[1].indices[1] = _ij1[1];
                                        vinfos[1].maxsolutions = _nj1;
                                        vinfos[2].jointtype = 1;
                                        vinfos[2].foffset = j2;
                                        vinfos[2].indices[0] = _ij2[0];
                                        vinfos[2].indices[1] = _ij2[1];
                                        vinfos[2].maxsolutions = _nj2;
                                        vinfos[3].jointtype = 1;
                                        vinfos[3].foffset = j3;
                                        vinfos[3].indices[0] = _ij3[0];
                                        vinfos[3].indices[1] = _ij3[1];
                                        vinfos[3].maxsolutions = _nj3;
                                        vinfos[4].jointtype = 1;
                                        vinfos[4].foffset = j4;
                                        vinfos[4].indices[0] = _ij4[0];
                                        vinfos[4].indices[1] = _ij4[1];
                                        vinfos[4].maxsolutions = _nj4;
                                        vinfos[5].jointtype = 1;
                                        vinfos[5].foffset = j5;
                                        vinfos[5].indices[0] = _ij5[0];
                                        vinfos[5].indices[1] = _ij5[1];
                                        vinfos[5].maxsolutions = _nj5;
                                        vinfos[6].jointtype = 1;
                                        vinfos[6].foffset = j6;
                                        vinfos[6].indices[0] = _ij6[0];
                                        vinfos[6].indices[1] = _ij6[1];
                                        vinfos[6].maxsolutions = _nj6;
                                        std::vector<int> vfree(0);
                                        solutions.AddSolution(vinfos, vfree);
                                      }
                                    }
                                  }
                                }
                              }
                            }
                            else
                            {
                              {
                                IkReal j2array[1], cj2array[1], sj2array[1];
                                bool j2valid[1] = { false };
                                _nj2 = 1;
                                CheckValue<IkReal> x291 = IKatan2WithCheck(
                                    IkReal(((-1.0) * new_r21)), IkReal(new_r20), IKFAST_ATAN2_MAGTHRESH);
                                if (!x291.valid)
                                {
                                  continue;
                                }
                                CheckValue<IkReal> x292 = IKPowWithIntegerCheck(IKsign(sj1), -1);
                                if (!x292.valid)
                                {
                                  continue;
                                }
                                j2array[0] = ((-1.5707963267949) + (x291.value) + (((1.5707963267949) * (x292.value))));
                                sj2array[0] = IKsin(j2array[0]);
                                cj2array[0] = IKcos(j2array[0]);
                                if (j2array[0] > IKPI)
                                {
                                  j2array[0] -= IK2PI;
                                }
                                else if (j2array[0] < -IKPI)
                                {
                                  j2array[0] += IK2PI;
                                }
                                j2valid[0] = true;
                                for (int ij2 = 0; ij2 < 1; ++ij2)
                                {
                                  if (!j2valid[ij2])
                                  {
                                    continue;
                                  }
                                  _ij2[0] = ij2;
                                  _ij2[1] = -1;
                                  for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                                  {
                                    if (j2valid[iij2] &&
                                        IKabs(cj2array[ij2] - cj2array[iij2]) < IKFAST_SOLUTION_THRESH &&
                                        IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                                    {
                                      j2valid[iij2] = false;
                                      _ij2[1] = iij2;
                                      break;
                                    }
                                  }
                                  j2 = j2array[ij2];
                                  cj2 = cj2array[ij2];
                                  sj2 = sj2array[ij2];
                                  {
                                    IkReal evalcond[12];
                                    IkReal x293 = IKsin(j2);
                                    IkReal x294 = IKcos(j2);
                                    IkReal x295 = ((1.0) * sj0);
                                    IkReal x296 = ((1.0) * sj1);
                                    IkReal x297 = (cj0 * new_r00);
                                    IkReal x298 = (cj1 * sj0);
                                    IkReal x299 = (cj0 * new_r01);
                                    IkReal x300 = (cj1 * x294);
                                    IkReal x301 = (cj1 * x293);
                                    evalcond[0] = (((sj1 * x293)) + new_r21);
                                    evalcond[1] = (new_r20 + (((-1.0) * x294 * x296)));
                                    evalcond[2] = (x293 + ((cj0 * new_r10)) + (((-1.0) * new_r00 * x295)));
                                    evalcond[3] = ((((-1.0) * new_r01 * x295)) + x294 + ((cj0 * new_r11)));
                                    evalcond[4] = (((new_r10 * sj0)) + x300 + x297);
                                    evalcond[5] = (((x294 * x298)) + new_r10 + ((cj0 * x293)));
                                    evalcond[6] = (((new_r11 * sj0)) + (((-1.0) * x301)) + x299);
                                    evalcond[7] = ((((-1.0) * x293 * x295)) + ((cj0 * x300)) + new_r00);
                                    evalcond[8] = ((((-1.0) * x295 * x301)) + new_r11 + ((cj0 * x294)));
                                    evalcond[9] = ((((-1.0) * cj0 * x301)) + new_r01 + (((-1.0) * x294 * x295)));
                                    evalcond[10] =
                                        ((((-1.0) * new_r20 * x296)) + ((cj1 * x297)) + ((new_r10 * x298)) + x294);
                                    evalcond[11] = ((((-1.0) * x293)) + (((-1.0) * new_r21 * x296)) +
                                                    ((new_r11 * x298)) + ((cj1 * x299)));
                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH ||
                                        IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH)
                                    {
                                      continue;
                                    }
                                  }

                                  {
                                    std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                    vinfos[0].jointtype = 1;
                                    vinfos[0].foffset = j0;
                                    vinfos[0].indices[0] = _ij0[0];
                                    vinfos[0].indices[1] = _ij0[1];
                                    vinfos[0].maxsolutions = _nj0;
                                    vinfos[1].jointtype = 1;
                                    vinfos[1].foffset = j1;
                                    vinfos[1].indices[0] = _ij1[0];
                                    vinfos[1].indices[1] = _ij1[1];
                                    vinfos[1].maxsolutions = _nj1;
                                    vinfos[2].jointtype = 1;
                                    vinfos[2].foffset = j2;
                                    vinfos[2].indices[0] = _ij2[0];
                                    vinfos[2].indices[1] = _ij2[1];
                                    vinfos[2].maxsolutions = _nj2;
                                    vinfos[3].jointtype = 1;
                                    vinfos[3].foffset = j3;
                                    vinfos[3].indices[0] = _ij3[0];
                                    vinfos[3].indices[1] = _ij3[1];
                                    vinfos[3].maxsolutions = _nj3;
                                    vinfos[4].jointtype = 1;
                                    vinfos[4].foffset = j4;
                                    vinfos[4].indices[0] = _ij4[0];
                                    vinfos[4].indices[1] = _ij4[1];
                                    vinfos[4].maxsolutions = _nj4;
                                    vinfos[5].jointtype = 1;
                                    vinfos[5].foffset = j5;
                                    vinfos[5].indices[0] = _ij5[0];
                                    vinfos[5].indices[1] = _ij5[1];
                                    vinfos[5].maxsolutions = _nj5;
                                    vinfos[6].jointtype = 1;
                                    vinfos[6].foffset = j6;
                                    vinfos[6].indices[0] = _ij6[0];
                                    vinfos[6].indices[1] = _ij6[1];
                                    vinfos[6].maxsolutions = _nj6;
                                    std::vector<int> vfree(0);
                                    solutions.AddSolution(vinfos, vfree);
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
                else
                {
                  {
                    IkReal j2array[1], cj2array[1], sj2array[1];
                    bool j2valid[1] = { false };
                    _nj2 = 1;
                    CheckValue<IkReal> x302 =
                        IKatan2WithCheck(IkReal(((-1.0) * new_r21)), IkReal(new_r20), IKFAST_ATAN2_MAGTHRESH);
                    if (!x302.valid)
                    {
                      continue;
                    }
                    CheckValue<IkReal> x303 = IKPowWithIntegerCheck(IKsign(sj1), -1);
                    if (!x303.valid)
                    {
                      continue;
                    }
                    j2array[0] = ((-1.5707963267949) + (x302.value) + (((1.5707963267949) * (x303.value))));
                    sj2array[0] = IKsin(j2array[0]);
                    cj2array[0] = IKcos(j2array[0]);
                    if (j2array[0] > IKPI)
                    {
                      j2array[0] -= IK2PI;
                    }
                    else if (j2array[0] < -IKPI)
                    {
                      j2array[0] += IK2PI;
                    }
                    j2valid[0] = true;
                    for (int ij2 = 0; ij2 < 1; ++ij2)
                    {
                      if (!j2valid[ij2])
                      {
                        continue;
                      }
                      _ij2[0] = ij2;
                      _ij2[1] = -1;
                      for (int iij2 = ij2 + 1; iij2 < 1; ++iij2)
                      {
                        if (j2valid[iij2] && IKabs(cj2array[ij2] - cj2array[iij2]) < IKFAST_SOLUTION_THRESH &&
                            IKabs(sj2array[ij2] - sj2array[iij2]) < IKFAST_SOLUTION_THRESH)
                        {
                          j2valid[iij2] = false;
                          _ij2[1] = iij2;
                          break;
                        }
                      }
                      j2 = j2array[ij2];
                      cj2 = cj2array[ij2];
                      sj2 = sj2array[ij2];
                      {
                        IkReal evalcond[2];
                        evalcond[0] = (((sj1 * (IKsin(j2)))) + new_r21);
                        evalcond[1] = ((((-1.0) * sj1 * (IKcos(j2)))) + new_r20);
                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH)
                        {
                          continue;
                        }
                      }

                      {
                        IkReal j0eval[3];
                        j0eval[0] = sj1;
                        j0eval[1] = ((IKabs(new_r12)) + (IKabs(new_r02)));
                        j0eval[2] = IKsign(sj1);
                        if (IKabs(j0eval[0]) < 0.0000010000000000 || IKabs(j0eval[1]) < 0.0000010000000000 ||
                            IKabs(j0eval[2]) < 0.0000010000000000)
                        {
                          {
                            IkReal j0eval[2];
                            j0eval[0] = new_r00;
                            j0eval[1] = sj1;
                            if (IKabs(j0eval[0]) < 0.0000010000000000 || IKabs(j0eval[1]) < 0.0000010000000000)
                            {
                              {
                                IkReal evalcond[5];
                                bool bgotonextstatement = true;
                                do
                                {
                                  evalcond[0] = ((-3.14159265358979) +
                                                 (IKfmod(((3.14159265358979) + (IKabs(j1))), 6.28318530717959)));
                                  evalcond[1] = new_r21;
                                  evalcond[2] = new_r02;
                                  evalcond[3] = new_r12;
                                  evalcond[4] = new_r20;
                                  if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                      IKabs(evalcond[1]) < 0.0000050000000000 &&
                                      IKabs(evalcond[2]) < 0.0000050000000000 &&
                                      IKabs(evalcond[3]) < 0.0000050000000000 &&
                                      IKabs(evalcond[4]) < 0.0000050000000000)
                                  {
                                    bgotonextstatement = false;
                                    {
                                      IkReal j0eval[3];
                                      sj1 = 0;
                                      cj1 = 1.0;
                                      j1 = 0;
                                      IkReal x304 = ((1.0) * cj2);
                                      IkReal x305 = ((new_r10 * new_r10) + (new_r00 * new_r00));
                                      j0eval[0] = x305;
                                      j0eval[1] = ((IKabs((((new_r00 * sj2)) + (((-1.0) * new_r10 * x304))))) +
                                                   (IKabs(((((-1.0) * new_r10 * sj2)) + (((-1.0) * new_r00 * x304))))));
                                      j0eval[2] = IKsign(x305);
                                      if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                          IKabs(j0eval[1]) < 0.0000010000000000 ||
                                          IKabs(j0eval[2]) < 0.0000010000000000)
                                      {
                                        {
                                          IkReal j0eval[3];
                                          sj1 = 0;
                                          cj1 = 1.0;
                                          j1 = 0;
                                          IkReal x306 = ((1.0) * cj2);
                                          IkReal x307 = (((new_r10 * new_r11)) + ((new_r00 * new_r01)));
                                          j0eval[0] = x307;
                                          j0eval[1] =
                                              ((IKabs(((((-1.0) * new_r01 * x306)) + (((-1.0) * new_r10 * x306))))) +
                                               (IKabs((((cj2 * new_r00)) + (((-1.0) * new_r11 * x306))))));
                                          j0eval[2] = IKsign(x307);
                                          if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                              IKabs(j0eval[1]) < 0.0000010000000000 ||
                                              IKabs(j0eval[2]) < 0.0000010000000000)
                                          {
                                            {
                                              IkReal j0eval[3];
                                              sj1 = 0;
                                              cj1 = 1.0;
                                              j1 = 0;
                                              IkReal x308 = ((1.0) * new_r10);
                                              IkReal x309 = ((((-1.0) * sj2 * x308)) + ((cj2 * new_r00)));
                                              j0eval[0] = x309;
                                              j0eval[1] = IKsign(x309);
                                              j0eval[2] = ((IKabs(((((-1.0) * (cj2 * cj2))) + (new_r10 * new_r10)))) +
                                                           (IKabs((((cj2 * sj2)) + (((-1.0) * new_r00 * x308))))));
                                              if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                  IKabs(j0eval[1]) < 0.0000010000000000 ||
                                                  IKabs(j0eval[2]) < 0.0000010000000000)
                                              {
                                                {
                                                  IkReal evalcond[1];
                                                  bool bgotonextstatement = true;
                                                  do
                                                  {
                                                    IkReal x312 = ((new_r10 * new_r10) + (new_r00 * new_r00));
                                                    if (IKabs(x312) == 0)
                                                    {
                                                      continue;
                                                    }
                                                    IkReal x310 = pow(x312, -0.5);
                                                    IkReal x311 = ((-1.0) * x310);
                                                    CheckValue<IkReal> x313 =
                                                        IKatan2WithCheck(IkReal(new_r00),
                                                                         IkReal(((-1.0) * new_r10)),
                                                                         IKFAST_ATAN2_MAGTHRESH);
                                                    if (!x313.valid)
                                                    {
                                                      continue;
                                                    }
                                                    IkReal gconst0 = ((-1.0) * (x313.value));
                                                    IkReal gconst1 = (new_r00 * x311);
                                                    IkReal gconst2 = (new_r10 * x311);
                                                    CheckValue<IkReal> x314 =
                                                        IKatan2WithCheck(IkReal(new_r00),
                                                                         IkReal(((-1.0) * new_r10)),
                                                                         IKFAST_ATAN2_MAGTHRESH);
                                                    if (!x314.valid)
                                                    {
                                                      continue;
                                                    }
                                                    evalcond[0] =
                                                        ((-3.14159265358979) +
                                                         (IKfmod(((3.14159265358979) + (IKabs(((x314.value) + j2)))),
                                                                 6.28318530717959)));
                                                    if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                    {
                                                      bgotonextstatement = false;
                                                      {
                                                        IkReal j0eval[2];
                                                        CheckValue<IkReal> x318 =
                                                            IKatan2WithCheck(IkReal(new_r00),
                                                                             IkReal(((-1.0) * new_r10)),
                                                                             IKFAST_ATAN2_MAGTHRESH);
                                                        if (!x318.valid)
                                                        {
                                                          continue;
                                                        }
                                                        IkReal x315 = ((-1.0) * (x318.value));
                                                        IkReal x316 = x310;
                                                        IkReal x317 = ((-1.0) * x316);
                                                        sj1 = 0;
                                                        cj1 = 1.0;
                                                        j1 = 0;
                                                        sj2 = gconst1;
                                                        cj2 = gconst2;
                                                        j2 = x315;
                                                        IkReal gconst0 = x315;
                                                        IkReal gconst1 = (new_r00 * x317);
                                                        IkReal gconst2 = (new_r10 * x317);
                                                        IkReal x319 = ((new_r10 * new_r10) + (new_r00 * new_r00));
                                                        j0eval[0] = x319;
                                                        j0eval[1] = IKsign(x319);
                                                        if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                            IKabs(j0eval[1]) < 0.0000010000000000)
                                                        {
                                                          {
                                                            IkReal j0eval[3];
                                                            CheckValue<IkReal> x323 =
                                                                IKatan2WithCheck(IkReal(new_r00),
                                                                                 IkReal(((-1.0) * new_r10)),
                                                                                 IKFAST_ATAN2_MAGTHRESH);
                                                            if (!x323.valid)
                                                            {
                                                              continue;
                                                            }
                                                            IkReal x320 = ((-1.0) * (x323.value));
                                                            IkReal x321 = x310;
                                                            IkReal x322 = ((-1.0) * x321);
                                                            sj1 = 0;
                                                            cj1 = 1.0;
                                                            j1 = 0;
                                                            sj2 = gconst1;
                                                            cj2 = gconst2;
                                                            j2 = x320;
                                                            IkReal gconst0 = x320;
                                                            IkReal gconst1 = (new_r00 * x322);
                                                            IkReal gconst2 = (new_r10 * x322);
                                                            IkReal x324 = new_r10 * new_r10;
                                                            IkReal x325 =
                                                                (((new_r10 * new_r11)) + ((new_r00 * new_r01)));
                                                            IkReal x326 = x310;
                                                            IkReal x327 = (new_r10 * x326);
                                                            j0eval[0] = x325;
                                                            j0eval[1] = IKsign(x325);
                                                            j0eval[2] =
                                                                ((IKabs(((((-1.0) * new_r00 * x327)) +
                                                                         ((new_r11 * x327))))) +
                                                                 (IKabs((((new_r01 * x327)) + ((x324 * x326))))));
                                                            if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                                IKabs(j0eval[1]) < 0.0000010000000000 ||
                                                                IKabs(j0eval[2]) < 0.0000010000000000)
                                                            {
                                                              {
                                                                IkReal j0eval[1];
                                                                CheckValue<IkReal> x331 =
                                                                    IKatan2WithCheck(IkReal(new_r00),
                                                                                     IkReal(((-1.0) * new_r10)),
                                                                                     IKFAST_ATAN2_MAGTHRESH);
                                                                if (!x331.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                IkReal x328 = ((-1.0) * (x331.value));
                                                                IkReal x329 = x310;
                                                                IkReal x330 = ((-1.0) * x329);
                                                                sj1 = 0;
                                                                cj1 = 1.0;
                                                                j1 = 0;
                                                                sj2 = gconst1;
                                                                cj2 = gconst2;
                                                                j2 = x328;
                                                                IkReal gconst0 = x328;
                                                                IkReal gconst1 = (new_r00 * x330);
                                                                IkReal gconst2 = (new_r10 * x330);
                                                                IkReal x332 = new_r10 * new_r10;
                                                                IkReal x333 = new_r00 * new_r00;
                                                                CheckValue<IkReal> x340 =
                                                                    IKPowWithIntegerCheck((x333 + x332), -1);
                                                                if (!x340.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                IkReal x334 = x340.value;
                                                                IkReal x335 = (x332 * x334);
                                                                CheckValue<IkReal> x341 = IKPowWithIntegerCheck(
                                                                    ((((-1.0) * x332)) + (((-1.0) * x333))), -1);
                                                                if (!x341.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                IkReal x336 = x341.value;
                                                                IkReal x337 = ((1.0) * x336);
                                                                IkReal x338 = (new_r00 * x337);
                                                                IkReal x339 = (new_r10 * x337);
                                                                j0eval[0] =
                                                                    ((IKabs(((((-1.0) * new_r10 * x338)) +
                                                                             (((-1.0) * x338 *
                                                                               (new_r10 * new_r10 * new_r10))) +
                                                                             (((-1.0) * new_r10 * x338 *
                                                                               (new_r00 * new_r00)))))) +
                                                                     (IKabs((((x334 * (x333 * x333))) +
                                                                             (((-1.0) * x335)) + ((x333 * x335))))));
                                                                if (IKabs(j0eval[0]) < 0.0000010000000000)
                                                                {
                                                                  continue;  // no branches [j0]
                                                                }
                                                                else
                                                                {
                                                                  {
                                                                    IkReal j0array[1], cj0array[1], sj0array[1];
                                                                    bool j0valid[1] = { false };
                                                                    _nj0 = 1;
                                                                    CheckValue<IkReal> x342 = IKatan2WithCheck(
                                                                        IkReal(((((-1.0) * (gconst2 * gconst2))) +
                                                                                (new_r00 * new_r00))),
                                                                        IkReal(((((-1.0) * gconst1 * gconst2)) +
                                                                                (((-1.0) * new_r00 * new_r10)))),
                                                                        IKFAST_ATAN2_MAGTHRESH);
                                                                    if (!x342.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    CheckValue<IkReal> x343 = IKPowWithIntegerCheck(
                                                                        IKsign((((gconst2 * new_r10)) +
                                                                                ((gconst1 * new_r00)))),
                                                                        -1);
                                                                    if (!x343.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    j0array[0] = ((-1.5707963267949) + (x342.value) +
                                                                                  (((1.5707963267949) * (x343.value))));
                                                                    sj0array[0] = IKsin(j0array[0]);
                                                                    cj0array[0] = IKcos(j0array[0]);
                                                                    if (j0array[0] > IKPI)
                                                                    {
                                                                      j0array[0] -= IK2PI;
                                                                    }
                                                                    else if (j0array[0] < -IKPI)
                                                                    {
                                                                      j0array[0] += IK2PI;
                                                                    }
                                                                    j0valid[0] = true;
                                                                    for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                    {
                                                                      if (!j0valid[ij0])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij0[0] = ij0;
                                                                      _ij0[1] = -1;
                                                                      for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                                      {
                                                                        if (j0valid[iij0] &&
                                                                            IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                                IKFAST_SOLUTION_THRESH &&
                                                                            IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                                IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j0valid[iij0] = false;
                                                                          _ij0[1] = iij0;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j0 = j0array[ij0];
                                                                      cj0 = cj0array[ij0];
                                                                      sj0 = sj0array[ij0];
                                                                      {
                                                                        IkReal evalcond[8];
                                                                        IkReal x344 = IKcos(j0);
                                                                        IkReal x345 = IKsin(j0);
                                                                        IkReal x346 = ((1.0) * gconst1);
                                                                        IkReal x347 = (gconst2 * x344);
                                                                        IkReal x348 = (gconst1 * x344);
                                                                        IkReal x349 = (gconst2 * x345);
                                                                        IkReal x350 = ((1.0) * x345);
                                                                        IkReal x351 = (x345 * x346);
                                                                        evalcond[0] = (gconst2 + ((new_r00 * x344)) +
                                                                                       ((new_r10 * x345)));
                                                                        evalcond[1] = (x348 + x349 + new_r10);
                                                                        evalcond[2] = (gconst1 + ((new_r10 * x344)) +
                                                                                       (((-1.0) * new_r00 * x350)));
                                                                        evalcond[3] = (gconst2 + ((new_r11 * x344)) +
                                                                                       (((-1.0) * new_r01 * x350)));
                                                                        evalcond[4] =
                                                                            ((((-1.0) * x351)) + x347 + new_r00);
                                                                        evalcond[5] =
                                                                            ((((-1.0) * x351)) + x347 + new_r11);
                                                                        evalcond[6] =
                                                                            (((new_r11 * x345)) + ((new_r01 * x344)) +
                                                                             (((-1.0) * x346)));
                                                                        evalcond[7] = ((((-1.0) * x344 * x346)) +
                                                                                       new_r01 + (((-1.0) * x349)));
                                                                        if (IKabs(evalcond[0]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[1]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[2]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[3]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[4]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[5]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[6]) >
                                                                                IKFAST_EVALCOND_THRESH ||
                                                                            IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      {
                                                                        std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                            vinfos(7);
                                                                        vinfos[0].jointtype = 1;
                                                                        vinfos[0].foffset = j0;
                                                                        vinfos[0].indices[0] = _ij0[0];
                                                                        vinfos[0].indices[1] = _ij0[1];
                                                                        vinfos[0].maxsolutions = _nj0;
                                                                        vinfos[1].jointtype = 1;
                                                                        vinfos[1].foffset = j1;
                                                                        vinfos[1].indices[0] = _ij1[0];
                                                                        vinfos[1].indices[1] = _ij1[1];
                                                                        vinfos[1].maxsolutions = _nj1;
                                                                        vinfos[2].jointtype = 1;
                                                                        vinfos[2].foffset = j2;
                                                                        vinfos[2].indices[0] = _ij2[0];
                                                                        vinfos[2].indices[1] = _ij2[1];
                                                                        vinfos[2].maxsolutions = _nj2;
                                                                        vinfos[3].jointtype = 1;
                                                                        vinfos[3].foffset = j3;
                                                                        vinfos[3].indices[0] = _ij3[0];
                                                                        vinfos[3].indices[1] = _ij3[1];
                                                                        vinfos[3].maxsolutions = _nj3;
                                                                        vinfos[4].jointtype = 1;
                                                                        vinfos[4].foffset = j4;
                                                                        vinfos[4].indices[0] = _ij4[0];
                                                                        vinfos[4].indices[1] = _ij4[1];
                                                                        vinfos[4].maxsolutions = _nj4;
                                                                        vinfos[5].jointtype = 1;
                                                                        vinfos[5].foffset = j5;
                                                                        vinfos[5].indices[0] = _ij5[0];
                                                                        vinfos[5].indices[1] = _ij5[1];
                                                                        vinfos[5].maxsolutions = _nj5;
                                                                        vinfos[6].jointtype = 1;
                                                                        vinfos[6].foffset = j6;
                                                                        vinfos[6].indices[0] = _ij6[0];
                                                                        vinfos[6].indices[1] = _ij6[1];
                                                                        vinfos[6].maxsolutions = _nj6;
                                                                        std::vector<int> vfree(0);
                                                                        solutions.AddSolution(vinfos, vfree);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                            else
                                                            {
                                                              {
                                                                IkReal j0array[1], cj0array[1], sj0array[1];
                                                                bool j0valid[1] = { false };
                                                                _nj0 = 1;
                                                                IkReal x352 = ((1.0) * gconst2);
                                                                CheckValue<IkReal> x353 = IKatan2WithCheck(
                                                                    IkReal((((gconst2 * new_r00)) +
                                                                            (((-1.0) * new_r11 * x352)))),
                                                                    IkReal(((((-1.0) * new_r01 * x352)) +
                                                                            (((-1.0) * new_r10 * x352)))),
                                                                    IKFAST_ATAN2_MAGTHRESH);
                                                                if (!x353.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                CheckValue<IkReal> x354 = IKPowWithIntegerCheck(
                                                                    IKsign((((new_r10 * new_r11)) +
                                                                            ((new_r00 * new_r01)))),
                                                                    -1);
                                                                if (!x354.valid)
                                                                {
                                                                  continue;
                                                                }
                                                                j0array[0] = ((-1.5707963267949) + (x353.value) +
                                                                              (((1.5707963267949) * (x354.value))));
                                                                sj0array[0] = IKsin(j0array[0]);
                                                                cj0array[0] = IKcos(j0array[0]);
                                                                if (j0array[0] > IKPI)
                                                                {
                                                                  j0array[0] -= IK2PI;
                                                                }
                                                                else if (j0array[0] < -IKPI)
                                                                {
                                                                  j0array[0] += IK2PI;
                                                                }
                                                                j0valid[0] = true;
                                                                for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                {
                                                                  if (!j0valid[ij0])
                                                                  {
                                                                    continue;
                                                                  }
                                                                  _ij0[0] = ij0;
                                                                  _ij0[1] = -1;
                                                                  for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                                  {
                                                                    if (j0valid[iij0] &&
                                                                        IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                            IKFAST_SOLUTION_THRESH &&
                                                                        IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                            IKFAST_SOLUTION_THRESH)
                                                                    {
                                                                      j0valid[iij0] = false;
                                                                      _ij0[1] = iij0;
                                                                      break;
                                                                    }
                                                                  }
                                                                  j0 = j0array[ij0];
                                                                  cj0 = cj0array[ij0];
                                                                  sj0 = sj0array[ij0];
                                                                  {
                                                                    IkReal evalcond[8];
                                                                    IkReal x355 = IKcos(j0);
                                                                    IkReal x356 = IKsin(j0);
                                                                    IkReal x357 = ((1.0) * gconst1);
                                                                    IkReal x358 = (gconst2 * x355);
                                                                    IkReal x359 = (gconst1 * x355);
                                                                    IkReal x360 = (gconst2 * x356);
                                                                    IkReal x361 = ((1.0) * x356);
                                                                    IkReal x362 = (x356 * x357);
                                                                    evalcond[0] = (gconst2 + ((new_r10 * x356)) +
                                                                                   ((new_r00 * x355)));
                                                                    evalcond[1] = (x359 + x360 + new_r10);
                                                                    evalcond[2] = ((((-1.0) * new_r00 * x361)) +
                                                                                   gconst1 + ((new_r10 * x355)));
                                                                    evalcond[3] = (gconst2 + ((new_r11 * x355)) +
                                                                                   (((-1.0) * new_r01 * x361)));
                                                                    evalcond[4] = ((((-1.0) * x362)) + x358 + new_r00);
                                                                    evalcond[5] = ((((-1.0) * x362)) + x358 + new_r11);
                                                                    evalcond[6] =
                                                                        (((new_r01 * x355)) + (((-1.0) * x357)) +
                                                                         ((new_r11 * x356)));
                                                                    evalcond[7] = ((((-1.0) * x360)) + new_r01 +
                                                                                   (((-1.0) * x355 * x357)));
                                                                    if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                        IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                    {
                                                                      continue;
                                                                    }
                                                                  }

                                                                  {
                                                                    std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                        vinfos(7);
                                                                    vinfos[0].jointtype = 1;
                                                                    vinfos[0].foffset = j0;
                                                                    vinfos[0].indices[0] = _ij0[0];
                                                                    vinfos[0].indices[1] = _ij0[1];
                                                                    vinfos[0].maxsolutions = _nj0;
                                                                    vinfos[1].jointtype = 1;
                                                                    vinfos[1].foffset = j1;
                                                                    vinfos[1].indices[0] = _ij1[0];
                                                                    vinfos[1].indices[1] = _ij1[1];
                                                                    vinfos[1].maxsolutions = _nj1;
                                                                    vinfos[2].jointtype = 1;
                                                                    vinfos[2].foffset = j2;
                                                                    vinfos[2].indices[0] = _ij2[0];
                                                                    vinfos[2].indices[1] = _ij2[1];
                                                                    vinfos[2].maxsolutions = _nj2;
                                                                    vinfos[3].jointtype = 1;
                                                                    vinfos[3].foffset = j3;
                                                                    vinfos[3].indices[0] = _ij3[0];
                                                                    vinfos[3].indices[1] = _ij3[1];
                                                                    vinfos[3].maxsolutions = _nj3;
                                                                    vinfos[4].jointtype = 1;
                                                                    vinfos[4].foffset = j4;
                                                                    vinfos[4].indices[0] = _ij4[0];
                                                                    vinfos[4].indices[1] = _ij4[1];
                                                                    vinfos[4].maxsolutions = _nj4;
                                                                    vinfos[5].jointtype = 1;
                                                                    vinfos[5].foffset = j5;
                                                                    vinfos[5].indices[0] = _ij5[0];
                                                                    vinfos[5].indices[1] = _ij5[1];
                                                                    vinfos[5].maxsolutions = _nj5;
                                                                    vinfos[6].jointtype = 1;
                                                                    vinfos[6].foffset = j6;
                                                                    vinfos[6].indices[0] = _ij6[0];
                                                                    vinfos[6].indices[1] = _ij6[1];
                                                                    vinfos[6].maxsolutions = _nj6;
                                                                    std::vector<int> vfree(0);
                                                                    solutions.AddSolution(vinfos, vfree);
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                        else
                                                        {
                                                          {
                                                            IkReal j0array[1], cj0array[1], sj0array[1];
                                                            bool j0valid[1] = { false };
                                                            _nj0 = 1;
                                                            IkReal x363 = ((1.0) * new_r10);
                                                            CheckValue<IkReal> x364 = IKPowWithIntegerCheck(
                                                                IKsign(((new_r10 * new_r10) + (new_r00 * new_r00))),
                                                                -1);
                                                            if (!x364.valid)
                                                            {
                                                              continue;
                                                            }
                                                            CheckValue<IkReal> x365 = IKatan2WithCheck(
                                                                IkReal((((gconst1 * new_r00)) +
                                                                        (((-1.0) * gconst2 * x363)))),
                                                                IkReal(((((-1.0) * gconst1 * x363)) +
                                                                        (((-1.0) * gconst2 * new_r00)))),
                                                                IKFAST_ATAN2_MAGTHRESH);
                                                            if (!x365.valid)
                                                            {
                                                              continue;
                                                            }
                                                            j0array[0] =
                                                                ((-1.5707963267949) +
                                                                 (((1.5707963267949) * (x364.value))) + (x365.value));
                                                            sj0array[0] = IKsin(j0array[0]);
                                                            cj0array[0] = IKcos(j0array[0]);
                                                            if (j0array[0] > IKPI)
                                                            {
                                                              j0array[0] -= IK2PI;
                                                            }
                                                            else if (j0array[0] < -IKPI)
                                                            {
                                                              j0array[0] += IK2PI;
                                                            }
                                                            j0valid[0] = true;
                                                            for (int ij0 = 0; ij0 < 1; ++ij0)
                                                            {
                                                              if (!j0valid[ij0])
                                                              {
                                                                continue;
                                                              }
                                                              _ij0[0] = ij0;
                                                              _ij0[1] = -1;
                                                              for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                              {
                                                                if (j0valid[iij0] &&
                                                                    IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                        IKFAST_SOLUTION_THRESH &&
                                                                    IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                        IKFAST_SOLUTION_THRESH)
                                                                {
                                                                  j0valid[iij0] = false;
                                                                  _ij0[1] = iij0;
                                                                  break;
                                                                }
                                                              }
                                                              j0 = j0array[ij0];
                                                              cj0 = cj0array[ij0];
                                                              sj0 = sj0array[ij0];
                                                              {
                                                                IkReal evalcond[8];
                                                                IkReal x366 = IKcos(j0);
                                                                IkReal x367 = IKsin(j0);
                                                                IkReal x368 = ((1.0) * gconst1);
                                                                IkReal x369 = (gconst2 * x366);
                                                                IkReal x370 = (gconst1 * x366);
                                                                IkReal x371 = (gconst2 * x367);
                                                                IkReal x372 = ((1.0) * x367);
                                                                IkReal x373 = (x367 * x368);
                                                                evalcond[0] =
                                                                    (gconst2 + ((new_r00 * x366)) + ((new_r10 * x367)));
                                                                evalcond[1] = (x371 + x370 + new_r10);
                                                                evalcond[2] = ((((-1.0) * new_r00 * x372)) + gconst1 +
                                                                               ((new_r10 * x366)));
                                                                evalcond[3] = (gconst2 + (((-1.0) * new_r01 * x372)) +
                                                                               ((new_r11 * x366)));
                                                                evalcond[4] = ((((-1.0) * x373)) + x369 + new_r00);
                                                                evalcond[5] = ((((-1.0) * x373)) + x369 + new_r11);
                                                                evalcond[6] = ((((-1.0) * x368)) + ((new_r01 * x366)) +
                                                                               ((new_r11 * x367)));
                                                                evalcond[7] = ((((-1.0) * x371)) +
                                                                               (((-1.0) * x366 * x368)) + new_r01);
                                                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                {
                                                                  continue;
                                                                }
                                                              }

                                                              {
                                                                std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                                vinfos[0].jointtype = 1;
                                                                vinfos[0].foffset = j0;
                                                                vinfos[0].indices[0] = _ij0[0];
                                                                vinfos[0].indices[1] = _ij0[1];
                                                                vinfos[0].maxsolutions = _nj0;
                                                                vinfos[1].jointtype = 1;
                                                                vinfos[1].foffset = j1;
                                                                vinfos[1].indices[0] = _ij1[0];
                                                                vinfos[1].indices[1] = _ij1[1];
                                                                vinfos[1].maxsolutions = _nj1;
                                                                vinfos[2].jointtype = 1;
                                                                vinfos[2].foffset = j2;
                                                                vinfos[2].indices[0] = _ij2[0];
                                                                vinfos[2].indices[1] = _ij2[1];
                                                                vinfos[2].maxsolutions = _nj2;
                                                                vinfos[3].jointtype = 1;
                                                                vinfos[3].foffset = j3;
                                                                vinfos[3].indices[0] = _ij3[0];
                                                                vinfos[3].indices[1] = _ij3[1];
                                                                vinfos[3].maxsolutions = _nj3;
                                                                vinfos[4].jointtype = 1;
                                                                vinfos[4].foffset = j4;
                                                                vinfos[4].indices[0] = _ij4[0];
                                                                vinfos[4].indices[1] = _ij4[1];
                                                                vinfos[4].maxsolutions = _nj4;
                                                                vinfos[5].jointtype = 1;
                                                                vinfos[5].foffset = j5;
                                                                vinfos[5].indices[0] = _ij5[0];
                                                                vinfos[5].indices[1] = _ij5[1];
                                                                vinfos[5].maxsolutions = _nj5;
                                                                vinfos[6].jointtype = 1;
                                                                vinfos[6].foffset = j6;
                                                                vinfos[6].indices[0] = _ij6[0];
                                                                vinfos[6].indices[1] = _ij6[1];
                                                                vinfos[6].maxsolutions = _nj6;
                                                                std::vector<int> vfree(0);
                                                                solutions.AddSolution(vinfos, vfree);
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  } while (0);
                                                  if (bgotonextstatement)
                                                  {
                                                    bool bgotonextstatement = true;
                                                    do
                                                    {
                                                      IkReal x376 = ((new_r10 * new_r10) + (new_r00 * new_r00));
                                                      if (IKabs(x376) == 0)
                                                      {
                                                        continue;
                                                      }
                                                      IkReal x374 = pow(x376, -0.5);
                                                      IkReal x375 = ((1.0) * x374);
                                                      CheckValue<IkReal> x377 =
                                                          IKatan2WithCheck(IkReal(new_r00),
                                                                           IkReal(((-1.0) * new_r10)),
                                                                           IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x377.valid)
                                                      {
                                                        continue;
                                                      }
                                                      IkReal gconst3 = ((3.14159265358979) + (((-1.0) * (x377.value))));
                                                      IkReal gconst4 = (new_r00 * x375);
                                                      IkReal gconst5 = (new_r10 * x375);
                                                      CheckValue<IkReal> x378 =
                                                          IKatan2WithCheck(IkReal(new_r00),
                                                                           IkReal(((-1.0) * new_r10)),
                                                                           IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x378.valid)
                                                      {
                                                        continue;
                                                      }
                                                      evalcond[0] =
                                                          ((-3.14159265358979) +
                                                           (IKfmod(((3.14159265358979) +
                                                                    (IKabs(((-3.14159265358979) + (x378.value) + j2)))),
                                                                   6.28318530717959)));
                                                      if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                      {
                                                        bgotonextstatement = false;
                                                        {
                                                          IkReal j0eval[2];
                                                          CheckValue<IkReal> x382 =
                                                              IKatan2WithCheck(IkReal(new_r00),
                                                                               IkReal(((-1.0) * new_r10)),
                                                                               IKFAST_ATAN2_MAGTHRESH);
                                                          if (!x382.valid)
                                                          {
                                                            continue;
                                                          }
                                                          IkReal x379 = ((1.0) * (x382.value));
                                                          IkReal x380 = x374;
                                                          IkReal x381 = ((1.0) * x380);
                                                          sj1 = 0;
                                                          cj1 = 1.0;
                                                          j1 = 0;
                                                          sj2 = gconst4;
                                                          cj2 = gconst5;
                                                          j2 = ((3.14159265) + (((-1.0) * x379)));
                                                          IkReal gconst3 = ((3.14159265358979) + (((-1.0) * x379)));
                                                          IkReal gconst4 = (new_r00 * x381);
                                                          IkReal gconst5 = (new_r10 * x381);
                                                          IkReal x383 = ((new_r10 * new_r10) + (new_r00 * new_r00));
                                                          j0eval[0] = x383;
                                                          j0eval[1] = IKsign(x383);
                                                          if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                              IKabs(j0eval[1]) < 0.0000010000000000)
                                                          {
                                                            {
                                                              IkReal j0eval[3];
                                                              CheckValue<IkReal> x387 =
                                                                  IKatan2WithCheck(IkReal(new_r00),
                                                                                   IkReal(((-1.0) * new_r10)),
                                                                                   IKFAST_ATAN2_MAGTHRESH);
                                                              if (!x387.valid)
                                                              {
                                                                continue;
                                                              }
                                                              IkReal x384 = ((1.0) * (x387.value));
                                                              IkReal x385 = x374;
                                                              IkReal x386 = ((1.0) * x385);
                                                              sj1 = 0;
                                                              cj1 = 1.0;
                                                              j1 = 0;
                                                              sj2 = gconst4;
                                                              cj2 = gconst5;
                                                              j2 = ((3.14159265) + (((-1.0) * x384)));
                                                              IkReal gconst3 = ((3.14159265358979) + (((-1.0) * x384)));
                                                              IkReal gconst4 = (new_r00 * x386);
                                                              IkReal gconst5 = (new_r10 * x386);
                                                              IkReal x388 = new_r10 * new_r10;
                                                              IkReal x389 = (new_r10 * new_r11);
                                                              IkReal x390 = (((new_r00 * new_r01)) + x389);
                                                              IkReal x391 = x374;
                                                              IkReal x392 = ((1.0) * x391);
                                                              j0eval[0] = x390;
                                                              j0eval[1] =
                                                                  ((IKabs(((((-1.0) * new_r01 * new_r10 * x392)) +
                                                                           (((-1.0) * x388 * x392))))) +
                                                                   (IKabs(((((-1.0) * x389 * x392)) +
                                                                           ((new_r00 * new_r10 * x391))))));
                                                              j0eval[2] = IKsign(x390);
                                                              if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                                  IKabs(j0eval[1]) < 0.0000010000000000 ||
                                                                  IKabs(j0eval[2]) < 0.0000010000000000)
                                                              {
                                                                {
                                                                  IkReal j0eval[1];
                                                                  CheckValue<IkReal> x396 =
                                                                      IKatan2WithCheck(IkReal(new_r00),
                                                                                       IkReal(((-1.0) * new_r10)),
                                                                                       IKFAST_ATAN2_MAGTHRESH);
                                                                  if (!x396.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x393 = ((1.0) * (x396.value));
                                                                  IkReal x394 = x374;
                                                                  IkReal x395 = ((1.0) * x394);
                                                                  sj1 = 0;
                                                                  cj1 = 1.0;
                                                                  j1 = 0;
                                                                  sj2 = gconst4;
                                                                  cj2 = gconst5;
                                                                  j2 = ((3.14159265) + (((-1.0) * x393)));
                                                                  IkReal gconst3 =
                                                                      ((3.14159265358979) + (((-1.0) * x393)));
                                                                  IkReal gconst4 = (new_r00 * x395);
                                                                  IkReal gconst5 = (new_r10 * x395);
                                                                  IkReal x397 = new_r10 * new_r10;
                                                                  IkReal x398 = new_r00 * new_r00;
                                                                  CheckValue<IkReal> x405 =
                                                                      IKPowWithIntegerCheck((x397 + x398), -1);
                                                                  if (!x405.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x399 = x405.value;
                                                                  IkReal x400 = (x397 * x399);
                                                                  CheckValue<IkReal> x406 = IKPowWithIntegerCheck(
                                                                      ((((-1.0) * x398)) + (((-1.0) * x397))), -1);
                                                                  if (!x406.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x401 = x406.value;
                                                                  IkReal x402 = ((1.0) * x401);
                                                                  IkReal x403 = (new_r00 * x402);
                                                                  IkReal x404 = (new_r10 * x402);
                                                                  j0eval[0] =
                                                                      ((IKabs((((x399 * (x398 * x398))) +
                                                                               ((x398 * x400)) + (((-1.0) * x400))))) +
                                                                       (IKabs(((((-1.0) * x403 *
                                                                                 (new_r10 * new_r10 * new_r10))) +
                                                                               (((-1.0) * new_r10 * x403)) +
                                                                               (((-1.0) * new_r10 * x403 *
                                                                                 (new_r00 * new_r00)))))));
                                                                  if (IKabs(j0eval[0]) < 0.0000010000000000)
                                                                  {
                                                                    continue;  // no branches [j0]
                                                                  }
                                                                  else
                                                                  {
                                                                    {
                                                                      IkReal j0array[1], cj0array[1], sj0array[1];
                                                                      bool j0valid[1] = { false };
                                                                      _nj0 = 1;
                                                                      CheckValue<IkReal> x407 = IKPowWithIntegerCheck(
                                                                          IKsign((((gconst4 * new_r00)) +
                                                                                  ((gconst5 * new_r10)))),
                                                                          -1);
                                                                      if (!x407.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      CheckValue<IkReal> x408 = IKatan2WithCheck(
                                                                          IkReal(((((-1.0) * (gconst5 * gconst5))) +
                                                                                  (new_r00 * new_r00))),
                                                                          IkReal(((((-1.0) * gconst4 * gconst5)) +
                                                                                  (((-1.0) * new_r00 * new_r10)))),
                                                                          IKFAST_ATAN2_MAGTHRESH);
                                                                      if (!x408.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      j0array[0] =
                                                                          ((-1.5707963267949) +
                                                                           (((1.5707963267949) * (x407.value))) +
                                                                           (x408.value));
                                                                      sj0array[0] = IKsin(j0array[0]);
                                                                      cj0array[0] = IKcos(j0array[0]);
                                                                      if (j0array[0] > IKPI)
                                                                      {
                                                                        j0array[0] -= IK2PI;
                                                                      }
                                                                      else if (j0array[0] < -IKPI)
                                                                      {
                                                                        j0array[0] += IK2PI;
                                                                      }
                                                                      j0valid[0] = true;
                                                                      for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                      {
                                                                        if (!j0valid[ij0])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij0[0] = ij0;
                                                                        _ij0[1] = -1;
                                                                        for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                                        {
                                                                          if (j0valid[iij0] &&
                                                                              IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                              IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                                  IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j0valid[iij0] = false;
                                                                            _ij0[1] = iij0;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j0 = j0array[ij0];
                                                                        cj0 = cj0array[ij0];
                                                                        sj0 = sj0array[ij0];
                                                                        {
                                                                          IkReal evalcond[8];
                                                                          IkReal x409 = IKcos(j0);
                                                                          IkReal x410 = IKsin(j0);
                                                                          IkReal x411 = ((1.0) * gconst4);
                                                                          IkReal x412 = (gconst5 * x409);
                                                                          IkReal x413 = ((1.0) * x410);
                                                                          IkReal x414 = (x410 * x411);
                                                                          evalcond[0] = (gconst5 + ((new_r10 * x410)) +
                                                                                         ((new_r00 * x409)));
                                                                          evalcond[1] = (((gconst5 * x410)) +
                                                                                         ((gconst4 * x409)) + new_r10);
                                                                          evalcond[2] = (gconst4 + ((new_r10 * x409)) +
                                                                                         (((-1.0) * new_r00 * x413)));
                                                                          evalcond[3] = (gconst5 + ((new_r11 * x409)) +
                                                                                         (((-1.0) * new_r01 * x413)));
                                                                          evalcond[4] =
                                                                              (x412 + new_r00 + (((-1.0) * x414)));
                                                                          evalcond[5] =
                                                                              (x412 + new_r11 + (((-1.0) * x414)));
                                                                          evalcond[6] =
                                                                              (((new_r11 * x410)) + ((new_r01 * x409)) +
                                                                               (((-1.0) * x411)));
                                                                          evalcond[7] =
                                                                              ((((-1.0) * gconst5 * x413)) + new_r01 +
                                                                               (((-1.0) * x409 * x411)));
                                                                          if (IKabs(evalcond[0]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[1]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[2]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[3]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[4]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[5]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[6]) >
                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                              IKabs(evalcond[7]) >
                                                                                  IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        {
                                                                          std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                              vinfos(7);
                                                                          vinfos[0].jointtype = 1;
                                                                          vinfos[0].foffset = j0;
                                                                          vinfos[0].indices[0] = _ij0[0];
                                                                          vinfos[0].indices[1] = _ij0[1];
                                                                          vinfos[0].maxsolutions = _nj0;
                                                                          vinfos[1].jointtype = 1;
                                                                          vinfos[1].foffset = j1;
                                                                          vinfos[1].indices[0] = _ij1[0];
                                                                          vinfos[1].indices[1] = _ij1[1];
                                                                          vinfos[1].maxsolutions = _nj1;
                                                                          vinfos[2].jointtype = 1;
                                                                          vinfos[2].foffset = j2;
                                                                          vinfos[2].indices[0] = _ij2[0];
                                                                          vinfos[2].indices[1] = _ij2[1];
                                                                          vinfos[2].maxsolutions = _nj2;
                                                                          vinfos[3].jointtype = 1;
                                                                          vinfos[3].foffset = j3;
                                                                          vinfos[3].indices[0] = _ij3[0];
                                                                          vinfos[3].indices[1] = _ij3[1];
                                                                          vinfos[3].maxsolutions = _nj3;
                                                                          vinfos[4].jointtype = 1;
                                                                          vinfos[4].foffset = j4;
                                                                          vinfos[4].indices[0] = _ij4[0];
                                                                          vinfos[4].indices[1] = _ij4[1];
                                                                          vinfos[4].maxsolutions = _nj4;
                                                                          vinfos[5].jointtype = 1;
                                                                          vinfos[5].foffset = j5;
                                                                          vinfos[5].indices[0] = _ij5[0];
                                                                          vinfos[5].indices[1] = _ij5[1];
                                                                          vinfos[5].maxsolutions = _nj5;
                                                                          vinfos[6].jointtype = 1;
                                                                          vinfos[6].foffset = j6;
                                                                          vinfos[6].indices[0] = _ij6[0];
                                                                          vinfos[6].indices[1] = _ij6[1];
                                                                          vinfos[6].maxsolutions = _nj6;
                                                                          std::vector<int> vfree(0);
                                                                          solutions.AddSolution(vinfos, vfree);
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                              else
                                                              {
                                                                {
                                                                  IkReal j0array[1], cj0array[1], sj0array[1];
                                                                  bool j0valid[1] = { false };
                                                                  _nj0 = 1;
                                                                  IkReal x415 = ((1.0) * gconst5);
                                                                  CheckValue<IkReal> x416 = IKatan2WithCheck(
                                                                      IkReal((((gconst5 * new_r00)) +
                                                                              (((-1.0) * new_r11 * x415)))),
                                                                      IkReal(((((-1.0) * new_r10 * x415)) +
                                                                              (((-1.0) * new_r01 * x415)))),
                                                                      IKFAST_ATAN2_MAGTHRESH);
                                                                  if (!x416.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  CheckValue<IkReal> x417 = IKPowWithIntegerCheck(
                                                                      IKsign((((new_r10 * new_r11)) +
                                                                              ((new_r00 * new_r01)))),
                                                                      -1);
                                                                  if (!x417.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  j0array[0] = ((-1.5707963267949) + (x416.value) +
                                                                                (((1.5707963267949) * (x417.value))));
                                                                  sj0array[0] = IKsin(j0array[0]);
                                                                  cj0array[0] = IKcos(j0array[0]);
                                                                  if (j0array[0] > IKPI)
                                                                  {
                                                                    j0array[0] -= IK2PI;
                                                                  }
                                                                  else if (j0array[0] < -IKPI)
                                                                  {
                                                                    j0array[0] += IK2PI;
                                                                  }
                                                                  j0valid[0] = true;
                                                                  for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                  {
                                                                    if (!j0valid[ij0])
                                                                    {
                                                                      continue;
                                                                    }
                                                                    _ij0[0] = ij0;
                                                                    _ij0[1] = -1;
                                                                    for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                                    {
                                                                      if (j0valid[iij0] &&
                                                                          IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                              IKFAST_SOLUTION_THRESH &&
                                                                          IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                              IKFAST_SOLUTION_THRESH)
                                                                      {
                                                                        j0valid[iij0] = false;
                                                                        _ij0[1] = iij0;
                                                                        break;
                                                                      }
                                                                    }
                                                                    j0 = j0array[ij0];
                                                                    cj0 = cj0array[ij0];
                                                                    sj0 = sj0array[ij0];
                                                                    {
                                                                      IkReal evalcond[8];
                                                                      IkReal x418 = IKcos(j0);
                                                                      IkReal x419 = IKsin(j0);
                                                                      IkReal x420 = ((1.0) * gconst4);
                                                                      IkReal x421 = (gconst5 * x418);
                                                                      IkReal x422 = ((1.0) * x419);
                                                                      IkReal x423 = (x419 * x420);
                                                                      evalcond[0] = (gconst5 + ((new_r10 * x419)) +
                                                                                     ((new_r00 * x418)));
                                                                      evalcond[1] = (((gconst5 * x419)) + new_r10 +
                                                                                     ((gconst4 * x418)));
                                                                      evalcond[2] = ((((-1.0) * new_r00 * x422)) +
                                                                                     gconst4 + ((new_r10 * x418)));
                                                                      evalcond[3] = (gconst5 + ((new_r11 * x418)) +
                                                                                     (((-1.0) * new_r01 * x422)));
                                                                      evalcond[4] =
                                                                          ((((-1.0) * x423)) + x421 + new_r00);
                                                                      evalcond[5] =
                                                                          ((((-1.0) * x423)) + x421 + new_r11);
                                                                      evalcond[6] =
                                                                          ((((-1.0) * x420)) + ((new_r11 * x419)) +
                                                                           ((new_r01 * x418)));
                                                                      evalcond[7] =
                                                                          ((((-1.0) * x418 * x420)) + new_r01 +
                                                                           (((-1.0) * gconst5 * x422)));
                                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                          IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                      {
                                                                        continue;
                                                                      }
                                                                    }

                                                                    {
                                                                      std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                          vinfos(7);
                                                                      vinfos[0].jointtype = 1;
                                                                      vinfos[0].foffset = j0;
                                                                      vinfos[0].indices[0] = _ij0[0];
                                                                      vinfos[0].indices[1] = _ij0[1];
                                                                      vinfos[0].maxsolutions = _nj0;
                                                                      vinfos[1].jointtype = 1;
                                                                      vinfos[1].foffset = j1;
                                                                      vinfos[1].indices[0] = _ij1[0];
                                                                      vinfos[1].indices[1] = _ij1[1];
                                                                      vinfos[1].maxsolutions = _nj1;
                                                                      vinfos[2].jointtype = 1;
                                                                      vinfos[2].foffset = j2;
                                                                      vinfos[2].indices[0] = _ij2[0];
                                                                      vinfos[2].indices[1] = _ij2[1];
                                                                      vinfos[2].maxsolutions = _nj2;
                                                                      vinfos[3].jointtype = 1;
                                                                      vinfos[3].foffset = j3;
                                                                      vinfos[3].indices[0] = _ij3[0];
                                                                      vinfos[3].indices[1] = _ij3[1];
                                                                      vinfos[3].maxsolutions = _nj3;
                                                                      vinfos[4].jointtype = 1;
                                                                      vinfos[4].foffset = j4;
                                                                      vinfos[4].indices[0] = _ij4[0];
                                                                      vinfos[4].indices[1] = _ij4[1];
                                                                      vinfos[4].maxsolutions = _nj4;
                                                                      vinfos[5].jointtype = 1;
                                                                      vinfos[5].foffset = j5;
                                                                      vinfos[5].indices[0] = _ij5[0];
                                                                      vinfos[5].indices[1] = _ij5[1];
                                                                      vinfos[5].maxsolutions = _nj5;
                                                                      vinfos[6].jointtype = 1;
                                                                      vinfos[6].foffset = j6;
                                                                      vinfos[6].indices[0] = _ij6[0];
                                                                      vinfos[6].indices[1] = _ij6[1];
                                                                      vinfos[6].maxsolutions = _nj6;
                                                                      std::vector<int> vfree(0);
                                                                      solutions.AddSolution(vinfos, vfree);
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                          else
                                                          {
                                                            {
                                                              IkReal j0array[1], cj0array[1], sj0array[1];
                                                              bool j0valid[1] = { false };
                                                              _nj0 = 1;
                                                              IkReal x424 = ((1.0) * new_r10);
                                                              CheckValue<IkReal> x425 = IKatan2WithCheck(
                                                                  IkReal((((gconst4 * new_r00)) +
                                                                          (((-1.0) * gconst5 * x424)))),
                                                                  IkReal(((((-1.0) * gconst4 * x424)) +
                                                                          (((-1.0) * gconst5 * new_r00)))),
                                                                  IKFAST_ATAN2_MAGTHRESH);
                                                              if (!x425.valid)
                                                              {
                                                                continue;
                                                              }
                                                              CheckValue<IkReal> x426 = IKPowWithIntegerCheck(
                                                                  IKsign(((new_r10 * new_r10) + (new_r00 * new_r00))),
                                                                  -1);
                                                              if (!x426.valid)
                                                              {
                                                                continue;
                                                              }
                                                              j0array[0] = ((-1.5707963267949) + (x425.value) +
                                                                            (((1.5707963267949) * (x426.value))));
                                                              sj0array[0] = IKsin(j0array[0]);
                                                              cj0array[0] = IKcos(j0array[0]);
                                                              if (j0array[0] > IKPI)
                                                              {
                                                                j0array[0] -= IK2PI;
                                                              }
                                                              else if (j0array[0] < -IKPI)
                                                              {
                                                                j0array[0] += IK2PI;
                                                              }
                                                              j0valid[0] = true;
                                                              for (int ij0 = 0; ij0 < 1; ++ij0)
                                                              {
                                                                if (!j0valid[ij0])
                                                                {
                                                                  continue;
                                                                }
                                                                _ij0[0] = ij0;
                                                                _ij0[1] = -1;
                                                                for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                                {
                                                                  if (j0valid[iij0] &&
                                                                      IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                          IKFAST_SOLUTION_THRESH &&
                                                                      IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                          IKFAST_SOLUTION_THRESH)
                                                                  {
                                                                    j0valid[iij0] = false;
                                                                    _ij0[1] = iij0;
                                                                    break;
                                                                  }
                                                                }
                                                                j0 = j0array[ij0];
                                                                cj0 = cj0array[ij0];
                                                                sj0 = sj0array[ij0];
                                                                {
                                                                  IkReal evalcond[8];
                                                                  IkReal x427 = IKcos(j0);
                                                                  IkReal x428 = IKsin(j0);
                                                                  IkReal x429 = ((1.0) * gconst4);
                                                                  IkReal x430 = (gconst5 * x427);
                                                                  IkReal x431 = ((1.0) * x428);
                                                                  IkReal x432 = (x428 * x429);
                                                                  evalcond[0] = (gconst5 + ((new_r10 * x428)) +
                                                                                 ((new_r00 * x427)));
                                                                  evalcond[1] = (((gconst4 * x427)) +
                                                                                 ((gconst5 * x428)) + new_r10);
                                                                  evalcond[2] = ((((-1.0) * new_r00 * x431)) + gconst4 +
                                                                                 ((new_r10 * x427)));
                                                                  evalcond[3] = ((((-1.0) * new_r01 * x431)) + gconst5 +
                                                                                 ((new_r11 * x427)));
                                                                  evalcond[4] = ((((-1.0) * x432)) + x430 + new_r00);
                                                                  evalcond[5] = ((((-1.0) * x432)) + x430 + new_r11);
                                                                  evalcond[6] =
                                                                      ((((-1.0) * x429)) + ((new_r11 * x428)) +
                                                                       ((new_r01 * x427)));
                                                                  evalcond[7] = ((((-1.0) * x427 * x429)) +
                                                                                 (((-1.0) * gconst5 * x431)) + new_r01);
                                                                  if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                  {
                                                                    continue;
                                                                  }
                                                                }

                                                                {
                                                                  std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(
                                                                      7);
                                                                  vinfos[0].jointtype = 1;
                                                                  vinfos[0].foffset = j0;
                                                                  vinfos[0].indices[0] = _ij0[0];
                                                                  vinfos[0].indices[1] = _ij0[1];
                                                                  vinfos[0].maxsolutions = _nj0;
                                                                  vinfos[1].jointtype = 1;
                                                                  vinfos[1].foffset = j1;
                                                                  vinfos[1].indices[0] = _ij1[0];
                                                                  vinfos[1].indices[1] = _ij1[1];
                                                                  vinfos[1].maxsolutions = _nj1;
                                                                  vinfos[2].jointtype = 1;
                                                                  vinfos[2].foffset = j2;
                                                                  vinfos[2].indices[0] = _ij2[0];
                                                                  vinfos[2].indices[1] = _ij2[1];
                                                                  vinfos[2].maxsolutions = _nj2;
                                                                  vinfos[3].jointtype = 1;
                                                                  vinfos[3].foffset = j3;
                                                                  vinfos[3].indices[0] = _ij3[0];
                                                                  vinfos[3].indices[1] = _ij3[1];
                                                                  vinfos[3].maxsolutions = _nj3;
                                                                  vinfos[4].jointtype = 1;
                                                                  vinfos[4].foffset = j4;
                                                                  vinfos[4].indices[0] = _ij4[0];
                                                                  vinfos[4].indices[1] = _ij4[1];
                                                                  vinfos[4].maxsolutions = _nj4;
                                                                  vinfos[5].jointtype = 1;
                                                                  vinfos[5].foffset = j5;
                                                                  vinfos[5].indices[0] = _ij5[0];
                                                                  vinfos[5].indices[1] = _ij5[1];
                                                                  vinfos[5].maxsolutions = _nj5;
                                                                  vinfos[6].jointtype = 1;
                                                                  vinfos[6].foffset = j6;
                                                                  vinfos[6].indices[0] = _ij6[0];
                                                                  vinfos[6].indices[1] = _ij6[1];
                                                                  vinfos[6].maxsolutions = _nj6;
                                                                  std::vector<int> vfree(0);
                                                                  solutions.AddSolution(vinfos, vfree);
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    } while (0);
                                                    if (bgotonextstatement)
                                                    {
                                                      bool bgotonextstatement = true;
                                                      do
                                                      {
                                                        evalcond[0] = ((-3.14159265358979) +
                                                                       (IKfmod(((3.14159265358979) +
                                                                                (IKabs(((-1.5707963267949) + j2)))),
                                                                               6.28318530717959)));
                                                        if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                        {
                                                          bgotonextstatement = false;
                                                          {
                                                            IkReal j0array[1], cj0array[1], sj0array[1];
                                                            bool j0valid[1] = { false };
                                                            _nj0 = 1;
                                                            if (IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH &&
                                                                IKabs(((-1.0) * new_r10)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                IKabs(IKsqr(new_r00) + IKsqr(((-1.0) * new_r10)) - 1) <=
                                                                    IKFAST_SINCOS_THRESH)
                                                              continue;
                                                            j0array[0] = IKatan2(new_r00, ((-1.0) * new_r10));
                                                            sj0array[0] = IKsin(j0array[0]);
                                                            cj0array[0] = IKcos(j0array[0]);
                                                            if (j0array[0] > IKPI)
                                                            {
                                                              j0array[0] -= IK2PI;
                                                            }
                                                            else if (j0array[0] < -IKPI)
                                                            {
                                                              j0array[0] += IK2PI;
                                                            }
                                                            j0valid[0] = true;
                                                            for (int ij0 = 0; ij0 < 1; ++ij0)
                                                            {
                                                              if (!j0valid[ij0])
                                                              {
                                                                continue;
                                                              }
                                                              _ij0[0] = ij0;
                                                              _ij0[1] = -1;
                                                              for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                              {
                                                                if (j0valid[iij0] &&
                                                                    IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                        IKFAST_SOLUTION_THRESH &&
                                                                    IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                        IKFAST_SOLUTION_THRESH)
                                                                {
                                                                  j0valid[iij0] = false;
                                                                  _ij0[1] = iij0;
                                                                  break;
                                                                }
                                                              }
                                                              j0 = j0array[ij0];
                                                              cj0 = cj0array[ij0];
                                                              sj0 = sj0array[ij0];
                                                              {
                                                                IkReal evalcond[8];
                                                                IkReal x433 = IKcos(j0);
                                                                IkReal x434 = IKsin(j0);
                                                                IkReal x435 = ((1.0) * x434);
                                                                evalcond[0] = (x433 + new_r10);
                                                                evalcond[1] = ((((-1.0) * x435)) + new_r00);
                                                                evalcond[2] = ((((-1.0) * x435)) + new_r11);
                                                                evalcond[3] = ((((-1.0) * x433)) + new_r01);
                                                                evalcond[4] = (((new_r00 * x433)) + ((new_r10 * x434)));
                                                                evalcond[5] =
                                                                    ((((-1.0) * new_r01 * x435)) + ((new_r11 * x433)));
                                                                evalcond[6] =
                                                                    ((-1.0) + ((new_r01 * x433)) + ((new_r11 * x434)));
                                                                evalcond[7] = ((1.0) + (((-1.0) * new_r00 * x435)) +
                                                                               ((new_r10 * x433)));
                                                                if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                    IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                {
                                                                  continue;
                                                                }
                                                              }

                                                              {
                                                                std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                                vinfos[0].jointtype = 1;
                                                                vinfos[0].foffset = j0;
                                                                vinfos[0].indices[0] = _ij0[0];
                                                                vinfos[0].indices[1] = _ij0[1];
                                                                vinfos[0].maxsolutions = _nj0;
                                                                vinfos[1].jointtype = 1;
                                                                vinfos[1].foffset = j1;
                                                                vinfos[1].indices[0] = _ij1[0];
                                                                vinfos[1].indices[1] = _ij1[1];
                                                                vinfos[1].maxsolutions = _nj1;
                                                                vinfos[2].jointtype = 1;
                                                                vinfos[2].foffset = j2;
                                                                vinfos[2].indices[0] = _ij2[0];
                                                                vinfos[2].indices[1] = _ij2[1];
                                                                vinfos[2].maxsolutions = _nj2;
                                                                vinfos[3].jointtype = 1;
                                                                vinfos[3].foffset = j3;
                                                                vinfos[3].indices[0] = _ij3[0];
                                                                vinfos[3].indices[1] = _ij3[1];
                                                                vinfos[3].maxsolutions = _nj3;
                                                                vinfos[4].jointtype = 1;
                                                                vinfos[4].foffset = j4;
                                                                vinfos[4].indices[0] = _ij4[0];
                                                                vinfos[4].indices[1] = _ij4[1];
                                                                vinfos[4].maxsolutions = _nj4;
                                                                vinfos[5].jointtype = 1;
                                                                vinfos[5].foffset = j5;
                                                                vinfos[5].indices[0] = _ij5[0];
                                                                vinfos[5].indices[1] = _ij5[1];
                                                                vinfos[5].maxsolutions = _nj5;
                                                                vinfos[6].jointtype = 1;
                                                                vinfos[6].foffset = j6;
                                                                vinfos[6].indices[0] = _ij6[0];
                                                                vinfos[6].indices[1] = _ij6[1];
                                                                vinfos[6].maxsolutions = _nj6;
                                                                std::vector<int> vfree(0);
                                                                solutions.AddSolution(vinfos, vfree);
                                                              }
                                                            }
                                                          }
                                                        }
                                                      } while (0);
                                                      if (bgotonextstatement)
                                                      {
                                                        bool bgotonextstatement = true;
                                                        do
                                                        {
                                                          evalcond[0] = ((-3.14159265358979) +
                                                                         (IKfmod(((3.14159265358979) +
                                                                                  (IKabs(((1.5707963267949) + j2)))),
                                                                                 6.28318530717959)));
                                                          if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                          {
                                                            bgotonextstatement = false;
                                                            {
                                                              IkReal j0array[1], cj0array[1], sj0array[1];
                                                              bool j0valid[1] = { false };
                                                              _nj0 = 1;
                                                              if (IKabs(((-1.0) * new_r00)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                  IKabs(((-1.0) * new_r01)) < IKFAST_ATAN2_MAGTHRESH &&
                                                                  IKabs(IKsqr(((-1.0) * new_r00)) +
                                                                        IKsqr(((-1.0) * new_r01)) - 1) <=
                                                                      IKFAST_SINCOS_THRESH)
                                                                continue;
                                                              j0array[0] =
                                                                  IKatan2(((-1.0) * new_r00), ((-1.0) * new_r01));
                                                              sj0array[0] = IKsin(j0array[0]);
                                                              cj0array[0] = IKcos(j0array[0]);
                                                              if (j0array[0] > IKPI)
                                                              {
                                                                j0array[0] -= IK2PI;
                                                              }
                                                              else if (j0array[0] < -IKPI)
                                                              {
                                                                j0array[0] += IK2PI;
                                                              }
                                                              j0valid[0] = true;
                                                              for (int ij0 = 0; ij0 < 1; ++ij0)
                                                              {
                                                                if (!j0valid[ij0])
                                                                {
                                                                  continue;
                                                                }
                                                                _ij0[0] = ij0;
                                                                _ij0[1] = -1;
                                                                for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                                {
                                                                  if (j0valid[iij0] &&
                                                                      IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                          IKFAST_SOLUTION_THRESH &&
                                                                      IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                          IKFAST_SOLUTION_THRESH)
                                                                  {
                                                                    j0valid[iij0] = false;
                                                                    _ij0[1] = iij0;
                                                                    break;
                                                                  }
                                                                }
                                                                j0 = j0array[ij0];
                                                                cj0 = cj0array[ij0];
                                                                sj0 = sj0array[ij0];
                                                                {
                                                                  IkReal evalcond[8];
                                                                  IkReal x436 = IKsin(j0);
                                                                  IkReal x437 = IKcos(j0);
                                                                  IkReal x438 = ((1.0) * x436);
                                                                  evalcond[0] = (x436 + new_r00);
                                                                  evalcond[1] = (x436 + new_r11);
                                                                  evalcond[2] = (x437 + new_r01);
                                                                  evalcond[3] = ((((-1.0) * x437)) + new_r10);
                                                                  evalcond[4] =
                                                                      (((new_r00 * x437)) + ((new_r10 * x436)));
                                                                  evalcond[5] = ((((-1.0) * new_r01 * x438)) +
                                                                                 ((new_r11 * x437)));
                                                                  evalcond[6] =
                                                                      ((1.0) + ((new_r01 * x437)) + ((new_r11 * x436)));
                                                                  evalcond[7] = ((-1.0) + (((-1.0) * new_r00 * x438)) +
                                                                                 ((new_r10 * x437)));
                                                                  if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                                      IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                                  {
                                                                    continue;
                                                                  }
                                                                }

                                                                {
                                                                  std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(
                                                                      7);
                                                                  vinfos[0].jointtype = 1;
                                                                  vinfos[0].foffset = j0;
                                                                  vinfos[0].indices[0] = _ij0[0];
                                                                  vinfos[0].indices[1] = _ij0[1];
                                                                  vinfos[0].maxsolutions = _nj0;
                                                                  vinfos[1].jointtype = 1;
                                                                  vinfos[1].foffset = j1;
                                                                  vinfos[1].indices[0] = _ij1[0];
                                                                  vinfos[1].indices[1] = _ij1[1];
                                                                  vinfos[1].maxsolutions = _nj1;
                                                                  vinfos[2].jointtype = 1;
                                                                  vinfos[2].foffset = j2;
                                                                  vinfos[2].indices[0] = _ij2[0];
                                                                  vinfos[2].indices[1] = _ij2[1];
                                                                  vinfos[2].maxsolutions = _nj2;
                                                                  vinfos[3].jointtype = 1;
                                                                  vinfos[3].foffset = j3;
                                                                  vinfos[3].indices[0] = _ij3[0];
                                                                  vinfos[3].indices[1] = _ij3[1];
                                                                  vinfos[3].maxsolutions = _nj3;
                                                                  vinfos[4].jointtype = 1;
                                                                  vinfos[4].foffset = j4;
                                                                  vinfos[4].indices[0] = _ij4[0];
                                                                  vinfos[4].indices[1] = _ij4[1];
                                                                  vinfos[4].maxsolutions = _nj4;
                                                                  vinfos[5].jointtype = 1;
                                                                  vinfos[5].foffset = j5;
                                                                  vinfos[5].indices[0] = _ij5[0];
                                                                  vinfos[5].indices[1] = _ij5[1];
                                                                  vinfos[5].maxsolutions = _nj5;
                                                                  vinfos[6].jointtype = 1;
                                                                  vinfos[6].foffset = j6;
                                                                  vinfos[6].indices[0] = _ij6[0];
                                                                  vinfos[6].indices[1] = _ij6[1];
                                                                  vinfos[6].maxsolutions = _nj6;
                                                                  std::vector<int> vfree(0);
                                                                  solutions.AddSolution(vinfos, vfree);
                                                                }
                                                              }
                                                            }
                                                          }
                                                        } while (0);
                                                        if (bgotonextstatement)
                                                        {
                                                          bool bgotonextstatement = true;
                                                          do
                                                          {
                                                            evalcond[0] = ((new_r10 * new_r10) + (new_r00 * new_r00));
                                                            if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                            {
                                                              bgotonextstatement = false;
                                                              {
                                                                IkReal j0eval[1];
                                                                sj1 = 0;
                                                                cj1 = 1.0;
                                                                j1 = 0;
                                                                new_r10 = 0;
                                                                new_r00 = 0;
                                                                j0eval[0] = ((IKabs(new_r11)) + (IKabs(new_r01)));
                                                                if (IKabs(j0eval[0]) < 0.0000010000000000)
                                                                {
                                                                  continue;  // 3 cases reached
                                                                }
                                                                else
                                                                {
                                                                  {
                                                                    IkReal j0array[2], cj0array[2], sj0array[2];
                                                                    bool j0valid[2] = { false };
                                                                    _nj0 = 2;
                                                                    CheckValue<IkReal> x440 =
                                                                        IKatan2WithCheck(IkReal(new_r01),
                                                                                         IkReal(new_r11),
                                                                                         IKFAST_ATAN2_MAGTHRESH);
                                                                    if (!x440.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    IkReal x439 = x440.value;
                                                                    j0array[0] = ((-1.0) * x439);
                                                                    sj0array[0] = IKsin(j0array[0]);
                                                                    cj0array[0] = IKcos(j0array[0]);
                                                                    j0array[1] =
                                                                        ((3.14159265358979) + (((-1.0) * x439)));
                                                                    sj0array[1] = IKsin(j0array[1]);
                                                                    cj0array[1] = IKcos(j0array[1]);
                                                                    if (j0array[0] > IKPI)
                                                                    {
                                                                      j0array[0] -= IK2PI;
                                                                    }
                                                                    else if (j0array[0] < -IKPI)
                                                                    {
                                                                      j0array[0] += IK2PI;
                                                                    }
                                                                    j0valid[0] = true;
                                                                    if (j0array[1] > IKPI)
                                                                    {
                                                                      j0array[1] -= IK2PI;
                                                                    }
                                                                    else if (j0array[1] < -IKPI)
                                                                    {
                                                                      j0array[1] += IK2PI;
                                                                    }
                                                                    j0valid[1] = true;
                                                                    for (int ij0 = 0; ij0 < 2; ++ij0)
                                                                    {
                                                                      if (!j0valid[ij0])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij0[0] = ij0;
                                                                      _ij0[1] = -1;
                                                                      for (int iij0 = ij0 + 1; iij0 < 2; ++iij0)
                                                                      {
                                                                        if (j0valid[iij0] &&
                                                                            IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                                IKFAST_SOLUTION_THRESH &&
                                                                            IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                                IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j0valid[iij0] = false;
                                                                          _ij0[1] = iij0;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j0 = j0array[ij0];
                                                                      cj0 = cj0array[ij0];
                                                                      sj0 = sj0array[ij0];
                                                                      {
                                                                        IkReal evalcond[1];
                                                                        evalcond[0] =
                                                                            (((new_r11 * (IKcos(j0)))) +
                                                                             (((-1.0) * new_r01 * (IKsin(j0)))));
                                                                        if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      {
                                                                        std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                            vinfos(7);
                                                                        vinfos[0].jointtype = 1;
                                                                        vinfos[0].foffset = j0;
                                                                        vinfos[0].indices[0] = _ij0[0];
                                                                        vinfos[0].indices[1] = _ij0[1];
                                                                        vinfos[0].maxsolutions = _nj0;
                                                                        vinfos[1].jointtype = 1;
                                                                        vinfos[1].foffset = j1;
                                                                        vinfos[1].indices[0] = _ij1[0];
                                                                        vinfos[1].indices[1] = _ij1[1];
                                                                        vinfos[1].maxsolutions = _nj1;
                                                                        vinfos[2].jointtype = 1;
                                                                        vinfos[2].foffset = j2;
                                                                        vinfos[2].indices[0] = _ij2[0];
                                                                        vinfos[2].indices[1] = _ij2[1];
                                                                        vinfos[2].maxsolutions = _nj2;
                                                                        vinfos[3].jointtype = 1;
                                                                        vinfos[3].foffset = j3;
                                                                        vinfos[3].indices[0] = _ij3[0];
                                                                        vinfos[3].indices[1] = _ij3[1];
                                                                        vinfos[3].maxsolutions = _nj3;
                                                                        vinfos[4].jointtype = 1;
                                                                        vinfos[4].foffset = j4;
                                                                        vinfos[4].indices[0] = _ij4[0];
                                                                        vinfos[4].indices[1] = _ij4[1];
                                                                        vinfos[4].maxsolutions = _nj4;
                                                                        vinfos[5].jointtype = 1;
                                                                        vinfos[5].foffset = j5;
                                                                        vinfos[5].indices[0] = _ij5[0];
                                                                        vinfos[5].indices[1] = _ij5[1];
                                                                        vinfos[5].maxsolutions = _nj5;
                                                                        vinfos[6].jointtype = 1;
                                                                        vinfos[6].foffset = j6;
                                                                        vinfos[6].indices[0] = _ij6[0];
                                                                        vinfos[6].indices[1] = _ij6[1];
                                                                        vinfos[6].maxsolutions = _nj6;
                                                                        std::vector<int> vfree(0);
                                                                        solutions.AddSolution(vinfos, vfree);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          } while (0);
                                                          if (bgotonextstatement)
                                                          {
                                                            bool bgotonextstatement = true;
                                                            do
                                                            {
                                                              evalcond[0] = ((IKabs(new_r10)) + (IKabs(new_r00)));
                                                              if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                              {
                                                                bgotonextstatement = false;
                                                                {
                                                                  IkReal j0eval[1];
                                                                  sj1 = 0;
                                                                  cj1 = 1.0;
                                                                  j1 = 0;
                                                                  new_r00 = 0;
                                                                  new_r10 = 0;
                                                                  new_r21 = 0;
                                                                  new_r22 = 0;
                                                                  j0eval[0] = ((IKabs(new_r11)) + (IKabs(new_r01)));
                                                                  if (IKabs(j0eval[0]) < 0.0000010000000000)
                                                                  {
                                                                    continue;  // no branches [j0]
                                                                  }
                                                                  else
                                                                  {
                                                                    {
                                                                      IkReal j0array[2], cj0array[2], sj0array[2];
                                                                      bool j0valid[2] = { false };
                                                                      _nj0 = 2;
                                                                      CheckValue<IkReal> x442 =
                                                                          IKatan2WithCheck(IkReal(new_r01),
                                                                                           IkReal(new_r11),
                                                                                           IKFAST_ATAN2_MAGTHRESH);
                                                                      if (!x442.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      IkReal x441 = x442.value;
                                                                      j0array[0] = ((-1.0) * x441);
                                                                      sj0array[0] = IKsin(j0array[0]);
                                                                      cj0array[0] = IKcos(j0array[0]);
                                                                      j0array[1] =
                                                                          ((3.14159265358979) + (((-1.0) * x441)));
                                                                      sj0array[1] = IKsin(j0array[1]);
                                                                      cj0array[1] = IKcos(j0array[1]);
                                                                      if (j0array[0] > IKPI)
                                                                      {
                                                                        j0array[0] -= IK2PI;
                                                                      }
                                                                      else if (j0array[0] < -IKPI)
                                                                      {
                                                                        j0array[0] += IK2PI;
                                                                      }
                                                                      j0valid[0] = true;
                                                                      if (j0array[1] > IKPI)
                                                                      {
                                                                        j0array[1] -= IK2PI;
                                                                      }
                                                                      else if (j0array[1] < -IKPI)
                                                                      {
                                                                        j0array[1] += IK2PI;
                                                                      }
                                                                      j0valid[1] = true;
                                                                      for (int ij0 = 0; ij0 < 2; ++ij0)
                                                                      {
                                                                        if (!j0valid[ij0])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij0[0] = ij0;
                                                                        _ij0[1] = -1;
                                                                        for (int iij0 = ij0 + 1; iij0 < 2; ++iij0)
                                                                        {
                                                                          if (j0valid[iij0] &&
                                                                              IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                              IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                                                  IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j0valid[iij0] = false;
                                                                            _ij0[1] = iij0;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j0 = j0array[ij0];
                                                                        cj0 = cj0array[ij0];
                                                                        sj0 = sj0array[ij0];
                                                                        {
                                                                          IkReal evalcond[1];
                                                                          evalcond[0] =
                                                                              (((new_r11 * (IKcos(j0)))) +
                                                                               (((-1.0) * new_r01 * (IKsin(j0)))));
                                                                          if (IKabs(evalcond[0]) >
                                                                              IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        {
                                                                          std::vector<IkSingleDOFSolutionBase<IkReal> >
                                                                              vinfos(7);
                                                                          vinfos[0].jointtype = 1;
                                                                          vinfos[0].foffset = j0;
                                                                          vinfos[0].indices[0] = _ij0[0];
                                                                          vinfos[0].indices[1] = _ij0[1];
                                                                          vinfos[0].maxsolutions = _nj0;
                                                                          vinfos[1].jointtype = 1;
                                                                          vinfos[1].foffset = j1;
                                                                          vinfos[1].indices[0] = _ij1[0];
                                                                          vinfos[1].indices[1] = _ij1[1];
                                                                          vinfos[1].maxsolutions = _nj1;
                                                                          vinfos[2].jointtype = 1;
                                                                          vinfos[2].foffset = j2;
                                                                          vinfos[2].indices[0] = _ij2[0];
                                                                          vinfos[2].indices[1] = _ij2[1];
                                                                          vinfos[2].maxsolutions = _nj2;
                                                                          vinfos[3].jointtype = 1;
                                                                          vinfos[3].foffset = j3;
                                                                          vinfos[3].indices[0] = _ij3[0];
                                                                          vinfos[3].indices[1] = _ij3[1];
                                                                          vinfos[3].maxsolutions = _nj3;
                                                                          vinfos[4].jointtype = 1;
                                                                          vinfos[4].foffset = j4;
                                                                          vinfos[4].indices[0] = _ij4[0];
                                                                          vinfos[4].indices[1] = _ij4[1];
                                                                          vinfos[4].maxsolutions = _nj4;
                                                                          vinfos[5].jointtype = 1;
                                                                          vinfos[5].foffset = j5;
                                                                          vinfos[5].indices[0] = _ij5[0];
                                                                          vinfos[5].indices[1] = _ij5[1];
                                                                          vinfos[5].maxsolutions = _nj5;
                                                                          vinfos[6].jointtype = 1;
                                                                          vinfos[6].foffset = j6;
                                                                          vinfos[6].indices[0] = _ij6[0];
                                                                          vinfos[6].indices[1] = _ij6[1];
                                                                          vinfos[6].maxsolutions = _nj6;
                                                                          std::vector<int> vfree(0);
                                                                          solutions.AddSolution(vinfos, vfree);
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            } while (0);
                                                            if (bgotonextstatement)
                                                            {
                                                              bool bgotonextstatement = true;
                                                              do
                                                              {
                                                                if (1)
                                                                {
                                                                  bgotonextstatement = false;
                                                                  continue;  // branch miss [j0]
                                                                }
                                                              } while (0);
                                                              if (bgotonextstatement)
                                                              {
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                              else
                                              {
                                                {
                                                  IkReal j0array[1], cj0array[1], sj0array[1];
                                                  bool j0valid[1] = { false };
                                                  _nj0 = 1;
                                                  IkReal x443 = ((1.0) * new_r10);
                                                  CheckValue<IkReal> x444 = IKatan2WithCheck(
                                                      IkReal((((cj2 * sj2)) + (((-1.0) * new_r00 * x443)))),
                                                      IkReal(((((-1.0) * (cj2 * cj2))) + (new_r10 * new_r10))),
                                                      IKFAST_ATAN2_MAGTHRESH);
                                                  if (!x444.valid)
                                                  {
                                                    continue;
                                                  }
                                                  CheckValue<IkReal> x445 = IKPowWithIntegerCheck(
                                                      IKsign(((((-1.0) * sj2 * x443)) + ((cj2 * new_r00)))), -1);
                                                  if (!x445.valid)
                                                  {
                                                    continue;
                                                  }
                                                  j0array[0] = ((-1.5707963267949) + (x444.value) +
                                                                (((1.5707963267949) * (x445.value))));
                                                  sj0array[0] = IKsin(j0array[0]);
                                                  cj0array[0] = IKcos(j0array[0]);
                                                  if (j0array[0] > IKPI)
                                                  {
                                                    j0array[0] -= IK2PI;
                                                  }
                                                  else if (j0array[0] < -IKPI)
                                                  {
                                                    j0array[0] += IK2PI;
                                                  }
                                                  j0valid[0] = true;
                                                  for (int ij0 = 0; ij0 < 1; ++ij0)
                                                  {
                                                    if (!j0valid[ij0])
                                                    {
                                                      continue;
                                                    }
                                                    _ij0[0] = ij0;
                                                    _ij0[1] = -1;
                                                    for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                    {
                                                      if (j0valid[iij0] &&
                                                          IKabs(cj0array[ij0] - cj0array[iij0]) <
                                                              IKFAST_SOLUTION_THRESH &&
                                                          IKabs(sj0array[ij0] - sj0array[iij0]) <
                                                              IKFAST_SOLUTION_THRESH)
                                                      {
                                                        j0valid[iij0] = false;
                                                        _ij0[1] = iij0;
                                                        break;
                                                      }
                                                    }
                                                    j0 = j0array[ij0];
                                                    cj0 = cj0array[ij0];
                                                    sj0 = sj0array[ij0];
                                                    {
                                                      IkReal evalcond[8];
                                                      IkReal x446 = IKcos(j0);
                                                      IkReal x447 = IKsin(j0);
                                                      IkReal x448 = ((1.0) * sj2);
                                                      IkReal x449 = (cj2 * x446);
                                                      IkReal x450 = ((1.0) * x447);
                                                      IkReal x451 = (x447 * x448);
                                                      evalcond[0] = (((new_r00 * x446)) + cj2 + ((new_r10 * x447)));
                                                      evalcond[1] = (((cj2 * x447)) + ((sj2 * x446)) + new_r10);
                                                      evalcond[2] =
                                                          (sj2 + (((-1.0) * new_r00 * x450)) + ((new_r10 * x446)));
                                                      evalcond[3] =
                                                          (cj2 + (((-1.0) * new_r01 * x450)) + ((new_r11 * x446)));
                                                      evalcond[4] = ((((-1.0) * x451)) + x449 + new_r00);
                                                      evalcond[5] = ((((-1.0) * x451)) + x449 + new_r11);
                                                      evalcond[6] =
                                                          ((((-1.0) * x448)) + ((new_r01 * x446)) + ((new_r11 * x447)));
                                                      evalcond[7] = (new_r01 + (((-1.0) * cj2 * x450)) +
                                                                     (((-1.0) * x446 * x448)));
                                                      if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                          IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                      {
                                                        continue;
                                                      }
                                                    }

                                                    {
                                                      std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                      vinfos[0].jointtype = 1;
                                                      vinfos[0].foffset = j0;
                                                      vinfos[0].indices[0] = _ij0[0];
                                                      vinfos[0].indices[1] = _ij0[1];
                                                      vinfos[0].maxsolutions = _nj0;
                                                      vinfos[1].jointtype = 1;
                                                      vinfos[1].foffset = j1;
                                                      vinfos[1].indices[0] = _ij1[0];
                                                      vinfos[1].indices[1] = _ij1[1];
                                                      vinfos[1].maxsolutions = _nj1;
                                                      vinfos[2].jointtype = 1;
                                                      vinfos[2].foffset = j2;
                                                      vinfos[2].indices[0] = _ij2[0];
                                                      vinfos[2].indices[1] = _ij2[1];
                                                      vinfos[2].maxsolutions = _nj2;
                                                      vinfos[3].jointtype = 1;
                                                      vinfos[3].foffset = j3;
                                                      vinfos[3].indices[0] = _ij3[0];
                                                      vinfos[3].indices[1] = _ij3[1];
                                                      vinfos[3].maxsolutions = _nj3;
                                                      vinfos[4].jointtype = 1;
                                                      vinfos[4].foffset = j4;
                                                      vinfos[4].indices[0] = _ij4[0];
                                                      vinfos[4].indices[1] = _ij4[1];
                                                      vinfos[4].maxsolutions = _nj4;
                                                      vinfos[5].jointtype = 1;
                                                      vinfos[5].foffset = j5;
                                                      vinfos[5].indices[0] = _ij5[0];
                                                      vinfos[5].indices[1] = _ij5[1];
                                                      vinfos[5].maxsolutions = _nj5;
                                                      vinfos[6].jointtype = 1;
                                                      vinfos[6].foffset = j6;
                                                      vinfos[6].indices[0] = _ij6[0];
                                                      vinfos[6].indices[1] = _ij6[1];
                                                      vinfos[6].maxsolutions = _nj6;
                                                      std::vector<int> vfree(0);
                                                      solutions.AddSolution(vinfos, vfree);
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                          else
                                          {
                                            {
                                              IkReal j0array[1], cj0array[1], sj0array[1];
                                              bool j0valid[1] = { false };
                                              _nj0 = 1;
                                              IkReal x452 = ((1.0) * cj2);
                                              CheckValue<IkReal> x453 = IKatan2WithCheck(
                                                  IkReal(((((-1.0) * new_r11 * x452)) + ((cj2 * new_r00)))),
                                                  IkReal(((((-1.0) * new_r10 * x452)) + (((-1.0) * new_r01 * x452)))),
                                                  IKFAST_ATAN2_MAGTHRESH);
                                              if (!x453.valid)
                                              {
                                                continue;
                                              }
                                              CheckValue<IkReal> x454 = IKPowWithIntegerCheck(
                                                  IKsign((((new_r10 * new_r11)) + ((new_r00 * new_r01)))), -1);
                                              if (!x454.valid)
                                              {
                                                continue;
                                              }
                                              j0array[0] = ((-1.5707963267949) + (x453.value) +
                                                            (((1.5707963267949) * (x454.value))));
                                              sj0array[0] = IKsin(j0array[0]);
                                              cj0array[0] = IKcos(j0array[0]);
                                              if (j0array[0] > IKPI)
                                              {
                                                j0array[0] -= IK2PI;
                                              }
                                              else if (j0array[0] < -IKPI)
                                              {
                                                j0array[0] += IK2PI;
                                              }
                                              j0valid[0] = true;
                                              for (int ij0 = 0; ij0 < 1; ++ij0)
                                              {
                                                if (!j0valid[ij0])
                                                {
                                                  continue;
                                                }
                                                _ij0[0] = ij0;
                                                _ij0[1] = -1;
                                                for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                                {
                                                  if (j0valid[iij0] &&
                                                      IKabs(cj0array[ij0] - cj0array[iij0]) < IKFAST_SOLUTION_THRESH &&
                                                      IKabs(sj0array[ij0] - sj0array[iij0]) < IKFAST_SOLUTION_THRESH)
                                                  {
                                                    j0valid[iij0] = false;
                                                    _ij0[1] = iij0;
                                                    break;
                                                  }
                                                }
                                                j0 = j0array[ij0];
                                                cj0 = cj0array[ij0];
                                                sj0 = sj0array[ij0];
                                                {
                                                  IkReal evalcond[8];
                                                  IkReal x455 = IKcos(j0);
                                                  IkReal x456 = IKsin(j0);
                                                  IkReal x457 = ((1.0) * sj2);
                                                  IkReal x458 = (cj2 * x455);
                                                  IkReal x459 = ((1.0) * x456);
                                                  IkReal x460 = (x456 * x457);
                                                  evalcond[0] = (((new_r10 * x456)) + cj2 + ((new_r00 * x455)));
                                                  evalcond[1] = (((sj2 * x455)) + ((cj2 * x456)) + new_r10);
                                                  evalcond[2] =
                                                      (((new_r10 * x455)) + sj2 + (((-1.0) * new_r00 * x459)));
                                                  evalcond[3] =
                                                      (((new_r11 * x455)) + cj2 + (((-1.0) * new_r01 * x459)));
                                                  evalcond[4] = ((((-1.0) * x460)) + x458 + new_r00);
                                                  evalcond[5] = ((((-1.0) * x460)) + x458 + new_r11);
                                                  evalcond[6] =
                                                      (((new_r11 * x456)) + ((new_r01 * x455)) + (((-1.0) * x457)));
                                                  evalcond[7] =
                                                      ((((-1.0) * x455 * x457)) + new_r01 + (((-1.0) * cj2 * x459)));
                                                  if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                      IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                                  {
                                                    continue;
                                                  }
                                                }

                                                {
                                                  std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                                  vinfos[0].jointtype = 1;
                                                  vinfos[0].foffset = j0;
                                                  vinfos[0].indices[0] = _ij0[0];
                                                  vinfos[0].indices[1] = _ij0[1];
                                                  vinfos[0].maxsolutions = _nj0;
                                                  vinfos[1].jointtype = 1;
                                                  vinfos[1].foffset = j1;
                                                  vinfos[1].indices[0] = _ij1[0];
                                                  vinfos[1].indices[1] = _ij1[1];
                                                  vinfos[1].maxsolutions = _nj1;
                                                  vinfos[2].jointtype = 1;
                                                  vinfos[2].foffset = j2;
                                                  vinfos[2].indices[0] = _ij2[0];
                                                  vinfos[2].indices[1] = _ij2[1];
                                                  vinfos[2].maxsolutions = _nj2;
                                                  vinfos[3].jointtype = 1;
                                                  vinfos[3].foffset = j3;
                                                  vinfos[3].indices[0] = _ij3[0];
                                                  vinfos[3].indices[1] = _ij3[1];
                                                  vinfos[3].maxsolutions = _nj3;
                                                  vinfos[4].jointtype = 1;
                                                  vinfos[4].foffset = j4;
                                                  vinfos[4].indices[0] = _ij4[0];
                                                  vinfos[4].indices[1] = _ij4[1];
                                                  vinfos[4].maxsolutions = _nj4;
                                                  vinfos[5].jointtype = 1;
                                                  vinfos[5].foffset = j5;
                                                  vinfos[5].indices[0] = _ij5[0];
                                                  vinfos[5].indices[1] = _ij5[1];
                                                  vinfos[5].maxsolutions = _nj5;
                                                  vinfos[6].jointtype = 1;
                                                  vinfos[6].foffset = j6;
                                                  vinfos[6].indices[0] = _ij6[0];
                                                  vinfos[6].indices[1] = _ij6[1];
                                                  vinfos[6].maxsolutions = _nj6;
                                                  std::vector<int> vfree(0);
                                                  solutions.AddSolution(vinfos, vfree);
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                      else
                                      {
                                        {
                                          IkReal j0array[1], cj0array[1], sj0array[1];
                                          bool j0valid[1] = { false };
                                          _nj0 = 1;
                                          IkReal x461 = ((1.0) * cj2);
                                          CheckValue<IkReal> x462 = IKPowWithIntegerCheck(
                                              IKsign(((new_r10 * new_r10) + (new_r00 * new_r00))), -1);
                                          if (!x462.valid)
                                          {
                                            continue;
                                          }
                                          CheckValue<IkReal> x463 = IKatan2WithCheck(
                                              IkReal(((((-1.0) * new_r10 * x461)) + ((new_r00 * sj2)))),
                                              IkReal(((((-1.0) * new_r00 * x461)) + (((-1.0) * new_r10 * sj2)))),
                                              IKFAST_ATAN2_MAGTHRESH);
                                          if (!x463.valid)
                                          {
                                            continue;
                                          }
                                          j0array[0] = ((-1.5707963267949) + (((1.5707963267949) * (x462.value))) +
                                                        (x463.value));
                                          sj0array[0] = IKsin(j0array[0]);
                                          cj0array[0] = IKcos(j0array[0]);
                                          if (j0array[0] > IKPI)
                                          {
                                            j0array[0] -= IK2PI;
                                          }
                                          else if (j0array[0] < -IKPI)
                                          {
                                            j0array[0] += IK2PI;
                                          }
                                          j0valid[0] = true;
                                          for (int ij0 = 0; ij0 < 1; ++ij0)
                                          {
                                            if (!j0valid[ij0])
                                            {
                                              continue;
                                            }
                                            _ij0[0] = ij0;
                                            _ij0[1] = -1;
                                            for (int iij0 = ij0 + 1; iij0 < 1; ++iij0)
                                            {
                                              if (j0valid[iij0] &&
                                                  IKabs(cj0array[ij0] - cj0array[iij0]) < IKFAST_SOLUTION_THRESH &&
                                                  IKabs(sj0array[ij0] - sj0array[iij0]) < IKFAST_SOLUTION_THRESH)
                                              {
                                                j0valid[iij0] = false;
                                                _ij0[1] = iij0;
                                                break;
                                              }
                                            }
                                            j0 = j0array[ij0];
                                            cj0 = cj0array[ij0];
                                            sj0 = sj0array[ij0];
                                            {
                                              IkReal evalcond[8];
                                              IkReal x464 = IKcos(j0);
                                              IkReal x465 = IKsin(j0);
                                              IkReal x466 = ((1.0) * sj2);
                                              IkReal x467 = (cj2 * x464);
                                              IkReal x468 = ((1.0) * x465);
                                              IkReal x469 = (x465 * x466);
                                              evalcond[0] = (((new_r10 * x465)) + cj2 + ((new_r00 * x464)));
                                              evalcond[1] = (((cj2 * x465)) + new_r10 + ((sj2 * x464)));
                                              evalcond[2] = (sj2 + ((new_r10 * x464)) + (((-1.0) * new_r00 * x468)));
                                              evalcond[3] = (((new_r11 * x464)) + cj2 + (((-1.0) * new_r01 * x468)));
                                              evalcond[4] = ((((-1.0) * x469)) + x467 + new_r00);
                                              evalcond[5] = ((((-1.0) * x469)) + x467 + new_r11);
                                              evalcond[6] =
                                                  (((new_r11 * x465)) + ((new_r01 * x464)) + (((-1.0) * x466)));
                                              evalcond[7] =
                                                  ((((-1.0) * x464 * x466)) + new_r01 + (((-1.0) * cj2 * x468)));
                                              if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH ||
                                                  IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH)
                                              {
                                                continue;
                                              }
                                            }

                                            {
                                              std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
                                              vinfos[0].jointtype = 1;
                                              vinfos[0].foffset = j0;
                                              vinfos[0].indices[0] = _ij0[0];
                                              vinfos[0].indices[1] = _ij0[1];
                                              vinfos[0].maxsolutions = _nj0;
                                              vinfos[1].jointtype = 1;
                                              vinfos[1].foffset = j1;
                                              vinfos[1].indices[0] = _ij1[0];
                                              vinfos[1].indices[1] = _ij1[1];
                                              vinfos[1].maxsolutions = _nj1;
                                              vinfos[2].jointtype = 1;
                                              vinfos[2].foffset = j2;
                                              vinfos[2].indices[0] = _ij2[0];
                                              vinfos[2].indices[1] = _ij2[1];
                                              vinfos[2].maxsolutions = _nj2;
                                              vinfos[3].jointtype = 1;
                                              vinfos[3].foffset = j3;
                                              vinfos[3].indices[0] = _ij3[0];
                                              vinfos[3].indices[1] = _ij3[1];
                                              vinfos[3].maxsolutions = _nj3;
                                              vinfos[4].jointtype = 1;
                                              vinfos[4].foffset = j4;
                                              vinfos[4].indices[0] = _ij4[0];
                                              vinfos[4].indices[1] = _ij4[1];
                                              vinfos[4].maxsolutions = _nj4;
                                              vinfos[5].jointtype = 1;
                                              vinfos[5].foffset = j5;
                                              vinfos[5].indices[0] = _ij5[0];
                                              vinfos[5].indices[1] = _ij5[1];
                                              vinfos[5].maxsolutions = _nj5;
                                              vinfos[6].jointtype = 1;
                                              vinfos[6].foffset = j6;
                                              vinfos[6].indices[0] = _ij6[0];
                                              vinfos[6].indices[1] = _ij6[1];
                                              vinfos[6].maxsolutions = _nj6;
                                              std::vector<int> vfree(0);
                                              solutions.AddSolution(vinfos, vfree);
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                } while (0);
                                if (bgotonextstatement)
                                {
                                  bool bgotonextstatement = true;
                                  do
                                  {
                                    evalcond[0] = ((-3.14159265358979) +
                                                   (IKfmod(((3.14159265358979) + (IKabs(((-3.14159265358979) + j1)))),
                                                           6.28318530717959)));
                                    evalcond[1] = new_r21;
                                    evalcond[2] = new_r02;
                                    evalcond[3] = new_r12;
                                    evalcond[4] = new_r20;
                                    if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                        IKabs(evalcond[1]) < 0.0000050000000000 &&
                                        IKabs(evalcond[2]) < 0.0000050000000000 &&
                                        IKabs(evalcond[3]) < 0.0000050000000000 &&
                                        IKabs(evalcond[4]) < 0.0000050000000000)
                                    {
                                      bgotonextstatement = false;
                                      {
                                        IkReal j0eval[3];
                                        sj1 = 0;
                                        cj1 = -1.0;
                                        j1 = 3.14159265358979;
                                        IkReal x470 = ((1.0) * sj2);
                                        IkReal x471 = (((new_r10 * new_r11)) + ((new_r00 * new_r01)));
                                        j0eval[0] = x471;
                                        j0eval[1] =
                                            ((IKabs(((((-1.0) * new_r00 * x470)) + (((-1.0) * new_r11 * x470))))) +
                                             (IKabs((((new_r01 * sj2)) + (((-1.0) * new_r10 * x470))))));
                                        j0eval[2] = IKsign(x471);
                                        if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                            IKabs(j0eval[1]) < 0.0000010000000000 ||
                                            IKabs(j0eval[2]) < 0.0000010000000000)
                                        {
                                          {
                                            IkReal j0eval[3];
                                            sj1 = 0;
                                            cj1 = -1.0;
                                            j1 = 3.14159265358979;
                                            IkReal x472 = ((1.0) * new_r11);
                                            IkReal x473 = ((new_r01 * new_r01) + (new_r11 * new_r11));
                                            j0eval[0] = x473;
                                            j0eval[1] =
                                                ((IKabs(((((-1.0) * sj2 * x472)) + ((cj2 * new_r01))))) +
                                                 (IKabs(((((-1.0) * new_r01 * sj2)) + (((-1.0) * cj2 * x472))))));
                                            j0eval[2] = IKsign(x473);
                                            if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                IKabs(j0eval[1]) < 0.0000010000000000 ||
                                                IKabs(j0eval[2]) < 0.0000010000000000)
                                            {
                                              {
                                                IkReal j0eval[3];
                                                sj1 = 0;
                                                cj1 = -1.0;
                                                j1 = 3.14159265358979;
                                                IkReal x474 = (((new_r11 * sj2)) + ((cj2 * new_r01)));
                                                j0eval[0] = x474;
                                                j0eval[1] = IKsign(x474);
                                                j0eval[2] = ((IKabs(((((-1.0) * cj2 * sj2)) +
                                                                     (((-1.0) * new_r10 * new_r11))))) +
                                                             (IKabs(((-1.0) + (cj2 * cj2) + ((new_r01 * new_r10))))));
                                                if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                    IKabs(j0eval[1]) < 0.0000010000000000 ||
                                                    IKabs(j0eval[2]) < 0.0000010000000000)
                                                {
                                                  {
                                                    IkReal evalcond[1];
                                                    bool bgotonextstatement = true;
                                                    do
                                                    {
                                                      IkReal x476 = ((new_r01 * new_r01) + (new_r11 * new_r11));
                                                      if (IKabs(x476) == 0)
                                                      {
                                                        continue;
                                                      }
                                                      IkReal x475 = pow(x476, -0.5);
                                                      CheckValue<IkReal> x477 = IKatan2WithCheck(
                                                          IkReal(new_r01), IkReal(new_r11), IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x477.valid)
                                                      {
                                                        continue;
                                                      }
                                                      IkReal gconst6 = ((-1.0) * (x477.value));
                                                      IkReal gconst7 = ((-1.0) * new_r01 * x475);
                                                      IkReal gconst8 = (new_r11 * x475);
                                                      CheckValue<IkReal> x478 = IKatan2WithCheck(
                                                          IkReal(new_r01), IkReal(new_r11), IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x478.valid)
                                                      {
                                                        continue;
                                                      }
                                                      evalcond[0] =
                                                          ((-3.14159265358979) +
                                                           (IKfmod(((3.14159265358979) + (IKabs(((x478.value) + j2)))),
                                                                   6.28318530717959)));
                                                      if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                      {
                                                        bgotonextstatement = false;
                                                        {
                                                          IkReal j0eval[3];
                                                          CheckValue<IkReal> x481 = IKatan2WithCheck(
                                                              IkReal(new_r01), IkReal(new_r11), IKFAST_ATAN2_MAGTHRESH);
                                                          if (!x481.valid)
                                                          {
                                                            continue;
                                                          }
                                                          IkReal x479 = ((-1.0) * (x481.value));
                                                          IkReal x480 = x475;
                                                          sj1 = 0;
                                                          cj1 = -1.0;
                                                          j1 = 3.14159265358979;
                                                          sj2 = gconst7;
                                                          cj2 = gconst8;
                                                          j2 = x479;
                                                          IkReal gconst6 = x479;
                                                          IkReal gconst7 = ((-1.0) * new_r01 * x480);
                                                          IkReal gconst8 = (new_r11 * x480);
                                                          IkReal x482 = new_r01 * new_r01;
                                                          IkReal x483 = (new_r00 * new_r01);
                                                          IkReal x484 = (((new_r10 * new_r11)) + x483);
                                                          IkReal x485 = x475;
                                                          IkReal x486 = (new_r01 * x485);
                                                          j0eval[0] = x484;
                                                          j0eval[1] = IKsign(x484);
                                                          j0eval[2] = ((IKabs((((new_r10 * x486)) +
                                                                               (((-1.0) * x482 * x485))))) +
                                                                       (IKabs((((x483 * x485)) + ((new_r11 * x486))))));
                                                          if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                              IKabs(j0eval[1]) < 0.0000010000000000 ||
                                                              IKabs(j0eval[2]) < 0.0000010000000000)
                                                          {
                                                            {
                                                              IkReal j0eval[2];
                                                              CheckValue<IkReal> x489 =
                                                                  IKatan2WithCheck(IkReal(new_r01),
                                                                                   IkReal(new_r11),
                                                                                   IKFAST_ATAN2_MAGTHRESH);
                                                              if (!x489.valid)
                                                              {
                                                                continue;
                                                              }
                                                              IkReal x487 = ((-1.0) * (x489.value));
                                                              IkReal x488 = x475;
                                                              sj1 = 0;
                                                              cj1 = -1.0;
                                                              j1 = 3.14159265358979;
                                                              sj2 = gconst7;
                                                              cj2 = gconst8;
                                                              j2 = x487;
                                                              IkReal gconst6 = x487;
                                                              IkReal gconst7 = ((-1.0) * new_r01 * x488);
                                                              IkReal gconst8 = (new_r11 * x488);
                                                              IkReal x490 = ((new_r01 * new_r01) + (new_r11 * new_r11));
                                                              j0eval[0] = x490;
                                                              j0eval[1] = IKsign(x490);
                                                              if (IKabs(j0eval[0]) < 0.0000010000000000 ||
                                                                  IKabs(j0eval[1]) < 0.0000010000000000)
                                                              {
                                                                {
                                                                  IkReal j0eval[1];
                                                                  CheckValue<IkReal> x493 =
                                                                      IKatan2WithCheck(IkReal(new_r01),
                                                                                       IkReal(new_r11),
                                                                                       IKFAST_ATAN2_MAGTHRESH);
                                                                  if (!x493.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x491 = ((-1.0) * (x493.value));
                                                                  IkReal x492 = x475;
                                                                  sj1 = 0;
                                                                  cj1 = -1.0;
                                                                  j1 = 3.14159265358979;
                                                                  sj2 = gconst7;
                                                                  cj2 = gconst8;
                                                                  j2 = x491;
                                                                  IkReal gconst6 = x491;
                                                                  IkReal gconst7 = ((-1.0) * new_r01 * x492);
                                                                  IkReal gconst8 = (new_r11 * x492);
                                                                  IkReal x494 = new_r01 * new_r01;
                                                                  IkReal x495 = new_r11 * new_r11;
                                                                  IkReal x496 = ((1.0) * x494);
                                                                  CheckValue<IkReal> x502 =
                                                                      IKPowWithIntegerCheck((x494 + x495), -1);
                                                                  if (!x502.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x497 = x502.value;
                                                                  CheckValue<IkReal> x503 = IKPowWithIntegerCheck(
                                                                      ((((-1.0) * x496)) + (((-1.0) * x495))), -1);
                                                                  if (!x503.valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  IkReal x498 = x503.value;
                                                                  IkReal x499 = ((1.0) * x498);
                                                                  IkReal x500 = (new_r11 * x499);
                                                                  IkReal x501 = (new_r01 * x499);
                                                                  j0eval[0] =
                                                                      ((IKabs((((x494 * x495 * x497)) +
                                                                               (((-1.0) * x496 * x497)) +
                                                                               ((x497 * (x495 * x495)))))) +
                                                                       (IKabs(((((-1.0) * new_r01 * x500)) +
                                                                               (((-1.0) * x500 *
                                                                                 (new_r01 * new_r01 * new_r01))) +
                                                                               (((-1.0) * new_r01 * x500 *
                                                                                 (new_r11 * new_r11)))))));
                                                                  if (IKabs(j0eval[0]) < 0.0000010000000000)
                                                                  {
                                                                    {
                                                                      IkReal evalcond[3];
                                                                      bool bgotonextstatement = true;
                                                                      do
                                                                      {
                                                                        evalcond[0] =
                                                                            ((IKabs(new_r11)) + (IKabs(new_r00)));
                                                                        if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                                        {
                                                                          bgotonextstatement = false;
                                                                          {
                                                                            IkReal j0eval[1];
                                                                            CheckValue<IkReal> x505 = IKatan2WithCheck(
                                                                                IkReal(new_r01),
                                                                                IkReal(0),
                                                                                IKFAST_ATAN2_MAGTHRESH);
                                                                            if (!x505.valid)
                                                                            {
                                                                              continue;
                                                                            }
                                                                            IkReal x504 = ((-1.0) * (x505.value));
                                                                            sj1 = 0;
                                                                            cj1 = -1.0;
                                                                            j1 = 3.14159265358979;
                                                                            sj2 = gconst7;
                                                                            cj2 = gconst8;
                                                                            j2 = x504;
                                                                            new_r11 = 0;
                                                                            new_r00 = 0;
                                                                            IkReal gconst6 = x504;
                                                                            IkReal x506 = new_r01 * new_r01;
                                                                            if (IKabs(x506) == 0)
                                                                            {
                                                                              continue;
                                                                            }
                                                                            IkReal gconst7 =
                                                                                ((-1.0) * new_r01 * (pow(x506, -0.5)));
                                                                            IkReal gconst8 = 0;
                                                                            j0eval[0] = new_r10;
                                                                            if (IKabs(j0eval[0]) < 0.0000010000000000)
                                                                            {
                                                                              {
                                                                                IkReal j0array[2], cj0array[2],
                                                                                    sj0array[2];
                                                                                bool j0valid[2] = { false };
                                                                                _nj0 = 2;
                                                                                CheckValue<IkReal> x507 =
                                                                                    IKPowWithIntegerCheck(gconst7, -1);
                                                                                if (!x507.valid)
                                                                                {
                                                                                  continue;
                                                                                }
                                                                                cj0array[0] =
                                                                                    ((-1.0) * new_r10 * (x507.value));
                                                                                if (cj0array[0] >=
                                                                                        -1 - IKFAST_SINCOS_THRESH &&
                                                                                    cj0array[0] <=
                                                                                        1 + IKFAST_SINCOS_THRESH)
                                                                                {
                                                                                  j0valid[0] = j0valid[1] = true;
                                                                                  j0array[0] = IKacos(cj0array[0]);
                                                                                  sj0array[0] = IKsin(j0array[0]);
                                                                                  cj0array[1] = cj0array[0];
                                                                                  j0array[1] = -j0array[0];
                                                                                  sj0array[1] = -sj0array[0];
                                                                                }
                                                                                else if (isnan(cj0array[0]))
                                                                                {
                                                                                  // probably any value will work
                                                                                  j0valid[0] = true;
                                                                                  cj0array[0] = 1;
                                                                                  sj0array[0] = 0;
                                                                                  j0array[0] = 0;
                                                                                }
                                                                                for (int ij0 = 0; ij0 < 2; ++ij0)
                                                                                {
                                                                                  if (!j0valid[ij0])
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  _ij0[0] = ij0;
                                                                                  _ij0[1] = -1;
                                                                                  for (int iij0 = ij0 + 1; iij0 < 2;
                                                                                       ++iij0)
                                                                                  {
                                                                                    if (j0valid[iij0] &&
                                                                                        IKabs(cj0array[ij0] -
                                                                                              cj0array[iij0]) <
                                                                                            IKFAST_SOLUTION_THRESH &&
                                                                                        IKabs(sj0array[ij0] -
                                                                                              sj0array[iij0]) <
                                                                                            IKFAST_SOLUTION_THRESH)
                                                                                    {
                                                                                      j0valid[iij0] = false;
                                                                                      _ij0[1] = iij0;
                                                                                      break;
                                                                                    }
                                                                                  }
                                                                                  j0 = j0array[ij0];
                                                                                  cj0 = cj0array[ij0];
                                                                                  sj0 = sj0array[ij0];
                                                                                  {
                                                                                    IkReal evalcond[6];
                                                                                    IkReal x508 = IKsin(j0);
                                                                                    IkReal x509 = IKcos(j0);
                                                                                    IkReal x510 = ((-1.0) * x508);
                                                                                    evalcond[0] = (new_r10 * x508);
                                                                                    evalcond[1] = (new_r01 * x510);
                                                                                    evalcond[2] = (gconst7 * x510);
                                                                                    evalcond[3] =
                                                                                        (gconst7 + ((new_r10 * x509)));
                                                                                    evalcond[4] =
                                                                                        (gconst7 + ((new_r01 * x509)));
                                                                                    evalcond[5] =
                                                                                        (((gconst7 * x509)) + new_r01);
                                                                                    if (IKabs(evalcond[0]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[1]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[2]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[3]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[4]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[5]) >
                                                                                            IKFAST_EVALCOND_THRESH)
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                  }

                                                                                  {
                                                                                    std::vector<IkSingleDOFSolutionBase<
                                                                                        IkReal> >
                                                                                        vinfos(7);
                                                                                    vinfos[0].jointtype = 1;
                                                                                    vinfos[0].foffset = j0;
                                                                                    vinfos[0].indices[0] = _ij0[0];
                                                                                    vinfos[0].indices[1] = _ij0[1];
                                                                                    vinfos[0].maxsolutions = _nj0;
                                                                                    vinfos[1].jointtype = 1;
                                                                                    vinfos[1].foffset = j1;
                                                                                    vinfos[1].indices[0] = _ij1[0];
                                                                                    vinfos[1].indices[1] = _ij1[1];
                                                                                    vinfos[1].maxsolutions = _nj1;
                                                                                    vinfos[2].jointtype = 1;
                                                                                    vinfos[2].foffset = j2;
                                                                                    vinfos[2].indices[0] = _ij2[0];
                                                                                    vinfos[2].indices[1] = _ij2[1];
                                                                                    vinfos[2].maxsolutions = _nj2;
                                                                                    vinfos[3].jointtype = 1;
                                                                                    vinfos[3].foffset = j3;
                                                                                    vinfos[3].indices[0] = _ij3[0];
                                                                                    vinfos[3].indices[1] = _ij3[1];
                                                                                    vinfos[3].maxsolutions = _nj3;
                                                                                    vinfos[4].jointtype = 1;
                                                                                    vinfos[4].foffset = j4;
                                                                                    vinfos[4].indices[0] = _ij4[0];
                                                                                    vinfos[4].indices[1] = _ij4[1];
                                                                                    vinfos[4].maxsolutions = _nj4;
                                                                                    vinfos[5].jointtype = 1;
                                                                                    vinfos[5].foffset = j5;
                                                                                    vinfos[5].indices[0] = _ij5[0];
                                                                                    vinfos[5].indices[1] = _ij5[1];
                                                                                    vinfos[5].maxsolutions = _nj5;
                                                                                    vinfos[6].jointtype = 1;
                                                                                    vinfos[6].foffset = j6;
                                                                                    vinfos[6].indices[0] = _ij6[0];
                                                                                    vinfos[6].indices[1] = _ij6[1];
                                                                                    vinfos[6].maxsolutions = _nj6;
                                                                                    std::vector<int> vfree(0);
                                                                                    solutions.AddSolution(vinfos,
                                                                                                          vfree);
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                            else
                                                                            {
                                                                              {
                                                                                IkReal j0array[2], cj0array[2],
                                                                                    sj0array[2];
                                                                                bool j0valid[2] = { false };
                                                                                _nj0 = 2;
                                                                                CheckValue<IkReal> x511 =
                                                                                    IKPowWithIntegerCheck(new_r10, -1);
                                                                                if (!x511.valid)
                                                                                {
                                                                                  continue;
                                                                                }
                                                                                cj0array[0] =
                                                                                    ((-1.0) * gconst7 * (x511.value));
                                                                                if (cj0array[0] >=
                                                                                        -1 - IKFAST_SINCOS_THRESH &&
                                                                                    cj0array[0] <=
                                                                                        1 + IKFAST_SINCOS_THRESH)
                                                                                {
                                                                                  j0valid[0] = j0valid[1] = true;
                                                                                  j0array[0] = IKacos(cj0array[0]);
                                                                                  sj0array[0] = IKsin(j0array[0]);
                                                                                  cj0array[1] = cj0array[0];
                                                                                  j0array[1] = -j0array[0];
                                                                                  sj0array[1] = -sj0array[0];
                                                                                }
                                                                                else if (isnan(cj0array[0]))
                                                                                {
                                                                                  // probably any value will work
                                                                                  j0valid[0] = true;
                                                                                  cj0array[0] = 1;
                                                                                  sj0array[0] = 0;
                                                                                  j0array[0] = 0;
                                                                                }
                                                                                for (int ij0 = 0; ij0 < 2; ++ij0)
                                                                                {
                                                                                  if (!j0valid[ij0])
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  _ij0[0] = ij0;
                                                                                  _ij0[1] = -1;
                                                                                  for (int iij0 = ij0 + 1; iij0 < 2;
                                                                                       ++iij0)
                                                                                  {
                                                                                    if (j0valid[iij0] &&
                                                                                        IKabs(cj0array[ij0] -
                                                                                              cj0array[iij0]) <
                                                                                            IKFAST_SOLUTION_THRESH &&
                                                                                        IKabs(sj0array[ij0] -
                                                                                              sj0array[iij0]) <
                                                                                            IKFAST_SOLUTION_THRESH)
                                                                                    {
                                                                                      j0valid[iij0] = false;
                                                                                      _ij0[1] = iij0;
                                                                                      break;
                                                                                    }
                                                                                  }
                                                                                  j0 = j0array[ij0];
                                                                                  cj0 = cj0array[ij0];
                                                                                  sj0 = sj0array[ij0];
                                                                                  {
                                                                                    IkReal evalcond[6];
                                                                                    IkReal x512 = IKsin(j0);
                                                                                    IkReal x513 = IKcos(j0);
                                                                                    IkReal x514 = (gconst7 * x513);
                                                                                    IkReal x515 = ((-1.0) * x512);
                                                                                    evalcond[0] = (new_r10 * x512);
                                                                                    evalcond[1] = (new_r01 * x515);
                                                                                    evalcond[2] = (gconst7 * x515);
                                                                                    evalcond[3] = (x514 + new_r10);
                                                                                    evalcond[4] =
                                                                                        (((new_r01 * x513)) + gconst7);
                                                                                    evalcond[5] = (x514 + new_r01);
                                                                                    if (IKabs(evalcond[0]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[1]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[2]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[3]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[4]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[5]) >
                                                                                            IKFAST_EVALCOND_THRESH)
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                  }

                                                                                  {
                                                                                    std::vector<IkSingleDOFSolutionBase<
                                                                                        IkReal> >
                                                                                        vinfos(7);
                                                                                    vinfos[0].jointtype = 1;
                                                                                    vinfos[0].foffset = j0;
                                                                                    vinfos[0].indices[0] = _ij0[0];
                                                                                    vinfos[0].indices[1] = _ij0[1];
                                                                                    vinfos[0].maxsolutions = _nj0;
                                                                                    vinfos[1].jointtype = 1;
                                                                                    vinfos[1].foffset = j1;
                                                                                    vinfos[1].indices[0] = _ij1[0];
                                                                                    vinfos[1].indices[1] = _ij1[1];
                                                                                    vinfos[1].maxsolutions = _nj1;
                                                                                    vinfos[2].jointtype = 1;
                                                                                    vinfos[2].foffset = j2;
                                                                                    vinfos[2].indices[0] = _ij2[0];
                                                                                    vinfos[2].indices[1] = _ij2[1];
                                                                                    vinfos[2].maxsolutions = _nj2;
                                                                                    vinfos[3].jointtype = 1;
                                                                                    vinfos[3].foffset = j3;
                                                                                    vinfos[3].indices[0] = _ij3[0];
                                                                                    vinfos[3].indices[1] = _ij3[1];
                                                                                    vinfos[3].maxsolutions = _nj3;
                                                                                    vinfos[4].jointtype = 1;
                                                                                    vinfos[4].foffset = j4;
                                                                                    vinfos[4].indices[0] = _ij4[0];
                                                                                    vinfos[4].indices[1] = _ij4[1];
                                                                                    vinfos[4].maxsolutions = _nj4;
                                                                                    vinfos[5].jointtype = 1;
                                                                                    vinfos[5].foffset = j5;
                                                                                    vinfos[5].indices[0] = _ij5[0];
                                                                                    vinfos[5].indices[1] = _ij5[1];
                                                                                    vinfos[5].maxsolutions = _nj5;
                                                                                    vinfos[6].jointtype = 1;
                                                                                    vinfos[6].foffset = j6;
                                                                                    vinfos[6].indices[0] = _ij6[0];
                                                                                    vinfos[6].indices[1] = _ij6[1];
                                                                                    vinfos[6].maxsolutions = _nj6;
                                                                                    std::vector<int> vfree(0);
                                                                                    solutions.AddSolution(vinfos,
                                                                                                          vfree);
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                      } while (0);
                                                                      if (bgotonextstatement)
                                                                      {
                                                                        bool bgotonextstatement = true;
                                                                        do
                                                                        {
                                                                          evalcond[0] =
                                                                              ((IKabs(new_r10)) + (IKabs(new_r00)));
                                                                          evalcond[1] = gconst7;
                                                                          evalcond[2] = gconst8;
                                                                          if (IKabs(evalcond[0]) < 0.0000050000000000 &&
                                                                              IKabs(evalcond[1]) < 0.0000050000000000 &&
                                                                              IKabs(evalcond[2]) < 0.0000050000000000)
                                                                          {
                                                                            bgotonextstatement = false;
                                                                            {
                                                                              IkReal j0eval[3];
                                                                              CheckValue<IkReal> x517 =
                                                                                  IKatan2WithCheck(
                                                                                      IkReal(new_r01),
                                                                                      IkReal(new_r11),
                                                                                      IKFAST_ATAN2_MAGTHRESH);
                                                                              if (!x517.valid)
                                                                              {
                                                                                continue;
                                                                              }
                                                                              IkReal x516 = ((-1.0) * (x517.value));
                                                                              sj1 = 0;
                                                                              cj1 = -1.0;
                                                                              j1 = 3.14159265358979;
                                                                              sj2 = gconst7;
                                                                              cj2 = gconst8;
                                                                              j2 = x516;
                                                                              new_r00 = 0;
                                                                              new_r10 = 0;
                                                                              new_r21 = 0;
                                                                              new_r22 = 0;
                                                                              IkReal gconst6 = x516;
                                                                              IkReal gconst7 = ((-1.0) * new_r01);
                                                                              IkReal gconst8 = new_r11;
                                                                              j0eval[0] = -1.0;
                                                                              j0eval[1] =
                                                                                  ((IKabs((new_r01 * new_r11))) +
                                                                                   (IKabs(((1.0) +
                                                                                           (((-1.0) *
                                                                                             (new_r01 * new_r01)))))));
                                                                              j0eval[2] = -1.0;
                                                                              if (IKabs(j0eval[0]) <
                                                                                      0.0000010000000000 ||
                                                                                  IKabs(j0eval[1]) <
                                                                                      0.0000010000000000 ||
                                                                                  IKabs(j0eval[2]) < 0.0000010000000000)
                                                                              {
                                                                                {
                                                                                  IkReal j0eval[3];
                                                                                  CheckValue<IkReal> x519 =
                                                                                      IKatan2WithCheck(
                                                                                          IkReal(new_r01),
                                                                                          IkReal(new_r11),
                                                                                          IKFAST_ATAN2_MAGTHRESH);
                                                                                  if (!x519.valid)
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  IkReal x518 = ((-1.0) * (x519.value));
                                                                                  sj1 = 0;
                                                                                  cj1 = -1.0;
                                                                                  j1 = 3.14159265358979;
                                                                                  sj2 = gconst7;
                                                                                  cj2 = gconst8;
                                                                                  j2 = x518;
                                                                                  new_r00 = 0;
                                                                                  new_r10 = 0;
                                                                                  new_r21 = 0;
                                                                                  new_r22 = 0;
                                                                                  IkReal gconst6 = x518;
                                                                                  IkReal gconst7 = ((-1.0) * new_r01);
                                                                                  IkReal gconst8 = new_r11;
                                                                                  j0eval[0] = -1.0;
                                                                                  j0eval[1] =
                                                                                      ((IKabs((new_r01 * new_r11))) +
                                                                                       (IKabs(
                                                                                           ((1.0) +
                                                                                            (((-1.0) *
                                                                                              (new_r01 * new_r01)))))));
                                                                                  j0eval[2] = -1.0;
                                                                                  if (IKabs(j0eval[0]) <
                                                                                          0.0000010000000000 ||
                                                                                      IKabs(j0eval[1]) <
                                                                                          0.0000010000000000 ||
                                                                                      IKabs(j0eval[2]) <
                                                                                          0.0000010000000000)
                                                                                  {
                                                                                    {
                                                                                      IkReal j0eval[3];
                                                                                      CheckValue<IkReal> x521 =
                                                                                          IKatan2WithCheck(
                                                                                              IkReal(new_r01),
                                                                                              IkReal(new_r11),
                                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                                      if (!x521.valid)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      IkReal x520 =
                                                                                          ((-1.0) * (x521.value));
                                                                                      sj1 = 0;
                                                                                      cj1 = -1.0;
                                                                                      j1 = 3.14159265358979;
                                                                                      sj2 = gconst7;
                                                                                      cj2 = gconst8;
                                                                                      j2 = x520;
                                                                                      new_r00 = 0;
                                                                                      new_r10 = 0;
                                                                                      new_r21 = 0;
                                                                                      new_r22 = 0;
                                                                                      IkReal gconst6 = x520;
                                                                                      IkReal gconst7 =
                                                                                          ((-1.0) * new_r01);
                                                                                      IkReal gconst8 = new_r11;
                                                                                      j0eval[0] = 1.0;
                                                                                      j0eval[1] =
                                                                                          ((((0.5) *
                                                                                             (IKabs(
                                                                                                 ((-1.0) +
                                                                                                  (((2.0) *
                                                                                                    (new_r01 *
                                                                                                     new_r01)))))))) +
                                                                                           (IKabs(
                                                                                               (new_r01 * new_r11))));
                                                                                      j0eval[2] = 1.0;
                                                                                      if (IKabs(j0eval[0]) <
                                                                                              0.0000010000000000 ||
                                                                                          IKabs(j0eval[1]) <
                                                                                              0.0000010000000000 ||
                                                                                          IKabs(j0eval[2]) <
                                                                                              0.0000010000000000)
                                                                                      {
                                                                                        continue;  // 3 cases reached
                                                                                      }
                                                                                      else
                                                                                      {
                                                                                        {
                                                                                          IkReal j0array[1],
                                                                                              cj0array[1], sj0array[1];
                                                                                          bool j0valid[1] = { false };
                                                                                          _nj0 = 1;
                                                                                          IkReal x522 =
                                                                                              ((1.0) * new_r11);
                                                                                          CheckValue<IkReal> x523 =
                                                                                              IKatan2WithCheck(
                                                                                                  IkReal((((gconst8 *
                                                                                                            new_r01)) +
                                                                                                          (((-1.0) *
                                                                                                            gconst7 *
                                                                                                            x522)))),
                                                                                                  IkReal(((((-1.0) *
                                                                                                            gconst8 *
                                                                                                            x522)) +
                                                                                                          (((-1.0) *
                                                                                                            gconst7 *
                                                                                                            new_r01)))),
                                                                                                  IKFAST_ATAN2_MAGTHRESH);
                                                                                          if (!x523.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          CheckValue<IkReal> x524 =
                                                                                              IKPowWithIntegerCheck(
                                                                                                  IKsign(((new_r01 *
                                                                                                           new_r01) +
                                                                                                          (new_r11 *
                                                                                                           new_r11))),
                                                                                                  -1);
                                                                                          if (!x524.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          j0array[0] =
                                                                                              ((-1.5707963267949) +
                                                                                               (x523.value) +
                                                                                               (((1.5707963267949) *
                                                                                                 (x524.value))));
                                                                                          sj0array[0] =
                                                                                              IKsin(j0array[0]);
                                                                                          cj0array[0] =
                                                                                              IKcos(j0array[0]);
                                                                                          if (j0array[0] > IKPI)
                                                                                          {
                                                                                            j0array[0] -= IK2PI;
                                                                                          }
                                                                                          else if (j0array[0] < -IKPI)
                                                                                          {
                                                                                            j0array[0] += IK2PI;
                                                                                          }
                                                                                          j0valid[0] = true;
                                                                                          for (int ij0 = 0; ij0 < 1;
                                                                                               ++ij0)
                                                                                          {
                                                                                            if (!j0valid[ij0])
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            _ij0[0] = ij0;
                                                                                            _ij0[1] = -1;
                                                                                            for (int iij0 = ij0 + 1;
                                                                                                 iij0 < 1;
                                                                                                 ++iij0)
                                                                                            {
                                                                                              if (j0valid[iij0] &&
                                                                                                  IKabs(
                                                                                                      cj0array[ij0] -
                                                                                                      cj0array[iij0]) <
                                                                                                      IKFAST_SOLUTION_THRESH &&
                                                                                                  IKabs(
                                                                                                      sj0array[ij0] -
                                                                                                      sj0array[iij0]) <
                                                                                                      IKFAST_SOLUTION_THRESH)
                                                                                              {
                                                                                                j0valid[iij0] = false;
                                                                                                _ij0[1] = iij0;
                                                                                                break;
                                                                                              }
                                                                                            }
                                                                                            j0 = j0array[ij0];
                                                                                            cj0 = cj0array[ij0];
                                                                                            sj0 = sj0array[ij0];
                                                                                            {
                                                                                              IkReal evalcond[6];
                                                                                              IkReal x525 = IKsin(j0);
                                                                                              IkReal x526 = IKcos(j0);
                                                                                              IkReal x527 =
                                                                                                  (gconst7 * x526);
                                                                                              IkReal x528 =
                                                                                                  ((1.0) * x525);
                                                                                              IkReal x529 =
                                                                                                  (gconst8 * x526);
                                                                                              IkReal x530 =
                                                                                                  (gconst8 * x528);
                                                                                              evalcond[0] =
                                                                                                  ((((-1.0) * x530)) +
                                                                                                   x527);
                                                                                              evalcond[1] =
                                                                                                  (((new_r01 * x526)) +
                                                                                                   gconst7 +
                                                                                                   ((new_r11 * x525)));
                                                                                              evalcond[2] =
                                                                                                  (((gconst7 * x525)) +
                                                                                                   x529 + new_r11);
                                                                                              evalcond[3] =
                                                                                                  (gconst8 +
                                                                                                   ((new_r11 * x526)) +
                                                                                                   (((-1.0) * new_r01 *
                                                                                                     x528)));
                                                                                              evalcond[4] =
                                                                                                  ((((-1.0) * x529)) +
                                                                                                   (((-1.0) * gconst7 *
                                                                                                     x528)));
                                                                                              evalcond[5] =
                                                                                                  ((((-1.0) * x530)) +
                                                                                                   x527 + new_r01);
                                                                                              if (IKabs(evalcond[0]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[1]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[2]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[3]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[4]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[5]) >
                                                                                                      IKFAST_EVALCOND_THRESH)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                            }

                                                                                            {
                                                                                              std::vector<
                                                                                                  IkSingleDOFSolutionBase<
                                                                                                      IkReal> >
                                                                                                  vinfos(7);
                                                                                              vinfos[0].jointtype = 1;
                                                                                              vinfos[0].foffset = j0;
                                                                                              vinfos[0].indices[0] =
                                                                                                  _ij0[0];
                                                                                              vinfos[0].indices[1] =
                                                                                                  _ij0[1];
                                                                                              vinfos[0].maxsolutions =
                                                                                                  _nj0;
                                                                                              vinfos[1].jointtype = 1;
                                                                                              vinfos[1].foffset = j1;
                                                                                              vinfos[1].indices[0] =
                                                                                                  _ij1[0];
                                                                                              vinfos[1].indices[1] =
                                                                                                  _ij1[1];
                                                                                              vinfos[1].maxsolutions =
                                                                                                  _nj1;
                                                                                              vinfos[2].jointtype = 1;
                                                                                              vinfos[2].foffset = j2;
                                                                                              vinfos[2].indices[0] =
                                                                                                  _ij2[0];
                                                                                              vinfos[2].indices[1] =
                                                                                                  _ij2[1];
                                                                                              vinfos[2].maxsolutions =
                                                                                                  _nj2;
                                                                                              vinfos[3].jointtype = 1;
                                                                                              vinfos[3].foffset = j3;
                                                                                              vinfos[3].indices[0] =
                                                                                                  _ij3[0];
                                                                                              vinfos[3].indices[1] =
                                                                                                  _ij3[1];
                                                                                              vinfos[3].maxsolutions =
                                                                                                  _nj3;
                                                                                              vinfos[4].jointtype = 1;
                                                                                              vinfos[4].foffset = j4;
                                                                                              vinfos[4].indices[0] =
                                                                                                  _ij4[0];
                                                                                              vinfos[4].indices[1] =
                                                                                                  _ij4[1];
                                                                                              vinfos[4].maxsolutions =
                                                                                                  _nj4;
                                                                                              vinfos[5].jointtype = 1;
                                                                                              vinfos[5].foffset = j5;
                                                                                              vinfos[5].indices[0] =
                                                                                                  _ij5[0];
                                                                                              vinfos[5].indices[1] =
                                                                                                  _ij5[1];
                                                                                              vinfos[5].maxsolutions =
                                                                                                  _nj5;
                                                                                              vinfos[6].jointtype = 1;
                                                                                              vinfos[6].foffset = j6;
                                                                                              vinfos[6].indices[0] =
                                                                                                  _ij6[0];
                                                                                              vinfos[6].indices[1] =
                                                                                                  _ij6[1];
                                                                                              vinfos[6].maxsolutions =
                                                                                                  _nj6;
                                                                                              std::vector<int> vfree(0);
                                                                                              solutions.AddSolution(
                                                                                                  vinfos, vfree);
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                  else
                                                                                  {
                                                                                    {
                                                                                      IkReal j0array[1], cj0array[1],
                                                                                          sj0array[1];
                                                                                      bool j0valid[1] = { false };
                                                                                      _nj0 = 1;
                                                                                      CheckValue<IkReal> x531 =
                                                                                          IKatan2WithCheck(
                                                                                              IkReal(
                                                                                                  (gconst7 * new_r11)),
                                                                                              IkReal(
                                                                                                  (gconst8 * new_r11)),
                                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                                      if (!x531.valid)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      CheckValue<IkReal> x532 =
                                                                                          IKPowWithIntegerCheck(
                                                                                              IKsign(((((-1.0) *
                                                                                                        (gconst8 *
                                                                                                         gconst8))) +
                                                                                                      (((-1.0) *
                                                                                                        (gconst7 *
                                                                                                         gconst7))))),
                                                                                              -1);
                                                                                      if (!x532.valid)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      j0array[0] =
                                                                                          ((-1.5707963267949) +
                                                                                           (x531.value) +
                                                                                           (((1.5707963267949) *
                                                                                             (x532.value))));
                                                                                      sj0array[0] = IKsin(j0array[0]);
                                                                                      cj0array[0] = IKcos(j0array[0]);
                                                                                      if (j0array[0] > IKPI)
                                                                                      {
                                                                                        j0array[0] -= IK2PI;
                                                                                      }
                                                                                      else if (j0array[0] < -IKPI)
                                                                                      {
                                                                                        j0array[0] += IK2PI;
                                                                                      }
                                                                                      j0valid[0] = true;
                                                                                      for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                                      {
                                                                                        if (!j0valid[ij0])
                                                                                        {
                                                                                          continue;
                                                                                        }
                                                                                        _ij0[0] = ij0;
                                                                                        _ij0[1] = -1;
                                                                                        for (int iij0 = ij0 + 1;
                                                                                             iij0 < 1;
                                                                                             ++iij0)
                                                                                        {
                                                                                          if (j0valid[iij0] &&
                                                                                              IKabs(cj0array[ij0] -
                                                                                                    cj0array[iij0]) <
                                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                                              IKabs(sj0array[ij0] -
                                                                                                    sj0array[iij0]) <
                                                                                                  IKFAST_SOLUTION_THRESH)
                                                                                          {
                                                                                            j0valid[iij0] = false;
                                                                                            _ij0[1] = iij0;
                                                                                            break;
                                                                                          }
                                                                                        }
                                                                                        j0 = j0array[ij0];
                                                                                        cj0 = cj0array[ij0];
                                                                                        sj0 = sj0array[ij0];
                                                                                        {
                                                                                          IkReal evalcond[6];
                                                                                          IkReal x533 = IKsin(j0);
                                                                                          IkReal x534 = IKcos(j0);
                                                                                          IkReal x535 =
                                                                                              (gconst7 * x534);
                                                                                          IkReal x536 = ((1.0) * x533);
                                                                                          IkReal x537 =
                                                                                              (gconst8 * x534);
                                                                                          IkReal x538 =
                                                                                              (gconst8 * x536);
                                                                                          evalcond[0] =
                                                                                              ((((-1.0) * x538)) +
                                                                                               x535);
                                                                                          evalcond[1] =
                                                                                              (((new_r01 * x534)) +
                                                                                               gconst7 +
                                                                                               ((new_r11 * x533)));
                                                                                          evalcond[2] =
                                                                                              (((gconst7 * x533)) +
                                                                                               x537 + new_r11);
                                                                                          evalcond[3] =
                                                                                              (gconst8 +
                                                                                               ((new_r11 * x534)) +
                                                                                               (((-1.0) * new_r01 *
                                                                                                 x536)));
                                                                                          evalcond[4] =
                                                                                              ((((-1.0) * x537)) +
                                                                                               (((-1.0) * gconst7 *
                                                                                                 x536)));
                                                                                          evalcond[5] =
                                                                                              ((((-1.0) * x538)) +
                                                                                               x535 + new_r01);
                                                                                          if (IKabs(evalcond[0]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[1]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[2]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[3]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[4]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[5]) >
                                                                                                  IKFAST_EVALCOND_THRESH)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                        }

                                                                                        {
                                                                                          std::vector<
                                                                                              IkSingleDOFSolutionBase<
                                                                                                  IkReal> >
                                                                                              vinfos(7);
                                                                                          vinfos[0].jointtype = 1;
                                                                                          vinfos[0].foffset = j0;
                                                                                          vinfos[0].indices[0] =
                                                                                              _ij0[0];
                                                                                          vinfos[0].indices[1] =
                                                                                              _ij0[1];
                                                                                          vinfos[0].maxsolutions = _nj0;
                                                                                          vinfos[1].jointtype = 1;
                                                                                          vinfos[1].foffset = j1;
                                                                                          vinfos[1].indices[0] =
                                                                                              _ij1[0];
                                                                                          vinfos[1].indices[1] =
                                                                                              _ij1[1];
                                                                                          vinfos[1].maxsolutions = _nj1;
                                                                                          vinfos[2].jointtype = 1;
                                                                                          vinfos[2].foffset = j2;
                                                                                          vinfos[2].indices[0] =
                                                                                              _ij2[0];
                                                                                          vinfos[2].indices[1] =
                                                                                              _ij2[1];
                                                                                          vinfos[2].maxsolutions = _nj2;
                                                                                          vinfos[3].jointtype = 1;
                                                                                          vinfos[3].foffset = j3;
                                                                                          vinfos[3].indices[0] =
                                                                                              _ij3[0];
                                                                                          vinfos[3].indices[1] =
                                                                                              _ij3[1];
                                                                                          vinfos[3].maxsolutions = _nj3;
                                                                                          vinfos[4].jointtype = 1;
                                                                                          vinfos[4].foffset = j4;
                                                                                          vinfos[4].indices[0] =
                                                                                              _ij4[0];
                                                                                          vinfos[4].indices[1] =
                                                                                              _ij4[1];
                                                                                          vinfos[4].maxsolutions = _nj4;
                                                                                          vinfos[5].jointtype = 1;
                                                                                          vinfos[5].foffset = j5;
                                                                                          vinfos[5].indices[0] =
                                                                                              _ij5[0];
                                                                                          vinfos[5].indices[1] =
                                                                                              _ij5[1];
                                                                                          vinfos[5].maxsolutions = _nj5;
                                                                                          vinfos[6].jointtype = 1;
                                                                                          vinfos[6].foffset = j6;
                                                                                          vinfos[6].indices[0] =
                                                                                              _ij6[0];
                                                                                          vinfos[6].indices[1] =
                                                                                              _ij6[1];
                                                                                          vinfos[6].maxsolutions = _nj6;
                                                                                          std::vector<int> vfree(0);
                                                                                          solutions.AddSolution(vinfos,
                                                                                                                vfree);
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                              else
                                                                              {
                                                                                {
                                                                                  IkReal j0array[1], cj0array[1],
                                                                                      sj0array[1];
                                                                                  bool j0valid[1] = { false };
                                                                                  _nj0 = 1;
                                                                                  CheckValue<IkReal> x539 =
                                                                                      IKatan2WithCheck(
                                                                                          IkReal((gconst7 * gconst8)),
                                                                                          IkReal(gconst8 * gconst8),
                                                                                          IKFAST_ATAN2_MAGTHRESH);
                                                                                  if (!x539.valid)
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  CheckValue<IkReal> x540 =
                                                                                      IKPowWithIntegerCheck(
                                                                                          IKsign(
                                                                                              ((((-1.0) * gconst8 *
                                                                                                 new_r11)) +
                                                                                               ((gconst7 * new_r01)))),
                                                                                          -1);
                                                                                  if (!x540.valid)
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  j0array[0] = ((-1.5707963267949) +
                                                                                                (x539.value) +
                                                                                                (((1.5707963267949) *
                                                                                                  (x540.value))));
                                                                                  sj0array[0] = IKsin(j0array[0]);
                                                                                  cj0array[0] = IKcos(j0array[0]);
                                                                                  if (j0array[0] > IKPI)
                                                                                  {
                                                                                    j0array[0] -= IK2PI;
                                                                                  }
                                                                                  else if (j0array[0] < -IKPI)
                                                                                  {
                                                                                    j0array[0] += IK2PI;
                                                                                  }
                                                                                  j0valid[0] = true;
                                                                                  for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                                  {
                                                                                    if (!j0valid[ij0])
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                    _ij0[0] = ij0;
                                                                                    _ij0[1] = -1;
                                                                                    for (int iij0 = ij0 + 1; iij0 < 1;
                                                                                         ++iij0)
                                                                                    {
                                                                                      if (j0valid[iij0] &&
                                                                                          IKabs(cj0array[ij0] -
                                                                                                cj0array[iij0]) <
                                                                                              IKFAST_SOLUTION_THRESH &&
                                                                                          IKabs(sj0array[ij0] -
                                                                                                sj0array[iij0]) <
                                                                                              IKFAST_SOLUTION_THRESH)
                                                                                      {
                                                                                        j0valid[iij0] = false;
                                                                                        _ij0[1] = iij0;
                                                                                        break;
                                                                                      }
                                                                                    }
                                                                                    j0 = j0array[ij0];
                                                                                    cj0 = cj0array[ij0];
                                                                                    sj0 = sj0array[ij0];
                                                                                    {
                                                                                      IkReal evalcond[6];
                                                                                      IkReal x541 = IKsin(j0);
                                                                                      IkReal x542 = IKcos(j0);
                                                                                      IkReal x543 = (gconst7 * x542);
                                                                                      IkReal x544 = ((1.0) * x541);
                                                                                      IkReal x545 = (gconst8 * x542);
                                                                                      IkReal x546 = (gconst8 * x544);
                                                                                      evalcond[0] =
                                                                                          ((((-1.0) * x546)) + x543);
                                                                                      evalcond[1] =
                                                                                          (gconst7 +
                                                                                           ((new_r11 * x541)) +
                                                                                           ((new_r01 * x542)));
                                                                                      evalcond[2] =
                                                                                          (x545 + ((gconst7 * x541)) +
                                                                                           new_r11);
                                                                                      evalcond[3] =
                                                                                          (gconst8 +
                                                                                           ((new_r11 * x542)) +
                                                                                           (((-1.0) * new_r01 * x544)));
                                                                                      evalcond[4] =
                                                                                          ((((-1.0) * x545)) +
                                                                                           (((-1.0) * gconst7 * x544)));
                                                                                      evalcond[5] = ((((-1.0) * x546)) +
                                                                                                     x543 + new_r01);
                                                                                      if (IKabs(evalcond[0]) >
                                                                                              IKFAST_EVALCOND_THRESH ||
                                                                                          IKabs(evalcond[1]) >
                                                                                              IKFAST_EVALCOND_THRESH ||
                                                                                          IKabs(evalcond[2]) >
                                                                                              IKFAST_EVALCOND_THRESH ||
                                                                                          IKabs(evalcond[3]) >
                                                                                              IKFAST_EVALCOND_THRESH ||
                                                                                          IKabs(evalcond[4]) >
                                                                                              IKFAST_EVALCOND_THRESH ||
                                                                                          IKabs(evalcond[5]) >
                                                                                              IKFAST_EVALCOND_THRESH)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                    }

                                                                                    {
                                                                                      std::vector<
                                                                                          IkSingleDOFSolutionBase<
                                                                                              IkReal> >
                                                                                          vinfos(7);
                                                                                      vinfos[0].jointtype = 1;
                                                                                      vinfos[0].foffset = j0;
                                                                                      vinfos[0].indices[0] = _ij0[0];
                                                                                      vinfos[0].indices[1] = _ij0[1];
                                                                                      vinfos[0].maxsolutions = _nj0;
                                                                                      vinfos[1].jointtype = 1;
                                                                                      vinfos[1].foffset = j1;
                                                                                      vinfos[1].indices[0] = _ij1[0];
                                                                                      vinfos[1].indices[1] = _ij1[1];
                                                                                      vinfos[1].maxsolutions = _nj1;
                                                                                      vinfos[2].jointtype = 1;
                                                                                      vinfos[2].foffset = j2;
                                                                                      vinfos[2].indices[0] = _ij2[0];
                                                                                      vinfos[2].indices[1] = _ij2[1];
                                                                                      vinfos[2].maxsolutions = _nj2;
                                                                                      vinfos[3].jointtype = 1;
                                                                                      vinfos[3].foffset = j3;
                                                                                      vinfos[3].indices[0] = _ij3[0];
                                                                                      vinfos[3].indices[1] = _ij3[1];
                                                                                      vinfos[3].maxsolutions = _nj3;
                                                                                      vinfos[4].jointtype = 1;
                                                                                      vinfos[4].foffset = j4;
                                                                                      vinfos[4].indices[0] = _ij4[0];
                                                                                      vinfos[4].indices[1] = _ij4[1];
                                                                                      vinfos[4].maxsolutions = _nj4;
                                                                                      vinfos[5].jointtype = 1;
                                                                                      vinfos[5].foffset = j5;
                                                                                      vinfos[5].indices[0] = _ij5[0];
                                                                                      vinfos[5].indices[1] = _ij5[1];
                                                                                      vinfos[5].maxsolutions = _nj5;
                                                                                      vinfos[6].jointtype = 1;
                                                                                      vinfos[6].foffset = j6;
                                                                                      vinfos[6].indices[0] = _ij6[0];
                                                                                      vinfos[6].indices[1] = _ij6[1];
                                                                                      vinfos[6].maxsolutions = _nj6;
                                                                                      std::vector<int> vfree(0);
                                                                                      solutions.AddSolution(vinfos,
                                                                                                            vfree);
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        } while (0);
                                                                        if (bgotonextstatement)
                                                                        {
                                                                          bool bgotonextstatement = true;
                                                                          do
                                                                          {
                                                                            evalcond[0] =
                                                                                ((IKabs(new_r10)) + (IKabs(new_r01)));
                                                                            if (IKabs(evalcond[0]) < 0.0000050000000000)
                                                                            {
                                                                              bgotonextstatement = false;
                                                                              {
                                                                                IkReal j0array[2], cj0array[2],
                                                                                    sj0array[2];
                                                                                bool j0valid[2] = { false };
                                                                                _nj0 = 2;
                                                                                CheckValue<IkReal> x547 =
                                                                                    IKPowWithIntegerCheck(gconst8, -1);
                                                                                if (!x547.valid)
                                                                                {
                                                                                  continue;
                                                                                }
                                                                                cj0array[0] = (new_r00 * (x547.value));
                                                                                if (cj0array[0] >=
                                                                                        -1 - IKFAST_SINCOS_THRESH &&
                                                                                    cj0array[0] <=
                                                                                        1 + IKFAST_SINCOS_THRESH)
                                                                                {
                                                                                  j0valid[0] = j0valid[1] = true;
                                                                                  j0array[0] = IKacos(cj0array[0]);
                                                                                  sj0array[0] = IKsin(j0array[0]);
                                                                                  cj0array[1] = cj0array[0];
                                                                                  j0array[1] = -j0array[0];
                                                                                  sj0array[1] = -sj0array[0];
                                                                                }
                                                                                else if (isnan(cj0array[0]))
                                                                                {
                                                                                  // probably any value will work
                                                                                  j0valid[0] = true;
                                                                                  cj0array[0] = 1;
                                                                                  sj0array[0] = 0;
                                                                                  j0array[0] = 0;
                                                                                }
                                                                                for (int ij0 = 0; ij0 < 2; ++ij0)
                                                                                {
                                                                                  if (!j0valid[ij0])
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  _ij0[0] = ij0;
                                                                                  _ij0[1] = -1;
                                                                                  for (int iij0 = ij0 + 1; iij0 < 2;
                                                                                       ++iij0)
                                                                                  {
                                                                                    if (j0valid[iij0] &&
                                                                                        IKabs(cj0array[ij0] -
                                                                                              cj0array[iij0]) <
                                                                                            IKFAST_SOLUTION_THRESH &&
                                                                                        IKabs(sj0array[ij0] -
                                                                                              sj0array[iij0]) <
                                                                                            IKFAST_SOLUTION_THRESH)
                                                                                    {
                                                                                      j0valid[iij0] = false;
                                                                                      _ij0[1] = iij0;
                                                                                      break;
                                                                                    }
                                                                                  }
                                                                                  j0 = j0array[ij0];
                                                                                  cj0 = cj0array[ij0];
                                                                                  sj0 = sj0array[ij0];
                                                                                  {
                                                                                    IkReal evalcond[6];
                                                                                    IkReal x548 = IKsin(j0);
                                                                                    IkReal x549 = IKcos(j0);
                                                                                    IkReal x550 = ((-1.0) * x548);
                                                                                    evalcond[0] = (new_r11 * x548);
                                                                                    evalcond[1] = (new_r00 * x550);
                                                                                    evalcond[2] = (gconst8 * x550);
                                                                                    evalcond[3] =
                                                                                        (gconst8 + ((new_r11 * x549)));
                                                                                    evalcond[4] =
                                                                                        (((gconst8 * x549)) + new_r11);
                                                                                    evalcond[5] =
                                                                                        (((new_r00 * x549)) +
                                                                                         (((-1.0) * gconst8)));
                                                                                    if (IKabs(evalcond[0]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[1]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[2]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[3]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[4]) >
                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                        IKabs(evalcond[5]) >
                                                                                            IKFAST_EVALCOND_THRESH)
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                  }

                                                                                  {
                                                                                    std::vector<IkSingleDOFSolutionBase<
                                                                                        IkReal> >
                                                                                        vinfos(7);
                                                                                    vinfos[0].jointtype = 1;
                                                                                    vinfos[0].foffset = j0;
                                                                                    vinfos[0].indices[0] = _ij0[0];
                                                                                    vinfos[0].indices[1] = _ij0[1];
                                                                                    vinfos[0].maxsolutions = _nj0;
                                                                                    vinfos[1].jointtype = 1;
                                                                                    vinfos[1].foffset = j1;
                                                                                    vinfos[1].indices[0] = _ij1[0];
                                                                                    vinfos[1].indices[1] = _ij1[1];
                                                                                    vinfos[1].maxsolutions = _nj1;
                                                                                    vinfos[2].jointtype = 1;
                                                                                    vinfos[2].foffset = j2;
                                                                                    vinfos[2].indices[0] = _ij2[0];
                                                                                    vinfos[2].indices[1] = _ij2[1];
                                                                                    vinfos[2].maxsolutions = _nj2;
                                                                                    vinfos[3].jointtype = 1;
                                                                                    vinfos[3].foffset = j3;
                                                                                    vinfos[3].indices[0] = _ij3[0];
                                                                                    vinfos[3].indices[1] = _ij3[1];
                                                                                    vinfos[3].maxsolutions = _nj3;
                                                                                    vinfos[4].jointtype = 1;
                                                                                    vinfos[4].foffset = j4;
                                                                                    vinfos[4].indices[0] = _ij4[0];
                                                                                    vinfos[4].indices[1] = _ij4[1];
                                                                                    vinfos[4].maxsolutions = _nj4;
                                                                                    vinfos[5].jointtype = 1;
                                                                                    vinfos[5].foffset = j5;
                                                                                    vinfos[5].indices[0] = _ij5[0];
                                                                                    vinfos[5].indices[1] = _ij5[1];
                                                                                    vinfos[5].maxsolutions = _nj5;
                                                                                    vinfos[6].jointtype = 1;
                                                                                    vinfos[6].foffset = j6;
                                                                                    vinfos[6].indices[0] = _ij6[0];
                                                                                    vinfos[6].indices[1] = _ij6[1];
                                                                                    vinfos[6].maxsolutions = _nj6;
                                                                                    std::vector<int> vfree(0);
                                                                                    solutions.AddSolution(vinfos,
                                                                                                          vfree);
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          } while (0);
                                                                          if (bgotonextstatement)
                                                                          {
                                                                            bool bgotonextstatement = true;
                                                                            do
                                                                            {
                                                                              evalcond[0] =
                                                                                  ((IKabs(new_r00)) + (IKabs(new_r01)));
                                                                              if (IKabs(evalcond[0]) <
                                                                                  0.0000050000000000)
                                                                              {
                                                                                bgotonextstatement = false;
                                                                                {
                                                                                  IkReal j0eval[1];
                                                                                  CheckValue<IkReal> x552 =
                                                                                      IKatan2WithCheck(
                                                                                          IkReal(0),
                                                                                          IkReal(new_r11),
                                                                                          IKFAST_ATAN2_MAGTHRESH);
                                                                                  if (!x552.valid)
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  IkReal x551 = ((-1.0) * (x552.value));
                                                                                  sj1 = 0;
                                                                                  cj1 = -1.0;
                                                                                  j1 = 3.14159265358979;
                                                                                  sj2 = gconst7;
                                                                                  cj2 = gconst8;
                                                                                  j2 = x551;
                                                                                  new_r00 = 0;
                                                                                  new_r01 = 0;
                                                                                  new_r12 = 0;
                                                                                  new_r22 = 0;
                                                                                  IkReal gconst6 = x551;
                                                                                  IkReal gconst7 = 0;
                                                                                  IkReal x553 =
                                                                                      ((1.0) + (((-1.0) *
                                                                                                 (new_r10 * new_r10))));
                                                                                  if (IKabs(x553) == 0)
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  IkReal gconst8 =
                                                                                      (new_r11 * (pow(x553, -0.5)));
                                                                                  j0eval[0] = ((IKabs(new_r11)) +
                                                                                               (IKabs(new_r10)));
                                                                                  if (IKabs(j0eval[0]) <
                                                                                      0.0000010000000000)
                                                                                  {
                                                                                    {
                                                                                      IkReal j0eval[1];
                                                                                      CheckValue<IkReal> x555 =
                                                                                          IKatan2WithCheck(
                                                                                              IkReal(0),
                                                                                              IkReal(new_r11),
                                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                                      if (!x555.valid)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      IkReal x554 =
                                                                                          ((-1.0) * (x555.value));
                                                                                      sj1 = 0;
                                                                                      cj1 = -1.0;
                                                                                      j1 = 3.14159265358979;
                                                                                      sj2 = gconst7;
                                                                                      cj2 = gconst8;
                                                                                      j2 = x554;
                                                                                      new_r00 = 0;
                                                                                      new_r01 = 0;
                                                                                      new_r12 = 0;
                                                                                      new_r22 = 0;
                                                                                      IkReal gconst6 = x554;
                                                                                      IkReal gconst7 = 0;
                                                                                      IkReal x556 =
                                                                                          ((1.0) +
                                                                                           (((-1.0) *
                                                                                             (new_r10 * new_r10))));
                                                                                      if (IKabs(x556) == 0)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      IkReal gconst8 =
                                                                                          (new_r11 * (pow(x556, -0.5)));
                                                                                      j0eval[0] = new_r11;
                                                                                      if (IKabs(j0eval[0]) <
                                                                                          0.0000010000000000)
                                                                                      {
                                                                                        {
                                                                                          IkReal j0eval[2];
                                                                                          CheckValue<IkReal> x558 =
                                                                                              IKatan2WithCheck(
                                                                                                  IkReal(0),
                                                                                                  IkReal(new_r11),
                                                                                                  IKFAST_ATAN2_MAGTHRESH);
                                                                                          if (!x558.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          IkReal x557 =
                                                                                              ((-1.0) * (x558.value));
                                                                                          sj1 = 0;
                                                                                          cj1 = -1.0;
                                                                                          j1 = 3.14159265358979;
                                                                                          sj2 = gconst7;
                                                                                          cj2 = gconst8;
                                                                                          j2 = x557;
                                                                                          new_r00 = 0;
                                                                                          new_r01 = 0;
                                                                                          new_r12 = 0;
                                                                                          new_r22 = 0;
                                                                                          IkReal gconst6 = x557;
                                                                                          IkReal gconst7 = 0;
                                                                                          IkReal x559 =
                                                                                              ((1.0) +
                                                                                               (((-1.0) *
                                                                                                 (new_r10 * new_r10))));
                                                                                          if (IKabs(x559) == 0)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          IkReal gconst8 =
                                                                                              (new_r11 *
                                                                                               (pow(x559, -0.5)));
                                                                                          j0eval[0] = new_r10;
                                                                                          j0eval[1] = new_r11;
                                                                                          if (IKabs(j0eval[0]) <
                                                                                                  0.0000010000000000 ||
                                                                                              IKabs(j0eval[1]) <
                                                                                                  0.0000010000000000)
                                                                                          {
                                                                                            continue;  // 3 cases
                                                                                                       // reached
                                                                                          }
                                                                                          else
                                                                                          {
                                                                                            {
                                                                                              IkReal j0array[1],
                                                                                                  cj0array[1],
                                                                                                  sj0array[1];
                                                                                              bool j0valid[1] = {
                                                                                                false
                                                                                              };
                                                                                              _nj0 = 1;
                                                                                              CheckValue<IkReal> x560 =
                                                                                                  IKPowWithIntegerCheck(
                                                                                                      new_r10, -1);
                                                                                              if (!x560.valid)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                              CheckValue<IkReal> x561 =
                                                                                                  IKPowWithIntegerCheck(
                                                                                                      new_r11, -1);
                                                                                              if (!x561.valid)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                              if (IKabs(
                                                                                                      (gconst8 *
                                                                                                       (x560.value))) <
                                                                                                      IKFAST_ATAN2_MAGTHRESH &&
                                                                                                  IKabs((
                                                                                                      (-1.0) * gconst8 *
                                                                                                      (x561.value))) <
                                                                                                      IKFAST_ATAN2_MAGTHRESH &&
                                                                                                  IKabs(
                                                                                                      IKsqr((
                                                                                                          gconst8 *
                                                                                                          (x560.value))) +
                                                                                                      IKsqr((
                                                                                                          (-1.0) *
                                                                                                          gconst8 *
                                                                                                          (x561.value))) -
                                                                                                      1) <=
                                                                                                      IKFAST_SINCOS_THRESH)
                                                                                                continue;
                                                                                              j0array[0] = IKatan2(
                                                                                                  (gconst8 *
                                                                                                   (x560.value)),
                                                                                                  ((-1.0) * gconst8 *
                                                                                                   (x561.value)));
                                                                                              sj0array[0] =
                                                                                                  IKsin(j0array[0]);
                                                                                              cj0array[0] =
                                                                                                  IKcos(j0array[0]);
                                                                                              if (j0array[0] > IKPI)
                                                                                              {
                                                                                                j0array[0] -= IK2PI;
                                                                                              }
                                                                                              else if (j0array[0] <
                                                                                                       -IKPI)
                                                                                              {
                                                                                                j0array[0] += IK2PI;
                                                                                              }
                                                                                              j0valid[0] = true;
                                                                                              for (int ij0 = 0; ij0 < 1;
                                                                                                   ++ij0)
                                                                                              {
                                                                                                if (!j0valid[ij0])
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                                _ij0[0] = ij0;
                                                                                                _ij0[1] = -1;
                                                                                                for (int iij0 = ij0 + 1;
                                                                                                     iij0 < 1;
                                                                                                     ++iij0)
                                                                                                {
                                                                                                  if (j0valid[iij0] &&
                                                                                                      IKabs(
                                                                                                          cj0array
                                                                                                              [ij0] -
                                                                                                          cj0array
                                                                                                              [iij0]) <
                                                                                                          IKFAST_SOLUTION_THRESH &&
                                                                                                      IKabs(
                                                                                                          sj0array
                                                                                                              [ij0] -
                                                                                                          sj0array
                                                                                                              [iij0]) <
                                                                                                          IKFAST_SOLUTION_THRESH)
                                                                                                  {
                                                                                                    j0valid[iij0] =
                                                                                                        false;
                                                                                                    _ij0[1] = iij0;
                                                                                                    break;
                                                                                                  }
                                                                                                }
                                                                                                j0 = j0array[ij0];
                                                                                                cj0 = cj0array[ij0];
                                                                                                sj0 = sj0array[ij0];
                                                                                                {
                                                                                                  IkReal evalcond[8];
                                                                                                  IkReal x562 =
                                                                                                      IKcos(j0);
                                                                                                  IkReal x563 =
                                                                                                      IKsin(j0);
                                                                                                  IkReal x564 =
                                                                                                      (gconst8 * x563);
                                                                                                  IkReal x565 =
                                                                                                      (gconst8 * x562);
                                                                                                  evalcond[0] =
                                                                                                      (new_r10 * x562);
                                                                                                  evalcond[1] =
                                                                                                      (new_r11 * x563);
                                                                                                  evalcond[2] =
                                                                                                      ((-1.0) * x565);
                                                                                                  evalcond[3] =
                                                                                                      ((-1.0) * x564);
                                                                                                  evalcond[4] =
                                                                                                      (gconst8 +
                                                                                                       ((new_r11 *
                                                                                                         x562)));
                                                                                                  evalcond[5] =
                                                                                                      (x565 + new_r11);
                                                                                                  evalcond[6] =
                                                                                                      ((((-1.0) *
                                                                                                         x564)) +
                                                                                                       new_r10);
                                                                                                  evalcond[7] =
                                                                                                      ((((-1.0) *
                                                                                                         gconst8)) +
                                                                                                       ((new_r10 *
                                                                                                         x563)));
                                                                                                  if (IKabs(
                                                                                                          evalcond[0]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[1]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[2]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[3]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[4]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[5]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[6]) >
                                                                                                          IKFAST_EVALCOND_THRESH ||
                                                                                                      IKabs(
                                                                                                          evalcond[7]) >
                                                                                                          IKFAST_EVALCOND_THRESH)
                                                                                                  {
                                                                                                    continue;
                                                                                                  }
                                                                                                }

                                                                                                {
                                                                                                  std::vector<
                                                                                                      IkSingleDOFSolutionBase<
                                                                                                          IkReal> >
                                                                                                      vinfos(7);
                                                                                                  vinfos[0].jointtype =
                                                                                                      1;
                                                                                                  vinfos[0].foffset =
                                                                                                      j0;
                                                                                                  vinfos[0].indices[0] =
                                                                                                      _ij0[0];
                                                                                                  vinfos[0].indices[1] =
                                                                                                      _ij0[1];
                                                                                                  vinfos[0]
                                                                                                      .maxsolutions =
                                                                                                      _nj0;
                                                                                                  vinfos[1].jointtype =
                                                                                                      1;
                                                                                                  vinfos[1].foffset =
                                                                                                      j1;
                                                                                                  vinfos[1].indices[0] =
                                                                                                      _ij1[0];
                                                                                                  vinfos[1].indices[1] =
                                                                                                      _ij1[1];
                                                                                                  vinfos[1]
                                                                                                      .maxsolutions =
                                                                                                      _nj1;
                                                                                                  vinfos[2].jointtype =
                                                                                                      1;
                                                                                                  vinfos[2].foffset =
                                                                                                      j2;
                                                                                                  vinfos[2].indices[0] =
                                                                                                      _ij2[0];
                                                                                                  vinfos[2].indices[1] =
                                                                                                      _ij2[1];
                                                                                                  vinfos[2]
                                                                                                      .maxsolutions =
                                                                                                      _nj2;
                                                                                                  vinfos[3].jointtype =
                                                                                                      1;
                                                                                                  vinfos[3].foffset =
                                                                                                      j3;
                                                                                                  vinfos[3].indices[0] =
                                                                                                      _ij3[0];
                                                                                                  vinfos[3].indices[1] =
                                                                                                      _ij3[1];
                                                                                                  vinfos[3]
                                                                                                      .maxsolutions =
                                                                                                      _nj3;
                                                                                                  vinfos[4].jointtype =
                                                                                                      1;
                                                                                                  vinfos[4].foffset =
                                                                                                      j4;
                                                                                                  vinfos[4].indices[0] =
                                                                                                      _ij4[0];
                                                                                                  vinfos[4].indices[1] =
                                                                                                      _ij4[1];
                                                                                                  vinfos[4]
                                                                                                      .maxsolutions =
                                                                                                      _nj4;
                                                                                                  vinfos[5].jointtype =
                                                                                                      1;
                                                                                                  vinfos[5].foffset =
                                                                                                      j5;
                                                                                                  vinfos[5].indices[0] =
                                                                                                      _ij5[0];
                                                                                                  vinfos[5].indices[1] =
                                                                                                      _ij5[1];
                                                                                                  vinfos[5]
                                                                                                      .maxsolutions =
                                                                                                      _nj5;
                                                                                                  vinfos[6].jointtype =
                                                                                                      1;
                                                                                                  vinfos[6].foffset =
                                                                                                      j6;
                                                                                                  vinfos[6].indices[0] =
                                                                                                      _ij6[0];
                                                                                                  vinfos[6].indices[1] =
                                                                                                      _ij6[1];
                                                                                                  vinfos[6]
                                                                                                      .maxsolutions =
                                                                                                      _nj6;
                                                                                                  std::vector<int>
                                                                                                      vfree(0);
                                                                                                  solutions.AddSolution(
                                                                                                      vinfos, vfree);
                                                                                                }
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                      else
                                                                                      {
                                                                                        {
                                                                                          IkReal j0array[1],
                                                                                              cj0array[1], sj0array[1];
                                                                                          bool j0valid[1] = { false };
                                                                                          _nj0 = 1;
                                                                                          CheckValue<IkReal> x566 =
                                                                                              IKPowWithIntegerCheck(
                                                                                                  gconst8, -1);
                                                                                          if (!x566.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          CheckValue<IkReal> x567 =
                                                                                              IKPowWithIntegerCheck(
                                                                                                  new_r11, -1);
                                                                                          if (!x567.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          if (IKabs((new_r10 *
                                                                                                     (x566.value))) <
                                                                                                  IKFAST_ATAN2_MAGTHRESH &&
                                                                                              IKabs(((-1.0) * gconst8 *
                                                                                                     (x567.value))) <
                                                                                                  IKFAST_ATAN2_MAGTHRESH &&
                                                                                              IKabs(
                                                                                                  IKsqr(
                                                                                                      (new_r10 *
                                                                                                       (x566.value))) +
                                                                                                  IKsqr((
                                                                                                      (-1.0) * gconst8 *
                                                                                                      (x567.value))) -
                                                                                                  1) <=
                                                                                                  IKFAST_SINCOS_THRESH)
                                                                                            continue;
                                                                                          j0array[0] = IKatan2(
                                                                                              (new_r10 * (x566.value)),
                                                                                              ((-1.0) * gconst8 *
                                                                                               (x567.value)));
                                                                                          sj0array[0] =
                                                                                              IKsin(j0array[0]);
                                                                                          cj0array[0] =
                                                                                              IKcos(j0array[0]);
                                                                                          if (j0array[0] > IKPI)
                                                                                          {
                                                                                            j0array[0] -= IK2PI;
                                                                                          }
                                                                                          else if (j0array[0] < -IKPI)
                                                                                          {
                                                                                            j0array[0] += IK2PI;
                                                                                          }
                                                                                          j0valid[0] = true;
                                                                                          for (int ij0 = 0; ij0 < 1;
                                                                                               ++ij0)
                                                                                          {
                                                                                            if (!j0valid[ij0])
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            _ij0[0] = ij0;
                                                                                            _ij0[1] = -1;
                                                                                            for (int iij0 = ij0 + 1;
                                                                                                 iij0 < 1;
                                                                                                 ++iij0)
                                                                                            {
                                                                                              if (j0valid[iij0] &&
                                                                                                  IKabs(
                                                                                                      cj0array[ij0] -
                                                                                                      cj0array[iij0]) <
                                                                                                      IKFAST_SOLUTION_THRESH &&
                                                                                                  IKabs(
                                                                                                      sj0array[ij0] -
                                                                                                      sj0array[iij0]) <
                                                                                                      IKFAST_SOLUTION_THRESH)
                                                                                              {
                                                                                                j0valid[iij0] = false;
                                                                                                _ij0[1] = iij0;
                                                                                                break;
                                                                                              }
                                                                                            }
                                                                                            j0 = j0array[ij0];
                                                                                            cj0 = cj0array[ij0];
                                                                                            sj0 = sj0array[ij0];
                                                                                            {
                                                                                              IkReal evalcond[8];
                                                                                              IkReal x568 = IKcos(j0);
                                                                                              IkReal x569 = IKsin(j0);
                                                                                              IkReal x570 =
                                                                                                  (gconst8 * x569);
                                                                                              IkReal x571 =
                                                                                                  (gconst8 * x568);
                                                                                              evalcond[0] =
                                                                                                  (new_r10 * x568);
                                                                                              evalcond[1] =
                                                                                                  (new_r11 * x569);
                                                                                              evalcond[2] =
                                                                                                  ((-1.0) * x571);
                                                                                              evalcond[3] =
                                                                                                  ((-1.0) * x570);
                                                                                              evalcond[4] =
                                                                                                  (gconst8 +
                                                                                                   ((new_r11 * x568)));
                                                                                              evalcond[5] =
                                                                                                  (x571 + new_r11);
                                                                                              evalcond[6] =
                                                                                                  ((((-1.0) * x570)) +
                                                                                                   new_r10);
                                                                                              evalcond[7] =
                                                                                                  ((((-1.0) *
                                                                                                     gconst8)) +
                                                                                                   ((new_r10 * x569)));
                                                                                              if (IKabs(evalcond[0]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[1]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[2]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[3]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[4]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[5]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[6]) >
                                                                                                      IKFAST_EVALCOND_THRESH ||
                                                                                                  IKabs(evalcond[7]) >
                                                                                                      IKFAST_EVALCOND_THRESH)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                            }

                                                                                            {
                                                                                              std::vector<
                                                                                                  IkSingleDOFSolutionBase<
                                                                                                      IkReal> >
                                                                                                  vinfos(7);
                                                                                              vinfos[0].jointtype = 1;
                                                                                              vinfos[0].foffset = j0;
                                                                                              vinfos[0].indices[0] =
                                                                                                  _ij0[0];
                                                                                              vinfos[0].indices[1] =
                                                                                                  _ij0[1];
                                                                                              vinfos[0].maxsolutions =
                                                                                                  _nj0;
                                                                                              vinfos[1].jointtype = 1;
                                                                                              vinfos[1].foffset = j1;
                                                                                              vinfos[1].indices[0] =
                                                                                                  _ij1[0];
                                                                                              vinfos[1].indices[1] =
                                                                                                  _ij1[1];
                                                                                              vinfos[1].maxsolutions =
                                                                                                  _nj1;
                                                                                              vinfos[2].jointtype = 1;
                                                                                              vinfos[2].foffset = j2;
                                                                                              vinfos[2].indices[0] =
                                                                                                  _ij2[0];
                                                                                              vinfos[2].indices[1] =
                                                                                                  _ij2[1];
                                                                                              vinfos[2].maxsolutions =
                                                                                                  _nj2;
                                                                                              vinfos[3].jointtype = 1;
                                                                                              vinfos[3].foffset = j3;
                                                                                              vinfos[3].indices[0] =
                                                                                                  _ij3[0];
                                                                                              vinfos[3].indices[1] =
                                                                                                  _ij3[1];
                                                                                              vinfos[3].maxsolutions =
                                                                                                  _nj3;
                                                                                              vinfos[4].jointtype = 1;
                                                                                              vinfos[4].foffset = j4;
                                                                                              vinfos[4].indices[0] =
                                                                                                  _ij4[0];
                                                                                              vinfos[4].indices[1] =
                                                                                                  _ij4[1];
                                                                                              vinfos[4].maxsolutions =
                                                                                                  _nj4;
                                                                                              vinfos[5].jointtype = 1;
                                                                                              vinfos[5].foffset = j5;
                                                                                              vinfos[5].indices[0] =
                                                                                                  _ij5[0];
                                                                                              vinfos[5].indices[1] =
                                                                                                  _ij5[1];
                                                                                              vinfos[5].maxsolutions =
                                                                                                  _nj5;
                                                                                              vinfos[6].jointtype = 1;
                                                                                              vinfos[6].foffset = j6;
                                                                                              vinfos[6].indices[0] =
                                                                                                  _ij6[0];
                                                                                              vinfos[6].indices[1] =
                                                                                                  _ij6[1];
                                                                                              vinfos[6].maxsolutions =
                                                                                                  _nj6;
                                                                                              std::vector<int> vfree(0);
                                                                                              solutions.AddSolution(
                                                                                                  vinfos, vfree);
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                  else
                                                                                  {
                                                                                    {
                                                                                      IkReal j0array[1], cj0array[1],
                                                                                          sj0array[1];
                                                                                      bool j0valid[1] = { false };
                                                                                      _nj0 = 1;
                                                                                      CheckValue<IkReal> x572 =
                                                                                          IKatan2WithCheck(
                                                                                              IkReal(new_r10),
                                                                                              IkReal(
                                                                                                  ((-1.0) * new_r11)),
                                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                                      if (!x572.valid)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      CheckValue<IkReal> x573 =
                                                                                          IKPowWithIntegerCheck(
                                                                                              IKsign(gconst8), -1);
                                                                                      if (!x573.valid)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      j0array[0] =
                                                                                          ((-1.5707963267949) +
                                                                                           (x572.value) +
                                                                                           (((1.5707963267949) *
                                                                                             (x573.value))));
                                                                                      sj0array[0] = IKsin(j0array[0]);
                                                                                      cj0array[0] = IKcos(j0array[0]);
                                                                                      if (j0array[0] > IKPI)
                                                                                      {
                                                                                        j0array[0] -= IK2PI;
                                                                                      }
                                                                                      else if (j0array[0] < -IKPI)
                                                                                      {
                                                                                        j0array[0] += IK2PI;
                                                                                      }
                                                                                      j0valid[0] = true;
                                                                                      for (int ij0 = 0; ij0 < 1; ++ij0)
                                                                                      {
                                                                                        if (!j0valid[ij0])
                                                                                        {
                                                                                          continue;
                                                                                        }
                                                                                        _ij0[0] = ij0;
                                                                                        _ij0[1] = -1;
                                                                                        for (int iij0 = ij0 + 1;
                                                                                             iij0 < 1;
                                                                                             ++iij0)
                                                                                        {
                                                                                          if (j0valid[iij0] &&
                                                                                              IKabs(cj0array[ij0] -
                                                                                                    cj0array[iij0]) <
                                                                                                  IKFAST_SOLUTION_THRESH &&
                                                                                              IKabs(sj0array[ij0] -
                                                                                                    sj0array[iij0]) <
                                                                                                  IKFAST_SOLUTION_THRESH)
                                                                                          {
                                                                                            j0valid[iij0] = false;
                                                                                            _ij0[1] = iij0;
                                                                                            break;
                                                                                          }
                                                                                        }
                                                                                        j0 = j0array[ij0];
                                                                                        cj0 = cj0array[ij0];
                                                                                        sj0 = sj0array[ij0];
                                                                                        {
                                                                                          IkReal evalcond[8];
                                                                                          IkReal x574 = IKcos(j0);
                                                                                          IkReal x575 = IKsin(j0);
                                                                                          IkReal x576 =
                                                                                              (gconst8 * x575);
                                                                                          IkReal x577 =
                                                                                              (gconst8 * x574);
                                                                                          evalcond[0] =
                                                                                              (new_r10 * x574);
                                                                                          evalcond[1] =
                                                                                              (new_r11 * x575);
                                                                                          evalcond[2] = ((-1.0) * x577);
                                                                                          evalcond[3] = ((-1.0) * x576);
                                                                                          evalcond[4] =
                                                                                              (((new_r11 * x574)) +
                                                                                               gconst8);
                                                                                          evalcond[5] =
                                                                                              (x577 + new_r11);
                                                                                          evalcond[6] =
                                                                                              ((((-1.0) * x576)) +
                                                                                               new_r10);
                                                                                          evalcond[7] =
                                                                                              (((new_r10 * x575)) +
                                                                                               (((-1.0) * gconst8)));
                                                                                          if (IKabs(evalcond[0]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[1]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[2]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[3]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[4]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[5]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[6]) >
                                                                                                  IKFAST_EVALCOND_THRESH ||
                                                                                              IKabs(evalcond[7]) >
                                                                                                  IKFAST_EVALCOND_THRESH)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                        }

                                                                                        {
                                                                                          std::vector<
                                                                                              IkSingleDOFSolutionBase<
                                                                                                  IkReal> >
                                                                                              vinfos(7);
                                                                                          vinfos[0].jointtype = 1;
                                                                                          vinfos[0].foffset = j0;
                                                                                          vinfos[0].indices[0] =
                                                                                              _ij0[0];
                                                                                          vinfos[0].indices[1] =
                                                                                              _ij0[1];
                                                                                          vinfos[0].maxsolutions = _nj0;
                                                                                          vinfos[1].jointtype = 1;
                                                                                          vinfos[1].foffset = j1;
                                                                                          vinfos[1].indices[0] =
                                                                                              _ij1[0];
                                                                                          vinfos[1].indices[1] =
                                                                                              _ij1[1];
                                                                                          vinfos[1].maxsolutions = _nj1;
                                                                                          vinfos[2].jointtype = 1;
                                                                                          vinfos[2].foffset = j2;
                                                                                          vinfos[2].indices[0] =
                                                                                              _ij2[0];
                                                                                          vinfos[2].indices[1] =
                                                                                              _ij2[1];
                                                                                          vinfos[2].maxsolutions = _nj2;
                                                                                          vinfos[3].jointtype = 1;
                                                                                          vinfos[3].foffset = j3;
                                                                                          vinfos[3].indices[0] =
                                                                                              _ij3[0];
                                                                                          vinfos[3].indices[1] =
                                                                                              _ij3[1];
                                                                                          vinfos[3].maxsolutions = _nj3;
                                                                                          vinfos[4].jointtype = 1;
                                                                                          vinfos[4].foffset = j4;
                                                                                          vinfos[4].indices[0] =
                                                                                              _ij4[0];
                                                                                          vinfos[4].indices[1] =
                                                                                              _ij4[1];
                                                                                          vinfos[4].maxsolutions = _nj4;
                                                                                          vinfos[5].jointtype = 1;
                                                                                          vinfos[5].foffset = j5;
                                                                                          vinfos[5].indices[0] =
                                                                                              _ij5[0];
                                                                                          vinfos[5].indices[1] =
                                                                                              _ij5[1];
                                                                                          vinfos[5].maxsolutions = _nj5;
                                                                                          vinfos[6].jointtype = 1;
                                                                                          vinfos[6].foffset = j6;
                                                                                          vinfos[6].indices[0] =
                                                                                              _ij6[0];
                                                                                          vinfos[6].indices[1] =
                                                                                              _ij6[1];
                                                                                          vinfos[6].maxsolutions = _nj6;
                                                                                          std::vector<int> vfree(0);
                                                                                          solutions.AddSolution(vinfos,
                                                                                                                vfree);
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            } while (0);
                                                                            if (bgotonextstatement)
                                                                            {
                                                                              bool bgotonextstatement = true;
                                                                              do
                                                                              {
                                                                                evalcond[0] = IKabs(new_r01);
                                                                                if (IKabs(evalcond[0]) <
                                                                                    0.0000050000000000)
                                                                                {
                                                                                  bgotonextstatement = false;
                                                                                  {
                                                                                    IkReal j0eval[1];
                                                                                    CheckValue<IkReal> x579 =
                                                                                        IKatan2WithCheck(
                                                                                            IkReal(0),
                                                                                            IkReal(new_r11),
                                                                                            IKFAST_ATAN2_MAGTHRESH);
                                                                                    if (!x579.valid)
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                    IkReal x578 =
                                                                                        ((-1.0) * (x579.value));
                                                                                    sj1 = 0;
                                                                                    cj1 = -1.0;
                                                                                    j1 = 3.14159265358979;
                                                                                    sj2 = gconst7;
                                                                                    cj2 = gconst8;
                                                                                    j2 = x578;
                                                                                    new_r01 = 0;
                                                                                    IkReal gconst6 = x578;
                                                                                    IkReal gconst7 = 0;
                                                                                    IkReal x580 = new_r11 * new_r11;
                                                                                    if (IKabs(x580) == 0)
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                    IkReal gconst8 =
                                                                                        (new_r11 * (pow(x580, -0.5)));
                                                                                    j0eval[0] = ((IKabs(new_r10)) +
                                                                                                 (IKabs(new_r00)));
                                                                                    if (IKabs(j0eval[0]) <
                                                                                        0.0000010000000000)
                                                                                    {
                                                                                      {
                                                                                        IkReal j0eval[1];
                                                                                        CheckValue<IkReal> x582 =
                                                                                            IKatan2WithCheck(
                                                                                                IkReal(0),
                                                                                                IkReal(new_r11),
                                                                                                IKFAST_ATAN2_MAGTHRESH);
                                                                                        if (!x582.valid)
                                                                                        {
                                                                                          continue;
                                                                                        }
                                                                                        IkReal x581 =
                                                                                            ((-1.0) * (x582.value));
                                                                                        sj1 = 0;
                                                                                        cj1 = -1.0;
                                                                                        j1 = 3.14159265358979;
                                                                                        sj2 = gconst7;
                                                                                        cj2 = gconst8;
                                                                                        j2 = x581;
                                                                                        new_r01 = 0;
                                                                                        IkReal gconst6 = x581;
                                                                                        IkReal gconst7 = 0;
                                                                                        IkReal x583 = new_r11 * new_r11;
                                                                                        if (IKabs(x583) == 0)
                                                                                        {
                                                                                          continue;
                                                                                        }
                                                                                        IkReal gconst8 =
                                                                                            (new_r11 *
                                                                                             (pow(x583, -0.5)));
                                                                                        j0eval[0] = ((IKabs(new_r11)) +
                                                                                                     (IKabs(new_r10)));
                                                                                        if (IKabs(j0eval[0]) <
                                                                                            0.0000010000000000)
                                                                                        {
                                                                                          {
                                                                                            IkReal j0eval[1];
                                                                                            CheckValue<IkReal> x585 =
                                                                                                IKatan2WithCheck(
                                                                                                    IkReal(0),
                                                                                                    IkReal(new_r11),
                                                                                                    IKFAST_ATAN2_MAGTHRESH);
                                                                                            if (!x585.valid)
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            IkReal x584 =
                                                                                                ((-1.0) * (x585.value));
                                                                                            sj1 = 0;
                                                                                            cj1 = -1.0;
                                                                                            j1 = 3.14159265358979;
                                                                                            sj2 = gconst7;
                                                                                            cj2 = gconst8;
                                                                                            j2 = x584;
                                                                                            new_r01 = 0;
                                                                                            IkReal gconst6 = x584;
                                                                                            IkReal gconst7 = 0;
                                                                                            IkReal x586 =
                                                                                                new_r11 * new_r11;
                                                                                            if (IKabs(x586) == 0)
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            IkReal gconst8 =
                                                                                                (new_r11 *
                                                                                                 (pow(x586, -0.5)));
                                                                                            j0eval[0] = new_r11;
                                                                                            if (IKabs(j0eval[0]) <
                                                                                                0.0000010000000000)
                                                                                            {
                                                                                              continue;  // 3 cases
                                                                                                         // reached
                                                                                            }
                                                                                            else
                                                                                            {
                                                                                              {
                                                                                                IkReal j0array[1],
                                                                                                    cj0array[1],
                                                                                                    sj0array[1];
                                                                                                bool j0valid[1] = {
                                                                                                  false
                                                                                                };
                                                                                                _nj0 = 1;
                                                                                                CheckValue<IkReal> x587 =
                                                                                                    IKPowWithIntegerCheck(
                                                                                                        gconst8, -1);
                                                                                                if (!x587.valid)
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                                CheckValue<IkReal> x588 =
                                                                                                    IKPowWithIntegerCheck(
                                                                                                        new_r11, -1);
                                                                                                if (!x588.valid)
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                                if (IKabs((
                                                                                                        new_r10 *
                                                                                                        (x587.value))) <
                                                                                                        IKFAST_ATAN2_MAGTHRESH &&
                                                                                                    IKabs((
                                                                                                        (-1.0) *
                                                                                                        gconst8 *
                                                                                                        (x588.value))) <
                                                                                                        IKFAST_ATAN2_MAGTHRESH &&
                                                                                                    IKabs(
                                                                                                        IKsqr((
                                                                                                            new_r10 *
                                                                                                            (x587.value))) +
                                                                                                        IKsqr((
                                                                                                            (-1.0) *
                                                                                                            gconst8 *
                                                                                                            (x588.value))) -
                                                                                                        1) <=
                                                                                                        IKFAST_SINCOS_THRESH)
                                                                                                  continue;
                                                                                                j0array[0] = IKatan2(
                                                                                                    (new_r10 *
                                                                                                     (x587.value)),
                                                                                                    ((-1.0) * gconst8 *
                                                                                                     (x588.value)));
                                                                                                sj0array[0] =
                                                                                                    IKsin(j0array[0]);
                                                                                                cj0array[0] =
                                                                                                    IKcos(j0array[0]);
                                                                                                if (j0array[0] > IKPI)
                                                                                                {
                                                                                                  j0array[0] -= IK2PI;
                                                                                                }
                                                                                                else if (j0array[0] <
                                                                                                         -IKPI)
                                                                                                {
                                                                                                  j0array[0] += IK2PI;
                                                                                                }
                                                                                                j0valid[0] = true;
                                                                                                for (int ij0 = 0;
                                                                                                     ij0 < 1;
                                                                                                     ++ij0)
                                                                                                {
                                                                                                  if (!j0valid[ij0])
                                                                                                  {
                                                                                                    continue;
                                                                                                  }
                                                                                                  _ij0[0] = ij0;
                                                                                                  _ij0[1] = -1;
                                                                                                  for (int iij0 =
                                                                                                           ij0 + 1;
                                                                                                       iij0 < 1;
                                                                                                       ++iij0)
                                                                                                  {
                                                                                                    if (j0valid[iij0] &&
                                                                                                        IKabs(
                                                                                                            cj0array
                                                                                                                [ij0] -
                                                                                                            cj0array
                                                                                                                [iij0]) <
                                                                                                            IKFAST_SOLUTION_THRESH &&
                                                                                                        IKabs(
                                                                                                            sj0array
                                                                                                                [ij0] -
                                                                                                            sj0array
                                                                                                                [iij0]) <
                                                                                                            IKFAST_SOLUTION_THRESH)
                                                                                                    {
                                                                                                      j0valid[iij0] =
                                                                                                          false;
                                                                                                      _ij0[1] = iij0;
                                                                                                      break;
                                                                                                    }
                                                                                                  }
                                                                                                  j0 = j0array[ij0];
                                                                                                  cj0 = cj0array[ij0];
                                                                                                  sj0 = sj0array[ij0];
                                                                                                  {
                                                                                                    IkReal evalcond[8];
                                                                                                    IkReal x589 =
                                                                                                        IKsin(j0);
                                                                                                    IkReal x590 =
                                                                                                        IKcos(j0);
                                                                                                    IkReal x591 =
                                                                                                        ((1.0) *
                                                                                                         gconst8);
                                                                                                    IkReal x592 =
                                                                                                        ((1.0) * x589);
                                                                                                    evalcond[0] =
                                                                                                        (new_r11 *
                                                                                                         x589);
                                                                                                    evalcond[1] =
                                                                                                        ((-1.0) *
                                                                                                         gconst8 *
                                                                                                         x589);
                                                                                                    evalcond[2] =
                                                                                                        (((new_r11 *
                                                                                                           x590)) +
                                                                                                         gconst8);
                                                                                                    evalcond[3] =
                                                                                                        (((gconst8 *
                                                                                                           x590)) +
                                                                                                         new_r11);
                                                                                                    evalcond[4] =
                                                                                                        ((((-1.0) *
                                                                                                           x589 *
                                                                                                           x591)) +
                                                                                                         new_r10);
                                                                                                    evalcond[5] =
                                                                                                        ((((-1.0) *
                                                                                                           x590 *
                                                                                                           x591)) +
                                                                                                         new_r00);
                                                                                                    evalcond[6] =
                                                                                                        ((((-1.0) *
                                                                                                           new_r00 *
                                                                                                           x592)) +
                                                                                                         ((new_r10 *
                                                                                                           x590)));
                                                                                                    evalcond[7] =
                                                                                                        (((new_r00 *
                                                                                                           x590)) +
                                                                                                         (((-1.0) *
                                                                                                           x591)) +
                                                                                                         ((new_r10 *
                                                                                                           x589)));
                                                                                                    if (IKabs(evalcond
                                                                                                                  [0]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [1]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [2]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [3]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [4]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [5]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [6]) >
                                                                                                            IKFAST_EVALCOND_THRESH ||
                                                                                                        IKabs(evalcond
                                                                                                                  [7]) >
                                                                                                            IKFAST_EVALCOND_THRESH)
                                                                                                    {
                                                                                                      continue;
                                                                                                    }
                                                                                                  }

                                                                                                  {
                                                                                                    std::vector<
                                                                                                        IkSingleDOFSolutionBase<
                                                                                                            IkReal> >
                                                                                                        vinfos(7);
                                                                                                    vinfos[0]
                                                                                                        .jointtype = 1;
                                                                                                    vinfos[0].foffset =
                                                                                                        j0;
                                                                                                    vinfos[0]
                                                                                                        .indices[0] =
                                                                                                        _ij0[0];
                                                                                                    vinfos[0]
                                                                                                        .indices[1] =
                                                                                                        _ij0[1];
                                                                                                    vinfos[0]
                                                                                                        .maxsolutions =
                                                                                                        _nj0;
                                                                                                    vinfos[1]
                                                                                                        .jointtype = 1;
                                                                                                    vinfos[1].foffset =
                                                         