# ECHO ONE Driver

## Initial Setup

### Installation of Device Driver

The repository [Toposens Library](https://gitlab.com/toposens/public/toposens-library) contains the toposens sensor library.

`toposens-library` is included as a git submodule under the toposens-echo-driver repository. During `catkin build` the library is built automatically.

### PCAN-USB FD Setup

In order for the target PC to be able to send and receive CAN frames the PCAN-USB FD adapter kernel modules must be installed and it is also recommended that can-utils is installed as this offers a suite of useful tools for troubleshooting on the CAN bus.
To install the kernel modules run the following commands:

```sh
sudo modprobe peak_usb
sudo modprobe peak_pci
```

To install `can-utils` run the following commands:

```sh
sudo apt-get update
sudo apt-get install can-utils
```

#### Manual CAN Interface Setup

To set up the CAN interface on a once-off basis you can connect the PCAN-USB FD adapter to the target PC and run the following command:

```sh
sudo ip link set can0 up type can bitrate 1000000
```

#### Automatic CAN Setup using /etc/network/interfaces

It is recommended that the network is configured so that the interface is set up automatically each time the target PC is turned on.
To do this, append the following code snippet to the end of the `/etc/network/interfaces` file:

```sh
allow-hotplug can0
iface can0 can static
    bitrate 1000000
    up ip link set $IFACE txqueuelen 100
```

#### Automatic CAN Setup using systemd

Alternatively, you can use systemd to enable automatic configuration of the CAN interface.
This is relevant for e.g. Ubuntu 20.04, as using `/etc/network/interfaces` is deprecated and does not work out of the box.
Navigate to `/etc/systemd/network/` and create a file `80-can.network` with the following content:

```sh
[Match]
Name=can*

[CAN]
BitRate=1000000
```

Then run the following commands to enable the automatic configuration via systemd:

```sh
sudo systemctl enable systemd-networkd
sudo systemctl start systemd-networkd
```

Note that in all of the above cases for setting up the CAN interface (except with using systemd), the name of the interface has been set to `can0`.
If a different name is chosen then wherever `can0` appears here, it must be replaced with the chosen interface name.
To verify that the interface has been set up, you can run the command `ip link show` which will display the network interfaces on the target PC.
If the set up of the interface is successful the output should then appear similar to:

![ip_link_show](img/ip_link_show.png)

At reboot the ECHO ONE sensor will send a ready message and a log message indicating the cause of the reset (eg. power on, software rest, etc.)
You can introspect these messages by running the command `candump can0`.

The first column of the output is the interface name, followed by the frame ID number, the number of data bytes in the frame and then the data bytes in Hexadecimal.

If this is not the case then it is first recommended to disconnect the PCAN-USB FD adapter, restart the power supply and reconnect the PCAN-USB FD adapter
(Note that when the power supply is restarted it is usually necessary to reconnect the PCAN-USB FD adapter).

## Usage

The plain ECHO ONE driver node can be started with:

```sh
roscore
rosrun toposens_echo_driver toposens_echo_driver_node
```

For running the node with `toposens_pointcloud`, RViz, `rqt_reconfigure` etc. use the following launch file:

```sh
roslaunch toposens_bringup echo_one.launch
```

By default toposens_echo_driver uses CAN communication interface.

For running the node with UART interface, an argument `com_interface` can be passed:

```sh
roslaunch toposens_bringup echo_one.launch com_interface:=UART
```

The emitted topics can then be monitored e.g. with:

```sh
rostopic echo /ts_scans
```

### Requesting an ADC Dump

For requesting an ADC Dump the ROS Node offers a service `"request_adc_dump"`.

A small node is provided to obtain the ADC Dump conveniently.
Please start it -while the main Echo Driver node is already running- via:

```shell
$ rosrun toposens_echo_driver request_adc_dump <sensor_id> <file_path>

# Example:
$ rosrun toposens_echo_driver request_adc_dump 1851 /home/user/dumps/dump.bin
```

If successful, the dump will be available under given file path.
In case of any potential problems please refer to the logging output of the main Echo Driver node.
