#ifndef TOPOSENS_ECHO_DRIVER_ADC_DUMP_H
#define TOPOSENS_ECHO_DRIVER_ADC_DUMP_H

#include <toposens/sensor_lib.h>

#include "toposens_echo_driver/RequestAdcDump.h"

namespace toposens_echo_driver
{
/**
 * @brief ROS Service Callback for ADC Dump Requests
 * @details Performs necessary steps to obtain ADC Dump from sensor. Utilizing the device driver
 * library.
 * @return true if successful, false otherwise
 */
// NOLINTNEXTLINE (google-runtime-references)
bool requestAdcDump(RequestAdcDump::Request& req, RequestAdcDump::Response& res);

/**
 * @brief Saves given @p adc_dump to file @p file_path
 * @details This was directly copied from an example application in the driver library. It should be
 * updated to our C++ coding guidelines, possibly when the TODO in the code is addressed.
 * @return true if successful, false otherwise
 */
auto saveAdcBlobData(ADCDump_t* adc_dump, const char* file_path) -> bool;

/**
 * @brief Callback for device driver library
 * @details Simply acknowledging
 */
void requestAdcDumpCallback(uint16_t sender_id, uint32_t data_size);

/**
 * @brief Callback for device driver library
 * @details Simply acknowledging
 */
void adcDumpEndCallback(uint16_t sender_id);

}  // namespace toposens_echo_driver

#endif  // TOPOSENS_ECHO_DRIVER_ADC_DUMP_H
