# Communication Protocol

[[_TOC_]]

## Introduction

This document describes the communication protocol.

## Interface Speeds

Currently the CAN bus is fixed to 1Mbps. It is planned to make the interface speed adjustable in the future.

## Node IDs & CAN Frame IDs & Broadcasting

- The CAN frames use a 11 bit ID.
- When a sensor on the bus sends a CAN frame, it will *always* use its *node ID* as the CAN frame ID.
- A sensor on the bus will only respond to messages which have the same frame ID as its node ID or have a frame ID of 0 (broadcast address). All other frame IDs will be ignored by the sensor.
- In order to determine which sensors are on the bus, the host/master device could send any command with the broadcast address and listen for what replies come back. For example the reboot command.
- By default each sensor's node ID is an xor'ed version of the bytes that make up its UID. It is highly unlikely that two or more sensors will have the same node ID.
- On the sensor side, all of the commands will work if the sensor is addressed using the broadcast address (host/master uses a CAN frame ID of 0). When the library is using the multi-cast ID and sends a get request such as "Get Bootloader Version" the API will block until all sensors on the bus reply but will only return the Bootloader version of the sensor that was first to respond.

## Timeouts

The sensor will periodically resend messages if they do not receive a reply within a certain time period. For example, when running the n_frames_single_shot_example, and the program is terminated mid-session, the sensor will periodically send an end of session request until it gets a reply.

## Asynchronous Messages

### Log Messages

The sensor will occasionally send asynchronous log messages to either report that an error has occurred to indicate that some other event has occurred. For example, when the sensor restarts, it will send a message indicating that it has done so.

Each message has a severity level (ERROR, WARN, INFO, DEBUG) and the sensor has a logging level which indicates which messages should be sent. For example, if the log level is set to WARN, then messages with a severity of INFO and DEBUG won't be sent.

These messages always have a control byte of 0xA0, 0xA1, 0xA2, or 0xA3.

### Ready Message

The sensor will occasionally send an asynchronous READY message. This message is to indicate that the sensor is not busy and is ready to record another frame.

After a reboot, it is best to wait for the sensor to send the ready message. When it has sent the message, the library can be sure that the sensor has initialized all software and hardware components.

These messages always have a control byte of 0x03.

### Sensor Sessions

The sensor will asynchronously attempt to start sessions for point output or ADC dump output. This is explained in more detail later.

### Versions

To retrieve the version of one of the components of the sensor send one of the following commands. Note that these values are just here for example and do not reflect the current versions of the various components.

|Name| Example Command|Example Reply|
|--|--|--|
|Get Bootloader version             |cansend can0 000#B000 | can0  736   [5]  B1 00 01 02 03 (Version 1.2.3) |
|Get App version                    |cansend can0 000#B001 | can0  736   [5]  B1 01 04 05 06 (Version 4.5.6) |
|Get HW version                     |cansend can0 000#B002 | can0  736   [5]  B1 02 07 08 09 (Version 7.8.9) |
|Get Signal Processing Lib version  |cansend can0 000#B003 | can0  736   [5]  B1 03 0A 0B 0C (Version 10.11.12) |
|Get Communication Lib version      |cansend can0 000#B004 | can0  736   [5]  B1 04 0D 0E 0F (Version 13.14.15) |

### Actions

|Name|Example Command|Example Reply|
|--|--|--|
|Reboot         | cansend can0 000#3000 | can0  736   [3]  31 00 00 (ACK)<br />(Sensor Reboots) <br /> can0  73B   [3]  A2 00 04 (Log message [Level = Warn, Category = Reset, Param = Reason]) <br /> can0  736   [1]  03 (Ready notification) |
|Measurement    | cansend can0 000#3001 | can0  736   [3]  31 01 00 (success)<br />can0  736   [3]  31 01 02 (Operation failed - mode cannot be SENSOR_MODE_SINGLE_SHOT_TRANSMIT, SENSOR_MODE_SINGLE_SHOT_LISTEN or SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN and state needs to be SENSOR_STATE_IDLE, otherwise the operation will fail)
|Factory reset  | cansend can0 000#3002 | can0  736   [3]  31 02 00 (success) |
|Store settings | cansend can0 000#3003 | can0  736   [3]  31 03 00 (success - note functionality has not yet been implemented - settings will remain the same) |
|Load settings  | cansend can0 000#3004 | can0  736   [3]  31 04 00 (success - note functionality has not yet been implemented - settings will remain the same) |
|ADC dump       | cansend can0 000#3005 | can0  736   [3]  31 05 00 (success) |

### Get Commands

#### ADC Get Commands

|Name|Example Command|Example Reply|
|--|--|--|
|Use fixed frame rate   | cansend can0 000#900000                                   | can0  736   [4]  91 00 00 00 (sensor doesn't use fixed frame rate) |
| Fixed frame rate      | cansend can0 000#900001                                   | can0  736   [4]  91 00 01 14 (20Hz) |

#### Transducer Get Commands

|Name|Example Command|Example Reply|
|--|--|--|
|Volume           | cansend can0 000#900100 | can0  736   [4]  91 01 00 64 (100% volume) |
|Number of pulses | cansend can0 000#900101 | can0  736   [4]  91 01 01 05 (5 pulses) |

#### Signal Processing Get Commands

|Name|Example Command|Example Reply|
|--|--|--|
| Temperature                 | cansend can0 000#900201 | can0  736   [7]  91 02 01 20 4E 00 00 (20000 -> 20.0 degrees celcius) |
| Relative humidity           | cansend can0 000#900202 | can0  736   [4]  91 02 02 32 (50 -> 50% relative humidity) |
|Noise level threshold factor | cansend can0 000#900203 | can0  425   [5]  91 02 03 E8 03 (1000 -> factor of 1.000) |
|Noise ratio threshold        | cansend can0 000#900204 | can0  425   [4]  91 02 04 32 (Threshold = 50%) |
|Enable near field detection  | cansend can0 000#900205 | can0  425   [4]  91 02 05 00 (0 = disabled, 1 = enabled)|
|Enable multipath filter      | cansend can0 000#900206 | can0  425   [4]  91 02 06 00 (0 = disabled, 1 = enabled)|
|Enable auto gain             | cansend can0 000#900207 | can0  425   [4]  91 02 07 00 (0 = disabled, 1 = enabled)|

#### System Get Commands

|Name|Example Command|Example Reply|
|--|--|--|
|Node ID          | cansend can0 000#900300                           | can0  736   [7]  91 03 00 36 07 00 00 (ID 0x736)|
|MCU temperature  | cansend can0 000#900301                           | can0  736   [7]  91 03 01 60 EA 00 00 (60000 -> 60.0 degrees celcius)|
|Log level        | cansend can0 000#900302                           | can0  736   [4]  91 03 02 02 (LOG_LEVEL_WARN) |
|Reset reason     | cansend can0 000#900303                           | can0  736   [4]  91 03 03 04 (RESET_REASON_SOFTWARE_RESET)|
|Sensor state     | cansend can0 000#900304                           | can0  736   [4]  91 03 04 00 (SENSOR_STATE_IDLE) |
|Sensor mode      | cansend can0 000#900305                           | can0  736   [4]  91 03 05 04 (SENSOR_MODE_IDLE) |
|Unique ID        | cansend can0 000#90030600 (Get word 0 of the UID) | can0  736   [8]  91 03 06 00 45 00 46 00 (UID word 0: 0x45 0x00 0x46 0x00) |
|                 | cansend can0 000#90030603 (Get word 3 of the UID) | can0  736   [4]  92 03 06 01 (NACK with "value out of range" status byte because UID is only 3 words (max index is 2))|
|Is calibrated| cansend can0 000#900307  | can0  425   [4]  91 03 07 01 (0 = not calibrated, 1 = is calibrated)|

### Set commands

#### ADC Set Commands

|Name|Example Command|Example Reply|
|--|--|--|
|Use fixed frame rate     | can0  000   [4]  60 00 00 00 (set to false)                 | can0  736   [4]  61 00 00 00 (success)|
|                         | cansend can0 000#60000006 (set to true)                     | can0  736   [4]  61 00 00 00 (success - true values are anything thats not 0) |
| Fixed frame rate        | cansend can0 000#60000110 (set frame rate to 16 fps)  | can0  736   [4]  61 00 01 00 (success) |
|                         | cansend can0 000#60000120 (set frame rate to 32 fps)  | can0  736   [4]  61 00 01 01 (NACK - out of range) |

#### Transducer Set Commands

|Name|Example Command|Example Reply|
|--|--|--|
|Volume           | cansend can0 000#60010010 (set volume to 16%)            | can0  736   [4]  61 01 00 00 (success) |
|                 | cansend can0 000#60010065 (set volume to 101%)          | can0  736   [4]  61 01 00 01 (NACK - out of range) |
|Number of pulses | cansend can0 000#60010103 (set number of pulses to 3)   | can0  736   [4]  61 01 01 00 (success) |
|                 | cansend can0 000#60010115 (set number of pulses to 21)  | can0  736   [4]  61 01 01 01 (NACK - out of range) |

#### Signal Processing Set Commands

|Name|Example Command|Example Reply|
|--|--|--|
| Temperature               | cansend can0 000#600201983A0000 (set temp to 15000 -> 15 degrees Celsius)    | can0  736   [4]  61 02 01 00 (success)
|                           |  cansend can0 000#600201905F0100 (set temp to 90000 -> 90 degrees Celsius)   | can0  736   [4]  61 02 01 01 (NACK - out of range) |
| Relative humidity         | cansend can0 000#60020246 (set relative humidity to 70)      | can0  736   [4]  61 02 02 00 (success)
|                           | cansend can0 000#60020265 (set relative humidity to 101)      | can0  736   [4]  61 02 02 01 (NACK - out of range) |
|Noise level threshold factor | cansend can0 000#6002032823 (set noise level threshold factor to 9000 -> 9.000) | can0  425   [4]  61 02 03 00 (success) |
|Noise ratio threshold        | cansend can0 000#6002040A (set noise ratio threshold to 10%) | can0  425   [4]  61 02 04 00 (success) |
|Enable near field detection  | cansend can0 000#60020501 (enable near field detection)| can0  425   [4]  61 02 05 00 (success) |
|Enable multipath filter      | cansend can0 000#60020601 (enable multipath filter) | can0  425   [4]  61 02 06 00 (success) |
|Enable auto gain             | cansend can0 000#60020701 (enable auto gain) | can0  425   [4]  61 02 07 00 (success)|

#### System Set Commands

|Name|Example Command|Example Reply|
|--|--|--|
|Node ID      | cansend can0 000#6003001101 (set node id to 0x111)                              | can0  736   [4]  61 03 00 00 (success - The message is ACK'ed with the original node ID and all messages afterwards will use the node id 0x111) |
|             | cansend can0 000#600300ffff (set node id to 0xffff (max is 0x7ff))              | can0  736   [4]  61 03 00 01 (NACK - out of range) |
|Log level    | cansend can0 000#60030200 (set log level to LOG_LEVEL_DEBUG)                    | can0  736   [4]  61 03 02 00 (success) |
|             | cansend can0 000#60030204 (set log level to enum 4)                             | can0  736   [4]  61 03 02 01 (NACK - out of range) |
|Sensor mode  | cansend can0 000#60030500 (set mode to SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN)  | can0  736   [4]  61 03 05 00 (success)
|             | cansend can0 000#60030505 (set mode to enum 5 (out of range)) | can0  736   [4]  61 03 05 01 (NACK - out of range) |

## Sessions

### Point Output Sessions

The sensor has differently operating modes, namely:

- SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN: In this mode, the sensor continuously records frames and outputs point data without being triggered by the host device. As this mode shall be continuously running the start/end of session does not need to be ACKed.
- SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN: In this mode the sensor records a single frame and outputs the points. After the points have been sent, the sensor enters an idle state.
- SENSOR_MODE_SINGLE_SHOT_TRANSMIT: In this mode the sensor sends an ultrasound pulse and does not output any points. The sensor enters an idle state.
- SENSOR_MODE_IDLE: The sensor does nothing.

There are different types of frames sent during a point session:

- Noise level frame: This frame is sent exactly once every point session.
- Near field frame: This frame is only sent at most 1 time in a point session. If it is sent, it means that there is an object in the near-field (< 20cm) of the sensor.
- 3D point frame: This is the standard point frame which contains 3D coordinates. There can be between 0-50 of these frames sent in a point session.
- 1D point frame: This is a point frame indicating that there is an object at certain distance but it cannot be localized. There can be between 0-50 of these frames sent in a point session.

By default, the sensor is in the SENSOR_MODE_IDLE mode. To get point data, the sensor mode needs to be changed to either SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN, or SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN mode.

The table below shows an example where the sensor is set to a single shot mode and the points are received.

|Host to Sensor|Sensor to Host|
|--|--|
| cansend can0 000#60030501 (switch to SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN mode) ||
| |can0  736   [4]  61 03 05 00 (ACK)|
| cansend can0 000#3001 (trigger measurement) ||
|| can0  736   [3]  31 01 00 (ACK)|
||(short delay while sensor records and processes the data)|
|| can0  736   [1]  03 (READY)|
|| can0  736   [3]  10 00 0C (Request to start point session)|
| cansend can0 000#0110000c (ACK) ||
|| can0  736   [3]  13 55 55 (Noise level frame)|
|| can0  736   [1]  12 (Near field point) |
|| can0  736   [4]  14 1B 00 00 (1D point) |
|| can0  736   [8]  11 E0 FF 20 00 20 00 0A (3D point)|
|| can0  736   [8]  11 D0 FF 30 00 30 00 14 (3D point)|
|| can0  736   [8]  11 C0 FF 40 00 40 00 1E (3D point)|
|| can0  736   [4]  14 8A 00 28 (1D point) |
|| can0  736   [8]  11 A0 FF 60 00 60 00 32 (3D point)|
|| can0  736   [8]  11 90 FF 70 00 70 00 3C (3D point)|
|| can0  736   [8]  11 80 FF 80 00 80 00 46 (3D point)|
|| can0  736   [4]  14 F9 00 50 (1D point) |
|| can0  736   [8]  11 60 FF A0 00 A0 00 5A (3D point)|
|| can0  736   [1]  00 (EOS request) |
|cansend can0 000#0100 (ACK) ||

If a continuous mode is set, the sensor does not need to be triggered and the start and end of sessions do not need to be acknowledged. In this mode, the start and end of session markers are just used to separate the points into different frames. The snippet below shows an example of how this works:

```none
can0  000   [4]  60 03 05 00 (Set mode to SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN)
can0  736   [4]  61 03 05 00 (ACK - Sensor automatically starts recording frames)
can0  736   [1]  03 (READY - Sensor has finished recording & processing a frame)
can0  736   [3]  10 00 0C (Start of session - doesn't need to be ACKed)
can0  736   [3]  13 55 55
can0  736   [1]  12
can0  736   [4]  14 1B 00 00
can0  736   [8]  11 E0 FF 20 00 20 00 0A
can0  736   [8]  11 D0 FF 30 00 30 00 14
can0  736   [8]  11 C0 FF 40 00 40 00 1E
can0  736   [4]  14 8A 00 28
can0  736   [8]  11 A0 FF 60 00 60 00 32
can0  736   [8]  11 90 FF 70 00 70 00 3C
can0  736   [8]  11 80 FF 80 00 80 00 46
can0  736   [4]  14 F9 00 50
can0  736   [8]  11 60 FF A0 00 A0 00 5A
can0  736   [1]  00 (End of session - doesn't need to be ACKed)
can0  736   [1]  03 (READY - Sensor has finished recording & processing a frame)
can0  736   [3]  10 00 0C (Start of session - doesn't need to be ACKed)
can0  736   [3]  13 55 55
can0  736   [1]  12
can0  736   [4]  14 1B 00 00
can0  736   [8]  11 E0 FF 20 00 20 00 0A
can0  736   [8]  11 D0 FF 30 00 30 00 14
can0  736   [8]  11 C0 FF 40 00 40 00 1E
can0  736   [4]  14 8A 00 28
can0  736   [8]  11 A0 FF 60 00 60 00 32
can0  736   [8]  11 90 FF 70 00 70 00 3C
can0  736   [8]  11 80 FF 80 00 80 00 46
can0  736   [4]  14 F9 00 50
can0  736   [8]  11 60 FF A0 00 A0 00 5A
can0  736   [1]  00 (End of session - doesn't need to be ACKed)
can0  736   [1]  03 (READY - Sensor has finished recording & processing a frame)
can0  736   [3]  10 00 0C (Start of session - doesn't need to be ACKed)
can0  736   [3]  13 55 55
can0  736   [1]  12
can0  736   [4]  14 1B 00 00
can0  736   [8]  11 E0 FF 20 00 20 00 0A
can0  736   [8]  11 D0 FF 30 00 30 00 14
can0  736   [8]  11 C0 FF 40 00 40 00 1E
can0  736   [4]  14 8A 00 28
can0  736   [8]  11 A0 FF 60 00 60 00 32
can0  736   [8]  11 90 FF 70 00 70 00 3C
can0  736   [8]  11 80 FF 80 00 80 00 46
can0  736   [4]  14 F9 00 50
can0  736   [8]  11 60 FF A0 00 A0 00 5A
can0  736   [1]  00 (End of session - doesn't need to be ACKed)
can0  000   [4]  60 03 05 01 (Set mode to SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN)
can0  736   [4]  61 03 05 00 (ACK)
(does nothing until triggered since now in idle state and no longer in continuous mode)
```

The snippet below shows a second example of the above continuous mode behavior, however, here the command to switch the sensor back to a single shot mode was sent while the sensor was in the middle of a point session while in continuous mode. In this case, the last few points and the EOS message are sent and then the switch mode command is processed and acknowledged.

```none
... same as above
can0  736   [1]  00
can0  736   [1]  03
can0  736   [3]  10 00 0C
can0  736   [3]  13 55 55
can0  736   [1]  12
can0  736   [4]  14 1B 00 00
can0  736   [8]  11 E0 FF 20 00 20 00 0A
can0  736   [8]  11 D0 FF 30 00 30 00 14
can0  736   [8]  11 C0 FF 40 00 40 00 1E
can0  736   [4]  14 8A 00 28
can0  736   [8]  11 A0 FF 60 00 60 00 32
can0  736   [8]  11 90 FF 70 00 70 00 3C
can0  000   [4]  60 03 05 01                 (Set mode to SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN)
can0  736   [8]  11 80 FF 80 00 80 00 46
can0  736   [4]  14 F9 00 50
can0  736   [8]  11 60 FF A0 00 A0 00 5A
can0  736   [1]  00
can0  736   [4]  61 03 05 00                 (ACK)
```

### ADC Dump Session

The purpose of this session is to transfer the ADC signals recorded by the sensor to a host device. This transfer will likely be ~577KB of data.

This session can either happen if:

  1. The sensor crashes. The idea here is that the frame that the caused the problem should be output so that the source of the crash can be investigated.
  1. The host/master sends an action command which has the appropriate subcontrol byte.

In both cases, the sensor will try to start the session by sending the start ADC dump session and the host should acknowledge. The sensor will then send the ADC bytes as a large blob.

After an ADC dump is triggered nothing will happen until the sensor has outputted the points from the next frame that is recorded after the trigger signal has been received. An example of this can be seen below.

|Host to Sensor|Sensor to Host|
|--|--|
|cansend can0 000#3005 (Request ADC dump for the next frame) | |
|| can0  736   [3]  31 05 00 (ACK) |
| cansend can0 000#60030501 (switch to SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN mode) ||
| |can0  736   [4]  61 03 05 00 (ACK)|
| cansend can0 000#3001 (trigger measurement) ||
|| can0  736   [3]  31 01 00 (ACK)|
||(short delay while sensor records and processes the data)|
|| can0  736   [1]  03 (READY)|
|| can0  736   [3]  10 00 0C (Request to start point session)|
| cansend can0 000#0110000c (ACK) ||
||(sensor sends points same as above)|
||can0 736 [1] 00 (EOS request)|
|cansend can0 000#0100 (ACK)||
||can0  736   [6]  20 00 88 13 00 00 (Request to start ADC dump session)|
|cansend can0 000#01200088130000 (ACK) ||
||  ...|
||can0  736   [8]  21 7F 7F 13 80 EC 01 00
||can0  736   [8]  21 80 80 13 7F EC 00 00
||can0  736   [8]  21 81 81 13 7E EC 01 00
||can0  736   [8]  21 82 82 13 7D EC 00 00
||can0  736   [8]  21 83 83 13 7C EC 01 00
||can0  736   [8]  21 84 84 13 7B EC 00 00
||can0  736   [8]  21 85 85 13 7A EC 01 00
||can0  736   [8]  21 86 86 13 79 EC 00 00
||can0  736   [8]  21 87 87 13 78 EC 01 00
||can0 736 [1] 00 (EOS request)|
|cansend can0 000#0100 (ACK)||
