# Toposens Sensor Library

[[_TOC_]]

## Introduction

The purpose of this README is to document how to use the library and the provided examples.

## Setting up the Sensor & CAN Interface

- Connect the D-Sub-15 cable from the sensor to the power/data D-Sub-15 cable.
- Connect the D-Sub-9 to the peak CAN adapter and the peak CAN adapter USB to the host device.
- Install the required kernel modules:

  ```none
  sudo modprobe peak_usb
  sudo modprobe peak_pci
  sudo apt-get update
  sudo apt-get install can-utils
  ```

- Then either every time the sensor is connected run the following command or set up an automatic way to configure the interface as described below:

```none
sudo ip link set can0 up type can bitrate 1000000
```

### Automatic Setup with /etc/network/interfaces

In the */etc/network/interfaces* file, add the following:

```none
allow-hotplug can0
iface can0 can static
     bitrate 1000000
     up ip link set $IFACE txqueuelen 100
```

### Automatic Setup with systemd

If you are on Ubuntu 20.04 you can use *systemd* since */etc/network/interfaces* is deprecated.
Navigate to `/etc/systemd/network/` and create a file `80-can.network` with the following content:

```none
[Match]
Name=can*

[CAN]
BitRate=1000000
```

Then run the following commands to enable the automatic configuration via systemd:

```none
sudo systemctl enable systemd-networkd
sudo systemctl start systemd-networkd
```

## Compiling and Installing the Sensor Library and example applications

Clone the toposens-libraries with the following command

```none
git clone --recurse-submodules https://gitlab.com/toposens/public/toposens-libraries.git

```
With the ``` --recurse-submodules ``` command, you will clone all other necessary dependencies([nanopb](https://gitlab.com/toposens/public/nanopb), [iso-tp](https://gitlab.com/toposens/public/iso-tp) and [core-libraries](https://gitlab.com/toposens/public/core-libraries)) to build the toposens-library.

When this step is done and all your  submodules are initialized and updated. You can run the build script to build the toposens-library.

There are different arguments you can call the ``` build.sh ``` script with:

* Build the target 

`./build.sh build`

* Build targets

`./build.sh all`

* Build debian packet

`./build.sh deb`

* Additionally you can clean the build folder and artifacts

`./build.sh clean`

### Test the Interface
For this section you need to build and install the library as a debian package. Use the following command to build the debian package.

`./build.sh deb`

You can find the build artifact in the artifact/ folder.

Switch to the artifact/ folder and install the debian package with the following commands:

```
cd artifacts
sudo apt install -y ./*.deb
```


- To test if the sensor interface works:

```python3
>>> import toposens
>>> toposens.init_can()
(0, 'TOPO_OK')
>>> toposens.print_sensor_config()
Sensor Node ID 0256 (0x100)
Sensor is in mode 0
```
Your sensor node id will appear different than the example.

If you receive a similar response from the sensor, your CAN connection is working.


## Running the Examples

After compiling the library, go to the folder `build/examples`. Run the example of choice.

```none
cd cmake_output_dir/toposens-library/examples
./n_frames_single_shot_example -n 100
```
