#!/bin/bash

OUTPUT_DIR="cmake_output_dir/"
ARTIFACT_DIR="artifacts/"

function clean()
{
	rm -rf ${OUTPUT_DIR}
	rm -rf ${ARTIFACT_DIR}
}


function build()
{
	cmake . -B ${OUTPUT_DIR}

	(
		cd ${OUTPUT_DIR};
		make
	)
}

function deb()
{

	(
		cd ${OUTPUT_DIR};
		cpack -G DEB
	)
}

case "${1:-}" in
	"all")
		build
		deb
		;;

	"build")
		build
		;;

	"clean")
		clean
		;;

	"deb")
		build
		deb
		;;

	*)
		;;
esac
