/*
*   Copyright (c) Toposens GmbH 2021. All rights reserved.
*/

/** **************************************************************************************
 * @file       toposens/errors.h
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 * @brief      This file contains the error codes used in the Toposens library.
 ******************************************************************************************/


#ifndef TOPO_ERRORS_H
#define TOPO_ERRORS_H

/** */
typedef enum TopoError_t
{
  /**> Flash access (read or write). */
  TOPO_ERROR_FLASH = -13,				      
  /**> Data (i.e. an array) could not be applied. */
  TOPO_ERROR_DATA_REJECTED = -12, 		
  /**> Function parameter was invalid (i.e. NULL pointer). */
  TOPO_ERROR_INVALID_PARAMETER = -11,	
  TOPO_ERROR_NODATA = -10,
  TOPO_ERROR_TRYAGAIN = -9,
  TOPO_ERROR_BUSY = -8,
  TOPO_ERROR_TIMEOUT = -7,
  TOPO_ERROR_MAX_SENSORS_REACHED = -6,
  TOPO_ERROR_ALREADY_CONNECTED = -5,
  TOPO_ERROR_ALREADY_INITIALIZED = -4,
  TOPO_ERROR_UNKNOWN_INTERFACE = -3,
  TOPO_ERROR_UNSUPPORTED_INTERFACE = -2,
  TOPO_ERROR_GENERIC = -1,
  TOPO_OK = 0
}
TopoError_t;

#ifndef TOPO_DOXYGEN_SKIP
#define ERR_STR(X) \
  case X:          \
    return #X;
#endif


 /*! @brief Returns a string representation of the given error code */
char* getErrorString(TopoError_t err);

#endif  // TOPO_ERRORS_H
