/** **************************************************************************************
 * @file       custom_structs.h
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 ******************************************************************************************/

#ifndef TOPOSENS_CUSTOM_STRUCTS_H
#define TOPOSENS_CUSTOM_STRUCTS_H

#include <stdint.h>

typedef struct Version_t
{
    uint8_t major;
    uint8_t minor;
    uint8_t hotfix;
} Version_t;

#define VERSION_STRUCT_TO_UINT32(version) ((((version.major << 8U) + version.minor) << 8U) + version.hotfix)
#define VERSION_UINT8_TO_UINT32(major, minor, hotfix) ((((major << 8U) + minor) << 8U) + hotfix)

#endif  // TOPOSENS_CUSTOM_STRUCTS_H
