#ifndef TOPOSENS_CUSTOM_TYPES_INTERNAL_H
#define TOPOSENS_CUSTOM_TYPES_INTERNAL_H

typedef enum StepGainFactor_t
{
    STEPGAIN_FACTOR_0_25,
    STEPGAIN_FACTOR_1,
    STEPGAIN_FACTOR_10,
    STEPGAIN_FACTOR_20,
    STEPGAIN_FACTOR_30,
    STEPGAIN_FACTOR_40,
    STEPGAIN_FACTOR_60,
    STEPGAIN_FACTOR_80,
    STEPGAIN_FACTOR_119,
    STEPGAIN_FACTOR_157,
    STEPGAIN_FACTOR_LAST_ENTRY
} StepGainFactor_t;

typedef enum ADCResolution_t
{
    ADC_RESOLUTION_8BIT,
    ADC_RESOLUTION_10BIT,
    ADC_RESOLUTION_12BIT,
    ADC_RESOLUTION_14BIT,
    ADC_RESOLUTION_16BIT,
    ADC_RESOLUTION_LAST_ENTRY
} ADCResolution_t;

typedef enum ADCSampleTime_t
{
    ADC_SAMPLETIME_1C5,
    ADC_SAMPLETIME_2C5,
    ADC_SAMPLETIME_8C5,
    ADC_SAMPLETIME_16C5,
    ADC_SAMPLETIME_32C5,
    ADC_SAMPLETIME_64C5,
    ADC_SAMPLETIME_387C5,
    ADC_SAMPLETIME_810C5,
    ADC_SAMPLETIME_LAST_ENTRY
} ADCSampleTime_t;

typedef enum ADCSampleRate_t
{
    ADC_SAMPLERATE_2M0SPS,
    ADC_SAMPLERATE_2M5SPS,
    ADC_SAMPLERATE_3M0SPS,
    ADC_SAMPLERATE_4M0SPS,
    ADC_SAMPLERATE_200kSPS,
    ADC_SAMPLERATE_LAST_ENTRY
} ADCSampleRate_t;

typedef enum SecretType_t
{
    SECRET_TYPE_ENCRYPTION_KEY,
    SECRET_TYPE_SIGNING_KEY,
    SECRET_TYPE_IV
} SecretType_t;

static const float StepGainFactorValues[STEPGAIN_FACTOR_LAST_ENTRY] = 
    {0.25F, 1.0F, 10.0F, 20.0F, 30.0F, 40.0F, 60.0F, 80.0F, 119.0F, 157.0F};

static const uint32_t ADCSampleRateValues[ADC_SAMPLERATE_LAST_ENTRY] = {
		2000000,
		2500000,
		3000000,
		4000000,
		200000,
};

static const uint8_t ADCResolutionValues[ADC_RESOLUTION_LAST_ENTRY] = {8, 10, 12, 14, 16};

#endif  // TOPOSENS_CUSTOM_TYPES_INTERNAL_H
