/** @file     sensor_manager.h
 *  @author   Sebastian Dengler
 *  @date     April 2019
 */

#ifndef SENSOR_MANAGER_H
#define SENSOR_MANAGER_H

#include <dynamic_reconfigure/server.h>
#include <ros/ros.h>
#include <ros/xmlrpc_manager.h>

#include <toposens_driver/sensor.h>

namespace toposens_sync
{
/** @brief Manages a system of multiple TS sensors.
 *  @details Instantiates a set of TS sensors. Tells the sensors to scan in an
 *  alternating mode.
 */
class SensorManager
{
public:
  /** Instantiates a set of Sensor objects according to the launch parameters.
   * @details According to the launch parameters, a set of Sensor objects is
   * instantiated.  A dynamic reconfigure server is set up to change the sync
   * mode during runtime.
   * @param nh Public nodehandle for pub-sub ops on ROS topics.
   * @param private_nh Private nodehandle for accessing launch parameters.
   */
  SensorManager(ros::NodeHandle nh, ros::NodeHandle private_nh);
  ~SensorManager() { this->shutdown(); }

  /** Triggers all available sensors and polls the received frames from them in
   * an alternating mode.
   * @details Triggers all available sensors and polls the received frames from
   * them in an alternating mode.
   *  @todo enable additional synchronisation modes when real time communication
   * is available
   */
  void trigger(void);

  /** Shuts down serial connections to all sensors. */
  void shutdown(void);

private:
  toposens_driver::Sensor *_sensors[10]; /**< Array of pointers to sensors (a maximum number of 10
                                            sensors can be used).*/
  int _num_sensors;                      /**< Number of sensors that are used.*/
};

}  // namespace toposens_sync

#endif
