//
// Copyright (c) 2018 CNRS
//
// This file is part of tsid
// tsid is free software: you can redistribute it
// and/or modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation, either version
// 3 of the License, or (at your option) any later version.
// tsid is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Lesser Public License for more details. You should have
// received a copy of the GNU Lesser General Public License along with
// tsid If not, see
// <http://www.gnu.org/licenses/>.
//

#ifndef __tsid_python_HQPOutput_hpp__
#define __tsid_python_HQPOutput_hpp__

#include "tsid/bindings/python/fwd.hpp"

#include "tsid/solvers/solver-HQP-output.hpp"

namespace tsid
{
  namespace python
  {    
    namespace bp = boost::python;
    
    template<typename T>
    struct HQPOutputPythonVisitor
    : public boost::python::def_visitor< HQPOutputPythonVisitor<T> >
    {
      template<class PyClass>     

      void visit(PyClass& cl) const
      {
        cl
        .def(bp::init<>("Defulat Constructor"))
        .def(bp::init<int, int, int>((bp::args("nVars", "nEq", "nInCon"))))
        .add_property("x", &HQPOutputPythonVisitor::x)
        .add_property("status", &HQPOutputPythonVisitor::status)
        ;
      }
      static Eigen::VectorXd x (const T & self) {return self.x;}
      static int status (const T & self) {return self.status;}
      static void expose(const std::string & class_name)
      {
        std::string doc = "HQPOutput info.";
        bp::class_<T>(class_name.c_str(),
                          doc.c_str(),
                          bp::no_init)
        .def(HQPOutputPythonVisitor<T>());       
      }
    };
  }
}


#endif // ifndef __tsid_python_HQPOutput_hpp__
