#ifndef URG_CONNECTION_H
#define URG_CONNECTION_H

/*!
  \file
  \brief ʐM̏

  \author Satofumi KAMIMURA

  $Id: urg_connection.h,v 1d233c7a2240 2011/02/19 03:08:45 Satofumi $
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "urg_c/urg_serial.h"
#include "urg_c/urg_tcpclient.h"


/*!
  \brief 萔`
*/
enum {
    URG_CONNECTION_TIMEOUT = -1, //!< ^CAEgƂ̖߂l
};


/*!
  \brief ʐM^Cv
*/
typedef enum {
    URG_SERIAL,                 //!< VA, USB ڑ
    URG_ETHERNET,               //!< C[T[lbgڑ
} urg_connection_type_t;


/*!
  \brief ʐM\[X
*/
typedef struct
{
    urg_connection_type_t type; //!< ڑ^Cv
    urg_serial_t serial;        //!< VAڑ
    urg_tcpclient_t tcpclient;  //!< C[T[lbgڑ
} urg_connection_t;


/*!
  \brief ڑ

  w肳ꂽfoCXɐڑB

  \param[in,out] connection ʐM\[X
  \param[in] connection_type ڑ^Cv
  \param[in] device ڑ
  \param[in] baudrate_or_port {[[g / |[gԍ

  \retval 0 
  \retval <0 G[

  connection_type ɂ

  - URG_SERIAL ... VAʐM
  - URG_ETHERNET .. C[T[lbgʐM

  w肷B

  device, baudrate_or_port ̎w connection_type ɂwłlقȂB
  Ⴆ΁AVAʐM̏ꍇ͈ȉ̂悤ɂȂB

  Example
  \code
  connection_t connection;
  if (! connection_open(&connection, URG_SERIAL, "COM1", 115200)) {
      return 1;
  } \endcode

  ܂AC[T[lbgʐM̏ꍇ͈ȉ̂悤ɂȂB

  Example
  \code
  connection_t connection;
  if (! connection_open(&connection, URG_ETHERNET, "192.168.0.10", 10940)) {
      return 1;
  } \endcode

  \see connection_close()
*/
extern int connection_open(urg_connection_t *connection,
                           urg_connection_type_t connection_type,
                           const char *device, long baudrate_or_port);


/*!
  \brief ؒf

  foCXƂ̐ڑؒfB

  \param[in,out] connection ʐM\[X

  \code
  connection_close(&connection); \endcode

  \see connection_open()
*/
extern void connection_close(urg_connection_t *connection);


/*! {[[gݒ肷 */
extern int connection_set_baudrate(urg_connection_t *connection, long baudrate);


/*!
  \brief M

  f[^𑗐MB

  \param[in,out] connection ʐM\[X
  \param[in] data Mf[^
  \param[in] size MoCg

  \retval >=0 Mf[^
  \retval <0 G[

  Example
  \code
  n = connection_write(&connection, "QT\n", 3); \endcode

  \see connection_read(), connection_readline()
*/
extern int connection_write(urg_connection_t *connection,
                            const char *data, int size);


/*!
  \brief M

  f[^MB

  \param[in,out] connection ʐM\[X
  \param[in] data Mf[^i[obt@
  \param[in] max_size Mf[^i[łoCg
  \param[in] timeout ^CAEg [msec]

  \retval >=0 Mf[^
  \retval <0 G[

  timeout ɕ̒lw肵ꍇA^CAEg͔ȂB

  1 MȂƂ #URG_CONNECTION_TIMEOUT ԂB

  Example
  \code
enum {
    BUFFER_SIZE = 256,
    TIMEOUT_MSEC = 1000,
};
char buffer[BUFFER_SIZE];
n = connection_read(&connection, buffer, BUFFER_SIZE, TIMEOUT_MSEC); \endcode

  \see connection_write(), connection_readline()
*/
extern int connection_read(urg_connection_t *connection,
                           char *data, int max_size, int timeout);


/*!
  \brief s܂ł̎M

  s܂ł̃f[^MB

  \param[in,out] connection ʐM\[X
  \param[in] data Mf[^i[obt@
  \param[in] max_size Mf[^i[łoCg
  \param[in] timeout ^CAEg [msec]

  \retval >=0 Mf[^
  \retval <0 G[

  data ɂ́A'\\0' I[ꂽ max_size zȂoCgi[B ܂AMł镶̃oCǵAő max_size - 1 ƂȂB

  s '\\r' ܂ '\\n' ƂB

  Mŏ̕s̏ꍇ́A0 ԂA1 MȂƂ #URG_CONNECTION_TIMEOUT ԂB

  \see connection_write(), connection_read()
*/
extern int connection_readline(urg_connection_t *connection,
                               char *data, int max_size, int timeout);

#ifdef __cplusplus
}
#endif

#endif /* !URG_CONNECTION_H */
