#include <boost/bind.hpp>
#include <boost/make_shared.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/thread.hpp>

#include <nodelet/nodelet.h>
#include <pluginlib/class_list_macros.h>

#include "tracker-viewer.hh"

namespace visp_tracker
{
  class TrackerViewerNodelet : public nodelet::Nodelet
  {
  public:
    TrackerViewerNodelet ()
      : nodelet::Nodelet (),
        exiting_ (false),
        trackerViewer_ (),
        thread_ ()
    {}

    ~TrackerViewerNodelet ()
    {
      exiting_ = true;
      if (thread_)
        if (!thread_->timed_join (boost::posix_time::seconds (2)))
          NODELET_WARN ("failed to join thread but continuing anyway");
      thread_.reset ();
      trackerViewer_.reset ();
    }

    void spin ()
    {
      trackerViewer_ = boost::shared_ptr<visp_tracker::TrackerViewer>
          (new visp_tracker::TrackerViewer
           (getMTNodeHandle (),
            getMTPrivateNodeHandle (),
            exiting_, 5u));
      while (ros::ok () && !exiting_)
        trackerViewer_->spin ();
    }

    virtual void onInit ()
    {
      NODELET_DEBUG ("Initializing nodelet...");
      exiting_ = false;
      thread_ = boost::make_shared<boost::thread>
          (boost::bind (&TrackerViewerNodelet::spin, this));
    }
  private:
    volatile bool exiting_;
    boost::shared_ptr<visp_tracker::TrackerViewer> trackerViewer_;
    boost::shared_ptr<boost::thread> thread_;
  };

} // end of namespace visp_tracker.

PLUGINLIB_EXPORT_CLASS(visp_tracker::TrackerViewerNodelet, nodelet::Nodelet);
