/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of PySide2.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef DEBUGFREEHOOK_H
#define DEBUGFREEHOOK_H

// These functions enable C library runtime hooks to try to catch cases where
// C++ object addresses remain in hash table of valid wrappers when the address
// is passed to free.  The hooks are probably not thread safe and thus
// should only be enabled in single threaded environments

// To enable the hook, uncomment the following define.
//#define SHIBOKEN_INSTALL_FREE_DEBUG_HOOK

#ifdef SHIBOKEN_INSTALL_FREE_DEBUG_HOOK
extern "C" {

void debugInstallFreeHook(void);
void debugRemoveFreeHook(void);

} // extern "C"

#endif // SHIBOKEN_INSTALL_FREE_DEBUG_HOOK

#endif // DEBUGFREEHOOK_H
