# python insertnamespace.py -d dom/include/1.5/dom -n ColladaDOM150
import os
from optparse import OptionParser

if __name__ == "__main__":
    parser = OptionParser()
    usage = "usage: %prog [options] <arg>"
    parser = OptionParser(description='adds namespace to header files',usage=usage)
    parser.add_option("-d", dest="destdir", default=None, help='destination directory')
    parser.add_option("-n", dest="namespace", default=None, help='namespace name')
    parser.add_option("--start", dest="startstr", default='class DAE;\n', help='start string')
    parser.add_option("--insertafter", dest="insertafter", action='store_true', default=False, help='insert after')
    (options, args) = parser.parse_args()

    namespacestart = '\nnamespace %s {\n'%options.namespace
    namespaceend = '} // %s\n'%options.namespace
    for filename in os.listdir(options.destdir):
        fullfilename = os.path.join(options.destdir,filename)
        if os.path.isfile(fullfilename):
            data = open(fullfilename,'r').read()
            namespaceindex = data.find(namespacestart)
            if namespaceindex < 0:
                head,sep,tail = data.partition(options.startstr)
                if len(tail) == 0:
                    print 'failed to find %s in %s'%(options.startstr,fullfilename)
                else:
                    endindex = tail.rfind('#endif')
                    if endindex < 0:
                        endindex = len(tail)
                    newdata = head
                    if options.insertafter:
                        newdata += sep
                    newdata += namespacestart
                    if not options.insertafter:
                        newdata += sep
                    newdata += tail[:endindex] + namespaceend + tail[endindex:]
                    open(fullfilename,'w').write(newdata)
                    
def test():
    class options:
        destdir='dom/include/1.5/dom' 
        namespace = 'ColladaDOM150' 
        startstr = 'class DAE;\n'
        insertafter = False
