@echo off

set MAJOR_VERSION=1
set MINOR_VERSION=3
set MAINTENANCE_VERSION=2
set BUILD_VERSION=1

@echo ************************
@echo *** ONI Redist Maker ***
@echo ************************
echo Going to build redist for version: %MAJOR_VERSION%.%MINOR_VERSION%.%MAINTENANCE_VERSION%.%BUILD_VERSION%!
@echo.

@echo ******************************************
@echo *** Erasing the old Final directory... ***
@echo ******************************************
rmdir /S /q Final
rmdir /S /q Output
mkdir Final
mkdir Output

@echo.
@echo *******************************************
@echo *** Running the Redist OpenNI script... ***
@echo *******************************************
IF "%1"=="" GOTO RedistNoParam
Redist_OpenNi.py %1 %2 %3 %4
goto FinishRedist
:RedistNoParam
Redist_OpenNi.py y 32 y
if not "%ERRORLEVEL%" == "0" goto ErrorScript
:FinishRedist

@echo.
@echo *************************************************
@echo *** Copying files into the Final directory... ***
@echo *************************************************
@echo.

Echo Moving the setup OPENNI-Win*-x.x.x file...
echo f | move Output\OPENNI-Win*-*.msi Final
if "%ERRORLEVEL%" == "1" goto ErrorCopy

Echo Copying the release notes...
copy  ..\..\..\Platform\Win32\Build\ReleaseNotes.txt Final

Echo Copying the unpacked files...
xcopy /E /I ..\Redist\Bin Final\Files\Bin
xcopy /E /I ..\Redist\Bin64 Final\Files\Bin64
xcopy /E /I ..\Redist\Driver Final\Files\Driver
xcopy /E /I ..\Redist\Documentation Final\Files\Documentation
xcopy /E /I ..\Redist\Include Final\Files\Include
xcopy /E /I ..\Redist\Lib Final\Files\Lib
xcopy /E /I ..\Redist\Lib64 Final\Files\Lib64

Echo Copying the debug driver...
xcopy /E /I ..\Driver\BinVSDbg Final\DebugDriver

Echo Copying PDBs...
xcopy /I ..\Bin\Release\*.pdb Final\PDBs\32
xcopy /I ..\Bin64\Release\*.pdb Final\PDBs\64
xcopy /E /I ..\Driver\PDBs\*.pdb Final\PDBs\DRV

Echo Creating the build info...
@echo This build (V%MAJOR_VERSION%.%MINOR_VERSION%.%MAINTENANCE_VERSION%.%BUILD_VERSION%) was auto-generated by RedistMaker on %COMPUTERNAME%\%USERNAME% at %DATE% %TIME% > Final\Buildinfo.txt

@echo.
@echo ***********************************************
@echo *** Finished creating the Final directory! ***
@echo ***********************************************

goto END

:ErrorCopy
@echo.
@echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
@echo !!! An error occured while copying a file !!!
@echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

exit /b 1
goto END

:ErrorScript
@echo.
@echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
@echo !!! An error occured while running a script !!!
@echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

exit /b 1
goto END

:END
@echo ********************************
@echo *** Exiting ONI Redist Maker ***
@echo ********************************